# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AppProfileDataBoostIsolationReadOnly',
    'AppProfileSingleClusterRouting',
    'AppProfileStandardIsolation',
    'AuthorizedViewSubsetView',
    'AuthorizedViewSubsetViewFamilySubset',
    'GCPolicyMaxAge',
    'GCPolicyMaxVersion',
    'InstanceCluster',
    'InstanceClusterAutoscalingConfig',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'TableAutomatedBackupPolicy',
    'TableColumnFamily',
    'TableIamBindingCondition',
    'TableIamMemberCondition',
]

@pulumi.output_type
class AppProfileDataBoostIsolationReadOnly(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "computeBillingOwner":
            suggest = "compute_billing_owner"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileDataBoostIsolationReadOnly. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileDataBoostIsolationReadOnly.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compute_billing_owner: builtins.str):
        """
        :param builtins.str compute_billing_owner: The Compute Billing Owner for this Data Boost App Profile.
               Possible values are: `HOST_PAYS`.
        """
        pulumi.set(__self__, "compute_billing_owner", compute_billing_owner)

    @property
    @pulumi.getter(name="computeBillingOwner")
    def compute_billing_owner(self) -> builtins.str:
        """
        The Compute Billing Owner for this Data Boost App Profile.
        Possible values are: `HOST_PAYS`.
        """
        return pulumi.get(self, "compute_billing_owner")


@pulumi.output_type
class AppProfileSingleClusterRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "allowTransactionalWrites":
            suggest = "allow_transactional_writes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppProfileSingleClusterRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppProfileSingleClusterRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 allow_transactional_writes: Optional[builtins.bool] = None):
        """
        :param builtins.str cluster_id: The cluster to which read/write requests should be routed.
        :param builtins.bool allow_transactional_writes: If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
               It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if allow_transactional_writes is not None:
            pulumi.set(__self__, "allow_transactional_writes", allow_transactional_writes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The cluster to which read/write requests should be routed.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="allowTransactionalWrites")
    def allow_transactional_writes(self) -> Optional[builtins.bool]:
        """
        If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
        It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return pulumi.get(self, "allow_transactional_writes")


@pulumi.output_type
class AppProfileStandardIsolation(dict):
    def __init__(__self__, *,
                 priority: builtins.str):
        """
        :param builtins.str priority: The priority of requests sent using this app profile.
               Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def priority(self) -> builtins.str:
        """
        The priority of requests sent using this app profile.
        Possible values are: `PRIORITY_LOW`, `PRIORITY_MEDIUM`, `PRIORITY_HIGH`.
        """
        return pulumi.get(self, "priority")


@pulumi.output_type
class AuthorizedViewSubsetView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familySubsets":
            suggest = "family_subsets"
        elif key == "rowPrefixes":
            suggest = "row_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizedViewSubsetView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizedViewSubsetView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizedViewSubsetView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_subsets: Optional[Sequence['outputs.AuthorizedViewSubsetViewFamilySubset']] = None,
                 row_prefixes: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence['AuthorizedViewSubsetViewFamilySubsetArgs'] family_subsets: A group of column family subsets to be included in the authorized view. This can be specified multiple times. Structure is documented below.
               
               -----
        :param Sequence[builtins.str] row_prefixes: A list of Base64-encoded row prefixes to be included in the authorized view. To provide access to all rows, include the empty string as a prefix ("").
        """
        if family_subsets is not None:
            pulumi.set(__self__, "family_subsets", family_subsets)
        if row_prefixes is not None:
            pulumi.set(__self__, "row_prefixes", row_prefixes)

    @property
    @pulumi.getter(name="familySubsets")
    def family_subsets(self) -> Optional[Sequence['outputs.AuthorizedViewSubsetViewFamilySubset']]:
        """
        A group of column family subsets to be included in the authorized view. This can be specified multiple times. Structure is documented below.

        -----
        """
        return pulumi.get(self, "family_subsets")

    @property
    @pulumi.getter(name="rowPrefixes")
    def row_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Base64-encoded row prefixes to be included in the authorized view. To provide access to all rows, include the empty string as a prefix ("").
        """
        return pulumi.get(self, "row_prefixes")


@pulumi.output_type
class AuthorizedViewSubsetViewFamilySubset(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "familyName":
            suggest = "family_name"
        elif key == "qualifierPrefixes":
            suggest = "qualifier_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuthorizedViewSubsetViewFamilySubset. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuthorizedViewSubsetViewFamilySubset.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuthorizedViewSubsetViewFamilySubset.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 family_name: builtins.str,
                 qualifier_prefixes: Optional[Sequence[builtins.str]] = None,
                 qualifiers: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str family_name: Name of the column family to be included in the authorized view. The specified column family must exist in the parent table of this authorized view.
        :param Sequence[builtins.str] qualifier_prefixes: A list of Base64-encoded prefixes for qualifiers of the column family to be included in the authorized view.
               Every qualifier starting with one of these prefixes is included in the authorized view. To provide access to all qualifiers, include the empty string as a prefix ("").
        :param Sequence[builtins.str] qualifiers: A list of Base64-encoded individual exact column qualifiers of the column family to be included in the authorized view.
        """
        pulumi.set(__self__, "family_name", family_name)
        if qualifier_prefixes is not None:
            pulumi.set(__self__, "qualifier_prefixes", qualifier_prefixes)
        if qualifiers is not None:
            pulumi.set(__self__, "qualifiers", qualifiers)

    @property
    @pulumi.getter(name="familyName")
    def family_name(self) -> builtins.str:
        """
        Name of the column family to be included in the authorized view. The specified column family must exist in the parent table of this authorized view.
        """
        return pulumi.get(self, "family_name")

    @property
    @pulumi.getter(name="qualifierPrefixes")
    def qualifier_prefixes(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Base64-encoded prefixes for qualifiers of the column family to be included in the authorized view.
        Every qualifier starting with one of these prefixes is included in the authorized view. To provide access to all qualifiers, include the empty string as a prefix ("").
        """
        return pulumi.get(self, "qualifier_prefixes")

    @property
    @pulumi.getter
    def qualifiers(self) -> Optional[Sequence[builtins.str]]:
        """
        A list of Base64-encoded individual exact column qualifiers of the column family to be included in the authorized view.
        """
        return pulumi.get(self, "qualifiers")


@pulumi.output_type
class GCPolicyMaxAge(dict):
    def __init__(__self__, *,
                 days: Optional[builtins.int] = None,
                 duration: Optional[builtins.str] = None):
        """
        :param builtins.int days: Number of days before applying GC policy.
        :param builtins.str duration: Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set
               
               -----
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)

    @property
    @pulumi.getter
    @_utilities.deprecated("""Deprecated in favor of duration""")
    def days(self) -> Optional[builtins.int]:
        """
        Number of days before applying GC policy.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter
    def duration(self) -> Optional[builtins.str]:
        """
        Duration before applying GC policy (ex. "8h"). This is required when `days` isn't set

        -----
        """
        return pulumi.get(self, "duration")


@pulumi.output_type
class GCPolicyMaxVersion(dict):
    def __init__(__self__, *,
                 number: builtins.int):
        """
        :param builtins.int number: Number of version before applying the GC policy.
               
               -----
               `gc_rules` include 2 fields:
        """
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def number(self) -> builtins.int:
        """
        Number of version before applying the GC policy.

        -----
        `gc_rules` include 2 fields:
        """
        return pulumi.get(self, "number")


@pulumi.output_type
class InstanceCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterId":
            suggest = "cluster_id"
        elif key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "nodeScalingFactor":
            suggest = "node_scaling_factor"
        elif key == "numNodes":
            suggest = "num_nodes"
        elif key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_id: builtins.str,
                 autoscaling_config: Optional['outputs.InstanceClusterAutoscalingConfig'] = None,
                 kms_key_name: Optional[builtins.str] = None,
                 node_scaling_factor: Optional[builtins.str] = None,
                 num_nodes: Optional[builtins.int] = None,
                 state: Optional[builtins.str] = None,
                 storage_type: Optional[builtins.str] = None,
                 zone: Optional[builtins.str] = None):
        """
        :param builtins.str cluster_id: The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        :param 'InstanceClusterAutoscalingConfigArgs' autoscaling_config: [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        :param builtins.str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        :param builtins.str node_scaling_factor: The node scaling factor for this cluster. One of `"NodeScalingFactor1X"` or `"NodeScalingFactor2X"`. Defaults to `"NodeScalingFactor1X"`. If `"NodeScalingFactor2X"` is specified, then `num_nodes`, `min_nodes`, and `max_nodes` would need to be specified in increments of 2. This value cannot be updated after the cluster is created.
               
               > **Note**: Removing the field entirely from the config will cause the provider to default to the backend value.
               
               !> **Warning**: Modifying this field will cause the provider to delete/recreate the entire resource.
               
               !> **Warning:** Modifying the `storage_type`, `zone` or `kms_key_name` of an existing cluster (by
               `cluster_id`) will cause the provider to delete/recreate the entire
               `bigtable.Instance` resource. If these values are changing, use a new
               `cluster_id`.
        :param builtins.int num_nodes: The number of nodes in the cluster.
               If no value is set, Cloud Bigtable automatically allocates nodes based on your data footprint and optimized for 50% storage utilization.
        :param builtins.str state: describes the current state of the cluster.
        :param builtins.str storage_type: The storage type to use. One of `"SSD"` or
               `"HDD"`. Defaults to `"SSD"`.
        :param builtins.str zone: The zone to create the Cloud Bigtable cluster in. If it not
               specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
               Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if autoscaling_config is not None:
            pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if node_scaling_factor is not None:
            pulumi.set(__self__, "node_scaling_factor", node_scaling_factor)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> builtins.str:
        """
        The ID of the Cloud Bigtable cluster. Must be 6-30 characters and must only contain hyphens, lowercase letters and numbers.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> Optional['outputs.InstanceClusterAutoscalingConfig']:
        """
        [Autoscaling](https://cloud.google.com/bigtable/docs/autoscaling#parameters) config for the cluster, contains the following arguments:
        """
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[builtins.str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="nodeScalingFactor")
    def node_scaling_factor(self) -> Optional[builtins.str]:
        """
        The node scaling factor for this cluster. One of `"NodeScalingFactor1X"` or `"NodeScalingFactor2X"`. Defaults to `"NodeScalingFactor1X"`. If `"NodeScalingFactor2X"` is specified, then `num_nodes`, `min_nodes`, and `max_nodes` would need to be specified in increments of 2. This value cannot be updated after the cluster is created.

        > **Note**: Removing the field entirely from the config will cause the provider to default to the backend value.

        !> **Warning**: Modifying this field will cause the provider to delete/recreate the entire resource.

        !> **Warning:** Modifying the `storage_type`, `zone` or `kms_key_name` of an existing cluster (by
        `cluster_id`) will cause the provider to delete/recreate the entire
        `bigtable.Instance` resource. If these values are changing, use a new
        `cluster_id`.
        """
        return pulumi.get(self, "node_scaling_factor")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[builtins.int]:
        """
        The number of nodes in the cluster.
        If no value is set, Cloud Bigtable automatically allocates nodes based on your data footprint and optimized for 50% storage utilization.
        """
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        describes the current state of the cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[builtins.str]:
        """
        The storage type to use. One of `"SSD"` or
        `"HDD"`. Defaults to `"SSD"`.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        The zone to create the Cloud Bigtable cluster in. If it not
        specified, the provider zone is used. Each cluster must have a different zone in the same region. Zones that support
        Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class InstanceClusterAutoscalingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuTarget":
            suggest = "cpu_target"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "storageTarget":
            suggest = "storage_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceClusterAutoscalingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceClusterAutoscalingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_target: builtins.int,
                 max_nodes: builtins.int,
                 min_nodes: builtins.int,
                 storage_target: Optional[builtins.int] = None):
        """
        :param builtins.int cpu_target: The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        :param builtins.int max_nodes: The maximum number of nodes for autoscaling.
        :param builtins.int min_nodes: The minimum number of nodes for autoscaling.
        :param builtins.int storage_target: The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.
               
               !> **Warning**: Only one of `autoscaling_config` or `num_nodes` should be set for a cluster. If both are set, `num_nodes` is ignored. If none is set, autoscaling will be disabled and sized to the current node count.
        """
        pulumi.set(__self__, "cpu_target", cpu_target)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        if storage_target is not None:
            pulumi.set(__self__, "storage_target", storage_target)

    @property
    @pulumi.getter(name="cpuTarget")
    def cpu_target(self) -> builtins.int:
        """
        The target CPU utilization for autoscaling, in percentage. Must be between 10 and 80.
        """
        return pulumi.get(self, "cpu_target")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> builtins.int:
        """
        The maximum number of nodes for autoscaling.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> builtins.int:
        """
        The minimum number of nodes for autoscaling.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="storageTarget")
    def storage_target(self) -> Optional[builtins.int]:
        """
        The target storage utilization for autoscaling, in GB, for each node in a cluster. This number is limited between 2560 (2.5TiB) and 5120 (5TiB) for a SSD cluster and between 8192 (8TiB) and 16384 (16 TiB) for an HDD cluster. If not set, whatever is already set for the cluster will not change, or if the cluster is just being created, it will use the default value of 2560 for SSD clusters and 8192 for HDD clusters.

        !> **Warning**: Only one of `autoscaling_config` or `num_nodes` should be set for a cluster. If both are set, `num_nodes` is ignored. If none is set, autoscaling will be disabled and sized to the current node count.
        """
        return pulumi.get(self, "storage_target")


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               For `bigtable.InstanceIamPolicy` only:
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        For `bigtable.InstanceIamPolicy` only:
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        """
        :param builtins.str expression: Textual representation of an expression in Common Expression Language syntax.
        :param builtins.str title: A title for the expression, i.e. a short string describing its purpose.
        :param builtins.str description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
               
               For `bigtable.InstanceIamPolicy` only:
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.

        For `bigtable.InstanceIamPolicy` only:
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class TableAutomatedBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPeriod":
            suggest = "retention_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableAutomatedBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableAutomatedBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableAutomatedBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: Optional[builtins.str] = None,
                 retention_period: Optional[builtins.str] = None):
        """
        :param builtins.str frequency: How frequently automated backups should occur.
        :param builtins.str retention_period: How long the automated backups should be retained.
        """
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[builtins.str]:
        """
        How frequently automated backups should occur.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[builtins.str]:
        """
        How long the automated backups should be retained.
        """
        return pulumi.get(self, "retention_period")


@pulumi.output_type
class TableColumnFamily(dict):
    def __init__(__self__, *,
                 family: builtins.str,
                 type: Optional[builtins.str] = None):
        """
        :param builtins.str family: The name of the column family.
        :param builtins.str type: The type of the column family.
        """
        pulumi.set(__self__, "family", family)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def family(self) -> builtins.str:
        """
        The name of the column family.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        """
        The type of the column family.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class TableIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class TableIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


