# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ProjectInfoArgs', 'ProjectInfo']

@pulumi.input_type
class ProjectInfoArgs:
    def __init__(__self__, *,
                 billing_account: pulumi.Input[builtins.str],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProjectInfo resource.
        :param pulumi.Input[builtins.str] billing_account: The ID of the billing account associated with the project, if
               any. Set to empty string to disable billing for the project.
               For example, `"012345-567890-ABCDEF"` or `""`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "billing_account", billing_account)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the billing account associated with the project, if
        any. Set to empty string to disable billing for the project.
        For example, `"012345-567890-ABCDEF"` or `""`.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "billing_account", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ProjectInfoState:
    def __init__(__self__, *,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProjectInfo resources.
        :param pulumi.Input[builtins.str] billing_account: The ID of the billing account associated with the project, if
               any. Set to empty string to disable billing for the project.
               For example, `"012345-567890-ABCDEF"` or `""`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if billing_account is not None:
            pulumi.set(__self__, "billing_account", billing_account)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the billing account associated with the project, if
        any. Set to empty string to disable billing for the project.
        For example, `"012345-567890-ABCDEF"` or `""`.
        """
        return pulumi.get(self, "billing_account")

    @billing_account.setter
    def billing_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "billing_account", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:billing/projectInfo:ProjectInfo")
class ProjectInfo(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Billing information for a project.

        To get more information about ProjectInfo, see:

        * [API documentation](https://cloud.google.com/billing/docs/reference/rest/v1/projects)
        * How-to Guides
            * [Enable, disable, or change billing for a project](https://cloud.google.com/billing/docs/how-to/modify-project)

        ## Example Usage

        ### Billing Project Info Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="tf-test_88717",
            name="tf-test_85794",
            org_id="123456789",
            deletion_policy="DELETE")
        default = gcp.billing.ProjectInfo("default",
            project=project.project_id,
            billing_account="000000-0000000-0000000-000000")
        ```

        ## Import

        ProjectInfo can be imported using any of these accepted formats:

        * `projects/{{project}}`

        * `{{project}}`

        When using the `pulumi import` command, ProjectInfo can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:billing/projectInfo:ProjectInfo default projects/{{project}}
        ```

        ```sh
        $ pulumi import gcp:billing/projectInfo:ProjectInfo default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_account: The ID of the billing account associated with the project, if
               any. Set to empty string to disable billing for the project.
               For example, `"012345-567890-ABCDEF"` or `""`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectInfoArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Billing information for a project.

        To get more information about ProjectInfo, see:

        * [API documentation](https://cloud.google.com/billing/docs/reference/rest/v1/projects)
        * How-to Guides
            * [Enable, disable, or change billing for a project](https://cloud.google.com/billing/docs/how-to/modify-project)

        ## Example Usage

        ### Billing Project Info Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.Project("project",
            project_id="tf-test_88717",
            name="tf-test_85794",
            org_id="123456789",
            deletion_policy="DELETE")
        default = gcp.billing.ProjectInfo("default",
            project=project.project_id,
            billing_account="000000-0000000-0000000-000000")
        ```

        ## Import

        ProjectInfo can be imported using any of these accepted formats:

        * `projects/{{project}}`

        * `{{project}}`

        When using the `pulumi import` command, ProjectInfo can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:billing/projectInfo:ProjectInfo default projects/{{project}}
        ```

        ```sh
        $ pulumi import gcp:billing/projectInfo:ProjectInfo default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param ProjectInfoArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectInfoArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 billing_account: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectInfoArgs.__new__(ProjectInfoArgs)

            if billing_account is None and not opts.urn:
                raise TypeError("Missing required property 'billing_account'")
            __props__.__dict__["billing_account"] = billing_account
            __props__.__dict__["project"] = project
        super(ProjectInfo, __self__).__init__(
            'gcp:billing/projectInfo:ProjectInfo',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            billing_account: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'ProjectInfo':
        """
        Get an existing ProjectInfo resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] billing_account: The ID of the billing account associated with the project, if
               any. Set to empty string to disable billing for the project.
               For example, `"012345-567890-ABCDEF"` or `""`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectInfoState.__new__(_ProjectInfoState)

        __props__.__dict__["billing_account"] = billing_account
        __props__.__dict__["project"] = project
        return ProjectInfo(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="billingAccount")
    def billing_account(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the billing account associated with the project, if
        any. Set to empty string to disable billing for the project.
        For example, `"012345-567890-ABCDEF"` or `""`.
        """
        return pulumi.get(self, "billing_account")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

