# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CaPoolArgs', 'CaPool']

@pulumi.input_type
class CaPoolArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 tier: pulumi.Input[builtins.str],
                 issuance_policy: Optional[pulumi.Input['CaPoolIssuancePolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 publishing_options: Optional[pulumi.Input['CaPoolPublishingOptionsArgs']] = None):
        """
        The set of arguments for constructing a CaPool resource.
        :param pulumi.Input[builtins.str] location: Location of the CaPool. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[builtins.str] tier: The Tier of this CaPool.
               Possible values are: `ENTERPRISE`, `DEVOPS`.
        :param pulumi.Input['CaPoolIssuancePolicyArgs'] issuance_policy: The IssuancePolicy to control how Certificates will be issued from this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The name for this CaPool.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CaPoolPublishingOptionsArgs'] publishing_options: The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "tier", tier)
        if issuance_policy is not None:
            pulumi.set(__self__, "issuance_policy", issuance_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publishing_options is not None:
            pulumi.set(__self__, "publishing_options", publishing_options)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the CaPool. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Input[builtins.str]:
        """
        The Tier of this CaPool.
        Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> Optional[pulumi.Input['CaPoolIssuancePolicyArgs']]:
        """
        The IssuancePolicy to control how Certificates will be issued from this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "issuance_policy")

    @issuance_policy.setter
    def issuance_policy(self, value: Optional[pulumi.Input['CaPoolIssuancePolicyArgs']]):
        pulumi.set(self, "issuance_policy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this CaPool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> Optional[pulumi.Input['CaPoolPublishingOptionsArgs']]:
        """
        The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "publishing_options")

    @publishing_options.setter
    def publishing_options(self, value: Optional[pulumi.Input['CaPoolPublishingOptionsArgs']]):
        pulumi.set(self, "publishing_options", value)


@pulumi.input_type
class _CaPoolState:
    def __init__(__self__, *,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 issuance_policy: Optional[pulumi.Input['CaPoolIssuancePolicyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 publishing_options: Optional[pulumi.Input['CaPoolPublishingOptionsArgs']] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CaPool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['CaPoolIssuancePolicyArgs'] issuance_policy: The IssuancePolicy to control how Certificates will be issued from this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the CaPool. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[builtins.str] name: The name for this CaPool.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['CaPoolPublishingOptionsArgs'] publishing_options: The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] tier: The Tier of this CaPool.
               Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if issuance_policy is not None:
            pulumi.set(__self__, "issuance_policy", issuance_policy)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if publishing_options is not None:
            pulumi.set(__self__, "publishing_options", publishing_options)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> Optional[pulumi.Input['CaPoolIssuancePolicyArgs']]:
        """
        The IssuancePolicy to control how Certificates will be issued from this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "issuance_policy")

    @issuance_policy.setter
    def issuance_policy(self, value: Optional[pulumi.Input['CaPoolIssuancePolicyArgs']]):
        pulumi.set(self, "issuance_policy", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the CaPool. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for this CaPool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> Optional[pulumi.Input['CaPoolPublishingOptionsArgs']]:
        """
        The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "publishing_options")

    @publishing_options.setter
    def publishing_options(self, value: Optional[pulumi.Input['CaPoolPublishingOptionsArgs']]):
        pulumi.set(self, "publishing_options", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Tier of this CaPool.
        Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)


@pulumi.type_token("gcp:certificateauthority/caPool:CaPool")
class CaPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issuance_policy: Optional[pulumi.Input[Union['CaPoolIssuancePolicyArgs', 'CaPoolIssuancePolicyArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 publishing_options: Optional[pulumi.Input[Union['CaPoolPublishingOptionsArgs', 'CaPoolPublishingOptionsArgsDict']]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A CaPool represents a group of CertificateAuthorities that form a trust anchor. A CaPool can be used to manage
        issuance policies for one or more CertificateAuthority resources and to rotate CA certificates in and out of the
        trust anchor.

        To get more information about CaPool, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest/v1/projects.locations.caPools)
        * How-to Guides
            * [Certificate Authority Service Overview](https://cloud.google.com/certificate-authority-service/docs/overview)

        ## Example Usage

        ### Privateca Capool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            },
            labels={
                "foo": "bar",
            })
        ```
        ### Privateca Capool All Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": True,
                "encoding_format": "PEM",
            },
            labels={
                "foo": "bar",
            },
            issuance_policy={
                "allowed_key_types": [
                    {
                        "elliptic_curve": {
                            "signature_algorithm": "ECDSA_P256",
                        },
                    },
                    {
                        "rsa": {
                            "min_modulus_size": "5",
                            "max_modulus_size": "10",
                        },
                    },
                ],
                "backdate_duration": "3600s",
                "maximum_lifetime": "50000s",
                "allowed_issuance_modes": {
                    "allow_csr_based_issuance": True,
                    "allow_config_based_issuance": True,
                },
                "identity_constraints": {
                    "allow_subject_passthrough": True,
                    "allow_subject_alt_names_passthrough": True,
                    "cel_expression": {
                        "expression": "subject_alt_names.all(san, san.type == DNS || san.type == EMAIL )",
                        "title": "My title",
                    },
                },
                "baseline_values": {
                    "aia_ocsp_servers": ["example.com"],
                    "additional_extensions": [{
                        "critical": True,
                        "value": "asdf",
                        "object_id": {
                            "object_id_paths": [
                                1,
                                7,
                            ],
                        },
                    }],
                    "policy_ids": [
                        {
                            "object_id_paths": [
                                1,
                                5,
                            ],
                        },
                        {
                            "object_id_paths": [
                                1,
                                5,
                                7,
                            ],
                        },
                    ],
                    "ca_options": {
                        "is_ca": True,
                        "max_issuer_path_length": 10,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "content_commitment": True,
                            "key_encipherment": False,
                            "data_encipherment": True,
                            "key_agreement": True,
                            "cert_sign": False,
                            "crl_sign": True,
                            "decipher_only": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                            "client_auth": False,
                            "email_protection": True,
                            "code_signing": True,
                            "time_stamping": True,
                        },
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": [
                            "*.example1.com",
                            "*.example2.com",
                        ],
                        "excluded_dns_names": [
                            "*.deny.example1.com",
                            "*.deny.example2.com",
                        ],
                        "permitted_ip_ranges": [
                            "10.0.0.0/8",
                            "11.0.0.0/8",
                        ],
                        "excluded_ip_ranges": [
                            "10.1.1.0/24",
                            "11.1.1.0/24",
                        ],
                        "permitted_email_addresses": [
                            ".example1.com",
                            ".example2.com",
                        ],
                        "excluded_email_addresses": [
                            ".deny.example1.com",
                            ".deny.example2.com",
                        ],
                        "permitted_uris": [
                            ".example1.com",
                            ".example2.com",
                        ],
                        "excluded_uris": [
                            ".deny.example1.com",
                            ".deny.example2.com",
                        ],
                    },
                },
            })
        ```

        ## Import

        CaPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CaPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default projects/{{project}}/locations/{{location}}/caPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['CaPoolIssuancePolicyArgs', 'CaPoolIssuancePolicyArgsDict']] issuance_policy: The IssuancePolicy to control how Certificates will be issued from this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the CaPool. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[builtins.str] name: The name for this CaPool.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CaPoolPublishingOptionsArgs', 'CaPoolPublishingOptionsArgsDict']] publishing_options: The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
               Structure is documented below.
        :param pulumi.Input[builtins.str] tier: The Tier of this CaPool.
               Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CaPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A CaPool represents a group of CertificateAuthorities that form a trust anchor. A CaPool can be used to manage
        issuance policies for one or more CertificateAuthority resources and to rotate CA certificates in and out of the
        trust anchor.

        To get more information about CaPool, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest/v1/projects.locations.caPools)
        * How-to Guides
            * [Certificate Authority Service Overview](https://cloud.google.com/certificate-authority-service/docs/overview)

        ## Example Usage

        ### Privateca Capool Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": True,
                "publish_crl": True,
            },
            labels={
                "foo": "bar",
            })
        ```
        ### Privateca Capool All Fields

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CaPool("default",
            name="my-pool",
            location="us-central1",
            tier="ENTERPRISE",
            publishing_options={
                "publish_ca_cert": False,
                "publish_crl": True,
                "encoding_format": "PEM",
            },
            labels={
                "foo": "bar",
            },
            issuance_policy={
                "allowed_key_types": [
                    {
                        "elliptic_curve": {
                            "signature_algorithm": "ECDSA_P256",
                        },
                    },
                    {
                        "rsa": {
                            "min_modulus_size": "5",
                            "max_modulus_size": "10",
                        },
                    },
                ],
                "backdate_duration": "3600s",
                "maximum_lifetime": "50000s",
                "allowed_issuance_modes": {
                    "allow_csr_based_issuance": True,
                    "allow_config_based_issuance": True,
                },
                "identity_constraints": {
                    "allow_subject_passthrough": True,
                    "allow_subject_alt_names_passthrough": True,
                    "cel_expression": {
                        "expression": "subject_alt_names.all(san, san.type == DNS || san.type == EMAIL )",
                        "title": "My title",
                    },
                },
                "baseline_values": {
                    "aia_ocsp_servers": ["example.com"],
                    "additional_extensions": [{
                        "critical": True,
                        "value": "asdf",
                        "object_id": {
                            "object_id_paths": [
                                1,
                                7,
                            ],
                        },
                    }],
                    "policy_ids": [
                        {
                            "object_id_paths": [
                                1,
                                5,
                            ],
                        },
                        {
                            "object_id_paths": [
                                1,
                                5,
                                7,
                            ],
                        },
                    ],
                    "ca_options": {
                        "is_ca": True,
                        "max_issuer_path_length": 10,
                    },
                    "key_usage": {
                        "base_key_usage": {
                            "digital_signature": True,
                            "content_commitment": True,
                            "key_encipherment": False,
                            "data_encipherment": True,
                            "key_agreement": True,
                            "cert_sign": False,
                            "crl_sign": True,
                            "decipher_only": True,
                        },
                        "extended_key_usage": {
                            "server_auth": True,
                            "client_auth": False,
                            "email_protection": True,
                            "code_signing": True,
                            "time_stamping": True,
                        },
                    },
                    "name_constraints": {
                        "critical": True,
                        "permitted_dns_names": [
                            "*.example1.com",
                            "*.example2.com",
                        ],
                        "excluded_dns_names": [
                            "*.deny.example1.com",
                            "*.deny.example2.com",
                        ],
                        "permitted_ip_ranges": [
                            "10.0.0.0/8",
                            "11.0.0.0/8",
                        ],
                        "excluded_ip_ranges": [
                            "10.1.1.0/24",
                            "11.1.1.0/24",
                        ],
                        "permitted_email_addresses": [
                            ".example1.com",
                            ".example2.com",
                        ],
                        "excluded_email_addresses": [
                            ".deny.example1.com",
                            ".deny.example2.com",
                        ],
                        "permitted_uris": [
                            ".example1.com",
                            ".example2.com",
                        ],
                        "excluded_uris": [
                            ".deny.example1.com",
                            ".deny.example2.com",
                        ],
                    },
                },
            })
        ```

        ## Import

        CaPool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/caPools/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CaPool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default projects/{{project}}/locations/{{location}}/caPools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/caPool:CaPool default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CaPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CaPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 issuance_policy: Optional[pulumi.Input[Union['CaPoolIssuancePolicyArgs', 'CaPoolIssuancePolicyArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 publishing_options: Optional[pulumi.Input[Union['CaPoolPublishingOptionsArgs', 'CaPoolPublishingOptionsArgsDict']]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CaPoolArgs.__new__(CaPoolArgs)

            __props__.__dict__["issuance_policy"] = issuance_policy
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["publishing_options"] = publishing_options
            if tier is None and not opts.urn:
                raise TypeError("Missing required property 'tier'")
            __props__.__dict__["tier"] = tier
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CaPool, __self__).__init__(
            'gcp:certificateauthority/caPool:CaPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            issuance_policy: Optional[pulumi.Input[Union['CaPoolIssuancePolicyArgs', 'CaPoolIssuancePolicyArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            publishing_options: Optional[pulumi.Input[Union['CaPoolPublishingOptionsArgs', 'CaPoolPublishingOptionsArgsDict']]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tier: Optional[pulumi.Input[builtins.str]] = None) -> 'CaPool':
        """
        Get an existing CaPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['CaPoolIssuancePolicyArgs', 'CaPoolIssuancePolicyArgsDict']] issuance_policy: The IssuancePolicy to control how Certificates will be issued from this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels with user-defined metadata.
               An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
               "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: Location of the CaPool. A full list of valid locations can be found by
               running `gcloud privateca locations list`.
        :param pulumi.Input[builtins.str] name: The name for this CaPool.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['CaPoolPublishingOptionsArgs', 'CaPoolPublishingOptionsArgsDict']] publishing_options: The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] tier: The Tier of this CaPool.
               Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CaPoolState.__new__(_CaPoolState)

        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["issuance_policy"] = issuance_policy
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["publishing_options"] = publishing_options
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["tier"] = tier
        return CaPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="issuancePolicy")
    def issuance_policy(self) -> pulumi.Output[Optional['outputs.CaPoolIssuancePolicy']]:
        """
        The IssuancePolicy to control how Certificates will be issued from this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "issuance_policy")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels with user-defined metadata.
        An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
        "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the CaPool. A full list of valid locations can be found by
        running `gcloud privateca locations list`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name for this CaPool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="publishingOptions")
    def publishing_options(self) -> pulumi.Output[Optional['outputs.CaPoolPublishingOptions']]:
        """
        The PublishingOptions to follow when issuing Certificates from any CertificateAuthority in this CaPool.
        Structure is documented below.
        """
        return pulumi.get(self, "publishing_options")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def tier(self) -> pulumi.Output[builtins.str]:
        """
        The Tier of this CaPool.
        Possible values are: `ENTERPRISE`, `DEVOPS`.
        """
        return pulumi.get(self, "tier")

