# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CertificateTemplateArgs', 'CertificateTemplate']

@pulumi.input_type
class CertificateTemplateArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity_constraints: Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 maximum_lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_extensions: Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']] = None,
                 predefined_values: Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CertificateTemplate resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] description: Optional. A human-readable description of scenarios this template is intended for.
        :param pulumi.Input['CertificateTemplateIdentityConstraintsArgs'] identity_constraints: Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels with user-defined metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] maximum_lifetime: Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        :param pulumi.Input[builtins.str] name: The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        :param pulumi.Input['CertificateTemplatePassthroughExtensionsArgs'] passthrough_extensions: Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
               Structure is documented below.
        :param pulumi.Input['CertificateTemplatePredefinedValuesArgs'] predefined_values: Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity_constraints is not None:
            pulumi.set(__self__, "identity_constraints", identity_constraints)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maximum_lifetime is not None:
            pulumi.set(__self__, "maximum_lifetime", maximum_lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passthrough_extensions is not None:
            pulumi.set(__self__, "passthrough_extensions", passthrough_extensions)
        if predefined_values is not None:
            pulumi.set(__self__, "predefined_values", predefined_values)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A human-readable description of scenarios this template is intended for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="identityConstraints")
    def identity_constraints(self) -> Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']]:
        """
        Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
        Structure is documented below.
        """
        return pulumi.get(self, "identity_constraints")

    @identity_constraints.setter
    def identity_constraints(self, value: Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']]):
        pulumi.set(self, "identity_constraints", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels with user-defined metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        """
        return pulumi.get(self, "maximum_lifetime")

    @maximum_lifetime.setter
    def maximum_lifetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maximum_lifetime", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passthroughExtensions")
    def passthrough_extensions(self) -> Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']]:
        """
        Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
        Structure is documented below.
        """
        return pulumi.get(self, "passthrough_extensions")

    @passthrough_extensions.setter
    def passthrough_extensions(self, value: Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']]):
        pulumi.set(self, "passthrough_extensions", value)

    @property
    @pulumi.getter(name="predefinedValues")
    def predefined_values(self) -> Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']]:
        """
        Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_values")

    @predefined_values.setter
    def predefined_values(self, value: Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']]):
        pulumi.set(self, "predefined_values", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CertificateTemplateState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 identity_constraints: Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_extensions: Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']] = None,
                 predefined_values: Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CertificateTemplate resources.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this CertificateTemplate was created.
        :param pulumi.Input[builtins.str] description: Optional. A human-readable description of scenarios this template is intended for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['CertificateTemplateIdentityConstraintsArgs'] identity_constraints: Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels with user-defined metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] maximum_lifetime: Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        :param pulumi.Input[builtins.str] name: The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        :param pulumi.Input['CertificateTemplatePassthroughExtensionsArgs'] passthrough_extensions: Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
               Structure is documented below.
        :param pulumi.Input['CertificateTemplatePredefinedValuesArgs'] predefined_values: Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this CertificateTemplate was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if identity_constraints is not None:
            pulumi.set(__self__, "identity_constraints", identity_constraints)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_lifetime is not None:
            pulumi.set(__self__, "maximum_lifetime", maximum_lifetime)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passthrough_extensions is not None:
            pulumi.set(__self__, "passthrough_extensions", passthrough_extensions)
        if predefined_values is not None:
            pulumi.set(__self__, "predefined_values", predefined_values)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this CertificateTemplate was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A human-readable description of scenarios this template is intended for.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="identityConstraints")
    def identity_constraints(self) -> Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']]:
        """
        Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
        Structure is documented below.
        """
        return pulumi.get(self, "identity_constraints")

    @identity_constraints.setter
    def identity_constraints(self, value: Optional[pulumi.Input['CertificateTemplateIdentityConstraintsArgs']]):
        pulumi.set(self, "identity_constraints", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels with user-defined metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        """
        return pulumi.get(self, "maximum_lifetime")

    @maximum_lifetime.setter
    def maximum_lifetime(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "maximum_lifetime", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passthroughExtensions")
    def passthrough_extensions(self) -> Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']]:
        """
        Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
        Structure is documented below.
        """
        return pulumi.get(self, "passthrough_extensions")

    @passthrough_extensions.setter
    def passthrough_extensions(self, value: Optional[pulumi.Input['CertificateTemplatePassthroughExtensionsArgs']]):
        pulumi.set(self, "passthrough_extensions", value)

    @property
    @pulumi.getter(name="predefinedValues")
    def predefined_values(self) -> Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']]:
        """
        Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_values")

    @predefined_values.setter
    def predefined_values(self, value: Optional[pulumi.Input['CertificateTemplatePredefinedValuesArgs']]):
        pulumi.set(self, "predefined_values", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this CertificateTemplate was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:certificateauthority/certificateTemplate:CertificateTemplate")
class CertificateTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity_constraints: Optional[pulumi.Input[Union['CertificateTemplateIdentityConstraintsArgs', 'CertificateTemplateIdentityConstraintsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_extensions: Optional[pulumi.Input[Union['CertificateTemplatePassthroughExtensionsArgs', 'CertificateTemplatePassthroughExtensionsArgsDict']]] = None,
                 predefined_values: Optional[pulumi.Input[Union['CertificateTemplatePredefinedValuesArgs', 'CertificateTemplatePredefinedValuesArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Certificate Authority Service provides reusable and parameterized templates that you can use for common certificate issuance scenarios. A certificate template represents a relatively static and well-defined certificate issuance schema within an organization. A certificate template can essentially become a full-fledged vertical certificate issuance framework.

        To get more information about CertificateTemplate, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest)
        * How-to Guides
            * [Common configurations and Certificate Profiles](https://cloud.google.com/certificate-authority-service/docs/certificate-profile)
            * [Official Documentation](https://cloud.google.com/certificate-authority-service)
            * [Understanding Certificate Templates](https://cloud.google.com/certificate-authority-service/docs/certificate-template)

        ## Example Usage

        ### Privateca Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CertificateTemplate("default",
            name="my-template",
            location="us-central1",
            description="A sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            maximum_lifetime="86400s",
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "max_issuer_path_length": 6,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Privateca Template Zero Max Issuer Path Length Null Ca

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CertificateTemplate("default",
            name="my-template",
            location="us-central1",
            description="A sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            maximum_lifetime="86400s",
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "null_ca": True,
                    "zero_max_issuer_path_length": True,
                    "max_issuer_path_length": 0,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "name_constraints": {
                    "critical": True,
                    "permitted_dns_names": [
                        "*.example1.com",
                        "*.example2.com",
                    ],
                    "excluded_dns_names": [
                        "*.deny.example1.com",
                        "*.deny.example2.com",
                    ],
                    "permitted_ip_ranges": [
                        "10.0.0.0/8",
                        "11.0.0.0/8",
                    ],
                    "excluded_ip_ranges": [
                        "10.1.1.0/24",
                        "11.1.1.0/24",
                    ],
                    "permitted_email_addresses": [
                        ".example1.com",
                        ".example2.com",
                    ],
                    "excluded_email_addresses": [
                        ".deny.example1.com",
                        ".deny.example2.com",
                    ],
                    "permitted_uris": [
                        ".example1.com",
                        ".example2.com",
                    ],
                    "excluded_uris": [
                        ".deny.example1.com",
                        ".deny.example2.com",
                    ],
                },
            },
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        CertificateTemplate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificateTemplates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CertificateTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default projects/{{project}}/locations/{{location}}/certificateTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Optional. A human-readable description of scenarios this template is intended for.
        :param pulumi.Input[Union['CertificateTemplateIdentityConstraintsArgs', 'CertificateTemplateIdentityConstraintsArgsDict']] identity_constraints: Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels with user-defined metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] maximum_lifetime: Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        :param pulumi.Input[builtins.str] name: The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        :param pulumi.Input[Union['CertificateTemplatePassthroughExtensionsArgs', 'CertificateTemplatePassthroughExtensionsArgsDict']] passthrough_extensions: Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
               Structure is documented below.
        :param pulumi.Input[Union['CertificateTemplatePredefinedValuesArgs', 'CertificateTemplatePredefinedValuesArgsDict']] predefined_values: Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Certificate Authority Service provides reusable and parameterized templates that you can use for common certificate issuance scenarios. A certificate template represents a relatively static and well-defined certificate issuance schema within an organization. A certificate template can essentially become a full-fledged vertical certificate issuance framework.

        To get more information about CertificateTemplate, see:

        * [API documentation](https://cloud.google.com/certificate-authority-service/docs/reference/rest)
        * How-to Guides
            * [Common configurations and Certificate Profiles](https://cloud.google.com/certificate-authority-service/docs/certificate-profile)
            * [Official Documentation](https://cloud.google.com/certificate-authority-service)
            * [Understanding Certificate Templates](https://cloud.google.com/certificate-authority-service/docs/certificate-template)

        ## Example Usage

        ### Privateca Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CertificateTemplate("default",
            name="my-template",
            location="us-central1",
            description="A sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            maximum_lifetime="86400s",
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "max_issuer_path_length": 6,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
            },
            labels={
                "label-one": "value-one",
            })
        ```
        ### Privateca Template Zero Max Issuer Path Length Null Ca

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.certificateauthority.CertificateTemplate("default",
            name="my-template",
            location="us-central1",
            description="A sample certificate template",
            identity_constraints={
                "allow_subject_alt_names_passthrough": True,
                "allow_subject_passthrough": True,
                "cel_expression": {
                    "description": "Always true",
                    "expression": "true",
                    "location": "any.file.anywhere",
                    "title": "Sample expression",
                },
            },
            maximum_lifetime="86400s",
            passthrough_extensions={
                "additional_extensions": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "known_extensions": ["EXTENDED_KEY_USAGE"],
            },
            predefined_values={
                "additional_extensions": [{
                    "object_id": {
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    },
                    "value": "c3RyaW5nCg==",
                    "critical": True,
                }],
                "aia_ocsp_servers": ["string"],
                "ca_options": {
                    "is_ca": False,
                    "null_ca": True,
                    "zero_max_issuer_path_length": True,
                    "max_issuer_path_length": 0,
                },
                "key_usage": {
                    "base_key_usage": {
                        "cert_sign": False,
                        "content_commitment": True,
                        "crl_sign": False,
                        "data_encipherment": True,
                        "decipher_only": True,
                        "digital_signature": True,
                        "encipher_only": True,
                        "key_agreement": True,
                        "key_encipherment": True,
                    },
                    "extended_key_usage": {
                        "client_auth": True,
                        "code_signing": True,
                        "email_protection": True,
                        "ocsp_signing": True,
                        "server_auth": True,
                        "time_stamping": True,
                    },
                    "unknown_extended_key_usages": [{
                        "object_id_paths": [
                            1,
                            6,
                        ],
                    }],
                },
                "policy_ids": [{
                    "object_id_paths": [
                        1,
                        6,
                    ],
                }],
                "name_constraints": {
                    "critical": True,
                    "permitted_dns_names": [
                        "*.example1.com",
                        "*.example2.com",
                    ],
                    "excluded_dns_names": [
                        "*.deny.example1.com",
                        "*.deny.example2.com",
                    ],
                    "permitted_ip_ranges": [
                        "10.0.0.0/8",
                        "11.0.0.0/8",
                    ],
                    "excluded_ip_ranges": [
                        "10.1.1.0/24",
                        "11.1.1.0/24",
                    ],
                    "permitted_email_addresses": [
                        ".example1.com",
                        ".example2.com",
                    ],
                    "excluded_email_addresses": [
                        ".deny.example1.com",
                        ".deny.example2.com",
                    ],
                    "permitted_uris": [
                        ".example1.com",
                        ".example2.com",
                    ],
                    "excluded_uris": [
                        ".deny.example1.com",
                        ".deny.example2.com",
                    ],
                },
            },
            labels={
                "label-one": "value-one",
            })
        ```

        ## Import

        CertificateTemplate can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/certificateTemplates/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, CertificateTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default projects/{{project}}/locations/{{location}}/certificateTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificateauthority/certificateTemplate:CertificateTemplate default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 identity_constraints: Optional[pulumi.Input[Union['CertificateTemplateIdentityConstraintsArgs', 'CertificateTemplateIdentityConstraintsArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 maximum_lifetime: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 passthrough_extensions: Optional[pulumi.Input[Union['CertificateTemplatePassthroughExtensionsArgs', 'CertificateTemplatePassthroughExtensionsArgsDict']]] = None,
                 predefined_values: Optional[pulumi.Input[Union['CertificateTemplatePredefinedValuesArgs', 'CertificateTemplatePredefinedValuesArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateTemplateArgs.__new__(CertificateTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["identity_constraints"] = identity_constraints
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_lifetime"] = maximum_lifetime
            __props__.__dict__["name"] = name
            __props__.__dict__["passthrough_extensions"] = passthrough_extensions
            __props__.__dict__["predefined_values"] = predefined_values
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CertificateTemplate, __self__).__init__(
            'gcp:certificateauthority/certificateTemplate:CertificateTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            identity_constraints: Optional[pulumi.Input[Union['CertificateTemplateIdentityConstraintsArgs', 'CertificateTemplateIdentityConstraintsArgsDict']]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            maximum_lifetime: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            passthrough_extensions: Optional[pulumi.Input[Union['CertificateTemplatePassthroughExtensionsArgs', 'CertificateTemplatePassthroughExtensionsArgsDict']]] = None,
            predefined_values: Optional[pulumi.Input[Union['CertificateTemplatePredefinedValuesArgs', 'CertificateTemplatePredefinedValuesArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'CertificateTemplate':
        """
        Get an existing CertificateTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this CertificateTemplate was created.
        :param pulumi.Input[builtins.str] description: Optional. A human-readable description of scenarios this template is intended for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['CertificateTemplateIdentityConstraintsArgs', 'CertificateTemplateIdentityConstraintsArgsDict']] identity_constraints: Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels with user-defined metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] maximum_lifetime: Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        :param pulumi.Input[builtins.str] name: The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        :param pulumi.Input[Union['CertificateTemplatePassthroughExtensionsArgs', 'CertificateTemplatePassthroughExtensionsArgsDict']] passthrough_extensions: Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
               Structure is documented below.
        :param pulumi.Input[Union['CertificateTemplatePredefinedValuesArgs', 'CertificateTemplatePredefinedValuesArgsDict']] predefined_values: Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this CertificateTemplate was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateTemplateState.__new__(_CertificateTemplateState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["identity_constraints"] = identity_constraints
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_lifetime"] = maximum_lifetime
        __props__.__dict__["name"] = name
        __props__.__dict__["passthrough_extensions"] = passthrough_extensions
        __props__.__dict__["predefined_values"] = predefined_values
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["update_time"] = update_time
        return CertificateTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this CertificateTemplate was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. A human-readable description of scenarios this template is intended for.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="identityConstraints")
    def identity_constraints(self) -> pulumi.Output[Optional['outputs.CertificateTemplateIdentityConstraints']]:
        """
        Optional. Describes constraints on identities that may be appear in Certificates issued using this template. If this is omitted, then this template will not add restrictions on a certificate's identity.
        Structure is documented below.
        """
        return pulumi.get(self, "identity_constraints")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Labels with user-defined metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="maximumLifetime")
    def maximum_lifetime(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. The maximum lifetime allowed for all issued certificates that use this template. If the issuing CaPool's IssuancePolicy specifies a maximum lifetime the minimum of the two durations will be the maximum lifetime for issued. Note that if the issuing CertificateAuthority expires before a Certificate's requested maximum_lifetime, the effective lifetime will be explicitly truncated to match it.
        """
        return pulumi.get(self, "maximum_lifetime")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name for this CertificateTemplate in the format `projects/*/locations/*/certificateTemplates/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passthroughExtensions")
    def passthrough_extensions(self) -> pulumi.Output[Optional['outputs.CertificateTemplatePassthroughExtensions']]:
        """
        Optional. Describes the set of X.509 extensions that may appear in a Certificate issued using this CertificateTemplate. If a certificate request sets extensions that don't appear in the passthrough_extensions, those extensions will be dropped. If the issuing CaPool's IssuancePolicy defines baseline_values that don't appear here, the certificate issuance request will fail. If this is omitted, then this template will not add restrictions on a certificate's X.509 extensions. These constraints do not apply to X.509 extensions set in this CertificateTemplate's predefined_values.
        Structure is documented below.
        """
        return pulumi.get(self, "passthrough_extensions")

    @property
    @pulumi.getter(name="predefinedValues")
    def predefined_values(self) -> pulumi.Output[Optional['outputs.CertificateTemplatePredefinedValues']]:
        """
        Optional. A set of X.509 values that will be applied to all issued certificates that use this template. If the certificate request includes conflicting values for the same properties, they will be overwritten by the values defined here. If the issuing CaPool's IssuancePolicy defines conflicting baseline_values for the same properties, the certificate issuance request will fail.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_values")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this CertificateTemplate was updated.
        """
        return pulumi.get(self, "update_time")

