# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetCertificateTemplateIamPolicyResult',
    'AwaitableGetCertificateTemplateIamPolicyResult',
    'get_certificate_template_iam_policy',
    'get_certificate_template_iam_policy_output',
]

@pulumi.output_type
class GetCertificateTemplateIamPolicyResult:
    """
    A collection of values returned by getCertificateTemplateIamPolicy.
    """
    def __init__(__self__, certificate_template=None, etag=None, id=None, location=None, policy_data=None, project=None):
        if certificate_template and not isinstance(certificate_template, str):
            raise TypeError("Expected argument 'certificate_template' to be a str")
        pulumi.set(__self__, "certificate_template", certificate_template)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> builtins.str:
        return pulumi.get(self, "certificate_template")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `certificateauthority.CertificateTemplateIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetCertificateTemplateIamPolicyResult(GetCertificateTemplateIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateTemplateIamPolicyResult(
            certificate_template=self.certificate_template,
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project)


def get_certificate_template_iam_policy(certificate_template: Optional[builtins.str] = None,
                                        location: Optional[builtins.str] = None,
                                        project: Optional[builtins.str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateTemplateIamPolicyResult:
    """
    Retrieves the current IAM policy data for certificatetemplate

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.certificateauthority.get_certificate_template_iam_policy(certificate_template=default["id"])
    ```


    :param builtins.str certificate_template: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: The location for the resource Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['certificateTemplate'] = certificate_template
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:certificateauthority/getCertificateTemplateIamPolicy:getCertificateTemplateIamPolicy', __args__, opts=opts, typ=GetCertificateTemplateIamPolicyResult).value

    return AwaitableGetCertificateTemplateIamPolicyResult(
        certificate_template=pulumi.get(__ret__, 'certificate_template'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_certificate_template_iam_policy_output(certificate_template: Optional[pulumi.Input[builtins.str]] = None,
                                               location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCertificateTemplateIamPolicyResult]:
    """
    Retrieves the current IAM policy data for certificatetemplate

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.certificateauthority.get_certificate_template_iam_policy(certificate_template=default["id"])
    ```


    :param builtins.str certificate_template: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: The location for the resource Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['certificateTemplate'] = certificate_template
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:certificateauthority/getCertificateTemplateIamPolicy:getCertificateTemplateIamPolicy', __args__, opts=opts, typ=GetCertificateTemplateIamPolicyResult)
    return __ret__.apply(lambda __response__: GetCertificateTemplateIamPolicyResult(
        certificate_template=pulumi.get(__response__, 'certificate_template'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
