# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateMapEntryArgs', 'CertificateMapEntry']

@pulumi.input_type
class CertificateMapEntryArgs:
    def __init__(__self__, *,
                 certificates: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 map: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 matcher: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CertificateMapEntry resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificates: A set of Certificates defines for the given hostname.
               There can be defined up to fifteen certificates in each Certificate Map Entry.
               Each certificate must match pattern projects/*/locations/*/certificates/*.
        :param pulumi.Input[builtins.str] map: A map entry that is inputted into the cetrificate map
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[builtins.str] hostname: A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
               for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
               selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with a Certificate Map Entry.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] matcher: A predefined matcher for particular cases, other than SNI selection
        :param pulumi.Input[builtins.str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry
               names must be unique globally and match pattern
               'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "map", map)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        A set of Certificates defines for the given hostname.
        There can be defined up to fifteen certificates in each Certificate Map Entry.
        Each certificate must match pattern projects/*/locations/*/certificates/*.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def map(self) -> pulumi.Input[builtins.str]:
        """
        A map entry that is inputted into the cetrificate map
        """
        return pulumi.get(self, "map")

    @map.setter
    def map(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "map", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
        for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
        selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of labels associated with a Certificate Map Entry.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A predefined matcher for particular cases, other than SNI selection
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry
        names must be unique globally and match pattern
        'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _CertificateMapEntryState:
    def __init__(__self__, *,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 matcher: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CertificateMapEntry resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificates: A set of Certificates defines for the given hostname.
               There can be defined up to fifteen certificates in each Certificate Map Entry.
               Each certificate must match pattern projects/*/locations/*/certificates/*.
        :param pulumi.Input[builtins.str] create_time: Creation timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] hostname: A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
               for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
               selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with a Certificate Map Entry.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] map: A map entry that is inputted into the cetrificate map
        :param pulumi.Input[builtins.str] matcher: A predefined matcher for particular cases, other than SNI selection
        :param pulumi.Input[builtins.str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry
               names must be unique globally and match pattern
               'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: A serving state of this Certificate Map Entry.
        :param pulumi.Input[builtins.str] update_time: Update timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if map is not None:
            pulumi.set(__self__, "map", map)
        if matcher is not None:
            pulumi.set(__self__, "matcher", matcher)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A set of Certificates defines for the given hostname.
        There can be defined up to fifteen certificates in each Certificate Map Entry.
        Each certificate must match pattern projects/*/locations/*/certificates/*.
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
        for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
        selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Set of labels associated with a Certificate Map Entry.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A map entry that is inputted into the cetrificate map
        """
        return pulumi.get(self, "map")

    @map.setter
    def map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "map", value)

    @property
    @pulumi.getter
    def matcher(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A predefined matcher for particular cases, other than SNI selection
        """
        return pulumi.get(self, "matcher")

    @matcher.setter
    def matcher(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "matcher", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry
        names must be unique globally and match pattern
        'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A serving state of this Certificate Map Entry.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Update timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:certificatemanager/certificateMapEntry:CertificateMapEntry")
class CertificateMapEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 matcher: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        CertificateMapEntry is a list of certificate configurations,
        that have been issued for a particular hostname

        ## Example Usage

        ### Certificate Manager Certificate Map Entry Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        certificate_map = gcp.certificatemanager.CertificateMap("certificate_map",
            name="cert-map-entry",
            description="My acceptance test certificate map",
            labels={
                "terraform": "true",
                "acc-test": "true",
            })
        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        certificate = gcp.certificatemanager.Certificate("certificate",
            name="cert-map-entry",
            description="The default cert",
            scope="DEFAULT",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        default = gcp.certificatemanager.CertificateMapEntry("default",
            name="cert-map-entry",
            description="My acceptance test certificate map entry",
            map=certificate_map.name,
            labels={
                "terraform": "true",
                "acc-test": "true",
            },
            certificates=[certificate.id],
            matcher="PRIMARY")
        ```

        ## Import

        CertificateMapEntry can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/certificateMaps/{{map}}/certificateMapEntries/{{name}}`

        * `{{project}}/{{map}}/{{name}}`

        * `{{map}}/{{name}}`

        When using the `pulumi import` command, CertificateMapEntry can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default projects/{{project}}/locations/global/certificateMaps/{{map}}/certificateMapEntries/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default {{project}}/{{map}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default {{map}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificates: A set of Certificates defines for the given hostname.
               There can be defined up to fifteen certificates in each Certificate Map Entry.
               Each certificate must match pattern projects/*/locations/*/certificates/*.
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[builtins.str] hostname: A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
               for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
               selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with a Certificate Map Entry.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] map: A map entry that is inputted into the cetrificate map
        :param pulumi.Input[builtins.str] matcher: A predefined matcher for particular cases, other than SNI selection
        :param pulumi.Input[builtins.str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry
               names must be unique globally and match pattern
               'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateMapEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        CertificateMapEntry is a list of certificate configurations,
        that have been issued for a particular hostname

        ## Example Usage

        ### Certificate Manager Certificate Map Entry Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        certificate_map = gcp.certificatemanager.CertificateMap("certificate_map",
            name="cert-map-entry",
            description="My acceptance test certificate map",
            labels={
                "terraform": "true",
                "acc-test": "true",
            })
        instance = gcp.certificatemanager.DnsAuthorization("instance",
            name="dns-auth",
            description="The default dnss",
            domain="subdomain.hashicorptest.com")
        instance2 = gcp.certificatemanager.DnsAuthorization("instance2",
            name="dns-auth2",
            description="The default dnss",
            domain="subdomain2.hashicorptest.com")
        certificate = gcp.certificatemanager.Certificate("certificate",
            name="cert-map-entry",
            description="The default cert",
            scope="DEFAULT",
            managed={
                "domains": [
                    instance.domain,
                    instance2.domain,
                ],
                "dns_authorizations": [
                    instance.id,
                    instance2.id,
                ],
            })
        default = gcp.certificatemanager.CertificateMapEntry("default",
            name="cert-map-entry",
            description="My acceptance test certificate map entry",
            map=certificate_map.name,
            labels={
                "terraform": "true",
                "acc-test": "true",
            },
            certificates=[certificate.id],
            matcher="PRIMARY")
        ```

        ## Import

        CertificateMapEntry can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/global/certificateMaps/{{map}}/certificateMapEntries/{{name}}`

        * `{{project}}/{{map}}/{{name}}`

        * `{{map}}/{{name}}`

        When using the `pulumi import` command, CertificateMapEntry can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default projects/{{project}}/locations/global/certificateMaps/{{map}}/certificateMapEntries/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default {{project}}/{{map}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/certificateMapEntry:CertificateMapEntry default {{map}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param CertificateMapEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateMapEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 matcher: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateMapEntryArgs.__new__(CertificateMapEntryArgs)

            if certificates is None and not opts.urn:
                raise TypeError("Missing required property 'certificates'")
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["description"] = description
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["labels"] = labels
            if map is None and not opts.urn:
                raise TypeError("Missing required property 'map'")
            __props__.__dict__["map"] = map
            __props__.__dict__["matcher"] = matcher
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CertificateMapEntry, __self__).__init__(
            'gcp:certificatemanager/certificateMapEntry:CertificateMapEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            map: Optional[pulumi.Input[builtins.str]] = None,
            matcher: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'CertificateMapEntry':
        """
        Get an existing CertificateMapEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] certificates: A set of Certificates defines for the given hostname.
               There can be defined up to fifteen certificates in each Certificate Map Entry.
               Each certificate must match pattern projects/*/locations/*/certificates/*.
        :param pulumi.Input[builtins.str] create_time: Creation timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] description: A human-readable description of the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] hostname: A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
               for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
               selecting a proper certificate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Set of labels associated with a Certificate Map Entry.
               An object containing a list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] map: A map entry that is inputted into the cetrificate map
        :param pulumi.Input[builtins.str] matcher: A predefined matcher for particular cases, other than SNI selection
        :param pulumi.Input[builtins.str] name: A user-defined name of the Certificate Map Entry. Certificate Map Entry
               names must be unique globally and match pattern
               'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: A serving state of this Certificate Map Entry.
        :param pulumi.Input[builtins.str] update_time: Update timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
               with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateMapEntryState.__new__(_CertificateMapEntryState)

        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["labels"] = labels
        __props__.__dict__["map"] = map
        __props__.__dict__["matcher"] = matcher
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        __props__.__dict__["update_time"] = update_time
        return CertificateMapEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        A set of Certificates defines for the given hostname.
        There can be defined up to fifteen certificates in each Certificate Map Entry.
        Each certificate must match pattern projects/*/locations/*/certificates/*.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human-readable description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
        for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
        selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Set of labels associated with a Certificate Map Entry.
        An object containing a list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def map(self) -> pulumi.Output[builtins.str]:
        """
        A map entry that is inputted into the cetrificate map
        """
        return pulumi.get(self, "map")

    @property
    @pulumi.getter
    def matcher(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A predefined matcher for particular cases, other than SNI selection
        """
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry
        names must be unique globally and match pattern
        'projects/*/locations/*/certificateMaps/*/certificateMapEntries/*'
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        A serving state of this Certificate Map Entry.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Update timestamp of a Certificate Map Entry. Timestamp in RFC3339 UTC "Zulu" format,
        with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

