# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataAccessLabelArgs', 'DataAccessLabel']

@pulumi.input_type
class DataAccessLabelArgs:
    def __init__(__self__, *,
                 data_access_label_id: pulumi.Input[builtins.str],
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 udm_query: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataAccessLabel resource.
        :param pulumi.Input[builtins.str] data_access_label_id: Required. The ID to use for the data access label, which will become the label's
               display name and the final component of the label's resource name. The
               maximum number of characters should be 63. Regex pattern is as per AIP:
               https://google.aip.dev/122#resource-id-segments
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] udm_query: A UDM query over event data.
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access label for a human reader.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_access_label_id", data_access_label_id)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "udm_query", udm_query)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataAccessLabelId")
    def data_access_label_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The ID to use for the data access label, which will become the label's
        display name and the final component of the label's resource name. The
        maximum number of characters should be 63. Regex pattern is as per AIP:
        https://google.aip.dev/122#resource-id-segments
        """
        return pulumi.get(self, "data_access_label_id")

    @data_access_label_id.setter
    def data_access_label_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_access_label_id", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="udmQuery")
    def udm_query(self) -> pulumi.Input[builtins.str]:
        """
        A UDM query over event data.
        """
        return pulumi.get(self, "udm_query")

    @udm_query.setter
    def udm_query(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "udm_query", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A description of the data access label for a human reader.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DataAccessLabelState:
    def __init__(__self__, *,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_access_label_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 last_editor: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 udm_query: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataAccessLabel resources.
        :param pulumi.Input[builtins.str] author: Output only. The user who created the data access label.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the data access label was created.
        :param pulumi.Input[builtins.str] data_access_label_id: Required. The ID to use for the data access label, which will become the label's
               display name and the final component of the label's resource name. The
               maximum number of characters should be 63. Regex pattern is as per AIP:
               https://google.aip.dev/122#resource-id-segments
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access label for a human reader.
        :param pulumi.Input[builtins.str] display_name: Output only. The short name displayed for the label as it appears on event data. This is same as data access label id.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] last_editor: Output only. The user who last updated the data access label.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: The unique resource name of the data access label. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label_id}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] udm_query: A UDM query over event data.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which the data access label was last updated.
        """
        if author is not None:
            pulumi.set(__self__, "author", author)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_access_label_id is not None:
            pulumi.set(__self__, "data_access_label_id", data_access_label_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if last_editor is not None:
            pulumi.set(__self__, "last_editor", last_editor)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if udm_query is not None:
            pulumi.set(__self__, "udm_query", udm_query)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The user who created the data access label.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the data access label was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataAccessLabelId")
    def data_access_label_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The ID to use for the data access label, which will become the label's
        display name and the final component of the label's resource name. The
        maximum number of characters should be 63. Regex pattern is as per AIP:
        https://google.aip.dev/122#resource-id-segments
        """
        return pulumi.get(self, "data_access_label_id")

    @data_access_label_id.setter
    def data_access_label_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_access_label_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A description of the data access label for a human reader.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The short name displayed for the label as it appears on event data. This is same as data access label id.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The user who last updated the data access label.
        """
        return pulumi.get(self, "last_editor")

    @last_editor.setter
    def last_editor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_editor", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique resource name of the data access label. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="udmQuery")
    def udm_query(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A UDM query over event data.
        """
        return pulumi.get(self, "udm_query")

    @udm_query.setter
    def udm_query(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "udm_query", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the data access label was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:chronicle/dataAccessLabel:DataAccessLabel")
class DataAccessLabel(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_label_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 udm_query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A DataAccessLabel is a label on events to define user access to data.

        To get more information about DataAccessLabel, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.dataAccessLabels)
        * How-to Guides
            * [Introduction to data RBAC](https://cloud.google.com/chronicle/docs/onboard/onboard-datarbac)

        ## Example Usage

        ### Chronicle Dataaccesslabel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessLabel("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"",
            description="label-description")
        ```

        ## Import

        DataAccessLabel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessLabels/{{data_access_label_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{data_access_label_id}}`

        * `{{location}}/{{instance}}/{{data_access_label_id}}`

        When using the `pulumi import` command, DataAccessLabel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessLabels/{{data_access_label_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default {{project}}/{{location}}/{{instance}}/{{data_access_label_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default {{location}}/{{instance}}/{{data_access_label_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] data_access_label_id: Required. The ID to use for the data access label, which will become the label's
               display name and the final component of the label's resource name. The
               maximum number of characters should be 63. Regex pattern is as per AIP:
               https://google.aip.dev/122#resource-id-segments
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access label for a human reader.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] udm_query: A UDM query over event data.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataAccessLabelArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A DataAccessLabel is a label on events to define user access to data.

        To get more information about DataAccessLabel, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.dataAccessLabels)
        * How-to Guides
            * [Introduction to data RBAC](https://cloud.google.com/chronicle/docs/onboard/onboard-datarbac)

        ## Example Usage

        ### Chronicle Dataaccesslabel Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessLabel("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"",
            description="label-description")
        ```

        ## Import

        DataAccessLabel can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessLabels/{{data_access_label_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{data_access_label_id}}`

        * `{{location}}/{{instance}}/{{data_access_label_id}}`

        When using the `pulumi import` command, DataAccessLabel can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessLabels/{{data_access_label_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default {{project}}/{{location}}/{{instance}}/{{data_access_label_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessLabel:DataAccessLabel default {{location}}/{{instance}}/{{data_access_label_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataAccessLabelArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAccessLabelArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_access_label_id: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 udm_query: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAccessLabelArgs.__new__(DataAccessLabelArgs)

            if data_access_label_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_label_id'")
            __props__.__dict__["data_access_label_id"] = data_access_label_id
            __props__.__dict__["description"] = description
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            if udm_query is None and not opts.urn:
                raise TypeError("Missing required property 'udm_query'")
            __props__.__dict__["udm_query"] = udm_query
            __props__.__dict__["author"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["last_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(DataAccessLabel, __self__).__init__(
            'gcp:chronicle/dataAccessLabel:DataAccessLabel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            author: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_access_label_id: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            last_editor: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            udm_query: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'DataAccessLabel':
        """
        Get an existing DataAccessLabel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] author: Output only. The user who created the data access label.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the data access label was created.
        :param pulumi.Input[builtins.str] data_access_label_id: Required. The ID to use for the data access label, which will become the label's
               display name and the final component of the label's resource name. The
               maximum number of characters should be 63. Regex pattern is as per AIP:
               https://google.aip.dev/122#resource-id-segments
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access label for a human reader.
        :param pulumi.Input[builtins.str] display_name: Output only. The short name displayed for the label as it appears on event data. This is same as data access label id.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] last_editor: Output only. The user who last updated the data access label.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: The unique resource name of the data access label. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label_id}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] udm_query: A UDM query over event data.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which the data access label was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataAccessLabelState.__new__(_DataAccessLabelState)

        __props__.__dict__["author"] = author
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_access_label_id"] = data_access_label_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["instance"] = instance
        __props__.__dict__["last_editor"] = last_editor
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["udm_query"] = udm_query
        __props__.__dict__["update_time"] = update_time
        return DataAccessLabel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The user who created the data access label.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the data access label was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataAccessLabelId")
    def data_access_label_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The ID to use for the data access label, which will become the label's
        display name and the final component of the label's resource name. The
        maximum number of characters should be 63. Regex pattern is as per AIP:
        https://google.aip.dev/122#resource-id-segments
        """
        return pulumi.get(self, "data_access_label_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. A description of the data access label for a human reader.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The short name displayed for the label as it appears on event data. This is same as data access label id.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The user who last updated the data access label.
        """
        return pulumi.get(self, "last_editor")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique resource name of the data access label. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="udmQuery")
    def udm_query(self) -> pulumi.Output[builtins.str]:
        """
        A UDM query over event data.
        """
        return pulumi.get(self, "udm_query")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the data access label was last updated.
        """
        return pulumi.get(self, "update_time")

