# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataAccessScopeArgs', 'DataAccessScope']

@pulumi.input_type
class DataAccessScopeArgs:
    def __init__(__self__, *,
                 data_access_scope_id: pulumi.Input[builtins.str],
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 allow_all: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]] = None,
                 denied_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DataAccessScope resource.
        :param pulumi.Input[builtins.str] data_access_scope_id: Required. The user provided scope id which will become the last part of the name
               of the scope resource.
               Needs to be compliant with https://google.aip.dev/122
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.bool] allow_all: Optional. Whether or not the scope allows all labels, allow_all and
               allowed_data_access_labels are mutually exclusive and one of them must be
               present. denied_data_access_labels can still be used along with allow_all.
               When combined with denied_data_access_labels, access will be granted to all
               data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
               A customer with scope with denied labels A and B and allow_all will be able
               to see all data except data labeled with A and data labeled with B and data
               with labels A and B.
        :param pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]] allowed_data_access_labels: The allowed labels for the scope. There has to be at
               least one label allowed for the scope to be valid.
               The logical operator for evaluation of the allowed labels is OR.
               Either allow_all or allowed_data_access_labels needs to be provided.
               E.g.: A customer with scope with allowed labels A and B will be able
               to see data with labeled with A or B or (A and B).
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]] denied_data_access_labels: Optional. The denied labels for the scope.
               The logical operator for evaluation of the denied labels is AND.
               E.g.: A customer with scope with denied labels A and B won't be able
               to see data labeled with A and data labeled with B
               and data with labels A and B.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access scope for a human reader.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "data_access_scope_id", data_access_scope_id)
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        if allow_all is not None:
            pulumi.set(__self__, "allow_all", allow_all)
        if allowed_data_access_labels is not None:
            pulumi.set(__self__, "allowed_data_access_labels", allowed_data_access_labels)
        if denied_data_access_labels is not None:
            pulumi.set(__self__, "denied_data_access_labels", denied_data_access_labels)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="dataAccessScopeId")
    def data_access_scope_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The user provided scope id which will become the last part of the name
        of the scope resource.
        Needs to be compliant with https://google.aip.dev/122
        """
        return pulumi.get(self, "data_access_scope_id")

    @data_access_scope_id.setter
    def data_access_scope_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "data_access_scope_id", value)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="allowAll")
    def allow_all(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. Whether or not the scope allows all labels, allow_all and
        allowed_data_access_labels are mutually exclusive and one of them must be
        present. denied_data_access_labels can still be used along with allow_all.
        When combined with denied_data_access_labels, access will be granted to all
        data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
        A customer with scope with denied labels A and B and allow_all will be able
        to see all data except data labeled with A and data labeled with B and data
        with labels A and B.
        """
        return pulumi.get(self, "allow_all")

    @allow_all.setter
    def allow_all(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_all", value)

    @property
    @pulumi.getter(name="allowedDataAccessLabels")
    def allowed_data_access_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]]:
        """
        The allowed labels for the scope. There has to be at
        least one label allowed for the scope to be valid.
        The logical operator for evaluation of the allowed labels is OR.
        Either allow_all or allowed_data_access_labels needs to be provided.
        E.g.: A customer with scope with allowed labels A and B will be able
        to see data with labeled with A or B or (A and B).
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_data_access_labels")

    @allowed_data_access_labels.setter
    def allowed_data_access_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]]):
        pulumi.set(self, "allowed_data_access_labels", value)

    @property
    @pulumi.getter(name="deniedDataAccessLabels")
    def denied_data_access_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]]:
        """
        Optional. The denied labels for the scope.
        The logical operator for evaluation of the denied labels is AND.
        E.g.: A customer with scope with denied labels A and B won't be able
        to see data labeled with A and data labeled with B
        and data with labels A and B.
        Structure is documented below.
        """
        return pulumi.get(self, "denied_data_access_labels")

    @denied_data_access_labels.setter
    def denied_data_access_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]]):
        pulumi.set(self, "denied_data_access_labels", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A description of the data access scope for a human reader.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _DataAccessScopeState:
    def __init__(__self__, *,
                 allow_all: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]] = None,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_access_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 denied_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 last_editor: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataAccessScope resources.
        :param pulumi.Input[builtins.bool] allow_all: Optional. Whether or not the scope allows all labels, allow_all and
               allowed_data_access_labels are mutually exclusive and one of them must be
               present. denied_data_access_labels can still be used along with allow_all.
               When combined with denied_data_access_labels, access will be granted to all
               data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
               A customer with scope with denied labels A and B and allow_all will be able
               to see all data except data labeled with A and data labeled with B and data
               with labels A and B.
        :param pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]] allowed_data_access_labels: The allowed labels for the scope. There has to be at
               least one label allowed for the scope to be valid.
               The logical operator for evaluation of the allowed labels is OR.
               Either allow_all or allowed_data_access_labels needs to be provided.
               E.g.: A customer with scope with allowed labels A and B will be able
               to see data with labeled with A or B or (A and B).
               Structure is documented below.
        :param pulumi.Input[builtins.str] author: Output only. The user who created the data access scope.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the data access scope was created.
        :param pulumi.Input[builtins.str] data_access_scope_id: Required. The user provided scope id which will become the last part of the name
               of the scope resource.
               Needs to be compliant with https://google.aip.dev/122
        :param pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]] denied_data_access_labels: Optional. The denied labels for the scope.
               The logical operator for evaluation of the denied labels is AND.
               E.g.: A customer with scope with denied labels A and B won't be able
               to see data labeled with A and data labeled with B
               and data with labels A and B.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access scope for a human reader.
        :param pulumi.Input[builtins.str] display_name: Output only. The name to be used for display to customers of the data access scope.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] last_editor: Output only. The user who last updated the data access scope.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: The unique full name of the data access scope. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope_id}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which the data access scope was last updated.
        """
        if allow_all is not None:
            pulumi.set(__self__, "allow_all", allow_all)
        if allowed_data_access_labels is not None:
            pulumi.set(__self__, "allowed_data_access_labels", allowed_data_access_labels)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_access_scope_id is not None:
            pulumi.set(__self__, "data_access_scope_id", data_access_scope_id)
        if denied_data_access_labels is not None:
            pulumi.set(__self__, "denied_data_access_labels", denied_data_access_labels)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if last_editor is not None:
            pulumi.set(__self__, "last_editor", last_editor)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="allowAll")
    def allow_all(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. Whether or not the scope allows all labels, allow_all and
        allowed_data_access_labels are mutually exclusive and one of them must be
        present. denied_data_access_labels can still be used along with allow_all.
        When combined with denied_data_access_labels, access will be granted to all
        data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
        A customer with scope with denied labels A and B and allow_all will be able
        to see all data except data labeled with A and data labeled with B and data
        with labels A and B.
        """
        return pulumi.get(self, "allow_all")

    @allow_all.setter
    def allow_all(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_all", value)

    @property
    @pulumi.getter(name="allowedDataAccessLabels")
    def allowed_data_access_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]]:
        """
        The allowed labels for the scope. There has to be at
        least one label allowed for the scope to be valid.
        The logical operator for evaluation of the allowed labels is OR.
        Either allow_all or allowed_data_access_labels needs to be provided.
        E.g.: A customer with scope with allowed labels A and B will be able
        to see data with labeled with A or B or (A and B).
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_data_access_labels")

    @allowed_data_access_labels.setter
    def allowed_data_access_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeAllowedDataAccessLabelArgs']]]]):
        pulumi.set(self, "allowed_data_access_labels", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The user who created the data access scope.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the data access scope was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataAccessScopeId")
    def data_access_scope_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The user provided scope id which will become the last part of the name
        of the scope resource.
        Needs to be compliant with https://google.aip.dev/122
        """
        return pulumi.get(self, "data_access_scope_id")

    @data_access_scope_id.setter
    def data_access_scope_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_access_scope_id", value)

    @property
    @pulumi.getter(name="deniedDataAccessLabels")
    def denied_data_access_labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]]:
        """
        Optional. The denied labels for the scope.
        The logical operator for evaluation of the denied labels is AND.
        E.g.: A customer with scope with denied labels A and B won't be able
        to see data labeled with A and data labeled with B
        and data with labels A and B.
        Structure is documented below.
        """
        return pulumi.get(self, "denied_data_access_labels")

    @denied_data_access_labels.setter
    def denied_data_access_labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DataAccessScopeDeniedDataAccessLabelArgs']]]]):
        pulumi.set(self, "denied_data_access_labels", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A description of the data access scope for a human reader.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The name to be used for display to customers of the data access scope.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The user who last updated the data access scope.
        """
        return pulumi.get(self, "last_editor")

    @last_editor.setter
    def last_editor(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_editor", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique full name of the data access scope. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which the data access scope was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:chronicle/dataAccessScope:DataAccessScope")
class DataAccessScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_all: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeAllowedDataAccessLabelArgs', 'DataAccessScopeAllowedDataAccessLabelArgsDict']]]]] = None,
                 data_access_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 denied_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeDeniedDataAccessLabelArgs', 'DataAccessScopeDeniedDataAccessLabelArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A DataAccessScope is a boolean expression of data access labels used to restrict access to data for users.

        To get more information about DataAccessScope, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.dataAccessScopes)
        * How-to Guides
            * [Introduction to data RBAC](https://cloud.google.com/chronicle/docs/onboard/onboard-datarbac)

        ## Example Usage

        ### Chronicle Dataaccessscope With Logtype

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[
                {
                    "log_type": "GCP_CLOUDAUDIT",
                },
                {
                    "log_type": "GITHUB",
                },
            ])
        ```
        ### Chronicle Dataaccessscope With Dataaccesslabel

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_data_access_label = gcp.chronicle.DataAccessLabel("custom_data_access_label",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"")
        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "data_access_label": google_chronicle_data_access_label["customDataAccessLabel"]["dataAccessLabelId"],
            }])
        ```
        ### Chronicle Dataaccessscope With Asset Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "asset_namespace": "my-namespace",
            }])
        ```
        ### Chronicle Dataaccessscope With Ingestion Label

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "ingestion_label": {
                    "ingestion_label_key": "ingestion_key",
                    "ingestion_label_value": "ingestion_value",
                },
            }])
        ```
        ### Chronicle Dataaccessscope With Denied Labels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_data_access_label = gcp.chronicle.DataAccessLabel("custom_data_access_label",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"")
        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allow_all=True,
            denied_data_access_labels=[
                {
                    "log_type": "GCP_CLOUDAUDIT",
                },
                {
                    "data_access_label": google_chronicle_data_access_label["customDataAccessLabel"]["dataAccessLabelId"],
                },
                {
                    "ingestion_label": {
                        "ingestion_label_key": "ingestion_key",
                        "ingestion_label_value": "ingestion_value",
                    },
                },
                {
                    "asset_namespace": "my-namespace",
                },
            ])
        ```

        ## Import

        DataAccessScope can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessScopes/{{data_access_scope_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{data_access_scope_id}}`

        * `{{location}}/{{instance}}/{{data_access_scope_id}}`

        When using the `pulumi import` command, DataAccessScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessScopes/{{data_access_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default {{project}}/{{location}}/{{instance}}/{{data_access_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default {{location}}/{{instance}}/{{data_access_scope_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_all: Optional. Whether or not the scope allows all labels, allow_all and
               allowed_data_access_labels are mutually exclusive and one of them must be
               present. denied_data_access_labels can still be used along with allow_all.
               When combined with denied_data_access_labels, access will be granted to all
               data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
               A customer with scope with denied labels A and B and allow_all will be able
               to see all data except data labeled with A and data labeled with B and data
               with labels A and B.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeAllowedDataAccessLabelArgs', 'DataAccessScopeAllowedDataAccessLabelArgsDict']]]] allowed_data_access_labels: The allowed labels for the scope. There has to be at
               least one label allowed for the scope to be valid.
               The logical operator for evaluation of the allowed labels is OR.
               Either allow_all or allowed_data_access_labels needs to be provided.
               E.g.: A customer with scope with allowed labels A and B will be able
               to see data with labeled with A or B or (A and B).
               Structure is documented below.
        :param pulumi.Input[builtins.str] data_access_scope_id: Required. The user provided scope id which will become the last part of the name
               of the scope resource.
               Needs to be compliant with https://google.aip.dev/122
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeDeniedDataAccessLabelArgs', 'DataAccessScopeDeniedDataAccessLabelArgsDict']]]] denied_data_access_labels: Optional. The denied labels for the scope.
               The logical operator for evaluation of the denied labels is AND.
               E.g.: A customer with scope with denied labels A and B won't be able
               to see data labeled with A and data labeled with B
               and data with labels A and B.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access scope for a human reader.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataAccessScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A DataAccessScope is a boolean expression of data access labels used to restrict access to data for users.

        To get more information about DataAccessScope, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.dataAccessScopes)
        * How-to Guides
            * [Introduction to data RBAC](https://cloud.google.com/chronicle/docs/onboard/onboard-datarbac)

        ## Example Usage

        ### Chronicle Dataaccessscope With Logtype

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[
                {
                    "log_type": "GCP_CLOUDAUDIT",
                },
                {
                    "log_type": "GITHUB",
                },
            ])
        ```
        ### Chronicle Dataaccessscope With Dataaccesslabel

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_data_access_label = gcp.chronicle.DataAccessLabel("custom_data_access_label",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"")
        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "data_access_label": google_chronicle_data_access_label["customDataAccessLabel"]["dataAccessLabelId"],
            }])
        ```
        ### Chronicle Dataaccessscope With Asset Namespace

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "asset_namespace": "my-namespace",
            }])
        ```
        ### Chronicle Dataaccessscope With Ingestion Label

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allowed_data_access_labels=[{
                "ingestion_label": {
                    "ingestion_label_key": "ingestion_key",
                    "ingestion_label_value": "ingestion_value",
                },
            }])
        ```
        ### Chronicle Dataaccessscope With Denied Labels

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_data_access_label = gcp.chronicle.DataAccessLabel("custom_data_access_label",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_label_id="label-id",
            udm_query="principal.hostname=\\"google.com\\"")
        example = gcp.chronicle.DataAccessScope("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-id",
            description="scope-description",
            allow_all=True,
            denied_data_access_labels=[
                {
                    "log_type": "GCP_CLOUDAUDIT",
                },
                {
                    "data_access_label": google_chronicle_data_access_label["customDataAccessLabel"]["dataAccessLabelId"],
                },
                {
                    "ingestion_label": {
                        "ingestion_label_key": "ingestion_key",
                        "ingestion_label_value": "ingestion_value",
                    },
                },
                {
                    "asset_namespace": "my-namespace",
                },
            ])
        ```

        ## Import

        DataAccessScope can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessScopes/{{data_access_scope_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{data_access_scope_id}}`

        * `{{location}}/{{instance}}/{{data_access_scope_id}}`

        When using the `pulumi import` command, DataAccessScope can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default projects/{{project}}/locations/{{location}}/instances/{{instance}}/dataAccessScopes/{{data_access_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default {{project}}/{{location}}/{{instance}}/{{data_access_scope_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/dataAccessScope:DataAccessScope default {{location}}/{{instance}}/{{data_access_scope_id}}
        ```

        :param str resource_name: The name of the resource.
        :param DataAccessScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataAccessScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_all: Optional[pulumi.Input[builtins.bool]] = None,
                 allowed_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeAllowedDataAccessLabelArgs', 'DataAccessScopeAllowedDataAccessLabelArgsDict']]]]] = None,
                 data_access_scope_id: Optional[pulumi.Input[builtins.str]] = None,
                 denied_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeDeniedDataAccessLabelArgs', 'DataAccessScopeDeniedDataAccessLabelArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataAccessScopeArgs.__new__(DataAccessScopeArgs)

            __props__.__dict__["allow_all"] = allow_all
            __props__.__dict__["allowed_data_access_labels"] = allowed_data_access_labels
            if data_access_scope_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_access_scope_id'")
            __props__.__dict__["data_access_scope_id"] = data_access_scope_id
            __props__.__dict__["denied_data_access_labels"] = denied_data_access_labels
            __props__.__dict__["description"] = description
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["author"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["last_editor"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(DataAccessScope, __self__).__init__(
            'gcp:chronicle/dataAccessScope:DataAccessScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_all: Optional[pulumi.Input[builtins.bool]] = None,
            allowed_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeAllowedDataAccessLabelArgs', 'DataAccessScopeAllowedDataAccessLabelArgsDict']]]]] = None,
            author: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_access_scope_id: Optional[pulumi.Input[builtins.str]] = None,
            denied_data_access_labels: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeDeniedDataAccessLabelArgs', 'DataAccessScopeDeniedDataAccessLabelArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            last_editor: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'DataAccessScope':
        """
        Get an existing DataAccessScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allow_all: Optional. Whether or not the scope allows all labels, allow_all and
               allowed_data_access_labels are mutually exclusive and one of them must be
               present. denied_data_access_labels can still be used along with allow_all.
               When combined with denied_data_access_labels, access will be granted to all
               data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
               A customer with scope with denied labels A and B and allow_all will be able
               to see all data except data labeled with A and data labeled with B and data
               with labels A and B.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeAllowedDataAccessLabelArgs', 'DataAccessScopeAllowedDataAccessLabelArgsDict']]]] allowed_data_access_labels: The allowed labels for the scope. There has to be at
               least one label allowed for the scope to be valid.
               The logical operator for evaluation of the allowed labels is OR.
               Either allow_all or allowed_data_access_labels needs to be provided.
               E.g.: A customer with scope with allowed labels A and B will be able
               to see data with labeled with A or B or (A and B).
               Structure is documented below.
        :param pulumi.Input[builtins.str] author: Output only. The user who created the data access scope.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which the data access scope was created.
        :param pulumi.Input[builtins.str] data_access_scope_id: Required. The user provided scope id which will become the last part of the name
               of the scope resource.
               Needs to be compliant with https://google.aip.dev/122
        :param pulumi.Input[Sequence[pulumi.Input[Union['DataAccessScopeDeniedDataAccessLabelArgs', 'DataAccessScopeDeniedDataAccessLabelArgsDict']]]] denied_data_access_labels: Optional. The denied labels for the scope.
               The logical operator for evaluation of the denied labels is AND.
               E.g.: A customer with scope with denied labels A and B won't be able
               to see data labeled with A and data labeled with B
               and data with labels A and B.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: Optional. A description of the data access scope for a human reader.
        :param pulumi.Input[builtins.str] display_name: Output only. The name to be used for display to customers of the data access scope.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] last_editor: Output only. The user who last updated the data access scope.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] name: The unique full name of the data access scope. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope_id}
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which the data access scope was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataAccessScopeState.__new__(_DataAccessScopeState)

        __props__.__dict__["allow_all"] = allow_all
        __props__.__dict__["allowed_data_access_labels"] = allowed_data_access_labels
        __props__.__dict__["author"] = author
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_access_scope_id"] = data_access_scope_id
        __props__.__dict__["denied_data_access_labels"] = denied_data_access_labels
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["instance"] = instance
        __props__.__dict__["last_editor"] = last_editor
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return DataAccessScope(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowAll")
    def allow_all(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional. Whether or not the scope allows all labels, allow_all and
        allowed_data_access_labels are mutually exclusive and one of them must be
        present. denied_data_access_labels can still be used along with allow_all.
        When combined with denied_data_access_labels, access will be granted to all
        data that doesn't have labels mentioned in denied_data_access_labels. E.g.:
        A customer with scope with denied labels A and B and allow_all will be able
        to see all data except data labeled with A and data labeled with B and data
        with labels A and B.
        """
        return pulumi.get(self, "allow_all")

    @property
    @pulumi.getter(name="allowedDataAccessLabels")
    def allowed_data_access_labels(self) -> pulumi.Output[Optional[Sequence['outputs.DataAccessScopeAllowedDataAccessLabel']]]:
        """
        The allowed labels for the scope. There has to be at
        least one label allowed for the scope to be valid.
        The logical operator for evaluation of the allowed labels is OR.
        Either allow_all or allowed_data_access_labels needs to be provided.
        E.g.: A customer with scope with allowed labels A and B will be able
        to see data with labeled with A or B or (A and B).
        Structure is documented below.
        """
        return pulumi.get(self, "allowed_data_access_labels")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The user who created the data access scope.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the data access scope was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataAccessScopeId")
    def data_access_scope_id(self) -> pulumi.Output[builtins.str]:
        """
        Required. The user provided scope id which will become the last part of the name
        of the scope resource.
        Needs to be compliant with https://google.aip.dev/122
        """
        return pulumi.get(self, "data_access_scope_id")

    @property
    @pulumi.getter(name="deniedDataAccessLabels")
    def denied_data_access_labels(self) -> pulumi.Output[Optional[Sequence['outputs.DataAccessScopeDeniedDataAccessLabel']]]:
        """
        Optional. The denied labels for the scope.
        The logical operator for evaluation of the denied labels is AND.
        E.g.: A customer with scope with denied labels A and B won't be able
        to see data labeled with A and data labeled with B
        and data with labels A and B.
        Structure is documented below.
        """
        return pulumi.get(self, "denied_data_access_labels")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. A description of the data access scope for a human reader.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The name to be used for display to customers of the data access scope.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter(name="lastEditor")
    def last_editor(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The user who last updated the data access scope.
        """
        return pulumi.get(self, "last_editor")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The unique full name of the data access scope. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{data_access_scope_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which the data access scope was last updated.
        """
        return pulumi.get(self, "update_time")

