# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 instance: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the rule should be deleted forcefully.
               If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
               will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
               rule has no associated retrohunts, including completed retrohunts, and no
               associated detections. Regardless of this field's value, the rule
               deployment associated with this rule will also be deleted.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] etag: The etag for this rule.
               If this is provided on update, the request will succeed if and only if it
               matches the server-computed value, and will fail with an ABORTED error
               otherwise.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] rule_id: Rule Id is the ID of the Rule.
        :param pulumi.Input[builtins.str] scope: Resource name of the DataAccessScope bound to this rule.
               Populated in BASIC view and FULL view.
               If reference lists are used in the rule, validations will be performed
               against this scope to ensure that the reference lists are compatible with
               both the user's and the rule's scopes.
               The scope should be in the format:
               "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        :param pulumi.Input[builtins.str] text: The YARA-L content of the rule.
               Populated in FULL view.
        """
        pulumi.set(__self__, "instance", instance)
        pulumi.set(__self__, "location", location)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Input[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine if the rule should be deleted forcefully.
        If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
        will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
        rule has no associated retrohunts, including completed retrohunts, and no
        associated detections. Regardless of this field's value, the rule
        deployment associated with this rule will also be deleted.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The etag for this rule.
        If this is provided on update, the request will succeed if and only if it
        matches the server-computed value, and will fail with an ABORTED error
        otherwise.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule Id is the ID of the Rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the DataAccessScope bound to this rule.
        Populated in BASIC view and FULL view.
        If reference lists are used in the rule, validations will be performed
        against this scope to ensure that the reference lists are compatible with
        both the user's and the rule's scopes.
        The scope should be in the format:
        "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The YARA-L content of the rule.
        Populated in FULL view.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 allowed_run_frequencies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 author: Optional[pulumi.Input[builtins.str]] = None,
                 compilation_diagnostics: Optional[pulumi.Input[Sequence[pulumi.Input['RuleCompilationDiagnosticArgs']]]] = None,
                 compilation_state: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 data_tables: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 near_real_time_live_rule_eligible: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 revision_create_time: Optional[pulumi.Input[builtins.str]] = None,
                 revision_id: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 severities: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSeverityArgs']]]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_run_frequencies: Output only. The run frequencies that are allowed for the rule.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] author: Output only. The author of the rule. Extracted from the meta section of text.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[Sequence[pulumi.Input['RuleCompilationDiagnosticArgs']]] compilation_diagnostics: Output only. A list of a rule's corresponding compilation diagnostic messages
               such as compilation errors and compilation warnings.
               Populated in FULL view.
               Structure is documented below.
        :param pulumi.Input[builtins.str] compilation_state: Output only. The current compilation state of the rule.
               Populated in FULL view.
               Possible values:
               COMPILATION_STATE_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp of when the rule was created.
               Populated in FULL view.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_tables: Output only. Resource names of the data tables used in this rule.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the rule should be deleted forcefully.
               If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
               will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
               rule has no associated retrohunts, including completed retrohunts, and no
               associated detections. Regardless of this field's value, the rule
               deployment associated with this rule will also be deleted.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: The display name of the severity level. Extracted from the meta section of
               the rule text.
        :param pulumi.Input[builtins.str] etag: The etag for this rule.
               If this is provided on update, the request will succeed if and only if it
               matches the server-computed value, and will fail with an ABORTED error
               otherwise.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Output only. Additional metadata specified in the meta section of text.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] name: Full resource name for the rule. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[builtins.bool] near_real_time_live_rule_eligible: Output only. Indicate the rule can run in near real time live rule.
               If this is true, the rule uses the near real time live rule when the run
               frequency is set to LIVE.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] reference_lists: Output only. Resource names of the reference lists used in this rule.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] revision_create_time: Output only. The timestamp of when the rule revision was created.
               Populated in FULL, REVISION_METADATA_ONLY views.
        :param pulumi.Input[builtins.str] revision_id: Output only. The revision ID of the rule.
               A new revision is created whenever the rule text is changed in any way.
               Format: v_{10 digits}_{9 digits}
               Populated in REVISION_METADATA_ONLY view and FULL view.
        :param pulumi.Input[builtins.str] rule_id: Rule Id is the ID of the Rule.
        :param pulumi.Input[builtins.str] scope: Resource name of the DataAccessScope bound to this rule.
               Populated in BASIC view and FULL view.
               If reference lists are used in the rule, validations will be performed
               against this scope to ensure that the reference lists are compatible with
               both the user's and the rule's scopes.
               The scope should be in the format:
               "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        :param pulumi.Input[Sequence[pulumi.Input['RuleSeverityArgs']]] severities: (Output)
               Output only. The severity of a rule's compilation diagnostic.
               Possible values:
               SEVERITY_UNSPECIFIED
               WARNING
               ERROR
        :param pulumi.Input[builtins.str] text: The YARA-L content of the rule.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] type: Possible values:
               RULE_TYPE_UNSPECIFIED
               SINGLE_EVENT
               MULTI_EVENT
        """
        if allowed_run_frequencies is not None:
            pulumi.set(__self__, "allowed_run_frequencies", allowed_run_frequencies)
        if author is not None:
            pulumi.set(__self__, "author", author)
        if compilation_diagnostics is not None:
            pulumi.set(__self__, "compilation_diagnostics", compilation_diagnostics)
        if compilation_state is not None:
            pulumi.set(__self__, "compilation_state", compilation_state)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_tables is not None:
            pulumi.set(__self__, "data_tables", data_tables)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if near_real_time_live_rule_eligible is not None:
            pulumi.set(__self__, "near_real_time_live_rule_eligible", near_real_time_live_rule_eligible)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reference_lists is not None:
            pulumi.set(__self__, "reference_lists", reference_lists)
        if revision_create_time is not None:
            pulumi.set(__self__, "revision_create_time", revision_create_time)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if severities is not None:
            pulumi.set(__self__, "severities", severities)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="allowedRunFrequencies")
    def allowed_run_frequencies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. The run frequencies that are allowed for the rule.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "allowed_run_frequencies")

    @allowed_run_frequencies.setter
    def allowed_run_frequencies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "allowed_run_frequencies", value)

    @property
    @pulumi.getter
    def author(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The author of the rule. Extracted from the meta section of text.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "author")

    @author.setter
    def author(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "author", value)

    @property
    @pulumi.getter(name="compilationDiagnostics")
    def compilation_diagnostics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleCompilationDiagnosticArgs']]]]:
        """
        Output only. A list of a rule's corresponding compilation diagnostic messages
        such as compilation errors and compilation warnings.
        Populated in FULL view.
        Structure is documented below.
        """
        return pulumi.get(self, "compilation_diagnostics")

    @compilation_diagnostics.setter
    def compilation_diagnostics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleCompilationDiagnosticArgs']]]]):
        pulumi.set(self, "compilation_diagnostics", value)

    @property
    @pulumi.getter(name="compilationState")
    def compilation_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The current compilation state of the rule.
        Populated in FULL view.
        Possible values:
        COMPILATION_STATE_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "compilation_state")

    @compilation_state.setter
    def compilation_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compilation_state", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp of when the rule was created.
        Populated in FULL view.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataTables")
    def data_tables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. Resource names of the data tables used in this rule.
        """
        return pulumi.get(self, "data_tables")

    @data_tables.setter
    def data_tables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "data_tables", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine if the rule should be deleted forcefully.
        If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
        will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
        rule has no associated retrohunts, including completed retrohunts, and no
        associated detections. Regardless of this field's value, the rule
        deployment associated with this rule will also be deleted.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the severity level. Extracted from the meta section of
        the rule text.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The etag for this rule.
        If this is provided on update, the request will succeed if and only if it
        matches the server-computed value, and will fail with an ABORTED error
        otherwise.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Output only. Additional metadata specified in the meta section of text.
        Populated in FULL view.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Full resource name for the rule. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nearRealTimeLiveRuleEligible")
    def near_real_time_live_rule_eligible(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. Indicate the rule can run in near real time live rule.
        If this is true, the rule uses the near real time live rule when the run
        frequency is set to LIVE.
        """
        return pulumi.get(self, "near_real_time_live_rule_eligible")

    @near_real_time_live_rule_eligible.setter
    def near_real_time_live_rule_eligible(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "near_real_time_live_rule_eligible", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="referenceLists")
    def reference_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Output only. Resource names of the reference lists used in this rule.
        Populated in FULL view.
        """
        return pulumi.get(self, "reference_lists")

    @reference_lists.setter
    def reference_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "reference_lists", value)

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp of when the rule revision was created.
        Populated in FULL, REVISION_METADATA_ONLY views.
        """
        return pulumi.get(self, "revision_create_time")

    @revision_create_time.setter
    def revision_create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_create_time", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The revision ID of the rule.
        A new revision is created whenever the rule text is changed in any way.
        Format: v_{10 digits}_{9 digits}
        Populated in REVISION_METADATA_ONLY view and FULL view.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Rule Id is the ID of the Rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Resource name of the DataAccessScope bound to this rule.
        Populated in BASIC view and FULL view.
        If reference lists are used in the rule, validations will be performed
        against this scope to ensure that the reference lists are compatible with
        both the user's and the rule's scopes.
        The scope should be in the format:
        "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def severities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleSeverityArgs']]]]:
        """
        (Output)
        Output only. The severity of a rule's compilation diagnostic.
        Possible values:
        SEVERITY_UNSPECIFIED
        WARNING
        ERROR
        """
        return pulumi.get(self, "severities")

    @severities.setter
    def severities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleSeverityArgs']]]]):
        pulumi.set(self, "severities", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The YARA-L content of the rule.
        Populated in FULL view.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible values:
        RULE_TYPE_UNSPECIFIED
        SINGLE_EVENT
        MULTI_EVENT
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("gcp:chronicle/rule:Rule")
class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The Rule resource represents a user-created rule.

        To get more information about Rule, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.rules)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="DEFAULT",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```
        ### Chronicle Rule With Force Deletion

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="FORCE",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```
        ### Chronicle Rule With Data Access Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_access_scope_test = gcp.chronicle.DataAccessScope("data_access_scope_test",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-name",
            description="scope-description",
            allowed_data_access_labels=[{
                "log_type": "GCP_CLOUDAUDIT",
            }])
        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            scope=google_chronicle_data_access_scope["dataAccessScopeTest"]["name"],
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```

        ## Import

        Rule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{rule_id}}`

        * `{{location}}/{{instance}}/{{rule_id}}`

        When using the `pulumi import` command, Rule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default {{project}}/{{location}}/{{instance}}/{{rule_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default {{location}}/{{instance}}/{{rule_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the rule should be deleted forcefully.
               If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
               will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
               rule has no associated retrohunts, including completed retrohunts, and no
               associated detections. Regardless of this field's value, the rule
               deployment associated with this rule will also be deleted.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] etag: The etag for this rule.
               If this is provided on update, the request will succeed if and only if it
               matches the server-computed value, and will fail with an ABORTED error
               otherwise.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] rule_id: Rule Id is the ID of the Rule.
        :param pulumi.Input[builtins.str] scope: Resource name of the DataAccessScope bound to this rule.
               Populated in BASIC view and FULL view.
               If reference lists are used in the rule, validations will be performed
               against this scope to ensure that the reference lists are compatible with
               both the user's and the rule's scopes.
               The scope should be in the format:
               "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        :param pulumi.Input[builtins.str] text: The YARA-L content of the rule.
               Populated in FULL view.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Rule resource represents a user-created rule.

        To get more information about Rule, see:

        * [API documentation](https://cloud.google.com/chronicle/docs/reference/rest/v1/projects.locations.instances.rules)
        * How-to Guides
            * [Google SecOps Guides](https://cloud.google.com/chronicle/docs/secops/secops-overview)

        ## Example Usage

        ### Chronicle Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="DEFAULT",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```
        ### Chronicle Rule With Force Deletion

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            deletion_policy="FORCE",
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```
        ### Chronicle Rule With Data Access Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        data_access_scope_test = gcp.chronicle.DataAccessScope("data_access_scope_test",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            data_access_scope_id="scope-name",
            description="scope-description",
            allowed_data_access_labels=[{
                "log_type": "GCP_CLOUDAUDIT",
            }])
        example = gcp.chronicle.Rule("example",
            location="us",
            instance="00000000-0000-0000-0000-000000000000",
            scope=google_chronicle_data_access_scope["dataAccessScopeTest"]["name"],
            text="rule test_rule { meta: events:  $userid = $e.principal.user.userid  match: $userid over 10m condition: $e }\\n")
        ```

        ## Import

        Rule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule_id}}`

        * `{{project}}/{{location}}/{{instance}}/{{rule_id}}`

        * `{{location}}/{{instance}}/{{rule_id}}`

        When using the `pulumi import` command, Rule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default projects/{{project}}/locations/{{location}}/instances/{{instance}}/rules/{{rule_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default {{project}}/{{location}}/{{instance}}/{{rule_id}}
        ```

        ```sh
        $ pulumi import gcp:chronicle/rule:Rule default {{location}}/{{instance}}/{{rule_id}}
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 instance: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 text: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["etag"] = etag
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__.__dict__["instance"] = instance
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["rule_id"] = rule_id
            __props__.__dict__["scope"] = scope
            __props__.__dict__["text"] = text
            __props__.__dict__["allowed_run_frequencies"] = None
            __props__.__dict__["author"] = None
            __props__.__dict__["compilation_diagnostics"] = None
            __props__.__dict__["compilation_state"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_tables"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["near_real_time_live_rule_eligible"] = None
            __props__.__dict__["reference_lists"] = None
            __props__.__dict__["revision_create_time"] = None
            __props__.__dict__["revision_id"] = None
            __props__.__dict__["severities"] = None
            __props__.__dict__["type"] = None
        super(Rule, __self__).__init__(
            'gcp:chronicle/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_run_frequencies: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            author: Optional[pulumi.Input[builtins.str]] = None,
            compilation_diagnostics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleCompilationDiagnosticArgs', 'RuleCompilationDiagnosticArgsDict']]]]] = None,
            compilation_state: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            data_tables: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            instance: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            near_real_time_live_rule_eligible: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reference_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            revision_create_time: Optional[pulumi.Input[builtins.str]] = None,
            revision_id: Optional[pulumi.Input[builtins.str]] = None,
            rule_id: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            severities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RuleSeverityArgs', 'RuleSeverityArgsDict']]]]] = None,
            text: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] allowed_run_frequencies: Output only. The run frequencies that are allowed for the rule.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] author: Output only. The author of the rule. Extracted from the meta section of text.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleCompilationDiagnosticArgs', 'RuleCompilationDiagnosticArgsDict']]]] compilation_diagnostics: Output only. A list of a rule's corresponding compilation diagnostic messages
               such as compilation errors and compilation warnings.
               Populated in FULL view.
               Structure is documented below.
        :param pulumi.Input[builtins.str] compilation_state: Output only. The current compilation state of the rule.
               Populated in FULL view.
               Possible values:
               COMPILATION_STATE_UNSPECIFIED
               SUCCEEDED
               FAILED
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp of when the rule was created.
               Populated in FULL view.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] data_tables: Output only. Resource names of the data tables used in this rule.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine if the rule should be deleted forcefully.
               If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
               will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
               rule has no associated retrohunts, including completed retrohunts, and no
               associated detections. Regardless of this field's value, the rule
               deployment associated with this rule will also be deleted.
               Possible values: DEFAULT, FORCE
        :param pulumi.Input[builtins.str] display_name: The display name of the severity level. Extracted from the meta section of
               the rule text.
        :param pulumi.Input[builtins.str] etag: The etag for this rule.
               If this is provided on update, the request will succeed if and only if it
               matches the server-computed value, and will fail with an ABORTED error
               otherwise.
               Populated in BASIC view and FULL view.
        :param pulumi.Input[builtins.str] instance: The unique identifier for the Chronicle instance, which is the same as the customer ID.
        :param pulumi.Input[builtins.str] location: The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Output only. Additional metadata specified in the meta section of text.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] name: Full resource name for the rule. This unique identifier is generated using values provided for the URL parameters.
               Format:
               projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        :param pulumi.Input[builtins.bool] near_real_time_live_rule_eligible: Output only. Indicate the rule can run in near real time live rule.
               If this is true, the rule uses the near real time live rule when the run
               frequency is set to LIVE.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] reference_lists: Output only. Resource names of the reference lists used in this rule.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] revision_create_time: Output only. The timestamp of when the rule revision was created.
               Populated in FULL, REVISION_METADATA_ONLY views.
        :param pulumi.Input[builtins.str] revision_id: Output only. The revision ID of the rule.
               A new revision is created whenever the rule text is changed in any way.
               Format: v_{10 digits}_{9 digits}
               Populated in REVISION_METADATA_ONLY view and FULL view.
        :param pulumi.Input[builtins.str] rule_id: Rule Id is the ID of the Rule.
        :param pulumi.Input[builtins.str] scope: Resource name of the DataAccessScope bound to this rule.
               Populated in BASIC view and FULL view.
               If reference lists are used in the rule, validations will be performed
               against this scope to ensure that the reference lists are compatible with
               both the user's and the rule's scopes.
               The scope should be in the format:
               "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        :param pulumi.Input[Sequence[pulumi.Input[Union['RuleSeverityArgs', 'RuleSeverityArgsDict']]]] severities: (Output)
               Output only. The severity of a rule's compilation diagnostic.
               Possible values:
               SEVERITY_UNSPECIFIED
               WARNING
               ERROR
        :param pulumi.Input[builtins.str] text: The YARA-L content of the rule.
               Populated in FULL view.
        :param pulumi.Input[builtins.str] type: Possible values:
               RULE_TYPE_UNSPECIFIED
               SINGLE_EVENT
               MULTI_EVENT
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["allowed_run_frequencies"] = allowed_run_frequencies
        __props__.__dict__["author"] = author
        __props__.__dict__["compilation_diagnostics"] = compilation_diagnostics
        __props__.__dict__["compilation_state"] = compilation_state
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_tables"] = data_tables
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["etag"] = etag
        __props__.__dict__["instance"] = instance
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["near_real_time_live_rule_eligible"] = near_real_time_live_rule_eligible
        __props__.__dict__["project"] = project
        __props__.__dict__["reference_lists"] = reference_lists
        __props__.__dict__["revision_create_time"] = revision_create_time
        __props__.__dict__["revision_id"] = revision_id
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["scope"] = scope
        __props__.__dict__["severities"] = severities
        __props__.__dict__["text"] = text
        __props__.__dict__["type"] = type
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedRunFrequencies")
    def allowed_run_frequencies(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. The run frequencies that are allowed for the rule.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "allowed_run_frequencies")

    @property
    @pulumi.getter
    def author(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The author of the rule. Extracted from the meta section of text.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "author")

    @property
    @pulumi.getter(name="compilationDiagnostics")
    def compilation_diagnostics(self) -> pulumi.Output[Sequence['outputs.RuleCompilationDiagnostic']]:
        """
        Output only. A list of a rule's corresponding compilation diagnostic messages
        such as compilation errors and compilation warnings.
        Populated in FULL view.
        Structure is documented below.
        """
        return pulumi.get(self, "compilation_diagnostics")

    @property
    @pulumi.getter(name="compilationState")
    def compilation_state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The current compilation state of the rule.
        Populated in FULL view.
        Possible values:
        COMPILATION_STATE_UNSPECIFIED
        SUCCEEDED
        FAILED
        """
        return pulumi.get(self, "compilation_state")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp of when the rule was created.
        Populated in FULL view.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataTables")
    def data_tables(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. Resource names of the data tables used in this rule.
        """
        return pulumi.get(self, "data_tables")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Policy to determine if the rule should be deleted forcefully.
        If deletion_policy = "FORCE", any retrohunts and any detections associated with the rule
        will also be deleted. If deletion_policy = "DEFAULT", the call will only succeed if the
        rule has no associated retrohunts, including completed retrohunts, and no
        associated detections. Regardless of this field's value, the rule
        deployment associated with this rule will also be deleted.
        Possible values: DEFAULT, FORCE
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the severity level. Extracted from the meta section of
        the rule text.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The etag for this rule.
        If this is provided on update, the request will succeed if and only if it
        matches the server-computed value, and will fail with an ABORTED error
        otherwise.
        Populated in BASIC view and FULL view.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def instance(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the Chronicle instance, which is the same as the customer ID.
        """
        return pulumi.get(self, "instance")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the resource. This is the geographical region where the Chronicle instance resides, such as "us" or "europe-west2".
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Output only. Additional metadata specified in the meta section of text.
        Populated in FULL view.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Full resource name for the rule. This unique identifier is generated using values provided for the URL parameters.
        Format:
        projects/{project}/locations/{location}/instances/{instance}/rules/{rule}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nearRealTimeLiveRuleEligible")
    def near_real_time_live_rule_eligible(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. Indicate the rule can run in near real time live rule.
        If this is true, the rule uses the near real time live rule when the run
        frequency is set to LIVE.
        """
        return pulumi.get(self, "near_real_time_live_rule_eligible")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="referenceLists")
    def reference_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Output only. Resource names of the reference lists used in this rule.
        Populated in FULL view.
        """
        return pulumi.get(self, "reference_lists")

    @property
    @pulumi.getter(name="revisionCreateTime")
    def revision_create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp of when the rule revision was created.
        Populated in FULL, REVISION_METADATA_ONLY views.
        """
        return pulumi.get(self, "revision_create_time")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The revision ID of the rule.
        A new revision is created whenever the rule text is changed in any way.
        Format: v_{10 digits}_{9 digits}
        Populated in REVISION_METADATA_ONLY view and FULL view.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[builtins.str]:
        """
        Rule Id is the ID of the Rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Resource name of the DataAccessScope bound to this rule.
        Populated in BASIC view and FULL view.
        If reference lists are used in the rule, validations will be performed
        against this scope to ensure that the reference lists are compatible with
        both the user's and the rule's scopes.
        The scope should be in the format:
        "projects/{project}/locations/{location}/instances/{instance}/dataAccessScopes/{scope}".
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def severities(self) -> pulumi.Output[Sequence['outputs.RuleSeverity']]:
        """
        (Output)
        Output only. The severity of a rule's compilation diagnostic.
        Possible values:
        SEVERITY_UNSPECIFIED
        WARNING
        ERROR
        """
        return pulumi.get(self, "severities")

    @property
    @pulumi.getter
    def text(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The YARA-L content of the rule.
        Populated in FULL view.
        """
        return pulumi.get(self, "text")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Possible values:
        RULE_TYPE_UNSPECIFIED
        SINGLE_EVENT
        MULTI_EVENT
        """
        return pulumi.get(self, "type")

