# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'BitbucketServerConfigConnectedRepositoryArgs',
    'BitbucketServerConfigConnectedRepositoryArgsDict',
    'BitbucketServerConfigSecretsArgs',
    'BitbucketServerConfigSecretsArgsDict',
    'TriggerApprovalConfigArgs',
    'TriggerApprovalConfigArgsDict',
    'TriggerBitbucketServerTriggerConfigArgs',
    'TriggerBitbucketServerTriggerConfigArgsDict',
    'TriggerBitbucketServerTriggerConfigPullRequestArgs',
    'TriggerBitbucketServerTriggerConfigPullRequestArgsDict',
    'TriggerBitbucketServerTriggerConfigPushArgs',
    'TriggerBitbucketServerTriggerConfigPushArgsDict',
    'TriggerBuildArgs',
    'TriggerBuildArgsDict',
    'TriggerBuildArtifactsArgs',
    'TriggerBuildArtifactsArgsDict',
    'TriggerBuildArtifactsMavenArtifactArgs',
    'TriggerBuildArtifactsMavenArtifactArgsDict',
    'TriggerBuildArtifactsNpmPackageArgs',
    'TriggerBuildArtifactsNpmPackageArgsDict',
    'TriggerBuildArtifactsObjectsArgs',
    'TriggerBuildArtifactsObjectsArgsDict',
    'TriggerBuildArtifactsObjectsTimingArgs',
    'TriggerBuildArtifactsObjectsTimingArgsDict',
    'TriggerBuildArtifactsPythonPackageArgs',
    'TriggerBuildArtifactsPythonPackageArgsDict',
    'TriggerBuildAvailableSecretsArgs',
    'TriggerBuildAvailableSecretsArgsDict',
    'TriggerBuildAvailableSecretsSecretManagerArgs',
    'TriggerBuildAvailableSecretsSecretManagerArgsDict',
    'TriggerBuildOptionsArgs',
    'TriggerBuildOptionsArgsDict',
    'TriggerBuildOptionsVolumeArgs',
    'TriggerBuildOptionsVolumeArgsDict',
    'TriggerBuildSecretArgs',
    'TriggerBuildSecretArgsDict',
    'TriggerBuildSourceArgs',
    'TriggerBuildSourceArgsDict',
    'TriggerBuildSourceRepoSourceArgs',
    'TriggerBuildSourceRepoSourceArgsDict',
    'TriggerBuildSourceStorageSourceArgs',
    'TriggerBuildSourceStorageSourceArgsDict',
    'TriggerBuildStepArgs',
    'TriggerBuildStepArgsDict',
    'TriggerBuildStepVolumeArgs',
    'TriggerBuildStepVolumeArgsDict',
    'TriggerGitFileSourceArgs',
    'TriggerGitFileSourceArgsDict',
    'TriggerGithubArgs',
    'TriggerGithubArgsDict',
    'TriggerGithubPullRequestArgs',
    'TriggerGithubPullRequestArgsDict',
    'TriggerGithubPushArgs',
    'TriggerGithubPushArgsDict',
    'TriggerPubsubConfigArgs',
    'TriggerPubsubConfigArgsDict',
    'TriggerRepositoryEventConfigArgs',
    'TriggerRepositoryEventConfigArgsDict',
    'TriggerRepositoryEventConfigPullRequestArgs',
    'TriggerRepositoryEventConfigPullRequestArgsDict',
    'TriggerRepositoryEventConfigPushArgs',
    'TriggerRepositoryEventConfigPushArgsDict',
    'TriggerSourceToBuildArgs',
    'TriggerSourceToBuildArgsDict',
    'TriggerTriggerTemplateArgs',
    'TriggerTriggerTemplateArgsDict',
    'TriggerWebhookConfigArgs',
    'TriggerWebhookConfigArgsDict',
    'WorkerPoolNetworkConfigArgs',
    'WorkerPoolNetworkConfigArgsDict',
    'WorkerPoolPrivateServiceConnectArgs',
    'WorkerPoolPrivateServiceConnectArgsDict',
    'WorkerPoolWorkerConfigArgs',
    'WorkerPoolWorkerConfigArgsDict',
]

MYPY = False

if not MYPY:
    class BitbucketServerConfigConnectedRepositoryArgsDict(TypedDict):
        project_key: pulumi.Input[builtins.str]
        """
        Identifier for the project storing the repository.
        """
        repo_slug: pulumi.Input[builtins.str]
        """
        Identifier for the repository.
        """
elif False:
    BitbucketServerConfigConnectedRepositoryArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BitbucketServerConfigConnectedRepositoryArgs:
    def __init__(__self__, *,
                 project_key: pulumi.Input[builtins.str],
                 repo_slug: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] project_key: Identifier for the project storing the repository.
        :param pulumi.Input[builtins.str] repo_slug: Identifier for the repository.
        """
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[builtins.str]:
        """
        Identifier for the project storing the repository.
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> pulumi.Input[builtins.str]:
        """
        Identifier for the repository.
        """
        return pulumi.get(self, "repo_slug")

    @repo_slug.setter
    def repo_slug(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repo_slug", value)


if not MYPY:
    class BitbucketServerConfigSecretsArgsDict(TypedDict):
        admin_access_token_version_name: pulumi.Input[builtins.str]
        """
        The resource name for the admin access token's secret version.
        """
        read_access_token_version_name: pulumi.Input[builtins.str]
        """
        The resource name for the read access token's secret version.
        """
        webhook_secret_version_name: pulumi.Input[builtins.str]
        """
        Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
elif False:
    BitbucketServerConfigSecretsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class BitbucketServerConfigSecretsArgs:
    def __init__(__self__, *,
                 admin_access_token_version_name: pulumi.Input[builtins.str],
                 read_access_token_version_name: pulumi.Input[builtins.str],
                 webhook_secret_version_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] admin_access_token_version_name: The resource name for the admin access token's secret version.
        :param pulumi.Input[builtins.str] read_access_token_version_name: The resource name for the read access token's secret version.
        :param pulumi.Input[builtins.str] webhook_secret_version_name: Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
               Changing this field will result in deleting/ recreating the resource.
        """
        pulumi.set(__self__, "admin_access_token_version_name", admin_access_token_version_name)
        pulumi.set(__self__, "read_access_token_version_name", read_access_token_version_name)
        pulumi.set(__self__, "webhook_secret_version_name", webhook_secret_version_name)

    @property
    @pulumi.getter(name="adminAccessTokenVersionName")
    def admin_access_token_version_name(self) -> pulumi.Input[builtins.str]:
        """
        The resource name for the admin access token's secret version.
        """
        return pulumi.get(self, "admin_access_token_version_name")

    @admin_access_token_version_name.setter
    def admin_access_token_version_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "admin_access_token_version_name", value)

    @property
    @pulumi.getter(name="readAccessTokenVersionName")
    def read_access_token_version_name(self) -> pulumi.Input[builtins.str]:
        """
        The resource name for the read access token's secret version.
        """
        return pulumi.get(self, "read_access_token_version_name")

    @read_access_token_version_name.setter
    def read_access_token_version_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "read_access_token_version_name", value)

    @property
    @pulumi.getter(name="webhookSecretVersionName")
    def webhook_secret_version_name(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. The resource name for the webhook secret's secret version. Once this field has been set, it cannot be changed.
        Changing this field will result in deleting/ recreating the resource.
        """
        return pulumi.get(self, "webhook_secret_version_name")

    @webhook_secret_version_name.setter
    def webhook_secret_version_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "webhook_secret_version_name", value)


if not MYPY:
    class TriggerApprovalConfigArgsDict(TypedDict):
        approval_required: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when run,
        and will need to be explicitly approved to start.
        """
elif False:
    TriggerApprovalConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerApprovalConfigArgs:
    def __init__(__self__, *,
                 approval_required: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.bool] approval_required: Whether or not approval is needed. If this is set on a build, it will become pending when run,
               and will need to be explicitly approved to start.
        """
        if approval_required is not None:
            pulumi.set(__self__, "approval_required", approval_required)

    @property
    @pulumi.getter(name="approvalRequired")
    def approval_required(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether or not approval is needed. If this is set on a build, it will become pending when run,
        and will need to be explicitly approved to start.
        """
        return pulumi.get(self, "approval_required")

    @approval_required.setter
    def approval_required(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "approval_required", value)


if not MYPY:
    class TriggerBitbucketServerTriggerConfigArgsDict(TypedDict):
        bitbucket_server_config_resource: pulumi.Input[builtins.str]
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        project_key: pulumi.Input[builtins.str]
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        repo_slug: pulumi.Input[builtins.str]
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
        For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        pull_request: NotRequired[pulumi.Input['TriggerBitbucketServerTriggerConfigPullRequestArgsDict']]
        """
        Filter to match changes in pull requests.
        Structure is documented below.
        """
        push: NotRequired[pulumi.Input['TriggerBitbucketServerTriggerConfigPushArgsDict']]
        """
        Filter to match changes in refs like branches, tags.
        Structure is documented below.
        """
elif False:
    TriggerBitbucketServerTriggerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBitbucketServerTriggerConfigArgs:
    def __init__(__self__, *,
                 bitbucket_server_config_resource: pulumi.Input[builtins.str],
                 project_key: pulumi.Input[builtins.str],
                 repo_slug: pulumi.Input[builtins.str],
                 pull_request: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPullRequestArgs']] = None,
                 push: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPushArgs']] = None):
        """
        :param pulumi.Input[builtins.str] bitbucket_server_config_resource: The Bitbucket server config resource that this trigger config maps to.
        :param pulumi.Input[builtins.str] project_key: Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        :param pulumi.Input[builtins.str] repo_slug: Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
               For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        :param pulumi.Input['TriggerBitbucketServerTriggerConfigPullRequestArgs'] pull_request: Filter to match changes in pull requests.
               Structure is documented below.
        :param pulumi.Input['TriggerBitbucketServerTriggerConfigPushArgs'] push: Filter to match changes in refs like branches, tags.
               Structure is documented below.
        """
        pulumi.set(__self__, "bitbucket_server_config_resource", bitbucket_server_config_resource)
        pulumi.set(__self__, "project_key", project_key)
        pulumi.set(__self__, "repo_slug", repo_slug)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="bitbucketServerConfigResource")
    def bitbucket_server_config_resource(self) -> pulumi.Input[builtins.str]:
        """
        The Bitbucket server config resource that this trigger config maps to.
        """
        return pulumi.get(self, "bitbucket_server_config_resource")

    @bitbucket_server_config_resource.setter
    def bitbucket_server_config_resource(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bitbucket_server_config_resource", value)

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> pulumi.Input[builtins.str]:
        """
        Key of the project that the repo is in. For example: The key for https://mybitbucket.server/projects/TEST/repos/test-repo is "TEST".
        """
        return pulumi.get(self, "project_key")

    @project_key.setter
    def project_key(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "project_key", value)

    @property
    @pulumi.getter(name="repoSlug")
    def repo_slug(self) -> pulumi.Input[builtins.str]:
        """
        Slug of the repository. A repository slug is a URL-friendly version of a repository name, automatically generated by Bitbucket for use in the URL.
        For example, if the repository name is 'test repo', in the URL it would become 'test-repo' as in https://mybitbucket.server/projects/TEST/repos/test-repo.
        """
        return pulumi.get(self, "repo_slug")

    @repo_slug.setter
    def repo_slug(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repo_slug", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPullRequestArgs']]:
        """
        Filter to match changes in pull requests.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPullRequestArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPushArgs']]:
        """
        Filter to match changes in refs like branches, tags.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['TriggerBitbucketServerTriggerConfigPushArgs']]):
        pulumi.set(self, "push", value)


if not MYPY:
    class TriggerBitbucketServerTriggerConfigPullRequestArgsDict(TypedDict):
        branch: pulumi.Input[builtins.str]
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        comment_control: NotRequired[pulumi.Input[builtins.str]]
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
elif False:
    TriggerBitbucketServerTriggerConfigPullRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBitbucketServerTriggerConfigPullRequestArgs:
    def __init__(__self__, *,
                 branch: pulumi.Input[builtins.str],
                 comment_control: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[builtins.str] comment_control: Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param pulumi.Input[builtins.bool] invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Input[builtins.str]:
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @comment_control.setter
    def comment_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment_control", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)


if not MYPY:
    class TriggerBitbucketServerTriggerConfigPushArgsDict(TypedDict):
        branch: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        tag: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
elif False:
    TriggerBitbucketServerTriggerConfigPushArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBitbucketServerTriggerConfigPushArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 tag: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.  Specify only one of branch or tag.
        :param pulumi.Input[builtins.bool] invert_regex: When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        :param pulumi.Input[builtins.str] tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag", value)


if not MYPY:
    class TriggerBuildArgsDict(TypedDict):
        steps: pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgsDict']]]
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        artifacts: NotRequired[pulumi.Input['TriggerBuildArtifactsArgsDict']]
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        Structure is documented below.
        """
        available_secrets: NotRequired[pulumi.Input['TriggerBuildAvailableSecretsArgsDict']]
        """
        Secrets and secret environment variables.
        Structure is documented below.
        """
        images: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        logs_bucket: NotRequired[pulumi.Input[builtins.str]]
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        options: NotRequired[pulumi.Input['TriggerBuildOptionsArgsDict']]
        """
        Special options for this build.
        Structure is documented below.
        """
        queue_ttl: NotRequired[pulumi.Input[builtins.str]]
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        secrets: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgsDict']]]]
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        source: NotRequired[pulumi.Input['TriggerBuildSourceArgsDict']]
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        substitutions: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Substitutions data for Build resource.
        """
        tags: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Amount of time that this build should be allowed to run, to second granularity.
        If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
        This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
        The expected format is the number of seconds followed by s.
        Default time is ten minutes (600s).
        """
elif False:
    TriggerBuildArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArgs:
    def __init__(__self__, *,
                 steps: pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]],
                 artifacts: Optional[pulumi.Input['TriggerBuildArtifactsArgs']] = None,
                 available_secrets: Optional[pulumi.Input['TriggerBuildAvailableSecretsArgs']] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 logs_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 options: Optional[pulumi.Input['TriggerBuildOptionsArgs']] = None,
                 queue_ttl: Optional[pulumi.Input[builtins.str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]] = None,
                 source: Optional[pulumi.Input['TriggerBuildSourceArgs']] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]] steps: The operations to be performed on the workspace.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildArtifactsArgs'] artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildAvailableSecretsArgs'] available_secrets: Secrets and secret environment variables.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] images: A list of images to be pushed upon the successful completion of all build steps.
               The images are pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build status is marked FAILURE.
        :param pulumi.Input[builtins.str] logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param pulumi.Input['TriggerBuildOptionsArgs'] options: Special options for this build.
               Structure is documented below.
        :param pulumi.Input[builtins.str] queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]] secrets: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildSourceArgs'] source: The location of the source files to build.
               One of `storageSource` or `repoSource` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] substitutions: Substitutions data for Build resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: Tags for annotation of a Build. These are not docker tags.
        :param pulumi.Input[builtins.str] timeout: Amount of time that this build should be allowed to run, to second granularity.
               If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
               This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
               The expected format is the number of seconds followed by s.
               Default time is ten minutes (600s).
        """
        pulumi.set(__self__, "steps", steps)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if available_secrets is not None:
            pulumi.set(__self__, "available_secrets", available_secrets)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]]:
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input['TriggerBuildArtifactsArgs']]:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input['TriggerBuildArtifactsArgs']]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> Optional[pulumi.Input['TriggerBuildAvailableSecretsArgs']]:
        """
        Secrets and secret environment variables.
        Structure is documented below.
        """
        return pulumi.get(self, "available_secrets")

    @available_secrets.setter
    def available_secrets(self, value: Optional[pulumi.Input['TriggerBuildAvailableSecretsArgs']]):
        pulumi.set(self, "available_secrets", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @logs_bucket.setter
    def logs_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logs_bucket", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TriggerBuildOptionsArgs']]:
        """
        Special options for this build.
        Structure is documented below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TriggerBuildOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @queue_ttl.setter
    def queue_ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "queue_ttl", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['TriggerBuildSourceArgs']]:
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['TriggerBuildSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Substitutions data for Build resource.
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Amount of time that this build should be allowed to run, to second granularity.
        If this amount of time elapses, work on the build will cease and the build status will be TIMEOUT.
        This timeout must be equal to or greater than the sum of the timeouts for build steps within the build.
        The expected format is the number of seconds followed by s.
        Default time is ten minutes (600s).
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)


if not MYPY:
    class TriggerBuildArtifactsArgsDict(TypedDict):
        images: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        maven_artifacts: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsMavenArtifactArgsDict']]]]
        """
        A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        npm_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsNpmPackageArgsDict']]]]
        """
        Npm package to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        objects: NotRequired[pulumi.Input['TriggerBuildArtifactsObjectsArgsDict']]
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        python_packages: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsPythonPackageArgsDict']]]]
        """
        Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
elif False:
    TriggerBuildArtifactsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsArgs:
    def __init__(__self__, *,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 maven_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsMavenArtifactArgs']]]] = None,
                 npm_packages: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsNpmPackageArgs']]]] = None,
                 objects: Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']] = None,
                 python_packages: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsPythonPackageArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsMavenArtifactArgs']]] maven_artifacts: A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsNpmPackageArgs']]] npm_packages: Npm package to upload to Artifact Registry upon successful completion of all build steps.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildArtifactsObjectsArgs'] objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
               Files in the workspace matching specified paths globs will be uploaded to the
               Cloud Storage location using the builder service account's credentials.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsPythonPackageArgs']]] python_packages: Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        """
        if images is not None:
            pulumi.set(__self__, "images", images)
        if maven_artifacts is not None:
            pulumi.set(__self__, "maven_artifacts", maven_artifacts)
        if npm_packages is not None:
            pulumi.set(__self__, "npm_packages", npm_packages)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)
        if python_packages is not None:
            pulumi.set(__self__, "python_packages", python_packages)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="mavenArtifacts")
    def maven_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsMavenArtifactArgs']]]]:
        """
        A Maven artifact to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "maven_artifacts")

    @maven_artifacts.setter
    def maven_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsMavenArtifactArgs']]]]):
        pulumi.set(self, "maven_artifacts", value)

    @property
    @pulumi.getter(name="npmPackages")
    def npm_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsNpmPackageArgs']]]]:
        """
        Npm package to upload to Artifact Registry upon successful completion of all build steps.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "npm_packages")

    @npm_packages.setter
    def npm_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsNpmPackageArgs']]]]):
        pulumi.set(self, "npm_packages", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']]:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']]):
        pulumi.set(self, "objects", value)

    @property
    @pulumi.getter(name="pythonPackages")
    def python_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsPythonPackageArgs']]]]:
        """
        Python package to upload to Artifact Registry upon successful completion of all build steps. A package can encapsulate multiple objects to be uploaded to a single repository.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "python_packages")

    @python_packages.setter
    def python_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsPythonPackageArgs']]]]):
        pulumi.set(self, "python_packages", value)


if not MYPY:
    class TriggerBuildArtifactsMavenArtifactArgsDict(TypedDict):
        artifact_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Maven artifactId value used when uploading the artifact to Artifact Registry.
        """
        group_id: NotRequired[pulumi.Input[builtins.str]]
        """
        Maven groupId value used when uploading the artifact to Artifact Registry.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
        Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        """
        version: NotRequired[pulumi.Input[builtins.str]]
        """
        Maven version value used when uploading the artifact to Artifact Registry.
        """
elif False:
    TriggerBuildArtifactsMavenArtifactArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsMavenArtifactArgs:
    def __init__(__self__, *,
                 artifact_id: Optional[pulumi.Input[builtins.str]] = None,
                 group_id: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] artifact_id: Maven artifactId value used when uploading the artifact to Artifact Registry.
        :param pulumi.Input[builtins.str] group_id: Maven groupId value used when uploading the artifact to Artifact Registry.
        :param pulumi.Input[builtins.str] path: Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        :param pulumi.Input[builtins.str] repository: Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
               Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        :param pulumi.Input[builtins.str] version: Maven version value used when uploading the artifact to Artifact Registry.
        """
        if artifact_id is not None:
            pulumi.set(__self__, "artifact_id", artifact_id)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maven artifactId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "artifact_id")

    @artifact_id.setter
    def artifact_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "artifact_id", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maven groupId value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to an artifact in the build's workspace to be uploaded to Artifact Registry. This can be either an absolute path, e.g. /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Artifact Registry repository, in the form "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY"
        Artifact in the workspace specified by path will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maven version value used when uploading the artifact to Artifact Registry.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class TriggerBuildArtifactsNpmPackageArgsDict(TypedDict):
        package_path: NotRequired[pulumi.Input[builtins.str]]
        """
        Path to the package.json. e.g. workspace/path/to/package
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
        Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
elif False:
    TriggerBuildArtifactsNpmPackageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsNpmPackageArgs:
    def __init__(__self__, *,
                 package_path: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] package_path: Path to the package.json. e.g. workspace/path/to/package
        :param pulumi.Input[builtins.str] repository: Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
               Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        if package_path is not None:
            pulumi.set(__self__, "package_path", package_path)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="packagePath")
    def package_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path to the package.json. e.g. workspace/path/to/package
        """
        return pulumi.get(self, "package_path")

    @package_path.setter
    def package_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "package_path", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Artifact Registry repository, in the form "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY"
        Npm package in the workspace specified by path will be zipped and uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)


if not MYPY:
    class TriggerBuildArtifactsObjectsArgsDict(TypedDict):
        location: NotRequired[pulumi.Input[builtins.str]]
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
        Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
        this location as a prefix.
        """
        paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Path globs used to match files in the build's workspace.
        """
        timings: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgsDict']]]]
        """
        (Output)
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.


        <a name="nested_build_artifacts_objects_timing"></a>The `timing` block contains:
        """
elif False:
    TriggerBuildArtifactsObjectsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsObjectsArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timings: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]] = None):
        """
        :param pulumi.Input[builtins.str] location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
               Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
               this location as a prefix.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: Path globs used to match files in the build's workspace.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]] timings: (Output)
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
               
               
               <a name="nested_build_artifacts_objects_timing"></a>The `timing` block contains:
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if timings is not None:
            pulumi.set(__self__, "timings", timings)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
        Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
        this location as a prefix.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter
    def timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]]:
        """
        (Output)
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.


        <a name="nested_build_artifacts_objects_timing"></a>The `timing` block contains:
        """
        return pulumi.get(self, "timings")

    @timings.setter
    def timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]]):
        pulumi.set(self, "timings", value)


if not MYPY:
    class TriggerBuildArtifactsObjectsTimingArgsDict(TypedDict):
        end_time: NotRequired[pulumi.Input[builtins.str]]
        """
        End of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        start_time: NotRequired[pulumi.Input[builtins.str]]
        """
        Start of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
elif False:
    TriggerBuildArtifactsObjectsTimingArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsObjectsTimingArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[builtins.str]] = None,
                 start_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] end_time: End of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[builtins.str] start_time: Start of time span.
               
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        End of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Start of time span.

        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class TriggerBuildArtifactsPythonPackageArgsDict(TypedDict):
        paths: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
        Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
elif False:
    TriggerBuildArtifactsPythonPackageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildArtifactsPythonPackageArgs:
    def __init__(__self__, *,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] paths: Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        :param pulumi.Input[builtins.str] repository: Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
               Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Path globs used to match files in the build's workspace. For Python/ Twine, this is usually dist/*, and sometimes additionally an .asc file.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Artifact Registry repository, in the form "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY"
        Files in the workspace matching any path pattern will be uploaded to Artifact Registry with this location as a prefix.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)


if not MYPY:
    class TriggerBuildAvailableSecretsArgsDict(TypedDict):
        secret_managers: pulumi.Input[Sequence[pulumi.Input['TriggerBuildAvailableSecretsSecretManagerArgsDict']]]
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        Structure is documented below.
        """
elif False:
    TriggerBuildAvailableSecretsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildAvailableSecretsArgs:
    def __init__(__self__, *,
                 secret_managers: pulumi.Input[Sequence[pulumi.Input['TriggerBuildAvailableSecretsSecretManagerArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildAvailableSecretsSecretManagerArgs']]] secret_managers: Pairs a secret environment variable with a SecretVersion in Secret Manager.
               Structure is documented below.
        """
        pulumi.set(__self__, "secret_managers", secret_managers)

    @property
    @pulumi.getter(name="secretManagers")
    def secret_managers(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerBuildAvailableSecretsSecretManagerArgs']]]:
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_managers")

    @secret_managers.setter
    def secret_managers(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerBuildAvailableSecretsSecretManagerArgs']]]):
        pulumi.set(self, "secret_managers", value)


if not MYPY:
    class TriggerBuildAvailableSecretsSecretManagerArgsDict(TypedDict):
        env: pulumi.Input[builtins.str]
        """
        Environment variable name to associate with the secret. Secret environment
        variables must be unique across all of a build's secrets, and must be used
        by at least one build step.
        """
        version_name: pulumi.Input[builtins.str]
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
elif False:
    TriggerBuildAvailableSecretsSecretManagerArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildAvailableSecretsSecretManagerArgs:
    def __init__(__self__, *,
                 env: pulumi.Input[builtins.str],
                 version_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] env: Environment variable name to associate with the secret. Secret environment
               variables must be unique across all of a build's secrets, and must be used
               by at least one build step.
        :param pulumi.Input[builtins.str] version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def env(self) -> pulumi.Input[builtins.str]:
        """
        Environment variable name to associate with the secret. Secret environment
        variables must be unique across all of a build's secrets, and must be used
        by at least one build step.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> pulumi.Input[builtins.str]:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")

    @version_name.setter
    def version_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version_name", value)


if not MYPY:
    class TriggerBuildOptionsArgsDict(TypedDict):
        disk_size_gb: NotRequired[pulumi.Input[builtins.int]]
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        dynamic_substitutions: NotRequired[pulumi.Input[builtins.bool]]
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.
        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        log_streaming_option: NotRequired[pulumi.Input[builtins.str]]
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        Possible values are: `STREAM_DEFAULT`, `STREAM_ON`, `STREAM_OFF`.
        """
        logging: NotRequired[pulumi.Input[builtins.str]]
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        Possible values are: `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, `NONE`.
        """
        machine_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Compute Engine machine type on which to run the build.
        """
        requested_verify_option: NotRequired[pulumi.Input[builtins.str]]
        """
        Requested verifiability options.
        Possible values are: `NOT_VERIFIED`, `VERIFIED`.
        """
        secret_envs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        source_provenance_hashes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        Requested hash for SourceProvenance.
        Each value may be one of: `NONE`, `SHA256`, `MD5`.
        """
        substitution_option: NotRequired[pulumi.Input[builtins.str]]
        """
        Option to specify behavior when there is an error in the substitution checks.
        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file.
        Possible values are: `MUST_MATCH`, `ALLOW_LOOSE`.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgsDict']]]]
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        worker_pool: NotRequired[pulumi.Input[builtins.str]]
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
        This field is experimental.
        """
elif False:
    TriggerBuildOptionsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildOptionsArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 dynamic_substitutions: Optional[pulumi.Input[builtins.bool]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 log_streaming_option: Optional[pulumi.Input[builtins.str]] = None,
                 logging: Optional[pulumi.Input[builtins.str]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 requested_verify_option: Optional[pulumi.Input[builtins.str]] = None,
                 secret_envs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_provenance_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 substitution_option: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]] = None,
                 worker_pool: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] disk_size_gb: Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
               some of the space will be used by the operating system and build utilities.
               Also note that this is the minimum disk size that will be allocated for the build --
               the build may run with a larger disk than requested. At present, the maximum disk size
               is 1000GB; builds that request more than the maximum are rejected with an error.
        :param pulumi.Input[builtins.bool] dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions.
               NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param pulumi.Input[builtins.str] log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
               Possible values are: `STREAM_DEFAULT`, `STREAM_ON`, `STREAM_OFF`.
        :param pulumi.Input[builtins.str] logging: Option to specify the logging mode, which determines if and where build logs are stored.
               Possible values are: `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, `NONE`.
        :param pulumi.Input[builtins.str] machine_type: Compute Engine machine type on which to run the build.
        :param pulumi.Input[builtins.str] requested_verify_option: Requested verifiability options.
               Possible values are: `NOT_VERIFIED`, `VERIFIED`.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_provenance_hashes: Requested hash for SourceProvenance.
               Each value may be one of: `NONE`, `SHA256`, `MD5`.
        :param pulumi.Input[builtins.str] substitution_option: Option to specify behavior when there is an error in the substitution checks.
               NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
               in the build configuration file.
               Possible values are: `MUST_MATCH`, `ALLOW_LOOSE`.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] worker_pool: Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
               This field is experimental.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if dynamic_substitutions is not None:
            pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if log_streaming_option is not None:
            pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if requested_verify_option is not None:
            pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if source_provenance_hashes is not None:
            pulumi.set(__self__, "source_provenance_hashes", source_provenance_hashes)
        if substitution_option is not None:
            pulumi.set(__self__, "substitution_option", substitution_option)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.
        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @dynamic_substitutions.setter
    def dynamic_substitutions(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "dynamic_substitutions", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        Possible values are: `STREAM_DEFAULT`, `STREAM_ON`, `STREAM_OFF`.
        """
        return pulumi.get(self, "log_streaming_option")

    @log_streaming_option.setter
    def log_streaming_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "log_streaming_option", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        Possible values are: `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, `CLOUD_LOGGING_ONLY`, `NONE`.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Requested verifiability options.
        Possible values are: `NOT_VERIFIED`, `VERIFIED`.
        """
        return pulumi.get(self, "requested_verify_option")

    @requested_verify_option.setter
    def requested_verify_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "requested_verify_option", value)

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @secret_envs.setter
    def secret_envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_envs", value)

    @property
    @pulumi.getter(name="sourceProvenanceHashes")
    def source_provenance_hashes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Requested hash for SourceProvenance.
        Each value may be one of: `NONE`, `SHA256`, `MD5`.
        """
        return pulumi.get(self, "source_provenance_hashes")

    @source_provenance_hashes.setter
    def source_provenance_hashes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_provenance_hashes", value)

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Option to specify behavior when there is an error in the substitution checks.
        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file.
        Possible values are: `MUST_MATCH`, `ALLOW_LOOSE`.
        """
        return pulumi.get(self, "substitution_option")

    @substitution_option.setter
    def substitution_option(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "substitution_option", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
        This field is experimental.
        """
        return pulumi.get(self, "worker_pool")

    @worker_pool.setter
    def worker_pool(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "worker_pool", value)


if not MYPY:
    class TriggerBuildOptionsVolumeArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        path: NotRequired[pulumi.Input[builtins.str]]
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
elif False:
    TriggerBuildOptionsVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildOptionsVolumeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[builtins.str] path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "path", value)


if not MYPY:
    class TriggerBuildSecretArgsDict(TypedDict):
        kms_key_name: pulumi.Input[builtins.str]
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        secret_env: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Map of environment variable name to its encrypted value.
        Secret environment variables must be unique across all of a build's secrets,
        and must be used by at least one build step. Values can be at most 64 KB in size.
        There can be at most 100 secret values across all of a build's secrets.
        """
elif False:
    TriggerBuildSecretArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildSecretArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[builtins.str],
                 secret_env: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] secret_env: Map of environment variable name to its encrypted value.
               Secret environment variables must be unique across all of a build's secrets,
               and must be used by at least one build step. Values can be at most 64 KB in size.
               There can be at most 100 secret values across all of a build's secrets.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[builtins.str]:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of environment variable name to its encrypted value.
        Secret environment variables must be unique across all of a build's secrets,
        and must be used by at least one build step. Values can be at most 64 KB in size.
        There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")

    @secret_env.setter
    def secret_env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_env", value)


if not MYPY:
    class TriggerBuildSourceArgsDict(TypedDict):
        repo_source: NotRequired[pulumi.Input['TriggerBuildSourceRepoSourceArgsDict']]
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        storage_source: NotRequired[pulumi.Input['TriggerBuildSourceStorageSourceArgsDict']]
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
elif False:
    TriggerBuildSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildSourceArgs:
    def __init__(__self__, *,
                 repo_source: Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']] = None):
        """
        :param pulumi.Input['TriggerBuildSourceRepoSourceArgs'] repo_source: Location of the source in a Google Cloud Source Repository.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildSourceStorageSourceArgs'] storage_source: Location of the source in an archive file in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']]:
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']]:
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)


if not MYPY:
    class TriggerBuildSourceRepoSourceArgsDict(TypedDict):
        repo_name: pulumi.Input[builtins.str]
        """
        Name of the Cloud Source Repository.
        """
        branch_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        commit_sha: NotRequired[pulumi.Input[builtins.str]]
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        dir: NotRequired[pulumi.Input[builtins.str]]
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and is an absolute path,
        this value is ignored for that step's execution.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        project_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        substitutions: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        tag_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
elif False:
    TriggerBuildSourceRepoSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildSourceRepoSourceArgs:
    def __init__(__self__, *,
                 repo_name: pulumi.Input[builtins.str],
                 branch_name: Optional[pulumi.Input[builtins.str]] = None,
                 commit_sha: Optional[pulumi.Input[builtins.str]] = None,
                 dir: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tag_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[builtins.str] branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[builtins.str] commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param pulumi.Input[builtins.str] dir: Directory, relative to the source root, in which to run the build.
               This must be a relative path. If a step's dir is specified and is an absolute path,
               this value is ignored for that step's execution.
        :param pulumi.Input[builtins.bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[builtins.str] project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param pulumi.Input[builtins.str] tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "repo_name", repo_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and is an absolute path,
        this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag_name", value)


if not MYPY:
    class TriggerBuildSourceStorageSourceArgsDict(TypedDict):
        bucket: pulumi.Input[builtins.str]
        """
        Google Cloud Storage bucket containing the source.
        """
        object: pulumi.Input[builtins.str]
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        generation: NotRequired[pulumi.Input[builtins.str]]
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
elif False:
    TriggerBuildSourceStorageSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildSourceStorageSourceArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[builtins.str],
                 object: pulumi.Input[builtins.str],
                 generation: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] bucket: Google Cloud Storage bucket containing the source.
        :param pulumi.Input[builtins.str] object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param pulumi.Input[builtins.str] generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[builtins.str]:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[builtins.str]:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generation", value)


if not MYPY:
    class TriggerBuildStepArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        The name of the container image that will run this particular build step.
        If the image is available in the host's Docker daemon's cache, it will be
        run directly. If not, the host will attempt to pull the image first, using
        the builder service account's credentials if necessary.
        The Docker daemon's cache will already have the latest versions of all of
        the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
        for images and examples).
        The Docker daemon will also have cached many of the layers for some popular
        images, like "ubuntu", "debian", but they will be refreshed at the time
        you attempt to use them.
        If you built an image in a previous build step, it will be stored in the
        host's Docker daemon's cache and is available to use as the name for a
        later build step.
        """
        allow_exit_codes: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]
        """
        Allow this build step to fail without failing the entire build if and
        only if the exit code is one of the specified codes.
        If `allowFailure` is also specified, this field will take precedence.
        """
        allow_failure: NotRequired[pulumi.Input[builtins.bool]]
        """
        Allow this build step to fail without failing the entire build.
        If false, the entire build will fail if this step fails. Otherwise, the
        build will succeed, but this step will still have a failure status.
        Error information will be reported in the `failureDetail` field.
        `allowExitCodes` takes precedence over this field.
        """
        args: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        dir: NotRequired[pulumi.Input[builtins.str]]
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        entrypoint: NotRequired[pulumi.Input[builtins.str]]
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        envs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of environment variable definitions to be used when
        running a step.
        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        id: NotRequired[pulumi.Input[builtins.str]]
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        script: NotRequired[pulumi.Input[builtins.str]]
        """
        A shell script to be executed in the step.
        When script is provided, the user cannot specify the entrypoint or args.
        """
        secret_envs: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's `Secret`.
        """
        timeout: NotRequired[pulumi.Input[builtins.str]]
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        timing: NotRequired[pulumi.Input[builtins.str]]
        """
        Output only. Stores timing information for executing this
        build step.
        """
        volumes: NotRequired[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgsDict']]]]
        """
        List of volumes to mount into the build step.
        Each volume is created as an empty volume prior to execution of the
        build step. Upon completion of the build, volumes and their contents
        are discarded.
        Using a named volume in only one step is not valid as it is
        indicative of a build request with an incorrect configuration.
        Structure is documented below.
        """
        wait_fors: NotRequired[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
elif False:
    TriggerBuildStepArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildStepArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 allow_exit_codes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 allow_failure: Optional[pulumi.Input[builtins.bool]] = None,
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 dir: Optional[pulumi.Input[builtins.str]] = None,
                 entrypoint: Optional[pulumi.Input[builtins.str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 id: Optional[pulumi.Input[builtins.str]] = None,
                 script: Optional[pulumi.Input[builtins.str]] = None,
                 secret_envs: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.str]] = None,
                 timing: Optional[pulumi.Input[builtins.str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]] = None,
                 wait_fors: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the container image that will run this particular build step.
               If the image is available in the host's Docker daemon's cache, it will be
               run directly. If not, the host will attempt to pull the image first, using
               the builder service account's credentials if necessary.
               The Docker daemon's cache will already have the latest versions of all of
               the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
               for images and examples).
               The Docker daemon will also have cached many of the layers for some popular
               images, like "ubuntu", "debian", but they will be refreshed at the time
               you attempt to use them.
               If you built an image in a previous build step, it will be stored in the
               host's Docker daemon's cache and is available to use as the name for a
               later build step.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] allow_exit_codes: Allow this build step to fail without failing the entire build if and
               only if the exit code is one of the specified codes.
               If `allowFailure` is also specified, this field will take precedence.
        :param pulumi.Input[builtins.bool] allow_failure: Allow this build step to fail without failing the entire build.
               If false, the entire build will fail if this step fails. Otherwise, the
               build will succeed, but this step will still have a failure status.
               Error information will be reported in the `failureDetail` field.
               `allowExitCodes` takes precedence over this field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] args: A list of arguments that will be presented to the step when it is started.
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param pulumi.Input[builtins.str] dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param pulumi.Input[builtins.str] entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] envs: A list of environment variable definitions to be used when
               running a step.
               The elements are of the form "KEY=VALUE" for the environment variable
               "KEY" being given the value "VALUE".
        :param pulumi.Input[builtins.str] id: Unique identifier for this build step, used in `wait_for` to
               reference this build step as a dependency.
        :param pulumi.Input[builtins.str] script: A shell script to be executed in the step.
               When script is provided, the user cannot specify the entrypoint or args.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] secret_envs: A list of environment variables which are encrypted using
               a Cloud Key
               Management Service crypto key. These values must be specified in
               the build's `Secret`.
        :param pulumi.Input[builtins.str] timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param pulumi.Input[builtins.str] timing: Output only. Stores timing information for executing this
               build step.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]] volumes: List of volumes to mount into the build step.
               Each volume is created as an empty volume prior to execution of the
               build step. Upon completion of the build, volumes and their contents
               are discarded.
               Using a named volume in only one step is not valid as it is
               indicative of a build request with an incorrect configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] wait_fors: The ID(s) of the step(s) that this build step depends on.
               This build step will not start until all the build steps in `wait_for`
               have completed successfully. If `wait_for` is empty, this build step
               will start when all previous build steps in the `Build.Steps` list
               have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if allow_exit_codes is not None:
            pulumi.set(__self__, "allow_exit_codes", allow_exit_codes)
        if allow_failure is not None:
            pulumi.set(__self__, "allow_failure", allow_failure)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if timing is not None:
            pulumi.set(__self__, "timing", timing)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_fors is not None:
            pulumi.set(__self__, "wait_fors", wait_fors)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        The name of the container image that will run this particular build step.
        If the image is available in the host's Docker daemon's cache, it will be
        run directly. If not, the host will attempt to pull the image first, using
        the builder service account's credentials if necessary.
        The Docker daemon's cache will already have the latest versions of all of
        the officially supported build steps (see https://github.com/GoogleCloudPlatform/cloud-builders
        for images and examples).
        The Docker daemon will also have cached many of the layers for some popular
        images, like "ubuntu", "debian", but they will be refreshed at the time
        you attempt to use them.
        If you built an image in a previous build step, it will be stored in the
        host's Docker daemon's cache and is available to use as the name for a
        later build step.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="allowExitCodes")
    def allow_exit_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        Allow this build step to fail without failing the entire build if and
        only if the exit code is one of the specified codes.
        If `allowFailure` is also specified, this field will take precedence.
        """
        return pulumi.get(self, "allow_exit_codes")

    @allow_exit_codes.setter
    def allow_exit_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "allow_exit_codes", value)

    @property
    @pulumi.getter(name="allowFailure")
    def allow_failure(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow this build step to fail without failing the entire build.
        If false, the entire build will fail if this step fails. Otherwise, the
        build will succeed, but this step will still have a failure status.
        Error information will be reported in the `failureDetail` field.
        `allowExitCodes` takes precedence over this field.
        """
        return pulumi.get(self, "allow_failure")

    @allow_failure.setter
    def allow_failure(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_failure", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of environment variable definitions to be used when
        running a step.
        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A shell script to be executed in the step.
        When script is provided, the user cannot specify the entrypoint or args.
        """
        return pulumi.get(self, "script")

    @script.setter
    def script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "script", value)

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's `Secret`.
        """
        return pulumi.get(self, "secret_envs")

    @secret_envs.setter
    def secret_envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "secret_envs", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def timing(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Stores timing information for executing this
        build step.
        """
        return pulumi.get(self, "timing")

    @timing.setter
    def timing(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "timing", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]]:
        """
        List of volumes to mount into the build step.
        Each volume is created as an empty volume prior to execution of the
        build step. Upon completion of the build, volumes and their contents
        are discarded.
        Using a named volume in only one step is not valid as it is
        indicative of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")

    @wait_fors.setter
    def wait_fors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "wait_fors", value)


if not MYPY:
    class TriggerBuildStepVolumeArgsDict(TypedDict):
        name: pulumi.Input[builtins.str]
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        path: pulumi.Input[builtins.str]
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
elif False:
    TriggerBuildStepVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerBuildStepVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[builtins.str],
                 path: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[builtins.str] path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)


if not MYPY:
    class TriggerGitFileSourceArgsDict(TypedDict):
        path: pulumi.Input[builtins.str]
        """
        The path of the file, with the repo root as the root of the path.
        """
        repo_type: pulumi.Input[builtins.str]
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        bitbucket_server_config: NotRequired[pulumi.Input[builtins.str]]
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        github_enterprise_config: NotRequired[pulumi.Input[builtins.str]]
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
        If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        revision: NotRequired[pulumi.Input[builtins.str]]
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
        filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
        If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The URI of the repo (optional). If unspecified, the repo from which the trigger
        invocation originated is assumed to be the repo from which to read the specified path.
        """
elif False:
    TriggerGitFileSourceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerGitFileSourceArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[builtins.str],
                 repo_type: pulumi.Input[builtins.str],
                 bitbucket_server_config: Optional[pulumi.Input[builtins.str]] = None,
                 github_enterprise_config: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 revision: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] path: The path of the file, with the repo root as the root of the path.
        :param pulumi.Input[builtins.str] repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        :param pulumi.Input[builtins.str] bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param pulumi.Input[builtins.str] github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param pulumi.Input[builtins.str] repository: The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
               If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        :param pulumi.Input[builtins.str] revision: The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
               filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
               If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        :param pulumi.Input[builtins.str] uri: The URI of the repo (optional). If unspecified, the repo from which the trigger
               invocation originated is assumed to be the repo from which to read the specified path.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "repo_type", repo_type)
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[builtins.str]:
        """
        The path of the file, with the repo root as the root of the path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repo_type", value)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @bitbucket_server_config.setter
    def bitbucket_server_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bitbucket_server_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fully qualified resource name of the Repo API repository. The fully qualified resource name of the Repo API repository.
        If unspecified, the repo from which the trigger invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The branch, tag, arbitrary ref, or SHA version of the repo to use when resolving the
        filename (optional). This field respects the same syntax/resolution as described here: https://git-scm.com/docs/gitrevisions
        If unspecified, the revision from which the trigger invocation originated is assumed to be the revision from which to read the specified path.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the repo (optional). If unspecified, the repo from which the trigger
        invocation originated is assumed to be the repo from which to read the specified path.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class TriggerGithubArgsDict(TypedDict):
        enterprise_config_resource_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the github enterprise config that should be applied to this installation.
        For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        """
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the repository. For example: The name for
        https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        owner: NotRequired[pulumi.Input[builtins.str]]
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        pull_request: NotRequired[pulumi.Input['TriggerGithubPullRequestArgsDict']]
        """
        filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        push: NotRequired[pulumi.Input['TriggerGithubPushArgsDict']]
        """
        filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
elif False:
    TriggerGithubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerGithubArgs:
    def __init__(__self__, *,
                 enterprise_config_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 owner: Optional[pulumi.Input[builtins.str]] = None,
                 pull_request: Optional[pulumi.Input['TriggerGithubPullRequestArgs']] = None,
                 push: Optional[pulumi.Input['TriggerGithubPushArgs']] = None):
        """
        :param pulumi.Input[builtins.str] enterprise_config_resource_name: The resource name of the github enterprise config that should be applied to this installation.
               For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        :param pulumi.Input[builtins.str] name: Name of the repository. For example: The name for
               https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param pulumi.Input[builtins.str] owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param pulumi.Input['TriggerGithubPullRequestArgs'] pull_request: filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        :param pulumi.Input['TriggerGithubPushArgs'] push: filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
               Structure is documented below.
        """
        if enterprise_config_resource_name is not None:
            pulumi.set(__self__, "enterprise_config_resource_name", enterprise_config_resource_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="enterpriseConfigResourceName")
    def enterprise_config_resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the github enterprise config that should be applied to this installation.
        For example: "projects/{$projectId}/locations/{$locationId}/githubEnterpriseConfigs/{$configId}"
        """
        return pulumi.get(self, "enterprise_config_resource_name")

    @enterprise_config_resource_name.setter
    def enterprise_config_resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "enterprise_config_resource_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the repository. For example: The name for
        https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['TriggerGithubPullRequestArgs']]:
        """
        filter to match changes in pull requests. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['TriggerGithubPullRequestArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['TriggerGithubPushArgs']]:
        """
        filter to match changes in refs, like branches or tags. Specify only one of `pull_request` or `push`.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['TriggerGithubPushArgs']]):
        pulumi.set(self, "push", value)


if not MYPY:
    class TriggerGithubPullRequestArgsDict(TypedDict):
        branch: pulumi.Input[builtins.str]
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        comment_control: NotRequired[pulumi.Input[builtins.str]]
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
elif False:
    TriggerGithubPullRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerGithubPullRequestArgs:
    def __init__(__self__, *,
                 branch: pulumi.Input[builtins.str],
                 comment_control: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[builtins.str] comment_control: Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param pulumi.Input[builtins.bool] invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Input[builtins.str]:
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @comment_control.setter
    def comment_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment_control", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)


if not MYPY:
    class TriggerGithubPushArgsDict(TypedDict):
        branch: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        tag: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
elif False:
    TriggerGithubPushArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerGithubPushArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 tag: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.  Specify only one of branch or tag.
        :param pulumi.Input[builtins.bool] invert_regex: When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        :param pulumi.Input[builtins.str] tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag", value)


if not MYPY:
    class TriggerPubsubConfigArgsDict(TypedDict):
        topic: pulumi.Input[builtins.str]
        """
        The name of the topic from which this subscription is receiving messages.
        """
        service_account_email: NotRequired[pulumi.Input[builtins.str]]
        """
        Service account that will make the push request.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        subscription: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Name of the subscription.
        """
elif False:
    TriggerPubsubConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerPubsubConfigArgs:
    def __init__(__self__, *,
                 topic: pulumi.Input[builtins.str],
                 service_account_email: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] topic: The name of the topic from which this subscription is receiving messages.
        :param pulumi.Input[builtins.str] service_account_email: Service account that will make the push request.
        :param pulumi.Input[builtins.str] state: (Output)
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        :param pulumi.Input[builtins.str] subscription: (Output)
               Output only. Name of the subscription.
        """
        pulumi.set(__self__, "topic", topic)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[builtins.str]:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Name of the subscription.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription", value)


if not MYPY:
    class TriggerRepositoryEventConfigArgsDict(TypedDict):
        pull_request: NotRequired[pulumi.Input['TriggerRepositoryEventConfigPullRequestArgsDict']]
        """
        Contains filter properties for matching Pull Requests.
        Structure is documented below.
        """
        push: NotRequired[pulumi.Input['TriggerRepositoryEventConfigPushArgsDict']]
        """
        Contains filter properties for matching git pushes.
        Structure is documented below.
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource name of the Repo API resource.
        """
elif False:
    TriggerRepositoryEventConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerRepositoryEventConfigArgs:
    def __init__(__self__, *,
                 pull_request: Optional[pulumi.Input['TriggerRepositoryEventConfigPullRequestArgs']] = None,
                 push: Optional[pulumi.Input['TriggerRepositoryEventConfigPushArgs']] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['TriggerRepositoryEventConfigPullRequestArgs'] pull_request: Contains filter properties for matching Pull Requests.
               Structure is documented below.
        :param pulumi.Input['TriggerRepositoryEventConfigPushArgs'] push: Contains filter properties for matching git pushes.
               Structure is documented below.
        :param pulumi.Input[builtins.str] repository: The resource name of the Repo API resource.
        """
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['TriggerRepositoryEventConfigPullRequestArgs']]:
        """
        Contains filter properties for matching Pull Requests.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['TriggerRepositoryEventConfigPullRequestArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['TriggerRepositoryEventConfigPushArgs']]:
        """
        Contains filter properties for matching git pushes.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['TriggerRepositoryEventConfigPushArgs']]):
        pulumi.set(self, "push", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Repo API resource.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)


if not MYPY:
    class TriggerRepositoryEventConfigPullRequestArgsDict(TypedDict):
        branch: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        comment_control: NotRequired[pulumi.Input[builtins.str]]
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
elif False:
    TriggerRepositoryEventConfigPullRequestArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerRepositoryEventConfigPullRequestArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 comment_control: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[builtins.str] comment_control: Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
               Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param pulumi.Input[builtins.bool] invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of branches to match.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Configure builds to run whether a repository owner or collaborator need to comment /gcbrun.
        Possible values are: `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @comment_control.setter
    def comment_control(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comment_control", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)


if not MYPY:
    class TriggerRepositoryEventConfigPushArgsDict(TypedDict):
        branch: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        tag: NotRequired[pulumi.Input[builtins.str]]
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
elif False:
    TriggerRepositoryEventConfigPushArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerRepositoryEventConfigPushArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 tag: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] branch: Regex of branches to match.  Specify only one of branch or tag.
        :param pulumi.Input[builtins.bool] invert_regex: When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        :param pulumi.Input[builtins.str] tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When true, only trigger a build if the revision regex does NOT match the gitRef regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag", value)


if not MYPY:
    class TriggerSourceToBuildArgsDict(TypedDict):
        ref: pulumi.Input[builtins.str]
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        repo_type: pulumi.Input[builtins.str]
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        bitbucket_server_config: NotRequired[pulumi.Input[builtins.str]]
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        github_enterprise_config: NotRequired[pulumi.Input[builtins.str]]
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        repository: NotRequired[pulumi.Input[builtins.str]]
        """
        The qualified resource name of the Repo API repository.
        Either uri or repository can be specified and is required.
        """
        uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The URI of the repo.
        """
elif False:
    TriggerSourceToBuildArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerSourceToBuildArgs:
    def __init__(__self__, *,
                 ref: pulumi.Input[builtins.str],
                 repo_type: pulumi.Input[builtins.str],
                 bitbucket_server_config: Optional[pulumi.Input[builtins.str]] = None,
                 github_enterprise_config: Optional[pulumi.Input[builtins.str]] = None,
                 repository: Optional[pulumi.Input[builtins.str]] = None,
                 uri: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ref: The branch or tag to use. Must start with "refs/" (required).
        :param pulumi.Input[builtins.str] repo_type: The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
               Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
               Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        :param pulumi.Input[builtins.str] bitbucket_server_config: The full resource name of the bitbucket server config.
               Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        :param pulumi.Input[builtins.str] github_enterprise_config: The full resource name of the github enterprise config.
               Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        :param pulumi.Input[builtins.str] repository: The qualified resource name of the Repo API repository.
               Either uri or repository can be specified and is required.
        :param pulumi.Input[builtins.str] uri: The URI of the repo.
        """
        pulumi.set(__self__, "ref", ref)
        pulumi.set(__self__, "repo_type", repo_type)
        if bitbucket_server_config is not None:
            pulumi.set(__self__, "bitbucket_server_config", bitbucket_server_config)
        if github_enterprise_config is not None:
            pulumi.set(__self__, "github_enterprise_config", github_enterprise_config)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def ref(self) -> pulumi.Input[builtins.str]:
        """
        The branch or tag to use. Must start with "refs/" (required).
        """
        return pulumi.get(self, "ref")

    @ref.setter
    def ref(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ref", value)

    @property
    @pulumi.getter(name="repoType")
    def repo_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the repo, since it may not be explicit from the repo field (e.g from a URL).
        Values can be UNKNOWN, CLOUD_SOURCE_REPOSITORIES, GITHUB, BITBUCKET_SERVER
        Possible values are: `UNKNOWN`, `CLOUD_SOURCE_REPOSITORIES`, `GITHUB`, `BITBUCKET_SERVER`.
        """
        return pulumi.get(self, "repo_type")

    @repo_type.setter
    def repo_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "repo_type", value)

    @property
    @pulumi.getter(name="bitbucketServerConfig")
    def bitbucket_server_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full resource name of the bitbucket server config.
        Format: projects/{project}/locations/{location}/bitbucketServerConfigs/{id}.
        """
        return pulumi.get(self, "bitbucket_server_config")

    @bitbucket_server_config.setter
    def bitbucket_server_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bitbucket_server_config", value)

    @property
    @pulumi.getter(name="githubEnterpriseConfig")
    def github_enterprise_config(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full resource name of the github enterprise config.
        Format: projects/{project}/locations/{location}/githubEnterpriseConfigs/{id}. projects/{project}/githubEnterpriseConfigs/{id}.
        """
        return pulumi.get(self, "github_enterprise_config")

    @github_enterprise_config.setter
    def github_enterprise_config(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "github_enterprise_config", value)

    @property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The qualified resource name of the Repo API repository.
        Either uri or repository can be specified and is required.
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repository", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the repo.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uri", value)


if not MYPY:
    class TriggerTriggerTemplateArgsDict(TypedDict):
        branch_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        commit_sha: NotRequired[pulumi.Input[builtins.str]]
        """
        Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        """
        dir: NotRequired[pulumi.Input[builtins.str]]
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and
        is an absolute path, this value is ignored for that step's
        execution.
        """
        invert_regex: NotRequired[pulumi.Input[builtins.bool]]
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        project_id: NotRequired[pulumi.Input[builtins.str]]
        """
        ID of the project that owns the Cloud Source Repository. If
        omitted, the project ID requesting the build is assumed.
        """
        repo_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        """
        tag_name: NotRequired[pulumi.Input[builtins.str]]
        """
        Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
elif False:
    TriggerTriggerTemplateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerTriggerTemplateArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[builtins.str]] = None,
                 commit_sha: Optional[pulumi.Input[builtins.str]] = None,
                 dir: Optional[pulumi.Input[builtins.str]] = None,
                 invert_regex: Optional[pulumi.Input[builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[builtins.str]] = None,
                 repo_name: Optional[pulumi.Input[builtins.str]] = None,
                 tag_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] branch_name: Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        :param pulumi.Input[builtins.str] commit_sha: Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        :param pulumi.Input[builtins.str] dir: Directory, relative to the source root, in which to run the build.
               This must be a relative path. If a step's dir is specified and
               is an absolute path, this value is ignored for that step's
               execution.
        :param pulumi.Input[builtins.bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[builtins.str] project_id: ID of the project that owns the Cloud Source Repository. If
               omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[builtins.str] repo_name: Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        :param pulumi.Input[builtins.str] tag_name: Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
               This field is a regular expression.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the branch to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Explicit commit SHA to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Directory, relative to the source root, in which to run the build.
        This must be a relative path. If a step's dir is specified and
        is an absolute path, this value is ignored for that step's
        execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ID of the project that owns the Cloud Source Repository. If
        omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the Cloud Source Repository. If omitted, the name "default" is assumed.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the tag to build. Exactly one of a branch name, tag, or commit SHA must be provided.
        This field is a regular expression.
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tag_name", value)


if not MYPY:
    class TriggerWebhookConfigArgsDict(TypedDict):
        secret: pulumi.Input[builtins.str]
        """
        Resource name for the secret required as a URL parameter.
        """
        state: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
elif False:
    TriggerWebhookConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class TriggerWebhookConfigArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[builtins.str],
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] secret: Resource name for the secret required as a URL parameter.
        :param pulumi.Input[builtins.str] state: (Output)
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[builtins.str]:
        """
        Resource name for the secret required as a URL parameter.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


if not MYPY:
    class WorkerPoolNetworkConfigArgsDict(TypedDict):
        peered_network: pulumi.Input[builtins.str]
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        peered_network_ip_range: NotRequired[pulumi.Input[builtins.str]]
        """
        Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
        """
elif False:
    WorkerPoolNetworkConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkerPoolNetworkConfigArgs:
    def __init__(__self__, *,
                 peered_network: pulumi.Input[builtins.str],
                 peered_network_ip_range: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        :param pulumi.Input[builtins.str] peered_network_ip_range: Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
        """
        pulumi.set(__self__, "peered_network", peered_network)
        if peered_network_ip_range is not None:
            pulumi.set(__self__, "peered_network_ip_range", peered_network_ip_range)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Input[builtins.str]:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "peered_network", value)

    @property
    @pulumi.getter(name="peeredNetworkIpRange")
    def peered_network_ip_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Immutable. Subnet IP range within the peered network. This is specified in CIDR notation with a slash and the subnet prefix size. You can optionally specify an IP address before the subnet prefix value. e.g. `192.168.0.0/29` would specify an IP range starting at 192.168.0.0 with a prefix size of 29 bits. `/16` would specify a prefix size of 16 bits, with an automatically determined IP within the peered VPC. If unspecified, a value of `/24` will be used.
        """
        return pulumi.get(self, "peered_network_ip_range")

    @peered_network_ip_range.setter
    def peered_network_ip_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "peered_network_ip_range", value)


if not MYPY:
    class WorkerPoolPrivateServiceConnectArgsDict(TypedDict):
        network_attachment: pulumi.Input[builtins.str]
        """
        Required. Immutable. The network attachment that the worker network interface is connected to. Must be in the format `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`. The region of network attachment must be the same as the worker pool. See [Network Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
        """
        route_all_traffic: NotRequired[pulumi.Input[builtins.bool]]
        """
        Immutable. Route all traffic through PSC interface. Enable this if you want full control of traffic in the private pool. Configure Cloud NAT for the subnet of network attachment if you need to access public Internet. If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16 through PSC interface.
        """
elif False:
    WorkerPoolPrivateServiceConnectArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkerPoolPrivateServiceConnectArgs:
    def __init__(__self__, *,
                 network_attachment: pulumi.Input[builtins.str],
                 route_all_traffic: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] network_attachment: Required. Immutable. The network attachment that the worker network interface is connected to. Must be in the format `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`. The region of network attachment must be the same as the worker pool. See [Network Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
        :param pulumi.Input[builtins.bool] route_all_traffic: Immutable. Route all traffic through PSC interface. Enable this if you want full control of traffic in the private pool. Configure Cloud NAT for the subnet of network attachment if you need to access public Internet. If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16 through PSC interface.
        """
        pulumi.set(__self__, "network_attachment", network_attachment)
        if route_all_traffic is not None:
            pulumi.set(__self__, "route_all_traffic", route_all_traffic)

    @property
    @pulumi.getter(name="networkAttachment")
    def network_attachment(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. The network attachment that the worker network interface is connected to. Must be in the format `projects/{project}/regions/{region}/networkAttachments/{networkAttachment}`. The region of network attachment must be the same as the worker pool. See [Network Attachments](https://cloud.google.com/vpc/docs/about-network-attachments)
        """
        return pulumi.get(self, "network_attachment")

    @network_attachment.setter
    def network_attachment(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_attachment", value)

    @property
    @pulumi.getter(name="routeAllTraffic")
    def route_all_traffic(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Immutable. Route all traffic through PSC interface. Enable this if you want full control of traffic in the private pool. Configure Cloud NAT for the subnet of network attachment if you need to access public Internet. If false, Only route private IPs, e.g. 10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16 through PSC interface.
        """
        return pulumi.get(self, "route_all_traffic")

    @route_all_traffic.setter
    def route_all_traffic(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "route_all_traffic", value)


if not MYPY:
    class WorkerPoolWorkerConfigArgsDict(TypedDict):
        disk_size_gb: NotRequired[pulumi.Input[builtins.int]]
        """
        Size of the disk attached to the worker, in GB. See [diskSizeGb](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#disksizegb). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        machine_type: NotRequired[pulumi.Input[builtins.str]]
        """
        Machine type of a worker, such as `n1-standard-1`. See [machineType](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#machinetype). If left blank, Cloud Build will use `n1-standard-1`.
        """
        no_external_ip: NotRequired[pulumi.Input[builtins.bool]]
        """
        If true, workers are created without any public address, which prevents network egress to public IPs.
        """
elif False:
    WorkerPoolWorkerConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class WorkerPoolWorkerConfigArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 no_external_ip: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.int] disk_size_gb: Size of the disk attached to the worker, in GB. See [diskSizeGb](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#disksizegb). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param pulumi.Input[builtins.str] machine_type: Machine type of a worker, such as `n1-standard-1`. See [machineType](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#machinetype). If left blank, Cloud Build will use `n1-standard-1`.
        :param pulumi.Input[builtins.bool] no_external_ip: If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if no_external_ip is not None:
            pulumi.set(__self__, "no_external_ip", no_external_ip)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of the disk attached to the worker, in GB. See [diskSizeGb](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#disksizegb). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Machine type of a worker, such as `n1-standard-1`. See [machineType](https://cloud.google.com/build/docs/private-pools/private-pool-config-file-schema#machinetype). If left blank, Cloud Build will use `n1-standard-1`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="noExternalIp")
    def no_external_ip(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        return pulumi.get(self, "no_external_ip")

    @no_external_ip.setter
    def no_external_ip(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "no_external_ip", value)


