# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionBitbucketCloudConfigArgs',
    'ConnectionBitbucketCloudConfigArgsDict',
    'ConnectionBitbucketCloudConfigAuthorizerCredentialArgs',
    'ConnectionBitbucketCloudConfigAuthorizerCredentialArgsDict',
    'ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs',
    'ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgsDict',
    'ConnectionBitbucketDataCenterConfigArgs',
    'ConnectionBitbucketDataCenterConfigArgsDict',
    'ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs',
    'ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgsDict',
    'ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs',
    'ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgsDict',
    'ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs',
    'ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgsDict',
    'ConnectionGithubConfigArgs',
    'ConnectionGithubConfigArgsDict',
    'ConnectionGithubConfigAuthorizerCredentialArgs',
    'ConnectionGithubConfigAuthorizerCredentialArgsDict',
    'ConnectionGithubEnterpriseConfigArgs',
    'ConnectionGithubEnterpriseConfigArgsDict',
    'ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs',
    'ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgsDict',
    'ConnectionGitlabConfigArgs',
    'ConnectionGitlabConfigArgsDict',
    'ConnectionGitlabConfigAuthorizerCredentialArgs',
    'ConnectionGitlabConfigAuthorizerCredentialArgsDict',
    'ConnectionGitlabConfigReadAuthorizerCredentialArgs',
    'ConnectionGitlabConfigReadAuthorizerCredentialArgsDict',
    'ConnectionGitlabConfigServiceDirectoryConfigArgs',
    'ConnectionGitlabConfigServiceDirectoryConfigArgsDict',
    'ConnectionIAMBindingConditionArgs',
    'ConnectionIAMBindingConditionArgsDict',
    'ConnectionIAMMemberConditionArgs',
    'ConnectionIAMMemberConditionArgsDict',
    'ConnectionInstallationStateArgs',
    'ConnectionInstallationStateArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionBitbucketCloudConfigArgsDict(TypedDict):
        authorizer_credential: pulumi.Input['ConnectionBitbucketCloudConfigAuthorizerCredentialArgsDict']
        """
        Required. An access token with the `webhook`, `repository`, `repository:admin` and `pullrequest` scope access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate these credentials.
        Structure is documented below.
        """
        read_authorizer_credential: pulumi.Input['ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgsDict']
        """
        Required. An access token with the `repository` access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate the credentials.
        Structure is documented below.
        """
        webhook_secret_secret_version: pulumi.Input[builtins.str]
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        """
        workspace: pulumi.Input[builtins.str]
        """
        The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        """
elif False:
    ConnectionBitbucketCloudConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketCloudConfigArgs:
    def __init__(__self__, *,
                 authorizer_credential: pulumi.Input['ConnectionBitbucketCloudConfigAuthorizerCredentialArgs'],
                 read_authorizer_credential: pulumi.Input['ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs'],
                 webhook_secret_secret_version: pulumi.Input[builtins.str],
                 workspace: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input['ConnectionBitbucketCloudConfigAuthorizerCredentialArgs'] authorizer_credential: Required. An access token with the `webhook`, `repository`, `repository:admin` and `pullrequest` scope access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate these credentials.
               Structure is documented below.
        :param pulumi.Input['ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs'] read_authorizer_credential: Required. An access token with the `repository` access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate the credentials.
               Structure is documented below.
        :param pulumi.Input[builtins.str] webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] workspace: The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        pulumi.set(__self__, "workspace", workspace)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> pulumi.Input['ConnectionBitbucketCloudConfigAuthorizerCredentialArgs']:
        """
        Required. An access token with the `webhook`, `repository`, `repository:admin` and `pullrequest` scope access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate these credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: pulumi.Input['ConnectionBitbucketCloudConfigAuthorizerCredentialArgs']):
        pulumi.set(self, "authorizer_credential", value)

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> pulumi.Input['ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs']:
        """
        Required. An access token with the `repository` access. It can be either a workspace, project or repository access token. It's recommended to use a system account to generate the credentials.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @read_authorizer_credential.setter
    def read_authorizer_credential(self, value: pulumi.Input['ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs']):
        pulumi.set(self, "read_authorizer_credential", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "webhook_secret_secret_version", value)

    @property
    @pulumi.getter
    def workspace(self) -> pulumi.Input[builtins.str]:
        """
        The Bitbucket Cloud Workspace ID to be connected to Google Cloud Platform.
        """
        return pulumi.get(self, "workspace")

    @workspace.setter
    def workspace(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "workspace", value)


if not MYPY:
    class ConnectionBitbucketCloudConfigAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionBitbucketCloudConfigAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketCloudConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketCloudConfigReadAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionBitbucketDataCenterConfigArgsDict(TypedDict):
        authorizer_credential: pulumi.Input['ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgsDict']
        """
        Required. A http access token with the `REPO_ADMIN` scope access.
        Structure is documented below.
        """
        host_uri: pulumi.Input[builtins.str]
        """
        The URI of the Bitbucket Data Center host this connection is for.
        """
        read_authorizer_credential: pulumi.Input['ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgsDict']
        """
        Required. A http access token with the `REPO_READ` access.
        Structure is documented below.
        """
        webhook_secret_secret_version: pulumi.Input[builtins.str]
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        """
        server_version: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Version of the Bitbucket Data Center running on the `host_uri`.
        """
        service_directory_config: NotRequired[pulumi.Input['ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgsDict']]
        """
        Configuration for using Service Directory to privately connect to a Bitbucket Data Center. This should only be set if the Bitbucket Data Center is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the Bitbucket Data Center will be made over the public internet.
        Structure is documented below.
        """
        ssl_ca: NotRequired[pulumi.Input[builtins.str]]
        """
        SSL certificate to use for requests to the Bitbucket Data Center.
        """
elif False:
    ConnectionBitbucketDataCenterConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketDataCenterConfigArgs:
    def __init__(__self__, *,
                 authorizer_credential: pulumi.Input['ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs'],
                 host_uri: pulumi.Input[builtins.str],
                 read_authorizer_credential: pulumi.Input['ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs'],
                 webhook_secret_secret_version: pulumi.Input[builtins.str],
                 server_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_config: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs'] authorizer_credential: Required. A http access token with the `REPO_ADMIN` scope access.
               Structure is documented below.
        :param pulumi.Input[builtins.str] host_uri: The URI of the Bitbucket Data Center host this connection is for.
        :param pulumi.Input['ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs'] read_authorizer_credential: Required. A http access token with the `REPO_READ` access.
               Structure is documented below.
        :param pulumi.Input[builtins.str] webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] server_version: (Output)
               Output only. Version of the Bitbucket Data Center running on the `host_uri`.
        :param pulumi.Input['ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs'] service_directory_config: Configuration for using Service Directory to privately connect to a Bitbucket Data Center. This should only be set if the Bitbucket Data Center is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the Bitbucket Data Center will be made over the public internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to the Bitbucket Data Center.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> pulumi.Input['ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs']:
        """
        Required. A http access token with the `REPO_ADMIN` scope access.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: pulumi.Input['ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs']):
        pulumi.set(self, "authorizer_credential", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Input[builtins.str]:
        """
        The URI of the Bitbucket Data Center host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> pulumi.Input['ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs']:
        """
        Required. A http access token with the `REPO_READ` access.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @read_authorizer_credential.setter
    def read_authorizer_credential(self, value: pulumi.Input['ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs']):
        pulumi.set(self, "read_authorizer_credential", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. SecretManager resource containing the webhook secret used to verify webhook events, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "webhook_secret_secret_version", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Version of the Bitbucket Data Center running on the `host_uri`.
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs']]:
        """
        Configuration for using Service Directory to privately connect to a Bitbucket Data Center. This should only be set if the Bitbucket Data Center is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the Bitbucket Data Center will be made over the public internet.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSL certificate to use for requests to the Bitbucket Data Center.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)


if not MYPY:
    class ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketDataCenterConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketDataCenterConfigReadAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgsDict(TypedDict):
        service: pulumi.Input[builtins.str]
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
elif False:
    ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionBitbucketDataCenterConfigServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] service: Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)


if not MYPY:
    class ConnectionGithubConfigArgsDict(TypedDict):
        app_installation_id: NotRequired[pulumi.Input[builtins.int]]
        """
        GitHub App installation id.
        """
        authorizer_credential: NotRequired[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgsDict']]
        """
        OAuth credential of the account that authorized the Cloud Build GitHub App. It is recommended to use a robot account instead of a human user account. The OAuth token must be tied to the Cloud Build GitHub App.
        Structure is documented below.
        """
elif False:
    ConnectionGithubConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubConfigArgs:
    def __init__(__self__, *,
                 app_installation_id: Optional[pulumi.Input[builtins.int]] = None,
                 authorizer_credential: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']] = None):
        """
        :param pulumi.Input[builtins.int] app_installation_id: GitHub App installation id.
        :param pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs'] authorizer_credential: OAuth credential of the account that authorized the Cloud Build GitHub App. It is recommended to use a robot account instead of a human user account. The OAuth token must be tied to the Cloud Build GitHub App.
               Structure is documented below.
        """
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if authorizer_credential is not None:
            pulumi.set(__self__, "authorizer_credential", authorizer_credential)

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        GitHub App installation id.
        """
        return pulumi.get(self, "app_installation_id")

    @app_installation_id.setter
    def app_installation_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "app_installation_id", value)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]:
        """
        OAuth credential of the account that authorized the Cloud Build GitHub App. It is recommended to use a robot account instead of a human user account. The OAuth token must be tied to the Cloud Build GitHub App.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: Optional[pulumi.Input['ConnectionGithubConfigAuthorizerCredentialArgs']]):
        pulumi.set(self, "authorizer_credential", value)


if not MYPY:
    class ConnectionGithubConfigAuthorizerCredentialArgsDict(TypedDict):
        oauth_token_secret_version: NotRequired[pulumi.Input[builtins.str]]
        """
        A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionGithubConfigAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 oauth_token_secret_version: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] oauth_token_secret_version: A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        if oauth_token_secret_version is not None:
            pulumi.set(__self__, "oauth_token_secret_version", oauth_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="oauthTokenSecretVersion")
    def oauth_token_secret_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A SecretManager resource containing the OAuth token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "oauth_token_secret_version")

    @oauth_token_secret_version.setter
    def oauth_token_secret_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "oauth_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionGithubEnterpriseConfigArgsDict(TypedDict):
        host_uri: pulumi.Input[builtins.str]
        """
        Required. The URI of the GitHub Enterprise host this connection is for.
        """
        app_id: NotRequired[pulumi.Input[builtins.int]]
        """
        Id of the GitHub App created from the manifest.
        """
        app_installation_id: NotRequired[pulumi.Input[builtins.int]]
        """
        ID of the installation of the GitHub App.
        """
        app_slug: NotRequired[pulumi.Input[builtins.str]]
        """
        The URL-friendly name of the GitHub App.
        """
        private_key_secret_version: NotRequired[pulumi.Input[builtins.str]]
        """
        SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        service_directory_config: NotRequired[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgsDict']]
        """
        Configuration for using Service Directory to privately connect to a GitHub Enterprise server. This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
        Structure is documented below.
        """
        ssl_ca: NotRequired[pulumi.Input[builtins.str]]
        """
        SSL certificate to use for requests to GitHub Enterprise.
        """
        webhook_secret_secret_version: NotRequired[pulumi.Input[builtins.str]]
        """
        SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
elif False:
    ConnectionGithubEnterpriseConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubEnterpriseConfigArgs:
    def __init__(__self__, *,
                 host_uri: pulumi.Input[builtins.str],
                 app_id: Optional[pulumi.Input[builtins.int]] = None,
                 app_installation_id: Optional[pulumi.Input[builtins.int]] = None,
                 app_slug: Optional[pulumi.Input[builtins.str]] = None,
                 private_key_secret_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_config: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 webhook_secret_secret_version: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] host_uri: Required. The URI of the GitHub Enterprise host this connection is for.
        :param pulumi.Input[builtins.int] app_id: Id of the GitHub App created from the manifest.
        :param pulumi.Input[builtins.int] app_installation_id: ID of the installation of the GitHub App.
        :param pulumi.Input[builtins.str] app_slug: The URL-friendly name of the GitHub App.
        :param pulumi.Input[builtins.str] private_key_secret_version: SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs'] service_directory_config: Configuration for using Service Directory to privately connect to a GitHub Enterprise server. This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to GitHub Enterprise.
        :param pulumi.Input[builtins.str] webhook_secret_secret_version: SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        pulumi.set(__self__, "host_uri", host_uri)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_installation_id is not None:
            pulumi.set(__self__, "app_installation_id", app_installation_id)
        if app_slug is not None:
            pulumi.set(__self__, "app_slug", app_slug)
        if private_key_secret_version is not None:
            pulumi.set(__self__, "private_key_secret_version", private_key_secret_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if webhook_secret_secret_version is not None:
            pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> pulumi.Input[builtins.str]:
        """
        Required. The URI of the GitHub Enterprise host this connection is for.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Id of the GitHub App created from the manifest.
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appInstallationId")
    def app_installation_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        ID of the installation of the GitHub App.
        """
        return pulumi.get(self, "app_installation_id")

    @app_installation_id.setter
    def app_installation_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "app_installation_id", value)

    @property
    @pulumi.getter(name="appSlug")
    def app_slug(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL-friendly name of the GitHub App.
        """
        return pulumi.get(self, "app_slug")

    @app_slug.setter
    def app_slug(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "app_slug", value)

    @property
    @pulumi.getter(name="privateKeySecretVersion")
    def private_key_secret_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SecretManager resource containing the private key of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "private_key_secret_version")

    @private_key_secret_version.setter
    def private_key_secret_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key_secret_version", value)

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']]:
        """
        Configuration for using Service Directory to privately connect to a GitHub Enterprise server. This should only be set if the GitHub Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitHub Enterprise server will be made over the public internet.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSL certificate to use for requests to GitHub Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SecretManager resource containing the webhook secret of the GitHub App, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "webhook_secret_secret_version", value)


if not MYPY:
    class ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgsDict(TypedDict):
        service: pulumi.Input[builtins.str]
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
elif False:
    ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGithubEnterpriseConfigServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] service: Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)


if not MYPY:
    class ConnectionGitlabConfigArgsDict(TypedDict):
        authorizer_credential: pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgsDict']
        """
        Required. A GitLab personal access token with the `api` scope access.
        Structure is documented below.
        """
        read_authorizer_credential: pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgsDict']
        """
        Required. A GitLab personal access token with the minimum `read_api` scope access.
        Structure is documented below.
        """
        webhook_secret_secret_version: pulumi.Input[builtins.str]
        """
        Required. Immutable. SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
        """
        host_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        The URI of the GitLab Enterprise host this connection is for. If not specified, the default value is https://gitlab.com.
        """
        server_version: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        """
        service_directory_config: NotRequired[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgsDict']]
        """
        Configuration for using Service Directory to privately connect to a GitLab Enterprise server. This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
        Structure is documented below.
        """
        ssl_ca: NotRequired[pulumi.Input[builtins.str]]
        """
        SSL certificate to use for requests to GitLab Enterprise.
        """
elif False:
    ConnectionGitlabConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGitlabConfigArgs:
    def __init__(__self__, *,
                 authorizer_credential: pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs'],
                 read_authorizer_credential: pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs'],
                 webhook_secret_secret_version: pulumi.Input[builtins.str],
                 host_uri: Optional[pulumi.Input[builtins.str]] = None,
                 server_version: Optional[pulumi.Input[builtins.str]] = None,
                 service_directory_config: Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs'] authorizer_credential: Required. A GitLab personal access token with the `api` scope access.
               Structure is documented below.
        :param pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs'] read_authorizer_credential: Required. A GitLab personal access token with the minimum `read_api` scope access.
               Structure is documented below.
        :param pulumi.Input[builtins.str] webhook_secret_secret_version: Required. Immutable. SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] host_uri: The URI of the GitLab Enterprise host this connection is for. If not specified, the default value is https://gitlab.com.
        :param pulumi.Input[builtins.str] server_version: (Output)
               Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        :param pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs'] service_directory_config: Configuration for using Service Directory to privately connect to a GitLab Enterprise server. This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
               Structure is documented below.
        :param pulumi.Input[builtins.str] ssl_ca: SSL certificate to use for requests to GitLab Enterprise.
        """
        pulumi.set(__self__, "authorizer_credential", authorizer_credential)
        pulumi.set(__self__, "read_authorizer_credential", read_authorizer_credential)
        pulumi.set(__self__, "webhook_secret_secret_version", webhook_secret_secret_version)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if server_version is not None:
            pulumi.set(__self__, "server_version", server_version)
        if service_directory_config is not None:
            pulumi.set(__self__, "service_directory_config", service_directory_config)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)

    @property
    @pulumi.getter(name="authorizerCredential")
    def authorizer_credential(self) -> pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs']:
        """
        Required. A GitLab personal access token with the `api` scope access.
        Structure is documented below.
        """
        return pulumi.get(self, "authorizer_credential")

    @authorizer_credential.setter
    def authorizer_credential(self, value: pulumi.Input['ConnectionGitlabConfigAuthorizerCredentialArgs']):
        pulumi.set(self, "authorizer_credential", value)

    @property
    @pulumi.getter(name="readAuthorizerCredential")
    def read_authorizer_credential(self) -> pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs']:
        """
        Required. A GitLab personal access token with the minimum `read_api` scope access.
        Structure is documented below.
        """
        return pulumi.get(self, "read_authorizer_credential")

    @read_authorizer_credential.setter
    def read_authorizer_credential(self, value: pulumi.Input['ConnectionGitlabConfigReadAuthorizerCredentialArgs']):
        pulumi.set(self, "read_authorizer_credential", value)

    @property
    @pulumi.getter(name="webhookSecretSecretVersion")
    def webhook_secret_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. Immutable. SecretManager resource containing the webhook secret of a GitLab Enterprise project, formatted as `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "webhook_secret_secret_version")

    @webhook_secret_secret_version.setter
    def webhook_secret_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "webhook_secret_secret_version", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the GitLab Enterprise host this connection is for. If not specified, the default value is https://gitlab.com.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="serverVersion")
    def server_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Version of the GitLab Enterprise server running on the `host_uri`.
        """
        return pulumi.get(self, "server_version")

    @server_version.setter
    def server_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "server_version", value)

    @property
    @pulumi.getter(name="serviceDirectoryConfig")
    def service_directory_config(self) -> Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']]:
        """
        Configuration for using Service Directory to privately connect to a GitLab Enterprise server. This should only be set if the GitLab Enterprise server is hosted on-premises and not reachable by public internet. If this field is left empty, calls to the GitLab Enterprise server will be made over the public internet.
        Structure is documented below.
        """
        return pulumi.get(self, "service_directory_config")

    @service_directory_config.setter
    def service_directory_config(self, value: Optional[pulumi.Input['ConnectionGitlabConfigServiceDirectoryConfigArgs']]):
        pulumi.set(self, "service_directory_config", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SSL certificate to use for requests to GitLab Enterprise.
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)


if not MYPY:
    class ConnectionGitlabConfigAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionGitlabConfigAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGitlabConfigAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionGitlabConfigReadAuthorizerCredentialArgsDict(TypedDict):
        user_token_secret_version: pulumi.Input[builtins.str]
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The username associated to this token.
        """
elif False:
    ConnectionGitlabConfigReadAuthorizerCredentialArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGitlabConfigReadAuthorizerCredentialArgs:
    def __init__(__self__, *,
                 user_token_secret_version: pulumi.Input[builtins.str],
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] user_token_secret_version: Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        :param pulumi.Input[builtins.str] username: (Output)
               Output only. The username associated to this token.
        """
        pulumi.set(__self__, "user_token_secret_version", user_token_secret_version)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="userTokenSecretVersion")
    def user_token_secret_version(self) -> pulumi.Input[builtins.str]:
        """
        Required. A SecretManager resource containing the user token that authorizes the Cloud Build connection. Format: `projects/*/secrets/*/versions/*`.
        """
        return pulumi.get(self, "user_token_secret_version")

    @user_token_secret_version.setter
    def user_token_secret_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_token_secret_version", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The username associated to this token.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionGitlabConfigServiceDirectoryConfigArgsDict(TypedDict):
        service: pulumi.Input[builtins.str]
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
elif False:
    ConnectionGitlabConfigServiceDirectoryConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionGitlabConfigServiceDirectoryConfigArgs:
    def __init__(__self__, *,
                 service: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] service: Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[builtins.str]:
        """
        Required. The Service Directory service name. Format: projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service", value)


if not MYPY:
    class ConnectionIAMBindingConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        title: pulumi.Input[builtins.str]
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ConnectionIAMBindingConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionIAMBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class ConnectionIAMMemberConditionArgsDict(TypedDict):
        expression: pulumi.Input[builtins.str]
        title: pulumi.Input[builtins.str]
        description: NotRequired[pulumi.Input[builtins.str]]
elif False:
    ConnectionIAMMemberConditionArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionIAMMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[builtins.str],
                 title: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[builtins.str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


if not MYPY:
    class ConnectionInstallationStateArgsDict(TypedDict):
        action_uri: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Link to follow for next action. Empty string if the installation is already complete.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Message of what the user should do next to continue the installation. Empty string if the installation is already complete.
        """
        stage: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. Current step of the installation process.
        """
elif False:
    ConnectionInstallationStateArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionInstallationStateArgs:
    def __init__(__self__, *,
                 action_uri: Optional[pulumi.Input[builtins.str]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None,
                 stage: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] action_uri: (Output)
               Output only. Link to follow for next action. Empty string if the installation is already complete.
        :param pulumi.Input[builtins.str] message: (Output)
               Output only. Message of what the user should do next to continue the installation. Empty string if the installation is already complete.
        :param pulumi.Input[builtins.str] stage: (Output)
               Output only. Current step of the installation process.
        """
        if action_uri is not None:
            pulumi.set(__self__, "action_uri", action_uri)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if stage is not None:
            pulumi.set(__self__, "stage", stage)

    @property
    @pulumi.getter(name="actionUri")
    def action_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Link to follow for next action. Empty string if the installation is already complete.
        """
        return pulumi.get(self, "action_uri")

    @action_uri.setter
    def action_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action_uri", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Message of what the user should do next to continue the installation. Empty string if the installation is already complete.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def stage(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. Current step of the installation process.
        """
        return pulumi.get(self, "stage")

    @stage.setter
    def stage(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stage", value)


