# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AutomationArgs', 'Automation']

@pulumi.input_type
class AutomationArgs:
    def __init__(__self__, *,
                 delivery_pipeline: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]],
                 selector: pulumi.Input['AutomationSelectorArgs'],
                 service_account: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a Automation resource.
        :param pulumi.Input[builtins.str] delivery_pipeline: The delivery_pipeline for the resource
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]] rules: Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
               Structure is documented below.
        :param pulumi.Input['AutomationSelectorArgs'] selector: Required. Selected resources to which the automation will be applied.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] description: Optional. Description of the `Automation`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the `Automation`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.bool] suspended: Optional. When Suspended, automation is deactivated from execution.
        """
        pulumi.set(__self__, "delivery_pipeline", delivery_pipeline)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "selector", selector)
        pulumi.set(__self__, "service_account", service_account)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)

    @property
    @pulumi.getter(name="deliveryPipeline")
    def delivery_pipeline(self) -> pulumi.Input[builtins.str]:
        """
        The delivery_pipeline for the resource
        """
        return pulumi.get(self, "delivery_pipeline")

    @delivery_pipeline.setter
    def delivery_pipeline(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "delivery_pipeline", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]]:
        """
        Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Input['AutomationSelectorArgs']:
        """
        Required. Selected resources to which the automation will be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: pulumi.Input['AutomationSelectorArgs']):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Input[builtins.str]:
        """
        Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Description of the `Automation`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the `Automation`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. When Suspended, automation is deactivated from execution.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)


@pulumi.input_type
class _AutomationState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 delivery_pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]]] = None,
                 selector: Optional[pulumi.Input['AutomationSelectorArgs']] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Automation resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. Time at which the automation was created.
        :param pulumi.Input[builtins.str] delivery_pipeline: The delivery_pipeline for the resource
        :param pulumi.Input[builtins.str] description: Optional. Description of the `Automation`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Optional. The weak etag of the `Automation` resource. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] name: Name of the `Automation`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]] rules: Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
               Structure is documented below.
        :param pulumi.Input['AutomationSelectorArgs'] selector: Required. Selected resources to which the automation will be applied.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        :param pulumi.Input[builtins.bool] suspended: Optional. When Suspended, automation is deactivated from execution.
        :param pulumi.Input[builtins.str] uid: Output only. Unique identifier of the `Automation`.
        :param pulumi.Input[builtins.str] update_time: Output only. Time at which the automation was updated.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if delivery_pipeline is not None:
            pulumi.set(__self__, "delivery_pipeline", delivery_pipeline)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if suspended is not None:
            pulumi.set(__self__, "suspended", suspended)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Time at which the automation was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deliveryPipeline")
    def delivery_pipeline(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The delivery_pipeline for the resource
        """
        return pulumi.get(self, "delivery_pipeline")

    @delivery_pipeline.setter
    def delivery_pipeline(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delivery_pipeline", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. Description of the `Automation`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The weak etag of the `Automation` resource. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the `Automation`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]]]:
        """
        Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AutomationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input['AutomationSelectorArgs']]:
        """
        Required. Selected resources to which the automation will be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input['AutomationSelectorArgs']]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def suspended(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Optional. When Suspended, automation is deactivated from execution.
        """
        return pulumi.get(self, "suspended")

    @suspended.setter
    def suspended(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "suspended", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Unique identifier of the `Automation`.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Time at which the automation was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:clouddeploy/automation:Automation")
class Automation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delivery_pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomationRuleArgs', 'AutomationRuleArgsDict']]]]] = None,
                 selector: Optional[pulumi.Input[Union['AutomationSelectorArgs', 'AutomationSelectorArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        An `Automation` enables the automation of manually driven actions for a Delivery Pipeline, which includes Release promotion amongst Targets, Rollout repair and Rollout deployment strategy advancement.

        To get more information about Automation, see:

        * [API documentation](https://cloud.google.com/deploy/docs/api/reference/rest/v1/projects.locations.deliveryPipelines.automations)
        * How-to Guides
            * [Automate your deployment](https://cloud.google.com/deploy/docs/automation)

        ## Example Usage

        ### Clouddeploy Automation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.clouddeploy.DeliveryPipeline("pipeline",
            name="cd-pipeline",
            location="us-central1",
            serial_pipeline={
                "stages": [{
                    "target_id": "test",
                    "profiles": [],
                }],
            })
        b_automation = gcp.clouddeploy.Automation("b-automation",
            name="cd-automation",
            project=pipeline.project,
            location=pipeline.location,
            delivery_pipeline=pipeline.name,
            service_account="my@service-account.com",
            selector={
                "targets": [{
                    "id": "*",
                }],
            },
            rules=[
                {
                    "promote_release_rule": {
                        "id": "promote-release",
                    },
                },
                {
                    "advance_rollout_rule": {
                        "id": "advance-rollout",
                    },
                },
                {
                    "repair_rollout_rule": {
                        "id": "repair-rollout",
                        "repair_phases": [
                            {
                                "retry": {
                                    "attempts": "1",
                                },
                            },
                            {
                                "rollback": {},
                            },
                        ],
                    },
                },
                {
                    "timed_promote_release_rule": {
                        "id": "timed-promote-release",
                        "schedule": "0 9 * * 1",
                        "time_zone": "America/New_York",
                    },
                },
            ])
        ```
        ### Clouddeploy Automation Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.clouddeploy.DeliveryPipeline("pipeline",
            name="cd-pipeline",
            location="us-central1",
            serial_pipeline={
                "stages": [{
                    "target_id": "test",
                    "profiles": ["test-profile"],
                }],
            })
        f_automation = gcp.clouddeploy.Automation("f-automation",
            name="cd-automation",
            location="us-central1",
            delivery_pipeline=pipeline.name,
            service_account="my@service-account.com",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            description="automation resource",
            selector={
                "targets": [{
                    "id": "test",
                    "labels": {
                        "foo": "bar",
                    },
                }],
            },
            suspended=True,
            rules=[
                {
                    "promote_release_rule": {
                        "id": "promote-release",
                        "wait": "200s",
                        "destination_target_id": "@next",
                        "destination_phase": "stable",
                    },
                },
                {
                    "advance_rollout_rule": {
                        "id": "advance-rollout",
                        "source_phases": ["canary"],
                        "wait": "200s",
                    },
                },
                {
                    "repair_rollout_rule": {
                        "id": "repair-rollout",
                        "phases": ["stable"],
                        "jobs": ["deploy"],
                        "repair_phases": [
                            {
                                "retry": {
                                    "attempts": "1",
                                    "wait": "200s",
                                    "backoff_mode": "BACKOFF_MODE_LINEAR",
                                },
                            },
                            {
                                "rollback": {
                                    "destination_phase": "stable",
                                    "disable_rollback_if_rollout_pending": True,
                                },
                            },
                        ],
                    },
                },
                {
                    "timed_promote_release_rule": {
                        "id": "timed-promote-release",
                        "destination_target_id": "@next",
                        "schedule": "0 9 * * 1",
                        "time_zone": "America/New_York",
                        "destination_phase": "stable",
                    },
                },
            ])
        ```

        ## Import

        Automation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/deliveryPipelines/{{delivery_pipeline}}/automations/{{name}}`

        * `{{project}}/{{location}}/{{delivery_pipeline}}/{{name}}`

        * `{{location}}/{{delivery_pipeline}}/{{name}}`

        When using the `pulumi import` command, Automation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default projects/{{project}}/locations/{{location}}/deliveryPipelines/{{delivery_pipeline}}/automations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default {{project}}/{{location}}/{{delivery_pipeline}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default {{location}}/{{delivery_pipeline}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] delivery_pipeline: The delivery_pipeline for the resource
        :param pulumi.Input[builtins.str] description: Optional. Description of the `Automation`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] name: Name of the `Automation`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutomationRuleArgs', 'AutomationRuleArgsDict']]]] rules: Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
               Structure is documented below.
        :param pulumi.Input[Union['AutomationSelectorArgs', 'AutomationSelectorArgsDict']] selector: Required. Selected resources to which the automation will be applied.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        :param pulumi.Input[builtins.bool] suspended: Optional. When Suspended, automation is deactivated from execution.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutomationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An `Automation` enables the automation of manually driven actions for a Delivery Pipeline, which includes Release promotion amongst Targets, Rollout repair and Rollout deployment strategy advancement.

        To get more information about Automation, see:

        * [API documentation](https://cloud.google.com/deploy/docs/api/reference/rest/v1/projects.locations.deliveryPipelines.automations)
        * How-to Guides
            * [Automate your deployment](https://cloud.google.com/deploy/docs/automation)

        ## Example Usage

        ### Clouddeploy Automation Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.clouddeploy.DeliveryPipeline("pipeline",
            name="cd-pipeline",
            location="us-central1",
            serial_pipeline={
                "stages": [{
                    "target_id": "test",
                    "profiles": [],
                }],
            })
        b_automation = gcp.clouddeploy.Automation("b-automation",
            name="cd-automation",
            project=pipeline.project,
            location=pipeline.location,
            delivery_pipeline=pipeline.name,
            service_account="my@service-account.com",
            selector={
                "targets": [{
                    "id": "*",
                }],
            },
            rules=[
                {
                    "promote_release_rule": {
                        "id": "promote-release",
                    },
                },
                {
                    "advance_rollout_rule": {
                        "id": "advance-rollout",
                    },
                },
                {
                    "repair_rollout_rule": {
                        "id": "repair-rollout",
                        "repair_phases": [
                            {
                                "retry": {
                                    "attempts": "1",
                                },
                            },
                            {
                                "rollback": {},
                            },
                        ],
                    },
                },
                {
                    "timed_promote_release_rule": {
                        "id": "timed-promote-release",
                        "schedule": "0 9 * * 1",
                        "time_zone": "America/New_York",
                    },
                },
            ])
        ```
        ### Clouddeploy Automation Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        pipeline = gcp.clouddeploy.DeliveryPipeline("pipeline",
            name="cd-pipeline",
            location="us-central1",
            serial_pipeline={
                "stages": [{
                    "target_id": "test",
                    "profiles": ["test-profile"],
                }],
            })
        f_automation = gcp.clouddeploy.Automation("f-automation",
            name="cd-automation",
            location="us-central1",
            delivery_pipeline=pipeline.name,
            service_account="my@service-account.com",
            annotations={
                "my_first_annotation": "example-annotation-1",
                "my_second_annotation": "example-annotation-2",
            },
            labels={
                "my_first_label": "example-label-1",
                "my_second_label": "example-label-2",
            },
            description="automation resource",
            selector={
                "targets": [{
                    "id": "test",
                    "labels": {
                        "foo": "bar",
                    },
                }],
            },
            suspended=True,
            rules=[
                {
                    "promote_release_rule": {
                        "id": "promote-release",
                        "wait": "200s",
                        "destination_target_id": "@next",
                        "destination_phase": "stable",
                    },
                },
                {
                    "advance_rollout_rule": {
                        "id": "advance-rollout",
                        "source_phases": ["canary"],
                        "wait": "200s",
                    },
                },
                {
                    "repair_rollout_rule": {
                        "id": "repair-rollout",
                        "phases": ["stable"],
                        "jobs": ["deploy"],
                        "repair_phases": [
                            {
                                "retry": {
                                    "attempts": "1",
                                    "wait": "200s",
                                    "backoff_mode": "BACKOFF_MODE_LINEAR",
                                },
                            },
                            {
                                "rollback": {
                                    "destination_phase": "stable",
                                    "disable_rollback_if_rollout_pending": True,
                                },
                            },
                        ],
                    },
                },
                {
                    "timed_promote_release_rule": {
                        "id": "timed-promote-release",
                        "destination_target_id": "@next",
                        "schedule": "0 9 * * 1",
                        "time_zone": "America/New_York",
                        "destination_phase": "stable",
                    },
                },
            ])
        ```

        ## Import

        Automation can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/deliveryPipelines/{{delivery_pipeline}}/automations/{{name}}`

        * `{{project}}/{{location}}/{{delivery_pipeline}}/{{name}}`

        * `{{location}}/{{delivery_pipeline}}/{{name}}`

        When using the `pulumi import` command, Automation can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default projects/{{project}}/locations/{{location}}/deliveryPipelines/{{delivery_pipeline}}/automations/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default {{project}}/{{location}}/{{delivery_pipeline}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:clouddeploy/automation:Automation default {{location}}/{{delivery_pipeline}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AutomationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutomationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delivery_pipeline: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomationRuleArgs', 'AutomationRuleArgsDict']]]]] = None,
                 selector: Optional[pulumi.Input[Union['AutomationSelectorArgs', 'AutomationSelectorArgsDict']]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 suspended: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutomationArgs.__new__(AutomationArgs)

            __props__.__dict__["annotations"] = annotations
            if delivery_pipeline is None and not opts.urn:
                raise TypeError("Missing required property 'delivery_pipeline'")
            __props__.__dict__["delivery_pipeline"] = delivery_pipeline
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if selector is None and not opts.urn:
                raise TypeError("Missing required property 'selector'")
            __props__.__dict__["selector"] = selector
            if service_account is None and not opts.urn:
                raise TypeError("Missing required property 'service_account'")
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["suspended"] = suspended
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Automation, __self__).__init__(
            'gcp:clouddeploy/automation:Automation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            delivery_pipeline: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AutomationRuleArgs', 'AutomationRuleArgsDict']]]]] = None,
            selector: Optional[pulumi.Input[Union['AutomationSelectorArgs', 'AutomationSelectorArgsDict']]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            suspended: Optional[pulumi.Input[builtins.bool]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Automation':
        """
        Get an existing Automation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. Time at which the automation was created.
        :param pulumi.Input[builtins.str] delivery_pipeline: The delivery_pipeline for the resource
        :param pulumi.Input[builtins.str] description: Optional. Description of the `Automation`. Max length is 255 characters.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] etag: Optional. The weak etag of the `Automation` resource. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[builtins.str] name: Name of the `Automation`.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AutomationRuleArgs', 'AutomationRuleArgsDict']]]] rules: Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
               Structure is documented below.
        :param pulumi.Input[Union['AutomationSelectorArgs', 'AutomationSelectorArgsDict']] selector: Required. Selected resources to which the automation will be applied.
               Structure is documented below.
        :param pulumi.Input[builtins.str] service_account: Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        :param pulumi.Input[builtins.bool] suspended: Optional. When Suspended, automation is deactivated from execution.
        :param pulumi.Input[builtins.str] uid: Output only. Unique identifier of the `Automation`.
        :param pulumi.Input[builtins.str] update_time: Output only. Time at which the automation was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutomationState.__new__(_AutomationState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["delivery_pipeline"] = delivery_pipeline
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["etag"] = etag
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["rules"] = rules
        __props__.__dict__["selector"] = selector
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["suspended"] = suspended
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Automation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. User annotations. These attributes can only be set and used by the user, and not by Cloud Deploy. Annotations must meet the following constraints: * Annotations are key/value pairs. * Valid annotation keys have two segments: an optional prefix and name, separated by a slash (`/`). * The name segment is required and must be 63 characters or less, beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between. * The prefix is optional. If specified, the prefix must be a DNS subdomain: a series of DNS labels separated by dots(`.`), not longer than 253 characters in total, followed by a slash (`/`). See https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set for more details.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Time at which the automation was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deliveryPipeline")
    def delivery_pipeline(self) -> pulumi.Output[builtins.str]:
        """
        The delivery_pipeline for the resource
        """
        return pulumi.get(self, "delivery_pipeline")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. Description of the `Automation`. Max length is 255 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The weak etag of the `Automation` resource. This checksum is computed by the server based on the value of other fields, and may be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Labels are attributes that can be set and used by both the user and by Cloud Deploy. Labels must meet the following constraints: * Keys and values can contain only lowercase letters, numeric characters, underscores, and dashes. * All characters must use UTF-8 encoding, and international characters are allowed. * Keys must start with a lowercase letter or international character. * Each resource is limited to a maximum of 64 labels. Both keys and values are additionally constrained to be <= 63 characters.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the `Automation`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.AutomationRule']]:
        """
        Required. List of Automation rules associated with the Automation resource. Must have at least one rule and limited to 250 rules per Delivery Pipeline. Note: the order of the rules here is not the same as the order of execution.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter
    def selector(self) -> pulumi.Output['outputs.AutomationSelector']:
        """
        Required. Selected resources to which the automation will be applied.
        Structure is documented below.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[builtins.str]:
        """
        Required. Email address of the user-managed IAM service account that creates Cloud Deploy release and rollout resources.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def suspended(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Optional. When Suspended, automation is deactivated from execution.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Unique identifier of the `Automation`.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Time at which the automation was updated.
        """
        return pulumi.get(self, "update_time")

