# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFunctionResult',
    'AwaitableGetFunctionResult',
    'get_function',
    'get_function_output',
]

@pulumi.output_type
class GetFunctionResult:
    """
    A collection of values returned by getFunction.
    """
    def __init__(__self__, available_memory_mb=None, build_environment_variables=None, build_service_account=None, build_worker_pool=None, description=None, docker_registry=None, docker_repository=None, effective_labels=None, entry_point=None, environment_variables=None, event_triggers=None, https_trigger_security_level=None, https_trigger_url=None, id=None, ingress_settings=None, kms_key_name=None, labels=None, max_instances=None, min_instances=None, name=None, project=None, pulumi_labels=None, region=None, runtime=None, secret_environment_variables=None, secret_volumes=None, service_account_email=None, source_archive_bucket=None, source_archive_object=None, source_repositories=None, status=None, timeout=None, trigger_http=None, version_id=None, vpc_connector=None, vpc_connector_egress_settings=None):
        if available_memory_mb and not isinstance(available_memory_mb, int):
            raise TypeError("Expected argument 'available_memory_mb' to be a int")
        pulumi.set(__self__, "available_memory_mb", available_memory_mb)
        if build_environment_variables and not isinstance(build_environment_variables, dict):
            raise TypeError("Expected argument 'build_environment_variables' to be a dict")
        pulumi.set(__self__, "build_environment_variables", build_environment_variables)
        if build_service_account and not isinstance(build_service_account, str):
            raise TypeError("Expected argument 'build_service_account' to be a str")
        pulumi.set(__self__, "build_service_account", build_service_account)
        if build_worker_pool and not isinstance(build_worker_pool, str):
            raise TypeError("Expected argument 'build_worker_pool' to be a str")
        pulumi.set(__self__, "build_worker_pool", build_worker_pool)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if docker_registry and not isinstance(docker_registry, str):
            raise TypeError("Expected argument 'docker_registry' to be a str")
        pulumi.set(__self__, "docker_registry", docker_registry)
        if docker_repository and not isinstance(docker_repository, str):
            raise TypeError("Expected argument 'docker_repository' to be a str")
        pulumi.set(__self__, "docker_repository", docker_repository)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if entry_point and not isinstance(entry_point, str):
            raise TypeError("Expected argument 'entry_point' to be a str")
        pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables and not isinstance(environment_variables, dict):
            raise TypeError("Expected argument 'environment_variables' to be a dict")
        pulumi.set(__self__, "environment_variables", environment_variables)
        if event_triggers and not isinstance(event_triggers, list):
            raise TypeError("Expected argument 'event_triggers' to be a list")
        pulumi.set(__self__, "event_triggers", event_triggers)
        if https_trigger_security_level and not isinstance(https_trigger_security_level, str):
            raise TypeError("Expected argument 'https_trigger_security_level' to be a str")
        pulumi.set(__self__, "https_trigger_security_level", https_trigger_security_level)
        if https_trigger_url and not isinstance(https_trigger_url, str):
            raise TypeError("Expected argument 'https_trigger_url' to be a str")
        pulumi.set(__self__, "https_trigger_url", https_trigger_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ingress_settings and not isinstance(ingress_settings, str):
            raise TypeError("Expected argument 'ingress_settings' to be a str")
        pulumi.set(__self__, "ingress_settings", ingress_settings)
        if kms_key_name and not isinstance(kms_key_name, str):
            raise TypeError("Expected argument 'kms_key_name' to be a str")
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if max_instances and not isinstance(max_instances, int):
            raise TypeError("Expected argument 'max_instances' to be a int")
        pulumi.set(__self__, "max_instances", max_instances)
        if min_instances and not isinstance(min_instances, int):
            raise TypeError("Expected argument 'min_instances' to be a int")
        pulumi.set(__self__, "min_instances", min_instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if runtime and not isinstance(runtime, str):
            raise TypeError("Expected argument 'runtime' to be a str")
        pulumi.set(__self__, "runtime", runtime)
        if secret_environment_variables and not isinstance(secret_environment_variables, list):
            raise TypeError("Expected argument 'secret_environment_variables' to be a list")
        pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if secret_volumes and not isinstance(secret_volumes, list):
            raise TypeError("Expected argument 'secret_volumes' to be a list")
        pulumi.set(__self__, "secret_volumes", secret_volumes)
        if service_account_email and not isinstance(service_account_email, str):
            raise TypeError("Expected argument 'service_account_email' to be a str")
        pulumi.set(__self__, "service_account_email", service_account_email)
        if source_archive_bucket and not isinstance(source_archive_bucket, str):
            raise TypeError("Expected argument 'source_archive_bucket' to be a str")
        pulumi.set(__self__, "source_archive_bucket", source_archive_bucket)
        if source_archive_object and not isinstance(source_archive_object, str):
            raise TypeError("Expected argument 'source_archive_object' to be a str")
        pulumi.set(__self__, "source_archive_object", source_archive_object)
        if source_repositories and not isinstance(source_repositories, list):
            raise TypeError("Expected argument 'source_repositories' to be a list")
        pulumi.set(__self__, "source_repositories", source_repositories)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if timeout and not isinstance(timeout, int):
            raise TypeError("Expected argument 'timeout' to be a int")
        pulumi.set(__self__, "timeout", timeout)
        if trigger_http and not isinstance(trigger_http, bool):
            raise TypeError("Expected argument 'trigger_http' to be a bool")
        pulumi.set(__self__, "trigger_http", trigger_http)
        if version_id and not isinstance(version_id, str):
            raise TypeError("Expected argument 'version_id' to be a str")
        pulumi.set(__self__, "version_id", version_id)
        if vpc_connector and not isinstance(vpc_connector, str):
            raise TypeError("Expected argument 'vpc_connector' to be a str")
        pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings and not isinstance(vpc_connector_egress_settings, str):
            raise TypeError("Expected argument 'vpc_connector_egress_settings' to be a str")
        pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="availableMemoryMb")
    def available_memory_mb(self) -> builtins.int:
        """
        Available memory (in MB) to the function.
        """
        return pulumi.get(self, "available_memory_mb")

    @property
    @pulumi.getter(name="buildEnvironmentVariables")
    def build_environment_variables(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "build_environment_variables")

    @property
    @pulumi.getter(name="buildServiceAccount")
    def build_service_account(self) -> builtins.str:
        return pulumi.get(self, "build_service_account")

    @property
    @pulumi.getter(name="buildWorkerPool")
    def build_worker_pool(self) -> builtins.str:
        return pulumi.get(self, "build_worker_pool")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of the function.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dockerRegistry")
    def docker_registry(self) -> builtins.str:
        return pulumi.get(self, "docker_registry")

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> builtins.str:
        return pulumi.get(self, "docker_repository")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> builtins.str:
        """
        Name of a JavaScript function that will be executed when the Google Cloud Function is triggered.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="eventTriggers")
    def event_triggers(self) -> Sequence['outputs.GetFunctionEventTriggerResult']:
        """
        A source that fires events in response to a condition in another service. Structure is documented below.
        """
        return pulumi.get(self, "event_triggers")

    @property
    @pulumi.getter(name="httpsTriggerSecurityLevel")
    def https_trigger_security_level(self) -> builtins.str:
        return pulumi.get(self, "https_trigger_security_level")

    @property
    @pulumi.getter(name="httpsTriggerUrl")
    def https_trigger_url(self) -> builtins.str:
        """
        If function is triggered by HTTP, trigger URL is set here.
        """
        return pulumi.get(self, "https_trigger_url")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> builtins.str:
        """
        Controls what traffic can reach the function.
        """
        return pulumi.get(self, "ingress_settings")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> builtins.str:
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> builtins.int:
        """
        The limit on the maximum number of function instances that may coexist at a given time. If unset or set to `0`, the API default will be used.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> builtins.int:
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the Cloud Function.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def runtime(self) -> builtins.str:
        """
        The runtime in which the function is running.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Sequence['outputs.GetFunctionSecretEnvironmentVariableResult']:
        return pulumi.get(self, "secret_environment_variables")

    @property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Sequence['outputs.GetFunctionSecretVolumeResult']:
        return pulumi.get(self, "secret_volumes")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        The service account email to be assumed by the cloud function.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="sourceArchiveBucket")
    def source_archive_bucket(self) -> builtins.str:
        """
        The GCS bucket containing the zip archive which contains the function.
        """
        return pulumi.get(self, "source_archive_bucket")

    @property
    @pulumi.getter(name="sourceArchiveObject")
    def source_archive_object(self) -> builtins.str:
        """
        The source archive object (file) in archive bucket.
        """
        return pulumi.get(self, "source_archive_object")

    @property
    @pulumi.getter(name="sourceRepositories")
    def source_repositories(self) -> Sequence['outputs.GetFunctionSourceRepositoryResult']:
        """
        The URL of the Cloud Source Repository that the function is deployed from. Structure is documented below.
        """
        return pulumi.get(self, "source_repositories")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> builtins.int:
        """
        Function execution timeout (in seconds).
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="triggerHttp")
    def trigger_http(self) -> builtins.bool:
        """
        If function is triggered by HTTP, this boolean is set.
        """
        return pulumi.get(self, "trigger_http")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> builtins.str:
        return pulumi.get(self, "version_id")

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> builtins.str:
        """
        The VPC Network Connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> builtins.str:
        """
        The egress settings for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")


class AwaitableGetFunctionResult(GetFunctionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFunctionResult(
            available_memory_mb=self.available_memory_mb,
            build_environment_variables=self.build_environment_variables,
            build_service_account=self.build_service_account,
            build_worker_pool=self.build_worker_pool,
            description=self.description,
            docker_registry=self.docker_registry,
            docker_repository=self.docker_repository,
            effective_labels=self.effective_labels,
            entry_point=self.entry_point,
            environment_variables=self.environment_variables,
            event_triggers=self.event_triggers,
            https_trigger_security_level=self.https_trigger_security_level,
            https_trigger_url=self.https_trigger_url,
            id=self.id,
            ingress_settings=self.ingress_settings,
            kms_key_name=self.kms_key_name,
            labels=self.labels,
            max_instances=self.max_instances,
            min_instances=self.min_instances,
            name=self.name,
            project=self.project,
            pulumi_labels=self.pulumi_labels,
            region=self.region,
            runtime=self.runtime,
            secret_environment_variables=self.secret_environment_variables,
            secret_volumes=self.secret_volumes,
            service_account_email=self.service_account_email,
            source_archive_bucket=self.source_archive_bucket,
            source_archive_object=self.source_archive_object,
            source_repositories=self.source_repositories,
            status=self.status,
            timeout=self.timeout,
            trigger_http=self.trigger_http,
            version_id=self.version_id,
            vpc_connector=self.vpc_connector,
            vpc_connector_egress_settings=self.vpc_connector_egress_settings)


def get_function(name: Optional[builtins.str] = None,
                 project: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFunctionResult:
    """
    Get information about a Google Cloud Function. For more information see
    the [official documentation](https://cloud.google.com/functions/docs/)
    and [API](https://cloud.google.com/functions/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_function = gcp.cloudfunctions.get_function(name="function")
    ```


    :param builtins.str name: The name of a Cloud Function.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:cloudfunctions/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult).value

    return AwaitableGetFunctionResult(
        available_memory_mb=pulumi.get(__ret__, 'available_memory_mb'),
        build_environment_variables=pulumi.get(__ret__, 'build_environment_variables'),
        build_service_account=pulumi.get(__ret__, 'build_service_account'),
        build_worker_pool=pulumi.get(__ret__, 'build_worker_pool'),
        description=pulumi.get(__ret__, 'description'),
        docker_registry=pulumi.get(__ret__, 'docker_registry'),
        docker_repository=pulumi.get(__ret__, 'docker_repository'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        entry_point=pulumi.get(__ret__, 'entry_point'),
        environment_variables=pulumi.get(__ret__, 'environment_variables'),
        event_triggers=pulumi.get(__ret__, 'event_triggers'),
        https_trigger_security_level=pulumi.get(__ret__, 'https_trigger_security_level'),
        https_trigger_url=pulumi.get(__ret__, 'https_trigger_url'),
        id=pulumi.get(__ret__, 'id'),
        ingress_settings=pulumi.get(__ret__, 'ingress_settings'),
        kms_key_name=pulumi.get(__ret__, 'kms_key_name'),
        labels=pulumi.get(__ret__, 'labels'),
        max_instances=pulumi.get(__ret__, 'max_instances'),
        min_instances=pulumi.get(__ret__, 'min_instances'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        region=pulumi.get(__ret__, 'region'),
        runtime=pulumi.get(__ret__, 'runtime'),
        secret_environment_variables=pulumi.get(__ret__, 'secret_environment_variables'),
        secret_volumes=pulumi.get(__ret__, 'secret_volumes'),
        service_account_email=pulumi.get(__ret__, 'service_account_email'),
        source_archive_bucket=pulumi.get(__ret__, 'source_archive_bucket'),
        source_archive_object=pulumi.get(__ret__, 'source_archive_object'),
        source_repositories=pulumi.get(__ret__, 'source_repositories'),
        status=pulumi.get(__ret__, 'status'),
        timeout=pulumi.get(__ret__, 'timeout'),
        trigger_http=pulumi.get(__ret__, 'trigger_http'),
        version_id=pulumi.get(__ret__, 'version_id'),
        vpc_connector=pulumi.get(__ret__, 'vpc_connector'),
        vpc_connector_egress_settings=pulumi.get(__ret__, 'vpc_connector_egress_settings'))
def get_function_output(name: Optional[pulumi.Input[builtins.str]] = None,
                        project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFunctionResult]:
    """
    Get information about a Google Cloud Function. For more information see
    the [official documentation](https://cloud.google.com/functions/docs/)
    and [API](https://cloud.google.com/functions/docs/apis).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_function = gcp.cloudfunctions.get_function(name="function")
    ```


    :param builtins.str name: The name of a Cloud Function.
           
           - - -
    :param builtins.str project: The project in which the resource belongs. If it
           is not provided, the provider project is used.
    :param builtins.str region: The region in which the resource belongs. If it
           is not provided, the provider region is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:cloudfunctions/getFunction:getFunction', __args__, opts=opts, typ=GetFunctionResult)
    return __ret__.apply(lambda __response__: GetFunctionResult(
        available_memory_mb=pulumi.get(__response__, 'available_memory_mb'),
        build_environment_variables=pulumi.get(__response__, 'build_environment_variables'),
        build_service_account=pulumi.get(__response__, 'build_service_account'),
        build_worker_pool=pulumi.get(__response__, 'build_worker_pool'),
        description=pulumi.get(__response__, 'description'),
        docker_registry=pulumi.get(__response__, 'docker_registry'),
        docker_repository=pulumi.get(__response__, 'docker_repository'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        entry_point=pulumi.get(__response__, 'entry_point'),
        environment_variables=pulumi.get(__response__, 'environment_variables'),
        event_triggers=pulumi.get(__response__, 'event_triggers'),
        https_trigger_security_level=pulumi.get(__response__, 'https_trigger_security_level'),
        https_trigger_url=pulumi.get(__response__, 'https_trigger_url'),
        id=pulumi.get(__response__, 'id'),
        ingress_settings=pulumi.get(__response__, 'ingress_settings'),
        kms_key_name=pulumi.get(__response__, 'kms_key_name'),
        labels=pulumi.get(__response__, 'labels'),
        max_instances=pulumi.get(__response__, 'max_instances'),
        min_instances=pulumi.get(__response__, 'min_instances'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        region=pulumi.get(__response__, 'region'),
        runtime=pulumi.get(__response__, 'runtime'),
        secret_environment_variables=pulumi.get(__response__, 'secret_environment_variables'),
        secret_volumes=pulumi.get(__response__, 'secret_volumes'),
        service_account_email=pulumi.get(__response__, 'service_account_email'),
        source_archive_bucket=pulumi.get(__response__, 'source_archive_bucket'),
        source_archive_object=pulumi.get(__response__, 'source_archive_object'),
        source_repositories=pulumi.get(__response__, 'source_repositories'),
        status=pulumi.get(__response__, 'status'),
        timeout=pulumi.get(__response__, 'timeout'),
        trigger_http=pulumi.get(__response__, 'trigger_http'),
        version_id=pulumi.get(__response__, 'version_id'),
        vpc_connector=pulumi.get(__response__, 'vpc_connector'),
        vpc_connector_egress_settings=pulumi.get(__response__, 'vpc_connector_egress_settings')))
