# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'FunctionBuildConfig',
    'FunctionBuildConfigAutomaticUpdatePolicy',
    'FunctionBuildConfigOnDeployUpdatePolicy',
    'FunctionBuildConfigSource',
    'FunctionBuildConfigSourceRepoSource',
    'FunctionBuildConfigSourceStorageSource',
    'FunctionEventTrigger',
    'FunctionEventTriggerEventFilter',
    'FunctionIamBindingCondition',
    'FunctionIamMemberCondition',
    'FunctionServiceConfig',
    'FunctionServiceConfigSecretEnvironmentVariable',
    'FunctionServiceConfigSecretVolume',
    'FunctionServiceConfigSecretVolumeVersion',
    'GetFunctionBuildConfigResult',
    'GetFunctionBuildConfigAutomaticUpdatePolicyResult',
    'GetFunctionBuildConfigOnDeployUpdatePolicyResult',
    'GetFunctionBuildConfigSourceResult',
    'GetFunctionBuildConfigSourceRepoSourceResult',
    'GetFunctionBuildConfigSourceStorageSourceResult',
    'GetFunctionEventTriggerResult',
    'GetFunctionEventTriggerEventFilterResult',
    'GetFunctionServiceConfigResult',
    'GetFunctionServiceConfigSecretEnvironmentVariableResult',
    'GetFunctionServiceConfigSecretVolumeResult',
    'GetFunctionServiceConfigSecretVolumeVersionResult',
]

@pulumi.output_type
class FunctionBuildConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "automaticUpdatePolicy":
            suggest = "automatic_update_policy"
        elif key == "dockerRepository":
            suggest = "docker_repository"
        elif key == "entryPoint":
            suggest = "entry_point"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "onDeployUpdatePolicy":
            suggest = "on_deploy_update_policy"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 automatic_update_policy: Optional['outputs.FunctionBuildConfigAutomaticUpdatePolicy'] = None,
                 build: Optional[builtins.str] = None,
                 docker_repository: Optional[builtins.str] = None,
                 entry_point: Optional[builtins.str] = None,
                 environment_variables: Optional[Mapping[str, builtins.str]] = None,
                 on_deploy_update_policy: Optional['outputs.FunctionBuildConfigOnDeployUpdatePolicy'] = None,
                 runtime: Optional[builtins.str] = None,
                 service_account: Optional[builtins.str] = None,
                 source: Optional['outputs.FunctionBuildConfigSource'] = None,
                 worker_pool: Optional[builtins.str] = None):
        """
        :param 'FunctionBuildConfigAutomaticUpdatePolicyArgs' automatic_update_policy: Security patches are applied automatically to the runtime without requiring
               the function to be redeployed.
        :param builtins.str build: (Output)
               The Cloud Build name of the latest successful
               deployment of the function.
        :param builtins.str docker_repository: User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        :param builtins.str entry_point: The name of the function (as defined in source code) that will be executed.
               Defaults to the resource name suffix, if not specified. For backward
               compatibility, if function with given name is not found, then the system
               will try to use function named "function". For Node.js this is name of a
               function exported by the module specified in source_location.
        :param Mapping[str, builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param 'FunctionBuildConfigOnDeployUpdatePolicyArgs' on_deploy_update_policy: Security patches are only applied when a function is redeployed.
               Structure is documented below.
        :param builtins.str runtime: The runtime in which to run the function. Required when deploying a new
               function, optional when updating an existing function.
        :param builtins.str service_account: The fully-qualified name of the service account to be used for building the container.
        :param 'FunctionBuildConfigSourceArgs' source: The location of the function source code.
               Structure is documented below.
        :param builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        if automatic_update_policy is not None:
            pulumi.set(__self__, "automatic_update_policy", automatic_update_policy)
        if build is not None:
            pulumi.set(__self__, "build", build)
        if docker_repository is not None:
            pulumi.set(__self__, "docker_repository", docker_repository)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if on_deploy_update_policy is not None:
            pulumi.set(__self__, "on_deploy_update_policy", on_deploy_update_policy)
        if runtime is not None:
            pulumi.set(__self__, "runtime", runtime)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="automaticUpdatePolicy")
    def automatic_update_policy(self) -> Optional['outputs.FunctionBuildConfigAutomaticUpdatePolicy']:
        """
        Security patches are applied automatically to the runtime without requiring
        the function to be redeployed.
        """
        return pulumi.get(self, "automatic_update_policy")

    @property
    @pulumi.getter
    def build(self) -> Optional[builtins.str]:
        """
        (Output)
        The Cloud Build name of the latest successful
        deployment of the function.
        """
        return pulumi.get(self, "build")

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> Optional[builtins.str]:
        """
        User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        """
        return pulumi.get(self, "docker_repository")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[builtins.str]:
        """
        The name of the function (as defined in source code) that will be executed.
        Defaults to the resource name suffix, if not specified. For backward
        compatibility, if function with given name is not found, then the system
        will try to use function named "function". For Node.js this is name of a
        function exported by the module specified in source_location.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="onDeployUpdatePolicy")
    def on_deploy_update_policy(self) -> Optional['outputs.FunctionBuildConfigOnDeployUpdatePolicy']:
        """
        Security patches are only applied when a function is redeployed.
        Structure is documented below.
        """
        return pulumi.get(self, "on_deploy_update_policy")

    @property
    @pulumi.getter
    def runtime(self) -> Optional[builtins.str]:
        """
        The runtime in which to run the function. Required when deploying a new
        function, optional when updating an existing function.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[builtins.str]:
        """
        The fully-qualified name of the service account to be used for building the container.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.FunctionBuildConfigSource']:
        """
        The location of the function source code.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[builtins.str]:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class FunctionBuildConfigAutomaticUpdatePolicy(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class FunctionBuildConfigOnDeployUpdatePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigOnDeployUpdatePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigOnDeployUpdatePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigOnDeployUpdatePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 runtime_version: Optional[builtins.str] = None):
        """
        :param builtins.str runtime_version: (Output)
               The runtime version which was used during latest function deployment.
        """
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[builtins.str]:
        """
        (Output)
        The runtime version which was used during latest function deployment.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FunctionBuildConfigSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: Optional['outputs.FunctionBuildConfigSourceRepoSource'] = None,
                 storage_source: Optional['outputs.FunctionBuildConfigSourceStorageSource'] = None):
        """
        :param 'FunctionBuildConfigSourceRepoSourceArgs' repo_source: If provided, get the source from this location in a Cloud Source Repository.
               Structure is documented below.
        :param 'FunctionBuildConfigSourceStorageSourceArgs' storage_source: If provided, get the source from this location in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional['outputs.FunctionBuildConfigSourceRepoSource']:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional['outputs.FunctionBuildConfigSourceStorageSource']:
        """
        If provided, get the source from this location in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")


@pulumi.output_type
class FunctionBuildConfigSourceRepoSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionBuildConfigSourceRepoSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionBuildConfigSourceRepoSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionBuildConfigSourceRepoSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: Optional[builtins.str] = None,
                 commit_sha: Optional[builtins.str] = None,
                 dir: Optional[builtins.str] = None,
                 invert_regex: Optional[builtins.bool] = None,
                 project_id: Optional[builtins.str] = None,
                 repo_name: Optional[builtins.str] = None,
                 tag_name: Optional[builtins.str] = None):
        """
        :param builtins.str branch_name: Regex matching branches to build.
        :param builtins.str commit_sha: Regex matching tags to build.
        :param builtins.str dir: Directory, relative to the source root, in which to run the build.
        :param builtins.bool invert_regex: Only trigger a build if the revision regex does
               NOT match the revision regex.
        :param builtins.str project_id: ID of the project that owns the Cloud Source Repository. If omitted, the
               project ID requesting the build is assumed.
        :param builtins.str repo_name: Name of the Cloud Source Repository.
        :param builtins.str tag_name: Regex matching tags to build.
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[builtins.str]:
        """
        Regex matching branches to build.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[builtins.str]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> Optional[builtins.str]:
        """
        Directory, relative to the source root, in which to run the build.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[builtins.bool]:
        """
        Only trigger a build if the revision regex does
        NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[builtins.str]:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the
        project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[builtins.str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[builtins.str]:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class FunctionBuildConfigSourceStorageSource(dict):
    def __init__(__self__, *,
                 bucket: Optional[builtins.str] = None,
                 generation: Optional[builtins.int] = None,
                 object: Optional[builtins.str] = None):
        """
        :param builtins.str bucket: Google Cloud Storage bucket containing the source
        :param builtins.int generation: Google Cloud Storage generation for the object. If the generation
               is omitted, the latest generation will be used.
        :param builtins.str object: Google Cloud Storage object containing the source.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[builtins.str]:
        """
        Google Cloud Storage bucket containing the source
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> Optional[builtins.int]:
        """
        Google Cloud Storage generation for the object. If the generation
        is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> Optional[builtins.str]:
        """
        Google Cloud Storage object containing the source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class FunctionEventTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eventFilters":
            suggest = "event_filters"
        elif key == "eventType":
            suggest = "event_type"
        elif key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "retryPolicy":
            suggest = "retry_policy"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "triggerRegion":
            suggest = "trigger_region"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionEventTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionEventTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 event_filters: Optional[Sequence['outputs.FunctionEventTriggerEventFilter']] = None,
                 event_type: Optional[builtins.str] = None,
                 pubsub_topic: Optional[builtins.str] = None,
                 retry_policy: Optional[builtins.str] = None,
                 service_account_email: Optional[builtins.str] = None,
                 trigger: Optional[builtins.str] = None,
                 trigger_region: Optional[builtins.str] = None):
        """
        :param Sequence['FunctionEventTriggerEventFilterArgs'] event_filters: Criteria used to filter events.
               Structure is documented below.
        :param builtins.str event_type: Required. The type of event to observe.
        :param builtins.str pubsub_topic: The name of a Pub/Sub topic in the same project that will be used
               as the transport topic for the event delivery.
        :param builtins.str retry_policy: Describes the retry policy in case of function's execution failure.
               Retried execution is charged as any other execution.
               Possible values are: `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, `RETRY_POLICY_RETRY`.
        :param builtins.str service_account_email: Optional. The email of the trigger's service account. The service account
               must have permission to invoke Cloud Run services. If empty, defaults to the
               Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        :param builtins.str trigger: (Output)
               Output only. The resource name of the Eventarc trigger.
        :param builtins.str trigger_region: The region that the trigger will be in. The trigger will only receive
               events originating in this region. It can be the same
               region as the function, a different region or multi-region, or the global
               region. If not provided, defaults to the same region as the function.
        """
        if event_filters is not None:
            pulumi.set(__self__, "event_filters", event_filters)
        if event_type is not None:
            pulumi.set(__self__, "event_type", event_type)
        if pubsub_topic is not None:
            pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        if retry_policy is not None:
            pulumi.set(__self__, "retry_policy", retry_policy)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if trigger_region is not None:
            pulumi.set(__self__, "trigger_region", trigger_region)

    @property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Optional[Sequence['outputs.FunctionEventTriggerEventFilter']]:
        """
        Criteria used to filter events.
        Structure is documented below.
        """
        return pulumi.get(self, "event_filters")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> Optional[builtins.str]:
        """
        Required. The type of event to observe.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> Optional[builtins.str]:
        """
        The name of a Pub/Sub topic in the same project that will be used
        as the transport topic for the event delivery.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> Optional[builtins.str]:
        """
        Describes the retry policy in case of function's execution failure.
        Retried execution is charged as any other execution.
        Possible values are: `RETRY_POLICY_UNSPECIFIED`, `RETRY_POLICY_DO_NOT_RETRY`, `RETRY_POLICY_RETRY`.
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[builtins.str]:
        """
        Optional. The email of the trigger's service account. The service account
        must have permission to invoke Cloud Run services. If empty, defaults to the
        Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def trigger(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The resource name of the Eventarc trigger.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> Optional[builtins.str]:
        """
        The region that the trigger will be in. The trigger will only receive
        events originating in this region. It can be the same
        region as the function, a different region or multi-region, or the global
        region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")


@pulumi.output_type
class FunctionEventTriggerEventFilter(dict):
    def __init__(__self__, *,
                 attribute: builtins.str,
                 value: builtins.str,
                 operator: Optional[builtins.str] = None):
        """
        :param builtins.str attribute: 'Required. The name of a CloudEvents attribute.
               Currently, only a subset of attributes are supported for filtering. Use the `gcloud eventarc providers describe` command to learn more about events and their attributes.
               Do not filter for the 'type' attribute here, as this is already achieved by the resource's `event_type` attribute.
        :param builtins.str value: Required. The value for the attribute.
               If the operator field is set as `match-path-pattern`, this value can be a path pattern instead of an exact value.
        :param builtins.str operator: Optional. The operator used for matching the events with the value of
               the filter. If not specified, only events that have an exact key-value
               pair specified in the filter are matched.
               The only allowed value is `match-path-pattern`.
               [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "value", value)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @property
    @pulumi.getter
    def attribute(self) -> builtins.str:
        """
        'Required. The name of a CloudEvents attribute.
        Currently, only a subset of attributes are supported for filtering. Use the `gcloud eventarc providers describe` command to learn more about events and their attributes.
        Do not filter for the 'type' attribute here, as this is already achieved by the resource's `event_type` attribute.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Required. The value for the attribute.
        If the operator field is set as `match-path-pattern`, this value can be a path pattern instead of an exact value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def operator(self) -> Optional[builtins.str]:
        """
        Optional. The operator used for matching the events with the value of
        the filter. If not specified, only events that have an exact key-value
        pair specified in the filter are matched.
        The only allowed value is `match-path-pattern`.
        [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class FunctionIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: builtins.str,
                 title: builtins.str,
                 description: Optional[builtins.str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> builtins.str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        return pulumi.get(self, "description")


@pulumi.output_type
class FunctionServiceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allTrafficOnLatestRevision":
            suggest = "all_traffic_on_latest_revision"
        elif key == "availableCpu":
            suggest = "available_cpu"
        elif key == "availableMemory":
            suggest = "available_memory"
        elif key == "binaryAuthorizationPolicy":
            suggest = "binary_authorization_policy"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "gcfUri":
            suggest = "gcf_uri"
        elif key == "ingressSettings":
            suggest = "ingress_settings"
        elif key == "maxInstanceCount":
            suggest = "max_instance_count"
        elif key == "maxInstanceRequestConcurrency":
            suggest = "max_instance_request_concurrency"
        elif key == "minInstanceCount":
            suggest = "min_instance_count"
        elif key == "secretEnvironmentVariables":
            suggest = "secret_environment_variables"
        elif key == "secretVolumes":
            suggest = "secret_volumes"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"
        elif key == "vpcConnector":
            suggest = "vpc_connector"
        elif key == "vpcConnectorEgressSettings":
            suggest = "vpc_connector_egress_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 all_traffic_on_latest_revision: Optional[builtins.bool] = None,
                 available_cpu: Optional[builtins.str] = None,
                 available_memory: Optional[builtins.str] = None,
                 binary_authorization_policy: Optional[builtins.str] = None,
                 environment_variables: Optional[Mapping[str, builtins.str]] = None,
                 gcf_uri: Optional[builtins.str] = None,
                 ingress_settings: Optional[builtins.str] = None,
                 max_instance_count: Optional[builtins.int] = None,
                 max_instance_request_concurrency: Optional[builtins.int] = None,
                 min_instance_count: Optional[builtins.int] = None,
                 secret_environment_variables: Optional[Sequence['outputs.FunctionServiceConfigSecretEnvironmentVariable']] = None,
                 secret_volumes: Optional[Sequence['outputs.FunctionServiceConfigSecretVolume']] = None,
                 service: Optional[builtins.str] = None,
                 service_account_email: Optional[builtins.str] = None,
                 timeout_seconds: Optional[builtins.int] = None,
                 uri: Optional[builtins.str] = None,
                 vpc_connector: Optional[builtins.str] = None,
                 vpc_connector_egress_settings: Optional[builtins.str] = None):
        """
        :param builtins.bool all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. Defaults to true.
        :param builtins.str available_cpu: The number of CPUs used in a single container instance. Default value is calculated from available memory.
        :param builtins.str available_memory: The amount of memory available for a function.
               Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
               supplied the value is interpreted as bytes.
        :param builtins.str binary_authorization_policy: The binary authorization policy to be checked when deploying the Cloud Run service.
        :param Mapping[str, builtins.str] environment_variables: Environment variables that shall be available during function execution.
        :param builtins.str gcf_uri: (Output)
               URIs of the Service deployed
        :param builtins.str ingress_settings: Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
               Default value is `ALLOW_ALL`.
               Possible values are: `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, `ALLOW_INTERNAL_AND_GCLB`.
        :param builtins.int max_instance_count: The limit on the maximum number of function instances that may coexist at a
               given time.
        :param builtins.int max_instance_request_concurrency: Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        :param builtins.int min_instance_count: The limit on the minimum number of function instances that may coexist at a
               given time.
        :param Sequence['FunctionServiceConfigSecretEnvironmentVariableArgs'] secret_environment_variables: Secret environment variables configuration.
               Structure is documented below.
        :param Sequence['FunctionServiceConfigSecretVolumeArgs'] secret_volumes: Secret volumes configuration.
               Structure is documented below.
        :param builtins.str service: Name of the service associated with a Function.
        :param builtins.str service_account_email: The email of the service account for this function.
        :param builtins.int timeout_seconds: The function execution timeout. Execution is considered failed and
               can be terminated if the function is not completed at the end of the
               timeout period. Defaults to 60 seconds.
        :param builtins.str uri: (Output)
               URI of the Service deployed.
        :param builtins.str vpc_connector: The Serverless VPC Access connector that this cloud function can connect to.
        :param builtins.str vpc_connector_egress_settings: Available egress settings.
               Possible values are: `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, `ALL_TRAFFIC`.
        """
        if all_traffic_on_latest_revision is not None:
            pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        if available_cpu is not None:
            pulumi.set(__self__, "available_cpu", available_cpu)
        if available_memory is not None:
            pulumi.set(__self__, "available_memory", available_memory)
        if binary_authorization_policy is not None:
            pulumi.set(__self__, "binary_authorization_policy", binary_authorization_policy)
        if environment_variables is not None:
            pulumi.set(__self__, "environment_variables", environment_variables)
        if gcf_uri is not None:
            pulumi.set(__self__, "gcf_uri", gcf_uri)
        if ingress_settings is not None:
            pulumi.set(__self__, "ingress_settings", ingress_settings)
        if max_instance_count is not None:
            pulumi.set(__self__, "max_instance_count", max_instance_count)
        if max_instance_request_concurrency is not None:
            pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        if min_instance_count is not None:
            pulumi.set(__self__, "min_instance_count", min_instance_count)
        if secret_environment_variables is not None:
            pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        if secret_volumes is not None:
            pulumi.set(__self__, "secret_volumes", secret_volumes)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if vpc_connector is not None:
            pulumi.set(__self__, "vpc_connector", vpc_connector)
        if vpc_connector_egress_settings is not None:
            pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> Optional[builtins.bool]:
        """
        Whether 100% of traffic is routed to the latest revision. Defaults to true.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @property
    @pulumi.getter(name="availableCpu")
    def available_cpu(self) -> Optional[builtins.str]:
        """
        The number of CPUs used in a single container instance. Default value is calculated from available memory.
        """
        return pulumi.get(self, "available_cpu")

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> Optional[builtins.str]:
        """
        The amount of memory available for a function.
        Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        supplied the value is interpreted as bytes.
        """
        return pulumi.get(self, "available_memory")

    @property
    @pulumi.getter(name="binaryAuthorizationPolicy")
    def binary_authorization_policy(self) -> Optional[builtins.str]:
        """
        The binary authorization policy to be checked when deploying the Cloud Run service.
        """
        return pulumi.get(self, "binary_authorization_policy")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="gcfUri")
    def gcf_uri(self) -> Optional[builtins.str]:
        """
        (Output)
        URIs of the Service deployed
        """
        return pulumi.get(self, "gcf_uri")

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> Optional[builtins.str]:
        """
        Available ingress settings. Defaults to "ALLOW_ALL" if unspecified.
        Default value is `ALLOW_ALL`.
        Possible values are: `ALLOW_ALL`, `ALLOW_INTERNAL_ONLY`, `ALLOW_INTERNAL_AND_GCLB`.
        """
        return pulumi.get(self, "ingress_settings")

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> Optional[builtins.int]:
        """
        The limit on the maximum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> Optional[builtins.int]:
        """
        Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> Optional[builtins.int]:
        """
        The limit on the minimum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "min_instance_count")

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretEnvironmentVariable']]:
        """
        Secret environment variables configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_environment_variables")

    @property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretVolume']]:
        """
        Secret volumes configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "secret_volumes")

    @property
    @pulumi.getter
    def service(self) -> Optional[builtins.str]:
        """
        Name of the service associated with a Function.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[builtins.str]:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[builtins.int]:
        """
        The function execution timeout. Execution is considered failed and
        can be terminated if the function is not completed at the end of the
        timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def uri(self) -> Optional[builtins.str]:
        """
        (Output)
        URI of the Service deployed.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> Optional[builtins.str]:
        """
        The Serverless VPC Access connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> Optional[builtins.str]:
        """
        Available egress settings.
        Possible values are: `VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED`, `PRIVATE_RANGES_ONLY`, `ALL_TRAFFIC`.
        """
        return pulumi.get(self, "vpc_connector_egress_settings")


@pulumi.output_type
class FunctionServiceConfigSecretEnvironmentVariable(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfigSecretEnvironmentVariable. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfigSecretEnvironmentVariable.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfigSecretEnvironmentVariable.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: builtins.str,
                 project_id: builtins.str,
                 secret: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str key: Name of the environment variable.
        :param builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param builtins.str version: Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class FunctionServiceConfigSecretVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FunctionServiceConfigSecretVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FunctionServiceConfigSecretVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FunctionServiceConfigSecretVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: builtins.str,
                 project_id: builtins.str,
                 secret: builtins.str,
                 versions: Optional[Sequence['outputs.FunctionServiceConfigSecretVolumeVersion']] = None):
        """
        :param builtins.str mount_path: The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        :param builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param Sequence['FunctionServiceConfigSecretVolumeVersionArgs'] versions: List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
               Structure is documented below.
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> builtins.str:
        """
        The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def versions(self) -> Optional[Sequence['outputs.FunctionServiceConfigSecretVolumeVersion']]:
        """
        List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        Structure is documented below.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class FunctionServiceConfigSecretVolumeVersion(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str path: Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        :param builtins.str version: Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionBuildConfigResult(dict):
    def __init__(__self__, *,
                 automatic_update_policies: Sequence['outputs.GetFunctionBuildConfigAutomaticUpdatePolicyResult'],
                 build: builtins.str,
                 docker_repository: builtins.str,
                 entry_point: builtins.str,
                 environment_variables: Mapping[str, builtins.str],
                 on_deploy_update_policies: Sequence['outputs.GetFunctionBuildConfigOnDeployUpdatePolicyResult'],
                 runtime: builtins.str,
                 service_account: builtins.str,
                 sources: Sequence['outputs.GetFunctionBuildConfigSourceResult'],
                 worker_pool: builtins.str):
        """
        :param Sequence['GetFunctionBuildConfigAutomaticUpdatePolicyArgs'] automatic_update_policies: Security patches are applied automatically to the runtime without requiring
               the function to be redeployed.
        :param builtins.str build: The Cloud Build name of the latest successful
               deployment of the function.
        :param builtins.str docker_repository: User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        :param builtins.str entry_point: The name of the function (as defined in source code) that will be executed.
               Defaults to the resource name suffix, if not specified. For backward
               compatibility, if function with given name is not found, then the system
               will try to use function named "function". For Node.js this is name of a
               function exported by the module specified in source_location.
        :param Mapping[str, builtins.str] environment_variables: User-provided build-time environment variables for the function.
        :param Sequence['GetFunctionBuildConfigOnDeployUpdatePolicyArgs'] on_deploy_update_policies: Security patches are only applied when a function is redeployed.
        :param builtins.str runtime: The runtime in which to run the function. Required when deploying a new
               function, optional when updating an existing function.
        :param builtins.str service_account: The fully-qualified name of the service account to be used for building the container.
        :param Sequence['GetFunctionBuildConfigSourceArgs'] sources: The location of the function source code.
        :param builtins.str worker_pool: Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        pulumi.set(__self__, "automatic_update_policies", automatic_update_policies)
        pulumi.set(__self__, "build", build)
        pulumi.set(__self__, "docker_repository", docker_repository)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "on_deploy_update_policies", on_deploy_update_policies)
        pulumi.set(__self__, "runtime", runtime)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "sources", sources)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="automaticUpdatePolicies")
    def automatic_update_policies(self) -> Sequence['outputs.GetFunctionBuildConfigAutomaticUpdatePolicyResult']:
        """
        Security patches are applied automatically to the runtime without requiring
        the function to be redeployed.
        """
        return pulumi.get(self, "automatic_update_policies")

    @property
    @pulumi.getter
    def build(self) -> builtins.str:
        """
        The Cloud Build name of the latest successful
        deployment of the function.
        """
        return pulumi.get(self, "build")

    @property
    @pulumi.getter(name="dockerRepository")
    def docker_repository(self) -> builtins.str:
        """
        User managed repository created in Artifact Registry optionally with a customer managed encryption key.
        """
        return pulumi.get(self, "docker_repository")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> builtins.str:
        """
        The name of the function (as defined in source code) that will be executed.
        Defaults to the resource name suffix, if not specified. For backward
        compatibility, if function with given name is not found, then the system
        will try to use function named "function". For Node.js this is name of a
        function exported by the module specified in source_location.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, builtins.str]:
        """
        User-provided build-time environment variables for the function.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="onDeployUpdatePolicies")
    def on_deploy_update_policies(self) -> Sequence['outputs.GetFunctionBuildConfigOnDeployUpdatePolicyResult']:
        """
        Security patches are only applied when a function is redeployed.
        """
        return pulumi.get(self, "on_deploy_update_policies")

    @property
    @pulumi.getter
    def runtime(self) -> builtins.str:
        """
        The runtime in which to run the function. Required when deploying a new
        function, optional when updating an existing function.
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> builtins.str:
        """
        The fully-qualified name of the service account to be used for building the container.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceResult']:
        """
        The location of the function source code.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> builtins.str:
        """
        Name of the Cloud Build Custom Worker Pool that should be used to build the function.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class GetFunctionBuildConfigAutomaticUpdatePolicyResult(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class GetFunctionBuildConfigOnDeployUpdatePolicyResult(dict):
    def __init__(__self__, *,
                 runtime_version: builtins.str):
        """
        :param builtins.str runtime_version: The runtime version which was used during latest function deployment.
        """
        pulumi.set(__self__, "runtime_version", runtime_version)

    @property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> builtins.str:
        """
        The runtime version which was used during latest function deployment.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class GetFunctionBuildConfigSourceResult(dict):
    def __init__(__self__, *,
                 repo_sources: Sequence['outputs.GetFunctionBuildConfigSourceRepoSourceResult'],
                 storage_sources: Sequence['outputs.GetFunctionBuildConfigSourceStorageSourceResult']):
        """
        :param Sequence['GetFunctionBuildConfigSourceRepoSourceArgs'] repo_sources: If provided, get the source from this location in a Cloud Source Repository.
        :param Sequence['GetFunctionBuildConfigSourceStorageSourceArgs'] storage_sources: If provided, get the source from this location in Google Cloud Storage.
        """
        pulumi.set(__self__, "repo_sources", repo_sources)
        pulumi.set(__self__, "storage_sources", storage_sources)

    @property
    @pulumi.getter(name="repoSources")
    def repo_sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceRepoSourceResult']:
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_sources")

    @property
    @pulumi.getter(name="storageSources")
    def storage_sources(self) -> Sequence['outputs.GetFunctionBuildConfigSourceStorageSourceResult']:
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_sources")


@pulumi.output_type
class GetFunctionBuildConfigSourceRepoSourceResult(dict):
    def __init__(__self__, *,
                 branch_name: builtins.str,
                 commit_sha: builtins.str,
                 dir: builtins.str,
                 invert_regex: builtins.bool,
                 project_id: builtins.str,
                 repo_name: builtins.str,
                 tag_name: builtins.str):
        """
        :param builtins.str branch_name: Regex matching branches to build.
        :param builtins.str commit_sha: Regex matching tags to build.
        :param builtins.str dir: Directory, relative to the source root, in which to run the build.
        :param builtins.bool invert_regex: Only trigger a build if the revision regex does
               NOT match the revision regex.
        :param builtins.str project_id: ID of the project that owns the Cloud Source Repository. If omitted, the
               project ID requesting the build is assumed.
        :param builtins.str repo_name: Name of the Cloud Source Repository.
        :param builtins.str tag_name: Regex matching tags to build.
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> builtins.str:
        """
        Regex matching branches to build.
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> builtins.str:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> builtins.str:
        """
        Directory, relative to the source root, in which to run the build.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> builtins.bool:
        """
        Only trigger a build if the revision regex does
        NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the
        project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> builtins.str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> builtins.str:
        """
        Regex matching tags to build.
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class GetFunctionBuildConfigSourceStorageSourceResult(dict):
    def __init__(__self__, *,
                 bucket: builtins.str,
                 generation: builtins.int,
                 object: builtins.str):
        """
        :param builtins.str bucket: Google Cloud Storage bucket containing the source
        :param builtins.int generation: Google Cloud Storage generation for the object. If the generation
               is omitted, the latest generation will be used.
        :param builtins.str object: Google Cloud Storage object containing the source.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Google Cloud Storage bucket containing the source
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> builtins.int:
        """
        Google Cloud Storage generation for the object. If the generation
        is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> builtins.str:
        """
        Google Cloud Storage object containing the source.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetFunctionEventTriggerResult(dict):
    def __init__(__self__, *,
                 event_filters: Sequence['outputs.GetFunctionEventTriggerEventFilterResult'],
                 event_type: builtins.str,
                 pubsub_topic: builtins.str,
                 retry_policy: builtins.str,
                 service_account_email: builtins.str,
                 trigger: builtins.str,
                 trigger_region: builtins.str):
        """
        :param Sequence['GetFunctionEventTriggerEventFilterArgs'] event_filters: Criteria used to filter events.
        :param builtins.str event_type: Required. The type of event to observe.
        :param builtins.str pubsub_topic: The name of a Pub/Sub topic in the same project that will be used
               as the transport topic for the event delivery.
        :param builtins.str retry_policy: Describes the retry policy in case of function's execution failure.
               Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]
        :param builtins.str service_account_email: Optional. The email of the trigger's service account. The service account
               must have permission to invoke Cloud Run services. If empty, defaults to the
               Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        :param builtins.str trigger: Output only. The resource name of the Eventarc trigger.
        :param builtins.str trigger_region: The region that the trigger will be in. The trigger will only receive
               events originating in this region. It can be the same
               region as the function, a different region or multi-region, or the global
               region. If not provided, defaults to the same region as the function.
        """
        pulumi.set(__self__, "event_filters", event_filters)
        pulumi.set(__self__, "event_type", event_type)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        pulumi.set(__self__, "retry_policy", retry_policy)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "trigger", trigger)
        pulumi.set(__self__, "trigger_region", trigger_region)

    @property
    @pulumi.getter(name="eventFilters")
    def event_filters(self) -> Sequence['outputs.GetFunctionEventTriggerEventFilterResult']:
        """
        Criteria used to filter events.
        """
        return pulumi.get(self, "event_filters")

    @property
    @pulumi.getter(name="eventType")
    def event_type(self) -> builtins.str:
        """
        Required. The type of event to observe.
        """
        return pulumi.get(self, "event_type")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> builtins.str:
        """
        The name of a Pub/Sub topic in the same project that will be used
        as the transport topic for the event delivery.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="retryPolicy")
    def retry_policy(self) -> builtins.str:
        """
        Describes the retry policy in case of function's execution failure.
        Retried execution is charged as any other execution. Possible values: ["RETRY_POLICY_UNSPECIFIED", "RETRY_POLICY_DO_NOT_RETRY", "RETRY_POLICY_RETRY"]
        """
        return pulumi.get(self, "retry_policy")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        Optional. The email of the trigger's service account. The service account
        must have permission to invoke Cloud Run services. If empty, defaults to the
        Compute Engine default service account: {project_number}-compute@developer.gserviceaccount.com.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def trigger(self) -> builtins.str:
        """
        Output only. The resource name of the Eventarc trigger.
        """
        return pulumi.get(self, "trigger")

    @property
    @pulumi.getter(name="triggerRegion")
    def trigger_region(self) -> builtins.str:
        """
        The region that the trigger will be in. The trigger will only receive
        events originating in this region. It can be the same
        region as the function, a different region or multi-region, or the global
        region. If not provided, defaults to the same region as the function.
        """
        return pulumi.get(self, "trigger_region")


@pulumi.output_type
class GetFunctionEventTriggerEventFilterResult(dict):
    def __init__(__self__, *,
                 attribute: builtins.str,
                 operator: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str attribute: 'Required. The name of a CloudEvents attribute.
               Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
               Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.
        :param builtins.str operator: Optional. The operator used for matching the events with the value of
               the filter. If not specified, only events that have an exact key-value
               pair specified in the filter are matched.
               The only allowed value is 'match-path-pattern'.
               [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        :param builtins.str value: Required. The value for the attribute.
               If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.
        """
        pulumi.set(__self__, "attribute", attribute)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def attribute(self) -> builtins.str:
        """
        'Required. The name of a CloudEvents attribute.
        Currently, only a subset of attributes are supported for filtering. Use the 'gcloud eventarc providers describe' command to learn more about events and their attributes.
        Do not filter for the 'type' attribute here, as this is already achieved by the resource's 'event_type' attribute.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def operator(self) -> builtins.str:
        """
        Optional. The operator used for matching the events with the value of
        the filter. If not specified, only events that have an exact key-value
        pair specified in the filter are matched.
        The only allowed value is 'match-path-pattern'.
        [See documentation on path patterns here](https://cloud.google.com/eventarc/docs/path-patterns)'
        """
        return pulumi.get(self, "operator")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Required. The value for the attribute.
        If the operator field is set as 'match-path-pattern', this value can be a path pattern instead of an exact value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetFunctionServiceConfigResult(dict):
    def __init__(__self__, *,
                 all_traffic_on_latest_revision: builtins.bool,
                 available_cpu: builtins.str,
                 available_memory: builtins.str,
                 binary_authorization_policy: builtins.str,
                 environment_variables: Mapping[str, builtins.str],
                 gcf_uri: builtins.str,
                 ingress_settings: builtins.str,
                 max_instance_count: builtins.int,
                 max_instance_request_concurrency: builtins.int,
                 min_instance_count: builtins.int,
                 secret_environment_variables: Sequence['outputs.GetFunctionServiceConfigSecretEnvironmentVariableResult'],
                 secret_volumes: Sequence['outputs.GetFunctionServiceConfigSecretVolumeResult'],
                 service: builtins.str,
                 service_account_email: builtins.str,
                 timeout_seconds: builtins.int,
                 uri: builtins.str,
                 vpc_connector: builtins.str,
                 vpc_connector_egress_settings: builtins.str):
        """
        :param builtins.bool all_traffic_on_latest_revision: Whether 100% of traffic is routed to the latest revision. Defaults to true.
        :param builtins.str available_cpu: The number of CPUs used in a single container instance. Default value is calculated from available memory.
        :param builtins.str available_memory: The amount of memory available for a function.
               Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
               supplied the value is interpreted as bytes.
        :param builtins.str binary_authorization_policy: The binary authorization policy to be checked when deploying the Cloud Run service.
        :param Mapping[str, builtins.str] environment_variables: Environment variables that shall be available during function execution.
        :param builtins.str gcf_uri: URIs of the Service deployed
        :param builtins.str ingress_settings: Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]
        :param builtins.int max_instance_count: The limit on the maximum number of function instances that may coexist at a
               given time.
        :param builtins.int max_instance_request_concurrency: Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        :param builtins.int min_instance_count: The limit on the minimum number of function instances that may coexist at a
               given time.
        :param Sequence['GetFunctionServiceConfigSecretEnvironmentVariableArgs'] secret_environment_variables: Secret environment variables configuration.
        :param Sequence['GetFunctionServiceConfigSecretVolumeArgs'] secret_volumes: Secret volumes configuration.
        :param builtins.str service: Name of the service associated with a Function.
        :param builtins.str service_account_email: The email of the service account for this function.
        :param builtins.int timeout_seconds: The function execution timeout. Execution is considered failed and
               can be terminated if the function is not completed at the end of the
               timeout period. Defaults to 60 seconds.
        :param builtins.str uri: URI of the Service deployed.
        :param builtins.str vpc_connector: The Serverless VPC Access connector that this cloud function can connect to.
        :param builtins.str vpc_connector_egress_settings: Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]
        """
        pulumi.set(__self__, "all_traffic_on_latest_revision", all_traffic_on_latest_revision)
        pulumi.set(__self__, "available_cpu", available_cpu)
        pulumi.set(__self__, "available_memory", available_memory)
        pulumi.set(__self__, "binary_authorization_policy", binary_authorization_policy)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "gcf_uri", gcf_uri)
        pulumi.set(__self__, "ingress_settings", ingress_settings)
        pulumi.set(__self__, "max_instance_count", max_instance_count)
        pulumi.set(__self__, "max_instance_request_concurrency", max_instance_request_concurrency)
        pulumi.set(__self__, "min_instance_count", min_instance_count)
        pulumi.set(__self__, "secret_environment_variables", secret_environment_variables)
        pulumi.set(__self__, "secret_volumes", secret_volumes)
        pulumi.set(__self__, "service", service)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "vpc_connector", vpc_connector)
        pulumi.set(__self__, "vpc_connector_egress_settings", vpc_connector_egress_settings)

    @property
    @pulumi.getter(name="allTrafficOnLatestRevision")
    def all_traffic_on_latest_revision(self) -> builtins.bool:
        """
        Whether 100% of traffic is routed to the latest revision. Defaults to true.
        """
        return pulumi.get(self, "all_traffic_on_latest_revision")

    @property
    @pulumi.getter(name="availableCpu")
    def available_cpu(self) -> builtins.str:
        """
        The number of CPUs used in a single container instance. Default value is calculated from available memory.
        """
        return pulumi.get(self, "available_cpu")

    @property
    @pulumi.getter(name="availableMemory")
    def available_memory(self) -> builtins.str:
        """
        The amount of memory available for a function.
        Defaults to 256M. Supported units are k, M, G, Mi, Gi. If no unit is
        supplied the value is interpreted as bytes.
        """
        return pulumi.get(self, "available_memory")

    @property
    @pulumi.getter(name="binaryAuthorizationPolicy")
    def binary_authorization_policy(self) -> builtins.str:
        """
        The binary authorization policy to be checked when deploying the Cloud Run service.
        """
        return pulumi.get(self, "binary_authorization_policy")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Mapping[str, builtins.str]:
        """
        Environment variables that shall be available during function execution.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="gcfUri")
    def gcf_uri(self) -> builtins.str:
        """
        URIs of the Service deployed
        """
        return pulumi.get(self, "gcf_uri")

    @property
    @pulumi.getter(name="ingressSettings")
    def ingress_settings(self) -> builtins.str:
        """
        Available ingress settings. Defaults to "ALLOW_ALL" if unspecified. Default value: "ALLOW_ALL" Possible values: ["ALLOW_ALL", "ALLOW_INTERNAL_ONLY", "ALLOW_INTERNAL_AND_GCLB"]
        """
        return pulumi.get(self, "ingress_settings")

    @property
    @pulumi.getter(name="maxInstanceCount")
    def max_instance_count(self) -> builtins.int:
        """
        The limit on the maximum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "max_instance_count")

    @property
    @pulumi.getter(name="maxInstanceRequestConcurrency")
    def max_instance_request_concurrency(self) -> builtins.int:
        """
        Sets the maximum number of concurrent requests that each instance can receive. Defaults to 1.
        """
        return pulumi.get(self, "max_instance_request_concurrency")

    @property
    @pulumi.getter(name="minInstanceCount")
    def min_instance_count(self) -> builtins.int:
        """
        The limit on the minimum number of function instances that may coexist at a
        given time.
        """
        return pulumi.get(self, "min_instance_count")

    @property
    @pulumi.getter(name="secretEnvironmentVariables")
    def secret_environment_variables(self) -> Sequence['outputs.GetFunctionServiceConfigSecretEnvironmentVariableResult']:
        """
        Secret environment variables configuration.
        """
        return pulumi.get(self, "secret_environment_variables")

    @property
    @pulumi.getter(name="secretVolumes")
    def secret_volumes(self) -> Sequence['outputs.GetFunctionServiceConfigSecretVolumeResult']:
        """
        Secret volumes configuration.
        """
        return pulumi.get(self, "secret_volumes")

    @property
    @pulumi.getter
    def service(self) -> builtins.str:
        """
        Name of the service associated with a Function.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> builtins.str:
        """
        The email of the service account for this function.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> builtins.int:
        """
        The function execution timeout. Execution is considered failed and
        can be terminated if the function is not completed at the end of the
        timeout period. Defaults to 60 seconds.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def uri(self) -> builtins.str:
        """
        URI of the Service deployed.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="vpcConnector")
    def vpc_connector(self) -> builtins.str:
        """
        The Serverless VPC Access connector that this cloud function can connect to.
        """
        return pulumi.get(self, "vpc_connector")

    @property
    @pulumi.getter(name="vpcConnectorEgressSettings")
    def vpc_connector_egress_settings(self) -> builtins.str:
        """
        Available egress settings. Possible values: ["VPC_CONNECTOR_EGRESS_SETTINGS_UNSPECIFIED", "PRIVATE_RANGES_ONLY", "ALL_TRAFFIC"]
        """
        return pulumi.get(self, "vpc_connector_egress_settings")


@pulumi.output_type
class GetFunctionServiceConfigSecretEnvironmentVariableResult(dict):
    def __init__(__self__, *,
                 key: builtins.str,
                 project_id: builtins.str,
                 secret: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str key: Name of the environment variable.
        :param builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param builtins.str version: Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def key(self) -> builtins.str:
        """
        Name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is recommended to use a numeric version for secret environment variables as any updates to the secret value is not reflected until new instances start.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetFunctionServiceConfigSecretVolumeResult(dict):
    def __init__(__self__, *,
                 mount_path: builtins.str,
                 project_id: builtins.str,
                 secret: builtins.str,
                 versions: Sequence['outputs.GetFunctionServiceConfigSecretVolumeVersionResult']):
        """
        :param builtins.str mount_path: The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        :param builtins.str project_id: Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        :param builtins.str secret: Name of the secret in secret manager (not the full resource name).
        :param Sequence['GetFunctionServiceConfigSecretVolumeVersionArgs'] versions: List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret", secret)
        pulumi.set(__self__, "versions", versions)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> builtins.str:
        """
        The path within the container to mount the secret volume. For example, setting the mountPath as /etc/secrets would mount the secret value files under the /etc/secrets directory. This directory will also be completely shadowed and unavailable to mount any other secrets. Recommended mount path: /etc/secrets
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> builtins.str:
        """
        Project identifier (preferably project number but can also be the project ID) of the project that contains the secret. If not set, it will be populated with the function's project assuming that the secret exists in the same project as of the function.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def secret(self) -> builtins.str:
        """
        Name of the secret in secret manager (not the full resource name).
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetFunctionServiceConfigSecretVolumeVersionResult']:
        """
        List of secret versions to mount for this secret. If empty, the latest version of the secret will be made available in a file named after the secret under the mount point.'
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetFunctionServiceConfigSecretVolumeVersionResult(dict):
    def __init__(__self__, *,
                 path: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str path: Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        :param builtins.str version: Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def path(self) -> builtins.str:
        """
        Relative path of the file under the mount path where the secret value for this version will be fetched and made available. For example, setting the mountPath as '/etc/secrets' and path as secret_foo would mount the secret value file at /etc/secrets/secret_foo.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Version of the secret (version number or the string 'latest'). It is preferable to use latest version with secret volumes as secret value changes are reflected immediately.
        """
        return pulumi.get(self, "version")


