# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SQuotaPreferenceArgs', 'SQuotaPreference']

@pulumi.input_type
class SQuotaPreferenceArgs:
    def __init__(__self__, *,
                 quota_config: pulumi.Input['SQuotaPreferenceQuotaConfigArgs'],
                 contact_email: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_safety_checks: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 quota_id: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SQuotaPreference resource.
        :param pulumi.Input['SQuotaPreferenceQuotaConfigArgs'] quota_config: The preferred quota configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] contact_email: An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
               The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
               NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
               Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        :param pulumi.Input[builtins.str] ignore_safety_checks: The list of quota safety checks to be ignored.
               Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
               Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        :param pulumi.Input[builtins.str] justification: The reason / justification for this quota preference.
        :param pulumi.Input[builtins.str] name: The resource name of the quota preference. Required except in the CREATE requests.
        :param pulumi.Input[builtins.str] parent: The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        :param pulumi.Input[builtins.str] quota_id: The id of the quota to which the quota preference is applied. A quota id is unique in the service.
               Example: `CPUS-per-project-region`.
        :param pulumi.Input[builtins.str] service: The name of the service to which the quota preference is applied.
        """
        pulumi.set(__self__, "quota_config", quota_config)
        if contact_email is not None:
            pulumi.set(__self__, "contact_email", contact_email)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if ignore_safety_checks is not None:
            pulumi.set(__self__, "ignore_safety_checks", ignore_safety_checks)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if quota_id is not None:
            pulumi.set(__self__, "quota_id", quota_id)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="quotaConfig")
    def quota_config(self) -> pulumi.Input['SQuotaPreferenceQuotaConfigArgs']:
        """
        The preferred quota configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "quota_config")

    @quota_config.setter
    def quota_config(self, value: pulumi.Input['SQuotaPreferenceQuotaConfigArgs']):
        pulumi.set(self, "quota_config", value)

    @property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
        The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        """
        return pulumi.get(self, "contact_email")

    @contact_email.setter
    def contact_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_email", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
        NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
        Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="ignoreSafetyChecks")
    def ignore_safety_checks(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The list of quota safety checks to be ignored.
        Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
        Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        """
        return pulumi.get(self, "ignore_safety_checks")

    @ignore_safety_checks.setter
    def ignore_safety_checks(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ignore_safety_checks", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason / justification for this quota preference.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "justification", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the quota preference. Required except in the CREATE requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the quota to which the quota preference is applied. A quota id is unique in the service.
        Example: `CPUS-per-project-region`.
        """
        return pulumi.get(self, "quota_id")

    @quota_id.setter
    def quota_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quota_id", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service to which the quota preference is applied.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class _SQuotaPreferenceState:
    def __init__(__self__, *,
                 contact_email: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 ignore_safety_checks: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 quota_config: Optional[pulumi.Input['SQuotaPreferenceQuotaConfigArgs']] = None,
                 quota_id: Optional[pulumi.Input[builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SQuotaPreference resources.
        :param pulumi.Input[builtins.str] contact_email: An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
               The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        :param pulumi.Input[builtins.str] create_time: Create time stamp.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
               NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
               Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        :param pulumi.Input[builtins.str] etag: The current etag of the quota preference. If an etag is provided on update and does not match the current server's etag of the quota preference, the request will be blocked and an ABORTED error will be returned. See https://google.aip.dev/134#etags for more details on etags.
        :param pulumi.Input[builtins.str] ignore_safety_checks: The list of quota safety checks to be ignored.
               Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
               Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        :param pulumi.Input[builtins.str] justification: The reason / justification for this quota preference.
        :param pulumi.Input[builtins.str] name: The resource name of the quota preference. Required except in the CREATE requests.
        :param pulumi.Input[builtins.str] parent: The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        :param pulumi.Input['SQuotaPreferenceQuotaConfigArgs'] quota_config: The preferred quota configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] quota_id: The id of the quota to which the quota preference is applied. A quota id is unique in the service.
               Example: `CPUS-per-project-region`.
        :param pulumi.Input[builtins.bool] reconciling: Is the quota preference pending Google Cloud approval and fulfillment.
        :param pulumi.Input[builtins.str] service: The name of the service to which the quota preference is applied.
        :param pulumi.Input[builtins.str] update_time: Update time stamp.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        if contact_email is not None:
            pulumi.set(__self__, "contact_email", contact_email)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if ignore_safety_checks is not None:
            pulumi.set(__self__, "ignore_safety_checks", ignore_safety_checks)
        if justification is not None:
            pulumi.set(__self__, "justification", justification)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if quota_config is not None:
            pulumi.set(__self__, "quota_config", quota_config)
        if quota_id is not None:
            pulumi.set(__self__, "quota_id", quota_id)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
        The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        """
        return pulumi.get(self, "contact_email")

    @contact_email.setter
    def contact_email(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "contact_email", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Create time stamp.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
        NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
        Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current etag of the quota preference. If an etag is provided on update and does not match the current server's etag of the quota preference, the request will be blocked and an ABORTED error will be returned. See https://google.aip.dev/134#etags for more details on etags.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter(name="ignoreSafetyChecks")
    def ignore_safety_checks(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The list of quota safety checks to be ignored.
        Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
        Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        """
        return pulumi.get(self, "ignore_safety_checks")

    @ignore_safety_checks.setter
    def ignore_safety_checks(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ignore_safety_checks", value)

    @property
    @pulumi.getter
    def justification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The reason / justification for this quota preference.
        """
        return pulumi.get(self, "justification")

    @justification.setter
    def justification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "justification", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the quota preference. Required except in the CREATE requests.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="quotaConfig")
    def quota_config(self) -> Optional[pulumi.Input['SQuotaPreferenceQuotaConfigArgs']]:
        """
        The preferred quota configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "quota_config")

    @quota_config.setter
    def quota_config(self, value: Optional[pulumi.Input['SQuotaPreferenceQuotaConfigArgs']]):
        pulumi.set(self, "quota_config", value)

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The id of the quota to which the quota preference is applied. A quota id is unique in the service.
        Example: `CPUS-per-project-region`.
        """
        return pulumi.get(self, "quota_id")

    @quota_id.setter
    def quota_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "quota_id", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Is the quota preference pending Google Cloud approval and fulfillment.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service to which the quota preference is applied.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Update time stamp.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:cloudquota/sQuotaPreference:SQuotaPreference")
class SQuotaPreference(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_email: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_safety_checks: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 quota_config: Optional[pulumi.Input[Union['SQuotaPreferenceQuotaConfigArgs', 'SQuotaPreferenceQuotaConfigArgsDict']]] = None,
                 quota_id: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        QuotaPreference represents the preferred quota configuration specified for a project, folder or organization. There is only one QuotaPreference resource for a quota value targeting a unique set of dimensions.

        To get more information about QuotaPreference, see:

        * [API documentation](https://cloud.google.com/docs/quotas/reference/rest/v1/projects.locations.quotaPreferences)
        * How-to Guides
            * [Cloud Quotas Overview](https://cloud.google.com/docs/quotas/overview)

        ## Example Usage

        ### Cloudquotas Quota Preference Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        preference = gcp.cloudquota.SQuotaPreference("preference",
            parent="projects/my-project-name",
            name="compute_googleapis_com-CPUS-per-project_us-east1",
            dimensions={
                "region": "us-east1",
            },
            service="compute.googleapis.com",
            quota_id="CPUS-per-project-region",
            contact_email="testuser@gmail.com",
            quota_config={
                "preferred_value": "200",
            })
        ```

        ## Import

        QuotaPreference can be imported using any of these accepted formats:

        * `{{parent}}/locations/global/quotaPreferences/{{name}}`

        When using the `pulumi import` command, QuotaPreference can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudquota/sQuotaPreference:SQuotaPreference default {{parent}}/locations/global/quotaPreferences/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] contact_email: An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
               The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
               NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
               Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        :param pulumi.Input[builtins.str] ignore_safety_checks: The list of quota safety checks to be ignored.
               Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
               Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        :param pulumi.Input[builtins.str] justification: The reason / justification for this quota preference.
        :param pulumi.Input[builtins.str] name: The resource name of the quota preference. Required except in the CREATE requests.
        :param pulumi.Input[builtins.str] parent: The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        :param pulumi.Input[Union['SQuotaPreferenceQuotaConfigArgs', 'SQuotaPreferenceQuotaConfigArgsDict']] quota_config: The preferred quota configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] quota_id: The id of the quota to which the quota preference is applied. A quota id is unique in the service.
               Example: `CPUS-per-project-region`.
        :param pulumi.Input[builtins.str] service: The name of the service to which the quota preference is applied.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SQuotaPreferenceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        QuotaPreference represents the preferred quota configuration specified for a project, folder or organization. There is only one QuotaPreference resource for a quota value targeting a unique set of dimensions.

        To get more information about QuotaPreference, see:

        * [API documentation](https://cloud.google.com/docs/quotas/reference/rest/v1/projects.locations.quotaPreferences)
        * How-to Guides
            * [Cloud Quotas Overview](https://cloud.google.com/docs/quotas/overview)

        ## Example Usage

        ### Cloudquotas Quota Preference Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        preference = gcp.cloudquota.SQuotaPreference("preference",
            parent="projects/my-project-name",
            name="compute_googleapis_com-CPUS-per-project_us-east1",
            dimensions={
                "region": "us-east1",
            },
            service="compute.googleapis.com",
            quota_id="CPUS-per-project-region",
            contact_email="testuser@gmail.com",
            quota_config={
                "preferred_value": "200",
            })
        ```

        ## Import

        QuotaPreference can be imported using any of these accepted formats:

        * `{{parent}}/locations/global/quotaPreferences/{{name}}`

        When using the `pulumi import` command, QuotaPreference can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudquota/sQuotaPreference:SQuotaPreference default {{parent}}/locations/global/quotaPreferences/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param SQuotaPreferenceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SQuotaPreferenceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 contact_email: Optional[pulumi.Input[builtins.str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ignore_safety_checks: Optional[pulumi.Input[builtins.str]] = None,
                 justification: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 quota_config: Optional[pulumi.Input[Union['SQuotaPreferenceQuotaConfigArgs', 'SQuotaPreferenceQuotaConfigArgsDict']]] = None,
                 quota_id: Optional[pulumi.Input[builtins.str]] = None,
                 service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SQuotaPreferenceArgs.__new__(SQuotaPreferenceArgs)

            __props__.__dict__["contact_email"] = contact_email
            __props__.__dict__["dimensions"] = dimensions
            __props__.__dict__["ignore_safety_checks"] = ignore_safety_checks
            __props__.__dict__["justification"] = justification
            __props__.__dict__["name"] = name
            __props__.__dict__["parent"] = parent
            if quota_config is None and not opts.urn:
                raise TypeError("Missing required property 'quota_config'")
            __props__.__dict__["quota_config"] = quota_config
            __props__.__dict__["quota_id"] = quota_id
            __props__.__dict__["service"] = service
            __props__.__dict__["create_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["update_time"] = None
        super(SQuotaPreference, __self__).__init__(
            'gcp:cloudquota/sQuotaPreference:SQuotaPreference',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            contact_email: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            ignore_safety_checks: Optional[pulumi.Input[builtins.str]] = None,
            justification: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            quota_config: Optional[pulumi.Input[Union['SQuotaPreferenceQuotaConfigArgs', 'SQuotaPreferenceQuotaConfigArgsDict']]] = None,
            quota_id: Optional[pulumi.Input[builtins.str]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            service: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'SQuotaPreference':
        """
        Get an existing SQuotaPreference resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] contact_email: An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
               The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        :param pulumi.Input[builtins.str] create_time: Create time stamp.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] dimensions: The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
               NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
               Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        :param pulumi.Input[builtins.str] etag: The current etag of the quota preference. If an etag is provided on update and does not match the current server's etag of the quota preference, the request will be blocked and an ABORTED error will be returned. See https://google.aip.dev/134#etags for more details on etags.
        :param pulumi.Input[builtins.str] ignore_safety_checks: The list of quota safety checks to be ignored.
               Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
               Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        :param pulumi.Input[builtins.str] justification: The reason / justification for this quota preference.
        :param pulumi.Input[builtins.str] name: The resource name of the quota preference. Required except in the CREATE requests.
        :param pulumi.Input[builtins.str] parent: The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        :param pulumi.Input[Union['SQuotaPreferenceQuotaConfigArgs', 'SQuotaPreferenceQuotaConfigArgsDict']] quota_config: The preferred quota configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] quota_id: The id of the quota to which the quota preference is applied. A quota id is unique in the service.
               Example: `CPUS-per-project-region`.
        :param pulumi.Input[builtins.bool] reconciling: Is the quota preference pending Google Cloud approval and fulfillment.
        :param pulumi.Input[builtins.str] service: The name of the service to which the quota preference is applied.
        :param pulumi.Input[builtins.str] update_time: Update time stamp.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SQuotaPreferenceState.__new__(_SQuotaPreferenceState)

        __props__.__dict__["contact_email"] = contact_email
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["etag"] = etag
        __props__.__dict__["ignore_safety_checks"] = ignore_safety_checks
        __props__.__dict__["justification"] = justification
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["quota_config"] = quota_config
        __props__.__dict__["quota_id"] = quota_id
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["service"] = service
        __props__.__dict__["update_time"] = update_time
        return SQuotaPreference(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contactEmail")
    def contact_email(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An email address that can be used for quota related communication between the Google Cloud and the user in case the Google Cloud needs further information to make a decision on whether the user preferred quota can be granted.
        The Google account for the email address must have quota update permission for the project, folder or organization this quota preference is for.
        """
        return pulumi.get(self, "contact_email")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Create time stamp.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The dimensions that this quota preference applies to. The key of the map entry is the name of a dimension, such as "region", "zone", "network_id", and the value of the map entry is the dimension value. If a dimension is missing from the map of dimensions, the quota preference applies to all the dimension values except for those that have other quota preferences configured for the specific value.
        NOTE: QuotaPreferences can only be applied across all values of "user" and "resource" dimension. Do not set values for "user" or "resource" in the dimension map.
        Example: `{"provider": "Foo Inc"}` where "provider" is a service specific dimension.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        The current etag of the quota preference. If an etag is provided on update and does not match the current server's etag of the quota preference, the request will be blocked and an ABORTED error will be returned. See https://google.aip.dev/134#etags for more details on etags.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="ignoreSafetyChecks")
    def ignore_safety_checks(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The list of quota safety checks to be ignored.
        Default value is `QUOTA_SAFETY_CHECK_UNSPECIFIED`.
        Possible values are: `QUOTA_SAFETY_CHECK_UNSPECIFIED`, `QUOTA_DECREASE_BELOW_USAGE`, `QUOTA_DECREASE_PERCENTAGE_TOO_HIGH`.
        """
        return pulumi.get(self, "ignore_safety_checks")

    @property
    @pulumi.getter
    def justification(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The reason / justification for this quota preference.
        """
        return pulumi.get(self, "justification")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the quota preference. Required except in the CREATE requests.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of the quota preference. Allowed parents are "projects/[project-id / number]" or "folders/[folder-id / number]" or "organizations/[org-id / number]".
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="quotaConfig")
    def quota_config(self) -> pulumi.Output['outputs.SQuotaPreferenceQuotaConfig']:
        """
        The preferred quota configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "quota_config")

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> pulumi.Output[builtins.str]:
        """
        The id of the quota to which the quota preference is applied. A quota id is unique in the service.
        Example: `CPUS-per-project-region`.
        """
        return pulumi.get(self, "quota_id")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Is the quota preference pending Google Cloud approval and fulfillment.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[builtins.str]:
        """
        The name of the service to which the quota preference is applied.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Update time stamp.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: `2014-10-02T15:01:23Z` and `2014-10-02T15:01:23.045123456Z`.
        """
        return pulumi.get(self, "update_time")

