# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 autogenerate_revision_name: Optional[pulumi.Input[builtins.bool]] = None,
                 metadata: Optional[pulumi.Input['ServiceMetadataArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[builtins.bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input['ServiceMetadataArgs'] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name must be unique within a Google Cloud project and region.
               Is required when creating resources. Name is primarily intended
               for creation idempotence and configuration definition. Cannot be updated.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ServiceTemplateArgs'] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if autogenerate_revision_name is not None:
            pulumi.set(__self__, "autogenerate_revision_name", autogenerate_revision_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @autogenerate_revision_name.setter
    def autogenerate_revision_name(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autogenerate_revision_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ServiceMetadataArgs']]:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ServiceMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name must be unique within a Google Cloud project and region.
        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 autogenerate_revision_name: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input['ServiceMetadataArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[builtins.bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input['ServiceMetadataArgs'] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name must be unique within a Google Cloud project and region.
               Is required when creating resources. Name is primarily intended
               for creation idempotence and configuration definition. Cannot be updated.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]] statuses: (Output)
               Status of the condition, one of True, False, Unknown.
        :param pulumi.Input['ServiceTemplateArgs'] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        if autogenerate_revision_name is not None:
            pulumi.set(__self__, "autogenerate_revision_name", autogenerate_revision_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @autogenerate_revision_name.setter
    def autogenerate_revision_name(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "autogenerate_revision_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ServiceMetadataArgs']]:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ServiceMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name must be unique within a Google Cloud project and region.
        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


@pulumi.type_token("gcp:cloudrun/service:Service")
class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autogenerate_revision_name: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['ServiceMetadataArgs', 'ServiceMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None,
                 __props__=None):
        """
        A Cloud Run service has a unique endpoint and autoscales containers.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        > **Warning:** We recommend using the `cloudrunv2.Service` resource which offers a better
        developer experience and broader support of Cloud Run features.

        ## Example Usage

        ### Cloud Run Service Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloud_run_service_name",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        sa = gcp.serviceaccount.Account("sa",
            account_id="cloud-run-pubsub-invoker",
            display_name="Cloud Run Pub/Sub Invoker")
        binding = gcp.cloudrun.IamBinding("binding",
            location=default.location,
            service=default.name,
            role="roles/run.invoker",
            members=[sa.email.apply(lambda email: f"serviceAccount:{email}")])
        project = gcp.projects.IAMBinding("project",
            role="roles/iam.serviceAccountTokenCreator",
            members=[sa.email.apply(lambda email: f"serviceAccount:{email}")])
        topic = gcp.pubsub.Topic("topic", name="pubsub_topic")
        subscription = gcp.pubsub.Subscription("subscription",
            name="pubsub_subscription",
            topic=topic.name,
            push_config={
                "push_endpoint": default.statuses[0].url,
                "oidc_token": {
                    "service_account_email": sa.email,
                },
                "attributes": {
                    "x-goog-version": "v1",
                },
            })
        ```

        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        ```
        ### Cloud Run Service Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "annotations": {
                    "run.googleapis.com/launch-stage": "BETA",
                },
            },
            template={
                "metadata": {
                    "annotations": {
                        "autoscaling.knative.dev/maxScale": "1",
                        "run.googleapis.com/cpu-throttling": "false",
                    },
                },
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                        "resources": {
                            "limits": {
                                "cpu": "4",
                                "memory": "16Gi",
                                "nvidia.com/gpu": "1",
                            },
                        },
                    }],
                    "node_selector": {
                        "run.googleapis.com/accelerator": "nvidia-l4",
                    },
                },
            })
        ```
        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-east1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
                "metadata": {
                    "annotations": {
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/cloudsql-instances": instance.connection_name,
                        "run.googleapis.com/client-name": "demo",
                    },
                },
            },
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Noauth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            })
        noauth = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/run.invoker",
            "members": ["allUsers"],
        }])
        noauth_iam_policy = gcp.cloudrun.IamPolicy("noauth",
            location=default.location,
            project=default.project,
            service=default.name,
            policy_data=noauth.policy_data)
        ```
        ### Cloud Run Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "startup_probe": {
                            "initial_delay_seconds": 0,
                            "timeout_seconds": 1,
                            "period_seconds": 3,
                            "failure_threshold": 1,
                            "tcp_socket": {
                                "port": 8080,
                            },
                        },
                        "liveness_probe": {
                            "http_get": {
                                "path": "/",
                            },
                        },
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        ```
        ### Cloud Run Service Multicontainer

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "metadata": {
                    "annotations": {
                        "run.googleapis.com/container-dependencies": json.dumps({
                            "hello-1": ["hello-2"],
                        }),
                    },
                },
                "spec": {
                    "containers": [
                        {
                            "name": "hello-1",
                            "ports": [{
                                "container_port": 8080,
                            }],
                            "image": "us-docker.pkg.dev/cloudrun/container/hello",
                            "volume_mounts": [{
                                "name": "shared-volume",
                                "mount_path": "/mnt/shared",
                            }],
                        },
                        {
                            "name": "hello-2",
                            "image": "us-docker.pkg.dev/cloudrun/container/hello",
                            "envs": [{
                                "name": "PORT",
                                "value": "8081",
                            }],
                            "startup_probe": {
                                "http_get": {
                                    "port": 8081,
                                },
                            },
                            "volume_mounts": [{
                                "name": "shared-volume",
                                "mount_path": "/mnt/shared",
                            }],
                        },
                    ],
                    "volumes": [{
                        "name": "shared-volume",
                        "empty_dir": {
                            "medium": "Memory",
                            "size_limit": "128Mi",
                        },
                    }],
                },
            })
        ```
        ### Cloud Run Service Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "annotations": {
                    "run.googleapis.com/launch-stage": "BETA",
                    "run.googleapis.com/iap-enabled": "true",
                },
            },
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `locations/{{location}}/namespaces/{{project}}/services/{{name}}`

        * `{{location}}/{{project}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default locations/{{location}}/namespaces/{{project}}/services/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[Union['ServiceMetadataArgs', 'ServiceMetadataArgsDict']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name must be unique within a Google Cloud project and region.
               Is required when creating resources. Name is primarily intended
               for creation idempotence and configuration definition. Cannot be updated.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Cloud Run service has a unique endpoint and autoscales containers.

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        > **Warning:** We recommend using the `cloudrunv2.Service` resource which offers a better
        developer experience and broader support of Cloud Run features.

        ## Example Usage

        ### Cloud Run Service Pubsub

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloud_run_service_name",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        sa = gcp.serviceaccount.Account("sa",
            account_id="cloud-run-pubsub-invoker",
            display_name="Cloud Run Pub/Sub Invoker")
        binding = gcp.cloudrun.IamBinding("binding",
            location=default.location,
            service=default.name,
            role="roles/run.invoker",
            members=[sa.email.apply(lambda email: f"serviceAccount:{email}")])
        project = gcp.projects.IAMBinding("project",
            role="roles/iam.serviceAccountTokenCreator",
            members=[sa.email.apply(lambda email: f"serviceAccount:{email}")])
        topic = gcp.pubsub.Topic("topic", name="pubsub_topic")
        subscription = gcp.pubsub.Subscription("subscription",
            name="pubsub_subscription",
            topic=topic.name,
            push_config={
                "push_endpoint": default.statuses[0].url,
                "oidc_token": {
                    "service_account_email": sa.email,
                },
                "attributes": {
                    "x-goog-version": "v1",
                },
            })
        ```

        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        ```
        ### Cloud Run Service Gpu

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "annotations": {
                    "run.googleapis.com/launch-stage": "BETA",
                },
            },
            template={
                "metadata": {
                    "annotations": {
                        "autoscaling.knative.dev/maxScale": "1",
                        "run.googleapis.com/cpu-throttling": "false",
                    },
                },
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                        "resources": {
                            "limits": {
                                "cpu": "4",
                                "memory": "16Gi",
                                "nvidia.com/gpu": "1",
                            },
                        },
                    }],
                    "node_selector": {
                        "run.googleapis.com/accelerator": "nvidia-l4",
                    },
                },
            })
        ```
        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            name="cloudrun-sql",
            region="us-east1",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-f1-micro",
            },
            deletion_protection=True)
        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
                "metadata": {
                    "annotations": {
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/cloudsql-instances": instance.connection_name,
                        "run.googleapis.com/client-name": "demo",
                    },
                },
            },
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Noauth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                    }],
                },
            })
        noauth = gcp.organizations.get_iam_policy(bindings=[{
            "role": "roles/run.invoker",
            "members": ["allUsers"],
        }])
        noauth_iam_policy = gcp.cloudrun.IamPolicy("noauth",
            location=default.location,
            project=default.project,
            service=default.name,
            policy_data=noauth.policy_data)
        ```
        ### Cloud Run Service Probes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "spec": {
                    "containers": [{
                        "image": "us-docker.pkg.dev/cloudrun/container/hello",
                        "startup_probe": {
                            "initial_delay_seconds": 0,
                            "timeout_seconds": 1,
                            "period_seconds": 3,
                            "failure_threshold": 1,
                            "tcp_socket": {
                                "port": 8080,
                            },
                        },
                        "liveness_probe": {
                            "http_get": {
                                "path": "/",
                            },
                        },
                    }],
                },
            },
            traffics=[{
                "percent": 100,
                "latest_revision": True,
            }])
        ```
        ### Cloud Run Service Multicontainer

        ```python
        import pulumi
        import json
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            template={
                "metadata": {
                    "annotations": {
                        "run.googleapis.com/container-dependencies": json.dumps({
                            "hello-1": ["hello-2"],
                        }),
                    },
                },
                "spec": {
                    "containers": [
                        {
                            "name": "hello-1",
                            "ports": [{
                                "container_port": 8080,
                            }],
                            "image": "us-docker.pkg.dev/cloudrun/container/hello",
                            "volume_mounts": [{
                                "name": "shared-volume",
                                "mount_path": "/mnt/shared",
                            }],
                        },
                        {
                            "name": "hello-2",
                            "image": "us-docker.pkg.dev/cloudrun/container/hello",
                            "envs": [{
                                "name": "PORT",
                                "value": "8081",
                            }],
                            "startup_probe": {
                                "http_get": {
                                    "port": 8081,
                                },
                            },
                            "volume_mounts": [{
                                "name": "shared-volume",
                                "mount_path": "/mnt/shared",
                            }],
                        },
                    ],
                    "volumes": [{
                        "name": "shared-volume",
                        "empty_dir": {
                            "medium": "Memory",
                            "size_limit": "128Mi",
                        },
                    }],
                },
            })
        ```
        ### Cloud Run Service Iap

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            name="cloudrun-srv",
            location="us-central1",
            metadata={
                "annotations": {
                    "run.googleapis.com/launch-stage": "BETA",
                    "run.googleapis.com/iap-enabled": "true",
                },
            },
            template={
                "spec": {
                    "containers": [{
                        "image": "gcr.io/cloudrun/hello",
                    }],
                },
            })
        ```

        ## Import

        Service can be imported using any of these accepted formats:

        * `locations/{{location}}/namespaces/{{project}}/services/{{name}}`

        * `{{location}}/{{project}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Service can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default locations/{{location}}/namespaces/{{project}}/services/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autogenerate_revision_name: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Union['ServiceMetadataArgs', 'ServiceMetadataArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["autogenerate_revision_name"] = autogenerate_revision_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["template"] = template
            __props__.__dict__["traffics"] = traffics
            __props__.__dict__["statuses"] = None
        super(Service, __self__).__init__(
            'gcp:cloudrun/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autogenerate_revision_name: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Union['ServiceMetadataArgs', 'ServiceMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceStatusArgs', 'ServiceStatusArgsDict']]]]] = None,
            template: Optional[pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']]] = None,
            traffics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[builtins.str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[Union['ServiceMetadataArgs', 'ServiceMetadataArgsDict']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name must be unique within a Google Cloud project and region.
               Is required when creating resources. Name is primarily intended
               for creation idempotence and configuration definition. Cannot be updated.
               More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceStatusArgs', 'ServiceStatusArgsDict']]]] statuses: (Output)
               Status of the condition, one of True, False, Unknown.
        :param pulumi.Input[Union['ServiceTemplateArgs', 'ServiceTemplateArgsDict']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceTrafficArgs', 'ServiceTrafficArgsDict']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["autogenerate_revision_name"] = autogenerate_revision_name
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["template"] = template
        __props__.__dict__["traffics"] = traffics
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.ServiceMetadata']:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name must be unique within a Google Cloud project and region.
        Is required when creating resources. Name is primarily intended
        for creation idempotence and configuration definition. Cannot be updated.
        More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ServiceStatus']]:
        """
        (Output)
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.ServiceTemplate']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/main/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def traffics(self) -> pulumi.Output[Sequence['outputs.ServiceTraffic']]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

