# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotebookExecutionArgs', 'NotebookExecution']

@pulumi.input_type
class NotebookExecutionArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 gcs_output_uri: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 dataform_repository_source: Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']] = None,
                 direct_notebook_source: Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']] = None,
                 execution_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 execution_user: Optional[pulumi.Input[builtins.str]] = None,
                 gcs_notebook_source: Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']] = None,
                 notebook_execution_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NotebookExecution resource.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Notebook Execution.
        :param pulumi.Input[builtins.str] gcs_output_uri: The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input['NotebookExecutionDataformRepositorySourceArgs'] dataform_repository_source: The Dataform Repository containing the input notebook.
               Structure is documented below.
        :param pulumi.Input['NotebookExecutionDirectNotebookSourceArgs'] direct_notebook_source: The content of the input notebook in ipynb format.
               Structure is documented below.
        :param pulumi.Input[builtins.str] execution_timeout: Max running time of the execution job in seconds (default 86400s / 24 hrs).
        :param pulumi.Input[builtins.str] execution_user: The user email to run the execution as.
        :param pulumi.Input['NotebookExecutionGcsNotebookSourceArgs'] gcs_notebook_source: The Cloud Storage uri for the input notebook.
               Structure is documented below.
        :param pulumi.Input[builtins.str] notebook_execution_job_id: User specified ID for the Notebook Execution Job
        :param pulumi.Input[builtins.str] notebook_runtime_template_resource_name: The NotebookRuntimeTemplate to source compute configuration from.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: The service account to run the execution as.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "gcs_output_uri", gcs_output_uri)
        pulumi.set(__self__, "location", location)
        if dataform_repository_source is not None:
            pulumi.set(__self__, "dataform_repository_source", dataform_repository_source)
        if direct_notebook_source is not None:
            pulumi.set(__self__, "direct_notebook_source", direct_notebook_source)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if execution_user is not None:
            pulumi.set(__self__, "execution_user", execution_user)
        if gcs_notebook_source is not None:
            pulumi.set(__self__, "gcs_notebook_source", gcs_notebook_source)
        if notebook_execution_job_id is not None:
            pulumi.set(__self__, "notebook_execution_job_id", notebook_execution_job_id)
        if notebook_runtime_template_resource_name is not None:
            pulumi.set(__self__, "notebook_runtime_template_resource_name", notebook_runtime_template_resource_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Required. The display name of the Notebook Execution.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="gcsOutputUri")
    def gcs_output_uri(self) -> pulumi.Input[builtins.str]:
        """
        The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        """
        return pulumi.get(self, "gcs_output_uri")

    @gcs_output_uri.setter
    def gcs_output_uri(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "gcs_output_uri", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="dataformRepositorySource")
    def dataform_repository_source(self) -> Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']]:
        """
        The Dataform Repository containing the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "dataform_repository_source")

    @dataform_repository_source.setter
    def dataform_repository_source(self, value: Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']]):
        pulumi.set(self, "dataform_repository_source", value)

    @property
    @pulumi.getter(name="directNotebookSource")
    def direct_notebook_source(self) -> Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']]:
        """
        The content of the input notebook in ipynb format.
        Structure is documented below.
        """
        return pulumi.get(self, "direct_notebook_source")

    @direct_notebook_source.setter
    def direct_notebook_source(self, value: Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']]):
        pulumi.set(self, "direct_notebook_source", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Max running time of the execution job in seconds (default 86400s / 24 hrs).
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @property
    @pulumi.getter(name="executionUser")
    def execution_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user email to run the execution as.
        """
        return pulumi.get(self, "execution_user")

    @execution_user.setter
    def execution_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_user", value)

    @property
    @pulumi.getter(name="gcsNotebookSource")
    def gcs_notebook_source(self) -> Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']]:
        """
        The Cloud Storage uri for the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_notebook_source")

    @gcs_notebook_source.setter
    def gcs_notebook_source(self, value: Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']]):
        pulumi.set(self, "gcs_notebook_source", value)

    @property
    @pulumi.getter(name="notebookExecutionJobId")
    def notebook_execution_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User specified ID for the Notebook Execution Job
        """
        return pulumi.get(self, "notebook_execution_job_id")

    @notebook_execution_job_id.setter
    def notebook_execution_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notebook_execution_job_id", value)

    @property
    @pulumi.getter(name="notebookRuntimeTemplateResourceName")
    def notebook_runtime_template_resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NotebookRuntimeTemplate to source compute configuration from.
        """
        return pulumi.get(self, "notebook_runtime_template_resource_name")

    @notebook_runtime_template_resource_name.setter
    def notebook_runtime_template_resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notebook_runtime_template_resource_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service account to run the execution as.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)


@pulumi.input_type
class _NotebookExecutionState:
    def __init__(__self__, *,
                 dataform_repository_source: Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']] = None,
                 direct_notebook_source: Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 execution_user: Optional[pulumi.Input[builtins.str]] = None,
                 gcs_notebook_source: Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']] = None,
                 gcs_output_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_execution_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NotebookExecution resources.
        :param pulumi.Input['NotebookExecutionDataformRepositorySourceArgs'] dataform_repository_source: The Dataform Repository containing the input notebook.
               Structure is documented below.
        :param pulumi.Input['NotebookExecutionDirectNotebookSourceArgs'] direct_notebook_source: The content of the input notebook in ipynb format.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Notebook Execution.
        :param pulumi.Input[builtins.str] execution_timeout: Max running time of the execution job in seconds (default 86400s / 24 hrs).
        :param pulumi.Input[builtins.str] execution_user: The user email to run the execution as.
        :param pulumi.Input['NotebookExecutionGcsNotebookSourceArgs'] gcs_notebook_source: The Cloud Storage uri for the input notebook.
               Structure is documented below.
        :param pulumi.Input[builtins.str] gcs_output_uri: The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] notebook_execution_job_id: User specified ID for the Notebook Execution Job
        :param pulumi.Input[builtins.str] notebook_runtime_template_resource_name: The NotebookRuntimeTemplate to source compute configuration from.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: The service account to run the execution as.
        """
        if dataform_repository_source is not None:
            pulumi.set(__self__, "dataform_repository_source", dataform_repository_source)
        if direct_notebook_source is not None:
            pulumi.set(__self__, "direct_notebook_source", direct_notebook_source)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if execution_timeout is not None:
            pulumi.set(__self__, "execution_timeout", execution_timeout)
        if execution_user is not None:
            pulumi.set(__self__, "execution_user", execution_user)
        if gcs_notebook_source is not None:
            pulumi.set(__self__, "gcs_notebook_source", gcs_notebook_source)
        if gcs_output_uri is not None:
            pulumi.set(__self__, "gcs_output_uri", gcs_output_uri)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if notebook_execution_job_id is not None:
            pulumi.set(__self__, "notebook_execution_job_id", notebook_execution_job_id)
        if notebook_runtime_template_resource_name is not None:
            pulumi.set(__self__, "notebook_runtime_template_resource_name", notebook_runtime_template_resource_name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="dataformRepositorySource")
    def dataform_repository_source(self) -> Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']]:
        """
        The Dataform Repository containing the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "dataform_repository_source")

    @dataform_repository_source.setter
    def dataform_repository_source(self, value: Optional[pulumi.Input['NotebookExecutionDataformRepositorySourceArgs']]):
        pulumi.set(self, "dataform_repository_source", value)

    @property
    @pulumi.getter(name="directNotebookSource")
    def direct_notebook_source(self) -> Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']]:
        """
        The content of the input notebook in ipynb format.
        Structure is documented below.
        """
        return pulumi.get(self, "direct_notebook_source")

    @direct_notebook_source.setter
    def direct_notebook_source(self, value: Optional[pulumi.Input['NotebookExecutionDirectNotebookSourceArgs']]):
        pulumi.set(self, "direct_notebook_source", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The display name of the Notebook Execution.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Max running time of the execution job in seconds (default 86400s / 24 hrs).
        """
        return pulumi.get(self, "execution_timeout")

    @execution_timeout.setter
    def execution_timeout(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_timeout", value)

    @property
    @pulumi.getter(name="executionUser")
    def execution_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user email to run the execution as.
        """
        return pulumi.get(self, "execution_user")

    @execution_user.setter
    def execution_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "execution_user", value)

    @property
    @pulumi.getter(name="gcsNotebookSource")
    def gcs_notebook_source(self) -> Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']]:
        """
        The Cloud Storage uri for the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_notebook_source")

    @gcs_notebook_source.setter
    def gcs_notebook_source(self, value: Optional[pulumi.Input['NotebookExecutionGcsNotebookSourceArgs']]):
        pulumi.set(self, "gcs_notebook_source", value)

    @property
    @pulumi.getter(name="gcsOutputUri")
    def gcs_output_uri(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        """
        return pulumi.get(self, "gcs_output_uri")

    @gcs_output_uri.setter
    def gcs_output_uri(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcs_output_uri", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="notebookExecutionJobId")
    def notebook_execution_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User specified ID for the Notebook Execution Job
        """
        return pulumi.get(self, "notebook_execution_job_id")

    @notebook_execution_job_id.setter
    def notebook_execution_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notebook_execution_job_id", value)

    @property
    @pulumi.getter(name="notebookRuntimeTemplateResourceName")
    def notebook_runtime_template_resource_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The NotebookRuntimeTemplate to source compute configuration from.
        """
        return pulumi.get(self, "notebook_runtime_template_resource_name")

    @notebook_runtime_template_resource_name.setter
    def notebook_runtime_template_resource_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notebook_runtime_template_resource_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The service account to run the execution as.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)


@pulumi.type_token("gcp:colab/notebookExecution:NotebookExecution")
class NotebookExecution(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataform_repository_source: Optional[pulumi.Input[Union['NotebookExecutionDataformRepositorySourceArgs', 'NotebookExecutionDataformRepositorySourceArgsDict']]] = None,
                 direct_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionDirectNotebookSourceArgs', 'NotebookExecutionDirectNotebookSourceArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 execution_user: Optional[pulumi.Input[builtins.str]] = None,
                 gcs_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionGcsNotebookSourceArgs', 'NotebookExecutionGcsNotebookSourceArgsDict']]] = None,
                 gcs_output_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_execution_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        'An instance of a notebook Execution'

        To get more information about NotebookExecution, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookExecutionJobs)
        * How-to Guides
            * [Schedule a notebook run](https://cloud.google.com/colab/docs/schedule-notebook-run)

        ## Example Usage

        ### Colab Notebook Execution Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            display_name="Notebook execution basic",
            location="us-central1",
            direct_notebook_source={
                "content": std.base64encode(input=\"\"\"    {
              "cells": [
                {
                  "cell_type": "code",
                  "execution_count": null,
                  "metadata": {},
                  "outputs": [],
                  "source": [
                    "print(\\"Hello, World!\\")"
                  ]
                }
              ],
              "metadata": {
                "kernelspec": {
                  "display_name": "Python 3",
                  "language": "python",
                  "name": "python3"
                },
                "language_info": {
                  "codemirror_mode": {
                    "name": "ipython",
                    "version": 3
                  },
                  "file_extension": ".py",
                  "mimetype": "text/x-python",
                  "name": "python",
                  "nbconvert_exporter": "python",
                  "pygments_lexer": "ipython3",
                  "version": "3.8.5"
                }
              },
              "nbformat": 4,
              "nbformat_minor": 4
            }
        \"\"\").result,
            },
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            service_account="my@service-account.com",
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Notebook Execution Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              "cells": [
                {
                  "cell_type": "code",
                  "execution_count": null,
                  "metadata": {},
                  "outputs": [],
                  "source": [
                    "print(\\"Hello, World!\\")"
                  ]
                }
              ],
              "metadata": {
                "kernelspec": {
                  "display_name": "Python 3",
                  "language": "python",
                  "name": "python3"
                },
                "language_info": {
                  "codemirror_mode": {
                    "name": "ipython",
                    "version": 3
                  },
                  "file_extension": ".py",
                  "mimetype": "text/x-python",
                  "name": "python",
                  "nbconvert_exporter": "python",
                  "pygments_lexer": "ipython3",
                  "version": "3.8.5"
                }
              },
              "nbformat": 4,
              "nbformat_minor": 4
            }
        \"\"\")
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            notebook_execution_job_id="colab-notebook-execution",
            display_name="Notebook execution full",
            location="us-central1",
            execution_timeout="86400s",
            gcs_notebook_source={
                "uri": pulumi.Output.all(
                    bucket=notebook.bucket,
                    name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                "generation": notebook.generation,
            },
            service_account="my@service-account.com",
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            opts = pulumi.ResourceOptions(depends_on=[
                    notebook,
                    output_bucket,
                    my_runtime_template,
                ]))
        ```
        ### Colab Notebook Execution Dataform

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="secret-data")
        dataform_repository = gcp.dataform.Repository("dataform_repository",
            name="dataform-repository",
            display_name="dataform_repository",
            npmrc_environment_variables_secret_version=secret_version.id,
            kms_key_name="my-crypto-key",
            labels={
                "label_foo1": "label-bar1",
            },
            git_remote_settings={
                "url": "https://github.com/OWNER/REPOSITORY.git",
                "default_branch": "main",
                "authentication_token_secret_version": secret_version.id,
            },
            workspace_compilation_overrides={
                "default_database": "database",
                "schema_suffix": "_suffix",
                "table_prefix": "prefix_",
            })
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            display_name="Notebook execution Dataform",
            location="us-central1",
            dataform_repository_source={
                "commit_sha": "randomsha123",
                "dataform_repository_resource_name": pulumi.Output.all(
                    project=my_runtime_template.project,
                    location=my_runtime_template.location,
                    name=dataform_repository.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/repositories/{resolved_outputs['name']}")
        ,
            },
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            service_account="my@service-account.com",
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                    secret_version,
                    dataform_repository,
                    secret,
                ]))
        ```

        ## Import

        NotebookExecution can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookExecutionJobs/{{notebook_execution_job_id}}`

        * `{{project}}/{{location}}/{{notebook_execution_job_id}}`

        * `{{location}}/{{notebook_execution_job_id}}`

        When using the `pulumi import` command, NotebookExecution can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default projects/{{project}}/locations/{{location}}/notebookExecutionJobs/{{notebook_execution_job_id}}
        ```

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default {{project}}/{{location}}/{{notebook_execution_job_id}}
        ```

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default {{location}}/{{notebook_execution_job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotebookExecutionDataformRepositorySourceArgs', 'NotebookExecutionDataformRepositorySourceArgsDict']] dataform_repository_source: The Dataform Repository containing the input notebook.
               Structure is documented below.
        :param pulumi.Input[Union['NotebookExecutionDirectNotebookSourceArgs', 'NotebookExecutionDirectNotebookSourceArgsDict']] direct_notebook_source: The content of the input notebook in ipynb format.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Notebook Execution.
        :param pulumi.Input[builtins.str] execution_timeout: Max running time of the execution job in seconds (default 86400s / 24 hrs).
        :param pulumi.Input[builtins.str] execution_user: The user email to run the execution as.
        :param pulumi.Input[Union['NotebookExecutionGcsNotebookSourceArgs', 'NotebookExecutionGcsNotebookSourceArgsDict']] gcs_notebook_source: The Cloud Storage uri for the input notebook.
               Structure is documented below.
        :param pulumi.Input[builtins.str] gcs_output_uri: The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] notebook_execution_job_id: User specified ID for the Notebook Execution Job
        :param pulumi.Input[builtins.str] notebook_runtime_template_resource_name: The NotebookRuntimeTemplate to source compute configuration from.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: The service account to run the execution as.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotebookExecutionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        'An instance of a notebook Execution'

        To get more information about NotebookExecution, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookExecutionJobs)
        * How-to Guides
            * [Schedule a notebook run](https://cloud.google.com/colab/docs/schedule-notebook-run)

        ## Example Usage

        ### Colab Notebook Execution Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            display_name="Notebook execution basic",
            location="us-central1",
            direct_notebook_source={
                "content": std.base64encode(input=\"\"\"    {
              "cells": [
                {
                  "cell_type": "code",
                  "execution_count": null,
                  "metadata": {},
                  "outputs": [],
                  "source": [
                    "print(\\"Hello, World!\\")"
                  ]
                }
              ],
              "metadata": {
                "kernelspec": {
                  "display_name": "Python 3",
                  "language": "python",
                  "name": "python3"
                },
                "language_info": {
                  "codemirror_mode": {
                    "name": "ipython",
                    "version": 3
                  },
                  "file_extension": ".py",
                  "mimetype": "text/x-python",
                  "name": "python",
                  "nbconvert_exporter": "python",
                  "pygments_lexer": "ipython3",
                  "version": "3.8.5"
                }
              },
              "nbformat": 4,
              "nbformat_minor": 4
            }
        \"\"\").result,
            },
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            service_account="my@service-account.com",
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                ]))
        ```
        ### Colab Notebook Execution Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        notebook = gcp.storage.BucketObject("notebook",
            name="hello_world.ipynb",
            bucket=output_bucket.name,
            content=\"\"\"    {
              "cells": [
                {
                  "cell_type": "code",
                  "execution_count": null,
                  "metadata": {},
                  "outputs": [],
                  "source": [
                    "print(\\"Hello, World!\\")"
                  ]
                }
              ],
              "metadata": {
                "kernelspec": {
                  "display_name": "Python 3",
                  "language": "python",
                  "name": "python3"
                },
                "language_info": {
                  "codemirror_mode": {
                    "name": "ipython",
                    "version": 3
                  },
                  "file_extension": ".py",
                  "mimetype": "text/x-python",
                  "name": "python",
                  "nbconvert_exporter": "python",
                  "pygments_lexer": "ipython3",
                  "version": "3.8.5"
                }
              },
              "nbformat": 4,
              "nbformat_minor": 4
            }
        \"\"\")
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            notebook_execution_job_id="colab-notebook-execution",
            display_name="Notebook execution full",
            location="us-central1",
            execution_timeout="86400s",
            gcs_notebook_source={
                "uri": pulumi.Output.all(
                    bucket=notebook.bucket,
                    name=notebook.name
        ).apply(lambda resolved_outputs: f"gs://{resolved_outputs['bucket']}/{resolved_outputs['name']}")
        ,
                "generation": notebook.generation,
            },
            service_account="my@service-account.com",
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            opts = pulumi.ResourceOptions(depends_on=[
                    notebook,
                    output_bucket,
                    my_runtime_template,
                ]))
        ```
        ### Colab Notebook Execution Dataform

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_runtime_template = gcp.colab.RuntimeTemplate("my_runtime_template",
            name="runtime-template-name",
            display_name="Runtime template",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        output_bucket = gcp.storage.Bucket("output_bucket",
            name="my_bucket",
            location="US",
            force_destroy=True,
            uniform_bucket_level_access=True)
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication={
                "auto": {},
            })
        secret_version = gcp.secretmanager.SecretVersion("secret_version",
            secret=secret.id,
            secret_data="secret-data")
        dataform_repository = gcp.dataform.Repository("dataform_repository",
            name="dataform-repository",
            display_name="dataform_repository",
            npmrc_environment_variables_secret_version=secret_version.id,
            kms_key_name="my-crypto-key",
            labels={
                "label_foo1": "label-bar1",
            },
            git_remote_settings={
                "url": "https://github.com/OWNER/REPOSITORY.git",
                "default_branch": "main",
                "authentication_token_secret_version": secret_version.id,
            },
            workspace_compilation_overrides={
                "default_database": "database",
                "schema_suffix": "_suffix",
                "table_prefix": "prefix_",
            })
        notebook_execution = gcp.colab.NotebookExecution("notebook-execution",
            display_name="Notebook execution Dataform",
            location="us-central1",
            dataform_repository_source={
                "commit_sha": "randomsha123",
                "dataform_repository_resource_name": pulumi.Output.all(
                    project=my_runtime_template.project,
                    location=my_runtime_template.location,
                    name=dataform_repository.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/repositories/{resolved_outputs['name']}")
        ,
            },
            notebook_runtime_template_resource_name=pulumi.Output.all(
                project=my_runtime_template.project,
                location=my_runtime_template.location,
                name=my_runtime_template.name
        ).apply(lambda resolved_outputs: f"projects/{resolved_outputs['project']}/locations/{resolved_outputs['location']}/notebookRuntimeTemplates/{resolved_outputs['name']}")
        ,
            gcs_output_uri=output_bucket.name.apply(lambda name: f"gs://{name}"),
            service_account="my@service-account.com",
            opts = pulumi.ResourceOptions(depends_on=[
                    my_runtime_template,
                    output_bucket,
                    secret_version,
                    dataform_repository,
                    secret,
                ]))
        ```

        ## Import

        NotebookExecution can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookExecutionJobs/{{notebook_execution_job_id}}`

        * `{{project}}/{{location}}/{{notebook_execution_job_id}}`

        * `{{location}}/{{notebook_execution_job_id}}`

        When using the `pulumi import` command, NotebookExecution can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default projects/{{project}}/locations/{{location}}/notebookExecutionJobs/{{notebook_execution_job_id}}
        ```

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default {{project}}/{{location}}/{{notebook_execution_job_id}}
        ```

        ```sh
        $ pulumi import gcp:colab/notebookExecution:NotebookExecution default {{location}}/{{notebook_execution_job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param NotebookExecutionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotebookExecutionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataform_repository_source: Optional[pulumi.Input[Union['NotebookExecutionDataformRepositorySourceArgs', 'NotebookExecutionDataformRepositorySourceArgsDict']]] = None,
                 direct_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionDirectNotebookSourceArgs', 'NotebookExecutionDirectNotebookSourceArgsDict']]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_timeout: Optional[pulumi.Input[builtins.str]] = None,
                 execution_user: Optional[pulumi.Input[builtins.str]] = None,
                 gcs_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionGcsNotebookSourceArgs', 'NotebookExecutionGcsNotebookSourceArgsDict']]] = None,
                 gcs_output_uri: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_execution_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_resource_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotebookExecutionArgs.__new__(NotebookExecutionArgs)

            __props__.__dict__["dataform_repository_source"] = dataform_repository_source
            __props__.__dict__["direct_notebook_source"] = direct_notebook_source
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["execution_timeout"] = execution_timeout
            __props__.__dict__["execution_user"] = execution_user
            __props__.__dict__["gcs_notebook_source"] = gcs_notebook_source
            if gcs_output_uri is None and not opts.urn:
                raise TypeError("Missing required property 'gcs_output_uri'")
            __props__.__dict__["gcs_output_uri"] = gcs_output_uri
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["notebook_execution_job_id"] = notebook_execution_job_id
            __props__.__dict__["notebook_runtime_template_resource_name"] = notebook_runtime_template_resource_name
            __props__.__dict__["project"] = project
            __props__.__dict__["service_account"] = service_account
        super(NotebookExecution, __self__).__init__(
            'gcp:colab/notebookExecution:NotebookExecution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataform_repository_source: Optional[pulumi.Input[Union['NotebookExecutionDataformRepositorySourceArgs', 'NotebookExecutionDataformRepositorySourceArgsDict']]] = None,
            direct_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionDirectNotebookSourceArgs', 'NotebookExecutionDirectNotebookSourceArgsDict']]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            execution_timeout: Optional[pulumi.Input[builtins.str]] = None,
            execution_user: Optional[pulumi.Input[builtins.str]] = None,
            gcs_notebook_source: Optional[pulumi.Input[Union['NotebookExecutionGcsNotebookSourceArgs', 'NotebookExecutionGcsNotebookSourceArgsDict']]] = None,
            gcs_output_uri: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            notebook_execution_job_id: Optional[pulumi.Input[builtins.str]] = None,
            notebook_runtime_template_resource_name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None) -> 'NotebookExecution':
        """
        Get an existing NotebookExecution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NotebookExecutionDataformRepositorySourceArgs', 'NotebookExecutionDataformRepositorySourceArgsDict']] dataform_repository_source: The Dataform Repository containing the input notebook.
               Structure is documented below.
        :param pulumi.Input[Union['NotebookExecutionDirectNotebookSourceArgs', 'NotebookExecutionDirectNotebookSourceArgsDict']] direct_notebook_source: The content of the input notebook in ipynb format.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Notebook Execution.
        :param pulumi.Input[builtins.str] execution_timeout: Max running time of the execution job in seconds (default 86400s / 24 hrs).
        :param pulumi.Input[builtins.str] execution_user: The user email to run the execution as.
        :param pulumi.Input[Union['NotebookExecutionGcsNotebookSourceArgs', 'NotebookExecutionGcsNotebookSourceArgsDict']] gcs_notebook_source: The Cloud Storage uri for the input notebook.
               Structure is documented below.
        :param pulumi.Input[builtins.str] gcs_output_uri: The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] notebook_execution_job_id: User specified ID for the Notebook Execution Job
        :param pulumi.Input[builtins.str] notebook_runtime_template_resource_name: The NotebookRuntimeTemplate to source compute configuration from.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] service_account: The service account to run the execution as.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotebookExecutionState.__new__(_NotebookExecutionState)

        __props__.__dict__["dataform_repository_source"] = dataform_repository_source
        __props__.__dict__["direct_notebook_source"] = direct_notebook_source
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["execution_timeout"] = execution_timeout
        __props__.__dict__["execution_user"] = execution_user
        __props__.__dict__["gcs_notebook_source"] = gcs_notebook_source
        __props__.__dict__["gcs_output_uri"] = gcs_output_uri
        __props__.__dict__["location"] = location
        __props__.__dict__["notebook_execution_job_id"] = notebook_execution_job_id
        __props__.__dict__["notebook_runtime_template_resource_name"] = notebook_runtime_template_resource_name
        __props__.__dict__["project"] = project
        __props__.__dict__["service_account"] = service_account
        return NotebookExecution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataformRepositorySource")
    def dataform_repository_source(self) -> pulumi.Output[Optional['outputs.NotebookExecutionDataformRepositorySource']]:
        """
        The Dataform Repository containing the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "dataform_repository_source")

    @property
    @pulumi.getter(name="directNotebookSource")
    def direct_notebook_source(self) -> pulumi.Output[Optional['outputs.NotebookExecutionDirectNotebookSource']]:
        """
        The content of the input notebook in ipynb format.
        Structure is documented below.
        """
        return pulumi.get(self, "direct_notebook_source")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Required. The display name of the Notebook Execution.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Max running time of the execution job in seconds (default 86400s / 24 hrs).
        """
        return pulumi.get(self, "execution_timeout")

    @property
    @pulumi.getter(name="executionUser")
    def execution_user(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The user email to run the execution as.
        """
        return pulumi.get(self, "execution_user")

    @property
    @pulumi.getter(name="gcsNotebookSource")
    def gcs_notebook_source(self) -> pulumi.Output[Optional['outputs.NotebookExecutionGcsNotebookSource']]:
        """
        The Cloud Storage uri for the input notebook.
        Structure is documented below.
        """
        return pulumi.get(self, "gcs_notebook_source")

    @property
    @pulumi.getter(name="gcsOutputUri")
    def gcs_output_uri(self) -> pulumi.Output[builtins.str]:
        """
        The Cloud Storage location to upload the result to. Format:`gs://bucket-name`
        """
        return pulumi.get(self, "gcs_output_uri")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="notebookExecutionJobId")
    def notebook_execution_job_id(self) -> pulumi.Output[builtins.str]:
        """
        User specified ID for the Notebook Execution Job
        """
        return pulumi.get(self, "notebook_execution_job_id")

    @property
    @pulumi.getter(name="notebookRuntimeTemplateResourceName")
    def notebook_runtime_template_resource_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The NotebookRuntimeTemplate to source compute configuration from.
        """
        return pulumi.get(self, "notebook_runtime_template_resource_name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The service account to run the execution as.
        """
        return pulumi.get(self, "service_account")

