# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuntimeArgs', 'Runtime']

@pulumi.input_type
class RuntimeArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[builtins.str],
                 location: pulumi.Input[builtins.str],
                 runtime_user: pulumi.Input[builtins.str],
                 auto_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_ref: Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Runtime resource.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] runtime_user: The user email of the NotebookRuntime.
        :param pulumi.Input[builtins.bool] auto_upgrade: Triggers an upgrade anytime the runtime is started if it is upgradable.
        :param pulumi.Input[builtins.str] description: The description of the Runtime.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime
        :param pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs'] notebook_runtime_template_ref: 'Runtime specific information used for NotebookRuntime creation.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "runtime_user", runtime_user)
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebook_runtime_template_ref is not None:
            pulumi.set(__self__, "notebook_runtime_template_ref", notebook_runtime_template_ref)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Required. The display name of the Runtime.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="runtimeUser")
    def runtime_user(self) -> pulumi.Input[builtins.str]:
        """
        The user email of the NotebookRuntime.
        """
        return pulumi.get(self, "runtime_user")

    @runtime_user.setter
    def runtime_user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "runtime_user", value)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Triggers an upgrade anytime the runtime is started if it is upgradable.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Runtime.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Runtime
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notebookRuntimeTemplateRef")
    def notebook_runtime_template_ref(self) -> Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']]:
        """
        'Runtime specific information used for NotebookRuntime creation.'
        Structure is documented below.
        """
        return pulumi.get(self, "notebook_runtime_template_ref")

    @notebook_runtime_template_ref.setter
    def notebook_runtime_template_ref(self, value: Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']]):
        pulumi.set(self, "notebook_runtime_template_ref", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _RuntimeState:
    def __init__(__self__, *,
                 auto_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[builtins.str]] = None,
                 is_upgradable: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_ref: Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']] = None,
                 notebook_runtime_type: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_user: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Runtime resources.
        :param pulumi.Input[builtins.bool] auto_upgrade: Triggers an upgrade anytime the runtime is started if it is upgradable.
        :param pulumi.Input[builtins.str] description: The description of the Runtime.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime.
        :param pulumi.Input[builtins.str] expiration_time: Output only. Timestamp when this NotebookRuntime will be expired.
        :param pulumi.Input[builtins.bool] is_upgradable: Output only. Checks if the NotebookRuntime is upgradable.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime
        :param pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs'] notebook_runtime_template_ref: 'Runtime specific information used for NotebookRuntime creation.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] notebook_runtime_type: Output only. The type of the notebook runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] runtime_user: The user email of the NotebookRuntime.
        :param pulumi.Input[builtins.str] state: Output only. The state of the runtime.
        """
        if auto_upgrade is not None:
            pulumi.set(__self__, "auto_upgrade", auto_upgrade)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_state is not None:
            pulumi.set(__self__, "desired_state", desired_state)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if is_upgradable is not None:
            pulumi.set(__self__, "is_upgradable", is_upgradable)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebook_runtime_template_ref is not None:
            pulumi.set(__self__, "notebook_runtime_template_ref", notebook_runtime_template_ref)
        if notebook_runtime_type is not None:
            pulumi.set(__self__, "notebook_runtime_type", notebook_runtime_type)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if runtime_user is not None:
            pulumi.set(__self__, "runtime_user", runtime_user)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Triggers an upgrade anytime the runtime is started if it is upgradable.
        """
        return pulumi.get(self, "auto_upgrade")

    @auto_upgrade.setter
    def auto_upgrade(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_upgrade", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The description of the Runtime.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        """
        return pulumi.get(self, "desired_state")

    @desired_state.setter
    def desired_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_state", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Required. The display name of the Runtime.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. Timestamp when this NotebookRuntime will be expired.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="isUpgradable")
    def is_upgradable(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. Checks if the NotebookRuntime is upgradable.
        """
        return pulumi.get(self, "is_upgradable")

    @is_upgradable.setter
    def is_upgradable(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_upgradable", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the Runtime
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notebookRuntimeTemplateRef")
    def notebook_runtime_template_ref(self) -> Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']]:
        """
        'Runtime specific information used for NotebookRuntime creation.'
        Structure is documented below.
        """
        return pulumi.get(self, "notebook_runtime_template_ref")

    @notebook_runtime_template_ref.setter
    def notebook_runtime_template_ref(self, value: Optional[pulumi.Input['RuntimeNotebookRuntimeTemplateRefArgs']]):
        pulumi.set(self, "notebook_runtime_template_ref", value)

    @property
    @pulumi.getter(name="notebookRuntimeType")
    def notebook_runtime_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The type of the notebook runtime.
        """
        return pulumi.get(self, "notebook_runtime_type")

    @notebook_runtime_type.setter
    def notebook_runtime_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notebook_runtime_type", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="runtimeUser")
    def runtime_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user email of the NotebookRuntime.
        """
        return pulumi.get(self, "runtime_user")

    @runtime_user.setter
    def runtime_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "runtime_user", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The state of the runtime.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:colab/runtime:Runtime")
class Runtime(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_ref: Optional[pulumi.Input[Union['RuntimeNotebookRuntimeTemplateRefArgs', 'RuntimeNotebookRuntimeTemplateRefArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        'A runtime is a Google-provisioned virtual machine (VM) that can run the code in your notebook (IPYNB file).'

        To get more information about Runtime, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookRuntimes)
        * How-to Guides
            * [Create a runtime](https://cloud.google.com/colab/docs/create-runtime)

        ## Example Usage

        ### Colab Runtime Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            display_name="Runtime basic",
            runtime_user="gterraformtestuser@gmail.com",
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```
        ### Colab Runtime Stopped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            desired_state="STOPPED",
            display_name="Runtime stopped",
            runtime_user="gterraformtestuser@gmail.com",
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```
        ### Colab Runtime Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template full",
            location="us-central1",
            description="Full runtime template",
            machine_spec={
                "machine_type": "n1-standard-2",
                "accelerator_type": "NVIDIA_TESLA_T4",
                "accelerator_count": 1,
            },
            data_persistent_disk_spec={
                "disk_type": "pd-standard",
                "disk_size_gb": "200",
            },
            network_spec={
                "enable_internet_access": True,
            },
            labels={
                "k": "val",
            },
            idle_shutdown_config={
                "idle_timeout": "3600s",
            },
            euc_config={
                "euc_disabled": True,
            },
            shielded_vm_config={
                "enable_secure_boot": True,
            },
            network_tags=[
                "abc",
                "def",
            ],
            encryption_spec={
                "kms_key_name": "my-crypto-key",
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            display_name="Runtime full",
            runtime_user="gterraformtestuser@gmail.com",
            description="Full runtime",
            desired_state="ACTIVE",
            auto_upgrade=True,
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```

        ## Import

        Runtime can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookRuntimes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Runtime can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default projects/{{project}}/locations/{{location}}/notebookRuntimes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_upgrade: Triggers an upgrade anytime the runtime is started if it is upgradable.
        :param pulumi.Input[builtins.str] description: The description of the Runtime.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime
        :param pulumi.Input[Union['RuntimeNotebookRuntimeTemplateRefArgs', 'RuntimeNotebookRuntimeTemplateRefArgsDict']] notebook_runtime_template_ref: 'Runtime specific information used for NotebookRuntime creation.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] runtime_user: The user email of the NotebookRuntime.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuntimeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        'A runtime is a Google-provisioned virtual machine (VM) that can run the code in your notebook (IPYNB file).'

        To get more information about Runtime, see:

        * [API documentation](https://cloud.google.com/vertex-ai/docs/reference/rest/v1/projects.locations.notebookRuntimes)
        * How-to Guides
            * [Create a runtime](https://cloud.google.com/colab/docs/create-runtime)

        ## Example Usage

        ### Colab Runtime Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            display_name="Runtime basic",
            runtime_user="gterraformtestuser@gmail.com",
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```
        ### Colab Runtime Stopped

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template basic",
            location="us-central1",
            machine_spec={
                "machine_type": "e2-standard-4",
            },
            network_spec={
                "enable_internet_access": True,
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            desired_state="STOPPED",
            display_name="Runtime stopped",
            runtime_user="gterraformtestuser@gmail.com",
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```
        ### Colab Runtime Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        my_template = gcp.colab.RuntimeTemplate("my_template",
            name="colab-runtime",
            display_name="Runtime template full",
            location="us-central1",
            description="Full runtime template",
            machine_spec={
                "machine_type": "n1-standard-2",
                "accelerator_type": "NVIDIA_TESLA_T4",
                "accelerator_count": 1,
            },
            data_persistent_disk_spec={
                "disk_type": "pd-standard",
                "disk_size_gb": "200",
            },
            network_spec={
                "enable_internet_access": True,
            },
            labels={
                "k": "val",
            },
            idle_shutdown_config={
                "idle_timeout": "3600s",
            },
            euc_config={
                "euc_disabled": True,
            },
            shielded_vm_config={
                "enable_secure_boot": True,
            },
            network_tags=[
                "abc",
                "def",
            ],
            encryption_spec={
                "kms_key_name": "my-crypto-key",
            })
        runtime = gcp.colab.Runtime("runtime",
            name="colab-runtime",
            location="us-central1",
            notebook_runtime_template_ref={
                "notebook_runtime_template": my_template.id,
            },
            display_name="Runtime full",
            runtime_user="gterraformtestuser@gmail.com",
            description="Full runtime",
            desired_state="ACTIVE",
            auto_upgrade=True,
            opts = pulumi.ResourceOptions(depends_on=[my_template]))
        ```

        ## Import

        Runtime can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/notebookRuntimes/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Runtime can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default projects/{{project}}/locations/{{location}}/notebookRuntimes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:colab/runtime:Runtime default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RuntimeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuntimeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_state: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notebook_runtime_template_ref: Optional[pulumi.Input[Union['RuntimeNotebookRuntimeTemplateRefArgs', 'RuntimeNotebookRuntimeTemplateRefArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 runtime_user: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuntimeArgs.__new__(RuntimeArgs)

            __props__.__dict__["auto_upgrade"] = auto_upgrade
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_state"] = desired_state
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["notebook_runtime_template_ref"] = notebook_runtime_template_ref
            __props__.__dict__["project"] = project
            if runtime_user is None and not opts.urn:
                raise TypeError("Missing required property 'runtime_user'")
            __props__.__dict__["runtime_user"] = runtime_user
            __props__.__dict__["expiration_time"] = None
            __props__.__dict__["is_upgradable"] = None
            __props__.__dict__["notebook_runtime_type"] = None
            __props__.__dict__["state"] = None
        super(Runtime, __self__).__init__(
            'gcp:colab/runtime:Runtime',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_upgrade: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            desired_state: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            expiration_time: Optional[pulumi.Input[builtins.str]] = None,
            is_upgradable: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notebook_runtime_template_ref: Optional[pulumi.Input[Union['RuntimeNotebookRuntimeTemplateRefArgs', 'RuntimeNotebookRuntimeTemplateRefArgsDict']]] = None,
            notebook_runtime_type: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            runtime_user: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'Runtime':
        """
        Get an existing Runtime resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] auto_upgrade: Triggers an upgrade anytime the runtime is started if it is upgradable.
        :param pulumi.Input[builtins.str] description: The description of the Runtime.
        :param pulumi.Input[builtins.str] desired_state: Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        :param pulumi.Input[builtins.str] display_name: Required. The display name of the Runtime.
        :param pulumi.Input[builtins.str] expiration_time: Output only. Timestamp when this NotebookRuntime will be expired.
        :param pulumi.Input[builtins.bool] is_upgradable: Output only. Checks if the NotebookRuntime is upgradable.
        :param pulumi.Input[builtins.str] location: The location for the resource: https://cloud.google.com/colab/docs/locations
        :param pulumi.Input[builtins.str] name: The resource name of the Runtime
        :param pulumi.Input[Union['RuntimeNotebookRuntimeTemplateRefArgs', 'RuntimeNotebookRuntimeTemplateRefArgsDict']] notebook_runtime_template_ref: 'Runtime specific information used for NotebookRuntime creation.'
               Structure is documented below.
        :param pulumi.Input[builtins.str] notebook_runtime_type: Output only. The type of the notebook runtime.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] runtime_user: The user email of the NotebookRuntime.
        :param pulumi.Input[builtins.str] state: Output only. The state of the runtime.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuntimeState.__new__(_RuntimeState)

        __props__.__dict__["auto_upgrade"] = auto_upgrade
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_state"] = desired_state
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["is_upgradable"] = is_upgradable
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notebook_runtime_template_ref"] = notebook_runtime_template_ref
        __props__.__dict__["notebook_runtime_type"] = notebook_runtime_type
        __props__.__dict__["project"] = project
        __props__.__dict__["runtime_user"] = runtime_user
        __props__.__dict__["state"] = state
        return Runtime(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoUpgrade")
    def auto_upgrade(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Triggers an upgrade anytime the runtime is started if it is upgradable.
        """
        return pulumi.get(self, "auto_upgrade")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The description of the Runtime.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredState")
    def desired_state(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Desired state of the Colab Runtime. Set this field to `RUNNING` to start the runtime, and `STOPPED` to stop it.
        """
        return pulumi.get(self, "desired_state")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Required. The display name of the Runtime.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. Timestamp when this NotebookRuntime will be expired.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="isUpgradable")
    def is_upgradable(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. Checks if the NotebookRuntime is upgradable.
        """
        return pulumi.get(self, "is_upgradable")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource: https://cloud.google.com/colab/docs/locations
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the Runtime
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notebookRuntimeTemplateRef")
    def notebook_runtime_template_ref(self) -> pulumi.Output[Optional['outputs.RuntimeNotebookRuntimeTemplateRef']]:
        """
        'Runtime specific information used for NotebookRuntime creation.'
        Structure is documented below.
        """
        return pulumi.get(self, "notebook_runtime_template_ref")

    @property
    @pulumi.getter(name="notebookRuntimeType")
    def notebook_runtime_type(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The type of the notebook runtime.
        """
        return pulumi.get(self, "notebook_runtime_type")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="runtimeUser")
    def runtime_user(self) -> pulumi.Output[builtins.str]:
        """
        The user email of the NotebookRuntime.
        """
        return pulumi.get(self, "runtime_user")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The state of the runtime.
        """
        return pulumi.get(self, "state")

