# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallArgs', 'Firewall']

@pulumi.input_type
class FirewallArgs:
    def __init__(__self__, *,
                 network: pulumi.Input[builtins.str],
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 log_config: Optional[pulumi.Input['FirewallLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input['FirewallParamsArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Firewall resource.
        :param pulumi.Input[builtins.str] network: The name or self_link of the network to attach this firewall to.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]] allows: The list of ALLOW rules specified by this firewall. Each rule
               specifies a protocol and port-range tuple that describes a permitted
               connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]] denies: The list of DENY rules specified by this firewall. Each rule specifies
               a protocol and port-range tuple that describes a denied connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_ranges: If destination ranges are specified, the firewall will apply only to
               traffic that has destination IP address in these ranges. These ranges
               must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        :param pulumi.Input[builtins.str] direction: Direction of traffic to which this firewall applies; default is
               INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
               `source_tags` or `source_service_accounts` is required.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall rule is disabled, i.e not applied to the
               network it is associated with. When set to true, the firewall rule is
               not enforced and the network behaves as if it did not exist. If this
               is unspecified, the firewall rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: This field denotes whether to enable logging for a particular firewall rule.
               If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        :param pulumi.Input['FirewallLogConfigArgs'] log_config: This field denotes the logging options for a particular firewall rule.
               If defined, logging is enabled, and logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input['FirewallParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: Priority for this rule. This is an integer between 0 and 65535, both
               inclusive. When not specified, the value assumed is 1000. Relative
               priorities determine precedence of conflicting rules. Lower value of
               priority implies higher precedence (eg, a rule with priority 0 has
               higher precedence than a rule with priority 1). DENY rules take
               precedence over ALLOW rules having equal priority.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ranges: If source ranges are specified, the firewall will apply only to
               traffic that has source IP address in these ranges. These ranges must
               be expressed in CIDR format. One or both of sourceRanges and
               sourceTags may be set. If both properties are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP that belongs to a tag listed in the sourceTags property. The
               connection does not need to match both properties for the firewall to
               apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
               `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_service_accounts: If source service accounts are specified, the firewall will apply only
               to traffic originating from an instance with a service account in this
               list. Source service accounts cannot be used to control traffic to an
               instance's external IP address because service accounts are associated
               with an instance, not an IP address. sourceRanges can be set at the
               same time as sourceServiceAccounts. If both are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP belongs to an instance with service account listed in
               sourceServiceAccount. The connection does not need to match both
               properties for the firewall to apply. sourceServiceAccounts cannot be
               used at the same time as sourceTags or targetTags. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_tags: If source tags are specified, the firewall will apply only to traffic
               with source IP that belongs to a tag listed in source tags. Source
               tags cannot be used to control traffic to an instance's external IP
               address. Because tags are associated with an instance, not an IP
               address. One or both of sourceRanges and sourceTags may be set. If
               both properties are set, the firewall will apply to traffic that has
               source IP address within sourceRanges OR the source IP that belongs to
               a tag listed in the sourceTags property. The connection does not need
               to match both properties for the firewall to apply. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               targetServiceAccounts cannot be used at the same time as targetTags or
               sourceTags. If neither targetServiceAccounts nor targetTags are
               specified, the firewall rule applies to all instances on the specified
               network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_tags: A list of instance tags indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               If no targetTags are specified, the firewall rule applies to all
               instances on the specified network.
        """
        pulumi.set(__self__, "network", network)
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ranges is not None:
            pulumi.set(__self__, "destination_ranges", destination_ranges)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_logging is not None:
            warnings.warn("""Deprecated in favor of log_config""", DeprecationWarning)
            pulumi.log.warn("""enable_logging is deprecated: Deprecated in favor of log_config""")
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)
        if source_service_accounts is not None:
            pulumi.set(__self__, "source_service_accounts", source_service_accounts)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The name or self_link of the network to attach this firewall to.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]]:
        """
        The list of ALLOW rules specified by this firewall. Each rule
        specifies a protocol and port-range tuple that describes a permitted
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]]:
        """
        The list of DENY rules specified by this firewall. Each rule specifies
        a protocol and port-range tuple that describes a denied connection.
        Structure is documented below.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationRanges")
    def destination_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If destination ranges are specified, the firewall will apply only to
        traffic that has destination IP address in these ranges. These ranges
        must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        """
        return pulumi.get(self, "destination_ranges")

    @destination_ranges.setter
    def destination_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_ranges", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Direction of traffic to which this firewall applies; default is
        INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
        `source_tags` or `source_service_accounts` is required.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall rule is disabled, i.e not applied to the
        network it is associated with. When set to true, the firewall rule is
        not enforced and the network behaves as if it did not exist. If this
        is unspecified, the firewall rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableLogging")
    @_utilities.deprecated("""Deprecated in favor of log_config""")
    def enable_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field denotes whether to enable logging for a particular firewall rule.
        If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['FirewallLogConfigArgs']]:
        """
        This field denotes the logging options for a particular firewall rule.
        If defined, logging is enabled, and logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['FirewallLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['FirewallParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['FirewallParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Priority for this rule. This is an integer between 0 and 65535, both
        inclusive. When not specified, the value assumed is 1000. Relative
        priorities determine precedence of conflicting rules. Lower value of
        priority implies higher precedence (eg, a rule with priority 0 has
        higher precedence than a rule with priority 1). DENY rules take
        precedence over ALLOW rules having equal priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source ranges are specified, the firewall will apply only to
        traffic that has source IP address in these ranges. These ranges must
        be expressed in CIDR format. One or both of sourceRanges and
        sourceTags may be set. If both properties are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP that belongs to a tag listed in the sourceTags property. The
        connection does not need to match both properties for the firewall to
        apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
        `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_ranges", value)

    @property
    @pulumi.getter(name="sourceServiceAccounts")
    def source_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source service accounts are specified, the firewall will apply only
        to traffic originating from an instance with a service account in this
        list. Source service accounts cannot be used to control traffic to an
        instance's external IP address because service accounts are associated
        with an instance, not an IP address. sourceRanges can be set at the
        same time as sourceServiceAccounts. If both are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP belongs to an instance with service account listed in
        sourceServiceAccount. The connection does not need to match both
        properties for the firewall to apply. sourceServiceAccounts cannot be
        used at the same time as sourceTags or targetTags. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_service_accounts")

    @source_service_accounts.setter
    def source_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_service_accounts", value)

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source tags are specified, the firewall will apply only to traffic
        with source IP that belongs to a tag listed in source tags. Source
        tags cannot be used to control traffic to an instance's external IP
        address. Because tags are associated with an instance, not an IP
        address. One or both of sourceRanges and sourceTags may be set. If
        both properties are set, the firewall will apply to traffic that has
        source IP address within sourceRanges OR the source IP that belongs to
        a tag listed in the sourceTags property. The connection does not need
        to match both properties for the firewall to apply. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_tags")

    @source_tags.setter
    def source_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_tags", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of service accounts indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        targetServiceAccounts cannot be used at the same time as targetTags or
        sourceTags. If neither targetServiceAccounts nor targetTags are
        specified, the firewall rule applies to all instances on the specified
        network.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_service_accounts", value)

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance tags indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        If no targetTags are specified, the firewall rule applies to all
        instances on the specified network.
        """
        return pulumi.get(self, "target_tags")

    @target_tags.setter
    def target_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_tags", value)


@pulumi.input_type
class _FirewallState:
    def __init__(__self__, *,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 log_config: Optional[pulumi.Input['FirewallLogConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input['FirewallParamsArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Firewall resources.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]] allows: The list of ALLOW rules specified by this firewall. Each rule
               specifies a protocol and port-range tuple that describes a permitted
               connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]] denies: The list of DENY rules specified by this firewall. Each rule specifies
               a protocol and port-range tuple that describes a denied connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_ranges: If destination ranges are specified, the firewall will apply only to
               traffic that has destination IP address in these ranges. These ranges
               must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        :param pulumi.Input[builtins.str] direction: Direction of traffic to which this firewall applies; default is
               INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
               `source_tags` or `source_service_accounts` is required.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall rule is disabled, i.e not applied to the
               network it is associated with. When set to true, the firewall rule is
               not enforced and the network behaves as if it did not exist. If this
               is unspecified, the firewall rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: This field denotes whether to enable logging for a particular firewall rule.
               If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        :param pulumi.Input['FirewallLogConfigArgs'] log_config: This field denotes the logging options for a particular firewall rule.
               If defined, logging is enabled, and logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The name or self_link of the network to attach this firewall to.
        :param pulumi.Input['FirewallParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: Priority for this rule. This is an integer between 0 and 65535, both
               inclusive. When not specified, the value assumed is 1000. Relative
               priorities determine precedence of conflicting rules. Lower value of
               priority implies higher precedence (eg, a rule with priority 0 has
               higher precedence than a rule with priority 1). DENY rules take
               precedence over ALLOW rules having equal priority.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ranges: If source ranges are specified, the firewall will apply only to
               traffic that has source IP address in these ranges. These ranges must
               be expressed in CIDR format. One or both of sourceRanges and
               sourceTags may be set. If both properties are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP that belongs to a tag listed in the sourceTags property. The
               connection does not need to match both properties for the firewall to
               apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
               `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_service_accounts: If source service accounts are specified, the firewall will apply only
               to traffic originating from an instance with a service account in this
               list. Source service accounts cannot be used to control traffic to an
               instance's external IP address because service accounts are associated
               with an instance, not an IP address. sourceRanges can be set at the
               same time as sourceServiceAccounts. If both are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP belongs to an instance with service account listed in
               sourceServiceAccount. The connection does not need to match both
               properties for the firewall to apply. sourceServiceAccounts cannot be
               used at the same time as sourceTags or targetTags. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_tags: If source tags are specified, the firewall will apply only to traffic
               with source IP that belongs to a tag listed in source tags. Source
               tags cannot be used to control traffic to an instance's external IP
               address. Because tags are associated with an instance, not an IP
               address. One or both of sourceRanges and sourceTags may be set. If
               both properties are set, the firewall will apply to traffic that has
               source IP address within sourceRanges OR the source IP that belongs to
               a tag listed in the sourceTags property. The connection does not need
               to match both properties for the firewall to apply. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               targetServiceAccounts cannot be used at the same time as targetTags or
               sourceTags. If neither targetServiceAccounts nor targetTags are
               specified, the firewall rule applies to all instances on the specified
               network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_tags: A list of instance tags indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               If no targetTags are specified, the firewall rule applies to all
               instances on the specified network.
        """
        if allows is not None:
            pulumi.set(__self__, "allows", allows)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if denies is not None:
            pulumi.set(__self__, "denies", denies)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ranges is not None:
            pulumi.set(__self__, "destination_ranges", destination_ranges)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_logging is not None:
            warnings.warn("""Deprecated in favor of log_config""", DeprecationWarning)
            pulumi.log.warn("""enable_logging is deprecated: Deprecated in favor of log_config""")
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if source_ranges is not None:
            pulumi.set(__self__, "source_ranges", source_ranges)
        if source_service_accounts is not None:
            pulumi.set(__self__, "source_service_accounts", source_service_accounts)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        if target_tags is not None:
            pulumi.set(__self__, "target_tags", target_tags)

    @property
    @pulumi.getter
    def allows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]]:
        """
        The list of ALLOW rules specified by this firewall. Each rule
        specifies a protocol and port-range tuple that describes a permitted
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "allows")

    @allows.setter
    def allows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallAllowArgs']]]]):
        pulumi.set(self, "allows", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def denies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]]:
        """
        The list of DENY rules specified by this firewall. Each rule specifies
        a protocol and port-range tuple that describes a denied connection.
        Structure is documented below.
        """
        return pulumi.get(self, "denies")

    @denies.setter
    def denies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallDenyArgs']]]]):
        pulumi.set(self, "denies", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destinationRanges")
    def destination_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If destination ranges are specified, the firewall will apply only to
        traffic that has destination IP address in these ranges. These ranges
        must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        """
        return pulumi.get(self, "destination_ranges")

    @destination_ranges.setter
    def destination_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destination_ranges", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Direction of traffic to which this firewall applies; default is
        INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
        `source_tags` or `source_service_accounts` is required.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall rule is disabled, i.e not applied to the
        network it is associated with. When set to true, the firewall rule is
        not enforced and the network behaves as if it did not exist. If this
        is unspecified, the firewall rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableLogging")
    @_utilities.deprecated("""Deprecated in favor of log_config""")
    def enable_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This field denotes whether to enable logging for a particular firewall rule.
        If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['FirewallLogConfigArgs']]:
        """
        This field denotes the logging options for a particular firewall rule.
        If defined, logging is enabled, and logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['FirewallLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name or self_link of the network to attach this firewall to.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['FirewallParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['FirewallParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Priority for this rule. This is an integer between 0 and 65535, both
        inclusive. When not specified, the value assumed is 1000. Relative
        priorities determine precedence of conflicting rules. Lower value of
        priority implies higher precedence (eg, a rule with priority 0 has
        higher precedence than a rule with priority 1). DENY rules take
        precedence over ALLOW rules having equal priority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source ranges are specified, the firewall will apply only to
        traffic that has source IP address in these ranges. These ranges must
        be expressed in CIDR format. One or both of sourceRanges and
        sourceTags may be set. If both properties are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP that belongs to a tag listed in the sourceTags property. The
        connection does not need to match both properties for the firewall to
        apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
        `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_ranges")

    @source_ranges.setter
    def source_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_ranges", value)

    @property
    @pulumi.getter(name="sourceServiceAccounts")
    def source_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source service accounts are specified, the firewall will apply only
        to traffic originating from an instance with a service account in this
        list. Source service accounts cannot be used to control traffic to an
        instance's external IP address because service accounts are associated
        with an instance, not an IP address. sourceRanges can be set at the
        same time as sourceServiceAccounts. If both are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP belongs to an instance with service account listed in
        sourceServiceAccount. The connection does not need to match both
        properties for the firewall to apply. sourceServiceAccounts cannot be
        used at the same time as sourceTags or targetTags. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_service_accounts")

    @source_service_accounts.setter
    def source_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_service_accounts", value)

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If source tags are specified, the firewall will apply only to traffic
        with source IP that belongs to a tag listed in source tags. Source
        tags cannot be used to control traffic to an instance's external IP
        address. Because tags are associated with an instance, not an IP
        address. One or both of sourceRanges and sourceTags may be set. If
        both properties are set, the firewall will apply to traffic that has
        source IP address within sourceRanges OR the source IP that belongs to
        a tag listed in the sourceTags property. The connection does not need
        to match both properties for the firewall to apply. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_tags")

    @source_tags.setter
    def source_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "source_tags", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of service accounts indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        targetServiceAccounts cannot be used at the same time as targetTags or
        sourceTags. If neither targetServiceAccounts nor targetTags are
        specified, the firewall rule applies to all instances on the specified
        network.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_service_accounts", value)

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance tags indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        If no targetTags are specified, the firewall rule applies to all
        instances on the specified network.
        """
        return pulumi.get(self, "target_tags")

    @target_tags.setter
    def target_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_tags", value)


@pulumi.type_token("gcp:compute/firewall:Firewall")
class Firewall(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAllowArgs', 'FirewallAllowArgsDict']]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallDenyArgs', 'FirewallDenyArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 log_config: Optional[pulumi.Input[Union['FirewallLogConfigArgs', 'FirewallLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['FirewallParamsArgs', 'FirewallParamsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Each network has its own firewall controlling access to and from the
        instances.

        All traffic to instances, even from other instances, is blocked by the
        firewall unless firewall rules are created to allow it.

        The default network has automatically created firewall rules that are
        shown in default firewall rules. No manually created network has
        automatically created firewall rules except for a default "allow" rule for
        outgoing traffic and a default "deny" for incoming traffic. For all
        networks except the default network, you must create any firewall rules
        you need.

        To get more information about Firewall, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/firewalls)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/firewalls)

        ## Example Usage

        ### Firewall Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="test-network")
        default = gcp.compute.Firewall("default",
            name="test-firewall",
            network=default_network.name,
            allows=[
                {
                    "protocol": "icmp",
                },
                {
                    "protocol": "tcp",
                    "ports": [
                        "80",
                        "8080",
                        "1000-2000",
                    ],
                },
            ],
            source_tags=["web"])
        ```
        ### Firewall With Target Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        rules = gcp.compute.Firewall("rules",
            project="my-project-name",
            name="my-firewall-rule",
            network="default",
            description="Creates firewall rule targeting tagged instances",
            allows=[{
                "protocol": "tcp",
                "ports": [
                    "80",
                    "8080",
                    "1000-2000",
                ],
            }],
            source_tags=["foo"],
            target_tags=["web"])
        ```

        ## Import

        Firewall can be imported using any of these accepted formats:

        * `projects/{{project}}/global/firewalls/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Firewall can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default projects/{{project}}/global/firewalls/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallAllowArgs', 'FirewallAllowArgsDict']]]] allows: The list of ALLOW rules specified by this firewall. Each rule
               specifies a protocol and port-range tuple that describes a permitted
               connection.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallDenyArgs', 'FirewallDenyArgsDict']]]] denies: The list of DENY rules specified by this firewall. Each rule specifies
               a protocol and port-range tuple that describes a denied connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_ranges: If destination ranges are specified, the firewall will apply only to
               traffic that has destination IP address in these ranges. These ranges
               must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        :param pulumi.Input[builtins.str] direction: Direction of traffic to which this firewall applies; default is
               INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
               `source_tags` or `source_service_accounts` is required.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall rule is disabled, i.e not applied to the
               network it is associated with. When set to true, the firewall rule is
               not enforced and the network behaves as if it did not exist. If this
               is unspecified, the firewall rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: This field denotes whether to enable logging for a particular firewall rule.
               If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        :param pulumi.Input[Union['FirewallLogConfigArgs', 'FirewallLogConfigArgsDict']] log_config: This field denotes the logging options for a particular firewall rule.
               If defined, logging is enabled, and logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The name or self_link of the network to attach this firewall to.
        :param pulumi.Input[Union['FirewallParamsArgs', 'FirewallParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: Priority for this rule. This is an integer between 0 and 65535, both
               inclusive. When not specified, the value assumed is 1000. Relative
               priorities determine precedence of conflicting rules. Lower value of
               priority implies higher precedence (eg, a rule with priority 0 has
               higher precedence than a rule with priority 1). DENY rules take
               precedence over ALLOW rules having equal priority.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ranges: If source ranges are specified, the firewall will apply only to
               traffic that has source IP address in these ranges. These ranges must
               be expressed in CIDR format. One or both of sourceRanges and
               sourceTags may be set. If both properties are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP that belongs to a tag listed in the sourceTags property. The
               connection does not need to match both properties for the firewall to
               apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
               `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_service_accounts: If source service accounts are specified, the firewall will apply only
               to traffic originating from an instance with a service account in this
               list. Source service accounts cannot be used to control traffic to an
               instance's external IP address because service accounts are associated
               with an instance, not an IP address. sourceRanges can be set at the
               same time as sourceServiceAccounts. If both are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP belongs to an instance with service account listed in
               sourceServiceAccount. The connection does not need to match both
               properties for the firewall to apply. sourceServiceAccounts cannot be
               used at the same time as sourceTags or targetTags. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_tags: If source tags are specified, the firewall will apply only to traffic
               with source IP that belongs to a tag listed in source tags. Source
               tags cannot be used to control traffic to an instance's external IP
               address. Because tags are associated with an instance, not an IP
               address. One or both of sourceRanges and sourceTags may be set. If
               both properties are set, the firewall will apply to traffic that has
               source IP address within sourceRanges OR the source IP that belongs to
               a tag listed in the sourceTags property. The connection does not need
               to match both properties for the firewall to apply. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               targetServiceAccounts cannot be used at the same time as targetTags or
               sourceTags. If neither targetServiceAccounts nor targetTags are
               specified, the firewall rule applies to all instances on the specified
               network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_tags: A list of instance tags indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               If no targetTags are specified, the firewall rule applies to all
               instances on the specified network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Each network has its own firewall controlling access to and from the
        instances.

        All traffic to instances, even from other instances, is blocked by the
        firewall unless firewall rules are created to allow it.

        The default network has automatically created firewall rules that are
        shown in default firewall rules. No manually created network has
        automatically created firewall rules except for a default "allow" rule for
        outgoing traffic and a default "deny" for incoming traffic. For all
        networks except the default network, you must create any firewall rules
        you need.

        To get more information about Firewall, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/firewalls)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/vpc/docs/firewalls)

        ## Example Usage

        ### Firewall Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="test-network")
        default = gcp.compute.Firewall("default",
            name="test-firewall",
            network=default_network.name,
            allows=[
                {
                    "protocol": "icmp",
                },
                {
                    "protocol": "tcp",
                    "ports": [
                        "80",
                        "8080",
                        "1000-2000",
                    ],
                },
            ],
            source_tags=["web"])
        ```
        ### Firewall With Target Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        rules = gcp.compute.Firewall("rules",
            project="my-project-name",
            name="my-firewall-rule",
            network="default",
            description="Creates firewall rule targeting tagged instances",
            allows=[{
                "protocol": "tcp",
                "ports": [
                    "80",
                    "8080",
                    "1000-2000",
                ],
            }],
            source_tags=["foo"],
            target_tags=["web"])
        ```

        ## Import

        Firewall can be imported using any of these accepted formats:

        * `projects/{{project}}/global/firewalls/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Firewall can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default projects/{{project}}/global/firewalls/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewall:Firewall default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param FirewallArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAllowArgs', 'FirewallAllowArgsDict']]]]] = None,
                 denies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallDenyArgs', 'FirewallDenyArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 log_config: Optional[pulumi.Input[Union['FirewallLogConfigArgs', 'FirewallLogConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['FirewallParamsArgs', 'FirewallParamsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallArgs.__new__(FirewallArgs)

            __props__.__dict__["allows"] = allows
            __props__.__dict__["denies"] = denies
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_ranges"] = destination_ranges
            __props__.__dict__["direction"] = direction
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["enable_logging"] = enable_logging
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["params"] = params
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["source_ranges"] = source_ranges
            __props__.__dict__["source_service_accounts"] = source_service_accounts
            __props__.__dict__["source_tags"] = source_tags
            __props__.__dict__["target_service_accounts"] = target_service_accounts
            __props__.__dict__["target_tags"] = target_tags
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["self_link"] = None
        super(Firewall, __self__).__init__(
            'gcp:compute/firewall:Firewall',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallAllowArgs', 'FirewallAllowArgsDict']]]]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            denies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallDenyArgs', 'FirewallDenyArgsDict']]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
            log_config: Optional[pulumi.Input[Union['FirewallLogConfigArgs', 'FirewallLogConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            params: Optional[pulumi.Input[Union['FirewallParamsArgs', 'FirewallParamsArgsDict']]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            source_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            source_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Firewall':
        """
        Get an existing Firewall resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallAllowArgs', 'FirewallAllowArgsDict']]]] allows: The list of ALLOW rules specified by this firewall. Each rule
               specifies a protocol and port-range tuple that describes a permitted
               connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallDenyArgs', 'FirewallDenyArgsDict']]]] denies: The list of DENY rules specified by this firewall. Each rule specifies
               a protocol and port-range tuple that describes a denied connection.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destination_ranges: If destination ranges are specified, the firewall will apply only to
               traffic that has destination IP address in these ranges. These ranges
               must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        :param pulumi.Input[builtins.str] direction: Direction of traffic to which this firewall applies; default is
               INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
               `source_tags` or `source_service_accounts` is required.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall rule is disabled, i.e not applied to the
               network it is associated with. When set to true, the firewall rule is
               not enforced and the network behaves as if it did not exist. If this
               is unspecified, the firewall rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: This field denotes whether to enable logging for a particular firewall rule.
               If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        :param pulumi.Input[Union['FirewallLogConfigArgs', 'FirewallLogConfigArgsDict']] log_config: This field denotes the logging options for a particular firewall rule.
               If defined, logging is enabled, and logs will be exported to Cloud Logging.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The name or self_link of the network to attach this firewall to.
        :param pulumi.Input[Union['FirewallParamsArgs', 'FirewallParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: Priority for this rule. This is an integer between 0 and 65535, both
               inclusive. When not specified, the value assumed is 1000. Relative
               priorities determine precedence of conflicting rules. Lower value of
               priority implies higher precedence (eg, a rule with priority 0 has
               higher precedence than a rule with priority 1). DENY rules take
               precedence over ALLOW rules having equal priority.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_ranges: If source ranges are specified, the firewall will apply only to
               traffic that has source IP address in these ranges. These ranges must
               be expressed in CIDR format. One or both of sourceRanges and
               sourceTags may be set. If both properties are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP that belongs to a tag listed in the sourceTags property. The
               connection does not need to match both properties for the firewall to
               apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
               `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_service_accounts: If source service accounts are specified, the firewall will apply only
               to traffic originating from an instance with a service account in this
               list. Source service accounts cannot be used to control traffic to an
               instance's external IP address because service accounts are associated
               with an instance, not an IP address. sourceRanges can be set at the
               same time as sourceServiceAccounts. If both are set, the firewall will
               apply to traffic that has source IP address within sourceRanges OR the
               source IP belongs to an instance with service account listed in
               sourceServiceAccount. The connection does not need to match both
               properties for the firewall to apply. sourceServiceAccounts cannot be
               used at the same time as sourceTags or targetTags. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] source_tags: If source tags are specified, the firewall will apply only to traffic
               with source IP that belongs to a tag listed in source tags. Source
               tags cannot be used to control traffic to an instance's external IP
               address. Because tags are associated with an instance, not an IP
               address. One or both of sourceRanges and sourceTags may be set. If
               both properties are set, the firewall will apply to traffic that has
               source IP address within sourceRanges OR the source IP that belongs to
               a tag listed in the sourceTags property. The connection does not need
               to match both properties for the firewall to apply. For INGRESS traffic,
               one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               targetServiceAccounts cannot be used at the same time as targetTags or
               sourceTags. If neither targetServiceAccounts nor targetTags are
               specified, the firewall rule applies to all instances on the specified
               network.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_tags: A list of instance tags indicating sets of instances located in the
               network that may make network connections as specified in allowed[].
               If no targetTags are specified, the firewall rule applies to all
               instances on the specified network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallState.__new__(_FirewallState)

        __props__.__dict__["allows"] = allows
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["denies"] = denies
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_ranges"] = destination_ranges
        __props__.__dict__["direction"] = direction
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["log_config"] = log_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["params"] = params
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["source_ranges"] = source_ranges
        __props__.__dict__["source_service_accounts"] = source_service_accounts
        __props__.__dict__["source_tags"] = source_tags
        __props__.__dict__["target_service_accounts"] = target_service_accounts
        __props__.__dict__["target_tags"] = target_tags
        return Firewall(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allows(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallAllow']]]:
        """
        The list of ALLOW rules specified by this firewall. Each rule
        specifies a protocol and port-range tuple that describes a permitted
        connection.
        Structure is documented below.
        """
        return pulumi.get(self, "allows")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def denies(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallDeny']]]:
        """
        The list of DENY rules specified by this firewall. Each rule specifies
        a protocol and port-range tuple that describes a denied connection.
        Structure is documented below.
        """
        return pulumi.get(self, "denies")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationRanges")
    def destination_ranges(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        If destination ranges are specified, the firewall will apply only to
        traffic that has destination IP address in these ranges. These ranges
        must be expressed in CIDR format. IPv4 or IPv6 ranges are supported.
        """
        return pulumi.get(self, "destination_ranges")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        Direction of traffic to which this firewall applies; default is
        INGRESS. Note: For INGRESS traffic, one of `source_ranges`,
        `source_tags` or `source_service_accounts` is required.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Denotes whether the firewall rule is disabled, i.e not applied to the
        network it is associated with. When set to true, the firewall rule is
        not enforced and the network behaves as if it did not exist. If this
        is unspecified, the firewall rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="enableLogging")
    @_utilities.deprecated("""Deprecated in favor of log_config""")
    def enable_logging(self) -> pulumi.Output[builtins.bool]:
        """
        This field denotes whether to enable logging for a particular firewall rule.
        If logging is enabled, logs will be exported to Stackdriver. Deprecated in favor of `log_config`
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output[Optional['outputs.FirewallLogConfig']]:
        """
        This field denotes the logging options for a particular firewall rule.
        If defined, logging is enabled, and logs will be exported to Cloud Logging.
        Structure is documented below.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The name or self_link of the network to attach this firewall to.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.FirewallParams']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Priority for this rule. This is an integer between 0 and 65535, both
        inclusive. When not specified, the value assumed is 1000. Relative
        priorities determine precedence of conflicting rules. Lower value of
        priority implies higher precedence (eg, a rule with priority 0 has
        higher precedence than a rule with priority 1). DENY rules take
        precedence over ALLOW rules having equal priority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sourceRanges")
    def source_ranges(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        If source ranges are specified, the firewall will apply only to
        traffic that has source IP address in these ranges. These ranges must
        be expressed in CIDR format. One or both of sourceRanges and
        sourceTags may be set. If both properties are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP that belongs to a tag listed in the sourceTags property. The
        connection does not need to match both properties for the firewall to
        apply. IPv4 or IPv6 ranges are supported. For INGRESS traffic, one of
        `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_ranges")

    @property
    @pulumi.getter(name="sourceServiceAccounts")
    def source_service_accounts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        If source service accounts are specified, the firewall will apply only
        to traffic originating from an instance with a service account in this
        list. Source service accounts cannot be used to control traffic to an
        instance's external IP address because service accounts are associated
        with an instance, not an IP address. sourceRanges can be set at the
        same time as sourceServiceAccounts. If both are set, the firewall will
        apply to traffic that has source IP address within sourceRanges OR the
        source IP belongs to an instance with service account listed in
        sourceServiceAccount. The connection does not need to match both
        properties for the firewall to apply. sourceServiceAccounts cannot be
        used at the same time as sourceTags or targetTags. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_service_accounts")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        If source tags are specified, the firewall will apply only to traffic
        with source IP that belongs to a tag listed in source tags. Source
        tags cannot be used to control traffic to an instance's external IP
        address. Because tags are associated with an instance, not an IP
        address. One or both of sourceRanges and sourceTags may be set. If
        both properties are set, the firewall will apply to traffic that has
        source IP address within sourceRanges OR the source IP that belongs to
        a tag listed in the sourceTags property. The connection does not need
        to match both properties for the firewall to apply. For INGRESS traffic,
        one of `source_ranges`, `source_tags` or `source_service_accounts` is required.
        """
        return pulumi.get(self, "source_tags")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of service accounts indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        targetServiceAccounts cannot be used at the same time as targetTags or
        sourceTags. If neither targetServiceAccounts nor targetTags are
        specified, the firewall rule applies to all instances on the specified
        network.
        """
        return pulumi.get(self, "target_service_accounts")

    @property
    @pulumi.getter(name="targetTags")
    def target_tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of instance tags indicating sets of instances located in the
        network that may make network connections as specified in allowed[].
        If no targetTags are specified, the firewall rule applies to all
        instances on the specified network.
        """
        return pulumi.get(self, "target_tags")

