# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyRuleArgs', 'FirewallPolicyRule']

@pulumi.input_type
class FirewallPolicyRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 direction: pulumi.Input[builtins.str],
                 firewall_policy: pulumi.Input[builtins.str],
                 match: pulumi.Input['FirewallPolicyRuleMatchArgs'],
                 priority: pulumi.Input[builtins.int],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a FirewallPolicyRule resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input['FirewallPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled.
               When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
               If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
               Logs may be exported to BigQuery or Pub/Sub.
               Note: you cannot enable logging on "goto_next" rules.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance.
               Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get this rule.
               If this field is left blank, all VMs within the organization will receive the rule.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to.
               If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
               targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted.
               Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "firewall_policy", firewall_policy)
        pulumi.set(__self__, "match", match)
        pulumi.set(__self__, "priority", priority)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if security_profile_group is not None:
            pulumi.set(__self__, "security_profile_group", security_profile_group)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)
        if target_secure_tags is not None:
            pulumi.set(__self__, "target_secure_tags", target_secure_tags)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        if tls_inspect is not None:
            pulumi.set(__self__, "tls_inspect", tls_inspect)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Input[builtins.str]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def match(self) -> pulumi.Input['FirewallPolicyRuleMatchArgs']:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: pulumi.Input['FirewallPolicyRuleMatchArgs']):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled.
        When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
        If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether to enable logging for a particular rule.
        If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
        Logs may be exported to BigQuery or Pub/Sub.
        Note: you cannot enable logging on "goto_next" rules.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance.
        Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @security_profile_group.setter
    def security_profile_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_profile_group", value)

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network resource URLs to which this rule applies.
        This field allows you to control which network's VMs get this rule.
        If this field is left blank, all VMs within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @target_resources.setter
    def target_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_resources", value)

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to.
        If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
        targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
        Structure is documented below.
        """
        return pulumi.get(self, "target_secure_tags")

    @target_secure_tags.setter
    def target_secure_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]]):
        pulumi.set(self, "target_secure_tags", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_service_accounts", value)

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted.
        Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        return pulumi.get(self, "tls_inspect")

    @tls_inspect.setter
    def tls_inspect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_inspect", value)


@pulumi.input_type
class _FirewallPolicyRuleState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input['FirewallPolicyRuleMatchArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None):
        """
        Input properties used for looking up and filtering FirewallPolicyRule resources.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled.
               When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
               If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
               Logs may be exported to BigQuery or Pub/Sub.
               Note: you cannot enable logging on "goto_next" rules.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[builtins.str] kind: Type of the resource. Always `compute#firewallPolicyRule` for firewall policy rules
        :param pulumi.Input['FirewallPolicyRuleMatchArgs'] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[builtins.int] rule_tuple_count: Calculation of the complexity of a single firewall policy rule.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance.
               Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get this rule.
               If this field is left blank, all VMs within the organization will receive the rule.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to.
               If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
               targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted.
               Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if enable_logging is not None:
            pulumi.set(__self__, "enable_logging", enable_logging)
        if firewall_policy is not None:
            pulumi.set(__self__, "firewall_policy", firewall_policy)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if match is not None:
            pulumi.set(__self__, "match", match)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if rule_tuple_count is not None:
            pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        if security_profile_group is not None:
            pulumi.set(__self__, "security_profile_group", security_profile_group)
        if target_resources is not None:
            pulumi.set(__self__, "target_resources", target_resources)
        if target_secure_tags is not None:
            pulumi.set(__self__, "target_secure_tags", target_secure_tags)
        if target_service_accounts is not None:
            pulumi.set(__self__, "target_service_accounts", target_service_accounts)
        if tls_inspect is not None:
            pulumi.set(__self__, "tls_inspect", tls_inspect)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled.
        When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
        If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Denotes whether to enable logging for a particular rule.
        If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
        Logs may be exported to BigQuery or Pub/Sub.
        Note: you cannot enable logging on "goto_next" rules.
        """
        return pulumi.get(self, "enable_logging")

    @enable_logging.setter
    def enable_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_logging", value)

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @firewall_policy.setter
    def firewall_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "firewall_policy", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the resource. Always `compute#firewallPolicyRule` for firewall policy rules
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def match(self) -> Optional[pulumi.Input['FirewallPolicyRuleMatchArgs']]:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @match.setter
    def match(self, value: Optional[pulumi.Input['FirewallPolicyRuleMatchArgs']]):
        pulumi.set(self, "match", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Calculation of the complexity of a single firewall policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @rule_tuple_count.setter
    def rule_tuple_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_tuple_count", value)

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance.
        Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @security_profile_group.setter
    def security_profile_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_profile_group", value)

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network resource URLs to which this rule applies.
        This field allows you to control which network's VMs get this rule.
        If this field is left blank, all VMs within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @target_resources.setter
    def target_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_resources", value)

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to.
        If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
        targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
        Structure is documented below.
        """
        return pulumi.get(self, "target_secure_tags")

    @target_secure_tags.setter
    def target_secure_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyRuleTargetSecureTagArgs']]]]):
        pulumi.set(self, "target_secure_tags", value)

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @target_service_accounts.setter
    def target_service_accounts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "target_service_accounts", value)

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted.
        Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        return pulumi.get(self, "tls_inspect")

    @tls_inspect.setter
    def tls_inspect(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "tls_inspect", value)


@pulumi.type_token("gcp:compute/firewallPolicyRule:FirewallPolicyRule")
class FirewallPolicyRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['FirewallPolicyRuleMatchArgs', 'FirewallPolicyRuleMatchArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleTargetSecureTagArgs', 'FirewallPolicyRuleTargetSecureTagArgsDict']]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).

        To get more information about FirewallPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/firewallPolicies/addRule)

        ## Example Usage

        ### Firewall Policy Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_global_networksecurity_address_group = gcp.networksecurity.AddressGroup("basic_global_networksecurity_address_group",
            name="address-group",
            parent="organizations/123456789",
            description="Sample global networksecurity_address_group",
            location="global",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Resource created for Terraform acceptance testing")
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Resource created for Terraform acceptance testing",
            priority=9000,
            enable_logging=True,
            action="allow",
            direction="EGRESS",
            disabled=False,
            target_service_accounts=["my@service-account.com"],
            match={
                "dest_ip_ranges": ["11.100.0.1/32"],
                "dest_fqdns": [],
                "dest_region_codes": ["US"],
                "dest_threat_intelligences": ["iplist-known-malicious-ips"],
                "src_address_groups": [],
                "dest_address_groups": [basic_global_networksecurity_address_group.id],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        basic_key = gcp.tags.TagKey("basic_key",
            description="For keyname resources.",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "organization": "auto",
            })
        basic_value = gcp.tags.TagValue("basic_value",
            description="For valuename resources.",
            parent=basic_key.id,
            short_name="tag-value")
        ```
        ### Firewall Policy Rule Network Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Firewall policy")
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Firewall policy rule with network scope",
            priority=9000,
            action="allow",
            direction="INGRESS",
            disabled=False,
            match={
                "src_ip_ranges": ["11.100.0.1/32"],
                "src_network_scope": "VPC_NETWORKS",
                "src_networks": [network.id],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        ```
        ### Firewall Policy Rule Secure Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Resource created for Terraform acceptance testing")
        basic_key = gcp.tags.TagKey("basic_key",
            description="For keyname resources.",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "organization": "auto",
            })
        basic_value = gcp.tags.TagValue("basic_value",
            description="For valuename resources.",
            parent=basic_key.id,
            short_name="tag-value")
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Resource created for Terraform acceptance testing",
            priority=9000,
            enable_logging=True,
            action="allow",
            direction="INGRESS",
            disabled=False,
            target_secure_tags=[{
                "name": basic_value.id,
            }],
            match={
                "src_ip_ranges": ["11.100.0.1/32"],
                "src_secure_tags": [{
                    "name": basic_value.id,
                }],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        ```

        ## Import

        FirewallPolicyRule can be imported using any of these accepted formats:

        * `locations/global/firewallPolicies/{{firewall_policy}}/rules/{{priority}}`

        * `{{firewall_policy}}/{{priority}}`

        When using the `pulumi import` command, FirewallPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewallPolicyRule:FirewallPolicyRule default locations/global/firewallPolicies/{{firewall_policy}}/rules/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewallPolicyRule:FirewallPolicyRule default {{firewall_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled.
               When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
               If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
               Logs may be exported to BigQuery or Pub/Sub.
               Note: you cannot enable logging on "goto_next" rules.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[Union['FirewallPolicyRuleMatchArgs', 'FirewallPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance.
               Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get this rule.
               If this field is left blank, all VMs within the organization will receive the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleTargetSecureTagArgs', 'FirewallPolicyRuleTargetSecureTagArgsDict']]]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to.
               If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
               targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted.
               Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a rule that describes one or more match conditions along with the action to be taken when traffic matches this condition (allow or deny).

        To get more information about FirewallPolicyRule, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/firewallPolicies/addRule)

        ## Example Usage

        ### Firewall Policy Rule

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_global_networksecurity_address_group = gcp.networksecurity.AddressGroup("basic_global_networksecurity_address_group",
            name="address-group",
            parent="organizations/123456789",
            description="Sample global networksecurity_address_group",
            location="global",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Resource created for Terraform acceptance testing")
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Resource created for Terraform acceptance testing",
            priority=9000,
            enable_logging=True,
            action="allow",
            direction="EGRESS",
            disabled=False,
            target_service_accounts=["my@service-account.com"],
            match={
                "dest_ip_ranges": ["11.100.0.1/32"],
                "dest_fqdns": [],
                "dest_region_codes": ["US"],
                "dest_threat_intelligences": ["iplist-known-malicious-ips"],
                "src_address_groups": [],
                "dest_address_groups": [basic_global_networksecurity_address_group.id],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        basic_key = gcp.tags.TagKey("basic_key",
            description="For keyname resources.",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "organization": "auto",
            })
        basic_value = gcp.tags.TagValue("basic_value",
            description="For valuename resources.",
            parent=basic_key.id,
            short_name="tag-value")
        ```
        ### Firewall Policy Rule Network Scope

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Firewall policy")
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Firewall policy rule with network scope",
            priority=9000,
            action="allow",
            direction="INGRESS",
            disabled=False,
            match={
                "src_ip_ranges": ["11.100.0.1/32"],
                "src_network_scope": "VPC_NETWORKS",
                "src_networks": [network.id],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        ```
        ### Firewall Policy Rule Secure Tags

        ```python
        import pulumi
        import pulumi_gcp as gcp

        folder = gcp.organizations.Folder("folder",
            display_name="folder",
            parent="organizations/123456789",
            deletion_protection=False)
        default = gcp.compute.FirewallPolicy("default",
            parent=folder.id,
            short_name="fw-policy",
            description="Resource created for Terraform acceptance testing")
        basic_key = gcp.tags.TagKey("basic_key",
            description="For keyname resources.",
            parent="organizations/123456789",
            purpose="GCE_FIREWALL",
            short_name="tag-key",
            purpose_data={
                "organization": "auto",
            })
        basic_value = gcp.tags.TagValue("basic_value",
            description="For valuename resources.",
            parent=basic_key.id,
            short_name="tag-value")
        primary = gcp.compute.FirewallPolicyRule("primary",
            firewall_policy=default.name,
            description="Resource created for Terraform acceptance testing",
            priority=9000,
            enable_logging=True,
            action="allow",
            direction="INGRESS",
            disabled=False,
            target_secure_tags=[{
                "name": basic_value.id,
            }],
            match={
                "src_ip_ranges": ["11.100.0.1/32"],
                "src_secure_tags": [{
                    "name": basic_value.id,
                }],
                "layer4_configs": [
                    {
                        "ip_protocol": "tcp",
                        "ports": ["8080"],
                    },
                    {
                        "ip_protocol": "udp",
                        "ports": ["22"],
                    },
                ],
            })
        ```

        ## Import

        FirewallPolicyRule can be imported using any of these accepted formats:

        * `locations/global/firewallPolicies/{{firewall_policy}}/rules/{{priority}}`

        * `{{firewall_policy}}/{{priority}}`

        When using the `pulumi import` command, FirewallPolicyRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewallPolicyRule:FirewallPolicyRule default locations/global/firewallPolicies/{{firewall_policy}}/rules/{{priority}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewallPolicyRule:FirewallPolicyRule default {{firewall_policy}}/{{priority}}
        ```

        :param str resource_name: The name of the resource.
        :param FirewallPolicyRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 disabled: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
                 match: Optional[pulumi.Input[Union['FirewallPolicyRuleMatchArgs', 'FirewallPolicyRuleMatchArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
                 target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleTargetSecureTagArgs', 'FirewallPolicyRuleTargetSecureTagArgsDict']]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tls_inspect: Optional[pulumi.Input[builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyRuleArgs.__new__(FirewallPolicyRuleArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["disabled"] = disabled
            __props__.__dict__["enable_logging"] = enable_logging
            if firewall_policy is None and not opts.urn:
                raise TypeError("Missing required property 'firewall_policy'")
            __props__.__dict__["firewall_policy"] = firewall_policy
            if match is None and not opts.urn:
                raise TypeError("Missing required property 'match'")
            __props__.__dict__["match"] = match
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
            __props__.__dict__["security_profile_group"] = security_profile_group
            __props__.__dict__["target_resources"] = target_resources
            __props__.__dict__["target_secure_tags"] = target_secure_tags
            __props__.__dict__["target_service_accounts"] = target_service_accounts
            __props__.__dict__["tls_inspect"] = tls_inspect
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["rule_tuple_count"] = None
        super(FirewallPolicyRule, __self__).__init__(
            'gcp:compute/firewallPolicyRule:FirewallPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            disabled: Optional[pulumi.Input[builtins.bool]] = None,
            enable_logging: Optional[pulumi.Input[builtins.bool]] = None,
            firewall_policy: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            match: Optional[pulumi.Input[Union['FirewallPolicyRuleMatchArgs', 'FirewallPolicyRuleMatchArgsDict']]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
            security_profile_group: Optional[pulumi.Input[builtins.str]] = None,
            target_resources: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            target_secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleTargetSecureTagArgs', 'FirewallPolicyRuleTargetSecureTagArgsDict']]]]] = None,
            target_service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tls_inspect: Optional[pulumi.Input[builtins.bool]] = None) -> 'FirewallPolicyRule':
        """
        Get an existing FirewallPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description for this resource.
        :param pulumi.Input[builtins.str] direction: The direction in which this rule applies.
               Possible values are: `INGRESS`, `EGRESS`.
        :param pulumi.Input[builtins.bool] disabled: Denotes whether the firewall policy rule is disabled.
               When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
               If this is unspecified, the firewall policy rule will be enabled.
        :param pulumi.Input[builtins.bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
               Logs may be exported to BigQuery or Pub/Sub.
               Note: you cannot enable logging on "goto_next" rules.
        :param pulumi.Input[builtins.str] firewall_policy: The firewall policy of the resource.
        :param pulumi.Input[builtins.str] kind: Type of the resource. Always `compute#firewallPolicyRule` for firewall policy rules
        :param pulumi.Input[Union['FirewallPolicyRuleMatchArgs', 'FirewallPolicyRuleMatchArgsDict']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: An integer indicating the priority of a rule in the list.
               The priority must be a positive value between 0 and 2147483647.
               Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[builtins.int] rule_tuple_count: Calculation of the complexity of a single firewall policy rule.
        :param pulumi.Input[builtins.str] security_profile_group: A fully-qualified URL of a SecurityProfile resource instance.
               Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
               Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get this rule.
               If this field is left blank, all VMs within the organization will receive the rule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyRuleTargetSecureTagArgs', 'FirewallPolicyRuleTargetSecureTagArgsDict']]]] target_secure_tags: A list of secure tags that controls which instances the firewall rule applies to.
               If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
               targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] target_service_accounts: A list of service accounts indicating the sets of instances that are applied with this rule.
        :param pulumi.Input[builtins.bool] tls_inspect: Boolean flag indicating if the traffic should be TLS decrypted.
               Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyRuleState.__new__(_FirewallPolicyRuleState)

        __props__.__dict__["action"] = action
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["direction"] = direction
        __props__.__dict__["disabled"] = disabled
        __props__.__dict__["enable_logging"] = enable_logging
        __props__.__dict__["firewall_policy"] = firewall_policy
        __props__.__dict__["kind"] = kind
        __props__.__dict__["match"] = match
        __props__.__dict__["priority"] = priority
        __props__.__dict__["rule_tuple_count"] = rule_tuple_count
        __props__.__dict__["security_profile_group"] = security_profile_group
        __props__.__dict__["target_resources"] = target_resources
        __props__.__dict__["target_secure_tags"] = target_secure_tags
        __props__.__dict__["target_service_accounts"] = target_service_accounts
        __props__.__dict__["tls_inspect"] = tls_inspect
        return FirewallPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        The Action to perform when the client connection triggers the rule. Valid actions are "allow", "deny", "goto_next" and "apply_security_profile_group".
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description for this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        The direction in which this rule applies.
        Possible values are: `INGRESS`, `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Denotes whether the firewall policy rule is disabled.
        When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist.
        If this is unspecified, the firewall policy rule will be enabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Denotes whether to enable logging for a particular rule.
        If logging is enabled, logs will be exported to the configured export destination in Stackdriver.
        Logs may be exported to BigQuery or Pub/Sub.
        Note: you cannot enable logging on "goto_next" rules.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter(name="firewallPolicy")
    def firewall_policy(self) -> pulumi.Output[builtins.str]:
        """
        The firewall policy of the resource.
        """
        return pulumi.get(self, "firewall_policy")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        Type of the resource. Always `compute#firewallPolicyRule` for firewall policy rules
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output['outputs.FirewallPolicyRuleMatch']:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        An integer indicating the priority of a rule in the list.
        The priority must be a positive value between 0 and 2147483647.
        Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> pulumi.Output[builtins.int]:
        """
        Calculation of the complexity of a single firewall policy rule.
        """
        return pulumi.get(self, "rule_tuple_count")

    @property
    @pulumi.getter(name="securityProfileGroup")
    def security_profile_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A fully-qualified URL of a SecurityProfile resource instance.
        Example: https://networksecurity.googleapis.com/v1/projects/{project}/locations/{location}/securityProfileGroups/my-security-profile-group
        Must be specified if action = 'apply_security_profile_group' and cannot be specified for other actions.
        """
        return pulumi.get(self, "security_profile_group")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of network resource URLs to which this rule applies.
        This field allows you to control which network's VMs get this rule.
        If this field is left blank, all VMs within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @property
    @pulumi.getter(name="targetSecureTags")
    def target_secure_tags(self) -> pulumi.Output[Optional[Sequence['outputs.FirewallPolicyRuleTargetSecureTag']]]:
        """
        A list of secure tags that controls which instances the firewall rule applies to.
        If targetSecureTag are specified, then the firewall rule applies only to instances in the VPC network that have one of those EFFECTIVE secure tags, if all the targetSecureTag are in INEFFECTIVE state, then this rule will be ignored.
        targetSecureTag may not be set at the same time as targetServiceAccounts. If neither targetServiceAccounts nor targetSecureTag are specified, the firewall rule applies to all instances on the specified network. Maximum number of target secure tags allowed is 256.
        Structure is documented below.
        """
        return pulumi.get(self, "target_secure_tags")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of service accounts indicating the sets of instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    @property
    @pulumi.getter(name="tlsInspect")
    def tls_inspect(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Boolean flag indicating if the traffic should be TLS decrypted.
        Can be set only if action = 'apply_security_profile_group' and cannot be set for other actions.
        """
        return pulumi.get(self, "tls_inspect")

