# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FirewallPolicyWithRulesArgs', 'FirewallPolicyWithRules']

@pulumi.input_type
class FirewallPolicyWithRulesArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]],
                 short_name: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a FirewallPolicyWithRules resource.
        :param pulumi.Input[builtins.str] parent: The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
               Format: organizations/{organization_id} or folders/{folder_id}
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_name: A textual name of the security policy.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        """
        pulumi.set(__self__, "parent", parent)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "short_name", short_name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
        Format: organizations/{organization_id} or folders/{folder_id}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Input[builtins.str]:
        """
        A textual name of the security policy.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "short_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _FirewallPolicyWithRulesState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 predefined_rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesPredefinedRuleArgs']]]] = None,
                 rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 self_link_with_id: Optional[pulumi.Input[builtins.str]] = None,
                 short_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering FirewallPolicyWithRules resources.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of the resource. This field is used internally during updates of this resource.
        :param pulumi.Input[builtins.str] parent: The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
               Format: organizations/{organization_id} or folders/{folder_id}
        :param pulumi.Input[builtins.str] policy_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesPredefinedRuleArgs']]] predefined_rules: A list of pre-define firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.int] rule_tuple_count: Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        :param pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        :param pulumi.Input[builtins.str] short_name: A textual name of the security policy.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if predefined_rules is not None:
            pulumi.set(__self__, "predefined_rules", predefined_rules)
        if rule_tuple_count is not None:
            pulumi.set(__self__, "rule_tuple_count", rule_tuple_count)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of the resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
        Format: organizations/{organization_id} or folders/{folder_id}
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="predefinedRules")
    def predefined_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesPredefinedRuleArgs']]]]:
        """
        A list of pre-define firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_rules")

    @predefined_rules.setter
    def predefined_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesPredefinedRuleArgs']]]]):
        pulumi.set(self, "predefined_rules", value)

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        """
        return pulumi.get(self, "rule_tuple_count")

    @rule_tuple_count.setter
    def rule_tuple_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "rule_tuple_count", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]]]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FirewallPolicyWithRulesRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link_with_id", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A textual name of the security policy.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_name", value)


@pulumi.type_token("gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules")
class FirewallPolicyWithRules(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesRuleArgs', 'FirewallPolicyWithRulesRuleArgsDict']]]]] = None,
                 short_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The Compute FirewallPolicy with rules resource. It declaratively manges all
        rules in the firewall policy.

        ## Example Usage

        ### Compute Firewall Policy With Rules Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        address_group1 = gcp.networksecurity.AddressGroup("address_group_1",
            name="address-group",
            parent="organizations/123456789",
            description="Global address group",
            location="global",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        security_profile1 = gcp.networksecurity.SecurityProfile("security_profile_1",
            name="sp",
            type="THREAT_PREVENTION",
            parent="organizations/123456789",
            location="global")
        security_profile_group1 = gcp.networksecurity.SecurityProfileGroup("security_profile_group_1",
            name="spg",
            parent="organizations/123456789",
            description="my description",
            threat_prevention_profile=security_profile1.id)
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        primary = gcp.compute.FirewallPolicyWithRules("primary",
            short_name="fw-policy",
            description="Terraform test",
            parent="organizations/123456789",
            rules=[
                {
                    "description": "tcp rule",
                    "priority": 1000,
                    "enable_logging": True,
                    "action": "allow",
                    "direction": "EGRESS",
                    "target_resources": [network.self_link],
                    "match": {
                        "dest_ip_ranges": ["11.100.0.1/32"],
                        "dest_fqdns": [
                            "www.yyy.com",
                            "www.zzz.com",
                        ],
                        "dest_region_codes": [
                            "HK",
                            "IN",
                        ],
                        "dest_threat_intelligences": [
                            "iplist-search-engines-crawlers",
                            "iplist-tor-exit-nodes",
                        ],
                        "dest_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                            "ports": [
                                "8080",
                                "7070",
                            ],
                        }],
                    },
                },
                {
                    "description": "udp rule",
                    "priority": 2000,
                    "enable_logging": False,
                    "action": "deny",
                    "direction": "INGRESS",
                    "disabled": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "src_fqdns": [
                            "www.abc.com",
                            "www.def.com",
                        ],
                        "src_region_codes": [
                            "US",
                            "CA",
                        ],
                        "src_threat_intelligences": [
                            "iplist-known-malicious-ips",
                            "iplist-public-clouds",
                        ],
                        "src_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "udp",
                        }],
                    },
                },
                {
                    "description": "security profile group rule",
                    "rule_name": "tcp rule",
                    "priority": 3000,
                    "enable_logging": False,
                    "action": "apply_security_profile_group",
                    "direction": "INGRESS",
                    "target_service_accounts": ["test@google.com"],
                    "security_profile_group": security_profile_group1.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
                    "tls_inspect": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                        }],
                    },
                },
            ])
        ```

        ## Import

        FirewallPolicyWithRules can be imported using any of these accepted formats:

        * `locations/global/firewallPolicies/{{policy_id}}`

        * `{{policy_id}}`

        When using the `pulumi import` command, FirewallPolicyWithRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules default locations/global/firewallPolicies/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules default {{policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] parent: The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
               Format: organizations/{organization_id} or folders/{folder_id}
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesRuleArgs', 'FirewallPolicyWithRulesRuleArgsDict']]]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_name: A textual name of the security policy.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FirewallPolicyWithRulesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Compute FirewallPolicy with rules resource. It declaratively manges all
        rules in the firewall policy.

        ## Example Usage

        ### Compute Firewall Policy With Rules Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        address_group1 = gcp.networksecurity.AddressGroup("address_group_1",
            name="address-group",
            parent="organizations/123456789",
            description="Global address group",
            location="global",
            items=["208.80.154.224/32"],
            type="IPV4",
            capacity=100)
        security_profile1 = gcp.networksecurity.SecurityProfile("security_profile_1",
            name="sp",
            type="THREAT_PREVENTION",
            parent="organizations/123456789",
            location="global")
        security_profile_group1 = gcp.networksecurity.SecurityProfileGroup("security_profile_group_1",
            name="spg",
            parent="organizations/123456789",
            description="my description",
            threat_prevention_profile=security_profile1.id)
        network = gcp.compute.Network("network",
            name="network",
            auto_create_subnetworks=False)
        primary = gcp.compute.FirewallPolicyWithRules("primary",
            short_name="fw-policy",
            description="Terraform test",
            parent="organizations/123456789",
            rules=[
                {
                    "description": "tcp rule",
                    "priority": 1000,
                    "enable_logging": True,
                    "action": "allow",
                    "direction": "EGRESS",
                    "target_resources": [network.self_link],
                    "match": {
                        "dest_ip_ranges": ["11.100.0.1/32"],
                        "dest_fqdns": [
                            "www.yyy.com",
                            "www.zzz.com",
                        ],
                        "dest_region_codes": [
                            "HK",
                            "IN",
                        ],
                        "dest_threat_intelligences": [
                            "iplist-search-engines-crawlers",
                            "iplist-tor-exit-nodes",
                        ],
                        "dest_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                            "ports": [
                                "8080",
                                "7070",
                            ],
                        }],
                    },
                },
                {
                    "description": "udp rule",
                    "priority": 2000,
                    "enable_logging": False,
                    "action": "deny",
                    "direction": "INGRESS",
                    "disabled": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "src_fqdns": [
                            "www.abc.com",
                            "www.def.com",
                        ],
                        "src_region_codes": [
                            "US",
                            "CA",
                        ],
                        "src_threat_intelligences": [
                            "iplist-known-malicious-ips",
                            "iplist-public-clouds",
                        ],
                        "src_address_groups": [address_group1.id],
                        "layer4_configs": [{
                            "ip_protocol": "udp",
                        }],
                    },
                },
                {
                    "description": "security profile group rule",
                    "rule_name": "tcp rule",
                    "priority": 3000,
                    "enable_logging": False,
                    "action": "apply_security_profile_group",
                    "direction": "INGRESS",
                    "target_service_accounts": ["test@google.com"],
                    "security_profile_group": security_profile_group1.id.apply(lambda id: f"//networksecurity.googleapis.com/{id}"),
                    "tls_inspect": True,
                    "match": {
                        "src_ip_ranges": ["0.0.0.0/0"],
                        "layer4_configs": [{
                            "ip_protocol": "tcp",
                        }],
                    },
                },
            ])
        ```

        ## Import

        FirewallPolicyWithRules can be imported using any of these accepted formats:

        * `locations/global/firewallPolicies/{{policy_id}}`

        * `{{policy_id}}`

        When using the `pulumi import` command, FirewallPolicyWithRules can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules default locations/global/firewallPolicies/{{policy_id}}
        ```

        ```sh
        $ pulumi import gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules default {{policy_id}}
        ```

        :param str resource_name: The name of the resource.
        :param FirewallPolicyWithRulesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FirewallPolicyWithRulesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesRuleArgs', 'FirewallPolicyWithRulesRuleArgsDict']]]]] = None,
                 short_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FirewallPolicyWithRulesArgs.__new__(FirewallPolicyWithRulesArgs)

            __props__.__dict__["description"] = description
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if short_name is None and not opts.urn:
                raise TypeError("Missing required property 'short_name'")
            __props__.__dict__["short_name"] = short_name
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["policy_id"] = None
            __props__.__dict__["predefined_rules"] = None
            __props__.__dict__["rule_tuple_count"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["self_link_with_id"] = None
        super(FirewallPolicyWithRules, __self__).__init__(
            'gcp:compute/firewallPolicyWithRules:FirewallPolicyWithRules',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            policy_id: Optional[pulumi.Input[builtins.str]] = None,
            predefined_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesPredefinedRuleArgs', 'FirewallPolicyWithRulesPredefinedRuleArgsDict']]]]] = None,
            rule_tuple_count: Optional[pulumi.Input[builtins.int]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesRuleArgs', 'FirewallPolicyWithRulesRuleArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            self_link_with_id: Optional[pulumi.Input[builtins.str]] = None,
            short_name: Optional[pulumi.Input[builtins.str]] = None) -> 'FirewallPolicyWithRules':
        """
        Get an existing FirewallPolicyWithRules resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of the resource. This field is used internally during updates of this resource.
        :param pulumi.Input[builtins.str] parent: The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
               Format: organizations/{organization_id} or folders/{folder_id}
        :param pulumi.Input[builtins.str] policy_id: The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesPredefinedRuleArgs', 'FirewallPolicyWithRulesPredefinedRuleArgsDict']]]] predefined_rules: A list of pre-define firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.int] rule_tuple_count: Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        :param pulumi.Input[Sequence[pulumi.Input[Union['FirewallPolicyWithRulesRuleArgs', 'FirewallPolicyWithRulesRuleArgsDict']]]] rules: A list of firewall policy rules.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: Server-defined URL for the resource.
        :param pulumi.Input[builtins.str] self_link_with_id: Server-defined URL for this resource with the resource id.
        :param pulumi.Input[builtins.str] short_name: A textual name of the security policy.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FirewallPolicyWithRulesState.__new__(_FirewallPolicyWithRulesState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["parent"] = parent
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["predefined_rules"] = predefined_rules
        __props__.__dict__["rule_tuple_count"] = rule_tuple_count
        __props__.__dict__["rules"] = rules
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["self_link_with_id"] = self_link_with_id
        __props__.__dict__["short_name"] = short_name
        return FirewallPolicyWithRules(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of the resource. This field is used internally during updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of this FirewallPolicy in the Cloud Resource Hierarchy.
        Format: organizations/{organization_id} or folders/{folder_id}
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="predefinedRules")
    def predefined_rules(self) -> pulumi.Output[Sequence['outputs.FirewallPolicyWithRulesPredefinedRule']]:
        """
        A list of pre-define firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "predefined_rules")

    @property
    @pulumi.getter(name="ruleTupleCount")
    def rule_tuple_count(self) -> pulumi.Output[builtins.int]:
        """
        Total count of all firewall policy rule tuples. A firewall policy can not exceed a set number of tuples.
        """
        return pulumi.get(self, "rule_tuple_count")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.FirewallPolicyWithRulesRule']]:
        """
        A list of firewall policy rules.
        Structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[builtins.str]:
        """
        Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Output[builtins.str]:
        """
        A textual name of the security policy.
        """
        return pulumi.get(self, "short_name")

