# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetAddressesResult',
    'AwaitableGetAddressesResult',
    'get_addresses',
    'get_addresses_output',
]

@pulumi.output_type
class GetAddressesResult:
    """
    A collection of values returned by getAddresses.
    """
    def __init__(__self__, addresses=None, filter=None, id=None, project=None, region=None):
        if addresses and not isinstance(addresses, list):
            raise TypeError("Expected argument 'addresses' to be a list")
        pulumi.set(__self__, "addresses", addresses)
        if filter and not isinstance(filter, str):
            raise TypeError("Expected argument 'filter' to be a str")
        pulumi.set(__self__, "filter", filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.GetAddressesAddressResult']:
        """
        A list of addresses matching the filter. Structure is defined below.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def filter(self) -> Optional[builtins.str]:
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        The region in which the address resides.
        """
        return pulumi.get(self, "region")


class AwaitableGetAddressesResult(GetAddressesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressesResult(
            addresses=self.addresses,
            filter=self.filter,
            id=self.id,
            project=self.project,
            region=self.region)


def get_addresses(filter: Optional[builtins.str] = None,
                  project: Optional[builtins.str] = None,
                  region: Optional[builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressesResult:
    """
    List IP addresses in a project. For more information see
    the official API [list](https://cloud.google.com/compute/docs/reference/latest/addresses/list) and
    [aggregated list](https://cloud.google.com/compute/docs/reference/rest/v1/addresses/aggregatedList) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test = gcp.compute.get_addresses(filter="name:test-*")
    prod = gcp.dns.ManagedZone("prod",
        name="prod-zone",
        dns_name="prod.mydomain.com.")
    frontend = gcp.dns.RecordSet("frontend",
        name=prod.dns_name.apply(lambda dns_name: f"frontend.{dns_name}"),
        type="A",
        ttl=300,
        managed_zone=prod.name,
        rrdatas=[__item.address for __item in test.addresses])
    ```


    :param builtins.str filter: A filter expression that
           filters resources listed in the response. The expression must specify
           the field name, an operator, and the value that you want to use for
           filtering. The value must be a string, a number, or a boolean. The
           operator must be either "=", "!=", ">", "<", "<=", ">=" or ":". For
           example, if you are filtering Compute Engine instances, you can
           exclude instances named "example-instance" by specifying "name !=
           example-instance". The ":" operator can be used with string fields to
           match substrings. For non-string fields it is equivalent to the "="
           operator. The ":*" comparison can be used to test whether a key has
           been defined. For example, to find all objects with "owner" label
           use: \"\"\" labels.owner:* \"\"\" You can also filter nested fields. For
           example, you could specify "scheduling.automaticRestart = false" to
           include instances only if they are not scheduled for automatic
           restarts. You can use filtering on nested fields to filter based on
           resource labels. To filter on multiple expressions, provide each
           separate expression within parentheses. For example: \"\"\"
           (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
           \"\"\" By default, each expression is an "AND" expression. However, you
           can include "AND" and "OR" expressions explicitly. For example: \"\"\"
           (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell")
           AND (scheduling.automaticRestart = true)
    :param builtins.str project: The google project in which addresses are listed.
           Defaults to provider's configuration if missing.
    :param builtins.str region: Region that should be considered to search addresses.
           All regions are considered if missing.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getAddresses:getAddresses', __args__, opts=opts, typ=GetAddressesResult).value

    return AwaitableGetAddressesResult(
        addresses=pulumi.get(__ret__, 'addresses'),
        filter=pulumi.get(__ret__, 'filter'),
        id=pulumi.get(__ret__, 'id'),
        project=pulumi.get(__ret__, 'project'),
        region=pulumi.get(__ret__, 'region'))
def get_addresses_output(filter: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAddressesResult]:
    """
    List IP addresses in a project. For more information see
    the official API [list](https://cloud.google.com/compute/docs/reference/latest/addresses/list) and
    [aggregated list](https://cloud.google.com/compute/docs/reference/rest/v1/addresses/aggregatedList) documentation.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    test = gcp.compute.get_addresses(filter="name:test-*")
    prod = gcp.dns.ManagedZone("prod",
        name="prod-zone",
        dns_name="prod.mydomain.com.")
    frontend = gcp.dns.RecordSet("frontend",
        name=prod.dns_name.apply(lambda dns_name: f"frontend.{dns_name}"),
        type="A",
        ttl=300,
        managed_zone=prod.name,
        rrdatas=[__item.address for __item in test.addresses])
    ```


    :param builtins.str filter: A filter expression that
           filters resources listed in the response. The expression must specify
           the field name, an operator, and the value that you want to use for
           filtering. The value must be a string, a number, or a boolean. The
           operator must be either "=", "!=", ">", "<", "<=", ">=" or ":". For
           example, if you are filtering Compute Engine instances, you can
           exclude instances named "example-instance" by specifying "name !=
           example-instance". The ":" operator can be used with string fields to
           match substrings. For non-string fields it is equivalent to the "="
           operator. The ":*" comparison can be used to test whether a key has
           been defined. For example, to find all objects with "owner" label
           use: \"\"\" labels.owner:* \"\"\" You can also filter nested fields. For
           example, you could specify "scheduling.automaticRestart = false" to
           include instances only if they are not scheduled for automatic
           restarts. You can use filtering on nested fields to filter based on
           resource labels. To filter on multiple expressions, provide each
           separate expression within parentheses. For example: \"\"\"
           (scheduling.automaticRestart = true) (cpuPlatform = "Intel Skylake")
           \"\"\" By default, each expression is an "AND" expression. However, you
           can include "AND" and "OR" expressions explicitly. For example: \"\"\"
           (cpuPlatform = "Intel Skylake") OR (cpuPlatform = "Intel Broadwell")
           AND (scheduling.automaticRestart = true)
    :param builtins.str project: The google project in which addresses are listed.
           Defaults to provider's configuration if missing.
    :param builtins.str region: Region that should be considered to search addresses.
           All regions are considered if missing.
    """
    __args__ = dict()
    __args__['filter'] = filter
    __args__['project'] = project
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getAddresses:getAddresses', __args__, opts=opts, typ=GetAddressesResult)
    return __ret__.apply(lambda __response__: GetAddressesResult(
        addresses=pulumi.get(__response__, 'addresses'),
        filter=pulumi.get(__response__, 'filter'),
        id=pulumi.get(__response__, 'id'),
        project=pulumi.get(__response__, 'project'),
        region=pulumi.get(__response__, 'region')))
