# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDiskResult',
    'AwaitableGetDiskResult',
    'get_disk',
    'get_disk_output',
]

@pulumi.output_type
class GetDiskResult:
    """
    A collection of values returned by getDisk.
    """
    def __init__(__self__, access_mode=None, architecture=None, async_primary_disks=None, create_snapshot_before_destroy=None, create_snapshot_before_destroy_prefix=None, creation_timestamp=None, description=None, disk_encryption_keys=None, disk_id=None, effective_labels=None, enable_confidential_compute=None, guest_os_features=None, id=None, image=None, interface=None, label_fingerprint=None, labels=None, last_attach_timestamp=None, last_detach_timestamp=None, licenses=None, multi_writer=None, name=None, params=None, physical_block_size_bytes=None, project=None, provisioned_iops=None, provisioned_throughput=None, pulumi_labels=None, resource_policies=None, self_link=None, size=None, snapshot=None, source_disk=None, source_disk_id=None, source_image_encryption_keys=None, source_image_id=None, source_instant_snapshot=None, source_instant_snapshot_id=None, source_snapshot_encryption_keys=None, source_snapshot_id=None, source_storage_object=None, storage_pool=None, type=None, users=None, zone=None):
        if access_mode and not isinstance(access_mode, str):
            raise TypeError("Expected argument 'access_mode' to be a str")
        pulumi.set(__self__, "access_mode", access_mode)
        if architecture and not isinstance(architecture, str):
            raise TypeError("Expected argument 'architecture' to be a str")
        pulumi.set(__self__, "architecture", architecture)
        if async_primary_disks and not isinstance(async_primary_disks, list):
            raise TypeError("Expected argument 'async_primary_disks' to be a list")
        pulumi.set(__self__, "async_primary_disks", async_primary_disks)
        if create_snapshot_before_destroy and not isinstance(create_snapshot_before_destroy, bool):
            raise TypeError("Expected argument 'create_snapshot_before_destroy' to be a bool")
        pulumi.set(__self__, "create_snapshot_before_destroy", create_snapshot_before_destroy)
        if create_snapshot_before_destroy_prefix and not isinstance(create_snapshot_before_destroy_prefix, str):
            raise TypeError("Expected argument 'create_snapshot_before_destroy_prefix' to be a str")
        pulumi.set(__self__, "create_snapshot_before_destroy_prefix", create_snapshot_before_destroy_prefix)
        if creation_timestamp and not isinstance(creation_timestamp, str):
            raise TypeError("Expected argument 'creation_timestamp' to be a str")
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if disk_encryption_keys and not isinstance(disk_encryption_keys, list):
            raise TypeError("Expected argument 'disk_encryption_keys' to be a list")
        pulumi.set(__self__, "disk_encryption_keys", disk_encryption_keys)
        if disk_id and not isinstance(disk_id, str):
            raise TypeError("Expected argument 'disk_id' to be a str")
        pulumi.set(__self__, "disk_id", disk_id)
        if effective_labels and not isinstance(effective_labels, dict):
            raise TypeError("Expected argument 'effective_labels' to be a dict")
        pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_confidential_compute and not isinstance(enable_confidential_compute, bool):
            raise TypeError("Expected argument 'enable_confidential_compute' to be a bool")
        pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)
        if guest_os_features and not isinstance(guest_os_features, list):
            raise TypeError("Expected argument 'guest_os_features' to be a list")
        pulumi.set(__self__, "guest_os_features", guest_os_features)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image and not isinstance(image, str):
            raise TypeError("Expected argument 'image' to be a str")
        pulumi.set(__self__, "image", image)
        if interface and not isinstance(interface, str):
            raise TypeError("Expected argument 'interface' to be a str")
        pulumi.set(__self__, "interface", interface)
        if label_fingerprint and not isinstance(label_fingerprint, str):
            raise TypeError("Expected argument 'label_fingerprint' to be a str")
        pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if last_attach_timestamp and not isinstance(last_attach_timestamp, str):
            raise TypeError("Expected argument 'last_attach_timestamp' to be a str")
        pulumi.set(__self__, "last_attach_timestamp", last_attach_timestamp)
        if last_detach_timestamp and not isinstance(last_detach_timestamp, str):
            raise TypeError("Expected argument 'last_detach_timestamp' to be a str")
        pulumi.set(__self__, "last_detach_timestamp", last_detach_timestamp)
        if licenses and not isinstance(licenses, list):
            raise TypeError("Expected argument 'licenses' to be a list")
        pulumi.set(__self__, "licenses", licenses)
        if multi_writer and not isinstance(multi_writer, bool):
            raise TypeError("Expected argument 'multi_writer' to be a bool")
        pulumi.set(__self__, "multi_writer", multi_writer)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if params and not isinstance(params, list):
            raise TypeError("Expected argument 'params' to be a list")
        pulumi.set(__self__, "params", params)
        if physical_block_size_bytes and not isinstance(physical_block_size_bytes, int):
            raise TypeError("Expected argument 'physical_block_size_bytes' to be a int")
        pulumi.set(__self__, "physical_block_size_bytes", physical_block_size_bytes)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if provisioned_iops and not isinstance(provisioned_iops, int):
            raise TypeError("Expected argument 'provisioned_iops' to be a int")
        pulumi.set(__self__, "provisioned_iops", provisioned_iops)
        if provisioned_throughput and not isinstance(provisioned_throughput, int):
            raise TypeError("Expected argument 'provisioned_throughput' to be a int")
        pulumi.set(__self__, "provisioned_throughput", provisioned_throughput)
        if pulumi_labels and not isinstance(pulumi_labels, dict):
            raise TypeError("Expected argument 'pulumi_labels' to be a dict")
        pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if resource_policies and not isinstance(resource_policies, list):
            raise TypeError("Expected argument 'resource_policies' to be a list")
        pulumi.set(__self__, "resource_policies", resource_policies)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if size and not isinstance(size, int):
            raise TypeError("Expected argument 'size' to be a int")
        pulumi.set(__self__, "size", size)
        if snapshot and not isinstance(snapshot, str):
            raise TypeError("Expected argument 'snapshot' to be a str")
        pulumi.set(__self__, "snapshot", snapshot)
        if source_disk and not isinstance(source_disk, str):
            raise TypeError("Expected argument 'source_disk' to be a str")
        pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_id and not isinstance(source_disk_id, str):
            raise TypeError("Expected argument 'source_disk_id' to be a str")
        pulumi.set(__self__, "source_disk_id", source_disk_id)
        if source_image_encryption_keys and not isinstance(source_image_encryption_keys, list):
            raise TypeError("Expected argument 'source_image_encryption_keys' to be a list")
        pulumi.set(__self__, "source_image_encryption_keys", source_image_encryption_keys)
        if source_image_id and not isinstance(source_image_id, str):
            raise TypeError("Expected argument 'source_image_id' to be a str")
        pulumi.set(__self__, "source_image_id", source_image_id)
        if source_instant_snapshot and not isinstance(source_instant_snapshot, str):
            raise TypeError("Expected argument 'source_instant_snapshot' to be a str")
        pulumi.set(__self__, "source_instant_snapshot", source_instant_snapshot)
        if source_instant_snapshot_id and not isinstance(source_instant_snapshot_id, str):
            raise TypeError("Expected argument 'source_instant_snapshot_id' to be a str")
        pulumi.set(__self__, "source_instant_snapshot_id", source_instant_snapshot_id)
        if source_snapshot_encryption_keys and not isinstance(source_snapshot_encryption_keys, list):
            raise TypeError("Expected argument 'source_snapshot_encryption_keys' to be a list")
        pulumi.set(__self__, "source_snapshot_encryption_keys", source_snapshot_encryption_keys)
        if source_snapshot_id and not isinstance(source_snapshot_id, str):
            raise TypeError("Expected argument 'source_snapshot_id' to be a str")
        pulumi.set(__self__, "source_snapshot_id", source_snapshot_id)
        if source_storage_object and not isinstance(source_storage_object, str):
            raise TypeError("Expected argument 'source_storage_object' to be a str")
        pulumi.set(__self__, "source_storage_object", source_storage_object)
        if storage_pool and not isinstance(storage_pool, str):
            raise TypeError("Expected argument 'storage_pool' to be a str")
        pulumi.set(__self__, "storage_pool", storage_pool)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if users and not isinstance(users, list):
            raise TypeError("Expected argument 'users' to be a list")
        pulumi.set(__self__, "users", users)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> builtins.str:
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter
    def architecture(self) -> builtins.str:
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="asyncPrimaryDisks")
    def async_primary_disks(self) -> Sequence['outputs.GetDiskAsyncPrimaryDiskResult']:
        return pulumi.get(self, "async_primary_disks")

    @property
    @pulumi.getter(name="createSnapshotBeforeDestroy")
    def create_snapshot_before_destroy(self) -> builtins.bool:
        return pulumi.get(self, "create_snapshot_before_destroy")

    @property
    @pulumi.getter(name="createSnapshotBeforeDestroyPrefix")
    def create_snapshot_before_destroy_prefix(self) -> builtins.str:
        return pulumi.get(self, "create_snapshot_before_destroy_prefix")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> builtins.str:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskEncryptionKeys")
    def disk_encryption_keys(self) -> Sequence['outputs.GetDiskDiskEncryptionKeyResult']:
        return pulumi.get(self, "disk_encryption_keys")

    @property
    @pulumi.getter(name="diskId")
    def disk_id(self) -> builtins.str:
        return pulumi.get(self, "disk_id")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> builtins.bool:
        return pulumi.get(self, "enable_confidential_compute")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Sequence['outputs.GetDiskGuestOsFeatureResult']:
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> builtins.str:
        """
        The image from which to initialize this disk.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def interface(self) -> builtins.str:
        return pulumi.get(self, "interface")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> builtins.str:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, builtins.str]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastAttachTimestamp")
    def last_attach_timestamp(self) -> builtins.str:
        """
        Last attach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_attach_timestamp")

    @property
    @pulumi.getter(name="lastDetachTimestamp")
    def last_detach_timestamp(self) -> builtins.str:
        """
        Last detach timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_detach_timestamp")

    @property
    @pulumi.getter
    def licenses(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter(name="multiWriter")
    def multi_writer(self) -> builtins.bool:
        return pulumi.get(self, "multi_writer")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def params(self) -> Sequence['outputs.GetDiskParamResult']:
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="physicalBlockSizeBytes")
    def physical_block_size_bytes(self) -> builtins.int:
        """
        Physical block size of the persistent disk, in bytes.
        """
        return pulumi.get(self, "physical_block_size_bytes")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="provisionedIops")
    def provisioned_iops(self) -> builtins.int:
        return pulumi.get(self, "provisioned_iops")

    @property
    @pulumi.getter(name="provisionedThroughput")
    def provisioned_throughput(self) -> builtins.int:
        return pulumi.get(self, "provisioned_throughput")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Mapping[str, builtins.str]:
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def size(self) -> builtins.int:
        """
        Size of the persistent disk, specified in GB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def snapshot(self) -> builtins.str:
        """
        The source snapshot used to create this disk.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> builtins.str:
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="sourceDiskId")
    def source_disk_id(self) -> builtins.str:
        return pulumi.get(self, "source_disk_id")

    @property
    @pulumi.getter(name="sourceImageEncryptionKeys")
    def source_image_encryption_keys(self) -> Sequence['outputs.GetDiskSourceImageEncryptionKeyResult']:
        """
        The customer-supplied encryption key of the source image.
        """
        return pulumi.get(self, "source_image_encryption_keys")

    @property
    @pulumi.getter(name="sourceImageId")
    def source_image_id(self) -> builtins.str:
        """
        The ID value of the image used to create this disk. This value
        identifies the exact image that was used to create this persistent
        disk. For example, if you created the persistent disk from an image
        that was later deleted and recreated under the same name, the source
        image ID would identify the exact version of the image that was used.
        """
        return pulumi.get(self, "source_image_id")

    @property
    @pulumi.getter(name="sourceInstantSnapshot")
    def source_instant_snapshot(self) -> builtins.str:
        return pulumi.get(self, "source_instant_snapshot")

    @property
    @pulumi.getter(name="sourceInstantSnapshotId")
    def source_instant_snapshot_id(self) -> builtins.str:
        return pulumi.get(self, "source_instant_snapshot_id")

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKeys")
    def source_snapshot_encryption_keys(self) -> Sequence['outputs.GetDiskSourceSnapshotEncryptionKeyResult']:
        """
        The customer-supplied encryption key of the source snapshot.
        """
        return pulumi.get(self, "source_snapshot_encryption_keys")

    @property
    @pulumi.getter(name="sourceSnapshotId")
    def source_snapshot_id(self) -> builtins.str:
        """
        The unique ID of the snapshot used to create this disk. This value
        identifies the exact snapshot that was used to create this persistent
        disk. For example, if you created the persistent disk from a snapshot
        that was later deleted and recreated under the same name, the source
        snapshot ID would identify the exact version of the snapshot that was
        used.
        """
        return pulumi.get(self, "source_snapshot_id")

    @property
    @pulumi.getter(name="sourceStorageObject")
    def source_storage_object(self) -> builtins.str:
        return pulumi.get(self, "source_storage_object")

    @property
    @pulumi.getter(name="storagePool")
    def storage_pool(self) -> builtins.str:
        return pulumi.get(self, "storage_pool")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        URL of the disk type resource describing which disk type to use to
        create the disk.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def users(self) -> Sequence[builtins.str]:
        """
        Links to the users of the disk (attached instances) in form:
        project/zones/zone/instances/instance
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def zone(self) -> Optional[builtins.str]:
        """
        A reference to the zone where the disk resides.
        """
        return pulumi.get(self, "zone")


class AwaitableGetDiskResult(GetDiskResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDiskResult(
            access_mode=self.access_mode,
            architecture=self.architecture,
            async_primary_disks=self.async_primary_disks,
            create_snapshot_before_destroy=self.create_snapshot_before_destroy,
            create_snapshot_before_destroy_prefix=self.create_snapshot_before_destroy_prefix,
            creation_timestamp=self.creation_timestamp,
            description=self.description,
            disk_encryption_keys=self.disk_encryption_keys,
            disk_id=self.disk_id,
            effective_labels=self.effective_labels,
            enable_confidential_compute=self.enable_confidential_compute,
            guest_os_features=self.guest_os_features,
            id=self.id,
            image=self.image,
            interface=self.interface,
            label_fingerprint=self.label_fingerprint,
            labels=self.labels,
            last_attach_timestamp=self.last_attach_timestamp,
            last_detach_timestamp=self.last_detach_timestamp,
            licenses=self.licenses,
            multi_writer=self.multi_writer,
            name=self.name,
            params=self.params,
            physical_block_size_bytes=self.physical_block_size_bytes,
            project=self.project,
            provisioned_iops=self.provisioned_iops,
            provisioned_throughput=self.provisioned_throughput,
            pulumi_labels=self.pulumi_labels,
            resource_policies=self.resource_policies,
            self_link=self.self_link,
            size=self.size,
            snapshot=self.snapshot,
            source_disk=self.source_disk,
            source_disk_id=self.source_disk_id,
            source_image_encryption_keys=self.source_image_encryption_keys,
            source_image_id=self.source_image_id,
            source_instant_snapshot=self.source_instant_snapshot,
            source_instant_snapshot_id=self.source_instant_snapshot_id,
            source_snapshot_encryption_keys=self.source_snapshot_encryption_keys,
            source_snapshot_id=self.source_snapshot_id,
            source_storage_object=self.source_storage_object,
            storage_pool=self.storage_pool,
            type=self.type,
            users=self.users,
            zone=self.zone)


def get_disk(name: Optional[builtins.str] = None,
             project: Optional[builtins.str] = None,
             zone: Optional[builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDiskResult:
    """
    Get information about a Google Compute Persistent disks.

    [the official documentation](https://cloud.google.com/compute/docs/disks) and its [API](https://cloud.google.com/compute/docs/reference/latest/disks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    persistent_boot_disk = gcp.compute.get_disk(name="persistent-boot-disk",
        project="example")
    default = gcp.compute.Instance("default", boot_disk={
        "source": persistent_boot_disk.self_link,
        "auto_delete": False,
    })
    ```


    :param builtins.str name: The name of a specific disk.
           
           - - -
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param builtins.str zone: A reference to the zone where the disk resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getDisk:getDisk', __args__, opts=opts, typ=GetDiskResult).value

    return AwaitableGetDiskResult(
        access_mode=pulumi.get(__ret__, 'access_mode'),
        architecture=pulumi.get(__ret__, 'architecture'),
        async_primary_disks=pulumi.get(__ret__, 'async_primary_disks'),
        create_snapshot_before_destroy=pulumi.get(__ret__, 'create_snapshot_before_destroy'),
        create_snapshot_before_destroy_prefix=pulumi.get(__ret__, 'create_snapshot_before_destroy_prefix'),
        creation_timestamp=pulumi.get(__ret__, 'creation_timestamp'),
        description=pulumi.get(__ret__, 'description'),
        disk_encryption_keys=pulumi.get(__ret__, 'disk_encryption_keys'),
        disk_id=pulumi.get(__ret__, 'disk_id'),
        effective_labels=pulumi.get(__ret__, 'effective_labels'),
        enable_confidential_compute=pulumi.get(__ret__, 'enable_confidential_compute'),
        guest_os_features=pulumi.get(__ret__, 'guest_os_features'),
        id=pulumi.get(__ret__, 'id'),
        image=pulumi.get(__ret__, 'image'),
        interface=pulumi.get(__ret__, 'interface'),
        label_fingerprint=pulumi.get(__ret__, 'label_fingerprint'),
        labels=pulumi.get(__ret__, 'labels'),
        last_attach_timestamp=pulumi.get(__ret__, 'last_attach_timestamp'),
        last_detach_timestamp=pulumi.get(__ret__, 'last_detach_timestamp'),
        licenses=pulumi.get(__ret__, 'licenses'),
        multi_writer=pulumi.get(__ret__, 'multi_writer'),
        name=pulumi.get(__ret__, 'name'),
        params=pulumi.get(__ret__, 'params'),
        physical_block_size_bytes=pulumi.get(__ret__, 'physical_block_size_bytes'),
        project=pulumi.get(__ret__, 'project'),
        provisioned_iops=pulumi.get(__ret__, 'provisioned_iops'),
        provisioned_throughput=pulumi.get(__ret__, 'provisioned_throughput'),
        pulumi_labels=pulumi.get(__ret__, 'pulumi_labels'),
        resource_policies=pulumi.get(__ret__, 'resource_policies'),
        self_link=pulumi.get(__ret__, 'self_link'),
        size=pulumi.get(__ret__, 'size'),
        snapshot=pulumi.get(__ret__, 'snapshot'),
        source_disk=pulumi.get(__ret__, 'source_disk'),
        source_disk_id=pulumi.get(__ret__, 'source_disk_id'),
        source_image_encryption_keys=pulumi.get(__ret__, 'source_image_encryption_keys'),
        source_image_id=pulumi.get(__ret__, 'source_image_id'),
        source_instant_snapshot=pulumi.get(__ret__, 'source_instant_snapshot'),
        source_instant_snapshot_id=pulumi.get(__ret__, 'source_instant_snapshot_id'),
        source_snapshot_encryption_keys=pulumi.get(__ret__, 'source_snapshot_encryption_keys'),
        source_snapshot_id=pulumi.get(__ret__, 'source_snapshot_id'),
        source_storage_object=pulumi.get(__ret__, 'source_storage_object'),
        storage_pool=pulumi.get(__ret__, 'storage_pool'),
        type=pulumi.get(__ret__, 'type'),
        users=pulumi.get(__ret__, 'users'),
        zone=pulumi.get(__ret__, 'zone'))
def get_disk_output(name: Optional[pulumi.Input[builtins.str]] = None,
                    project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDiskResult]:
    """
    Get information about a Google Compute Persistent disks.

    [the official documentation](https://cloud.google.com/compute/docs/disks) and its [API](https://cloud.google.com/compute/docs/reference/latest/disks).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    persistent_boot_disk = gcp.compute.get_disk(name="persistent-boot-disk",
        project="example")
    default = gcp.compute.Instance("default", boot_disk={
        "source": persistent_boot_disk.self_link,
        "auto_delete": False,
    })
    ```


    :param builtins.str name: The name of a specific disk.
           
           - - -
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the provider project is used.
    :param builtins.str zone: A reference to the zone where the disk resides.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getDisk:getDisk', __args__, opts=opts, typ=GetDiskResult)
    return __ret__.apply(lambda __response__: GetDiskResult(
        access_mode=pulumi.get(__response__, 'access_mode'),
        architecture=pulumi.get(__response__, 'architecture'),
        async_primary_disks=pulumi.get(__response__, 'async_primary_disks'),
        create_snapshot_before_destroy=pulumi.get(__response__, 'create_snapshot_before_destroy'),
        create_snapshot_before_destroy_prefix=pulumi.get(__response__, 'create_snapshot_before_destroy_prefix'),
        creation_timestamp=pulumi.get(__response__, 'creation_timestamp'),
        description=pulumi.get(__response__, 'description'),
        disk_encryption_keys=pulumi.get(__response__, 'disk_encryption_keys'),
        disk_id=pulumi.get(__response__, 'disk_id'),
        effective_labels=pulumi.get(__response__, 'effective_labels'),
        enable_confidential_compute=pulumi.get(__response__, 'enable_confidential_compute'),
        guest_os_features=pulumi.get(__response__, 'guest_os_features'),
        id=pulumi.get(__response__, 'id'),
        image=pulumi.get(__response__, 'image'),
        interface=pulumi.get(__response__, 'interface'),
        label_fingerprint=pulumi.get(__response__, 'label_fingerprint'),
        labels=pulumi.get(__response__, 'labels'),
        last_attach_timestamp=pulumi.get(__response__, 'last_attach_timestamp'),
        last_detach_timestamp=pulumi.get(__response__, 'last_detach_timestamp'),
        licenses=pulumi.get(__response__, 'licenses'),
        multi_writer=pulumi.get(__response__, 'multi_writer'),
        name=pulumi.get(__response__, 'name'),
        params=pulumi.get(__response__, 'params'),
        physical_block_size_bytes=pulumi.get(__response__, 'physical_block_size_bytes'),
        project=pulumi.get(__response__, 'project'),
        provisioned_iops=pulumi.get(__response__, 'provisioned_iops'),
        provisioned_throughput=pulumi.get(__response__, 'provisioned_throughput'),
        pulumi_labels=pulumi.get(__response__, 'pulumi_labels'),
        resource_policies=pulumi.get(__response__, 'resource_policies'),
        self_link=pulumi.get(__response__, 'self_link'),
        size=pulumi.get(__response__, 'size'),
        snapshot=pulumi.get(__response__, 'snapshot'),
        source_disk=pulumi.get(__response__, 'source_disk'),
        source_disk_id=pulumi.get(__response__, 'source_disk_id'),
        source_image_encryption_keys=pulumi.get(__response__, 'source_image_encryption_keys'),
        source_image_id=pulumi.get(__response__, 'source_image_id'),
        source_instant_snapshot=pulumi.get(__response__, 'source_instant_snapshot'),
        source_instant_snapshot_id=pulumi.get(__response__, 'source_instant_snapshot_id'),
        source_snapshot_encryption_keys=pulumi.get(__response__, 'source_snapshot_encryption_keys'),
        source_snapshot_id=pulumi.get(__response__, 'source_snapshot_id'),
        source_storage_object=pulumi.get(__response__, 'source_storage_object'),
        storage_pool=pulumi.get(__response__, 'storage_pool'),
        type=pulumi.get(__response__, 'type'),
        users=pulumi.get(__response__, 'users'),
        zone=pulumi.get(__response__, 'zone')))
