# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstanceGuestAttributesResult',
    'AwaitableGetInstanceGuestAttributesResult',
    'get_instance_guest_attributes',
    'get_instance_guest_attributes_output',
]

@pulumi.output_type
class GetInstanceGuestAttributesResult:
    """
    A collection of values returned by getInstanceGuestAttributes.
    """
    def __init__(__self__, id=None, name=None, project=None, query_path=None, query_values=None, region=None, variable_key=None, variable_value=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if query_path and not isinstance(query_path, str):
            raise TypeError("Expected argument 'query_path' to be a str")
        pulumi.set(__self__, "query_path", query_path)
        if query_values and not isinstance(query_values, list):
            raise TypeError("Expected argument 'query_values' to be a list")
        pulumi.set(__self__, "query_values", query_values)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if variable_key and not isinstance(variable_key, str):
            raise TypeError("Expected argument 'variable_key' to be a str")
        pulumi.set(__self__, "variable_key", variable_key)
        if variable_value and not isinstance(variable_value, str):
            raise TypeError("Expected argument 'variable_value' to be a str")
        pulumi.set(__self__, "variable_value", variable_value)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="queryPath")
    def query_path(self) -> Optional[builtins.str]:
        return pulumi.get(self, "query_path")

    @property
    @pulumi.getter(name="queryValues")
    def query_values(self) -> Sequence['outputs.GetInstanceGuestAttributesQueryValueResult']:
        """
        Structure is documented below.
        """
        return pulumi.get(self, "query_values")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="variableKey")
    def variable_key(self) -> Optional[builtins.str]:
        return pulumi.get(self, "variable_key")

    @property
    @pulumi.getter(name="variableValue")
    def variable_value(self) -> builtins.str:
        """
        Value of the queried guest_attribute.
        """
        return pulumi.get(self, "variable_value")

    @property
    @pulumi.getter
    def zone(self) -> builtins.str:
        return pulumi.get(self, "zone")


class AwaitableGetInstanceGuestAttributesResult(GetInstanceGuestAttributesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstanceGuestAttributesResult(
            id=self.id,
            name=self.name,
            project=self.project,
            query_path=self.query_path,
            query_values=self.query_values,
            region=self.region,
            variable_key=self.variable_key,
            variable_value=self.variable_value,
            zone=self.zone)


def get_instance_guest_attributes(name: Optional[builtins.str] = None,
                                  project: Optional[builtins.str] = None,
                                  query_path: Optional[builtins.str] = None,
                                  region: Optional[builtins.str] = None,
                                  variable_key: Optional[builtins.str] = None,
                                  zone: Optional[builtins.str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstanceGuestAttributesResult:
    """
    Get information about a VM instance resource within GCE. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/instances)
    and
    [API](https://cloud.google.com/compute/docs/reference/latest/instances).

    Get information about VM's guest attrubutes. For more information see [the official documentation](https://cloud.google.com/compute/docs/metadata/manage-guest-attributes)
    and
    [API](https://cloud.google.com/compute/docs/reference/rest/v1/instances/getGuestAttributes).

    ## Example Usage

    ### Get All Attributes From A Single Namespace

    ```python
    import pulumi
    import pulumi_gcp as gcp

    appserver_ga = gcp.compute.get_instance_guest_attributes(name="primary-application-server",
        zone="us-central1-a",
        query_path="variables/")
    ```

    ### Get A Specific Variable

    ```python
    import pulumi
    import pulumi_gcp as gcp

    appserver_ga = gcp.compute.get_instance_guest_attributes(name="primary-application-server",
        zone="us-central1-a",
        variable_key="variables/key1")
    ```


    :param builtins.str name: The name or self_link of the instance.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If `self_link` is provided, this value is ignored.  If neither `self_link`
           nor `project` are provided, the provider project is used.
    :param builtins.str query_path: Path to query for the guest attributes. Consists of
           `namespace` name for the attributes followed with a `/`.
    :param builtins.str variable_key: Key of a variable to get the value of. Consists of
           `namespace` name and `key` name for the variable separated by a `/`.
    :param builtins.str zone: The zone of the instance. If `self_link` is provided, this
           value is ignored.  If neither `self_link` nor `zone` are provided, the
           provider zone is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['queryPath'] = query_path
    __args__['region'] = region
    __args__['variableKey'] = variable_key
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getInstanceGuestAttributes:getInstanceGuestAttributes', __args__, opts=opts, typ=GetInstanceGuestAttributesResult).value

    return AwaitableGetInstanceGuestAttributesResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        project=pulumi.get(__ret__, 'project'),
        query_path=pulumi.get(__ret__, 'query_path'),
        query_values=pulumi.get(__ret__, 'query_values'),
        region=pulumi.get(__ret__, 'region'),
        variable_key=pulumi.get(__ret__, 'variable_key'),
        variable_value=pulumi.get(__ret__, 'variable_value'),
        zone=pulumi.get(__ret__, 'zone'))
def get_instance_guest_attributes_output(name: Optional[pulumi.Input[builtins.str]] = None,
                                         project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         query_path: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         variable_key: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         zone: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstanceGuestAttributesResult]:
    """
    Get information about a VM instance resource within GCE. For more information see
    [the official documentation](https://cloud.google.com/compute/docs/instances)
    and
    [API](https://cloud.google.com/compute/docs/reference/latest/instances).

    Get information about VM's guest attrubutes. For more information see [the official documentation](https://cloud.google.com/compute/docs/metadata/manage-guest-attributes)
    and
    [API](https://cloud.google.com/compute/docs/reference/rest/v1/instances/getGuestAttributes).

    ## Example Usage

    ### Get All Attributes From A Single Namespace

    ```python
    import pulumi
    import pulumi_gcp as gcp

    appserver_ga = gcp.compute.get_instance_guest_attributes(name="primary-application-server",
        zone="us-central1-a",
        query_path="variables/")
    ```

    ### Get A Specific Variable

    ```python
    import pulumi
    import pulumi_gcp as gcp

    appserver_ga = gcp.compute.get_instance_guest_attributes(name="primary-application-server",
        zone="us-central1-a",
        variable_key="variables/key1")
    ```


    :param builtins.str name: The name or self_link of the instance.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If `self_link` is provided, this value is ignored.  If neither `self_link`
           nor `project` are provided, the provider project is used.
    :param builtins.str query_path: Path to query for the guest attributes. Consists of
           `namespace` name for the attributes followed with a `/`.
    :param builtins.str variable_key: Key of a variable to get the value of. Consists of
           `namespace` name and `key` name for the variable separated by a `/`.
    :param builtins.str zone: The zone of the instance. If `self_link` is provided, this
           value is ignored.  If neither `self_link` nor `zone` are provided, the
           provider zone is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['queryPath'] = query_path
    __args__['region'] = region
    __args__['variableKey'] = variable_key
    __args__['zone'] = zone
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getInstanceGuestAttributes:getInstanceGuestAttributes', __args__, opts=opts, typ=GetInstanceGuestAttributesResult)
    return __ret__.apply(lambda __response__: GetInstanceGuestAttributesResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        project=pulumi.get(__response__, 'project'),
        query_path=pulumi.get(__response__, 'query_path'),
        query_values=pulumi.get(__response__, 'query_values'),
        region=pulumi.get(__response__, 'region'),
        variable_key=pulumi.get(__response__, 'variable_key'),
        variable_value=pulumi.get(__response__, 'variable_value'),
        zone=pulumi.get(__response__, 'zone')))
