# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkResult',
    'AwaitableGetNetworkResult',
    'get_network',
    'get_network_output',
]

@pulumi.output_type
class GetNetworkResult:
    """
    A collection of values returned by getNetwork.
    """
    def __init__(__self__, description=None, gateway_ipv4=None, id=None, internal_ipv6_range=None, name=None, network_id=None, network_profile=None, numeric_id=None, project=None, self_link=None, subnetworks_self_links=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if gateway_ipv4 and not isinstance(gateway_ipv4, str):
            raise TypeError("Expected argument 'gateway_ipv4' to be a str")
        pulumi.set(__self__, "gateway_ipv4", gateway_ipv4)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_ipv6_range and not isinstance(internal_ipv6_range, str):
            raise TypeError("Expected argument 'internal_ipv6_range' to be a str")
        pulumi.set(__self__, "internal_ipv6_range", internal_ipv6_range)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, int):
            raise TypeError("Expected argument 'network_id' to be a int")
        pulumi.set(__self__, "network_id", network_id)
        if network_profile and not isinstance(network_profile, str):
            raise TypeError("Expected argument 'network_profile' to be a str")
        pulumi.set(__self__, "network_profile", network_profile)
        if numeric_id and not isinstance(numeric_id, str):
            raise TypeError("Expected argument 'numeric_id' to be a str")
        pulumi.set(__self__, "numeric_id", numeric_id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)
        if subnetworks_self_links and not isinstance(subnetworks_self_links, list):
            raise TypeError("Expected argument 'subnetworks_self_links' to be a list")
        pulumi.set(__self__, "subnetworks_self_links", subnetworks_self_links)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        Description of this network.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="gatewayIpv4")
    def gateway_ipv4(self) -> builtins.str:
        """
        The IP address of the gateway.
        """
        return pulumi.get(self, "gateway_ipv4")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalIpv6Range")
    def internal_ipv6_range(self) -> builtins.str:
        """
        The ula internal ipv6 range assigned to this network.
        """
        return pulumi.get(self, "internal_ipv6_range")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> builtins.int:
        """
        The numeric unique identifier for the resource.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> Optional[builtins.str]:
        """
        A full or partial URL of the network profile to apply to this network.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="numericId")
    @_utilities.deprecated("""`numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.""")
    def numeric_id(self) -> builtins.str:
        """
        (Deprecated) The numeric unique identifier for the resource. `numeric_id` is deprecated and will be removed in a future major release. Use `network_id` instead.
        """
        return pulumi.get(self, "numeric_id")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        The URI of the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="subnetworksSelfLinks")
    def subnetworks_self_links(self) -> Sequence[builtins.str]:
        """
        the list of subnetworks which belong to the network
        """
        return pulumi.get(self, "subnetworks_self_links")


class AwaitableGetNetworkResult(GetNetworkResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkResult(
            description=self.description,
            gateway_ipv4=self.gateway_ipv4,
            id=self.id,
            internal_ipv6_range=self.internal_ipv6_range,
            name=self.name,
            network_id=self.network_id,
            network_profile=self.network_profile,
            numeric_id=self.numeric_id,
            project=self.project,
            self_link=self.self_link,
            subnetworks_self_links=self.subnetworks_self_links)


def get_network(name: Optional[builtins.str] = None,
                network_profile: Optional[builtins.str] = None,
                project: Optional[builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkResult:
    """
    Get a network within GCE from its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_network = gcp.compute.get_network(name="default-us-east1")
    ```


    :param builtins.str name: The name of the network.
           
           
           - - -
    :param builtins.str network_profile: A full or partial URL of the network profile to apply to this network.
    :param builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkProfile'] = network_profile
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult).value

    return AwaitableGetNetworkResult(
        description=pulumi.get(__ret__, 'description'),
        gateway_ipv4=pulumi.get(__ret__, 'gateway_ipv4'),
        id=pulumi.get(__ret__, 'id'),
        internal_ipv6_range=pulumi.get(__ret__, 'internal_ipv6_range'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        network_profile=pulumi.get(__ret__, 'network_profile'),
        numeric_id=pulumi.get(__ret__, 'numeric_id'),
        project=pulumi.get(__ret__, 'project'),
        self_link=pulumi.get(__ret__, 'self_link'),
        subnetworks_self_links=pulumi.get(__ret__, 'subnetworks_self_links'))
def get_network_output(name: Optional[pulumi.Input[builtins.str]] = None,
                       network_profile: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkResult]:
    """
    Get a network within GCE from its name.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_network = gcp.compute.get_network(name="default-us-east1")
    ```


    :param builtins.str name: The name of the network.
           
           
           - - -
    :param builtins.str network_profile: A full or partial URL of the network profile to apply to this network.
    :param builtins.str project: The ID of the project in which the resource belongs. If it
           is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['networkProfile'] = network_profile
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getNetwork:getNetwork', __args__, opts=opts, typ=GetNetworkResult)
    return __ret__.apply(lambda __response__: GetNetworkResult(
        description=pulumi.get(__response__, 'description'),
        gateway_ipv4=pulumi.get(__response__, 'gateway_ipv4'),
        id=pulumi.get(__response__, 'id'),
        internal_ipv6_range=pulumi.get(__response__, 'internal_ipv6_range'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        network_profile=pulumi.get(__response__, 'network_profile'),
        numeric_id=pulumi.get(__response__, 'numeric_id'),
        project=pulumi.get(__response__, 'project'),
        self_link=pulumi.get(__response__, 'self_link'),
        subnetworks_self_links=pulumi.get(__response__, 'subnetworks_self_links')))
