# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworksResult',
    'AwaitableGetNetworksResult',
    'get_networks',
    'get_networks_output',
]

@pulumi.output_type
class GetNetworksResult:
    """
    A collection of values returned by getNetworks.
    """
    def __init__(__self__, id=None, networks=None, project=None, self_link=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if networks and not isinstance(networks, list):
            raise TypeError("Expected argument 'networks' to be a list")
        pulumi.set(__self__, "networks", networks)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if self_link and not isinstance(self_link, str):
            raise TypeError("Expected argument 'self_link' to be a str")
        pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def networks(self) -> Sequence[builtins.str]:
        """
        The list of networks in the specified project.
        """
        return pulumi.get(self, "networks")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        """
        The project name being queried.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> builtins.str:
        """
        The URI of the resource.
        """
        return pulumi.get(self, "self_link")


class AwaitableGetNetworksResult(GetNetworksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworksResult(
            id=self.id,
            networks=self.networks,
            project=self.project,
            self_link=self.self_link)


def get_networks(project: Optional[builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworksResult:
    """
    List all networks in a specified Google Cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_networks = gcp.compute.get_networks(project="my-cloud-project")
    ```


    :param builtins.str project: The name of the project.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:compute/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult).value

    return AwaitableGetNetworksResult(
        id=pulumi.get(__ret__, 'id'),
        networks=pulumi.get(__ret__, 'networks'),
        project=pulumi.get(__ret__, 'project'),
        self_link=pulumi.get(__ret__, 'self_link'))
def get_networks_output(project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworksResult]:
    """
    List all networks in a specified Google Cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    my_networks = gcp.compute.get_networks(project="my-cloud-project")
    ```


    :param builtins.str project: The name of the project.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:compute/getNetworks:getNetworks', __args__, opts=opts, typ=GetNetworksResult)
    return __ret__.apply(lambda __response__: GetNetworksResult(
        id=pulumi.get(__response__, 'id'),
        networks=pulumi.get(__response__, 'networks'),
        project=pulumi.get(__response__, 'project'),
        self_link=pulumi.get(__response__, 'self_link')))
