# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GlobalAddressArgs', 'GlobalAddress']

@pulumi.input_type
class GlobalAddressArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 address_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a GlobalAddress resource.
        :param pulumi.Input[builtins.str] address: The IP address or beginning of the address range represented by this
               resource. This can be supplied as an input to reserve a specific
               address or omitted to allow GCP to choose a valid one for you.
        :param pulumi.Input[builtins.str] address_type: The type of the address to reserve.
               * EXTERNAL indicates public/external single IP address.
               * INTERNAL indicates internal IP ranges belonging to some network.
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this address. The default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this address.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The URL of the network in which to reserve the IP range. The IP range
               must be in RFC1918 space. The network cannot be deleted if there are
               any reserved IP ranges referring to it.
               This should only be set when using an Internal address.
        :param pulumi.Input[builtins.int] prefix_length: The prefix length of the IP range. If not present, it means the
               address field is a single IP address.
               This field is not applicable to addresses with addressType=INTERNAL
               when purpose=PRIVATE_SERVICE_CONNECT
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] purpose: The purpose of the resource. Possible values include:
               * VPC_PEERING - for peer networks
               * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address or beginning of the address range represented by this
        resource. This can be supplied as an input to reserve a specific
        address or omitted to allow GCP to choose a valid one for you.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the address to reserve.
        * EXTERNAL indicates public/external single IP address.
        * INTERNAL indicates internal IP ranges belonging to some network.
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version that will be used by this address. The default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the network in which to reserve the IP range. The IP range
        must be in RFC1918 space. The network cannot be deleted if there are
        any reserved IP ranges referring to it.
        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The prefix length of the IP range. If not present, it means the
        address field is a single IP address.
        This field is not applicable to addresses with addressType=INTERNAL
        when purpose=PRIVATE_SERVICE_CONNECT
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The purpose of the resource. Possible values include:
        * VPC_PEERING - for peer networks
        * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose", value)


@pulumi.input_type
class _GlobalAddressState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 address_type: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering GlobalAddress resources.
        :param pulumi.Input[builtins.str] address: The IP address or beginning of the address range represented by this
               resource. This can be supplied as an input to reserve a specific
               address or omitted to allow GCP to choose a valid one for you.
        :param pulumi.Input[builtins.str] address_type: The type of the address to reserve.
               * EXTERNAL indicates public/external single IP address.
               * INTERNAL indicates internal IP ranges belonging to some network.
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this address. The default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this address.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The URL of the network in which to reserve the IP range. The IP range
               must be in RFC1918 space. The network cannot be deleted if there are
               any reserved IP ranges referring to it.
               This should only be set when using an Internal address.
        :param pulumi.Input[builtins.int] prefix_length: The prefix length of the IP range. If not present, it means the
               address field is a single IP address.
               This field is not applicable to addresses with addressType=INTERNAL
               when purpose=PRIVATE_SERVICE_CONNECT
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] purpose: The purpose of the resource. Possible values include:
               * VPC_PEERING - for peer networks
               * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if prefix_length is not None:
            pulumi.set(__self__, "prefix_length", prefix_length)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address or beginning of the address range represented by this
        resource. This can be supplied as an input to reserve a specific
        address or omitted to allow GCP to choose a valid one for you.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the address to reserve.
        * EXTERNAL indicates public/external single IP address.
        * INTERNAL indicates internal IP ranges belonging to some network.
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "address_type", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP Version that will be used by this address. The default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of the network in which to reserve the IP range. The IP range
        must be in RFC1918 space. The network cannot be deleted if there are
        any reserved IP ranges referring to it.
        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The prefix length of the IP range. If not present, it means the
        address field is a single IP address.
        This field is not applicable to addresses with addressType=INTERNAL
        when purpose=PRIVATE_SERVICE_CONNECT
        """
        return pulumi.get(self, "prefix_length")

    @prefix_length.setter
    def prefix_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "prefix_length", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The purpose of the resource. Possible values include:
        * VPC_PEERING - for peer networks
        * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "purpose", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)


@pulumi.type_token("gcp:compute/globalAddress:GlobalAddress")
class GlobalAddress(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 address_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a Global Address resource. Global addresses are used for
        HTTP(S) load balancing.

        To get more information about GlobalAddress, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/globalAddresses)
        * How-to Guides
            * [Reserving a Static External IP Address](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-external-ip-address)

        ## Example Usage

        ### Global Address Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.GlobalAddress("default", name="global-appserver-ip")
        ```
        ### Global Address Private Services Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-network-name",
            auto_create_subnetworks=False)
        default = gcp.compute.GlobalAddress("default",
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.105")
        ```

        ## Import

        GlobalAddress can be imported using any of these accepted formats:

        * `projects/{{project}}/global/addresses/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, GlobalAddress can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default projects/{{project}}/global/addresses/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The IP address or beginning of the address range represented by this
               resource. This can be supplied as an input to reserve a specific
               address or omitted to allow GCP to choose a valid one for you.
        :param pulumi.Input[builtins.str] address_type: The type of the address to reserve.
               * EXTERNAL indicates public/external single IP address.
               * INTERNAL indicates internal IP ranges belonging to some network.
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this address. The default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this address.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The URL of the network in which to reserve the IP range. The IP range
               must be in RFC1918 space. The network cannot be deleted if there are
               any reserved IP ranges referring to it.
               This should only be set when using an Internal address.
        :param pulumi.Input[builtins.int] prefix_length: The prefix length of the IP range. If not present, it means the
               address field is a single IP address.
               This field is not applicable to addresses with addressType=INTERNAL
               when purpose=PRIVATE_SERVICE_CONNECT
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] purpose: The purpose of the resource. Possible values include:
               * VPC_PEERING - for peer networks
               * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GlobalAddressArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Global Address resource. Global addresses are used for
        HTTP(S) load balancing.

        To get more information about GlobalAddress, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/globalAddresses)
        * How-to Guides
            * [Reserving a Static External IP Address](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-external-ip-address)

        ## Example Usage

        ### Global Address Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.GlobalAddress("default", name="global-appserver-ip")
        ```
        ### Global Address Private Services Connect

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="my-network-name",
            auto_create_subnetworks=False)
        default = gcp.compute.GlobalAddress("default",
            name="global-psconnect-ip",
            address_type="INTERNAL",
            purpose="PRIVATE_SERVICE_CONNECT",
            network=network.id,
            address="100.100.100.105")
        ```

        ## Import

        GlobalAddress can be imported using any of these accepted formats:

        * `projects/{{project}}/global/addresses/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, GlobalAddress can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default projects/{{project}}/global/addresses/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/globalAddress:GlobalAddress default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param GlobalAddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GlobalAddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[builtins.str]] = None,
                 address_type: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 ip_version: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 prefix_length: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 purpose: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GlobalAddressArgs.__new__(GlobalAddressArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["description"] = description
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["prefix_length"] = prefix_length
            __props__.__dict__["project"] = project
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(GlobalAddress, __self__).__init__(
            'gcp:compute/globalAddress:GlobalAddress',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[builtins.str]] = None,
            address_type: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            ip_version: Optional[pulumi.Input[builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            prefix_length: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            purpose: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None) -> 'GlobalAddress':
        """
        Get an existing GlobalAddress resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] address: The IP address or beginning of the address range represented by this
               resource. This can be supplied as an input to reserve a specific
               address or omitted to allow GCP to choose a valid one for you.
        :param pulumi.Input[builtins.str] address_type: The type of the address to reserve.
               * EXTERNAL indicates public/external single IP address.
               * INTERNAL indicates internal IP ranges belonging to some network.
               Default value is `EXTERNAL`.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] ip_version: The IP Version that will be used by this address. The default value is `IPV4`.
               Possible values are: `IPV4`, `IPV6`.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource.  Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this address.  A list of key->value pairs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The URL of the network in which to reserve the IP range. The IP range
               must be in RFC1918 space. The network cannot be deleted if there are
               any reserved IP ranges referring to it.
               This should only be set when using an Internal address.
        :param pulumi.Input[builtins.int] prefix_length: The prefix length of the IP range. If not present, it means the
               address field is a single IP address.
               This field is not applicable to addresses with addressType=INTERNAL
               when purpose=PRIVATE_SERVICE_CONNECT
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] purpose: The purpose of the resource. Possible values include:
               * VPC_PEERING - for peer networks
               * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GlobalAddressState.__new__(_GlobalAddressState)

        __props__.__dict__["address"] = address
        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["prefix_length"] = prefix_length
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["self_link"] = self_link
        return GlobalAddress(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[builtins.str]:
        """
        The IP address or beginning of the address range represented by this
        resource. This can be supplied as an input to reserve a specific
        address or omitted to allow GCP to choose a valid one for you.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of the address to reserve.
        * EXTERNAL indicates public/external single IP address.
        * INTERNAL indicates internal IP ranges belonging to some network.
        Default value is `EXTERNAL`.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "address_type")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP Version that will be used by this address. The default value is `IPV4`.
        Possible values are: `IPV4`, `IPV6`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource.  Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels to apply to this address.  A list of key->value pairs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL of the network in which to reserve the IP range. The IP range
        must be in RFC1918 space. The network cannot be deleted if there are
        any reserved IP ranges referring to it.
        This should only be set when using an Internal address.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="prefixLength")
    def prefix_length(self) -> pulumi.Output[builtins.int]:
        """
        The prefix length of the IP range. If not present, it means the
        address field is a single IP address.
        This field is not applicable to addresses with addressType=INTERNAL
        when purpose=PRIVATE_SERVICE_CONNECT
        """
        return pulumi.get(self, "prefix_length")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The purpose of the resource. Possible values include:
        * VPC_PEERING - for peer networks
        * PRIVATE_SERVICE_CONNECT - for  Private Service Connect networks
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

