# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]] = None,
                 image_encryption_key: Optional[pulumi.Input['ImageImageEncryptionKeyArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 raw_disk: Optional[pulumi.Input['ImageRawDiskArgs']] = None,
                 shielded_instance_initial_state: Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']] = None,
                 source_disk: Optional[pulumi.Input[builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']] = None,
                 source_image: Optional[pulumi.Input[builtins.str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']] = None,
                 source_snapshot: Optional[pulumi.Input[builtins.str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.int] disk_size_gb: Size of the image when restored onto a persistent disk (in GB).
        :param pulumi.Input[builtins.str] family: The name of the image family to which this image belongs. You can
               create disks by specifying an image family instead of a specific
               image name. The image family always returns its latest image that is
               not deprecated. The name of the image family must comply with
               RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable images.
               Structure is documented below.
        :param pulumi.Input['ImageImageEncryptionKeyArgs'] image_encryption_key: Encrypts the image using a customer-supplied encryption key.
               After you encrypt an image with a customer-supplied key, you must
               provide the same key if you use the image later (e.g. to create a
               disk from the image)
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this Image.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] licenses: Any applicable license URI.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ImageRawDiskArgs'] raw_disk: The parameters of the raw disk image.
               Structure is documented below.
        :param pulumi.Input['ImageShieldedInstanceInitialStateArgs'] shielded_instance_initial_state: Set the secure boot keys of shielded instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_disk: The source disk to create this image based on.
               You must provide either this property or the
               rawDisk.source property but not both to create an image.
        :param pulumi.Input['ImageSourceDiskEncryptionKeyArgs'] source_disk_encryption_key: The customer-supplied encryption key of the source disk. Required if
               the source disk is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_image: URL of the source image used to create this image. In order to create an image, you must provide the full or partial
               URL of one of the following:
               * The selfLink URL
               * This property
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input['ImageSourceImageEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_snapshot: URL of the source snapshot used to create this image.
               In order to create an image, you must provide the full or partial URL of one of the following:
               * The selfLink URL
               * This property
               * The sourceImage URL
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if
               the source snapshot is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] storage_locations: Cloud Storage bucket storage location of the image
               (regional or multi-regional).
               Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if image_encryption_key is not None:
            pulumi.set(__self__, "image_encryption_key", image_encryption_key)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if raw_disk is not None:
            pulumi.set(__self__, "raw_disk", raw_disk)
        if shielded_instance_initial_state is not None:
            pulumi.set(__self__, "shielded_instance_initial_state", shielded_instance_initial_state)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_encryption_key is not None:
            pulumi.set(__self__, "source_disk_encryption_key", source_disk_encryption_key)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)
        if storage_locations is not None:
            pulumi.set(__self__, "storage_locations", storage_locations)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of the image when restored onto a persistent disk (in GB).
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the image family to which this image belongs. You can
        create disks by specifying an image family instead of a specific
        image name. The image family always returns its latest image that is
        not deprecated. The name of the image family must comply with
        RFC1035.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable images.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter(name="imageEncryptionKey")
    def image_encryption_key(self) -> Optional[pulumi.Input['ImageImageEncryptionKeyArgs']]:
        """
        Encrypts the image using a customer-supplied encryption key.
        After you encrypt an image with a customer-supplied key, you must
        provide the same key if you use the image later (e.g. to create a
        disk from the image)
        Structure is documented below.
        """
        return pulumi.get(self, "image_encryption_key")

    @image_encryption_key.setter
    def image_encryption_key(self, value: Optional[pulumi.Input['ImageImageEncryptionKeyArgs']]):
        pulumi.set(self, "image_encryption_key", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this Image.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="rawDisk")
    def raw_disk(self) -> Optional[pulumi.Input['ImageRawDiskArgs']]:
        """
        The parameters of the raw disk image.
        Structure is documented below.
        """
        return pulumi.get(self, "raw_disk")

    @raw_disk.setter
    def raw_disk(self, value: Optional[pulumi.Input['ImageRawDiskArgs']]):
        pulumi.set(self, "raw_disk", value)

    @property
    @pulumi.getter(name="shieldedInstanceInitialState")
    def shielded_instance_initial_state(self) -> Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']]:
        """
        Set the secure boot keys of shielded instance.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_initial_state")

    @shielded_instance_initial_state.setter
    def shielded_instance_initial_state(self, value: Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']]):
        pulumi.set(self, "shielded_instance_initial_state", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source disk to create this image based on.
        You must provide either this property or the
        rawDisk.source property but not both to create an image.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source disk. Required if
        the source disk is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @source_disk_encryption_key.setter
    def source_disk_encryption_key(self, value: Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']]):
        pulumi.set(self, "source_disk_encryption_key", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the source image used to create this image. In order to create an image, you must provide the full or partial
        URL of one of the following:
        * The selfLink URL
        * This property
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the source snapshot used to create this image.
        In order to create an image, you must provide the full or partial URL of one of the following:
        * The selfLink URL
        * This property
        * The sourceImage URL
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required if
        the source snapshot is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Cloud Storage bucket storage location of the image
        (regional or multi-regional).
        Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        return pulumi.get(self, "storage_locations")

    @storage_locations.setter
    def storage_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "storage_locations", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 archive_size_bytes: Optional[pulumi.Input[builtins.int]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]] = None,
                 image_encryption_key: Optional[pulumi.Input['ImageImageEncryptionKeyArgs']] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 raw_disk: Optional[pulumi.Input['ImageRawDiskArgs']] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 shielded_instance_initial_state: Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']] = None,
                 source_disk: Optional[pulumi.Input[builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']] = None,
                 source_image: Optional[pulumi.Input[builtins.str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']] = None,
                 source_snapshot: Optional[pulumi.Input[builtins.str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[builtins.int] archive_size_bytes: Size of the image tar.gz archive stored in Google Cloud Storage (in
               bytes).
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.int] disk_size_gb: Size of the image when restored onto a persistent disk (in GB).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] family: The name of the image family to which this image belongs. You can
               create disks by specifying an image family instead of a specific
               image name. The image family always returns its latest image that is
               not deprecated. The name of the image family must comply with
               RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable images.
               Structure is documented below.
        :param pulumi.Input['ImageImageEncryptionKeyArgs'] image_encryption_key: Encrypts the image using a customer-supplied encryption key.
               After you encrypt an image with a customer-supplied key, you must
               provide the same key if you use the image later (e.g. to create a
               disk from the image)
               Structure is documented below.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this Image.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] licenses: Any applicable license URI.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['ImageRawDiskArgs'] raw_disk: The parameters of the raw disk image.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['ImageShieldedInstanceInitialStateArgs'] shielded_instance_initial_state: Set the secure boot keys of shielded instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_disk: The source disk to create this image based on.
               You must provide either this property or the
               rawDisk.source property but not both to create an image.
        :param pulumi.Input['ImageSourceDiskEncryptionKeyArgs'] source_disk_encryption_key: The customer-supplied encryption key of the source disk. Required if
               the source disk is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_image: URL of the source image used to create this image. In order to create an image, you must provide the full or partial
               URL of one of the following:
               * The selfLink URL
               * This property
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input['ImageSourceImageEncryptionKeyArgs'] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_snapshot: URL of the source snapshot used to create this image.
               In order to create an image, you must provide the full or partial URL of one of the following:
               * The selfLink URL
               * This property
               * The sourceImage URL
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs'] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if
               the source snapshot is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] storage_locations: Cloud Storage bucket storage location of the image
               (regional or multi-regional).
               Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        if archive_size_bytes is not None:
            pulumi.set(__self__, "archive_size_bytes", archive_size_bytes)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if guest_os_features is not None:
            pulumi.set(__self__, "guest_os_features", guest_os_features)
        if image_encryption_key is not None:
            pulumi.set(__self__, "image_encryption_key", image_encryption_key)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if licenses is not None:
            pulumi.set(__self__, "licenses", licenses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if raw_disk is not None:
            pulumi.set(__self__, "raw_disk", raw_disk)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if shielded_instance_initial_state is not None:
            pulumi.set(__self__, "shielded_instance_initial_state", shielded_instance_initial_state)
        if source_disk is not None:
            pulumi.set(__self__, "source_disk", source_disk)
        if source_disk_encryption_key is not None:
            pulumi.set(__self__, "source_disk_encryption_key", source_disk_encryption_key)
        if source_image is not None:
            pulumi.set(__self__, "source_image", source_image)
        if source_image_encryption_key is not None:
            pulumi.set(__self__, "source_image_encryption_key", source_image_encryption_key)
        if source_snapshot is not None:
            pulumi.set(__self__, "source_snapshot", source_snapshot)
        if source_snapshot_encryption_key is not None:
            pulumi.set(__self__, "source_snapshot_encryption_key", source_snapshot_encryption_key)
        if storage_locations is not None:
            pulumi.set(__self__, "storage_locations", storage_locations)

    @property
    @pulumi.getter(name="archiveSizeBytes")
    def archive_size_bytes(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of the image tar.gz archive stored in Google Cloud Storage (in
        bytes).
        """
        return pulumi.get(self, "archive_size_bytes")

    @archive_size_bytes.setter
    def archive_size_bytes(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "archive_size_bytes", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Size of the image when restored onto a persistent disk (in GB).
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the image family to which this image belongs. You can
        create disks by specifying an image family instead of a specific
        image name. The image family always returns its latest image that is
        not deprecated. The name of the image family must comply with
        RFC1035.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "family", value)

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable images.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @guest_os_features.setter
    def guest_os_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImageGuestOsFeatureArgs']]]]):
        pulumi.set(self, "guest_os_features", value)

    @property
    @pulumi.getter(name="imageEncryptionKey")
    def image_encryption_key(self) -> Optional[pulumi.Input['ImageImageEncryptionKeyArgs']]:
        """
        Encrypts the image using a customer-supplied encryption key.
        After you encrypt an image with a customer-supplied key, you must
        provide the same key if you use the image later (e.g. to create a
        disk from the image)
        Structure is documented below.
        """
        return pulumi.get(self, "image_encryption_key")

    @image_encryption_key.setter
    def image_encryption_key(self, value: Optional[pulumi.Input['ImageImageEncryptionKeyArgs']]):
        pulumi.set(self, "image_encryption_key", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The fingerprint used for optimistic locking of this resource. Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels to apply to this Image.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @licenses.setter
    def licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "licenses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="rawDisk")
    def raw_disk(self) -> Optional[pulumi.Input['ImageRawDiskArgs']]:
        """
        The parameters of the raw disk image.
        Structure is documented below.
        """
        return pulumi.get(self, "raw_disk")

    @raw_disk.setter
    def raw_disk(self, value: Optional[pulumi.Input['ImageRawDiskArgs']]):
        pulumi.set(self, "raw_disk", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="shieldedInstanceInitialState")
    def shielded_instance_initial_state(self) -> Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']]:
        """
        Set the secure boot keys of shielded instance.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_initial_state")

    @shielded_instance_initial_state.setter
    def shielded_instance_initial_state(self, value: Optional[pulumi.Input['ImageShieldedInstanceInitialStateArgs']]):
        pulumi.set(self, "shielded_instance_initial_state", value)

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source disk to create this image based on.
        You must provide either this property or the
        rawDisk.source property but not both to create an image.
        """
        return pulumi.get(self, "source_disk")

    @source_disk.setter
    def source_disk(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_disk", value)

    @property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source disk. Required if
        the source disk is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @source_disk_encryption_key.setter
    def source_disk_encryption_key(self, value: Optional[pulumi.Input['ImageSourceDiskEncryptionKeyArgs']]):
        pulumi.set(self, "source_disk_encryption_key", value)

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the source image used to create this image. In order to create an image, you must provide the full or partial
        URL of one of the following:
        * The selfLink URL
        * This property
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_image")

    @source_image.setter
    def source_image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_image", value)

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @source_image_encryption_key.setter
    def source_image_encryption_key(self, value: Optional[pulumi.Input['ImageSourceImageEncryptionKeyArgs']]):
        pulumi.set(self, "source_image_encryption_key", value)

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the source snapshot used to create this image.
        In order to create an image, you must provide the full or partial URL of one of the following:
        * The selfLink URL
        * This property
        * The sourceImage URL
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_snapshot")

    @source_snapshot.setter
    def source_snapshot(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_snapshot", value)

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']]:
        """
        The customer-supplied encryption key of the source snapshot. Required if
        the source snapshot is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @source_snapshot_encryption_key.setter
    def source_snapshot_encryption_key(self, value: Optional[pulumi.Input['ImageSourceSnapshotEncryptionKeyArgs']]):
        pulumi.set(self, "source_snapshot_encryption_key", value)

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Cloud Storage bucket storage location of the image
        (regional or multi-regional).
        Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        return pulumi.get(self, "storage_locations")

    @storage_locations.setter
    def storage_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "storage_locations", value)


@pulumi.type_token("gcp:compute/image:Image")
class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageGuestOsFeatureArgs', 'ImageGuestOsFeatureArgsDict']]]]] = None,
                 image_encryption_key: Optional[pulumi.Input[Union['ImageImageEncryptionKeyArgs', 'ImageImageEncryptionKeyArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 raw_disk: Optional[pulumi.Input[Union['ImageRawDiskArgs', 'ImageRawDiskArgsDict']]] = None,
                 shielded_instance_initial_state: Optional[pulumi.Input[Union['ImageShieldedInstanceInitialStateArgs', 'ImageShieldedInstanceInitialStateArgsDict']]] = None,
                 source_disk: Optional[pulumi.Input[builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input[Union['ImageSourceDiskEncryptionKeyArgs', 'ImageSourceDiskEncryptionKeyArgsDict']]] = None,
                 source_image: Optional[pulumi.Input[builtins.str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[Union['ImageSourceImageEncryptionKeyArgs', 'ImageSourceImageEncryptionKeyArgsDict']]] = None,
                 source_snapshot: Optional[pulumi.Input[builtins.str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[Union['ImageSourceSnapshotEncryptionKeyArgs', 'ImageSourceSnapshotEncryptionKeyArgsDict']]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Represents an Image resource.

        Google Compute Engine uses operating system images to create the root
        persistent disks for your instances. You specify an image when you create
        an instance. Images contain a boot loader, an operating system, and a
        root file system. Linux operating system images are also capable of
        running containers on Compute Engine.

        Images can be either public or custom.

        Public images are provided and maintained by Google, open-source
        communities, and third-party vendors. By default, all projects have
        access to these images and can use them to create instances.  Custom
        images are available only to your project. You can create a custom image
        from root persistent disks and other images. Then, use the custom image
        to create an instance.

        To get more information about Image, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/images)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/images)

        ## Example Usage

        ### Image Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-image",
            source_disk=persistent.id)
        ```
        ### Image Guest Os

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-image",
            source_disk=persistent.id,
            guest_os_features=[
                {
                    "type": "UEFI_COMPATIBLE",
                },
                {
                    "type": "VIRTIO_SCSI_MULTIQUEUE",
                },
                {
                    "type": "GVNIC",
                },
                {
                    "type": "SEV_CAPABLE",
                },
                {
                    "type": "SEV_LIVE_MIGRATABLE_V2",
                },
            ])
        ```
        ### Image Basic Storage Location

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-sl-image",
            source_disk=persistent.id,
            storage_locations=["us-central1"])
        ```

        ## Import

        Image can be imported using any of these accepted formats:

        * `projects/{{project}}/global/images/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Image can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/image:Image default projects/{{project}}/global/images/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/image:Image default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/image:Image default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.int] disk_size_gb: Size of the image when restored onto a persistent disk (in GB).
        :param pulumi.Input[builtins.str] family: The name of the image family to which this image belongs. You can
               create disks by specifying an image family instead of a specific
               image name. The image family always returns its latest image that is
               not deprecated. The name of the image family must comply with
               RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageGuestOsFeatureArgs', 'ImageGuestOsFeatureArgsDict']]]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable images.
               Structure is documented below.
        :param pulumi.Input[Union['ImageImageEncryptionKeyArgs', 'ImageImageEncryptionKeyArgsDict']] image_encryption_key: Encrypts the image using a customer-supplied encryption key.
               After you encrypt an image with a customer-supplied key, you must
               provide the same key if you use the image later (e.g. to create a
               disk from the image)
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this Image.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] licenses: Any applicable license URI.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['ImageRawDiskArgs', 'ImageRawDiskArgsDict']] raw_disk: The parameters of the raw disk image.
               Structure is documented below.
        :param pulumi.Input[Union['ImageShieldedInstanceInitialStateArgs', 'ImageShieldedInstanceInitialStateArgsDict']] shielded_instance_initial_state: Set the secure boot keys of shielded instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_disk: The source disk to create this image based on.
               You must provide either this property or the
               rawDisk.source property but not both to create an image.
        :param pulumi.Input[Union['ImageSourceDiskEncryptionKeyArgs', 'ImageSourceDiskEncryptionKeyArgsDict']] source_disk_encryption_key: The customer-supplied encryption key of the source disk. Required if
               the source disk is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_image: URL of the source image used to create this image. In order to create an image, you must provide the full or partial
               URL of one of the following:
               * The selfLink URL
               * This property
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input[Union['ImageSourceImageEncryptionKeyArgs', 'ImageSourceImageEncryptionKeyArgsDict']] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_snapshot: URL of the source snapshot used to create this image.
               In order to create an image, you must provide the full or partial URL of one of the following:
               * The selfLink URL
               * This property
               * The sourceImage URL
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input[Union['ImageSourceSnapshotEncryptionKeyArgs', 'ImageSourceSnapshotEncryptionKeyArgsDict']] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if
               the source snapshot is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] storage_locations: Cloud Storage bucket storage location of the image
               (regional or multi-regional).
               Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an Image resource.

        Google Compute Engine uses operating system images to create the root
        persistent disks for your instances. You specify an image when you create
        an instance. Images contain a boot loader, an operating system, and a
        root file system. Linux operating system images are also capable of
        running containers on Compute Engine.

        Images can be either public or custom.

        Public images are provided and maintained by Google, open-source
        communities, and third-party vendors. By default, all projects have
        access to these images and can use them to create instances.  Custom
        images are available only to your project. You can create a custom image
        from root persistent disks and other images. Then, use the custom image
        to create an instance.

        To get more information about Image, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/v1/images)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/images)

        ## Example Usage

        ### Image Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-image",
            source_disk=persistent.id)
        ```
        ### Image Guest Os

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-image",
            source_disk=persistent.id,
            guest_os_features=[
                {
                    "type": "UEFI_COMPATIBLE",
                },
                {
                    "type": "VIRTIO_SCSI_MULTIQUEUE",
                },
                {
                    "type": "GVNIC",
                },
                {
                    "type": "SEV_CAPABLE",
                },
                {
                    "type": "SEV_LIVE_MIGRATABLE_V2",
                },
            ])
        ```
        ### Image Basic Storage Location

        ```python
        import pulumi
        import pulumi_gcp as gcp

        debian = gcp.compute.get_image(family="debian-12",
            project="debian-cloud")
        persistent = gcp.compute.Disk("persistent",
            name="example-disk",
            image=debian.self_link,
            size=10,
            type="pd-ssd",
            zone="us-central1-a")
        example = gcp.compute.Image("example",
            name="example-sl-image",
            source_disk=persistent.id,
            storage_locations=["us-central1"])
        ```

        ## Import

        Image can be imported using any of these accepted formats:

        * `projects/{{project}}/global/images/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Image can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/image:Image default projects/{{project}}/global/images/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/image:Image default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/image:Image default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
                 family: Optional[pulumi.Input[builtins.str]] = None,
                 guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageGuestOsFeatureArgs', 'ImageGuestOsFeatureArgsDict']]]]] = None,
                 image_encryption_key: Optional[pulumi.Input[Union['ImageImageEncryptionKeyArgs', 'ImageImageEncryptionKeyArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 licenses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 raw_disk: Optional[pulumi.Input[Union['ImageRawDiskArgs', 'ImageRawDiskArgsDict']]] = None,
                 shielded_instance_initial_state: Optional[pulumi.Input[Union['ImageShieldedInstanceInitialStateArgs', 'ImageShieldedInstanceInitialStateArgsDict']]] = None,
                 source_disk: Optional[pulumi.Input[builtins.str]] = None,
                 source_disk_encryption_key: Optional[pulumi.Input[Union['ImageSourceDiskEncryptionKeyArgs', 'ImageSourceDiskEncryptionKeyArgsDict']]] = None,
                 source_image: Optional[pulumi.Input[builtins.str]] = None,
                 source_image_encryption_key: Optional[pulumi.Input[Union['ImageSourceImageEncryptionKeyArgs', 'ImageSourceImageEncryptionKeyArgsDict']]] = None,
                 source_snapshot: Optional[pulumi.Input[builtins.str]] = None,
                 source_snapshot_encryption_key: Optional[pulumi.Input[Union['ImageSourceSnapshotEncryptionKeyArgs', 'ImageSourceSnapshotEncryptionKeyArgsDict']]] = None,
                 storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["disk_size_gb"] = disk_size_gb
            __props__.__dict__["family"] = family
            __props__.__dict__["guest_os_features"] = guest_os_features
            __props__.__dict__["image_encryption_key"] = image_encryption_key
            __props__.__dict__["labels"] = labels
            __props__.__dict__["licenses"] = licenses
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["raw_disk"] = raw_disk
            __props__.__dict__["shielded_instance_initial_state"] = shielded_instance_initial_state
            __props__.__dict__["source_disk"] = source_disk
            __props__.__dict__["source_disk_encryption_key"] = source_disk_encryption_key
            __props__.__dict__["source_image"] = source_image
            __props__.__dict__["source_image_encryption_key"] = source_image_encryption_key
            __props__.__dict__["source_snapshot"] = source_snapshot
            __props__.__dict__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
            __props__.__dict__["storage_locations"] = storage_locations
            __props__.__dict__["archive_size_bytes"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Image, __self__).__init__(
            'gcp:compute/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive_size_bytes: Optional[pulumi.Input[builtins.int]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            disk_size_gb: Optional[pulumi.Input[builtins.int]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            family: Optional[pulumi.Input[builtins.str]] = None,
            guest_os_features: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ImageGuestOsFeatureArgs', 'ImageGuestOsFeatureArgsDict']]]]] = None,
            image_encryption_key: Optional[pulumi.Input[Union['ImageImageEncryptionKeyArgs', 'ImageImageEncryptionKeyArgsDict']]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            licenses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            raw_disk: Optional[pulumi.Input[Union['ImageRawDiskArgs', 'ImageRawDiskArgsDict']]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            shielded_instance_initial_state: Optional[pulumi.Input[Union['ImageShieldedInstanceInitialStateArgs', 'ImageShieldedInstanceInitialStateArgsDict']]] = None,
            source_disk: Optional[pulumi.Input[builtins.str]] = None,
            source_disk_encryption_key: Optional[pulumi.Input[Union['ImageSourceDiskEncryptionKeyArgs', 'ImageSourceDiskEncryptionKeyArgsDict']]] = None,
            source_image: Optional[pulumi.Input[builtins.str]] = None,
            source_image_encryption_key: Optional[pulumi.Input[Union['ImageSourceImageEncryptionKeyArgs', 'ImageSourceImageEncryptionKeyArgsDict']]] = None,
            source_snapshot: Optional[pulumi.Input[builtins.str]] = None,
            source_snapshot_encryption_key: Optional[pulumi.Input[Union['ImageSourceSnapshotEncryptionKeyArgs', 'ImageSourceSnapshotEncryptionKeyArgsDict']]] = None,
            storage_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] archive_size_bytes: Size of the image tar.gz archive stored in Google Cloud Storage (in
               bytes).
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.int] disk_size_gb: Size of the image when restored onto a persistent disk (in GB).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] family: The name of the image family to which this image belongs. You can
               create disks by specifying an image family instead of a specific
               image name. The image family always returns its latest image that is
               not deprecated. The name of the image family must comply with
               RFC1035.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ImageGuestOsFeatureArgs', 'ImageGuestOsFeatureArgsDict']]]] guest_os_features: A list of features to enable on the guest operating system.
               Applicable only for bootable images.
               Structure is documented below.
        :param pulumi.Input[Union['ImageImageEncryptionKeyArgs', 'ImageImageEncryptionKeyArgsDict']] image_encryption_key: Encrypts the image using a customer-supplied encryption key.
               After you encrypt an image with a customer-supplied key, you must
               provide the same key if you use the image later (e.g. to create a
               disk from the image)
               Structure is documented below.
        :param pulumi.Input[builtins.str] label_fingerprint: The fingerprint used for optimistic locking of this resource. Used
               internally during updates.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels to apply to this Image.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] licenses: Any applicable license URI.
        :param pulumi.Input[builtins.str] name: Name of the resource; provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['ImageRawDiskArgs', 'ImageRawDiskArgsDict']] raw_disk: The parameters of the raw disk image.
               Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['ImageShieldedInstanceInitialStateArgs', 'ImageShieldedInstanceInitialStateArgsDict']] shielded_instance_initial_state: Set the secure boot keys of shielded instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_disk: The source disk to create this image based on.
               You must provide either this property or the
               rawDisk.source property but not both to create an image.
        :param pulumi.Input[Union['ImageSourceDiskEncryptionKeyArgs', 'ImageSourceDiskEncryptionKeyArgsDict']] source_disk_encryption_key: The customer-supplied encryption key of the source disk. Required if
               the source disk is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_image: URL of the source image used to create this image. In order to create an image, you must provide the full or partial
               URL of one of the following:
               * The selfLink URL
               * This property
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input[Union['ImageSourceImageEncryptionKeyArgs', 'ImageSourceImageEncryptionKeyArgsDict']] source_image_encryption_key: The customer-supplied encryption key of the source image. Required if
               the source image is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source_snapshot: URL of the source snapshot used to create this image.
               In order to create an image, you must provide the full or partial URL of one of the following:
               * The selfLink URL
               * This property
               * The sourceImage URL
               * The rawDisk.source URL
               * The sourceDisk URL
        :param pulumi.Input[Union['ImageSourceSnapshotEncryptionKeyArgs', 'ImageSourceSnapshotEncryptionKeyArgsDict']] source_snapshot_encryption_key: The customer-supplied encryption key of the source snapshot. Required if
               the source snapshot is protected by a customer-supplied encryption key.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] storage_locations: Cloud Storage bucket storage location of the image
               (regional or multi-regional).
               Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["archive_size_bytes"] = archive_size_bytes
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["family"] = family
        __props__.__dict__["guest_os_features"] = guest_os_features
        __props__.__dict__["image_encryption_key"] = image_encryption_key
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["licenses"] = licenses
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["raw_disk"] = raw_disk
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["shielded_instance_initial_state"] = shielded_instance_initial_state
        __props__.__dict__["source_disk"] = source_disk
        __props__.__dict__["source_disk_encryption_key"] = source_disk_encryption_key
        __props__.__dict__["source_image"] = source_image
        __props__.__dict__["source_image_encryption_key"] = source_image_encryption_key
        __props__.__dict__["source_snapshot"] = source_snapshot
        __props__.__dict__["source_snapshot_encryption_key"] = source_snapshot_encryption_key
        __props__.__dict__["storage_locations"] = storage_locations
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archiveSizeBytes")
    def archive_size_bytes(self) -> pulumi.Output[builtins.int]:
        """
        Size of the image tar.gz archive stored in Google Cloud Storage (in
        bytes).
        """
        return pulumi.get(self, "archive_size_bytes")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[builtins.int]:
        """
        Size of the image when restored onto a persistent disk (in GB).
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def family(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The name of the image family to which this image belongs. You can
        create disks by specifying an image family instead of a specific
        image name. The image family always returns its latest image that is
        not deprecated. The name of the image family must comply with
        RFC1035.
        """
        return pulumi.get(self, "family")

    @property
    @pulumi.getter(name="guestOsFeatures")
    def guest_os_features(self) -> pulumi.Output[Sequence['outputs.ImageGuestOsFeature']]:
        """
        A list of features to enable on the guest operating system.
        Applicable only for bootable images.
        Structure is documented below.
        """
        return pulumi.get(self, "guest_os_features")

    @property
    @pulumi.getter(name="imageEncryptionKey")
    def image_encryption_key(self) -> pulumi.Output[Optional['outputs.ImageImageEncryptionKey']]:
        """
        Encrypts the image using a customer-supplied encryption key.
        After you encrypt an image with a customer-supplied key, you must
        provide the same key if you use the image later (e.g. to create a
        disk from the image)
        Structure is documented below.
        """
        return pulumi.get(self, "image_encryption_key")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The fingerprint used for optimistic locking of this resource. Used
        internally during updates.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels to apply to this Image.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def licenses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Any applicable license URI.
        """
        return pulumi.get(self, "licenses")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource; provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="rawDisk")
    def raw_disk(self) -> pulumi.Output[Optional['outputs.ImageRawDisk']]:
        """
        The parameters of the raw disk image.
        Structure is documented below.
        """
        return pulumi.get(self, "raw_disk")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="shieldedInstanceInitialState")
    def shielded_instance_initial_state(self) -> pulumi.Output['outputs.ImageShieldedInstanceInitialState']:
        """
        Set the secure boot keys of shielded instance.
        Structure is documented below.
        """
        return pulumi.get(self, "shielded_instance_initial_state")

    @property
    @pulumi.getter(name="sourceDisk")
    def source_disk(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The source disk to create this image based on.
        You must provide either this property or the
        rawDisk.source property but not both to create an image.
        """
        return pulumi.get(self, "source_disk")

    @property
    @pulumi.getter(name="sourceDiskEncryptionKey")
    def source_disk_encryption_key(self) -> pulumi.Output[Optional['outputs.ImageSourceDiskEncryptionKey']]:
        """
        The customer-supplied encryption key of the source disk. Required if
        the source disk is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_disk_encryption_key")

    @property
    @pulumi.getter(name="sourceImage")
    def source_image(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the source image used to create this image. In order to create an image, you must provide the full or partial
        URL of one of the following:
        * The selfLink URL
        * This property
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_image")

    @property
    @pulumi.getter(name="sourceImageEncryptionKey")
    def source_image_encryption_key(self) -> pulumi.Output[Optional['outputs.ImageSourceImageEncryptionKey']]:
        """
        The customer-supplied encryption key of the source image. Required if
        the source image is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_image_encryption_key")

    @property
    @pulumi.getter(name="sourceSnapshot")
    def source_snapshot(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the source snapshot used to create this image.
        In order to create an image, you must provide the full or partial URL of one of the following:
        * The selfLink URL
        * This property
        * The sourceImage URL
        * The rawDisk.source URL
        * The sourceDisk URL
        """
        return pulumi.get(self, "source_snapshot")

    @property
    @pulumi.getter(name="sourceSnapshotEncryptionKey")
    def source_snapshot_encryption_key(self) -> pulumi.Output[Optional['outputs.ImageSourceSnapshotEncryptionKey']]:
        """
        The customer-supplied encryption key of the source snapshot. Required if
        the source snapshot is protected by a customer-supplied encryption key.
        Structure is documented below.
        """
        return pulumi.get(self, "source_snapshot_encryption_key")

    @property
    @pulumi.getter(name="storageLocations")
    def storage_locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Cloud Storage bucket storage location of the image
        (regional or multi-regional).
        Reference link: https://cloud.google.com/compute/docs/reference/rest/v1/images
        """
        return pulumi.get(self, "storage_locations")

