# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 boot_disk: pulumi.Input['InstanceBootDiskArgs'],
                 machine_type: pulumi.Input[builtins.str],
                 network_interfaces: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]],
                 advanced_machine_features: Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[builtins.bool]] = None,
                 attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]] = None,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_status: Optional[pulumi.Input[builtins.str]] = None,
                 enable_display: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 instance_encryption_key: Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']] = None,
                 key_revocation_action_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']] = None,
                 params: Optional[pulumi.Input['InstanceParamsArgs']] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceReservationAffinityArgs']] = None,
                 resource_policies: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['InstanceSchedulingArgs']] = None,
                 scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]] = None,
                 service_account: Optional[pulumi.Input['InstanceServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceBootDiskArgs'] boot_disk: The boot disk for the instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] machine_type: The machine type to create.
               
               **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.
               
               [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
               Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
               `lifecycle.ignore_changes` on `machine_type` in these cases.
               
               There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Networks to attach to the instance. This can
               be specified multiple times. Structure is documented below.
               
               - - -
        :param pulumi.Input['InstanceAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] allow_stopping_for_update: If true, allows this prvider to stop the instance to update its properties.
               If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]] attached_disks: Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        :param pulumi.Input[builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs.
               This defaults to false.
        :param pulumi.Input['InstanceConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] deletion_protection: Enable deletion protection on this instance. Defaults to false.
               **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        :param pulumi.Input[builtins.str] description: A brief description of this resource.
        :param pulumi.Input[builtins.str] desired_status: Desired status of the instance. Either
               `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        :param pulumi.Input[builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
               **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        :param pulumi.Input[builtins.str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
               Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
               The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input['InstanceInstanceEncryptionKeyArgs'] instance_encryption_key: Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        :param pulumi.Input[builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Ssh keys attached in the Cloud Console will be removed.
               Add them to your config in order to keep them attached to your instance.
               A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)
               
               > Depending on the OS you choose for your instance, some metadata keys have
               special functionality.  Most linux-based images will run the content of
               `metadata.startup-script` in a shell on every boot.  At a minimum,
               Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
               support this key.  Windows instances require other keys depending on the format
               of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
               For the convenience of the users of `metadata.startup-script`,
               we provide a special attribute, `metadata_startup_script`, which is documented below.
        :param pulumi.Input[builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, except this one forces the instance to be recreated
               (thus re-running the script) if it is changed. This replaces the startup-script
               metadata key on the created instance and thus the two mechanisms are not
               allowed to be used simultaneously.  Users are free to use either mechanism - the
               only distinction is that this separate attribute will cause a recreate on
               modification.  On import, `metadata_startup_script` will not be set - if you
               choose to specify it you will see a diff immediately after import causing a
               destroy/recreate operation. If importing an instance and specifying this value
               is desired, you will need to modify your state file.
        :param pulumi.Input[builtins.str] min_cpu_platform: Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[builtins.str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input['InstanceNetworkPerformanceConfigArgs'] network_performance_config: (Optional, Beta
               Configures network performance settings for the instance. Structure is
               documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input['InstanceParamsArgs'] params: Additional instance parameters.
               .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input['InstanceReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['InstanceSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]] scratch_disks: Scratch disks to attach to the instance. This can be
               specified multiple times for multiple scratch disks. Structure is documented below.
        :param pulumi.Input['InstanceServiceAccountArgs'] service_account: Service account to attach to the instance.
               Structure is documented below.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input['InstanceShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of network tags to attach to the instance.
        :param pulumi.Input[builtins.str] zone: The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        pulumi.set(__self__, "boot_disk", boot_disk)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "network_interfaces", network_interfaces)
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if attached_disks is not None:
            pulumi.set(__self__, "attached_disks", attached_disks)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_encryption_key is not None:
            pulumi.set(__self__, "instance_encryption_key", instance_encryption_key)
        if key_revocation_action_type is not None:
            pulumi.set(__self__, "key_revocation_action_type", key_revocation_action_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if partner_metadata is not None:
            pulumi.set(__self__, "partner_metadata", partner_metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if scratch_disks is not None:
            pulumi.set(__self__, "scratch_disks", scratch_disks)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> pulumi.Input['InstanceBootDiskArgs']:
        """
        The boot disk for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: pulumi.Input['InstanceBootDiskArgs']):
        pulumi.set(self, "boot_disk", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Input[builtins.str]:
        """
        The machine type to create.

        **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.

        [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
        Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
        `lifecycle.ignore_changes` on `machine_type` in these cases.

        There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]:
        """
        Networks to attach to the instance. This can
        be specified multiple times. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, allows this prvider to stop the instance to update its properties.
        If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @property
    @pulumi.getter(name="attachedDisks")
    def attached_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]]:
        """
        Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        """
        return pulumi.get(self, "attached_disks")

    @attached_disks.setter
    def attached_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]]):
        pulumi.set(self, "attached_disks", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs.
        This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable deletion protection on this instance. Defaults to false.
        **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired status of the instance. Either
        `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_status", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
        Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
        The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="instanceEncryptionKey")
    def instance_encryption_key(self) -> Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']]:
        """
        Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        """
        return pulumi.get(self, "instance_encryption_key")

    @instance_encryption_key.setter
    def instance_encryption_key(self, value: Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']]):
        pulumi.set(self, "instance_encryption_key", value)

    @property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @key_revocation_action_type.setter
    def key_revocation_action_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_revocation_action_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Ssh keys attached in the Cloud Console will be removed.
        Add them to your config in order to keep them attached to your instance.
        A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)

        > Depending on the OS you choose for your instance, some metadata keys have
        special functionality.  Most linux-based images will run the content of
        `metadata.startup-script` in a shell on every boot.  At a minimum,
        Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
        support this key.  Windows instances require other keys depending on the format
        of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
        For the convenience of the users of `metadata.startup-script`,
        we provide a special attribute, `metadata_startup_script`, which is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, except this one forces the instance to be recreated
        (thus re-running the script) if it is changed. This replaces the startup-script
        metadata key on the created instance and thus the two mechanisms are not
        allowed to be used simultaneously.  Users are free to use either mechanism - the
        only distinction is that this separate attribute will cause a recreate on
        modification.  On import, `metadata_startup_script` will not be set - if you
        choose to specify it you will see a diff immediately after import causing a
        destroy/recreate operation. If importing an instance and specifying this value
        is desired, you will need to modify your state file.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']]:
        """
        (Optional, Beta
        Configures network performance settings for the instance. Structure is
        documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['InstanceParamsArgs']]:
        """
        Additional instance parameters.
        .
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['InstanceParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @partner_metadata.setter
    def partner_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "partner_metadata", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="scratchDisks")
    def scratch_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]]:
        """
        Scratch disks to attach to the instance. This can be
        specified multiple times for multiple scratch disks. Structure is documented below.
        """
        return pulumi.get(self, "scratch_disks")

    @scratch_disks.setter
    def scratch_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]]):
        pulumi.set(self, "scratch_disks", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceServiceAccountArgs']]:
        """
        Service account to attach to the instance.
        Structure is documented below.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 advanced_machine_features: Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[builtins.bool]] = None,
                 attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]] = None,
                 boot_disk: Optional[pulumi.Input['InstanceBootDiskArgs']] = None,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']] = None,
                 cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 current_status: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_status: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_display: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 instance_encryption_key: Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']] = None,
                 instance_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[builtins.str]] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 metadata_startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]] = None,
                 network_performance_config: Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']] = None,
                 params: Optional[pulumi.Input['InstanceParamsArgs']] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reservation_affinity: Optional[pulumi.Input['InstanceReservationAffinityArgs']] = None,
                 resource_policies: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling: Optional[pulumi.Input['InstanceSchedulingArgs']] = None,
                 scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input['InstanceServiceAccountArgs']] = None,
                 shielded_instance_config: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAdvancedMachineFeaturesArgs'] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] allow_stopping_for_update: If true, allows this prvider to stop the instance to update its properties.
               If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]] attached_disks: Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        :param pulumi.Input['InstanceBootDiskArgs'] boot_disk: The boot disk for the instance.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs.
               This defaults to false.
        :param pulumi.Input['InstanceConfidentialInstanceConfigArgs'] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[builtins.str] cpu_platform: The CPU platform used by this instance.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] current_status: The current status of the instance. This could be one of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see [Instance life cycle](https://cloud.google.com/compute/docs/instances/instance-life-cycle).
        :param pulumi.Input[builtins.bool] deletion_protection: Enable deletion protection on this instance. Defaults to false.
               **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        :param pulumi.Input[builtins.str] description: A brief description of this resource.
        :param pulumi.Input[builtins.str] desired_status: Desired status of the instance. Either
               `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
               **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        :param pulumi.Input[builtins.str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
               Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
               The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input['InstanceInstanceEncryptionKeyArgs'] instance_encryption_key: Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        :param pulumi.Input[builtins.str] instance_id: The server-assigned unique identifier of this instance.
        :param pulumi.Input[builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[builtins.str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] machine_type: The machine type to create.
               
               **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.
               
               [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
               Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
               `lifecycle.ignore_changes` on `machine_type` in these cases.
               
               There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Ssh keys attached in the Cloud Console will be removed.
               Add them to your config in order to keep them attached to your instance.
               A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)
               
               > Depending on the OS you choose for your instance, some metadata keys have
               special functionality.  Most linux-based images will run the content of
               `metadata.startup-script` in a shell on every boot.  At a minimum,
               Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
               support this key.  Windows instances require other keys depending on the format
               of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
               For the convenience of the users of `metadata.startup-script`,
               we provide a special attribute, `metadata_startup_script`, which is documented below.
        :param pulumi.Input[builtins.str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, except this one forces the instance to be recreated
               (thus re-running the script) if it is changed. This replaces the startup-script
               metadata key on the created instance and thus the two mechanisms are not
               allowed to be used simultaneously.  Users are free to use either mechanism - the
               only distinction is that this separate attribute will cause a recreate on
               modification.  On import, `metadata_startup_script` will not be set - if you
               choose to specify it you will see a diff immediately after import causing a
               destroy/recreate operation. If importing an instance and specifying this value
               is desired, you will need to modify your state file.
        :param pulumi.Input[builtins.str] min_cpu_platform: Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[builtins.str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]] network_interfaces: Networks to attach to the instance. This can
               be specified multiple times. Structure is documented below.
               
               - - -
        :param pulumi.Input['InstanceNetworkPerformanceConfigArgs'] network_performance_config: (Optional, Beta
               Configures network performance settings for the instance. Structure is
               documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input['InstanceParamsArgs'] params: Additional instance parameters.
               .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input['InstanceReservationAffinityArgs'] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input['InstanceSchedulingArgs'] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]] scratch_disks: Scratch disks to attach to the instance. This can be
               specified multiple times for multiple scratch disks. Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input['InstanceServiceAccountArgs'] service_account: Service account to attach to the instance.
               Structure is documented below.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input['InstanceShieldedInstanceConfigArgs'] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of network tags to attach to the instance.
        :param pulumi.Input[builtins.str] tags_fingerprint: The unique fingerprint of the tags.
        :param pulumi.Input[builtins.str] zone: The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        if advanced_machine_features is not None:
            pulumi.set(__self__, "advanced_machine_features", advanced_machine_features)
        if allow_stopping_for_update is not None:
            pulumi.set(__self__, "allow_stopping_for_update", allow_stopping_for_update)
        if attached_disks is not None:
            pulumi.set(__self__, "attached_disks", attached_disks)
        if boot_disk is not None:
            pulumi.set(__self__, "boot_disk", boot_disk)
        if can_ip_forward is not None:
            pulumi.set(__self__, "can_ip_forward", can_ip_forward)
        if confidential_instance_config is not None:
            pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        if cpu_platform is not None:
            pulumi.set(__self__, "cpu_platform", cpu_platform)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if current_status is not None:
            pulumi.set(__self__, "current_status", current_status)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if desired_status is not None:
            pulumi.set(__self__, "desired_status", desired_status)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_display is not None:
            pulumi.set(__self__, "enable_display", enable_display)
        if guest_accelerators is not None:
            pulumi.set(__self__, "guest_accelerators", guest_accelerators)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if instance_encryption_key is not None:
            pulumi.set(__self__, "instance_encryption_key", instance_encryption_key)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if key_revocation_action_type is not None:
            pulumi.set(__self__, "key_revocation_action_type", key_revocation_action_type)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metadata_fingerprint is not None:
            pulumi.set(__self__, "metadata_fingerprint", metadata_fingerprint)
        if metadata_startup_script is not None:
            pulumi.set(__self__, "metadata_startup_script", metadata_startup_script)
        if min_cpu_platform is not None:
            pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_interfaces is not None:
            pulumi.set(__self__, "network_interfaces", network_interfaces)
        if network_performance_config is not None:
            pulumi.set(__self__, "network_performance_config", network_performance_config)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if partner_metadata is not None:
            pulumi.set(__self__, "partner_metadata", partner_metadata)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reservation_affinity is not None:
            pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        if resource_policies is not None:
            pulumi.set(__self__, "resource_policies", resource_policies)
        if scheduling is not None:
            pulumi.set(__self__, "scheduling", scheduling)
        if scratch_disks is not None:
            pulumi.set(__self__, "scratch_disks", scratch_disks)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if shielded_instance_config is not None:
            pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tags_fingerprint is not None:
            pulumi.set(__self__, "tags_fingerprint", tags_fingerprint)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @advanced_machine_features.setter
    def advanced_machine_features(self, value: Optional[pulumi.Input['InstanceAdvancedMachineFeaturesArgs']]):
        pulumi.set(self, "advanced_machine_features", value)

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, allows this prvider to stop the instance to update its properties.
        If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @allow_stopping_for_update.setter
    def allow_stopping_for_update(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allow_stopping_for_update", value)

    @property
    @pulumi.getter(name="attachedDisks")
    def attached_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]]:
        """
        Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        """
        return pulumi.get(self, "attached_disks")

    @attached_disks.setter
    def attached_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAttachedDiskArgs']]]]):
        pulumi.set(self, "attached_disks", value)

    @property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> Optional[pulumi.Input['InstanceBootDiskArgs']]:
        """
        The boot disk for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "boot_disk")

    @boot_disk.setter
    def boot_disk(self, value: Optional[pulumi.Input['InstanceBootDiskArgs']]):
        pulumi.set(self, "boot_disk", value)

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs.
        This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @can_ip_forward.setter
    def can_ip_forward(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "can_ip_forward", value)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']]:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @confidential_instance_config.setter
    def confidential_instance_config(self, value: Optional[pulumi.Input['InstanceConfidentialInstanceConfigArgs']]):
        pulumi.set(self, "confidential_instance_config", value)

    @property
    @pulumi.getter(name="cpuPlatform")
    def cpu_platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU platform used by this instance.
        """
        return pulumi.get(self, "cpu_platform")

    @cpu_platform.setter
    def cpu_platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpu_platform", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the instance. This could be one of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see [Instance life cycle](https://cloud.google.com/compute/docs/instances/instance-life-cycle).
        """
        return pulumi.get(self, "current_status")

    @current_status.setter
    def current_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "current_status", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable deletion protection on this instance. Defaults to false.
        **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired status of the instance. Either
        `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        """
        return pulumi.get(self, "desired_status")

    @desired_status.setter
    def desired_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "desired_status", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @enable_display.setter
    def enable_display(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_display", value)

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        """
        return pulumi.get(self, "guest_accelerators")

    @guest_accelerators.setter
    def guest_accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGuestAcceleratorArgs']]]]):
        pulumi.set(self, "guest_accelerators", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
        Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
        The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="instanceEncryptionKey")
    def instance_encryption_key(self) -> Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']]:
        """
        Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        """
        return pulumi.get(self, "instance_encryption_key")

    @instance_encryption_key.setter
    def instance_encryption_key(self, value: Optional[pulumi.Input['InstanceInstanceEncryptionKeyArgs']]):
        pulumi.set(self, "instance_encryption_key", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The server-assigned unique identifier of this instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @key_revocation_action_type.setter
    def key_revocation_action_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_revocation_action_type", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of key/value label pairs to assign to the instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The machine type to create.

        **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.

        [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
        Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
        `lifecycle.ignore_changes` on `machine_type` in these cases.

        There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Ssh keys attached in the Cloud Console will be removed.
        Add them to your config in order to keep them attached to your instance.
        A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)

        > Depending on the OS you choose for your instance, some metadata keys have
        special functionality.  Most linux-based images will run the content of
        `metadata.startup-script` in a shell on every boot.  At a minimum,
        Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
        support this key.  Windows instances require other keys depending on the format
        of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
        For the convenience of the users of `metadata.startup-script`,
        we provide a special attribute, `metadata_startup_script`, which is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @metadata_fingerprint.setter
    def metadata_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata_fingerprint", value)

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, except this one forces the instance to be recreated
        (thus re-running the script) if it is changed. This replaces the startup-script
        metadata key on the created instance and thus the two mechanisms are not
        allowed to be used simultaneously.  Users are free to use either mechanism - the
        only distinction is that this separate attribute will cause a recreate on
        modification.  On import, `metadata_startup_script` will not be set - if you
        choose to specify it you will see a diff immediately after import causing a
        destroy/recreate operation. If importing an instance and specifying this value
        is desired, you will need to modify your state file.
        """
        return pulumi.get(self, "metadata_startup_script")

    @metadata_startup_script.setter
    def metadata_startup_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "metadata_startup_script", value)

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "min_cpu_platform")

    @min_cpu_platform.setter
    def min_cpu_platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_cpu_platform", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]:
        """
        Networks to attach to the instance. This can
        be specified multiple times. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "network_interfaces")

    @network_interfaces.setter
    def network_interfaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkInterfaceArgs']]]]):
        pulumi.set(self, "network_interfaces", value)

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']]:
        """
        (Optional, Beta
        Configures network performance settings for the instance. Structure is
        documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @network_performance_config.setter
    def network_performance_config(self, value: Optional[pulumi.Input['InstanceNetworkPerformanceConfigArgs']]):
        pulumi.set(self, "network_performance_config", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['InstanceParamsArgs']]:
        """
        Additional instance parameters.
        .
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['InstanceParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @partner_metadata.setter
    def partner_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "partner_metadata", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> Optional[pulumi.Input['InstanceReservationAffinityArgs']]:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @reservation_affinity.setter
    def reservation_affinity(self, value: Optional[pulumi.Input['InstanceReservationAffinityArgs']]):
        pulumi.set(self, "reservation_affinity", value)

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @resource_policies.setter
    def resource_policies(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_policies", value)

    @property
    @pulumi.getter
    def scheduling(self) -> Optional[pulumi.Input['InstanceSchedulingArgs']]:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @scheduling.setter
    def scheduling(self, value: Optional[pulumi.Input['InstanceSchedulingArgs']]):
        pulumi.set(self, "scheduling", value)

    @property
    @pulumi.getter(name="scratchDisks")
    def scratch_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]]:
        """
        Scratch disks to attach to the instance. This can be
        specified multiple times for multiple scratch disks. Structure is documented below.
        """
        return pulumi.get(self, "scratch_disks")

    @scratch_disks.setter
    def scratch_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceScratchDiskArgs']]]]):
        pulumi.set(self, "scratch_disks", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['InstanceServiceAccountArgs']]:
        """
        Service account to attach to the instance.
        Structure is documented below.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['InstanceServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "shielded_instance_config")

    @shielded_instance_config.setter
    def shielded_instance_config(self, value: Optional[pulumi.Input['InstanceShieldedInstanceConfigArgs']]):
        pulumi.set(self, "shielded_instance_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of network tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @tags_fingerprint.setter
    def tags_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tags_fingerprint", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:compute/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[Union['InstanceAdvancedMachineFeaturesArgs', 'InstanceAdvancedMachineFeaturesArgsDict']]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[builtins.bool]] = None,
                 attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedDiskArgs', 'InstanceAttachedDiskArgsDict']]]]] = None,
                 boot_disk: Optional[pulumi.Input[Union['InstanceBootDiskArgs', 'InstanceBootDiskArgsDict']]] = None,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[Union['InstanceConfidentialInstanceConfigArgs', 'InstanceConfidentialInstanceConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_status: Optional[pulumi.Input[builtins.str]] = None,
                 enable_display: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGuestAcceleratorArgs', 'InstanceGuestAcceleratorArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 instance_encryption_key: Optional[pulumi.Input[Union['InstanceInstanceEncryptionKeyArgs', 'InstanceInstanceEncryptionKeyArgsDict']]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[Union['InstanceNetworkPerformanceConfigArgs', 'InstanceNetworkPerformanceConfigArgsDict']]] = None,
                 params: Optional[pulumi.Input[Union['InstanceParamsArgs', 'InstanceParamsArgsDict']]] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input[Union['InstanceReservationAffinityArgs', 'InstanceReservationAffinityArgsDict']]] = None,
                 resource_policies: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['InstanceSchedulingArgs', 'InstanceSchedulingArgsDict']]] = None,
                 scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceScratchDiskArgs', 'InstanceScratchDiskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[Union['InstanceServiceAccountArgs', 'InstanceServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['InstanceShieldedInstanceConfigArgs', 'InstanceShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Manages a VM instance resource within GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/instances)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/instances).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="my-custom-sa",
            display_name="Custom SA for VM Instance")
        default_instance = gcp.compute.Instance("default",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-instance",
            machine_type="n2-standard-2",
            zone="us-central1-a",
            tags=[
                "foo",
                "bar",
            ],
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            metadata={
                "foo": "bar",
            },
            metadata_startup_script="echo hi > /test.txt",
            service_account={
                "email": default.email,
                "scopes": ["cloud-platform"],
            })
        ```

        ### Confidential Computing

        Example with [Confidential Mode](https://cloud.google.com/confidential-computing/confidential-vm/docs/confidential-vm-overview) activated.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="my-custom-sa",
            display_name="Custom SA for VM Instance")
        confidential_instance = gcp.compute.Instance("confidential_instance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-confidential-instance",
            zone="us-central1-a",
            machine_type="n2d-standard-2",
            min_cpu_platform="AMD Milan",
            confidential_instance_config={
                "enable_confidential_compute": True,
                "confidential_instance_type": "SEV",
            },
            boot_disk={
                "initialize_params": {
                    "image": "ubuntu-os-cloud/ubuntu-2204-lts",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            service_account={
                "email": default.email,
                "scopes": ["cloud-platform"],
            })
        ```

        ## Import

        Instances can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instances/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instances can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instance:Instance default projects/{{project}}/zones/{{zone}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instance:Instance default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAdvancedMachineFeaturesArgs', 'InstanceAdvancedMachineFeaturesArgsDict']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] allow_stopping_for_update: If true, allows this prvider to stop the instance to update its properties.
               If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedDiskArgs', 'InstanceAttachedDiskArgsDict']]]] attached_disks: Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        :param pulumi.Input[Union['InstanceBootDiskArgs', 'InstanceBootDiskArgsDict']] boot_disk: The boot disk for the instance.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs.
               This defaults to false.
        :param pulumi.Input[Union['InstanceConfidentialInstanceConfigArgs', 'InstanceConfidentialInstanceConfigArgsDict']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] deletion_protection: Enable deletion protection on this instance. Defaults to false.
               **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        :param pulumi.Input[builtins.str] description: A brief description of this resource.
        :param pulumi.Input[builtins.str] desired_status: Desired status of the instance. Either
               `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        :param pulumi.Input[builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGuestAcceleratorArgs', 'InstanceGuestAcceleratorArgsDict']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
               **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        :param pulumi.Input[builtins.str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
               Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
               The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InstanceInstanceEncryptionKeyArgs', 'InstanceInstanceEncryptionKeyArgsDict']] instance_encryption_key: Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        :param pulumi.Input[builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] machine_type: The machine type to create.
               
               **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.
               
               [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
               Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
               `lifecycle.ignore_changes` on `machine_type` in these cases.
               
               There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Ssh keys attached in the Cloud Console will be removed.
               Add them to your config in order to keep them attached to your instance.
               A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)
               
               > Depending on the OS you choose for your instance, some metadata keys have
               special functionality.  Most linux-based images will run the content of
               `metadata.startup-script` in a shell on every boot.  At a minimum,
               Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
               support this key.  Windows instances require other keys depending on the format
               of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
               For the convenience of the users of `metadata.startup-script`,
               we provide a special attribute, `metadata_startup_script`, which is documented below.
        :param pulumi.Input[builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, except this one forces the instance to be recreated
               (thus re-running the script) if it is changed. This replaces the startup-script
               metadata key on the created instance and thus the two mechanisms are not
               allowed to be used simultaneously.  Users are free to use either mechanism - the
               only distinction is that this separate attribute will cause a recreate on
               modification.  On import, `metadata_startup_script` will not be set - if you
               choose to specify it you will see a diff immediately after import causing a
               destroy/recreate operation. If importing an instance and specifying this value
               is desired, you will need to modify your state file.
        :param pulumi.Input[builtins.str] min_cpu_platform: Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[builtins.str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to the instance. This can
               be specified multiple times. Structure is documented below.
               
               - - -
        :param pulumi.Input[Union['InstanceNetworkPerformanceConfigArgs', 'InstanceNetworkPerformanceConfigArgsDict']] network_performance_config: (Optional, Beta
               Configures network performance settings for the instance. Structure is
               documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[Union['InstanceParamsArgs', 'InstanceParamsArgsDict']] params: Additional instance parameters.
               .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Union['InstanceReservationAffinityArgs', 'InstanceReservationAffinityArgsDict']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[Union['InstanceSchedulingArgs', 'InstanceSchedulingArgsDict']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceScratchDiskArgs', 'InstanceScratchDiskArgsDict']]]] scratch_disks: Scratch disks to attach to the instance. This can be
               specified multiple times for multiple scratch disks. Structure is documented below.
        :param pulumi.Input[Union['InstanceServiceAccountArgs', 'InstanceServiceAccountArgsDict']] service_account: Service account to attach to the instance.
               Structure is documented below.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Union['InstanceShieldedInstanceConfigArgs', 'InstanceShieldedInstanceConfigArgsDict']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of network tags to attach to the instance.
        :param pulumi.Input[builtins.str] zone: The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VM instance resource within GCE. For more information see
        [the official documentation](https://cloud.google.com/compute/docs/instances)
        and
        [API](https://cloud.google.com/compute/docs/reference/latest/instances).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="my-custom-sa",
            display_name="Custom SA for VM Instance")
        default_instance = gcp.compute.Instance("default",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-instance",
            machine_type="n2-standard-2",
            zone="us-central1-a",
            tags=[
                "foo",
                "bar",
            ],
            boot_disk={
                "initialize_params": {
                    "image": "debian-cloud/debian-11",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            metadata={
                "foo": "bar",
            },
            metadata_startup_script="echo hi > /test.txt",
            service_account={
                "email": default.email,
                "scopes": ["cloud-platform"],
            })
        ```

        ### Confidential Computing

        Example with [Confidential Mode](https://cloud.google.com/confidential-computing/confidential-vm/docs/confidential-vm-overview) activated.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.serviceaccount.Account("default",
            account_id="my-custom-sa",
            display_name="Custom SA for VM Instance")
        confidential_instance = gcp.compute.Instance("confidential_instance",
            network_interfaces=[{
                "access_configs": [{}],
                "network": "default",
            }],
            name="my-confidential-instance",
            zone="us-central1-a",
            machine_type="n2d-standard-2",
            min_cpu_platform="AMD Milan",
            confidential_instance_config={
                "enable_confidential_compute": True,
                "confidential_instance_type": "SEV",
            },
            boot_disk={
                "initialize_params": {
                    "image": "ubuntu-os-cloud/ubuntu-2204-lts",
                    "labels": {
                        "my_label": "value",
                    },
                },
            },
            scratch_disks=[{
                "interface": "NVME",
            }],
            service_account={
                "email": default.email,
                "scopes": ["cloud-platform"],
            })
        ```

        ## Import

        Instances can be imported using any of these accepted formats:

        * `projects/{{project}}/zones/{{zone}}/instances/{{name}}`

        * `{{project}}/{{zone}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, instances can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/instance:Instance default projects/{{project}}/zones/{{zone}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instance:Instance default {{project}}/{{zone}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[Union['InstanceAdvancedMachineFeaturesArgs', 'InstanceAdvancedMachineFeaturesArgsDict']]] = None,
                 allow_stopping_for_update: Optional[pulumi.Input[builtins.bool]] = None,
                 attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedDiskArgs', 'InstanceAttachedDiskArgsDict']]]]] = None,
                 boot_disk: Optional[pulumi.Input[Union['InstanceBootDiskArgs', 'InstanceBootDiskArgsDict']]] = None,
                 can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[Union['InstanceConfidentialInstanceConfigArgs', 'InstanceConfidentialInstanceConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 desired_status: Optional[pulumi.Input[builtins.str]] = None,
                 enable_display: Optional[pulumi.Input[builtins.bool]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGuestAcceleratorArgs', 'InstanceGuestAcceleratorArgsDict']]]]] = None,
                 hostname: Optional[pulumi.Input[builtins.str]] = None,
                 instance_encryption_key: Optional[pulumi.Input[Union['InstanceInstanceEncryptionKeyArgs', 'InstanceInstanceEncryptionKeyArgsDict']]] = None,
                 key_revocation_action_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 machine_type: Optional[pulumi.Input[builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 metadata_startup_script: Optional[pulumi.Input[builtins.str]] = None,
                 min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[Union['InstanceNetworkPerformanceConfigArgs', 'InstanceNetworkPerformanceConfigArgsDict']]] = None,
                 params: Optional[pulumi.Input[Union['InstanceParamsArgs', 'InstanceParamsArgsDict']]] = None,
                 partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reservation_affinity: Optional[pulumi.Input[Union['InstanceReservationAffinityArgs', 'InstanceReservationAffinityArgsDict']]] = None,
                 resource_policies: Optional[pulumi.Input[builtins.str]] = None,
                 scheduling: Optional[pulumi.Input[Union['InstanceSchedulingArgs', 'InstanceSchedulingArgsDict']]] = None,
                 scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceScratchDiskArgs', 'InstanceScratchDiskArgsDict']]]]] = None,
                 service_account: Optional[pulumi.Input[Union['InstanceServiceAccountArgs', 'InstanceServiceAccountArgsDict']]] = None,
                 shielded_instance_config: Optional[pulumi.Input[Union['InstanceShieldedInstanceConfigArgs', 'InstanceShieldedInstanceConfigArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["advanced_machine_features"] = advanced_machine_features
            __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
            __props__.__dict__["attached_disks"] = attached_disks
            if boot_disk is None and not opts.urn:
                raise TypeError("Missing required property 'boot_disk'")
            __props__.__dict__["boot_disk"] = boot_disk
            __props__.__dict__["can_ip_forward"] = can_ip_forward
            __props__.__dict__["confidential_instance_config"] = confidential_instance_config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["desired_status"] = desired_status
            __props__.__dict__["enable_display"] = enable_display
            __props__.__dict__["guest_accelerators"] = guest_accelerators
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["instance_encryption_key"] = instance_encryption_key
            __props__.__dict__["key_revocation_action_type"] = key_revocation_action_type
            __props__.__dict__["labels"] = labels
            if machine_type is None and not opts.urn:
                raise TypeError("Missing required property 'machine_type'")
            __props__.__dict__["machine_type"] = machine_type
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["metadata_startup_script"] = metadata_startup_script
            __props__.__dict__["min_cpu_platform"] = min_cpu_platform
            __props__.__dict__["name"] = name
            if network_interfaces is None and not opts.urn:
                raise TypeError("Missing required property 'network_interfaces'")
            __props__.__dict__["network_interfaces"] = network_interfaces
            __props__.__dict__["network_performance_config"] = network_performance_config
            __props__.__dict__["params"] = params
            __props__.__dict__["partner_metadata"] = partner_metadata
            __props__.__dict__["project"] = project
            __props__.__dict__["reservation_affinity"] = reservation_affinity
            __props__.__dict__["resource_policies"] = resource_policies
            __props__.__dict__["scheduling"] = scheduling
            __props__.__dict__["scratch_disks"] = scratch_disks
            __props__.__dict__["service_account"] = service_account
            __props__.__dict__["shielded_instance_config"] = shielded_instance_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["zone"] = zone
            __props__.__dict__["cpu_platform"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["current_status"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["metadata_fingerprint"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["tags_fingerprint"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:compute/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_machine_features: Optional[pulumi.Input[Union['InstanceAdvancedMachineFeaturesArgs', 'InstanceAdvancedMachineFeaturesArgsDict']]] = None,
            allow_stopping_for_update: Optional[pulumi.Input[builtins.bool]] = None,
            attached_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedDiskArgs', 'InstanceAttachedDiskArgsDict']]]]] = None,
            boot_disk: Optional[pulumi.Input[Union['InstanceBootDiskArgs', 'InstanceBootDiskArgsDict']]] = None,
            can_ip_forward: Optional[pulumi.Input[builtins.bool]] = None,
            confidential_instance_config: Optional[pulumi.Input[Union['InstanceConfidentialInstanceConfigArgs', 'InstanceConfidentialInstanceConfigArgsDict']]] = None,
            cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            current_status: Optional[pulumi.Input[builtins.str]] = None,
            deletion_protection: Optional[pulumi.Input[builtins.bool]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            desired_status: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_display: Optional[pulumi.Input[builtins.bool]] = None,
            guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGuestAcceleratorArgs', 'InstanceGuestAcceleratorArgsDict']]]]] = None,
            hostname: Optional[pulumi.Input[builtins.str]] = None,
            instance_encryption_key: Optional[pulumi.Input[Union['InstanceInstanceEncryptionKeyArgs', 'InstanceInstanceEncryptionKeyArgsDict']]] = None,
            instance_id: Optional[pulumi.Input[builtins.str]] = None,
            key_revocation_action_type: Optional[pulumi.Input[builtins.str]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            machine_type: Optional[pulumi.Input[builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            metadata_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            metadata_startup_script: Optional[pulumi.Input[builtins.str]] = None,
            min_cpu_platform: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]]] = None,
            network_performance_config: Optional[pulumi.Input[Union['InstanceNetworkPerformanceConfigArgs', 'InstanceNetworkPerformanceConfigArgsDict']]] = None,
            params: Optional[pulumi.Input[Union['InstanceParamsArgs', 'InstanceParamsArgsDict']]] = None,
            partner_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reservation_affinity: Optional[pulumi.Input[Union['InstanceReservationAffinityArgs', 'InstanceReservationAffinityArgsDict']]] = None,
            resource_policies: Optional[pulumi.Input[builtins.str]] = None,
            scheduling: Optional[pulumi.Input[Union['InstanceSchedulingArgs', 'InstanceSchedulingArgsDict']]] = None,
            scratch_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceScratchDiskArgs', 'InstanceScratchDiskArgsDict']]]]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[Union['InstanceServiceAccountArgs', 'InstanceServiceAccountArgsDict']]] = None,
            shielded_instance_config: Optional[pulumi.Input[Union['InstanceShieldedInstanceConfigArgs', 'InstanceShieldedInstanceConfigArgsDict']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            tags_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAdvancedMachineFeaturesArgs', 'InstanceAdvancedMachineFeaturesArgsDict']] advanced_machine_features: Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        :param pulumi.Input[builtins.bool] allow_stopping_for_update: If true, allows this prvider to stop the instance to update its properties.
               If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAttachedDiskArgs', 'InstanceAttachedDiskArgsDict']]]] attached_disks: Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        :param pulumi.Input[Union['InstanceBootDiskArgs', 'InstanceBootDiskArgsDict']] boot_disk: The boot disk for the instance.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] can_ip_forward: Whether to allow sending and receiving of
               packets with non-matching source or destination IPs.
               This defaults to false.
        :param pulumi.Input[Union['InstanceConfidentialInstanceConfigArgs', 'InstanceConfidentialInstanceConfigArgsDict']] confidential_instance_config: Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        :param pulumi.Input[builtins.str] cpu_platform: The CPU platform used by this instance.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] current_status: The current status of the instance. This could be one of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see [Instance life cycle](https://cloud.google.com/compute/docs/instances/instance-life-cycle).
        :param pulumi.Input[builtins.bool] deletion_protection: Enable deletion protection on this instance. Defaults to false.
               **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        :param pulumi.Input[builtins.str] description: A brief description of this resource.
        :param pulumi.Input[builtins.str] desired_status: Desired status of the instance. Either
               `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_display: Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceGuestAcceleratorArgs', 'InstanceGuestAcceleratorArgsDict']]]] guest_accelerators: List of the type and count of accelerator cards attached to the instance. Structure documented below.
               **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        :param pulumi.Input[builtins.str] hostname: A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
               Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
               The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['InstanceInstanceEncryptionKeyArgs', 'InstanceInstanceEncryptionKeyArgsDict']] instance_encryption_key: Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        :param pulumi.Input[builtins.str] instance_id: The server-assigned unique identifier of this instance.
        :param pulumi.Input[builtins.str] key_revocation_action_type: Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        :param pulumi.Input[builtins.str] label_fingerprint: The unique fingerprint of the labels.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: A map of key/value label pairs to assign to the instance.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field 'effective_labels' for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] machine_type: The machine type to create.
               
               **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.
               
               [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
               Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
               `lifecycle.ignore_changes` on `machine_type` in these cases.
               
               There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: Metadata key/value pairs to make available from
               within the instance. Ssh keys attached in the Cloud Console will be removed.
               Add them to your config in order to keep them attached to your instance.
               A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)
               
               > Depending on the OS you choose for your instance, some metadata keys have
               special functionality.  Most linux-based images will run the content of
               `metadata.startup-script` in a shell on every boot.  At a minimum,
               Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
               support this key.  Windows instances require other keys depending on the format
               of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
               For the convenience of the users of `metadata.startup-script`,
               we provide a special attribute, `metadata_startup_script`, which is documented below.
        :param pulumi.Input[builtins.str] metadata_fingerprint: The unique fingerprint of the metadata.
        :param pulumi.Input[builtins.str] metadata_startup_script: An alternative to using the
               startup-script metadata key, except this one forces the instance to be recreated
               (thus re-running the script) if it is changed. This replaces the startup-script
               metadata key on the created instance and thus the two mechanisms are not
               allowed to be used simultaneously.  Users are free to use either mechanism - the
               only distinction is that this separate attribute will cause a recreate on
               modification.  On import, `metadata_startup_script` will not be set - if you
               choose to specify it you will see a diff immediately after import causing a
               destroy/recreate operation. If importing an instance and specifying this value
               is desired, you will need to modify your state file.
        :param pulumi.Input[builtins.str] min_cpu_platform: Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
               `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[builtins.str] name: A unique name for the resource, required by GCE.
               Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkInterfaceArgs', 'InstanceNetworkInterfaceArgsDict']]]] network_interfaces: Networks to attach to the instance. This can
               be specified multiple times. Structure is documented below.
               
               - - -
        :param pulumi.Input[Union['InstanceNetworkPerformanceConfigArgs', 'InstanceNetworkPerformanceConfigArgsDict']] network_performance_config: (Optional, Beta
               Configures network performance settings for the instance. Structure is
               documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
               the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
               in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
               in order for this setting to take effect.
        :param pulumi.Input[Union['InstanceParamsArgs', 'InstanceParamsArgsDict']] params: Additional instance parameters.
               .
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] partner_metadata: Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs. If it
               is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource and default labels configured on the provider.
        :param pulumi.Input[Union['InstanceReservationAffinityArgs', 'InstanceReservationAffinityArgsDict']] reservation_affinity: Specifies the reservations that this instance can consume from.
               Structure is documented below.
        :param pulumi.Input[builtins.str] resource_policies: - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        :param pulumi.Input[Union['InstanceSchedulingArgs', 'InstanceSchedulingArgsDict']] scheduling: The scheduling strategy to use. More details about
               this configuration option are detailed below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceScratchDiskArgs', 'InstanceScratchDiskArgsDict']]]] scratch_disks: Scratch disks to attach to the instance. This can be
               specified multiple times for multiple scratch disks. Structure is documented below.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Union['InstanceServiceAccountArgs', 'InstanceServiceAccountArgsDict']] service_account: Service account to attach to the instance.
               Structure is documented below.
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Union['InstanceShieldedInstanceConfigArgs', 'InstanceShieldedInstanceConfigArgsDict']] shielded_instance_config: Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
               **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
               **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of network tags to attach to the instance.
        :param pulumi.Input[builtins.str] tags_fingerprint: The unique fingerprint of the tags.
        :param pulumi.Input[builtins.str] zone: The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["advanced_machine_features"] = advanced_machine_features
        __props__.__dict__["allow_stopping_for_update"] = allow_stopping_for_update
        __props__.__dict__["attached_disks"] = attached_disks
        __props__.__dict__["boot_disk"] = boot_disk
        __props__.__dict__["can_ip_forward"] = can_ip_forward
        __props__.__dict__["confidential_instance_config"] = confidential_instance_config
        __props__.__dict__["cpu_platform"] = cpu_platform
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["current_status"] = current_status
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["desired_status"] = desired_status
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_display"] = enable_display
        __props__.__dict__["guest_accelerators"] = guest_accelerators
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["instance_encryption_key"] = instance_encryption_key
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["key_revocation_action_type"] = key_revocation_action_type
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["machine_type"] = machine_type
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["metadata_fingerprint"] = metadata_fingerprint
        __props__.__dict__["metadata_startup_script"] = metadata_startup_script
        __props__.__dict__["min_cpu_platform"] = min_cpu_platform
        __props__.__dict__["name"] = name
        __props__.__dict__["network_interfaces"] = network_interfaces
        __props__.__dict__["network_performance_config"] = network_performance_config
        __props__.__dict__["params"] = params
        __props__.__dict__["partner_metadata"] = partner_metadata
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reservation_affinity"] = reservation_affinity
        __props__.__dict__["resource_policies"] = resource_policies
        __props__.__dict__["scheduling"] = scheduling
        __props__.__dict__["scratch_disks"] = scratch_disks
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["shielded_instance_config"] = shielded_instance_config
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tags_fingerprint"] = tags_fingerprint
        __props__.__dict__["zone"] = zone
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> pulumi.Output[Optional['outputs.InstanceAdvancedMachineFeatures']]:
        """
        Configure Nested Virtualisation and Simultaneous Hyper Threading  on this VM. Structure is documented below
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="allowStoppingForUpdate")
    def allow_stopping_for_update(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, allows this prvider to stop the instance to update its properties.
        If you try to update a property that requires stopping the instance without setting this field, the update will fail.
        """
        return pulumi.get(self, "allow_stopping_for_update")

    @property
    @pulumi.getter(name="attachedDisks")
    def attached_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceAttachedDisk']]]:
        """
        Additional disks to attach to the instance. Can be repeated multiple times for multiple disks. Structure is documented below.
        """
        return pulumi.get(self, "attached_disks")

    @property
    @pulumi.getter(name="bootDisk")
    def boot_disk(self) -> pulumi.Output['outputs.InstanceBootDisk']:
        """
        The boot disk for the instance.
        Structure is documented below.
        """
        return pulumi.get(self, "boot_disk")

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to allow sending and receiving of
        packets with non-matching source or destination IPs.
        This defaults to false.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> pulumi.Output['outputs.InstanceConfidentialInstanceConfig']:
        """
        Enable [Confidential Mode](https://cloud.google.com/compute/confidential-vm/docs/about-cvm) on this VM. Structure is documented below
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter(name="cpuPlatform")
    def cpu_platform(self) -> pulumi.Output[builtins.str]:
        """
        The CPU platform used by this instance.
        """
        return pulumi.get(self, "cpu_platform")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the instance. This could be one of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see [Instance life cycle](https://cloud.google.com/compute/docs/instances/instance-life-cycle).
        """
        return pulumi.get(self, "current_status")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable deletion protection on this instance. Defaults to false.
        **Note:** you must disable deletion protection before removing the resource (e.g., via `pulumi destroy`), or the instance cannot be deleted and the provider run will not complete successfully.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A brief description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="desiredStatus")
    def desired_status(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Desired status of the instance. Either
        `"RUNNING"`, `"SUSPENDED"` or `"TERMINATED"`.
        """
        return pulumi.get(self, "desired_status")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableDisplay")
    def enable_display(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Enable [Virtual Displays](https://cloud.google.com/compute/docs/instances/enable-instance-virtual-display#verify_display_driver) on this instance.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "enable_display")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> pulumi.Output[Sequence['outputs.InstanceGuestAccelerator']]:
        """
        List of the type and count of accelerator cards attached to the instance. Structure documented below.
        **Note:** GPU accelerators can only be used with `on_host_maintenance` option set to TERMINATE.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A custom hostname for the instance. Must be a fully qualified DNS name and RFC-1035-valid.
        Valid format is a series of labels 1-63 characters long matching the regular expression `a-z`, concatenated with periods.
        The entire hostname must not exceed 253 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceEncryptionKey")
    def instance_encryption_key(self) -> pulumi.Output[Optional['outputs.InstanceInstanceEncryptionKey']]:
        """
        Configuration for data encryption on the instance with encryption keys. Structure is documented below.
        """
        return pulumi.get(self, "instance_encryption_key")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[builtins.str]:
        """
        The server-assigned unique identifier of this instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="keyRevocationActionType")
    def key_revocation_action_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Action to be taken when a customer's encryption key is revoked. Supports `STOP` and `NONE`, with `NONE` being the default.
        """
        return pulumi.get(self, "key_revocation_action_type")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The unique fingerprint of the labels.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of key/value label pairs to assign to the instance.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field 'effective_labels' for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[builtins.str]:
        """
        The machine type to create.

        **Note:** If you want to update this value (resize the VM) after initial creation, you must set `allow_stopping_for_update` to `true`.

        [Custom machine types](https://cloud.google.com/dataproc/docs/concepts/compute/custom-machine-types) can be formatted as `custom-NUMBER_OF_CPUS-AMOUNT_OF_MEMORY_MB`, e.g. `custom-6-20480` for 6 vCPU and 20GB of RAM.
        Because of current API limitations some custom machine types may get converted to different machine types (such as an equivalent standard type) and cause non-empty plans in your configuration. Use
        `lifecycle.ignore_changes` on `machine_type` in these cases.

        There is a limit of 6.5 GB per CPU unless you add [extended memory](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#extendedmemory). You must do this explicitly by adding the suffix `-ext`, e.g. `custom-2-15360-ext` for 2 vCPU and 15 GB of memory.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Metadata key/value pairs to make available from
        within the instance. Ssh keys attached in the Cloud Console will be removed.
        Add them to your config in order to keep them attached to your instance.
        A list of predefined metadata keys (e.g. ssh-keys) can be found [here](https://cloud.google.com/compute/docs/metadata/predefined-metadata-keys)

        > Depending on the OS you choose for your instance, some metadata keys have
        special functionality.  Most linux-based images will run the content of
        `metadata.startup-script` in a shell on every boot.  At a minimum,
        Debian, CentOS, RHEL, SLES, Container-Optimized OS, and Ubuntu images
        support this key.  Windows instances require other keys depending on the format
        of the script and the time you would like it to run - see [this table](https://cloud.google.com/compute/docs/startupscript#providing_a_startup_script_for_windows_instances).
        For the convenience of the users of `metadata.startup-script`,
        we provide a special attribute, `metadata_startup_script`, which is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="metadataFingerprint")
    def metadata_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The unique fingerprint of the metadata.
        """
        return pulumi.get(self, "metadata_fingerprint")

    @property
    @pulumi.getter(name="metadataStartupScript")
    def metadata_startup_script(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An alternative to using the
        startup-script metadata key, except this one forces the instance to be recreated
        (thus re-running the script) if it is changed. This replaces the startup-script
        metadata key on the created instance and thus the two mechanisms are not
        allowed to be used simultaneously.  Users are free to use either mechanism - the
        only distinction is that this separate attribute will cause a recreate on
        modification.  On import, `metadata_startup_script` will not be set - if you
        choose to specify it you will see a diff immediately after import causing a
        destroy/recreate operation. If importing an instance and specifying this value
        is desired, you will need to modify your state file.
        """
        return pulumi.get(self, "metadata_startup_script")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[builtins.str]:
        """
        Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as
        `Intel Haswell` or `Intel Skylake`. See the complete list [here](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        A unique name for the resource, required by GCE.
        Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.InstanceNetworkInterface']]:
        """
        Networks to attach to the instance. This can
        be specified multiple times. Structure is documented below.

        - - -
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> pulumi.Output[Optional['outputs.InstanceNetworkPerformanceConfig']]:
        """
        (Optional, Beta
        Configures network performance settings for the instance. Structure is
        documented below. **Note**: `machine_type` must be a [supported type](https://cloud.google.com/compute/docs/networking/configure-vm-with-high-bandwidth-configuration),
        the `image` used must include the [`GVNIC`](https://cloud.google.com/compute/docs/networking/using-gvnic#create-instance-gvnic-image)
        in `guest-os-features`, and `network_interface.0.nic-type` must be `GVNIC`
        in order for this setting to take effect.
        """
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.InstanceParams']]:
        """
        Additional instance parameters.
        .
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Beta key/value pair represents partner metadata assigned to instance where key represent a defined namespace and value is a json string represent the entries associted with the namespace.
        """
        return pulumi.get(self, "partner_metadata")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs. If it
        is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> pulumi.Output['outputs.InstanceReservationAffinity']:
        """
        Specifies the reservations that this instance can consume from.
        Structure is documented below.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        - A list of self_links of resource policies to attach to the instance. Modifying this list will cause the instance to recreate. Currently a max of 1 resource policy is supported.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.InstanceScheduling']:
        """
        The scheduling strategy to use. More details about
        this configuration option are detailed below.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="scratchDisks")
    def scratch_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceScratchDisk']]]:
        """
        Scratch disks to attach to the instance. This can be
        specified multiple times for multiple scratch disks. Structure is documented below.
        """
        return pulumi.get(self, "scratch_disks")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[Optional['outputs.InstanceServiceAccount']]:
        """
        Service account to attach to the instance.
        Structure is documented below.
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.InstanceShieldedInstanceConfig']:
        """
        Enable [Shielded VM](https://cloud.google.com/security/shielded-cloud/shielded-vm) on this instance. Shielded VM provides verifiable integrity to prevent against malware and rootkits. Defaults to disabled. Structure is documented below.
        **Note**: `shielded_instance_config` can only be used with boot images with shielded vm support. See the complete list [here](https://cloud.google.com/compute/docs/images#shielded-images).
        **Note**: `allow_stopping_for_update` must be set to true or your instance must have a `desired_status` of `TERMINATED` in order to update this field.
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of network tags to attach to the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tagsFingerprint")
    def tags_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        The unique fingerprint of the tags.
        """
        return pulumi.get(self, "tags_fingerprint")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        The zone that the machine should be created in. If it is not provided, the provider zone is used.
        """
        return pulumi.get(self, "zone")

