# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectAttachmentArgs', 'InterconnectAttachment']

@pulumi.input_type
class InterconnectAttachmentArgs:
    def __init__(__self__, *,
                 router: pulumi.Input[builtins.str],
                 admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input[builtins.str]] = None,
                 interconnect: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 mtu: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_length: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a InterconnectAttachment resource.
        :param pulumi.Input[builtins.str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[builtins.bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[builtins.str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        :param pulumi.Input[builtins.str] candidate_cloud_router_ip_address: Single IPv4 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 203.0.113.1/29
        :param pulumi.Input[builtins.str] candidate_cloud_router_ipv6_address: Single IPv6 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 2001:db8::1/125
        :param pulumi.Input[builtins.str] candidate_customer_router_ip_address: Single IPv4 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 203.0.113.2/29
        :param pulumi.Input[builtins.str] candidate_customer_router_ipv6_address: Single IPv6 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 2001:db8::2/125
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[builtins.str] encryption: Indicates the user-supplied encryption option of this interconnect
               attachment. Can only be specified at attachment creation for PARTNER or
               DEDICATED attachments.
               * NONE - This is the default value, which means that the VLAN attachment
               carries unencrypted traffic. VMs are able to send traffic to, or receive
               traffic from, such a VLAN attachment.
               * IPSEC - The VLAN attachment carries only encrypted traffic that is
               encrypted by an IPsec device, such as an HA VPN gateway or third-party
               IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
               such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
               attachment must be created with this option.
               Default value is `NONE`.
               Possible values are: `NONE`, `IPSEC`.
        :param pulumi.Input[builtins.str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment,
               Used only for interconnect attachment that has the encryption option as
               IPSEC.
               The addresses must be RFC 1918 IP address ranges. When creating HA VPN
               gateway over the interconnect attachment, if the attachment is configured
               to use an RFC 1918 IP address, then the VPN gateway's IP address will be
               allocated from the IP address range specified here.
               For example, if the HA VPN gateway's interface 0 is paired to this
               interconnect attachment, then an RFC 1918 IP address for the VPN gateway
               interface 0 will be allocated from the IP address specified for this
               interconnect attachment.
               If this field is not specified for interconnect attachment that has
               encryption option as IPSEC, later on when creating HA VPN gateway on this
               interconnect attachment, the HA VPN gateway's IP address will be
               allocated from regional external IP address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
               Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this interconnect attachment to identify whether the IPv6
               feature is enabled or not. If not specified, IPV4_ONLY will be used.
               This field can be both set at interconnect attachments creation and update
               interconnect attachment operations.
               Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        :param pulumi.Input[builtins.int] subnet_length: Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
               except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
               constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
               remote location fall into this category. In these cases, the default value is 30, and
               requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
               gives Google Cloud Support more debugging visibility.
        :param pulumi.Input[builtins.str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        :param pulumi.Input[builtins.int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        pulumi.set(__self__, "router", router)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if candidate_cloud_router_ip_address is not None:
            pulumi.set(__self__, "candidate_cloud_router_ip_address", candidate_cloud_router_ip_address)
        if candidate_cloud_router_ipv6_address is not None:
            pulumi.set(__self__, "candidate_cloud_router_ipv6_address", candidate_cloud_router_ipv6_address)
        if candidate_customer_router_ip_address is not None:
            pulumi.set(__self__, "candidate_customer_router_ip_address", candidate_customer_router_ip_address)
        if candidate_customer_router_ipv6_address is not None:
            pulumi.set(__self__, "candidate_customer_router_ipv6_address", candidate_customer_router_ipv6_address)
        if candidate_subnets is not None:
            pulumi.set(__self__, "candidate_subnets", candidate_subnets)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_availability_domain is not None:
            pulumi.set(__self__, "edge_availability_domain", edge_availability_domain)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if ipsec_internal_addresses is not None:
            pulumi.set(__self__, "ipsec_internal_addresses", ipsec_internal_addresses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if subnet_length is not None:
            pulumi.set(__self__, "subnet_length", subnet_length)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_tag8021q is not None:
            pulumi.set(__self__, "vlan_tag8021q", vlan_tag8021q)

    @property
    @pulumi.getter
    def router(self) -> pulumi.Input[builtins.str]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="candidateCloudRouterIpAddress")
    def candidate_cloud_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 203.0.113.1/29
        """
        return pulumi.get(self, "candidate_cloud_router_ip_address")

    @candidate_cloud_router_ip_address.setter
    def candidate_cloud_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_cloud_router_ip_address", value)

    @property
    @pulumi.getter(name="candidateCloudRouterIpv6Address")
    def candidate_cloud_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 2001:db8::1/125
        """
        return pulumi.get(self, "candidate_cloud_router_ipv6_address")

    @candidate_cloud_router_ipv6_address.setter
    def candidate_cloud_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_cloud_router_ipv6_address", value)

    @property
    @pulumi.getter(name="candidateCustomerRouterIpAddress")
    def candidate_customer_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 203.0.113.2/29
        """
        return pulumi.get(self, "candidate_customer_router_ip_address")

    @candidate_customer_router_ip_address.setter
    def candidate_customer_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_customer_router_ip_address", value)

    @property
    @pulumi.getter(name="candidateCustomerRouterIpv6Address")
    def candidate_customer_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 2001:db8::2/125
        """
        return pulumi.get(self, "candidate_customer_router_ipv6_address")

    @candidate_customer_router_ipv6_address.setter
    def candidate_customer_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_customer_router_ipv6_address", value)

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @candidate_subnets.setter
    def candidate_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "candidate_subnets", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @edge_availability_domain.setter
    def edge_availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_availability_domain", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the user-supplied encryption option of this interconnect
        attachment. Can only be specified at attachment creation for PARTNER or
        DEDICATED attachments.
        * NONE - This is the default value, which means that the VLAN attachment
        carries unencrypted traffic. VMs are able to send traffic to, or receive
        traffic from, such a VLAN attachment.
        * IPSEC - The VLAN attachment carries only encrypted traffic that is
        encrypted by an IPsec device, such as an HA VPN gateway or third-party
        IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
        such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
        attachment must be created with this option.
        Default value is `NONE`.
        Possible values are: `NONE`, `IPSEC`.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment,
        Used only for interconnect attachment that has the encryption option as
        IPSEC.
        The addresses must be RFC 1918 IP address ranges. When creating HA VPN
        gateway over the interconnect attachment, if the attachment is configured
        to use an RFC 1918 IP address, then the VPN gateway's IP address will be
        allocated from the IP address range specified here.
        For example, if the HA VPN gateway's interface 0 is paired to this
        interconnect attachment, then an RFC 1918 IP address for the VPN gateway
        interface 0 will be allocated from the IP address specified for this
        interconnect attachment.
        If this field is not specified for interconnect attachment that has
        encryption option as IPSEC, later on when creating HA VPN gateway on this
        interconnect attachment, the HA VPN gateway's IP address will be
        allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @ipsec_internal_addresses.setter
    def ipsec_internal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipsec_internal_addresses", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
        Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stack type for this interconnect attachment to identify whether the IPv6
        feature is enabled or not. If not specified, IPV4_ONLY will be used.
        This field can be both set at interconnect attachments creation and update
        interconnect attachment operations.
        Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter(name="subnetLength")
    def subnet_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
        except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
        constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
        remote location fall into this category. In these cases, the default value is 30, and
        requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
        gives Google Cloud Support more debugging visibility.
        """
        return pulumi.get(self, "subnet_length")

    @subnet_length.setter
    def subnet_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "subnet_length", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

    @vlan_tag8021q.setter
    def vlan_tag8021q(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag8021q", value)


@pulumi.input_type
class _InterconnectAttachmentState:
    def __init__(__self__, *,
                 admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 attachment_group: Optional[pulumi.Input[builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 encryption: Optional[pulumi.Input[builtins.str]] = None,
                 google_reference_id: Optional[pulumi.Input[builtins.str]] = None,
                 interconnect: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 mtu: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 pairing_key: Optional[pulumi.Input[builtins.str]] = None,
                 partner_asn: Optional[pulumi.Input[builtins.str]] = None,
                 private_interconnect_infos: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_length: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering InterconnectAttachment resources.
        :param pulumi.Input[builtins.bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[builtins.str] attachment_group: URL of the AttachmentGroup that includes this Attachment.
        :param pulumi.Input[builtins.str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        :param pulumi.Input[builtins.str] candidate_cloud_router_ip_address: Single IPv4 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 203.0.113.1/29
        :param pulumi.Input[builtins.str] candidate_cloud_router_ipv6_address: Single IPv6 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 2001:db8::1/125
        :param pulumi.Input[builtins.str] candidate_customer_router_ip_address: Single IPv4 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 203.0.113.2/29
        :param pulumi.Input[builtins.str] candidate_customer_router_ipv6_address: Single IPv6 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 2001:db8::2/125
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[builtins.str] cloud_router_ip_address: IPv4 address + prefix length to be configured on Cloud Router
               Interface for this interconnect attachment.
        :param pulumi.Input[builtins.str] cloud_router_ipv6_address: IPv6 address + prefix length to be configured on Cloud Router
               Interface for this interconnect attachment.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] customer_router_ip_address: IPv4 address + prefix length to be configured on the customer
               router subinterface for this interconnect attachment.
        :param pulumi.Input[builtins.str] customer_router_ipv6_address: IPv6 address + prefix length to be configured on the customer
               router subinterface for this interconnect attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] encryption: Indicates the user-supplied encryption option of this interconnect
               attachment. Can only be specified at attachment creation for PARTNER or
               DEDICATED attachments.
               * NONE - This is the default value, which means that the VLAN attachment
               carries unencrypted traffic. VMs are able to send traffic to, or receive
               traffic from, such a VLAN attachment.
               * IPSEC - The VLAN attachment carries only encrypted traffic that is
               encrypted by an IPsec device, such as an HA VPN gateway or third-party
               IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
               such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
               attachment must be created with this option.
               Default value is `NONE`.
               Possible values are: `NONE`, `IPSEC`.
        :param pulumi.Input[builtins.str] google_reference_id: Google reference ID, to be used when raising support tickets with
               Google or otherwise to debug backend connectivity issues.
        :param pulumi.Input[builtins.str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment,
               Used only for interconnect attachment that has the encryption option as
               IPSEC.
               The addresses must be RFC 1918 IP address ranges. When creating HA VPN
               gateway over the interconnect attachment, if the attachment is configured
               to use an RFC 1918 IP address, then the VPN gateway's IP address will be
               allocated from the IP address range specified here.
               For example, if the HA VPN gateway's interface 0 is paired to this
               interconnect attachment, then an RFC 1918 IP address for the VPN gateway
               interface 0 will be allocated from the IP address specified for this
               interconnect attachment.
               If this field is not specified for interconnect attachment that has
               encryption option as IPSEC, later on when creating HA VPN gateway on this
               interconnect attachment, the HA VPN gateway's IP address will be
               allocated from regional external IP address pool.
        :param pulumi.Input[builtins.str] label_fingerprint: A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
               Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] pairing_key: [Output only for type PARTNER. Not present for DEDICATED]. The opaque
               identifier of an PARTNER attachment used to initiate provisioning with
               a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[builtins.str] partner_asn: [Output only for type PARTNER. Not present for DEDICATED]. Optional
               BGP ASN for the router that should be supplied by a layer 3 Partner if
               they configured BGP on behalf of the customer.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]] private_interconnect_infos: Information specific to an InterconnectAttachment. This property
               is populated if the interconnect that this is attached to is of type DEDICATED.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[builtins.str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this interconnect attachment to identify whether the IPv6
               feature is enabled or not. If not specified, IPV4_ONLY will be used.
               This field can be both set at interconnect attachments creation and update
               interconnect attachment operations.
               Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        :param pulumi.Input[builtins.str] state: [Output Only] The current state of this attachment's functionality.
        :param pulumi.Input[builtins.int] subnet_length: Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
               except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
               constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
               remote location fall into this category. In these cases, the default value is 30, and
               requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
               gives Google Cloud Support more debugging visibility.
        :param pulumi.Input[builtins.str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        :param pulumi.Input[builtins.int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if attachment_group is not None:
            pulumi.set(__self__, "attachment_group", attachment_group)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if candidate_cloud_router_ip_address is not None:
            pulumi.set(__self__, "candidate_cloud_router_ip_address", candidate_cloud_router_ip_address)
        if candidate_cloud_router_ipv6_address is not None:
            pulumi.set(__self__, "candidate_cloud_router_ipv6_address", candidate_cloud_router_ipv6_address)
        if candidate_customer_router_ip_address is not None:
            pulumi.set(__self__, "candidate_customer_router_ip_address", candidate_customer_router_ip_address)
        if candidate_customer_router_ipv6_address is not None:
            pulumi.set(__self__, "candidate_customer_router_ipv6_address", candidate_customer_router_ipv6_address)
        if candidate_subnets is not None:
            pulumi.set(__self__, "candidate_subnets", candidate_subnets)
        if cloud_router_ip_address is not None:
            pulumi.set(__self__, "cloud_router_ip_address", cloud_router_ip_address)
        if cloud_router_ipv6_address is not None:
            pulumi.set(__self__, "cloud_router_ipv6_address", cloud_router_ipv6_address)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if customer_router_ip_address is not None:
            pulumi.set(__self__, "customer_router_ip_address", customer_router_ip_address)
        if customer_router_ipv6_address is not None:
            pulumi.set(__self__, "customer_router_ipv6_address", customer_router_ipv6_address)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_availability_domain is not None:
            pulumi.set(__self__, "edge_availability_domain", edge_availability_domain)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if google_reference_id is not None:
            pulumi.set(__self__, "google_reference_id", google_reference_id)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if ipsec_internal_addresses is not None:
            pulumi.set(__self__, "ipsec_internal_addresses", ipsec_internal_addresses)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pairing_key is not None:
            pulumi.set(__self__, "pairing_key", pairing_key)
        if partner_asn is not None:
            pulumi.set(__self__, "partner_asn", partner_asn)
        if private_interconnect_infos is not None:
            pulumi.set(__self__, "private_interconnect_infos", private_interconnect_infos)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if stack_type is not None:
            pulumi.set(__self__, "stack_type", stack_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_length is not None:
            pulumi.set(__self__, "subnet_length", subnet_length)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_tag8021q is not None:
            pulumi.set(__self__, "vlan_tag8021q", vlan_tag8021q)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter(name="attachmentGroup")
    def attachment_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the AttachmentGroup that includes this Attachment.
        """
        return pulumi.get(self, "attachment_group")

    @attachment_group.setter
    def attachment_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "attachment_group", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="candidateCloudRouterIpAddress")
    def candidate_cloud_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 203.0.113.1/29
        """
        return pulumi.get(self, "candidate_cloud_router_ip_address")

    @candidate_cloud_router_ip_address.setter
    def candidate_cloud_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_cloud_router_ip_address", value)

    @property
    @pulumi.getter(name="candidateCloudRouterIpv6Address")
    def candidate_cloud_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 2001:db8::1/125
        """
        return pulumi.get(self, "candidate_cloud_router_ipv6_address")

    @candidate_cloud_router_ipv6_address.setter
    def candidate_cloud_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_cloud_router_ipv6_address", value)

    @property
    @pulumi.getter(name="candidateCustomerRouterIpAddress")
    def candidate_customer_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 203.0.113.2/29
        """
        return pulumi.get(self, "candidate_customer_router_ip_address")

    @candidate_customer_router_ip_address.setter
    def candidate_customer_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_customer_router_ip_address", value)

    @property
    @pulumi.getter(name="candidateCustomerRouterIpv6Address")
    def candidate_customer_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 2001:db8::2/125
        """
        return pulumi.get(self, "candidate_customer_router_ipv6_address")

    @candidate_customer_router_ipv6_address.setter
    def candidate_customer_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "candidate_customer_router_ipv6_address", value)

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @candidate_subnets.setter
    def candidate_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "candidate_subnets", value)

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address + prefix length to be configured on Cloud Router
        Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @cloud_router_ip_address.setter
    def cloud_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_router_ip_address", value)

    @property
    @pulumi.getter(name="cloudRouterIpv6Address")
    def cloud_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address + prefix length to be configured on Cloud Router
        Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ipv6_address")

    @cloud_router_ipv6_address.setter
    def cloud_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_router_ipv6_address", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv4 address + prefix length to be configured on the customer
        router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @customer_router_ip_address.setter
    def customer_router_ip_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_router_ip_address", value)

    @property
    @pulumi.getter(name="customerRouterIpv6Address")
    def customer_router_ipv6_address(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        IPv6 address + prefix length to be configured on the customer
        router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ipv6_address")

    @customer_router_ipv6_address.setter
    def customer_router_ipv6_address(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "customer_router_ipv6_address", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @edge_availability_domain.setter
    def edge_availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edge_availability_domain", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the user-supplied encryption option of this interconnect
        attachment. Can only be specified at attachment creation for PARTNER or
        DEDICATED attachments.
        * NONE - This is the default value, which means that the VLAN attachment
        carries unencrypted traffic. VMs are able to send traffic to, or receive
        traffic from, such a VLAN attachment.
        * IPSEC - The VLAN attachment carries only encrypted traffic that is
        encrypted by an IPsec device, such as an HA VPN gateway or third-party
        IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
        such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
        attachment must be created with this option.
        Default value is `NONE`.
        Possible values are: `NONE`, `IPSEC`.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Google reference ID, to be used when raising support tickets with
        Google or otherwise to debug backend connectivity issues.
        """
        return pulumi.get(self, "google_reference_id")

    @google_reference_id.setter
    def google_reference_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "google_reference_id", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment,
        Used only for interconnect attachment that has the encryption option as
        IPSEC.
        The addresses must be RFC 1918 IP address ranges. When creating HA VPN
        gateway over the interconnect attachment, if the attachment is configured
        to use an RFC 1918 IP address, then the VPN gateway's IP address will be
        allocated from the IP address range specified here.
        For example, if the HA VPN gateway's interface 0 is paired to this
        interconnect attachment, then an RFC 1918 IP address for the VPN gateway
        interface 0 will be allocated from the IP address specified for this
        interconnect attachment.
        If this field is not specified for interconnect attachment that has
        encryption option as IPSEC, later on when creating HA VPN gateway on this
        interconnect attachment, the HA VPN gateway's IP address will be
        allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @ipsec_internal_addresses.setter
    def ipsec_internal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "ipsec_internal_addresses", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
        Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. The opaque
        identifier of an PARTNER attachment used to initiate provisioning with
        a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @pairing_key.setter
    def pairing_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pairing_key", value)

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. Optional
        BGP ASN for the router that should be supplied by a layer 3 Partner if
        they configured BGP on behalf of the customer.
        """
        return pulumi.get(self, "partner_asn")

    @partner_asn.setter
    def partner_asn(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "partner_asn", value)

    @property
    @pulumi.getter(name="privateInterconnectInfos")
    def private_interconnect_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]]:
        """
        Information specific to an InterconnectAttachment. This property
        is populated if the interconnect that this is attached to is of type DEDICATED.
        Structure is documented below.
        """
        return pulumi.get(self, "private_interconnect_infos")

    @private_interconnect_infos.setter
    def private_interconnect_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentPrivateInterconnectInfoArgs']]]]):
        pulumi.set(self, "private_interconnect_infos", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The stack type for this interconnect attachment to identify whether the IPv6
        feature is enabled or not. If not specified, IPV4_ONLY will be used.
        This field can be both set at interconnect attachments creation and update
        interconnect attachment operations.
        Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @stack_type.setter
    def stack_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "stack_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        [Output Only] The current state of this attachment's functionality.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetLength")
    def subnet_length(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
        except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
        constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
        remote location fall into this category. In these cases, the default value is 30, and
        requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
        gives Google Cloud Support more debugging visibility.
        """
        return pulumi.get(self, "subnet_length")

    @subnet_length.setter
    def subnet_length(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "subnet_length", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

    @vlan_tag8021q.setter
    def vlan_tag8021q(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vlan_tag8021q", value)


@pulumi.type_token("gcp:compute/interconnectAttachment:InterconnectAttachment")
class InterconnectAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input[builtins.str]] = None,
                 interconnect: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 mtu: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_length: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Represents an InterconnectAttachment (VLAN attachment) resource. For more
        information, see Creating VLAN Attachments.

        To get more information about InterconnectAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectAttachments)
        * How-to Guides
            * [Create a Interconnect attachment](https://cloud.google.com/network-connectivity/docs/interconnect/how-to/dedicated/creating-vlan-attachments)

        ## Example Usage

        ### Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobar",
            name="network-1",
            auto_create_subnetworks=False)
        foobar = gcp.compute.Router("foobar",
            name="router-1",
            network=foobar_network.name,
            bgp={
                "asn": 16550,
            })
        on_prem = gcp.compute.InterconnectAttachment("on_prem",
            name="on-prem-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar.id,
            mtu="1500",
            labels={
                "mykey": "myvalue",
            })
        ```
        ### Compute Interconnect Attachment Ipsec Encryption

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-network",
            auto_create_subnetworks=False)
        address = gcp.compute.Address("address",
            name="test-address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        router = gcp.compute.Router("router",
            name="test-router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp={
                "asn": 16550,
            })
        ipsec_encrypted_interconnect_attachment = gcp.compute.InterconnectAttachment("ipsec-encrypted-interconnect-attachment",
            name="test-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address.self_link])
        ```
        ### Compute Interconnect Attachment Custom Ranges

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobar",
            name="test-network",
            auto_create_subnetworks=False)
        foobar = gcp.compute.Router("foobar",
            name="test-router",
            network=foobar_network.name,
            bgp={
                "asn": 16550,
            })
        custom_ranges_interconnect_attachment = gcp.compute.InterconnectAttachment("custom-ranges-interconnect-attachment",
            name="test-custom-ranges-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar.id,
            mtu="1500",
            stack_type="IPV4_IPV6",
            labels={
                "mykey": "myvalue",
            },
            candidate_cloud_router_ip_address="192.169.0.1/29",
            candidate_customer_router_ip_address="192.169.0.2/29",
            candidate_cloud_router_ipv6_address="748d:2f23:6651:9455:828b:ca81:6fe0:fed1/125",
            candidate_customer_router_ipv6_address="748d:2f23:6651:9455:828b:ca81:6fe0:fed2/125")
        ```

        ## Import

        InterconnectAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[builtins.str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        :param pulumi.Input[builtins.str] candidate_cloud_router_ip_address: Single IPv4 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 203.0.113.1/29
        :param pulumi.Input[builtins.str] candidate_cloud_router_ipv6_address: Single IPv6 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 2001:db8::1/125
        :param pulumi.Input[builtins.str] candidate_customer_router_ip_address: Single IPv4 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 203.0.113.2/29
        :param pulumi.Input[builtins.str] candidate_customer_router_ipv6_address: Single IPv6 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 2001:db8::2/125
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[builtins.str] encryption: Indicates the user-supplied encryption option of this interconnect
               attachment. Can only be specified at attachment creation for PARTNER or
               DEDICATED attachments.
               * NONE - This is the default value, which means that the VLAN attachment
               carries unencrypted traffic. VMs are able to send traffic to, or receive
               traffic from, such a VLAN attachment.
               * IPSEC - The VLAN attachment carries only encrypted traffic that is
               encrypted by an IPsec device, such as an HA VPN gateway or third-party
               IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
               such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
               attachment must be created with this option.
               Default value is `NONE`.
               Possible values are: `NONE`, `IPSEC`.
        :param pulumi.Input[builtins.str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment,
               Used only for interconnect attachment that has the encryption option as
               IPSEC.
               The addresses must be RFC 1918 IP address ranges. When creating HA VPN
               gateway over the interconnect attachment, if the attachment is configured
               to use an RFC 1918 IP address, then the VPN gateway's IP address will be
               allocated from the IP address range specified here.
               For example, if the HA VPN gateway's interface 0 is paired to this
               interconnect attachment, then an RFC 1918 IP address for the VPN gateway
               interface 0 will be allocated from the IP address specified for this
               interconnect attachment.
               If this field is not specified for interconnect attachment that has
               encryption option as IPSEC, later on when creating HA VPN gateway on this
               interconnect attachment, the HA VPN gateway's IP address will be
               allocated from regional external IP address pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
               Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[builtins.str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this interconnect attachment to identify whether the IPv6
               feature is enabled or not. If not specified, IPV4_ONLY will be used.
               This field can be both set at interconnect attachments creation and update
               interconnect attachment operations.
               Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        :param pulumi.Input[builtins.int] subnet_length: Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
               except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
               constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
               remote location fall into this category. In these cases, the default value is 30, and
               requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
               gives Google Cloud Support more debugging visibility.
        :param pulumi.Input[builtins.str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        :param pulumi.Input[builtins.int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents an InterconnectAttachment (VLAN attachment) resource. For more
        information, see Creating VLAN Attachments.

        To get more information about InterconnectAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnectAttachments)
        * How-to Guides
            * [Create a Interconnect attachment](https://cloud.google.com/network-connectivity/docs/interconnect/how-to/dedicated/creating-vlan-attachments)

        ## Example Usage

        ### Interconnect Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobar",
            name="network-1",
            auto_create_subnetworks=False)
        foobar = gcp.compute.Router("foobar",
            name="router-1",
            network=foobar_network.name,
            bgp={
                "asn": 16550,
            })
        on_prem = gcp.compute.InterconnectAttachment("on_prem",
            name="on-prem-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar.id,
            mtu="1500",
            labels={
                "mykey": "myvalue",
            })
        ```
        ### Compute Interconnect Attachment Ipsec Encryption

        ```python
        import pulumi
        import pulumi_gcp as gcp

        network = gcp.compute.Network("network",
            name="test-network",
            auto_create_subnetworks=False)
        address = gcp.compute.Address("address",
            name="test-address",
            address_type="INTERNAL",
            purpose="IPSEC_INTERCONNECT",
            address="192.168.1.0",
            prefix_length=29,
            network=network.self_link)
        router = gcp.compute.Router("router",
            name="test-router",
            network=network.name,
            encrypted_interconnect_router=True,
            bgp={
                "asn": 16550,
            })
        ipsec_encrypted_interconnect_attachment = gcp.compute.InterconnectAttachment("ipsec-encrypted-interconnect-attachment",
            name="test-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=router.id,
            encryption="IPSEC",
            ipsec_internal_addresses=[address.self_link])
        ```
        ### Compute Interconnect Attachment Custom Ranges

        ```python
        import pulumi
        import pulumi_gcp as gcp

        foobar_network = gcp.compute.Network("foobar",
            name="test-network",
            auto_create_subnetworks=False)
        foobar = gcp.compute.Router("foobar",
            name="test-router",
            network=foobar_network.name,
            bgp={
                "asn": 16550,
            })
        custom_ranges_interconnect_attachment = gcp.compute.InterconnectAttachment("custom-ranges-interconnect-attachment",
            name="test-custom-ranges-interconnect-attachment",
            edge_availability_domain="AVAILABILITY_DOMAIN_1",
            type="PARTNER",
            router=foobar.id,
            mtu="1500",
            stack_type="IPV4_IPV6",
            labels={
                "mykey": "myvalue",
            },
            candidate_cloud_router_ip_address="192.169.0.1/29",
            candidate_customer_router_ip_address="192.169.0.2/29",
            candidate_cloud_router_ipv6_address="748d:2f23:6651:9455:828b:ca81:6fe0:fed1/125",
            candidate_customer_router_ipv6_address="748d:2f23:6651:9455:828b:ca81:6fe0:fed2/125")
        ```

        ## Import

        InterconnectAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default projects/{{project}}/regions/{{region}}/interconnectAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachment:InterconnectAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InterconnectAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 bandwidth: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 encryption: Optional[pulumi.Input[builtins.str]] = None,
                 interconnect: Optional[pulumi.Input[builtins.str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 mtu: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 router: Optional[pulumi.Input[builtins.str]] = None,
                 stack_type: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_length: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectAttachmentArgs.__new__(InterconnectAttachmentArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["candidate_cloud_router_ip_address"] = candidate_cloud_router_ip_address
            __props__.__dict__["candidate_cloud_router_ipv6_address"] = candidate_cloud_router_ipv6_address
            __props__.__dict__["candidate_customer_router_ip_address"] = candidate_customer_router_ip_address
            __props__.__dict__["candidate_customer_router_ipv6_address"] = candidate_customer_router_ipv6_address
            __props__.__dict__["candidate_subnets"] = candidate_subnets
            __props__.__dict__["description"] = description
            __props__.__dict__["edge_availability_domain"] = edge_availability_domain
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["interconnect"] = interconnect
            __props__.__dict__["ipsec_internal_addresses"] = ipsec_internal_addresses
            __props__.__dict__["labels"] = labels
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            if router is None and not opts.urn:
                raise TypeError("Missing required property 'router'")
            __props__.__dict__["router"] = router
            __props__.__dict__["stack_type"] = stack_type
            __props__.__dict__["subnet_length"] = subnet_length
            __props__.__dict__["type"] = type
            __props__.__dict__["vlan_tag8021q"] = vlan_tag8021q
            __props__.__dict__["attachment_group"] = None
            __props__.__dict__["cloud_router_ip_address"] = None
            __props__.__dict__["cloud_router_ipv6_address"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["customer_router_ip_address"] = None
            __props__.__dict__["customer_router_ipv6_address"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["google_reference_id"] = None
            __props__.__dict__["label_fingerprint"] = None
            __props__.__dict__["pairing_key"] = None
            __props__.__dict__["partner_asn"] = None
            __props__.__dict__["private_interconnect_infos"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(InterconnectAttachment, __self__).__init__(
            'gcp:compute/interconnectAttachment:InterconnectAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            attachment_group: Optional[pulumi.Input[builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[builtins.str]] = None,
            candidate_cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            candidate_cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            candidate_customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            candidate_customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            cloud_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            cloud_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            customer_router_ip_address: Optional[pulumi.Input[builtins.str]] = None,
            customer_router_ipv6_address: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            edge_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            encryption: Optional[pulumi.Input[builtins.str]] = None,
            google_reference_id: Optional[pulumi.Input[builtins.str]] = None,
            interconnect: Optional[pulumi.Input[builtins.str]] = None,
            ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            label_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            mtu: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            pairing_key: Optional[pulumi.Input[builtins.str]] = None,
            partner_asn: Optional[pulumi.Input[builtins.str]] = None,
            private_interconnect_infos: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentPrivateInterconnectInfoArgs', 'InterconnectAttachmentPrivateInterconnectInfoArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            router: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            stack_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_length: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vlan_tag8021q: Optional[pulumi.Input[builtins.int]] = None) -> 'InterconnectAttachment':
        """
        Get an existing InterconnectAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] admin_enabled: Whether the VLAN attachment is enabled or disabled.  When using
               PARTNER type this will Pre-Activate the interconnect attachment
        :param pulumi.Input[builtins.str] attachment_group: URL of the AttachmentGroup that includes this Attachment.
        :param pulumi.Input[builtins.str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment.
               For attachments of type DEDICATED, the user can set the bandwidth.
               For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
               Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
               Defaults to BPS_10G
               Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        :param pulumi.Input[builtins.str] candidate_cloud_router_ip_address: Single IPv4 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 203.0.113.1/29
        :param pulumi.Input[builtins.str] candidate_cloud_router_ipv6_address: Single IPv6 address + prefix length to be configured on the cloud router interface for this
               interconnect attachment. Example: 2001:db8::1/125
        :param pulumi.Input[builtins.str] candidate_customer_router_ip_address: Single IPv4 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 203.0.113.2/29
        :param pulumi.Input[builtins.str] candidate_customer_router_ipv6_address: Single IPv6 address + prefix length to be configured on the customer router interface for this
               interconnect attachment. Example: 2001:db8::2/125
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation
               of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
               All prefixes must be within link-local address space (169.254.0.0/16)
               and must be /29 or shorter (/28, /27, etc). Google will attempt to select
               an unused /29 from the supplied candidate prefix(es). The request will
               fail if all possible /29s are in use on Google's edge. If not supplied,
               Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[builtins.str] cloud_router_ip_address: IPv4 address + prefix length to be configured on Cloud Router
               Interface for this interconnect attachment.
        :param pulumi.Input[builtins.str] cloud_router_ipv6_address: IPv6 address + prefix length to be configured on Cloud Router
               Interface for this interconnect attachment.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] customer_router_ip_address: IPv4 address + prefix length to be configured on the customer
               router subinterface for this interconnect attachment.
        :param pulumi.Input[builtins.str] customer_router_ipv6_address: IPv6 address + prefix length to be configured on the customer
               router subinterface for this interconnect attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[builtins.str] edge_availability_domain: Desired availability domain for the attachment. Only available for type
               PARTNER, at creation time. For improved reliability, customers should
               configure a pair of attachments with one per availability domain. The
               selected availability domain will be provided to the Partner via the
               pairing key so that the provisioned circuit will lie in the specified
               domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] encryption: Indicates the user-supplied encryption option of this interconnect
               attachment. Can only be specified at attachment creation for PARTNER or
               DEDICATED attachments.
               * NONE - This is the default value, which means that the VLAN attachment
               carries unencrypted traffic. VMs are able to send traffic to, or receive
               traffic from, such a VLAN attachment.
               * IPSEC - The VLAN attachment carries only encrypted traffic that is
               encrypted by an IPsec device, such as an HA VPN gateway or third-party
               IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
               such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
               attachment must be created with this option.
               Default value is `NONE`.
               Possible values are: `NONE`, `IPSEC`.
        :param pulumi.Input[builtins.str] google_reference_id: Google reference ID, to be used when raising support tickets with
               Google or otherwise to debug backend connectivity issues.
        :param pulumi.Input[builtins.str] interconnect: URL of the underlying Interconnect object that this attachment's
               traffic will traverse through. Required if type is DEDICATED, must not
               be set if type is PARTNER.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment,
               Used only for interconnect attachment that has the encryption option as
               IPSEC.
               The addresses must be RFC 1918 IP address ranges. When creating HA VPN
               gateway over the interconnect attachment, if the attachment is configured
               to use an RFC 1918 IP address, then the VPN gateway's IP address will be
               allocated from the IP address range specified here.
               For example, if the HA VPN gateway's interface 0 is paired to this
               interconnect attachment, then an RFC 1918 IP address for the VPN gateway
               interface 0 will be allocated from the IP address specified for this
               interconnect attachment.
               If this field is not specified for interconnect attachment that has
               encryption option as IPSEC, later on when creating HA VPN gateway on this
               interconnect attachment, the HA VPN gateway's IP address will be
               allocated from regional external IP address pool.
        :param pulumi.Input[builtins.str] label_fingerprint: A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
               of the labels set used for optimistic locking. The fingerprint is initially generated by
               Compute Engine and changes after every request to modify or update labels.
               You must always provide an up-to-date fingerprint hash in order to update or change labels,
               otherwise the request will fail with error 412 conditionNotMet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for this resource. These can only be added or modified by the setLabels
               method. Each label key/value pair must comply with RFC1035. Label values may be empty.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
               Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The
               name must be 1-63 characters long, and comply with RFC1035. Specifically, the
               name must be 1-63 characters long and match the regular expression
               `a-z?` which means the first character must be a
               lowercase letter, and all following characters must be a dash, lowercase
               letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] pairing_key: [Output only for type PARTNER. Not present for DEDICATED]. The opaque
               identifier of an PARTNER attachment used to initiate provisioning with
               a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[builtins.str] partner_asn: [Output only for type PARTNER. Not present for DEDICATED]. Optional
               BGP ASN for the router that should be supplied by a layer 3 Partner if
               they configured BGP on behalf of the customer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentPrivateInterconnectInfoArgs', 'InterconnectAttachmentPrivateInterconnectInfoArgsDict']]]] private_interconnect_infos: Information specific to an InterconnectAttachment. This property
               is populated if the interconnect that this is attached to is of type DEDICATED.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: Region where the regional interconnect attachment resides.
        :param pulumi.Input[builtins.str] router: URL of the cloud router to be used for dynamic routing. This router must be in
               the same region as this InterconnectAttachment. The InterconnectAttachment will
               automatically connect the Interconnect to the network & region within which the
               Cloud Router is configured.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.str] stack_type: The stack type for this interconnect attachment to identify whether the IPv6
               feature is enabled or not. If not specified, IPV4_ONLY will be used.
               This field can be both set at interconnect attachments creation and update
               interconnect attachment operations.
               Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        :param pulumi.Input[builtins.str] state: [Output Only] The current state of this attachment's functionality.
        :param pulumi.Input[builtins.int] subnet_length: Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
               except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
               constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
               remote location fall into this category. In these cases, the default value is 30, and
               requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
               gives Google Cloud Support more debugging visibility.
        :param pulumi.Input[builtins.str] type: The type of InterconnectAttachment you wish to create. Defaults to
               DEDICATED.
               Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        :param pulumi.Input[builtins.int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
               using PARTNER type this will be managed upstream.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterconnectAttachmentState.__new__(_InterconnectAttachmentState)

        __props__.__dict__["admin_enabled"] = admin_enabled
        __props__.__dict__["attachment_group"] = attachment_group
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["candidate_cloud_router_ip_address"] = candidate_cloud_router_ip_address
        __props__.__dict__["candidate_cloud_router_ipv6_address"] = candidate_cloud_router_ipv6_address
        __props__.__dict__["candidate_customer_router_ip_address"] = candidate_customer_router_ip_address
        __props__.__dict__["candidate_customer_router_ipv6_address"] = candidate_customer_router_ipv6_address
        __props__.__dict__["candidate_subnets"] = candidate_subnets
        __props__.__dict__["cloud_router_ip_address"] = cloud_router_ip_address
        __props__.__dict__["cloud_router_ipv6_address"] = cloud_router_ipv6_address
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["customer_router_ip_address"] = customer_router_ip_address
        __props__.__dict__["customer_router_ipv6_address"] = customer_router_ipv6_address
        __props__.__dict__["description"] = description
        __props__.__dict__["edge_availability_domain"] = edge_availability_domain
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["google_reference_id"] = google_reference_id
        __props__.__dict__["interconnect"] = interconnect
        __props__.__dict__["ipsec_internal_addresses"] = ipsec_internal_addresses
        __props__.__dict__["label_fingerprint"] = label_fingerprint
        __props__.__dict__["labels"] = labels
        __props__.__dict__["mtu"] = mtu
        __props__.__dict__["name"] = name
        __props__.__dict__["pairing_key"] = pairing_key
        __props__.__dict__["partner_asn"] = partner_asn
        __props__.__dict__["private_interconnect_infos"] = private_interconnect_infos
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["router"] = router
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["stack_type"] = stack_type
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_length"] = subnet_length
        __props__.__dict__["type"] = type
        __props__.__dict__["vlan_tag8021q"] = vlan_tag8021q
        return InterconnectAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether the VLAN attachment is enabled or disabled.  When using
        PARTNER type this will Pre-Activate the interconnect attachment
        """
        return pulumi.get(self, "admin_enabled")

    @property
    @pulumi.getter(name="attachmentGroup")
    def attachment_group(self) -> pulumi.Output[builtins.str]:
        """
        URL of the AttachmentGroup that includes this Attachment.
        """
        return pulumi.get(self, "attachment_group")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[builtins.str]:
        """
        Provisioned bandwidth capacity for the interconnect attachment.
        For attachments of type DEDICATED, the user can set the bandwidth.
        For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth.
        Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED,
        Defaults to BPS_10G
        Possible values are: `BPS_50M`, `BPS_100M`, `BPS_200M`, `BPS_300M`, `BPS_400M`, `BPS_500M`, `BPS_1G`, `BPS_2G`, `BPS_5G`, `BPS_10G`, `BPS_20G`, `BPS_50G`, `BPS_100G`.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="candidateCloudRouterIpAddress")
    def candidate_cloud_router_ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 203.0.113.1/29
        """
        return pulumi.get(self, "candidate_cloud_router_ip_address")

    @property
    @pulumi.getter(name="candidateCloudRouterIpv6Address")
    def candidate_cloud_router_ipv6_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the cloud router interface for this
        interconnect attachment. Example: 2001:db8::1/125
        """
        return pulumi.get(self, "candidate_cloud_router_ipv6_address")

    @property
    @pulumi.getter(name="candidateCustomerRouterIpAddress")
    def candidate_customer_router_ip_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Single IPv4 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 203.0.113.2/29
        """
        return pulumi.get(self, "candidate_customer_router_ip_address")

    @property
    @pulumi.getter(name="candidateCustomerRouterIpv6Address")
    def candidate_customer_router_ipv6_address(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Single IPv6 address + prefix length to be configured on the customer router interface for this
        interconnect attachment. Example: 2001:db8::2/125
        """
        return pulumi.get(self, "candidate_customer_router_ipv6_address")

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation
        of cloudRouterIpAddress and customerRouterIpAddress for this attachment.
        All prefixes must be within link-local address space (169.254.0.0/16)
        and must be /29 or shorter (/28, /27, etc). Google will attempt to select
        an unused /29 from the supplied candidate prefix(es). The request will
        fail if all possible /29s are in use on Google's edge. If not supplied,
        Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv4 address + prefix length to be configured on Cloud Router
        Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @property
    @pulumi.getter(name="cloudRouterIpv6Address")
    def cloud_router_ipv6_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv6 address + prefix length to be configured on Cloud Router
        Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ipv6_address")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv4 address + prefix length to be configured on the customer
        router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @property
    @pulumi.getter(name="customerRouterIpv6Address")
    def customer_router_ipv6_address(self) -> pulumi.Output[builtins.str]:
        """
        IPv6 address + prefix length to be configured on the customer
        router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ipv6_address")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        Desired availability domain for the attachment. Only available for type
        PARTNER, at creation time. For improved reliability, customers should
        configure a pair of attachments with one per availability domain. The
        selected availability domain will be provided to the Partner via the
        pairing key so that the provisioned circuit will lie in the specified
        domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Indicates the user-supplied encryption option of this interconnect
        attachment. Can only be specified at attachment creation for PARTNER or
        DEDICATED attachments.
        * NONE - This is the default value, which means that the VLAN attachment
        carries unencrypted traffic. VMs are able to send traffic to, or receive
        traffic from, such a VLAN attachment.
        * IPSEC - The VLAN attachment carries only encrypted traffic that is
        encrypted by an IPsec device, such as an HA VPN gateway or third-party
        IPsec VPN. VMs cannot directly send traffic to, or receive traffic from,
        such a VLAN attachment. To use HA VPN over Cloud Interconnect, the VLAN
        attachment must be created with this option.
        Default value is `NONE`.
        Possible values are: `NONE`, `IPSEC`.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> pulumi.Output[builtins.str]:
        """
        Google reference ID, to be used when raising support tickets with
        Google or otherwise to debug backend connectivity issues.
        """
        return pulumi.get(self, "google_reference_id")

    @property
    @pulumi.getter
    def interconnect(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL of the underlying Interconnect object that this attachment's
        traffic will traverse through. Required if type is DEDICATED, must not
        be set if type is PARTNER.
        """
        return pulumi.get(self, "interconnect")

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment,
        Used only for interconnect attachment that has the encryption option as
        IPSEC.
        The addresses must be RFC 1918 IP address ranges. When creating HA VPN
        gateway over the interconnect attachment, if the attachment is configured
        to use an RFC 1918 IP address, then the VPN gateway's IP address will be
        allocated from the IP address range specified here.
        For example, if the HA VPN gateway's interface 0 is paired to this
        interconnect attachment, then an RFC 1918 IP address for the VPN gateway
        interface 0 will be allocated from the IP address specified for this
        interconnect attachment.
        If this field is not specified for interconnect attachment that has
        encryption option as IPSEC, later on when creating HA VPN gateway on this
        interconnect attachment, the HA VPN gateway's IP address will be
        allocated from regional external IP address pool.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        A fingerprint for the labels being applied to this Interconnect, which is essentially a hash
        of the labels set used for optimistic locking. The fingerprint is initially generated by
        Compute Engine and changes after every request to modify or update labels.
        You must always provide an up-to-date fingerprint hash in order to update or change labels,
        otherwise the request will fail with error 412 conditionNotMet.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels
        method. Each label key/value pair must comply with RFC1035. Label values may be empty.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[builtins.str]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment.
        Valid values are 1440, 1460, 1500, and 8896. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created. The
        name must be 1-63 characters long, and comply with RFC1035. Specifically, the
        name must be 1-63 characters long and match the regular expression
        `a-z?` which means the first character must be a
        lowercase letter, and all following characters must be a dash, lowercase
        letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> pulumi.Output[builtins.str]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. The opaque
        identifier of an PARTNER attachment used to initiate provisioning with
        a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> pulumi.Output[builtins.str]:
        """
        [Output only for type PARTNER. Not present for DEDICATED]. Optional
        BGP ASN for the router that should be supplied by a layer 3 Partner if
        they configured BGP on behalf of the customer.
        """
        return pulumi.get(self, "partner_asn")

    @property
    @pulumi.getter(name="privateInterconnectInfos")
    def private_interconnect_infos(self) -> pulumi.Output[Sequence['outputs.InterconnectAttachmentPrivateInterconnectInfo']]:
        """
        Information specific to an InterconnectAttachment. This property
        is populated if the interconnect that this is attached to is of type DEDICATED.
        Structure is documented below.
        """
        return pulumi.get(self, "private_interconnect_infos")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        Region where the regional interconnect attachment resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[builtins.str]:
        """
        URL of the cloud router to be used for dynamic routing. This router must be in
        the same region as this InterconnectAttachment. The InterconnectAttachment will
        automatically connect the Interconnect to the network & region within which the
        Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="stackType")
    def stack_type(self) -> pulumi.Output[builtins.str]:
        """
        The stack type for this interconnect attachment to identify whether the IPv6
        feature is enabled or not. If not specified, IPV4_ONLY will be used.
        This field can be both set at interconnect attachments creation and update
        interconnect attachment operations.
        Possible values are: `IPV4_IPV6`, `IPV4_ONLY`.
        """
        return pulumi.get(self, "stack_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        [Output Only] The current state of this attachment's functionality.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetLength")
    def subnet_length(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Length of the IPv4 subnet mask. Allowed values: 29 (default), 30. The default value is 29,
        except for Cross-Cloud Interconnect connections that use an InterconnectRemoteLocation with a
        constraints.subnetLengthRange.min equal to 30. For example, connections that use an Azure
        remote location fall into this category. In these cases, the default value is 30, and
        requesting 29 returns an error. Where both 29 and 30 are allowed, 29 is preferred, because it
        gives Google Cloud Support more debugging visibility.
        """
        return pulumi.get(self, "subnet_length")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of InterconnectAttachment you wish to create. Defaults to
        DEDICATED.
        Possible values are: `DEDICATED`, `PARTNER`, `PARTNER_PROVIDER`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> pulumi.Output[builtins.int]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. When
        using PARTNER type this will be managed upstream.
        """
        return pulumi.get(self, "vlan_tag8021q")

