# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectAttachmentGroupArgs', 'InterconnectAttachmentGroup']

@pulumi.input_type
class InterconnectAttachmentGroupArgs:
    def __init__(__self__, *,
                 intent: pulumi.Input['InterconnectAttachmentGroupIntentArgs'],
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 interconnect_group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a InterconnectAttachmentGroup resource.
        :param pulumi.Input['InterconnectAttachmentGroupIntentArgs'] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]] attachments: Attachments in the AttachmentGroup. Keys are arbitrary user-specified
               strings. Users are encouraged, but not required, to use their preferred
               format for resource links as keys.
               Note that there are add-members and remove-members methods in gcloud.
               The size of this map is limited by an "Attachments per group" quota.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[builtins.str] interconnect_group: The URL of an InterconnectGroup that groups these Attachments'
               Interconnects. Customers do not need to set this unless directed by
               Google Support.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "intent", intent)
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interconnect_group is not None:
            pulumi.set(__self__, "interconnect_group", interconnect_group)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def intent(self) -> pulumi.Input['InterconnectAttachmentGroupIntentArgs']:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: pulumi.Input['InterconnectAttachmentGroupIntentArgs']):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]]:
        """
        Attachments in the AttachmentGroup. Keys are arbitrary user-specified
        strings. Users are encouraged, but not required, to use their preferred
        format for resource links as keys.
        Note that there are add-members and remove-members methods in gcloud.
        The size of this map is limited by an "Attachments per group" quota.
        Structure is documented below.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="interconnectGroup")
    def interconnect_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of an InterconnectGroup that groups these Attachments'
        Interconnects. Customers do not need to set this unless directed by
        Google Support.
        """
        return pulumi.get(self, "interconnect_group")

    @interconnect_group.setter
    def interconnect_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect_group", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _InterconnectAttachmentGroupState:
    def __init__(__self__, *,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]] = None,
                 configureds: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupConfiguredArgs']]]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input['InterconnectAttachmentGroupIntentArgs']] = None,
                 interconnect_group: Optional[pulumi.Input[builtins.str]] = None,
                 logical_structures: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupLogicalStructureArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering InterconnectAttachmentGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]] attachments: Attachments in the AttachmentGroup. Keys are arbitrary user-specified
               strings. Users are encouraged, but not required, to use their preferred
               format for resource links as keys.
               Note that there are add-members and remove-members methods in gcloud.
               The size of this map is limited by an "Attachments per group" quota.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupConfiguredArgs']]] configureds: The redundancy this group is configured to support. The way a
               user queries what SLA their Attachment gets is by looking at this field of
               the Attachment's AttachmentGroup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['InterconnectAttachmentGroupIntentArgs'] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] interconnect_group: The URL of an InterconnectGroup that groups these Attachments'
               Interconnects. Customers do not need to set this unless directed by
               Google Support.
        :param pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupLogicalStructureArgs']]] logical_structures: An analysis of the logical layout of Attachments in this
               group. Every Attachment in the group is shown once in this structure.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if attachments is not None:
            pulumi.set(__self__, "attachments", attachments)
        if configureds is not None:
            pulumi.set(__self__, "configureds", configureds)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if intent is not None:
            pulumi.set(__self__, "intent", intent)
        if interconnect_group is not None:
            pulumi.set(__self__, "interconnect_group", interconnect_group)
        if logical_structures is not None:
            pulumi.set(__self__, "logical_structures", logical_structures)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]]:
        """
        Attachments in the AttachmentGroup. Keys are arbitrary user-specified
        strings. Users are encouraged, but not required, to use their preferred
        format for resource links as keys.
        Note that there are add-members and remove-members methods in gcloud.
        The size of this map is limited by an "Attachments per group" quota.
        Structure is documented below.
        """
        return pulumi.get(self, "attachments")

    @attachments.setter
    def attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupAttachmentArgs']]]]):
        pulumi.set(self, "attachments", value)

    @property
    @pulumi.getter
    def configureds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupConfiguredArgs']]]]:
        """
        The redundancy this group is configured to support. The way a
        user queries what SLA their Attachment gets is by looking at this field of
        the Attachment's AttachmentGroup.
        Structure is documented below.
        """
        return pulumi.get(self, "configureds")

    @configureds.setter
    def configureds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupConfiguredArgs']]]]):
        pulumi.set(self, "configureds", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def intent(self) -> Optional[pulumi.Input['InterconnectAttachmentGroupIntentArgs']]:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @intent.setter
    def intent(self, value: Optional[pulumi.Input['InterconnectAttachmentGroupIntentArgs']]):
        pulumi.set(self, "intent", value)

    @property
    @pulumi.getter(name="interconnectGroup")
    def interconnect_group(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of an InterconnectGroup that groups these Attachments'
        Interconnects. Customers do not need to set this unless directed by
        Google Support.
        """
        return pulumi.get(self, "interconnect_group")

    @interconnect_group.setter
    def interconnect_group(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "interconnect_group", value)

    @property
    @pulumi.getter(name="logicalStructures")
    def logical_structures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupLogicalStructureArgs']]]]:
        """
        An analysis of the logical layout of Attachments in this
        group. Every Attachment in the group is shown once in this structure.
        Structure is documented below.
        """
        return pulumi.get(self, "logical_structures")

    @logical_structures.setter
    def logical_structures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InterconnectAttachmentGroupLogicalStructureArgs']]]]):
        pulumi.set(self, "logical_structures", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.type_token("gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup")
class InterconnectAttachmentGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupAttachmentArgs', 'InterconnectAttachmentGroupAttachmentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input[Union['InterconnectAttachmentGroupIntentArgs', 'InterconnectAttachmentGroupIntentArgsDict']]] = None,
                 interconnect_group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An interconnect attachment group resource allows customers to create,
        analyze, and expand highly available deployments.

        To get more information about InterconnectAttachmentGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Interconnect Attachment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_interconnect_attachment_group = gcp.compute.InterconnectAttachmentGroup("example-interconnect-attachment-group",
            name="example-interconnect-attachment-group",
            intent={
                "availability_sla": "NO_SLA",
            })
        ```

        ## Import

        InterconnectAttachmentGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnectAttachmentGroups/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectAttachmentGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default projects/{{project}}/global/interconnectAttachmentGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupAttachmentArgs', 'InterconnectAttachmentGroupAttachmentArgsDict']]]] attachments: Attachments in the AttachmentGroup. Keys are arbitrary user-specified
               strings. Users are encouraged, but not required, to use their preferred
               format for resource links as keys.
               Note that there are add-members and remove-members methods in gcloud.
               The size of this map is limited by an "Attachments per group" quota.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['InterconnectAttachmentGroupIntentArgs', 'InterconnectAttachmentGroupIntentArgsDict']] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] interconnect_group: The URL of an InterconnectGroup that groups these Attachments'
               Interconnects. Customers do not need to set this unless directed by
               Google Support.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectAttachmentGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An interconnect attachment group resource allows customers to create,
        analyze, and expand highly available deployments.

        To get more information about InterconnectAttachmentGroup, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/interconnects)
        * How-to Guides
            * [Create a Dedicated Interconnect](https://cloud.google.com/network-connectivity/docs/interconnect/concepts/dedicated-overview)

        ## Example Usage

        ### Interconnect Attachment Group Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        example_interconnect_attachment_group = gcp.compute.InterconnectAttachmentGroup("example-interconnect-attachment-group",
            name="example-interconnect-attachment-group",
            intent={
                "availability_sla": "NO_SLA",
            })
        ```

        ## Import

        InterconnectAttachmentGroup can be imported using any of these accepted formats:

        * `projects/{{project}}/global/interconnectAttachmentGroups/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, InterconnectAttachmentGroup can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default projects/{{project}}/global/interconnectAttachmentGroups/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InterconnectAttachmentGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectAttachmentGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupAttachmentArgs', 'InterconnectAttachmentGroupAttachmentArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 intent: Optional[pulumi.Input[Union['InterconnectAttachmentGroupIntentArgs', 'InterconnectAttachmentGroupIntentArgsDict']]] = None,
                 interconnect_group: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectAttachmentGroupArgs.__new__(InterconnectAttachmentGroupArgs)

            __props__.__dict__["attachments"] = attachments
            __props__.__dict__["description"] = description
            if intent is None and not opts.urn:
                raise TypeError("Missing required property 'intent'")
            __props__.__dict__["intent"] = intent
            __props__.__dict__["interconnect_group"] = interconnect_group
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["configureds"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["logical_structures"] = None
        super(InterconnectAttachmentGroup, __self__).__init__(
            'gcp:compute/interconnectAttachmentGroup:InterconnectAttachmentGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupAttachmentArgs', 'InterconnectAttachmentGroupAttachmentArgsDict']]]]] = None,
            configureds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupConfiguredArgs', 'InterconnectAttachmentGroupConfiguredArgsDict']]]]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            intent: Optional[pulumi.Input[Union['InterconnectAttachmentGroupIntentArgs', 'InterconnectAttachmentGroupIntentArgsDict']]] = None,
            interconnect_group: Optional[pulumi.Input[builtins.str]] = None,
            logical_structures: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupLogicalStructureArgs', 'InterconnectAttachmentGroupLogicalStructureArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None) -> 'InterconnectAttachmentGroup':
        """
        Get an existing InterconnectAttachmentGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupAttachmentArgs', 'InterconnectAttachmentGroupAttachmentArgsDict']]]] attachments: Attachments in the AttachmentGroup. Keys are arbitrary user-specified
               strings. Users are encouraged, but not required, to use their preferred
               format for resource links as keys.
               Note that there are add-members and remove-members methods in gcloud.
               The size of this map is limited by an "Attachments per group" quota.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupConfiguredArgs', 'InterconnectAttachmentGroupConfiguredArgsDict']]]] configureds: The redundancy this group is configured to support. The way a
               user queries what SLA their Attachment gets is by looking at this field of
               the Attachment's AttachmentGroup.
               Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['InterconnectAttachmentGroupIntentArgs', 'InterconnectAttachmentGroupIntentArgsDict']] intent: The user's intent for this group. This is the only required field besides
               the name that must be specified on group creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] interconnect_group: The URL of an InterconnectGroup that groups these Attachments'
               Interconnects. Customers do not need to set this unless directed by
               Google Support.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InterconnectAttachmentGroupLogicalStructureArgs', 'InterconnectAttachmentGroupLogicalStructureArgsDict']]]] logical_structures: An analysis of the logical layout of Attachments in this
               group. Every Attachment in the group is shown once in this structure.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is created. The name must be
               1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?` which means the first
               character must be a lowercase letter, and all following characters must be a dash,
               lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InterconnectAttachmentGroupState.__new__(_InterconnectAttachmentGroupState)

        __props__.__dict__["attachments"] = attachments
        __props__.__dict__["configureds"] = configureds
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["intent"] = intent
        __props__.__dict__["interconnect_group"] = interconnect_group
        __props__.__dict__["logical_structures"] = logical_structures
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return InterconnectAttachmentGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attachments(self) -> pulumi.Output[Optional[Sequence['outputs.InterconnectAttachmentGroupAttachment']]]:
        """
        Attachments in the AttachmentGroup. Keys are arbitrary user-specified
        strings. Users are encouraged, but not required, to use their preferred
        format for resource links as keys.
        Note that there are add-members and remove-members methods in gcloud.
        The size of this map is limited by an "Attachments per group" quota.
        Structure is documented below.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter
    def configureds(self) -> pulumi.Output[Sequence['outputs.InterconnectAttachmentGroupConfigured']]:
        """
        The redundancy this group is configured to support. The way a
        user queries what SLA their Attachment gets is by looking at this field of
        the Attachment's AttachmentGroup.
        Structure is documented below.
        """
        return pulumi.get(self, "configureds")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def intent(self) -> pulumi.Output['outputs.InterconnectAttachmentGroupIntent']:
        """
        The user's intent for this group. This is the only required field besides
        the name that must be specified on group creation.
        Structure is documented below.
        """
        return pulumi.get(self, "intent")

    @property
    @pulumi.getter(name="interconnectGroup")
    def interconnect_group(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The URL of an InterconnectGroup that groups these Attachments'
        Interconnects. Customers do not need to set this unless directed by
        Google Support.
        """
        return pulumi.get(self, "interconnect_group")

    @property
    @pulumi.getter(name="logicalStructures")
    def logical_structures(self) -> pulumi.Output[Sequence['outputs.InterconnectAttachmentGroupLogicalStructure']]:
        """
        An analysis of the logical layout of Attachments in this
        group. Every Attachment in the group is shown once in this structure.
        Structure is documented below.
        """
        return pulumi.get(self, "logical_structures")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be
        1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?` which means the first
        character must be a lowercase letter, and all following characters must be a dash,
        lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

