# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionUrlMapArgs', 'RegionUrlMap']

@pulumi.input_type
class RegionUrlMapArgs:
    def __init__(__self__, *,
                 default_route_action: Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']] = None,
                 default_service: Optional[pulumi.Input[builtins.str]] = None,
                 default_url_redirect: Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]] = None):
        """
        The set of arguments for constructing a RegionUrlMap resource.
        :param pulumi.Input['RegionUrlMapDefaultRouteActionArgs'] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
               defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[builtins.str] default_service: The full or partial URL of the defaultService resource to which traffic is directed if
               none of the hostRules match. If defaultRouteAction is additionally specified, advanced
               routing actions like URL Rewrites, etc. take effect prior to sending the request to the
               backend. However, if defaultService is specified, defaultRouteAction cannot contain any
               weightedBackendServices. Conversely, if routeAction specifies any
               weightedBackendServices, service must not be specified.  Only one of defaultService,
               defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        :param pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs'] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        if default_route_action is not None:
            pulumi.set(__self__, "default_route_action", default_route_action)
        if default_service is not None:
            pulumi.set(__self__, "default_service", default_service)
        if default_url_redirect is not None:
            pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host_rules is not None:
            pulumi.set(__self__, "host_rules", host_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_matchers is not None:
            pulumi.set(__self__, "path_matchers", path_matchers)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
        defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @default_route_action.setter
    def default_route_action(self, value: Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']]):
        pulumi.set(self, "default_route_action", value)

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full or partial URL of the defaultService resource to which traffic is directed if
        none of the hostRules match. If defaultRouteAction is additionally specified, advanced
        routing actions like URL Rewrites, etc. take effect prior to sending the request to the
        backend. However, if defaultService is specified, defaultRouteAction cannot contain any
        weightedBackendServices. Conversely, if routeAction specifies any
        weightedBackendServices, service must not be specified.  Only one of defaultService,
        defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "default_service")

    @default_service.setter
    def default_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_service", value)

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @default_url_redirect.setter
    def default_url_redirect(self, value: Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']]):
        pulumi.set(self, "default_url_redirect", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @host_rules.setter
    def host_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]]):
        pulumi.set(self, "host_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @path_matchers.setter
    def path_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]]):
        pulumi.set(self, "path_matchers", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Region in which the url map should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]]:
        """
        The list of expected URL mappings. Requests to update this UrlMap will
        succeed only if all of the test cases pass.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]]):
        pulumi.set(self, "tests", value)


@pulumi.input_type
class _RegionUrlMapState:
    def __init__(__self__, *,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 default_route_action: Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']] = None,
                 default_service: Optional[pulumi.Input[builtins.str]] = None,
                 default_url_redirect: Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]] = None,
                 map_id: Optional[pulumi.Input[builtins.int]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]] = None):
        """
        Input properties used for looking up and filtering RegionUrlMap resources.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input['RegionUrlMapDefaultRouteActionArgs'] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
               defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[builtins.str] default_service: The full or partial URL of the defaultService resource to which traffic is directed if
               none of the hostRules match. If defaultRouteAction is additionally specified, advanced
               routing actions like URL Rewrites, etc. take effect prior to sending the request to the
               backend. However, if defaultService is specified, defaultRouteAction cannot contain any
               weightedBackendServices. Conversely, if routeAction specifies any
               weightedBackendServices, service must not be specified.  Only one of defaultService,
               defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        :param pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs'] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.int] map_id: The unique identifier for the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if default_route_action is not None:
            pulumi.set(__self__, "default_route_action", default_route_action)
        if default_service is not None:
            pulumi.set(__self__, "default_service", default_service)
        if default_url_redirect is not None:
            pulumi.set(__self__, "default_url_redirect", default_url_redirect)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if host_rules is not None:
            pulumi.set(__self__, "host_rules", host_rules)
        if map_id is not None:
            pulumi.set(__self__, "map_id", map_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_matchers is not None:
            pulumi.set(__self__, "path_matchers", path_matchers)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tests is not None:
            pulumi.set(__self__, "tests", tests)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
        defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @default_route_action.setter
    def default_route_action(self, value: Optional[pulumi.Input['RegionUrlMapDefaultRouteActionArgs']]):
        pulumi.set(self, "default_route_action", value)

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The full or partial URL of the defaultService resource to which traffic is directed if
        none of the hostRules match. If defaultRouteAction is additionally specified, advanced
        routing actions like URL Rewrites, etc. take effect prior to sending the request to the
        backend. However, if defaultService is specified, defaultRouteAction cannot contain any
        weightedBackendServices. Conversely, if routeAction specifies any
        weightedBackendServices, service must not be specified.  Only one of defaultService,
        defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "default_service")

    @default_service.setter
    def default_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "default_service", value)

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @default_url_redirect.setter
    def default_url_redirect(self, value: Optional[pulumi.Input['RegionUrlMapDefaultUrlRedirectArgs']]):
        pulumi.set(self, "default_url_redirect", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @host_rules.setter
    def host_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapHostRuleArgs']]]]):
        pulumi.set(self, "host_rules", value)

    @property
    @pulumi.getter(name="mapId")
    def map_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "map_id")

    @map_id.setter
    def map_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "map_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @path_matchers.setter
    def path_matchers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapPathMatcherArgs']]]]):
        pulumi.set(self, "path_matchers", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Region in which the url map should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tests(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]]:
        """
        The list of expected URL mappings. Requests to update this UrlMap will
        succeed only if all of the test cases pass.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

    @tests.setter
    def tests(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RegionUrlMapTestArgs']]]]):
        pulumi.set(self, "tests", value)


@pulumi.type_token("gcp:compute/regionUrlMap:RegionUrlMap")
class RegionUrlMap(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_action: Optional[pulumi.Input[Union['RegionUrlMapDefaultRouteActionArgs', 'RegionUrlMapDefaultRouteActionArgsDict']]] = None,
                 default_service: Optional[pulumi.Input[builtins.str]] = None,
                 default_url_redirect: Optional[pulumi.Input[Union['RegionUrlMapDefaultUrlRedirectArgs', 'RegionUrlMapDefaultUrlRedirectArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapHostRuleArgs', 'RegionUrlMapHostRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapPathMatcherArgs', 'RegionUrlMapPathMatcherArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapTestArgs', 'RegionUrlMapTestArgsDict']]]]] = None,
                 __props__=None):
        """
        UrlMaps are used to route requests to a backend service based on rules
        that you define for the host and path of an incoming URL.

        ## Example Usage

        ### Region Url Map Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map Default Route Action

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_route_action={
                "retry_policy": {
                    "retry_conditions": [
                        "5xx",
                        "gateway-error",
                    ],
                    "num_retries": 3,
                    "per_try_timeout": {
                        "seconds": "0",
                        "nanos": 500,
                    },
                },
                "request_mirror_policy": {
                    "backend_service": home.id,
                },
                "weighted_backend_services": [
                    {
                        "backend_service": login.id,
                        "weight": 200,
                        "header_action": {
                            "request_headers_to_adds": [{
                                "header_name": "foo-request-1",
                                "header_value": "bar",
                                "replace": True,
                            }],
                            "request_headers_to_removes": ["fizz"],
                            "response_headers_to_adds": [{
                                "header_name": "foo-response-1",
                                "header_value": "bar",
                                "replace": True,
                            }],
                            "response_headers_to_removes": ["buzz"],
                        },
                    },
                    {
                        "backend_service": home.id,
                        "weight": 100,
                        "header_action": {
                            "request_headers_to_adds": [
                                {
                                    "header_name": "foo-request-1",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                                {
                                    "header_name": "foo-request-2",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                            ],
                            "request_headers_to_removes": ["fizz"],
                            "response_headers_to_adds": [
                                {
                                    "header_name": "foo-response-2",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                                {
                                    "header_name": "foo-response-1",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                            ],
                            "response_headers_to_removes": ["buzz"],
                        },
                    },
                ],
                "url_rewrite": {
                    "host_rewrite": "dev.example.com",
                    "path_prefix_rewrite": "/v1/api/",
                },
                "cors_policy": {
                    "disabled": False,
                    "allow_credentials": True,
                    "allow_headers": ["foobar"],
                    "allow_methods": [
                        "GET",
                        "POST",
                    ],
                    "allow_origins": ["example.com"],
                    "expose_headers": ["foobar"],
                    "max_age": 60,
                },
                "fault_injection_policy": {
                    "delay": {
                        "fixed_delay": {
                            "seconds": "0",
                            "nanos": 500,
                        },
                        "percentage": 0.5,
                    },
                    "abort": {
                        "http_status": 500,
                        "percentage": 0.5,
                    },
                },
                "timeout": {
                    "seconds": "0",
                    "nanos": 500,
                },
            },
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Path

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [{
                    "paths": ["/home"],
                    "route_action": {
                        "cors_policy": {
                            "allow_credentials": True,
                            "allow_headers": ["Allowed content"],
                            "allow_methods": ["GET"],
                            "allow_origins": ["Allowed origin"],
                            "expose_headers": ["Exposed header"],
                            "max_age": 30,
                            "disabled": False,
                        },
                        "fault_injection_policy": {
                            "abort": {
                                "http_status": 234,
                                "percentage": 5.6,
                            },
                            "delay": {
                                "fixed_delay": {
                                    "seconds": "0",
                                    "nanos": 50000,
                                },
                                "percentage": 7.8,
                            },
                        },
                        "request_mirror_policy": {
                            "backend_service": home.id,
                        },
                        "retry_policy": {
                            "num_retries": 4,
                            "per_try_timeout": {
                                "seconds": "30",
                            },
                            "retry_conditions": [
                                "5xx",
                                "deadline-exceeded",
                            ],
                        },
                        "timeout": {
                            "seconds": "20",
                            "nanos": 750000000,
                        },
                        "url_rewrite": {
                            "host_rewrite": "dev.example.com",
                            "path_prefix_rewrite": "/v1/api/",
                        },
                        "weighted_backend_services": [{
                            "backend_service": home.id,
                            "weight": 400,
                            "header_action": {
                                "request_headers_to_removes": ["RemoveMe"],
                                "request_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": True,
                                }],
                                "response_headers_to_removes": ["RemoveMe"],
                                "response_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": False,
                                }],
                            },
                        }],
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Path Partial

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [{
                    "paths": ["/home"],
                    "route_action": {
                        "retry_policy": {
                            "num_retries": 4,
                            "per_try_timeout": {
                                "seconds": "30",
                            },
                            "retry_conditions": [
                                "5xx",
                                "deadline-exceeded",
                            ],
                        },
                        "timeout": {
                            "seconds": "20",
                            "nanos": 750000000,
                        },
                        "url_rewrite": {
                            "host_rewrite": "dev.example.com",
                            "path_prefix_rewrite": "/v1/api/",
                        },
                        "weighted_backend_services": [{
                            "backend_service": home.id,
                            "weight": 400,
                            "header_action": {
                                "response_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": False,
                                }],
                            },
                        }],
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Route

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "route_rules": [{
                    "priority": 1,
                    "header_action": {
                        "request_headers_to_removes": ["RemoveMe2"],
                        "request_headers_to_adds": [{
                            "header_name": "AddSomethingElse",
                            "header_value": "MyOtherValue",
                            "replace": True,
                        }],
                        "response_headers_to_removes": ["RemoveMe3"],
                        "response_headers_to_adds": [{
                            "header_name": "AddMe",
                            "header_value": "MyValue",
                            "replace": False,
                        }],
                    },
                    "match_rules": [{
                        "full_path_match": "a full path",
                        "header_matches": [{
                            "header_name": "someheader",
                            "exact_match": "match this exactly",
                            "invert_match": True,
                        }],
                        "ignore_case": True,
                        "metadata_filters": [{
                            "filter_match_criteria": "MATCH_ANY",
                            "filter_labels": [{
                                "name": "PLANET",
                                "value": "MARS",
                            }],
                        }],
                        "query_parameter_matches": [{
                            "name": "a query parameter",
                            "present_match": True,
                        }],
                    }],
                    "url_redirect": {
                        "host_redirect": "A host",
                        "https_redirect": False,
                        "path_redirect": "some/path",
                        "redirect_response_code": "TEMPORARY_REDIRECT",
                        "strip_query": True,
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Route Partial

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "route_rules": [{
                    "priority": 1,
                    "service": home.id,
                    "header_action": {
                        "request_headers_to_removes": ["RemoveMe2"],
                    },
                    "match_rules": [{
                        "full_path_match": "a full path",
                        "header_matches": [{
                            "header_name": "someheader",
                            "exact_match": "match this exactly",
                            "invert_match": True,
                        }],
                        "query_parameter_matches": [{
                            "name": "a query parameter",
                            "present_match": True,
                        }],
                    }],
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map Path Template Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        home_backend = gcp.compute.RegionBackendService("home-backend",
            region="us-central1",
            name="home-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        cart_backend = gcp.compute.RegionBackendService("cart-backend",
            region="us-central1",
            name="cart-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        user_backend = gcp.compute.RegionBackendService("user-backend",
            region="us-central1",
            name="user-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        urlmap = gcp.compute.RegionUrlMap("urlmap",
            region="us-central1",
            name="urlmap",
            description="a description",
            default_service=home_backend.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "mysite",
            }],
            path_matchers=[{
                "name": "mysite",
                "default_service": home_backend.id,
                "route_rules": [
                    {
                        "match_rules": [{
                            "path_template_match": "/xyzwebservices/v2/xyz/users/{username=*}/carts/{cartid=**}",
                        }],
                        "service": cart_backend.id,
                        "priority": 1,
                        "route_action": {
                            "url_rewrite": {
                                "path_template_rewrite": "/{username}-{cartid}/",
                            },
                        },
                    },
                    {
                        "match_rules": [{
                            "path_template_match": "/xyzwebservices/v2/xyz/users/*/accountinfo/*",
                        }],
                        "service": user_backend.id,
                        "priority": 2,
                    },
                ],
            }])
        ```
        ### Region Url Map Path Matcher Default Route Action

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_route_action": {
                    "cors_policy": {
                        "disabled": False,
                        "allow_credentials": True,
                        "allow_headers": ["foobar"],
                        "allow_methods": [
                            "GET",
                            "POST",
                        ],
                        "allow_origins": ["example.com"],
                        "expose_headers": ["foobar"],
                        "max_age": 60,
                    },
                    "fault_injection_policy": {
                        "abort": {
                            "http_status": 500,
                            "percentage": 0.5,
                        },
                        "delay": {
                            "fixed_delay": {
                                "nanos": 500,
                                "seconds": "0",
                            },
                            "percentage": 0.5,
                        },
                    },
                    "request_mirror_policy": {
                        "backend_service": home.id,
                    },
                    "retry_policy": {
                        "num_retries": 3,
                        "per_try_timeout": {
                            "nanos": 500,
                            "seconds": "0",
                        },
                        "retry_conditions": [
                            "5xx",
                            "gateway-error",
                        ],
                    },
                    "timeout": {
                        "nanos": 500,
                        "seconds": "0",
                    },
                    "url_rewrite": {
                        "host_rewrite": "dev.example.com",
                        "path_prefix_rewrite": "/v1/api/",
                    },
                    "weighted_backend_services": [
                        {
                            "backend_service": home.id,
                            "header_action": {
                                "request_headers_to_adds": [
                                    {
                                        "header_name": "foo-request-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-request-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "request_headers_to_removes": ["fizz"],
                                "response_headers_to_adds": [
                                    {
                                        "header_name": "foo-response-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-response-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "response_headers_to_removes": ["buzz"],
                            },
                            "weight": 100,
                        },
                        {
                            "backend_service": login.id,
                            "header_action": {
                                "request_headers_to_adds": [
                                    {
                                        "header_name": "foo-request-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-request-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "request_headers_to_removes": ["fizz"],
                                "response_headers_to_adds": [
                                    {
                                        "header_name": "foo-response-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-response-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "response_headers_to_removes": ["buzz"],
                            },
                            "weight": 200,
                        },
                    ],
                },
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```

        ## Import

        RegionUrlMap can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/urlMaps/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionUrlMap can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default projects/{{project}}/regions/{{region}}/urlMaps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['RegionUrlMapDefaultRouteActionArgs', 'RegionUrlMapDefaultRouteActionArgsDict']] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
               defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[builtins.str] default_service: The full or partial URL of the defaultService resource to which traffic is directed if
               none of the hostRules match. If defaultRouteAction is additionally specified, advanced
               routing actions like URL Rewrites, etc. take effect prior to sending the request to the
               backend. However, if defaultService is specified, defaultRouteAction cannot contain any
               weightedBackendServices. Conversely, if routeAction specifies any
               weightedBackendServices, service must not be specified.  Only one of defaultService,
               defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        :param pulumi.Input[Union['RegionUrlMapDefaultUrlRedirectArgs', 'RegionUrlMapDefaultUrlRedirectArgsDict']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapHostRuleArgs', 'RegionUrlMapHostRuleArgsDict']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapPathMatcherArgs', 'RegionUrlMapPathMatcherArgsDict']]]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapTestArgs', 'RegionUrlMapTestArgsDict']]]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RegionUrlMapArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        UrlMaps are used to route requests to a backend service based on rules
        that you define for the host and path of an incoming URL.

        ## Example Usage

        ### Region Url Map Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map Default Route Action

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_route_action={
                "retry_policy": {
                    "retry_conditions": [
                        "5xx",
                        "gateway-error",
                    ],
                    "num_retries": 3,
                    "per_try_timeout": {
                        "seconds": "0",
                        "nanos": 500,
                    },
                },
                "request_mirror_policy": {
                    "backend_service": home.id,
                },
                "weighted_backend_services": [
                    {
                        "backend_service": login.id,
                        "weight": 200,
                        "header_action": {
                            "request_headers_to_adds": [{
                                "header_name": "foo-request-1",
                                "header_value": "bar",
                                "replace": True,
                            }],
                            "request_headers_to_removes": ["fizz"],
                            "response_headers_to_adds": [{
                                "header_name": "foo-response-1",
                                "header_value": "bar",
                                "replace": True,
                            }],
                            "response_headers_to_removes": ["buzz"],
                        },
                    },
                    {
                        "backend_service": home.id,
                        "weight": 100,
                        "header_action": {
                            "request_headers_to_adds": [
                                {
                                    "header_name": "foo-request-1",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                                {
                                    "header_name": "foo-request-2",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                            ],
                            "request_headers_to_removes": ["fizz"],
                            "response_headers_to_adds": [
                                {
                                    "header_name": "foo-response-2",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                                {
                                    "header_name": "foo-response-1",
                                    "header_value": "bar",
                                    "replace": True,
                                },
                            ],
                            "response_headers_to_removes": ["buzz"],
                        },
                    },
                ],
                "url_rewrite": {
                    "host_rewrite": "dev.example.com",
                    "path_prefix_rewrite": "/v1/api/",
                },
                "cors_policy": {
                    "disabled": False,
                    "allow_credentials": True,
                    "allow_headers": ["foobar"],
                    "allow_methods": [
                        "GET",
                        "POST",
                    ],
                    "allow_origins": ["example.com"],
                    "expose_headers": ["foobar"],
                    "max_age": 60,
                },
                "fault_injection_policy": {
                    "delay": {
                        "fixed_delay": {
                            "seconds": "0",
                            "nanos": 500,
                        },
                        "percentage": 0.5,
                    },
                    "abort": {
                        "http_status": 500,
                        "percentage": 0.5,
                    },
                },
                "timeout": {
                    "seconds": "0",
                    "nanos": 500,
                },
            },
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Path

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [{
                    "paths": ["/home"],
                    "route_action": {
                        "cors_policy": {
                            "allow_credentials": True,
                            "allow_headers": ["Allowed content"],
                            "allow_methods": ["GET"],
                            "allow_origins": ["Allowed origin"],
                            "expose_headers": ["Exposed header"],
                            "max_age": 30,
                            "disabled": False,
                        },
                        "fault_injection_policy": {
                            "abort": {
                                "http_status": 234,
                                "percentage": 5.6,
                            },
                            "delay": {
                                "fixed_delay": {
                                    "seconds": "0",
                                    "nanos": 50000,
                                },
                                "percentage": 7.8,
                            },
                        },
                        "request_mirror_policy": {
                            "backend_service": home.id,
                        },
                        "retry_policy": {
                            "num_retries": 4,
                            "per_try_timeout": {
                                "seconds": "30",
                            },
                            "retry_conditions": [
                                "5xx",
                                "deadline-exceeded",
                            ],
                        },
                        "timeout": {
                            "seconds": "20",
                            "nanos": 750000000,
                        },
                        "url_rewrite": {
                            "host_rewrite": "dev.example.com",
                            "path_prefix_rewrite": "/v1/api/",
                        },
                        "weighted_backend_services": [{
                            "backend_service": home.id,
                            "weight": 400,
                            "header_action": {
                                "request_headers_to_removes": ["RemoveMe"],
                                "request_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": True,
                                }],
                                "response_headers_to_removes": ["RemoveMe"],
                                "response_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": False,
                                }],
                            },
                        }],
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Path Partial

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "path_rules": [{
                    "paths": ["/home"],
                    "route_action": {
                        "retry_policy": {
                            "num_retries": 4,
                            "per_try_timeout": {
                                "seconds": "30",
                            },
                            "retry_conditions": [
                                "5xx",
                                "deadline-exceeded",
                            ],
                        },
                        "timeout": {
                            "seconds": "20",
                            "nanos": 750000000,
                        },
                        "url_rewrite": {
                            "host_rewrite": "dev.example.com",
                            "path_prefix_rewrite": "/v1/api/",
                        },
                        "weighted_backend_services": [{
                            "backend_service": home.id,
                            "weight": 400,
                            "header_action": {
                                "response_headers_to_adds": [{
                                    "header_name": "AddMe",
                                    "header_value": "MyValue",
                                    "replace": False,
                                }],
                            },
                        }],
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Route

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "route_rules": [{
                    "priority": 1,
                    "header_action": {
                        "request_headers_to_removes": ["RemoveMe2"],
                        "request_headers_to_adds": [{
                            "header_name": "AddSomethingElse",
                            "header_value": "MyOtherValue",
                            "replace": True,
                        }],
                        "response_headers_to_removes": ["RemoveMe3"],
                        "response_headers_to_adds": [{
                            "header_name": "AddMe",
                            "header_value": "MyValue",
                            "replace": False,
                        }],
                    },
                    "match_rules": [{
                        "full_path_match": "a full path",
                        "header_matches": [{
                            "header_name": "someheader",
                            "exact_match": "match this exactly",
                            "invert_match": True,
                        }],
                        "ignore_case": True,
                        "metadata_filters": [{
                            "filter_match_criteria": "MATCH_ANY",
                            "filter_labels": [{
                                "name": "PLANET",
                                "value": "MARS",
                            }],
                        }],
                        "query_parameter_matches": [{
                            "name": "a query parameter",
                            "present_match": True,
                        }],
                    }],
                    "url_redirect": {
                        "host_redirect": "A host",
                        "https_redirect": False,
                        "path_redirect": "some/path",
                        "redirect_response_code": "TEMPORARY_REDIRECT",
                        "strip_query": True,
                    },
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map L7 Ilb Route Partial

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            name="health-check",
            http_health_check={
                "port": 80,
            })
        home = gcp.compute.RegionBackendService("home",
            name="home",
            protocol="HTTP",
            timeout_sec=10,
            health_checks=default.id,
            load_balancing_scheme="INTERNAL_MANAGED")
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_service": home.id,
                "route_rules": [{
                    "priority": 1,
                    "service": home.id,
                    "header_action": {
                        "request_headers_to_removes": ["RemoveMe2"],
                    },
                    "match_rules": [{
                        "full_path_match": "a full path",
                        "header_matches": [{
                            "header_name": "someheader",
                            "exact_match": "match this exactly",
                            "invert_match": True,
                        }],
                        "query_parameter_matches": [{
                            "name": "a query parameter",
                            "present_match": True,
                        }],
                    }],
                }],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```
        ### Region Url Map Path Template Match

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        home_backend = gcp.compute.RegionBackendService("home-backend",
            region="us-central1",
            name="home-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        cart_backend = gcp.compute.RegionBackendService("cart-backend",
            region="us-central1",
            name="cart-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        user_backend = gcp.compute.RegionBackendService("user-backend",
            region="us-central1",
            name="user-service",
            port_name="http",
            protocol="HTTP",
            timeout_sec=10,
            load_balancing_scheme="EXTERNAL_MANAGED",
            health_checks=default.id)
        urlmap = gcp.compute.RegionUrlMap("urlmap",
            region="us-central1",
            name="urlmap",
            description="a description",
            default_service=home_backend.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "mysite",
            }],
            path_matchers=[{
                "name": "mysite",
                "default_service": home_backend.id,
                "route_rules": [
                    {
                        "match_rules": [{
                            "path_template_match": "/xyzwebservices/v2/xyz/users/{username=*}/carts/{cartid=**}",
                        }],
                        "service": cart_backend.id,
                        "priority": 1,
                        "route_action": {
                            "url_rewrite": {
                                "path_template_rewrite": "/{username}-{cartid}/",
                            },
                        },
                    },
                    {
                        "match_rules": [{
                            "path_template_match": "/xyzwebservices/v2/xyz/users/*/accountinfo/*",
                        }],
                        "service": user_backend.id,
                        "priority": 2,
                    },
                ],
            }])
        ```
        ### Region Url Map Path Matcher Default Route Action

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.RegionHealthCheck("default",
            region="us-central1",
            name="health-check",
            check_interval_sec=1,
            timeout_sec=1,
            http_health_check={
                "port": 80,
                "request_path": "/",
            })
        login = gcp.compute.RegionBackendService("login",
            region="us-central1",
            name="login",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        home = gcp.compute.RegionBackendService("home",
            region="us-central1",
            name="home",
            protocol="HTTP",
            load_balancing_scheme="INTERNAL_MANAGED",
            timeout_sec=10,
            health_checks=default.id)
        regionurlmap = gcp.compute.RegionUrlMap("regionurlmap",
            region="us-central1",
            name="regionurlmap",
            description="a description",
            default_service=home.id,
            host_rules=[{
                "hosts": ["mysite.com"],
                "path_matcher": "allpaths",
            }],
            path_matchers=[{
                "name": "allpaths",
                "default_route_action": {
                    "cors_policy": {
                        "disabled": False,
                        "allow_credentials": True,
                        "allow_headers": ["foobar"],
                        "allow_methods": [
                            "GET",
                            "POST",
                        ],
                        "allow_origins": ["example.com"],
                        "expose_headers": ["foobar"],
                        "max_age": 60,
                    },
                    "fault_injection_policy": {
                        "abort": {
                            "http_status": 500,
                            "percentage": 0.5,
                        },
                        "delay": {
                            "fixed_delay": {
                                "nanos": 500,
                                "seconds": "0",
                            },
                            "percentage": 0.5,
                        },
                    },
                    "request_mirror_policy": {
                        "backend_service": home.id,
                    },
                    "retry_policy": {
                        "num_retries": 3,
                        "per_try_timeout": {
                            "nanos": 500,
                            "seconds": "0",
                        },
                        "retry_conditions": [
                            "5xx",
                            "gateway-error",
                        ],
                    },
                    "timeout": {
                        "nanos": 500,
                        "seconds": "0",
                    },
                    "url_rewrite": {
                        "host_rewrite": "dev.example.com",
                        "path_prefix_rewrite": "/v1/api/",
                    },
                    "weighted_backend_services": [
                        {
                            "backend_service": home.id,
                            "header_action": {
                                "request_headers_to_adds": [
                                    {
                                        "header_name": "foo-request-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-request-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "request_headers_to_removes": ["fizz"],
                                "response_headers_to_adds": [
                                    {
                                        "header_name": "foo-response-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-response-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "response_headers_to_removes": ["buzz"],
                            },
                            "weight": 100,
                        },
                        {
                            "backend_service": login.id,
                            "header_action": {
                                "request_headers_to_adds": [
                                    {
                                        "header_name": "foo-request-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-request-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "request_headers_to_removes": ["fizz"],
                                "response_headers_to_adds": [
                                    {
                                        "header_name": "foo-response-1",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                    {
                                        "header_name": "foo-response-2",
                                        "header_value": "bar",
                                        "replace": True,
                                    },
                                ],
                                "response_headers_to_removes": ["buzz"],
                            },
                            "weight": 200,
                        },
                    ],
                },
                "path_rules": [
                    {
                        "paths": ["/home"],
                        "service": home.id,
                    },
                    {
                        "paths": ["/login"],
                        "service": login.id,
                    },
                ],
            }],
            tests=[{
                "service": home.id,
                "host": "hi.com",
                "path": "/home",
            }])
        ```

        ## Import

        RegionUrlMap can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/urlMaps/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, RegionUrlMap can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default projects/{{project}}/regions/{{region}}/urlMaps/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/regionUrlMap:RegionUrlMap default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RegionUrlMapArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionUrlMapArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_route_action: Optional[pulumi.Input[Union['RegionUrlMapDefaultRouteActionArgs', 'RegionUrlMapDefaultRouteActionArgsDict']]] = None,
                 default_service: Optional[pulumi.Input[builtins.str]] = None,
                 default_url_redirect: Optional[pulumi.Input[Union['RegionUrlMapDefaultUrlRedirectArgs', 'RegionUrlMapDefaultUrlRedirectArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapHostRuleArgs', 'RegionUrlMapHostRuleArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapPathMatcherArgs', 'RegionUrlMapPathMatcherArgsDict']]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapTestArgs', 'RegionUrlMapTestArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionUrlMapArgs.__new__(RegionUrlMapArgs)

            __props__.__dict__["default_route_action"] = default_route_action
            __props__.__dict__["default_service"] = default_service
            __props__.__dict__["default_url_redirect"] = default_url_redirect
            __props__.__dict__["description"] = description
            __props__.__dict__["host_rules"] = host_rules
            __props__.__dict__["name"] = name
            __props__.__dict__["path_matchers"] = path_matchers
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["tests"] = tests
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["map_id"] = None
            __props__.__dict__["self_link"] = None
        super(RegionUrlMap, __self__).__init__(
            'gcp:compute/regionUrlMap:RegionUrlMap',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            default_route_action: Optional[pulumi.Input[Union['RegionUrlMapDefaultRouteActionArgs', 'RegionUrlMapDefaultRouteActionArgsDict']]] = None,
            default_service: Optional[pulumi.Input[builtins.str]] = None,
            default_url_redirect: Optional[pulumi.Input[Union['RegionUrlMapDefaultUrlRedirectArgs', 'RegionUrlMapDefaultUrlRedirectArgsDict']]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            host_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapHostRuleArgs', 'RegionUrlMapHostRuleArgsDict']]]]] = None,
            map_id: Optional[pulumi.Input[builtins.int]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            path_matchers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapPathMatcherArgs', 'RegionUrlMapPathMatcherArgsDict']]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            tests: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapTestArgs', 'RegionUrlMapTestArgsDict']]]]] = None) -> 'RegionUrlMap':
        """
        Get an existing RegionUrlMap resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Union['RegionUrlMapDefaultRouteActionArgs', 'RegionUrlMapDefaultRouteActionArgsDict']] default_route_action: defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
               Only one of defaultRouteAction or defaultUrlRedirect must be set.
               URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
               defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
               Structure is documented below.
        :param pulumi.Input[builtins.str] default_service: The full or partial URL of the defaultService resource to which traffic is directed if
               none of the hostRules match. If defaultRouteAction is additionally specified, advanced
               routing actions like URL Rewrites, etc. take effect prior to sending the request to the
               backend. However, if defaultService is specified, defaultRouteAction cannot contain any
               weightedBackendServices. Conversely, if routeAction specifies any
               weightedBackendServices, service must not be specified.  Only one of defaultService,
               defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        :param pulumi.Input[Union['RegionUrlMapDefaultUrlRedirectArgs', 'RegionUrlMapDefaultUrlRedirectArgsDict']] default_url_redirect: When none of the specified hostRules match, the request is redirected to a URL specified
               by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
               defaultRouteAction must not be set.
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property when
               you create the resource.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapHostRuleArgs', 'RegionUrlMapHostRuleArgsDict']]]] host_rules: The list of HostRules to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.int] map_id: The unique identifier for the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035. Specifically, the name must be 1-63 characters long and match
               the regular expression `a-z?` which means the
               first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the last
               character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapPathMatcherArgs', 'RegionUrlMapPathMatcherArgsDict']]]] path_matchers: The list of named PathMatchers to use against the URL.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The Region in which the url map should reside.
               If it is not provided, the provider region is used.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RegionUrlMapTestArgs', 'RegionUrlMapTestArgsDict']]]] tests: The list of expected URL mappings. Requests to update this UrlMap will
               succeed only if all of the test cases pass.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegionUrlMapState.__new__(_RegionUrlMapState)

        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["default_route_action"] = default_route_action
        __props__.__dict__["default_service"] = default_service
        __props__.__dict__["default_url_redirect"] = default_url_redirect
        __props__.__dict__["description"] = description
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["host_rules"] = host_rules
        __props__.__dict__["map_id"] = map_id
        __props__.__dict__["name"] = name
        __props__.__dict__["path_matchers"] = path_matchers
        __props__.__dict__["project"] = project
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tests"] = tests
        return RegionUrlMap(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="defaultRouteAction")
    def default_route_action(self) -> pulumi.Output[Optional['outputs.RegionUrlMapDefaultRouteAction']]:
        """
        defaultRouteAction takes effect when none of the hostRules match. The load balancer performs advanced routing actions, such as URL rewrites and header transformations, before forwarding the request to the selected backend. If defaultRouteAction specifies any weightedBackendServices, defaultService must not be set. Conversely if defaultService is set, defaultRouteAction cannot contain any weightedBackendServices.
        Only one of defaultRouteAction or defaultUrlRedirect must be set.
        URL maps for Classic external HTTP(S) load balancers only support the urlRewrite action within defaultRouteAction.
        defaultRouteAction has no effect when the URL map is bound to a target gRPC proxy that has the validateForProxyless field set to true.
        Structure is documented below.
        """
        return pulumi.get(self, "default_route_action")

    @property
    @pulumi.getter(name="defaultService")
    def default_service(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The full or partial URL of the defaultService resource to which traffic is directed if
        none of the hostRules match. If defaultRouteAction is additionally specified, advanced
        routing actions like URL Rewrites, etc. take effect prior to sending the request to the
        backend. However, if defaultService is specified, defaultRouteAction cannot contain any
        weightedBackendServices. Conversely, if routeAction specifies any
        weightedBackendServices, service must not be specified.  Only one of defaultService,
        defaultUrlRedirect or defaultRouteAction.weightedBackendService must be set.
        """
        return pulumi.get(self, "default_service")

    @property
    @pulumi.getter(name="defaultUrlRedirect")
    def default_url_redirect(self) -> pulumi.Output[Optional['outputs.RegionUrlMapDefaultUrlRedirect']]:
        """
        When none of the specified hostRules match, the request is redirected to a URL specified
        by defaultUrlRedirect. If defaultUrlRedirect is specified, defaultService or
        defaultRouteAction must not be set.
        Structure is documented below.
        """
        return pulumi.get(self, "default_url_redirect")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property when
        you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="hostRules")
    def host_rules(self) -> pulumi.Output[Optional[Sequence['outputs.RegionUrlMapHostRule']]]:
        """
        The list of HostRules to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "host_rules")

    @property
    @pulumi.getter(name="mapId")
    def map_id(self) -> pulumi.Output[builtins.int]:
        """
        The unique identifier for the resource.
        """
        return pulumi.get(self, "map_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035. Specifically, the name must be 1-63 characters long and match
        the regular expression `a-z?` which means the
        first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the last
        character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pathMatchers")
    def path_matchers(self) -> pulumi.Output[Optional[Sequence['outputs.RegionUrlMapPathMatcher']]]:
        """
        The list of named PathMatchers to use against the URL.
        Structure is documented below.
        """
        return pulumi.get(self, "path_matchers")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The Region in which the url map should reside.
        If it is not provided, the provider region is used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tests(self) -> pulumi.Output[Optional[Sequence['outputs.RegionUrlMapTest']]]:
        """
        The list of expected URL mappings. Requests to update this UrlMap will
        succeed only if all of the test cases pass.
        Structure is documented below.
        """
        return pulumi.get(self, "tests")

