# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 dest_range: pulumi.Input[builtins.str],
                 network: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input['RouteParamsArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[builtins.str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] network: The network that this route applies to.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[builtins.str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[builtins.str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[builtins.str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[builtins.str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input['RouteParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of instance tags to which this route applies.
        """
        pulumi.set(__self__, "dest_range", dest_range)
        pulumi.set(__self__, "network", network)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if next_hop_gateway is not None:
            pulumi.set(__self__, "next_hop_gateway", next_hop_gateway)
        if next_hop_ilb is not None:
            pulumi.set(__self__, "next_hop_ilb", next_hop_ilb)
        if next_hop_instance is not None:
            pulumi.set(__self__, "next_hop_instance", next_hop_instance)
        if next_hop_instance_zone is not None:
            pulumi.set(__self__, "next_hop_instance_zone", next_hop_instance_zone)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if next_hop_vpn_tunnel is not None:
            pulumi.set(__self__, "next_hop_vpn_tunnel", next_hop_vpn_tunnel)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> pulumi.Input[builtins.str]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @dest_range.setter
    def dest_range(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dest_range", value)

    @property
    @pulumi.getter
    def network(self) -> pulumi.Input[builtins.str]:
        """
        The network that this route applies to.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @next_hop_gateway.setter
    def next_hop_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_gateway", value)

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @next_hop_ilb.setter
    def next_hop_ilb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ilb", value)

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @next_hop_instance.setter
    def next_hop_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_instance", value)

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @next_hop_instance_zone.setter
    def next_hop_instance_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_instance_zone", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @next_hop_vpn_tunnel.setter
    def next_hop_vpn_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_vpn_tunnel", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['RouteParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['RouteParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 as_paths: Optional[pulumi.Input[Sequence[pulumi.Input['RouteAsPathArgs']]]] = None,
                 creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dest_range: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_hub: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_inter_region_cost: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_med: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_network: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_origin: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_peering: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input['RouteParamsArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 route_status: Optional[pulumi.Input[builtins.str]] = None,
                 route_type: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 warnings: Optional[pulumi.Input[Sequence[pulumi.Input['RouteWarningArgs']]]] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[Sequence[pulumi.Input['RouteAsPathArgs']]] as_paths: Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[builtins.str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network that this route applies to.
        :param pulumi.Input[builtins.str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[builtins.str] next_hop_hub: The hub network that should handle matching packets, which should conform to RFC1035.
        :param pulumi.Input[builtins.str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[builtins.str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[builtins.str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[builtins.str] next_hop_inter_region_cost: Internal fixed region-to-region cost that Google Cloud calculates based on factors such as network performance, distance, and available bandwidth between regions.
        :param pulumi.Input[builtins.str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_med: Multi-Exit Discriminator, a BGP route metric that indicates the desirability of a particular route in a network.
        :param pulumi.Input[builtins.str] next_hop_network: URL to a Network that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_origin: Indicates the origin of the route. Can be IGP (Interior Gateway Protocol), EGP (Exterior Gateway Protocol), or INCOMPLETE.
        :param pulumi.Input[builtins.str] next_hop_peering: The network peering name that should handle matching packets, which should conform to RFC1035.
        :param pulumi.Input[builtins.str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input['RouteParamsArgs'] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] route_status: The status of the route, which can be one of the following values:
               - 'ACTIVE' for an active route
               - 'INACTIVE' for an inactive route
        :param pulumi.Input[builtins.str] route_type: The type of this route, which can be one of the following values:
               - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers
               - 'SUBNET' for a route from a subnet of the VPC
               - 'BGP' for a route learned from a BGP peer of this router
               - 'STATIC' for a static route
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of instance tags to which this route applies.
        :param pulumi.Input[Sequence[pulumi.Input['RouteWarningArgs']]] warnings: If potential misconfigurations are detected for this route, this field will be populated with warning messages.
               Structure is documented below.
        """
        if as_paths is not None:
            pulumi.set(__self__, "as_paths", as_paths)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dest_range is not None:
            pulumi.set(__self__, "dest_range", dest_range)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if next_hop_gateway is not None:
            pulumi.set(__self__, "next_hop_gateway", next_hop_gateway)
        if next_hop_hub is not None:
            pulumi.set(__self__, "next_hop_hub", next_hop_hub)
        if next_hop_ilb is not None:
            pulumi.set(__self__, "next_hop_ilb", next_hop_ilb)
        if next_hop_instance is not None:
            pulumi.set(__self__, "next_hop_instance", next_hop_instance)
        if next_hop_instance_zone is not None:
            pulumi.set(__self__, "next_hop_instance_zone", next_hop_instance_zone)
        if next_hop_inter_region_cost is not None:
            pulumi.set(__self__, "next_hop_inter_region_cost", next_hop_inter_region_cost)
        if next_hop_ip is not None:
            pulumi.set(__self__, "next_hop_ip", next_hop_ip)
        if next_hop_med is not None:
            pulumi.set(__self__, "next_hop_med", next_hop_med)
        if next_hop_network is not None:
            pulumi.set(__self__, "next_hop_network", next_hop_network)
        if next_hop_origin is not None:
            pulumi.set(__self__, "next_hop_origin", next_hop_origin)
        if next_hop_peering is not None:
            pulumi.set(__self__, "next_hop_peering", next_hop_peering)
        if next_hop_vpn_tunnel is not None:
            pulumi.set(__self__, "next_hop_vpn_tunnel", next_hop_vpn_tunnel)
        if params is not None:
            pulumi.set(__self__, "params", params)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if route_status is not None:
            pulumi.set(__self__, "route_status", route_status)
        if route_type is not None:
            pulumi.set(__self__, "route_type", route_type)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @property
    @pulumi.getter(name="asPaths")
    def as_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteAsPathArgs']]]]:
        """
        Structure is documented below.
        """
        return pulumi.get(self, "as_paths")

    @as_paths.setter
    def as_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteAsPathArgs']]]]):
        pulumi.set(self, "as_paths", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @dest_range.setter
    def dest_range(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dest_range", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network that this route applies to.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @next_hop_gateway.setter
    def next_hop_gateway(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_gateway", value)

    @property
    @pulumi.getter(name="nextHopHub")
    def next_hop_hub(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The hub network that should handle matching packets, which should conform to RFC1035.
        """
        return pulumi.get(self, "next_hop_hub")

    @next_hop_hub.setter
    def next_hop_hub(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_hub", value)

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @next_hop_ilb.setter
    def next_hop_ilb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ilb", value)

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @next_hop_instance.setter
    def next_hop_instance(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_instance", value)

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @next_hop_instance_zone.setter
    def next_hop_instance_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_instance_zone", value)

    @property
    @pulumi.getter(name="nextHopInterRegionCost")
    def next_hop_inter_region_cost(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Internal fixed region-to-region cost that Google Cloud calculates based on factors such as network performance, distance, and available bandwidth between regions.
        """
        return pulumi.get(self, "next_hop_inter_region_cost")

    @next_hop_inter_region_cost.setter
    def next_hop_inter_region_cost(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_inter_region_cost", value)

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @next_hop_ip.setter
    def next_hop_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_ip", value)

    @property
    @pulumi.getter(name="nextHopMed")
    def next_hop_med(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Multi-Exit Discriminator, a BGP route metric that indicates the desirability of a particular route in a network.
        """
        return pulumi.get(self, "next_hop_med")

    @next_hop_med.setter
    def next_hop_med(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_med", value)

    @property
    @pulumi.getter(name="nextHopNetwork")
    def next_hop_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to a Network that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_network")

    @next_hop_network.setter
    def next_hop_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_network", value)

    @property
    @pulumi.getter(name="nextHopOrigin")
    def next_hop_origin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Indicates the origin of the route. Can be IGP (Interior Gateway Protocol), EGP (Exterior Gateway Protocol), or INCOMPLETE.
        """
        return pulumi.get(self, "next_hop_origin")

    @next_hop_origin.setter
    def next_hop_origin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_origin", value)

    @property
    @pulumi.getter(name="nextHopPeering")
    def next_hop_peering(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network peering name that should handle matching packets, which should conform to RFC1035.
        """
        return pulumi.get(self, "next_hop_peering")

    @next_hop_peering.setter
    def next_hop_peering(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_peering", value)

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @next_hop_vpn_tunnel.setter
    def next_hop_vpn_tunnel(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "next_hop_vpn_tunnel", value)

    @property
    @pulumi.getter
    def params(self) -> Optional[pulumi.Input['RouteParamsArgs']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @params.setter
    def params(self, value: Optional[pulumi.Input['RouteParamsArgs']]):
        pulumi.set(self, "params", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="routeStatus")
    def route_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The status of the route, which can be one of the following values:
        - 'ACTIVE' for an active route
        - 'INACTIVE' for an inactive route
        """
        return pulumi.get(self, "route_status")

    @route_status.setter
    def route_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_status", value)

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of this route, which can be one of the following values:
        - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers
        - 'SUBNET' for a route from a subnet of the VPC
        - 'BGP' for a route learned from a BGP peer of this router
        - 'STATIC' for a static route
        """
        return pulumi.get(self, "route_type")

    @route_type.setter
    def route_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "route_type", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteWarningArgs']]]]:
        """
        If potential misconfigurations are detected for this route, this field will be populated with warning messages.
        Structure is documented below.
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteWarningArgs']]]]):
        pulumi.set(self, "warnings", value)


@pulumi.type_token("gcp:compute/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dest_range: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['RouteParamsArgs', 'RouteParamsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        Represents a Route resource.

        A route is a rule that specifies how certain packets should be handled by
        the virtual network. Routes are associated with virtual machines by tag,
        and the set of routes for a particular virtual machine is called its
        routing table. For each packet leaving a virtual machine, the system
        searches that virtual machine's routing table for a single best matching
        route.

        Routes match packets by destination IP address, preferring smaller or more
        specific ranges over larger ones. If there is a tie, the system selects
        the route with the smallest priority value. If there is still a tie, it
        uses the layer three and four packet headers to select just one of the
        remaining matching routes. The packet is then forwarded as specified by
        the next_hop field of the winning route -- either to another virtual
        machine destination, a virtual machine gateway or a Compute
        Engine-operated gateway. Packets that do not match any route in the
        sending virtual machine's routing table will be dropped.

        A Route resource must have exactly one specification of either
        nextHopGateway, nextHopInstance, nextHopIp, nextHopVpnTunnel, or
        nextHopIlb.

        To get more information about Route, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routes)
        * How-to Guides
            * [Using Routes](https://cloud.google.com/vpc/docs/using-routes)

        ## Example Usage

        ### Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="compute-network")
        default = gcp.compute.Route("default",
            name="network-route",
            dest_range="15.0.0.0/24",
            network=default_network.name,
            next_hop_ip="10.132.1.5",
            priority=100)
        ```
        ### Route Ilb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="compute-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="compute-subnet",
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=default.id)
        hc = gcp.compute.HealthCheck("hc",
            name="proxy-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="compute-backend",
            region="us-central1",
            health_checks=hc.id)
        default_forwarding_rule = gcp.compute.ForwardingRule("default",
            name="compute-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default.name,
            subnetwork=default_subnetwork.name)
        route_ilb = gcp.compute.Route("route-ilb",
            name="route-ilb",
            dest_range="0.0.0.0/0",
            network=default.name,
            next_hop_ilb=default_forwarding_rule.id,
            priority=2000)
        ```
        ### Route Ilb Vip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer = gcp.compute.Network("producer",
            name="producer-vpc",
            auto_create_subnetworks=False)
        producer_subnetwork = gcp.compute.Subnetwork("producer",
            name="producer-subnet",
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=producer.id)
        consumer = gcp.compute.Network("consumer",
            name="consumer-vpc",
            auto_create_subnetworks=False)
        consumer_subnetwork = gcp.compute.Subnetwork("consumer",
            name="consumer-subnet",
            ip_cidr_range="10.0.2.0/24",
            region="us-central1",
            network=consumer.id)
        peering1 = gcp.compute.NetworkPeering("peering1",
            name="peering-producer-to-consumer",
            network=consumer.id,
            peer_network=producer.id)
        peering2 = gcp.compute.NetworkPeering("peering2",
            name="peering-consumer-to-producer",
            network=producer.id,
            peer_network=consumer.id)
        hc = gcp.compute.HealthCheck("hc",
            name="proxy-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="compute-backend",
            region="us-central1",
            health_checks=hc.id)
        default = gcp.compute.ForwardingRule("default",
            name="compute-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=producer.name,
            subnetwork=producer_subnetwork.name)
        route_ilb = gcp.compute.Route("route-ilb",
            name="route-ilb",
            dest_range="0.0.0.0/0",
            network=consumer.name,
            next_hop_ilb=default.ip_address,
            priority=2000,
            tags=[
                "tag1",
                "tag2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    peering1,
                    peering2,
                ]))
        ```

        ## Import

        Route can be imported using any of these accepted formats:

        * `projects/{{project}}/global/routes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Route can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/route:Route default projects/{{project}}/global/routes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/route:Route default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/route:Route default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[builtins.str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network that this route applies to.
        :param pulumi.Input[builtins.str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[builtins.str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[builtins.str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[builtins.str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[builtins.str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[Union['RouteParamsArgs', 'RouteParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of instance tags to which this route applies.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Route resource.

        A route is a rule that specifies how certain packets should be handled by
        the virtual network. Routes are associated with virtual machines by tag,
        and the set of routes for a particular virtual machine is called its
        routing table. For each packet leaving a virtual machine, the system
        searches that virtual machine's routing table for a single best matching
        route.

        Routes match packets by destination IP address, preferring smaller or more
        specific ranges over larger ones. If there is a tie, the system selects
        the route with the smallest priority value. If there is still a tie, it
        uses the layer three and four packet headers to select just one of the
        remaining matching routes. The packet is then forwarded as specified by
        the next_hop field of the winning route -- either to another virtual
        machine destination, a virtual machine gateway or a Compute
        Engine-operated gateway. Packets that do not match any route in the
        sending virtual machine's routing table will be dropped.

        A Route resource must have exactly one specification of either
        nextHopGateway, nextHopInstance, nextHopIp, nextHopVpnTunnel, or
        nextHopIlb.

        To get more information about Route, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/routes)
        * How-to Guides
            * [Using Routes](https://cloud.google.com/vpc/docs/using-routes)

        ## Example Usage

        ### Route Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default_network = gcp.compute.Network("default", name="compute-network")
        default = gcp.compute.Route("default",
            name="network-route",
            dest_range="15.0.0.0/24",
            network=default_network.name,
            next_hop_ip="10.132.1.5",
            priority=100)
        ```
        ### Route Ilb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.compute.Network("default",
            name="compute-network",
            auto_create_subnetworks=False)
        default_subnetwork = gcp.compute.Subnetwork("default",
            name="compute-subnet",
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=default.id)
        hc = gcp.compute.HealthCheck("hc",
            name="proxy-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="compute-backend",
            region="us-central1",
            health_checks=hc.id)
        default_forwarding_rule = gcp.compute.ForwardingRule("default",
            name="compute-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=default.name,
            subnetwork=default_subnetwork.name)
        route_ilb = gcp.compute.Route("route-ilb",
            name="route-ilb",
            dest_range="0.0.0.0/0",
            network=default.name,
            next_hop_ilb=default_forwarding_rule.id,
            priority=2000)
        ```
        ### Route Ilb Vip

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer = gcp.compute.Network("producer",
            name="producer-vpc",
            auto_create_subnetworks=False)
        producer_subnetwork = gcp.compute.Subnetwork("producer",
            name="producer-subnet",
            ip_cidr_range="10.0.1.0/24",
            region="us-central1",
            network=producer.id)
        consumer = gcp.compute.Network("consumer",
            name="consumer-vpc",
            auto_create_subnetworks=False)
        consumer_subnetwork = gcp.compute.Subnetwork("consumer",
            name="consumer-subnet",
            ip_cidr_range="10.0.2.0/24",
            region="us-central1",
            network=consumer.id)
        peering1 = gcp.compute.NetworkPeering("peering1",
            name="peering-producer-to-consumer",
            network=consumer.id,
            peer_network=producer.id)
        peering2 = gcp.compute.NetworkPeering("peering2",
            name="peering-consumer-to-producer",
            network=producer.id,
            peer_network=consumer.id)
        hc = gcp.compute.HealthCheck("hc",
            name="proxy-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        backend = gcp.compute.RegionBackendService("backend",
            name="compute-backend",
            region="us-central1",
            health_checks=hc.id)
        default = gcp.compute.ForwardingRule("default",
            name="compute-forwarding-rule",
            region="us-central1",
            load_balancing_scheme="INTERNAL",
            backend_service=backend.id,
            all_ports=True,
            network=producer.name,
            subnetwork=producer_subnetwork.name)
        route_ilb = gcp.compute.Route("route-ilb",
            name="route-ilb",
            dest_range="0.0.0.0/0",
            network=consumer.name,
            next_hop_ilb=default.ip_address,
            priority=2000,
            tags=[
                "tag1",
                "tag2",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    peering1,
                    peering2,
                ]))
        ```

        ## Import

        Route can be imported using any of these accepted formats:

        * `projects/{{project}}/global/routes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Route can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/route:Route default projects/{{project}}/global/routes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/route:Route default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/route:Route default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 dest_range: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_gateway: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ilb: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_instance_zone: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
                 next_hop_vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
                 params: Optional[pulumi.Input[Union['RouteParamsArgs', 'RouteParamsArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            __props__.__dict__["description"] = description
            if dest_range is None and not opts.urn:
                raise TypeError("Missing required property 'dest_range'")
            __props__.__dict__["dest_range"] = dest_range
            __props__.__dict__["name"] = name
            if network is None and not opts.urn:
                raise TypeError("Missing required property 'network'")
            __props__.__dict__["network"] = network
            __props__.__dict__["next_hop_gateway"] = next_hop_gateway
            __props__.__dict__["next_hop_ilb"] = next_hop_ilb
            __props__.__dict__["next_hop_instance"] = next_hop_instance
            __props__.__dict__["next_hop_instance_zone"] = next_hop_instance_zone
            __props__.__dict__["next_hop_ip"] = next_hop_ip
            __props__.__dict__["next_hop_vpn_tunnel"] = next_hop_vpn_tunnel
            __props__.__dict__["params"] = params
            __props__.__dict__["priority"] = priority
            __props__.__dict__["project"] = project
            __props__.__dict__["tags"] = tags
            __props__.__dict__["as_paths"] = None
            __props__.__dict__["creation_timestamp"] = None
            __props__.__dict__["next_hop_hub"] = None
            __props__.__dict__["next_hop_inter_region_cost"] = None
            __props__.__dict__["next_hop_med"] = None
            __props__.__dict__["next_hop_network"] = None
            __props__.__dict__["next_hop_origin"] = None
            __props__.__dict__["next_hop_peering"] = None
            __props__.__dict__["route_status"] = None
            __props__.__dict__["route_type"] = None
            __props__.__dict__["self_link"] = None
            __props__.__dict__["warnings"] = None
        super(Route, __self__).__init__(
            'gcp:compute/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            as_paths: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteAsPathArgs', 'RouteAsPathArgsDict']]]]] = None,
            creation_timestamp: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            dest_range: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_gateway: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_hub: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_ilb: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_instance: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_instance_zone: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_inter_region_cost: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_ip: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_med: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_network: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_origin: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_peering: Optional[pulumi.Input[builtins.str]] = None,
            next_hop_vpn_tunnel: Optional[pulumi.Input[builtins.str]] = None,
            params: Optional[pulumi.Input[Union['RouteParamsArgs', 'RouteParamsArgsDict']]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            route_status: Optional[pulumi.Input[builtins.str]] = None,
            route_type: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            warnings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['RouteWarningArgs', 'RouteWarningArgsDict']]]]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteAsPathArgs', 'RouteAsPathArgsDict']]]] as_paths: Structure is documented below.
        :param pulumi.Input[builtins.str] creation_timestamp: Creation timestamp in RFC3339 text format.
        :param pulumi.Input[builtins.str] description: An optional description of this resource. Provide this property
               when you create the resource.
        :param pulumi.Input[builtins.str] dest_range: The destination range of outgoing packets that this route applies to.
               Only IPv4 is supported.
        :param pulumi.Input[builtins.str] name: Name of the resource. Provided by the client when the resource is
               created. The name must be 1-63 characters long, and comply with
               RFC1035.  Specifically, the name must be 1-63 characters long and
               match the regular expression `a-z?` which means
               the first character must be a lowercase letter, and all following
               characters must be a dash, lowercase letter, or digit, except the
               last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] network: The network that this route applies to.
        :param pulumi.Input[builtins.str] next_hop_gateway: URL to a gateway that should handle matching packets.
               Currently, you can only specify the internet gateway, using a full or
               partial valid URL:
               * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
               * `projects/project/global/gateways/default-internet-gateway`
               * `global/gateways/default-internet-gateway`
               * The string `default-internet-gateway`.
        :param pulumi.Input[builtins.str] next_hop_hub: The hub network that should handle matching packets, which should conform to RFC1035.
        :param pulumi.Input[builtins.str] next_hop_ilb: The IP address or URL to a forwarding rule of type
               loadBalancingScheme=INTERNAL that should handle matching
               packets.
               With the GA provider you can only specify the forwarding
               rule as a partial or full URL. For example, the following
               are all valid values:
               * 10.128.0.56
               * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
               * regions/region/forwardingRules/forwardingRule
               When the beta provider, you can also specify the IP address
               of a forwarding rule from the same VPC or any peered VPC.
               Note that this can only be used when the destinationRange is
               a public (non-RFC 1918) IP CIDR range.
        :param pulumi.Input[builtins.str] next_hop_instance: URL to an instance that should handle matching packets.
               You can specify this as a full or partial URL. For example:
               * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
               * `projects/project/zones/zone/instances/instance`
               * `zones/zone/instances/instance`
               * Just the instance name, with the zone in `next_hop_instance_zone`.
        :param pulumi.Input[builtins.str] next_hop_instance_zone: (Optional when `next_hop_instance` is
               specified)  The zone of the instance specified in
               `next_hop_instance`.  Omit if `next_hop_instance` is specified as
               a URL.
        :param pulumi.Input[builtins.str] next_hop_inter_region_cost: Internal fixed region-to-region cost that Google Cloud calculates based on factors such as network performance, distance, and available bandwidth between regions.
        :param pulumi.Input[builtins.str] next_hop_ip: Network IP address of an instance that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_med: Multi-Exit Discriminator, a BGP route metric that indicates the desirability of a particular route in a network.
        :param pulumi.Input[builtins.str] next_hop_network: URL to a Network that should handle matching packets.
        :param pulumi.Input[builtins.str] next_hop_origin: Indicates the origin of the route. Can be IGP (Interior Gateway Protocol), EGP (Exterior Gateway Protocol), or INCOMPLETE.
        :param pulumi.Input[builtins.str] next_hop_peering: The network peering name that should handle matching packets, which should conform to RFC1035.
        :param pulumi.Input[builtins.str] next_hop_vpn_tunnel: URL to a VpnTunnel that should handle matching packets.
        :param pulumi.Input[Union['RouteParamsArgs', 'RouteParamsArgsDict']] params: Additional params passed with the request, but not persisted as part of resource payload
               Structure is documented below.
        :param pulumi.Input[builtins.int] priority: The priority of this route. Priority is used to break ties in cases
               where there is more than one matching route of equal prefix length.
               In the case of two routes with equal prefix length, the one with the
               lowest-numbered priority value wins.
               Default value is 1000. Valid range is 0 through 65535.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] route_status: The status of the route, which can be one of the following values:
               - 'ACTIVE' for an active route
               - 'INACTIVE' for an inactive route
        :param pulumi.Input[builtins.str] route_type: The type of this route, which can be one of the following values:
               - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers
               - 'SUBNET' for a route from a subnet of the VPC
               - 'BGP' for a route learned from a BGP peer of this router
               - 'STATIC' for a static route
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] tags: A list of instance tags to which this route applies.
        :param pulumi.Input[Sequence[pulumi.Input[Union['RouteWarningArgs', 'RouteWarningArgsDict']]]] warnings: If potential misconfigurations are detected for this route, this field will be populated with warning messages.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["as_paths"] = as_paths
        __props__.__dict__["creation_timestamp"] = creation_timestamp
        __props__.__dict__["description"] = description
        __props__.__dict__["dest_range"] = dest_range
        __props__.__dict__["name"] = name
        __props__.__dict__["network"] = network
        __props__.__dict__["next_hop_gateway"] = next_hop_gateway
        __props__.__dict__["next_hop_hub"] = next_hop_hub
        __props__.__dict__["next_hop_ilb"] = next_hop_ilb
        __props__.__dict__["next_hop_instance"] = next_hop_instance
        __props__.__dict__["next_hop_instance_zone"] = next_hop_instance_zone
        __props__.__dict__["next_hop_inter_region_cost"] = next_hop_inter_region_cost
        __props__.__dict__["next_hop_ip"] = next_hop_ip
        __props__.__dict__["next_hop_med"] = next_hop_med
        __props__.__dict__["next_hop_network"] = next_hop_network
        __props__.__dict__["next_hop_origin"] = next_hop_origin
        __props__.__dict__["next_hop_peering"] = next_hop_peering
        __props__.__dict__["next_hop_vpn_tunnel"] = next_hop_vpn_tunnel
        __props__.__dict__["params"] = params
        __props__.__dict__["priority"] = priority
        __props__.__dict__["project"] = project
        __props__.__dict__["route_status"] = route_status
        __props__.__dict__["route_type"] = route_type
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["tags"] = tags
        __props__.__dict__["warnings"] = warnings
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="asPaths")
    def as_paths(self) -> pulumi.Output[Sequence['outputs.RouteAsPath']]:
        """
        Structure is documented below.
        """
        return pulumi.get(self, "as_paths")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[builtins.str]:
        """
        Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource. Provide this property
        when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destRange")
    def dest_range(self) -> pulumi.Output[builtins.str]:
        """
        The destination range of outgoing packets that this route applies to.
        Only IPv4 is supported.
        """
        return pulumi.get(self, "dest_range")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. Provided by the client when the resource is
        created. The name must be 1-63 characters long, and comply with
        RFC1035.  Specifically, the name must be 1-63 characters long and
        match the regular expression `a-z?` which means
        the first character must be a lowercase letter, and all following
        characters must be a dash, lowercase letter, or digit, except the
        last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[builtins.str]:
        """
        The network that this route applies to.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="nextHopGateway")
    def next_hop_gateway(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL to a gateway that should handle matching packets.
        Currently, you can only specify the internet gateway, using a full or
        partial valid URL:
        * `https://www.googleapis.com/compute/v1/projects/project/global/gateways/default-internet-gateway`
        * `projects/project/global/gateways/default-internet-gateway`
        * `global/gateways/default-internet-gateway`
        * The string `default-internet-gateway`.
        """
        return pulumi.get(self, "next_hop_gateway")

    @property
    @pulumi.getter(name="nextHopHub")
    def next_hop_hub(self) -> pulumi.Output[builtins.str]:
        """
        The hub network that should handle matching packets, which should conform to RFC1035.
        """
        return pulumi.get(self, "next_hop_hub")

    @property
    @pulumi.getter(name="nextHopIlb")
    def next_hop_ilb(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The IP address or URL to a forwarding rule of type
        loadBalancingScheme=INTERNAL that should handle matching
        packets.
        With the GA provider you can only specify the forwarding
        rule as a partial or full URL. For example, the following
        are all valid values:
        * 10.128.0.56
        * https://www.googleapis.com/compute/v1/projects/project/regions/region/forwardingRules/forwardingRule
        * regions/region/forwardingRules/forwardingRule
        When the beta provider, you can also specify the IP address
        of a forwarding rule from the same VPC or any peered VPC.
        Note that this can only be used when the destinationRange is
        a public (non-RFC 1918) IP CIDR range.
        """
        return pulumi.get(self, "next_hop_ilb")

    @property
    @pulumi.getter(name="nextHopInstance")
    def next_hop_instance(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL to an instance that should handle matching packets.
        You can specify this as a full or partial URL. For example:
        * `https://www.googleapis.com/compute/v1/projects/project/zones/zone/instances/instance`
        * `projects/project/zones/zone/instances/instance`
        * `zones/zone/instances/instance`
        * Just the instance name, with the zone in `next_hop_instance_zone`.
        """
        return pulumi.get(self, "next_hop_instance")

    @property
    @pulumi.getter(name="nextHopInstanceZone")
    def next_hop_instance_zone(self) -> pulumi.Output[builtins.str]:
        """
        (Optional when `next_hop_instance` is
        specified)  The zone of the instance specified in
        `next_hop_instance`.  Omit if `next_hop_instance` is specified as
        a URL.
        """
        return pulumi.get(self, "next_hop_instance_zone")

    @property
    @pulumi.getter(name="nextHopInterRegionCost")
    def next_hop_inter_region_cost(self) -> pulumi.Output[builtins.str]:
        """
        Internal fixed region-to-region cost that Google Cloud calculates based on factors such as network performance, distance, and available bandwidth between regions.
        """
        return pulumi.get(self, "next_hop_inter_region_cost")

    @property
    @pulumi.getter(name="nextHopIp")
    def next_hop_ip(self) -> pulumi.Output[builtins.str]:
        """
        Network IP address of an instance that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_ip")

    @property
    @pulumi.getter(name="nextHopMed")
    def next_hop_med(self) -> pulumi.Output[builtins.str]:
        """
        Multi-Exit Discriminator, a BGP route metric that indicates the desirability of a particular route in a network.
        """
        return pulumi.get(self, "next_hop_med")

    @property
    @pulumi.getter(name="nextHopNetwork")
    def next_hop_network(self) -> pulumi.Output[builtins.str]:
        """
        URL to a Network that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_network")

    @property
    @pulumi.getter(name="nextHopOrigin")
    def next_hop_origin(self) -> pulumi.Output[builtins.str]:
        """
        Indicates the origin of the route. Can be IGP (Interior Gateway Protocol), EGP (Exterior Gateway Protocol), or INCOMPLETE.
        """
        return pulumi.get(self, "next_hop_origin")

    @property
    @pulumi.getter(name="nextHopPeering")
    def next_hop_peering(self) -> pulumi.Output[builtins.str]:
        """
        The network peering name that should handle matching packets, which should conform to RFC1035.
        """
        return pulumi.get(self, "next_hop_peering")

    @property
    @pulumi.getter(name="nextHopVpnTunnel")
    def next_hop_vpn_tunnel(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        URL to a VpnTunnel that should handle matching packets.
        """
        return pulumi.get(self, "next_hop_vpn_tunnel")

    @property
    @pulumi.getter
    def params(self) -> pulumi.Output[Optional['outputs.RouteParams']]:
        """
        Additional params passed with the request, but not persisted as part of resource payload
        Structure is documented below.
        """
        return pulumi.get(self, "params")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The priority of this route. Priority is used to break ties in cases
        where there is more than one matching route of equal prefix length.
        In the case of two routes with equal prefix length, the one with the
        lowest-numbered priority value wins.
        Default value is 1000. Valid range is 0 through 65535.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="routeStatus")
    def route_status(self) -> pulumi.Output[builtins.str]:
        """
        The status of the route, which can be one of the following values:
        - 'ACTIVE' for an active route
        - 'INACTIVE' for an inactive route
        """
        return pulumi.get(self, "route_status")

    @property
    @pulumi.getter(name="routeType")
    def route_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of this route, which can be one of the following values:
        - 'TRANSIT' for a transit route that this router learned from another Cloud Router and will readvertise to one of its BGP peers
        - 'SUBNET' for a route from a subnet of the VPC
        - 'BGP' for a route learned from a BGP peer of this router
        - 'STATIC' for a static route
        """
        return pulumi.get(self, "route_type")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        A list of instance tags to which this route applies.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[Sequence['outputs.RouteWarning']]:
        """
        If potential misconfigurations are detected for this route, this field will be populated with warning messages.
        Structure is documented below.
        """
        return pulumi.get(self, "warnings")

