# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceAttachmentArgs', 'ServiceAttachment']

@pulumi.input_type
class ServiceAttachmentArgs:
    def __init__(__self__, *,
                 connection_preference: pulumi.Input[builtins.str],
                 enable_proxy_protocol: pulumi.Input[builtins.bool],
                 nat_subnets: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 target_service: pulumi.Input[builtins.str],
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 reconcile_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_propagated_connection_limit_if_zero: Optional[pulumi.Input[builtins.bool]] = None):
        """
        The set of arguments for constructing a ServiceAttachment resource.
        :param pulumi.Input[builtins.str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[builtins.bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[builtins.str] target_service: The URL of a service serving the endpoint identified by this service attachment.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] propagated_connection_limit: The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
               This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
               If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
               If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
               If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        :param pulumi.Input[builtins.bool] reconcile_connections: This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
               If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
               If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        :param pulumi.Input[builtins.str] region: URL of the region where the resource resides.
        :param pulumi.Input[builtins.bool] send_propagated_connection_limit_if_zero: Controls the behavior of propagated_connection_limit.
               When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
               When true, the provider will set propagated_connection_limit to zero.
               Defaults to false.
        """
        pulumi.set(__self__, "connection_preference", connection_preference)
        pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        pulumi.set(__self__, "nat_subnets", nat_subnets)
        pulumi.set(__self__, "target_service", target_service)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if consumer_reject_lists is not None:
            pulumi.set(__self__, "consumer_reject_lists", consumer_reject_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if propagated_connection_limit is not None:
            pulumi.set(__self__, "propagated_connection_limit", propagated_connection_limit)
        if reconcile_connections is not None:
            pulumi.set(__self__, "reconcile_connections", reconcile_connections)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if send_propagated_connection_limit_if_zero is not None:
            pulumi.set(__self__, "send_propagated_connection_limit_if_zero", send_propagated_connection_limit_if_zero)

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Input[builtins.str]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_preference", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Input[builtins.bool]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @nat_subnets.setter
    def nat_subnets(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "nat_subnets", value)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> pulumi.Input[builtins.str]:
        """
        The URL of a service serving the endpoint identified by this service attachment.
        """
        return pulumi.get(self, "target_service")

    @target_service.setter
    def target_service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_service", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @consumer_reject_lists.setter
    def consumer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "consumer_reject_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "domain_names", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="propagatedConnectionLimit")
    def propagated_connection_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
        This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
        If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
        If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
        If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        """
        return pulumi.get(self, "propagated_connection_limit")

    @propagated_connection_limit.setter
    def propagated_connection_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "propagated_connection_limit", value)

    @property
    @pulumi.getter(name="reconcileConnections")
    def reconcile_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
        If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
        If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        """
        return pulumi.get(self, "reconcile_connections")

    @reconcile_connections.setter
    def reconcile_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconcile_connections", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="sendPropagatedConnectionLimitIfZero")
    def send_propagated_connection_limit_if_zero(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls the behavior of propagated_connection_limit.
        When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
        When true, the provider will set propagated_connection_limit to zero.
        Defaults to false.
        """
        return pulumi.get(self, "send_propagated_connection_limit_if_zero")

    @send_propagated_connection_limit_if_zero.setter
    def send_propagated_connection_limit_if_zero(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_propagated_connection_limit_if_zero", value)


@pulumi.input_type
class _ServiceAttachmentState:
    def __init__(__self__, *,
                 connected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]] = None,
                 connection_preference: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[builtins.bool]] = None,
                 fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 reconcile_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 self_link: Optional[pulumi.Input[builtins.str]] = None,
                 send_propagated_connection_limit_if_zero: Optional[pulumi.Input[builtins.bool]] = None,
                 target_service: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceAttachment resources.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]] connected_endpoints: An array of the consumer forwarding rules connected to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[builtins.bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] propagated_connection_limit: The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
               This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
               If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
               If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
               If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        :param pulumi.Input[builtins.bool] reconcile_connections: This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
               If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
               If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        :param pulumi.Input[builtins.str] region: URL of the region where the resource resides.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.bool] send_propagated_connection_limit_if_zero: Controls the behavior of propagated_connection_limit.
               When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
               When true, the provider will set propagated_connection_limit to zero.
               Defaults to false.
        :param pulumi.Input[builtins.str] target_service: The URL of a service serving the endpoint identified by this service attachment.
        """
        if connected_endpoints is not None:
            pulumi.set(__self__, "connected_endpoints", connected_endpoints)
        if connection_preference is not None:
            pulumi.set(__self__, "connection_preference", connection_preference)
        if consumer_accept_lists is not None:
            pulumi.set(__self__, "consumer_accept_lists", consumer_accept_lists)
        if consumer_reject_lists is not None:
            pulumi.set(__self__, "consumer_reject_lists", consumer_reject_lists)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_subnets is not None:
            pulumi.set(__self__, "nat_subnets", nat_subnets)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if propagated_connection_limit is not None:
            pulumi.set(__self__, "propagated_connection_limit", propagated_connection_limit)
        if reconcile_connections is not None:
            pulumi.set(__self__, "reconcile_connections", reconcile_connections)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if send_propagated_connection_limit_if_zero is not None:
            pulumi.set(__self__, "send_propagated_connection_limit_if_zero", send_propagated_connection_limit_if_zero)
        if target_service is not None:
            pulumi.set(__self__, "target_service", target_service)

    @property
    @pulumi.getter(name="connectedEndpoints")
    def connected_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]]:
        """
        An array of the consumer forwarding rules connected to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoints")

    @connected_endpoints.setter
    def connected_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConnectedEndpointArgs']]]]):
        pulumi.set(self, "connected_endpoints", value)

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @connection_preference.setter
    def connection_preference(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_preference", value)

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @consumer_accept_lists.setter
    def consumer_accept_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceAttachmentConsumerAcceptListArgs']]]]):
        pulumi.set(self, "consumer_accept_lists", value)

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @consumer_reject_lists.setter
    def consumer_reject_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "consumer_reject_lists", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @domain_names.setter
    def domain_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "domain_names", value)

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @nat_subnets.setter
    def nat_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nat_subnets", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="propagatedConnectionLimit")
    def propagated_connection_limit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
        This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
        If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
        If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
        If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        """
        return pulumi.get(self, "propagated_connection_limit")

    @propagated_connection_limit.setter
    def propagated_connection_limit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "propagated_connection_limit", value)

    @property
    @pulumi.getter(name="reconcileConnections")
    def reconcile_connections(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
        If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
        If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        """
        return pulumi.get(self, "reconcile_connections")

    @reconcile_connections.setter
    def reconcile_connections(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconcile_connections", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sendPropagatedConnectionLimitIfZero")
    def send_propagated_connection_limit_if_zero(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Controls the behavior of propagated_connection_limit.
        When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
        When true, the provider will set propagated_connection_limit to zero.
        Defaults to false.
        """
        return pulumi.get(self, "send_propagated_connection_limit_if_zero")

    @send_propagated_connection_limit_if_zero.setter
    def send_propagated_connection_limit_if_zero(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "send_propagated_connection_limit_if_zero", value)

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The URL of a service serving the endpoint identified by this service attachment.
        """
        return pulumi.get(self, "target_service")

    @target_service.setter
    def target_service(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_service", value)


@pulumi.type_token("gcp:compute/serviceAttachment:ServiceAttachment")
class ServiceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConsumerAcceptListArgs', 'ServiceAttachmentConsumerAcceptListArgsDict']]]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 reconcile_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_propagated_connection_limit_if_zero: Optional[pulumi.Input[builtins.bool]] = None,
                 target_service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a ServiceAttachment resource.

        To get more information about ServiceAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/serviceAttachments)
        * How-to Guides
            * [Configuring Private Service Connect to access services](https://cloud.google.com/vpc/docs/configure-private-service-connect-services)

        ## Example Usage

        ### Service Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id)
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork="default",
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network="default",
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Explicit Projects

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_reject_lists=[
                "673497134629",
                "482878270665",
            ],
            consumer_accept_lists=[{
                "project_id_or_num": "658859330310",
                "connection_limit": 4,
            }])
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork="default",
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network="default",
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Explicit Networks

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc_ilb_consumer_network = gcp.compute.Network("psc_ilb_consumer_network",
            name="psc-ilb-consumer-network",
            auto_create_subnetworks=False)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=False,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_accept_lists=[{
                "network_url": psc_ilb_consumer_network.self_link,
                "connection_limit": 1,
            }])
        psc_ilb_consumer_subnetwork = gcp.compute.Subnetwork("psc_ilb_consumer_subnetwork",
            name="psc-ilb-consumer-network",
            ip_cidr_range="10.0.0.0/16",
            region="us-west2",
            network=psc_ilb_consumer_network.id)
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork=psc_ilb_consumer_subnetwork.id,
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network=psc_ilb_consumer_network.id,
            subnetwork=psc_ilb_consumer_subnetwork.id,
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Reconcile Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_reject_lists=[
                "673497134629",
                "482878270665",
            ],
            consumer_accept_lists=[{
                "project_id_or_num": "658859330310",
                "connection_limit": 4,
            }],
            reconcile_connections=False)
        ```

        ## Import

        ServiceAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ServiceAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConsumerAcceptListArgs', 'ServiceAttachmentConsumerAcceptListArgsDict']]]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[builtins.bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] propagated_connection_limit: The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
               This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
               If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
               If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
               If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        :param pulumi.Input[builtins.bool] reconcile_connections: This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
               If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
               If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        :param pulumi.Input[builtins.str] region: URL of the region where the resource resides.
        :param pulumi.Input[builtins.bool] send_propagated_connection_limit_if_zero: Controls the behavior of propagated_connection_limit.
               When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
               When true, the provider will set propagated_connection_limit to zero.
               Defaults to false.
        :param pulumi.Input[builtins.str] target_service: The URL of a service serving the endpoint identified by this service attachment.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a ServiceAttachment resource.

        To get more information about ServiceAttachment, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/beta/serviceAttachments)
        * How-to Guides
            * [Configuring Private Service Connect to access services](https://cloud.google.com/vpc/docs/configure-private-service-connect-services)

        ## Example Usage

        ### Service Attachment Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_AUTOMATIC",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id)
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork="default",
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network="default",
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Explicit Projects

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_reject_lists=[
                "673497134629",
                "482878270665",
            ],
            consumer_accept_lists=[{
                "project_id_or_num": "658859330310",
                "connection_limit": 4,
            }])
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork="default",
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network="default",
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Explicit Networks

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc_ilb_consumer_network = gcp.compute.Network("psc_ilb_consumer_network",
            name="psc-ilb-consumer-network",
            auto_create_subnetworks=False)
        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            enable_proxy_protocol=False,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_accept_lists=[{
                "network_url": psc_ilb_consumer_network.self_link,
                "connection_limit": 1,
            }])
        psc_ilb_consumer_subnetwork = gcp.compute.Subnetwork("psc_ilb_consumer_subnetwork",
            name="psc-ilb-consumer-network",
            ip_cidr_range="10.0.0.0/16",
            region="us-west2",
            network=psc_ilb_consumer_network.id)
        psc_ilb_consumer_address = gcp.compute.Address("psc_ilb_consumer_address",
            name="psc-ilb-consumer-address",
            region="us-west2",
            subnetwork=psc_ilb_consumer_subnetwork.id,
            address_type="INTERNAL")
        psc_ilb_consumer = gcp.compute.ForwardingRule("psc_ilb_consumer",
            name="psc-ilb-consumer-forwarding-rule",
            region="us-west2",
            target=psc_ilb_service_attachment.id,
            load_balancing_scheme="",
            network=psc_ilb_consumer_network.id,
            subnetwork=psc_ilb_consumer_subnetwork.id,
            ip_address=psc_ilb_consumer_address.id)
        ```
        ### Service Attachment Reconcile Connections

        ```python
        import pulumi
        import pulumi_gcp as gcp

        producer_service_health_check = gcp.compute.HealthCheck("producer_service_health_check",
            name="producer-service-health-check",
            check_interval_sec=1,
            timeout_sec=1,
            tcp_health_check={
                "port": 80,
            })
        producer_service_backend = gcp.compute.RegionBackendService("producer_service_backend",
            name="producer-service",
            region="us-west2",
            health_checks=producer_service_health_check.id)
        psc_ilb_network = gcp.compute.Network("psc_ilb_network",
            name="psc-ilb-network",
            auto_create_subnetworks=False)
        psc_ilb_producer_subnetwork = gcp.compute.Subnetwork("psc_ilb_producer_subnetwork",
            name="psc-ilb-producer-subnetwork",
            region="us-west2",
            network=psc_ilb_network.id,
            ip_cidr_range="10.0.0.0/16")
        psc_ilb_target_service = gcp.compute.ForwardingRule("psc_ilb_target_service",
            name="producer-forwarding-rule",
            region="us-west2",
            load_balancing_scheme="INTERNAL",
            backend_service=producer_service_backend.id,
            all_ports=True,
            network=psc_ilb_network.name,
            subnetwork=psc_ilb_producer_subnetwork.name)
        psc_ilb_nat = gcp.compute.Subnetwork("psc_ilb_nat",
            name="psc-ilb-nat",
            region="us-west2",
            network=psc_ilb_network.id,
            purpose="PRIVATE_SERVICE_CONNECT",
            ip_cidr_range="10.1.0.0/16")
        psc_ilb_service_attachment = gcp.compute.ServiceAttachment("psc_ilb_service_attachment",
            name="my-psc-ilb",
            region="us-west2",
            description="A service attachment configured with Terraform",
            domain_names=["gcp.tfacc.hashicorptest.com."],
            enable_proxy_protocol=True,
            connection_preference="ACCEPT_MANUAL",
            nat_subnets=[psc_ilb_nat.id],
            target_service=psc_ilb_target_service.id,
            consumer_reject_lists=[
                "673497134629",
                "482878270665",
            ],
            consumer_accept_lists=[{
                "project_id_or_num": "658859330310",
                "connection_limit": 4,
            }],
            reconcile_connections=False)
        ```

        ## Import

        ServiceAttachment can be imported using any of these accepted formats:

        * `projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, ServiceAttachment can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default projects/{{project}}/regions/{{region}}/serviceAttachments/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:compute/serviceAttachment:ServiceAttachment default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_preference: Optional[pulumi.Input[builtins.str]] = None,
                 consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConsumerAcceptListArgs', 'ServiceAttachmentConsumerAcceptListArgsDict']]]]] = None,
                 consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[builtins.bool]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 propagated_connection_limit: Optional[pulumi.Input[builtins.int]] = None,
                 reconcile_connections: Optional[pulumi.Input[builtins.bool]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 send_propagated_connection_limit_if_zero: Optional[pulumi.Input[builtins.bool]] = None,
                 target_service: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAttachmentArgs.__new__(ServiceAttachmentArgs)

            if connection_preference is None and not opts.urn:
                raise TypeError("Missing required property 'connection_preference'")
            __props__.__dict__["connection_preference"] = connection_preference
            __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
            __props__.__dict__["consumer_reject_lists"] = consumer_reject_lists
            __props__.__dict__["description"] = description
            __props__.__dict__["domain_names"] = domain_names
            if enable_proxy_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'enable_proxy_protocol'")
            __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
            __props__.__dict__["name"] = name
            if nat_subnets is None and not opts.urn:
                raise TypeError("Missing required property 'nat_subnets'")
            __props__.__dict__["nat_subnets"] = nat_subnets
            __props__.__dict__["project"] = project
            __props__.__dict__["propagated_connection_limit"] = propagated_connection_limit
            __props__.__dict__["reconcile_connections"] = reconcile_connections
            __props__.__dict__["region"] = region
            __props__.__dict__["send_propagated_connection_limit_if_zero"] = send_propagated_connection_limit_if_zero
            if target_service is None and not opts.urn:
                raise TypeError("Missing required property 'target_service'")
            __props__.__dict__["target_service"] = target_service
            __props__.__dict__["connected_endpoints"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["self_link"] = None
        super(ServiceAttachment, __self__).__init__(
            'gcp:compute/serviceAttachment:ServiceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connected_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConnectedEndpointArgs', 'ServiceAttachmentConnectedEndpointArgsDict']]]]] = None,
            connection_preference: Optional[pulumi.Input[builtins.str]] = None,
            consumer_accept_lists: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConsumerAcceptListArgs', 'ServiceAttachmentConsumerAcceptListArgsDict']]]]] = None,
            consumer_reject_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            domain_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            enable_proxy_protocol: Optional[pulumi.Input[builtins.bool]] = None,
            fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            nat_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            propagated_connection_limit: Optional[pulumi.Input[builtins.int]] = None,
            reconcile_connections: Optional[pulumi.Input[builtins.bool]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            self_link: Optional[pulumi.Input[builtins.str]] = None,
            send_propagated_connection_limit_if_zero: Optional[pulumi.Input[builtins.bool]] = None,
            target_service: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceAttachment':
        """
        Get an existing ServiceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConnectedEndpointArgs', 'ServiceAttachmentConnectedEndpointArgsDict']]]] connected_endpoints: An array of the consumer forwarding rules connected to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_preference: The connection preference to use for this service attachment. Valid
               values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        :param pulumi.Input[Sequence[pulumi.Input[Union['ServiceAttachmentConsumerAcceptListArgs', 'ServiceAttachmentConsumerAcceptListArgsDict']]]] consumer_accept_lists: An array of projects that are allowed to connect to this service
               attachment.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] consumer_reject_lists: An array of projects that are not allowed to connect to this service
               attachment.
        :param pulumi.Input[builtins.str] description: An optional description of this resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] domain_names: If specified, the domain name will be used during the integration between
               the PSC connected endpoints and the Cloud DNS. For example, this is a
               valid domain name: "p.mycompany.com.". Current max number of domain names
               supported is 1.
        :param pulumi.Input[builtins.bool] enable_proxy_protocol: If true, enable the proxy protocol which is for supplying client TCP/IP
               address data in TCP connections that traverse proxies on their way to
               destination servers.
        :param pulumi.Input[builtins.str] fingerprint: Fingerprint of this resource. This field is used internally during
               updates of this resource.
        :param pulumi.Input[builtins.str] name: Name of the resource. The name must be 1-63 characters long, and
               comply with RFC1035. Specifically, the name must be 1-63 characters
               long and match the regular expression `a-z?`
               which means the first character must be a lowercase letter, and all
               following characters must be a dash, lowercase letter, or digit,
               except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nat_subnets: An array of subnets that is provided for NAT in this service attachment.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.int] propagated_connection_limit: The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
               This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
               If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
               If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
               If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        :param pulumi.Input[builtins.bool] reconcile_connections: This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
               If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
               If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        :param pulumi.Input[builtins.str] region: URL of the region where the resource resides.
        :param pulumi.Input[builtins.str] self_link: The URI of the created resource.
        :param pulumi.Input[builtins.bool] send_propagated_connection_limit_if_zero: Controls the behavior of propagated_connection_limit.
               When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
               When true, the provider will set propagated_connection_limit to zero.
               Defaults to false.
        :param pulumi.Input[builtins.str] target_service: The URL of a service serving the endpoint identified by this service attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAttachmentState.__new__(_ServiceAttachmentState)

        __props__.__dict__["connected_endpoints"] = connected_endpoints
        __props__.__dict__["connection_preference"] = connection_preference
        __props__.__dict__["consumer_accept_lists"] = consumer_accept_lists
        __props__.__dict__["consumer_reject_lists"] = consumer_reject_lists
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_names"] = domain_names
        __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_subnets"] = nat_subnets
        __props__.__dict__["project"] = project
        __props__.__dict__["propagated_connection_limit"] = propagated_connection_limit
        __props__.__dict__["reconcile_connections"] = reconcile_connections
        __props__.__dict__["region"] = region
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["send_propagated_connection_limit_if_zero"] = send_propagated_connection_limit_if_zero
        __props__.__dict__["target_service"] = target_service
        return ServiceAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectedEndpoints")
    def connected_endpoints(self) -> pulumi.Output[Sequence['outputs.ServiceAttachmentConnectedEndpoint']]:
        """
        An array of the consumer forwarding rules connected to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "connected_endpoints")

    @property
    @pulumi.getter(name="connectionPreference")
    def connection_preference(self) -> pulumi.Output[builtins.str]:
        """
        The connection preference to use for this service attachment. Valid
        values include "ACCEPT_AUTOMATIC", "ACCEPT_MANUAL".
        """
        return pulumi.get(self, "connection_preference")

    @property
    @pulumi.getter(name="consumerAcceptLists")
    def consumer_accept_lists(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceAttachmentConsumerAcceptList']]]:
        """
        An array of projects that are allowed to connect to this service
        attachment.
        Structure is documented below.
        """
        return pulumi.get(self, "consumer_accept_lists")

    @property
    @pulumi.getter(name="consumerRejectLists")
    def consumer_reject_lists(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        An array of projects that are not allowed to connect to this service
        attachment.
        """
        return pulumi.get(self, "consumer_reject_lists")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        If specified, the domain name will be used during the integration between
        the PSC connected endpoints and the Cloud DNS. For example, this is a
        valid domain name: "p.mycompany.com.". Current max number of domain names
        supported is 1.
        """
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Output[builtins.bool]:
        """
        If true, enable the proxy protocol which is for supplying client TCP/IP
        address data in TCP connections that traverse proxies on their way to
        destination servers.
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of this resource. This field is used internally during
        updates of this resource.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the resource. The name must be 1-63 characters long, and
        comply with RFC1035. Specifically, the name must be 1-63 characters
        long and match the regular expression `a-z?`
        which means the first character must be a lowercase letter, and all
        following characters must be a dash, lowercase letter, or digit,
        except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="natSubnets")
    def nat_subnets(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        An array of subnets that is provided for NAT in this service attachment.
        """
        return pulumi.get(self, "nat_subnets")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="propagatedConnectionLimit")
    def propagated_connection_limit(self) -> pulumi.Output[builtins.int]:
        """
        The number of consumer spokes that connected Private Service Connect endpoints can be propagated to through Network Connectivity Center.
        This limit lets the service producer limit how many propagated Private Service Connect connections can be established to this service attachment from a single consumer.
        If the connection preference of the service attachment is ACCEPT_MANUAL, the limit applies to each project or network that is listed in the consumer accept list.
        If the connection preference of the service attachment is ACCEPT_AUTOMATIC, the limit applies to each project that contains a connected endpoint.
        If unspecified, the default propagated connection limit is 250. To explicitly send a zero value, set `send_propagated_connection_limit_if_zero = true`.
        """
        return pulumi.get(self, "propagated_connection_limit")

    @property
    @pulumi.getter(name="reconcileConnections")
    def reconcile_connections(self) -> pulumi.Output[builtins.bool]:
        """
        This flag determines whether a consumer accept/reject list change can reconcile the statuses of existing ACCEPTED or REJECTED PSC endpoints.
        If false, connection policy update will only affect existing PENDING PSC endpoints. Existing ACCEPTED/REJECTED endpoints will remain untouched regardless how the connection policy is modified .
        If true, update will affect both PENDING and ACCEPTED/REJECTED PSC endpoints. For example, an ACCEPTED PSC endpoint will be moved to REJECTED if its project is added to the reject list.
        """
        return pulumi.get(self, "reconcile_connections")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        URL of the region where the resource resides.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[builtins.str]:
        """
        The URI of the created resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sendPropagatedConnectionLimitIfZero")
    def send_propagated_connection_limit_if_zero(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Controls the behavior of propagated_connection_limit.
        When false, setting propagated_connection_limit to zero causes the provider to use to the API's default value.
        When true, the provider will set propagated_connection_limit to zero.
        Defaults to false.
        """
        return pulumi.get(self, "send_propagated_connection_limit_if_zero")

    @property
    @pulumi.getter(name="targetService")
    def target_service(self) -> pulumi.Output[builtins.str]:
        """
        The URL of a service serving the endpoint identified by this service attachment.
        """
        return pulumi.get(self, "target_service")

