# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SnapshotSettingsArgs', 'SnapshotSettings']

@pulumi.input_type
class SnapshotSettingsArgs:
    def __init__(__self__, *,
                 storage_location: pulumi.Input['SnapshotSettingsStorageLocationArgs'],
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a SnapshotSettings resource.
        :param pulumi.Input['SnapshotSettingsStorageLocationArgs'] storage_location: Policy of which storage location is going to be resolved, and additional data
               that particularizes how the policy is going to be carried out
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "storage_location", storage_location)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Input['SnapshotSettingsStorageLocationArgs']:
        """
        Policy of which storage location is going to be resolved, and additional data
        that particularizes how the policy is going to be carried out
        Structure is documented below.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: pulumi.Input['SnapshotSettingsStorageLocationArgs']):
        pulumi.set(self, "storage_location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _SnapshotSettingsState:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input['SnapshotSettingsStorageLocationArgs']] = None):
        """
        Input properties used for looking up and filtering SnapshotSettings resources.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SnapshotSettingsStorageLocationArgs'] storage_location: Policy of which storage location is going to be resolved, and additional data
               that particularizes how the policy is going to be carried out
               Structure is documented below.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input['SnapshotSettingsStorageLocationArgs']]:
        """
        Policy of which storage location is going to be resolved, and additional data
        that particularizes how the policy is going to be carried out
        Structure is documented below.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input['SnapshotSettingsStorageLocationArgs']]):
        pulumi.set(self, "storage_location", value)


@pulumi.type_token("gcp:compute/snapshotSettings:SnapshotSettings")
class SnapshotSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[Union['SnapshotSettingsStorageLocationArgs', 'SnapshotSettingsStorageLocationArgsDict']]] = None,
                 __props__=None):
        """
        Updates your project's snapshot settings and sets a new default storage location for snapshots.

        To get more information about SnapshotSettings, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/snapshotSettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/disks/snapshot-settings#snapshot_settings_how_to_update)

        ## Example Usage

        ### Snapshot Settings Specific Locations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_snapshot_settings = gcp.compute.SnapshotSettings("tf-test-snapshot-settings", storage_location={
            "policy": "SPECIFIC_LOCATIONS",
            "locations": [{
                "name": "us-central1",
                "location": "us-central1",
            }],
        })
        ```

        ## Import

        SnapshotSettings can be imported using any of these accepted formats:

        * `projects/{{project}}/global/snapshotSettings/`

        * `{{project}}`

        When using the `pulumi import` command, SnapshotSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/snapshotSettings:SnapshotSettings default projects/{{project}}/global/snapshotSettings/
        ```

        ```sh
        $ pulumi import gcp:compute/snapshotSettings:SnapshotSettings default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SnapshotSettingsStorageLocationArgs', 'SnapshotSettingsStorageLocationArgsDict']] storage_location: Policy of which storage location is going to be resolved, and additional data
               that particularizes how the policy is going to be carried out
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SnapshotSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Updates your project's snapshot settings and sets a new default storage location for snapshots.

        To get more information about SnapshotSettings, see:

        * [API documentation](https://cloud.google.com/compute/docs/reference/rest/v1/snapshotSettings)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/compute/docs/disks/snapshot-settings#snapshot_settings_how_to_update)

        ## Example Usage

        ### Snapshot Settings Specific Locations

        ```python
        import pulumi
        import pulumi_gcp as gcp

        tf_test_snapshot_settings = gcp.compute.SnapshotSettings("tf-test-snapshot-settings", storage_location={
            "policy": "SPECIFIC_LOCATIONS",
            "locations": [{
                "name": "us-central1",
                "location": "us-central1",
            }],
        })
        ```

        ## Import

        SnapshotSettings can be imported using any of these accepted formats:

        * `projects/{{project}}/global/snapshotSettings/`

        * `{{project}}`

        When using the `pulumi import` command, SnapshotSettings can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:compute/snapshotSettings:SnapshotSettings default projects/{{project}}/global/snapshotSettings/
        ```

        ```sh
        $ pulumi import gcp:compute/snapshotSettings:SnapshotSettings default {{project}}
        ```

        :param str resource_name: The name of the resource.
        :param SnapshotSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SnapshotSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[Union['SnapshotSettingsStorageLocationArgs', 'SnapshotSettingsStorageLocationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SnapshotSettingsArgs.__new__(SnapshotSettingsArgs)

            __props__.__dict__["project"] = project
            if storage_location is None and not opts.urn:
                raise TypeError("Missing required property 'storage_location'")
            __props__.__dict__["storage_location"] = storage_location
        super(SnapshotSettings, __self__).__init__(
            'gcp:compute/snapshotSettings:SnapshotSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            storage_location: Optional[pulumi.Input[Union['SnapshotSettingsStorageLocationArgs', 'SnapshotSettingsStorageLocationArgsDict']]] = None) -> 'SnapshotSettings':
        """
        Get an existing SnapshotSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SnapshotSettingsStorageLocationArgs', 'SnapshotSettingsStorageLocationArgsDict']] storage_location: Policy of which storage location is going to be resolved, and additional data
               that particularizes how the policy is going to be carried out
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SnapshotSettingsState.__new__(_SnapshotSettingsState)

        __props__.__dict__["project"] = project
        __props__.__dict__["storage_location"] = storage_location
        return SnapshotSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output['outputs.SnapshotSettingsStorageLocation']:
        """
        Policy of which storage location is going to be resolved, and additional data
        that particularizes how the policy is going to be carried out
        Structure is documented below.
        """
        return pulumi.get(self, "storage_location")

