# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalysisRuleArgs', 'AnalysisRule']

@pulumi.input_type
class AnalysisRuleArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[builtins.str],
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 analysis_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 annotator_selector: Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']] = None,
                 conversation_filter: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AnalysisRule resource.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.bool] active: If true, apply this rule to conversations. Otherwise, this rule is
               inactive and saved as a draft.
        :param pulumi.Input[builtins.float] analysis_percentage: Percentage of conversations that we should apply this analysis setting
               automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
               are sampled in a determenestic way. The original runtime_percentage &
               upload percentage will be replaced by defining filters on the conversation.
        :param pulumi.Input['AnalysisRuleAnnotatorSelectorArgs'] annotator_selector: Selector of all available annotators and phrase matchers to run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] conversation_filter: Filter for the conversations that should apply this analysis
               rule. An empty filter means this analysis rule applies to all
               conversations.
               Refer to https://cloud.google.com/contact-center/insights/docs/filtering
               for details.
        :param pulumi.Input[builtins.str] display_name: Display Name of the analysis rule.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "location", location)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if analysis_percentage is not None:
            pulumi.set(__self__, "analysis_percentage", analysis_percentage)
        if annotator_selector is not None:
            pulumi.set(__self__, "annotator_selector", annotator_selector)
        if conversation_filter is not None:
            pulumi.set(__self__, "conversation_filter", conversation_filter)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, apply this rule to conversations. Otherwise, this rule is
        inactive and saved as a draft.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="analysisPercentage")
    def analysis_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Percentage of conversations that we should apply this analysis setting
        automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
        are sampled in a determenestic way. The original runtime_percentage &
        upload percentage will be replaced by defining filters on the conversation.
        """
        return pulumi.get(self, "analysis_percentage")

    @analysis_percentage.setter
    def analysis_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "analysis_percentage", value)

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']]:
        """
        Selector of all available annotators and phrase matchers to run.
        Structure is documented below.
        """
        return pulumi.get(self, "annotator_selector")

    @annotator_selector.setter
    def annotator_selector(self, value: Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']]):
        pulumi.set(self, "annotator_selector", value)

    @property
    @pulumi.getter(name="conversationFilter")
    def conversation_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Filter for the conversations that should apply this analysis
        rule. An empty filter means this analysis rule applies to all
        conversations.
        Refer to https://cloud.google.com/contact-center/insights/docs/filtering
        for details.
        """
        return pulumi.get(self, "conversation_filter")

    @conversation_filter.setter
    def conversation_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conversation_filter", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display Name of the analysis rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AnalysisRuleState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 analysis_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 annotator_selector: Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']] = None,
                 conversation_filter: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AnalysisRule resources.
        :param pulumi.Input[builtins.bool] active: If true, apply this rule to conversations. Otherwise, this rule is
               inactive and saved as a draft.
        :param pulumi.Input[builtins.float] analysis_percentage: Percentage of conversations that we should apply this analysis setting
               automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
               are sampled in a determenestic way. The original runtime_percentage &
               upload percentage will be replaced by defining filters on the conversation.
        :param pulumi.Input['AnalysisRuleAnnotatorSelectorArgs'] annotator_selector: Selector of all available annotators and phrase matchers to run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] conversation_filter: Filter for the conversations that should apply this analysis
               rule. An empty filter means this analysis rule applies to all
               conversations.
               Refer to https://cloud.google.com/contact-center/insights/docs/filtering
               for details.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this analysis rule was created.
        :param pulumi.Input[builtins.str] display_name: Display Name of the analysis rule.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the analysis rule. Randomly generated by Insights.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The most recent time at which this analysis rule was updated.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if analysis_percentage is not None:
            pulumi.set(__self__, "analysis_percentage", analysis_percentage)
        if annotator_selector is not None:
            pulumi.set(__self__, "annotator_selector", annotator_selector)
        if conversation_filter is not None:
            pulumi.set(__self__, "conversation_filter", conversation_filter)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, apply this rule to conversations. Otherwise, this rule is
        inactive and saved as a draft.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="analysisPercentage")
    def analysis_percentage(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Percentage of conversations that we should apply this analysis setting
        automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
        are sampled in a determenestic way. The original runtime_percentage &
        upload percentage will be replaced by defining filters on the conversation.
        """
        return pulumi.get(self, "analysis_percentage")

    @analysis_percentage.setter
    def analysis_percentage(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "analysis_percentage", value)

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']]:
        """
        Selector of all available annotators and phrase matchers to run.
        Structure is documented below.
        """
        return pulumi.get(self, "annotator_selector")

    @annotator_selector.setter
    def annotator_selector(self, value: Optional[pulumi.Input['AnalysisRuleAnnotatorSelectorArgs']]):
        pulumi.set(self, "annotator_selector", value)

    @property
    @pulumi.getter(name="conversationFilter")
    def conversation_filter(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Filter for the conversations that should apply this analysis
        rule. An empty filter means this analysis rule applies to all
        conversations.
        Refer to https://cloud.google.com/contact-center/insights/docs/filtering
        for details.
        """
        return pulumi.get(self, "conversation_filter")

    @conversation_filter.setter
    def conversation_filter(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "conversation_filter", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this analysis rule was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display Name of the analysis rule.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the analysis rule. Randomly generated by Insights.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The most recent time at which this analysis rule was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:contactcenterinsights/analysisRule:AnalysisRule")
class AnalysisRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 analysis_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 annotator_selector: Optional[pulumi.Input[Union['AnalysisRuleAnnotatorSelectorArgs', 'AnalysisRuleAnnotatorSelectorArgsDict']]] = None,
                 conversation_filter: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        The CCAI Insights project wide analysis rule.
        This rule will be applied to all conversations that match the filter defined in the rule.
        For a conversation matches the filter, the annotators specified in the rule will be run.
        If a conversation matches multiple rules, a union of all the annotators will be run.
        One project can have multiple analysis rules.

        To get more information about AnalysisRule, see:

        * [API documentation](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations.analysisRules)
        * How-to Guides
            * [Configure analysis rules using the API](https://cloud.google.com/contact-center/insights/docs/analysis-rule)

        ## Example Usage

        ### Contact Center Insights Analysis Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_basic = gcp.contactcenterinsights.AnalysisRule("analysis_rule_basic",
            location="us-central1",
            display_name="analysis-rule-display-name")
        ```
        ### Contact Center Insights Analysis Rule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_full = gcp.contactcenterinsights.AnalysisRule("analysis_rule_full",
            location="us-central1",
            display_name="analysis-rule-display-name",
            conversation_filter="agent_id = \\"1\\"",
            annotator_selector={
                "run_interruption_annotator": False,
                "issue_models": ["projects/1111111111111/locations/us-central1/issueModels/some_issue_model_id"],
                "phrase_matchers": ["projects/1111111111111/locations/us-central1/phraseMatchers/123"],
                "qa_config": {
                    "scorecard_list": {
                        "qa_scorecard_revisions": ["projects/1111111111111/locations/us-central1/qaScorecards/*/revisions/some_scorecard_revision_id"],
                    },
                },
                "run_entity_annotator": False,
                "run_intent_annotator": False,
                "run_issue_model_annotator": False,
                "run_phrase_matcher_annotator": False,
                "run_qa_annotator": False,
                "run_sentiment_annotator": False,
                "run_silence_annotator": True,
                "run_summarization_annotator": False,
                "summarization_config": {
                    "summarization_model": "BASELINE_MODEL",
                },
            },
            analysis_percentage=0.5,
            active=True)
        ```
        ### Contact Center Insights Analysis Rule Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_profile = gcp.contactcenterinsights.AnalysisRule("analysis_rule_profile",
            location="us-central1",
            display_name="analysis-rule-display-name",
            conversation_filter="agent_id = \\"1\\"",
            annotator_selector={
                "run_interruption_annotator": False,
                "issue_models": ["projects/1111111111111/locations/us-central1/issueModels/some_issue_model_id"],
                "phrase_matchers": ["projects/1111111111111/locations/us-central1/phraseMatchers/123"],
                "qa_config": {
                    "scorecard_list": {
                        "qa_scorecard_revisions": ["projects/1111111111111/locations/us-central1/qaScorecards/*/revisions/some_scorecard_revision_id"],
                    },
                },
                "run_entity_annotator": False,
                "run_intent_annotator": False,
                "run_issue_model_annotator": False,
                "run_phrase_matcher_annotator": False,
                "run_qa_annotator": False,
                "run_sentiment_annotator": False,
                "run_silence_annotator": True,
                "run_summarization_annotator": False,
                "summarization_config": {
                    "conversation_profile": "projects/1111111111111/locations/us-central1/conversationProfiles/some_conversation_profile",
                },
            },
            analysis_percentage=0.5,
            active=True)
        ```

        ## Import

        AnalysisRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/analysisRules/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, AnalysisRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default projects/{{project}}/locations/{{location}}/analysisRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: If true, apply this rule to conversations. Otherwise, this rule is
               inactive and saved as a draft.
        :param pulumi.Input[builtins.float] analysis_percentage: Percentage of conversations that we should apply this analysis setting
               automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
               are sampled in a determenestic way. The original runtime_percentage &
               upload percentage will be replaced by defining filters on the conversation.
        :param pulumi.Input[Union['AnalysisRuleAnnotatorSelectorArgs', 'AnalysisRuleAnnotatorSelectorArgsDict']] annotator_selector: Selector of all available annotators and phrase matchers to run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] conversation_filter: Filter for the conversations that should apply this analysis
               rule. An empty filter means this analysis rule applies to all
               conversations.
               Refer to https://cloud.google.com/contact-center/insights/docs/filtering
               for details.
        :param pulumi.Input[builtins.str] display_name: Display Name of the analysis rule.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalysisRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The CCAI Insights project wide analysis rule.
        This rule will be applied to all conversations that match the filter defined in the rule.
        For a conversation matches the filter, the annotators specified in the rule will be run.
        If a conversation matches multiple rules, a union of all the annotators will be run.
        One project can have multiple analysis rules.

        To get more information about AnalysisRule, see:

        * [API documentation](https://cloud.google.com/contact-center/insights/docs/reference/rest/v1/projects.locations.analysisRules)
        * How-to Guides
            * [Configure analysis rules using the API](https://cloud.google.com/contact-center/insights/docs/analysis-rule)

        ## Example Usage

        ### Contact Center Insights Analysis Rule Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_basic = gcp.contactcenterinsights.AnalysisRule("analysis_rule_basic",
            location="us-central1",
            display_name="analysis-rule-display-name")
        ```
        ### Contact Center Insights Analysis Rule Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_full = gcp.contactcenterinsights.AnalysisRule("analysis_rule_full",
            location="us-central1",
            display_name="analysis-rule-display-name",
            conversation_filter="agent_id = \\"1\\"",
            annotator_selector={
                "run_interruption_annotator": False,
                "issue_models": ["projects/1111111111111/locations/us-central1/issueModels/some_issue_model_id"],
                "phrase_matchers": ["projects/1111111111111/locations/us-central1/phraseMatchers/123"],
                "qa_config": {
                    "scorecard_list": {
                        "qa_scorecard_revisions": ["projects/1111111111111/locations/us-central1/qaScorecards/*/revisions/some_scorecard_revision_id"],
                    },
                },
                "run_entity_annotator": False,
                "run_intent_annotator": False,
                "run_issue_model_annotator": False,
                "run_phrase_matcher_annotator": False,
                "run_qa_annotator": False,
                "run_sentiment_annotator": False,
                "run_silence_annotator": True,
                "run_summarization_annotator": False,
                "summarization_config": {
                    "summarization_model": "BASELINE_MODEL",
                },
            },
            analysis_percentage=0.5,
            active=True)
        ```
        ### Contact Center Insights Analysis Rule Profile

        ```python
        import pulumi
        import pulumi_gcp as gcp

        analysis_rule_profile = gcp.contactcenterinsights.AnalysisRule("analysis_rule_profile",
            location="us-central1",
            display_name="analysis-rule-display-name",
            conversation_filter="agent_id = \\"1\\"",
            annotator_selector={
                "run_interruption_annotator": False,
                "issue_models": ["projects/1111111111111/locations/us-central1/issueModels/some_issue_model_id"],
                "phrase_matchers": ["projects/1111111111111/locations/us-central1/phraseMatchers/123"],
                "qa_config": {
                    "scorecard_list": {
                        "qa_scorecard_revisions": ["projects/1111111111111/locations/us-central1/qaScorecards/*/revisions/some_scorecard_revision_id"],
                    },
                },
                "run_entity_annotator": False,
                "run_intent_annotator": False,
                "run_issue_model_annotator": False,
                "run_phrase_matcher_annotator": False,
                "run_qa_annotator": False,
                "run_sentiment_annotator": False,
                "run_silence_annotator": True,
                "run_summarization_annotator": False,
                "summarization_config": {
                    "conversation_profile": "projects/1111111111111/locations/us-central1/conversationProfiles/some_conversation_profile",
                },
            },
            analysis_percentage=0.5,
            active=True)
        ```

        ## Import

        AnalysisRule can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/analysisRules/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, AnalysisRule can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default projects/{{project}}/locations/{{location}}/analysisRules/{{name}}
        ```

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:contactcenterinsights/analysisRule:AnalysisRule default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AnalysisRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalysisRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[builtins.bool]] = None,
                 analysis_percentage: Optional[pulumi.Input[builtins.float]] = None,
                 annotator_selector: Optional[pulumi.Input[Union['AnalysisRuleAnnotatorSelectorArgs', 'AnalysisRuleAnnotatorSelectorArgsDict']]] = None,
                 conversation_filter: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalysisRuleArgs.__new__(AnalysisRuleArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["analysis_percentage"] = analysis_percentage
            __props__.__dict__["annotator_selector"] = annotator_selector
            __props__.__dict__["conversation_filter"] = conversation_filter
            __props__.__dict__["display_name"] = display_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["update_time"] = None
        super(AnalysisRule, __self__).__init__(
            'gcp:contactcenterinsights/analysisRule:AnalysisRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[builtins.bool]] = None,
            analysis_percentage: Optional[pulumi.Input[builtins.float]] = None,
            annotator_selector: Optional[pulumi.Input[Union['AnalysisRuleAnnotatorSelectorArgs', 'AnalysisRuleAnnotatorSelectorArgsDict']]] = None,
            conversation_filter: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'AnalysisRule':
        """
        Get an existing AnalysisRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] active: If true, apply this rule to conversations. Otherwise, this rule is
               inactive and saved as a draft.
        :param pulumi.Input[builtins.float] analysis_percentage: Percentage of conversations that we should apply this analysis setting
               automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
               are sampled in a determenestic way. The original runtime_percentage &
               upload percentage will be replaced by defining filters on the conversation.
        :param pulumi.Input[Union['AnalysisRuleAnnotatorSelectorArgs', 'AnalysisRuleAnnotatorSelectorArgsDict']] annotator_selector: Selector of all available annotators and phrase matchers to run.
               Structure is documented below.
        :param pulumi.Input[builtins.str] conversation_filter: Filter for the conversations that should apply this analysis
               rule. An empty filter means this analysis rule applies to all
               conversations.
               Refer to https://cloud.google.com/contact-center/insights/docs/filtering
               for details.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this analysis rule was created.
        :param pulumi.Input[builtins.str] display_name: Display Name of the analysis rule.
        :param pulumi.Input[builtins.str] location: Location of the resource.
        :param pulumi.Input[builtins.str] name: The resource name of the analysis rule. Randomly generated by Insights.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] update_time: Output only. The most recent time at which this analysis rule was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalysisRuleState.__new__(_AnalysisRuleState)

        __props__.__dict__["active"] = active
        __props__.__dict__["analysis_percentage"] = analysis_percentage
        __props__.__dict__["annotator_selector"] = annotator_selector
        __props__.__dict__["conversation_filter"] = conversation_filter
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["update_time"] = update_time
        return AnalysisRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        If true, apply this rule to conversations. Otherwise, this rule is
        inactive and saved as a draft.
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="analysisPercentage")
    def analysis_percentage(self) -> pulumi.Output[Optional[builtins.float]]:
        """
        Percentage of conversations that we should apply this analysis setting
        automatically, between [0, 1]. For example, 0.1 means 10%. Conversations
        are sampled in a determenestic way. The original runtime_percentage &
        upload percentage will be replaced by defining filters on the conversation.
        """
        return pulumi.get(self, "analysis_percentage")

    @property
    @pulumi.getter(name="annotatorSelector")
    def annotator_selector(self) -> pulumi.Output[Optional['outputs.AnalysisRuleAnnotatorSelector']]:
        """
        Selector of all available annotators and phrase matchers to run.
        Structure is documented below.
        """
        return pulumi.get(self, "annotator_selector")

    @property
    @pulumi.getter(name="conversationFilter")
    def conversation_filter(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Filter for the conversations that should apply this analysis
        rule. An empty filter means this analysis rule applies to all
        conversations.
        Refer to https://cloud.google.com/contact-center/insights/docs/filtering
        for details.
        """
        return pulumi.get(self, "conversation_filter")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this analysis rule was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display Name of the analysis rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        Location of the resource.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the analysis rule. Randomly generated by Insights.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The most recent time at which this analysis rule was updated.
        """
        return pulumi.get(self, "update_time")

