# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AttachedClusterArgs', 'AttachedCluster']

@pulumi.input_type
class AttachedClusterArgs:
    def __init__(__self__, *,
                 distribution: pulumi.Input[builtins.str],
                 fleet: pulumi.Input['AttachedClusterFleetArgs'],
                 location: pulumi.Input[builtins.str],
                 oidc_config: pulumi.Input['AttachedClusterOidcConfigArgs'],
                 platform_version: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input['AttachedClusterAuthorizationArgs']] = None,
                 binary_authorization: Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']] = None,
                 monitoring_config: Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_config: Optional[pulumi.Input['AttachedClusterProxyConfigArgs']] = None,
                 security_posture_config: Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']] = None):
        """
        The set of arguments for constructing a AttachedCluster resource.
        :param pulumi.Input[builtins.str] distribution: The Kubernetes distribution of the underlying attached cluster. Supported values:
               "eks", "aks", "generic". The generic distribution provides the ability to register
               or migrate any CNCF conformant cluster.
        :param pulumi.Input['AttachedClusterFleetArgs'] fleet: Fleet configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AttachedClusterOidcConfigArgs'] oidc_config: OIDC discovery information of the target cluster.
               Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
               API server. This fields indicates how GCP services
               validate KSA tokens in order to allow system workloads (such as GKE Connect
               and telemetry agents) to authenticate back to GCP.
               Both clusters with public and private issuer URLs are supported.
               Clusters with public issuers only need to specify the `issuer_url` field
               while clusters with private issuers need to provide both
               `issuer_url` and `jwks`.
               Structure is documented below.
        :param pulumi.Input[builtins.str] platform_version: The platform version for the cluster (e.g. `1.23.0-gke.1`).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same
               restrictions as Kubernetes annotations. The total size of all keys and
               values combined is limited to 256k. Key can have 2 segments: prefix (optional)
               and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AttachedClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterBinaryAuthorizationArgs'] binary_authorization: Binary Authorization configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        :param pulumi.Input[builtins.str] description: A human readable description of this attached cluster. Cannot be longer
               than 255 UTF-8 encoded bytes.
        :param pulumi.Input['AttachedClusterLoggingConfigArgs'] logging_config: Logging configuration.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterMonitoringConfigArgs'] monitoring_config: Monitoring configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AttachedClusterProxyConfigArgs'] proxy_config: Support for proxy configuration.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterSecurityPostureConfigArgs'] security_posture_config: (Optional, Deprecated)
               Enable/Disable Security Posture API features for the cluster.
               Structure is documented below.
               
               > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "fleet", fleet)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "oidc_config", oidc_config)
        pulumi.set(__self__, "platform_version", platform_version)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if monitoring_config is not None:
            pulumi.set(__self__, "monitoring_config", monitoring_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_config is not None:
            pulumi.set(__self__, "proxy_config", proxy_config)
        if security_posture_config is not None:
            warnings.warn("""`security_posture_config` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""security_posture_config is deprecated: `security_posture_config` is deprecated and will be removed in a future major release.""")
        if security_posture_config is not None:
            pulumi.set(__self__, "security_posture_config", security_posture_config)

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Input[builtins.str]:
        """
        The Kubernetes distribution of the underlying attached cluster. Supported values:
        "eks", "aks", "generic". The generic distribution provides the ability to register
        or migrate any CNCF conformant cluster.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Input['AttachedClusterFleetArgs']:
        """
        Fleet configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: pulumi.Input['AttachedClusterFleetArgs']):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="oidcConfig")
    def oidc_config(self) -> pulumi.Input['AttachedClusterOidcConfigArgs']:
        """
        OIDC discovery information of the target cluster.
        Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
        API server. This fields indicates how GCP services
        validate KSA tokens in order to allow system workloads (such as GKE Connect
        and telemetry agents) to authenticate back to GCP.
        Both clusters with public and private issuer URLs are supported.
        Clusters with public issuers only need to specify the `issuer_url` field
        while clusters with private issuers need to provide both
        `issuer_url` and `jwks`.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_config")

    @oidc_config.setter
    def oidc_config(self, value: pulumi.Input['AttachedClusterOidcConfigArgs']):
        pulumi.set(self, "oidc_config", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Input[builtins.str]:
        """
        The platform version for the cluster (e.g. `1.23.0-gke.1`).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same
        restrictions as Kubernetes annotations. The total size of all keys and
        values combined is limited to 256k. Key can have 2 segments: prefix (optional)
        and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['AttachedClusterAuthorizationArgs']]:
        """
        Configuration related to the cluster RBAC settings.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['AttachedClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']]:
        """
        Binary Authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable description of this attached cluster. Cannot be longer
        than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']]:
        """
        Logging configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="monitoringConfig")
    def monitoring_config(self) -> Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']]:
        """
        Monitoring configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring_config")

    @monitoring_config.setter
    def monitoring_config(self, value: Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']]):
        pulumi.set(self, "monitoring_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="proxyConfig")
    def proxy_config(self) -> Optional[pulumi.Input['AttachedClusterProxyConfigArgs']]:
        """
        Support for proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy_config")

    @proxy_config.setter
    def proxy_config(self, value: Optional[pulumi.Input['AttachedClusterProxyConfigArgs']]):
        pulumi.set(self, "proxy_config", value)

    @property
    @pulumi.getter(name="securityPostureConfig")
    @_utilities.deprecated("""`security_posture_config` is deprecated and will be removed in a future major release.""")
    def security_posture_config(self) -> Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']]:
        """
        (Optional, Deprecated)
        Enable/Disable Security Posture API features for the cluster.
        Structure is documented below.

        > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "security_posture_config")

    @security_posture_config.setter
    def security_posture_config(self, value: Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']]):
        pulumi.set(self, "security_posture_config", value)


@pulumi.input_type
class _AttachedClusterState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input['AttachedClusterAuthorizationArgs']] = None,
                 binary_authorization: Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']] = None,
                 cluster_region: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distribution: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterErrorArgs']]]] = None,
                 fleet: Optional[pulumi.Input['AttachedClusterFleetArgs']] = None,
                 kubernetes_version: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']] = None,
                 monitoring_config: Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_config: Optional[pulumi.Input['AttachedClusterOidcConfigArgs']] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_config: Optional[pulumi.Input['AttachedClusterProxyConfigArgs']] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 security_posture_config: Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterWorkloadIdentityConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering AttachedCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same
               restrictions as Kubernetes annotations. The total size of all keys and
               values combined is limited to 256k. Key can have 2 segments: prefix (optional)
               and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AttachedClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterBinaryAuthorizationArgs'] binary_authorization: Binary Authorization configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_region: Output only. The region where this cluster runs.
               For EKS clusters, this is an AWS region. For AKS clusters,
               this is an Azure region.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        :param pulumi.Input[builtins.str] description: A human readable description of this attached cluster. Cannot be longer
               than 255 UTF-8 encoded bytes.
        :param pulumi.Input[builtins.str] distribution: The Kubernetes distribution of the underlying attached cluster. Supported values:
               "eks", "aks", "generic". The generic distribution provides the ability to register
               or migrate any CNCF conformant cluster.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedClusterErrorArgs']]] errors: A set of errors found in the cluster.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterFleetArgs'] fleet: Fleet configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kubernetes_version: The Kubernetes version of the cluster.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AttachedClusterLoggingConfigArgs'] logging_config: Logging configuration.
               Structure is documented below.
        :param pulumi.Input['AttachedClusterMonitoringConfigArgs'] monitoring_config: Monitoring configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input['AttachedClusterOidcConfigArgs'] oidc_config: OIDC discovery information of the target cluster.
               Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
               API server. This fields indicates how GCP services
               validate KSA tokens in order to allow system workloads (such as GKE Connect
               and telemetry agents) to authenticate back to GCP.
               Both clusters with public and private issuer URLs are supported.
               Clusters with public issuers only need to specify the `issuer_url` field
               while clusters with private issuers need to provide both
               `issuer_url` and `jwks`.
               Structure is documented below.
        :param pulumi.Input[builtins.str] platform_version: The platform version for the cluster (e.g. `1.23.0-gke.1`).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['AttachedClusterProxyConfigArgs'] proxy_config: Support for proxy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] reconciling: If set, there are currently changes in flight to the cluster.
        :param pulumi.Input['AttachedClusterSecurityPostureConfigArgs'] security_posture_config: (Optional, Deprecated)
               Enable/Disable Security Posture API features for the cluster.
               Structure is documented below.
               
               > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] state: The current state of the cluster. Possible values:
               STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR,
               DEGRADED
        :param pulumi.Input[builtins.str] uid: A globally unique identifier for the cluster.
        :param pulumi.Input[builtins.str] update_time: The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['AttachedClusterWorkloadIdentityConfigArgs']]] workload_identity_configs: Workload Identity settings.
               Structure is documented below.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if cluster_region is not None:
            pulumi.set(__self__, "cluster_region", cluster_region)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletion_policy is not None:
            pulumi.set(__self__, "deletion_policy", deletion_policy)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if fleet is not None:
            pulumi.set(__self__, "fleet", fleet)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if monitoring_config is not None:
            pulumi.set(__self__, "monitoring_config", monitoring_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oidc_config is not None:
            pulumi.set(__self__, "oidc_config", oidc_config)
        if platform_version is not None:
            pulumi.set(__self__, "platform_version", platform_version)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proxy_config is not None:
            pulumi.set(__self__, "proxy_config", proxy_config)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if security_posture_config is not None:
            warnings.warn("""`security_posture_config` is deprecated and will be removed in a future major release.""", DeprecationWarning)
            pulumi.log.warn("""security_posture_config is deprecated: `security_posture_config` is deprecated and will be removed in a future major release.""")
        if security_posture_config is not None:
            pulumi.set(__self__, "security_posture_config", security_posture_config)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if workload_identity_configs is not None:
            pulumi.set(__self__, "workload_identity_configs", workload_identity_configs)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same
        restrictions as Kubernetes annotations. The total size of all keys and
        values combined is limited to 256k. Key can have 2 segments: prefix (optional)
        and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['AttachedClusterAuthorizationArgs']]:
        """
        Configuration related to the cluster RBAC settings.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['AttachedClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']]:
        """
        Binary Authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['AttachedClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="clusterRegion")
    def cluster_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The region where this cluster runs.
        For EKS clusters, this is an AWS region. For AKS clusters,
        this is an Azure region.
        """
        return pulumi.get(self, "cluster_region")

    @cluster_region.setter
    def cluster_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_region", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        """
        return pulumi.get(self, "deletion_policy")

    @deletion_policy.setter
    def deletion_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "deletion_policy", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A human readable description of this attached cluster. Cannot be longer
        than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes distribution of the underlying attached cluster. Supported values:
        "eks", "aks", "generic". The generic distribution provides the ability to register
        or migrate any CNCF conformant cluster.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterErrorArgs']]]]:
        """
        A set of errors found in the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def fleet(self) -> Optional[pulumi.Input['AttachedClusterFleetArgs']]:
        """
        Fleet configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: Optional[pulumi.Input['AttachedClusterFleetArgs']]):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes version of the cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']]:
        """
        Logging configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AttachedClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter(name="monitoringConfig")
    def monitoring_config(self) -> Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']]:
        """
        Monitoring configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring_config")

    @monitoring_config.setter
    def monitoring_config(self, value: Optional[pulumi.Input['AttachedClusterMonitoringConfigArgs']]):
        pulumi.set(self, "monitoring_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="oidcConfig")
    def oidc_config(self) -> Optional[pulumi.Input['AttachedClusterOidcConfigArgs']]:
        """
        OIDC discovery information of the target cluster.
        Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
        API server. This fields indicates how GCP services
        validate KSA tokens in order to allow system workloads (such as GKE Connect
        and telemetry agents) to authenticate back to GCP.
        Both clusters with public and private issuer URLs are supported.
        Clusters with public issuers only need to specify the `issuer_url` field
        while clusters with private issuers need to provide both
        `issuer_url` and `jwks`.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_config")

    @oidc_config.setter
    def oidc_config(self, value: Optional[pulumi.Input['AttachedClusterOidcConfigArgs']]):
        pulumi.set(self, "oidc_config", value)

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The platform version for the cluster (e.g. `1.23.0-gke.1`).
        """
        return pulumi.get(self, "platform_version")

    @platform_version.setter
    def platform_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform_version", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="proxyConfig")
    def proxy_config(self) -> Optional[pulumi.Input['AttachedClusterProxyConfigArgs']]:
        """
        Support for proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy_config")

    @proxy_config.setter
    def proxy_config(self, value: Optional[pulumi.Input['AttachedClusterProxyConfigArgs']]):
        pulumi.set(self, "proxy_config", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter(name="securityPostureConfig")
    @_utilities.deprecated("""`security_posture_config` is deprecated and will be removed in a future major release.""")
    def security_posture_config(self) -> Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']]:
        """
        (Optional, Deprecated)
        Enable/Disable Security Posture API features for the cluster.
        Structure is documented below.

        > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "security_posture_config")

    @security_posture_config.setter
    def security_posture_config(self, value: Optional[pulumi.Input['AttachedClusterSecurityPostureConfigArgs']]):
        pulumi.set(self, "security_posture_config", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the cluster. Possible values:
        STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR,
        DEGRADED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterWorkloadIdentityConfigArgs']]]]:
        """
        Workload Identity settings.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_identity_configs")

    @workload_identity_configs.setter
    def workload_identity_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AttachedClusterWorkloadIdentityConfigArgs']]]]):
        pulumi.set(self, "workload_identity_configs", value)


@pulumi.type_token("gcp:container/attachedCluster:AttachedCluster")
class AttachedCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[Union['AttachedClusterAuthorizationArgs', 'AttachedClusterAuthorizationArgsDict']]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['AttachedClusterBinaryAuthorizationArgs', 'AttachedClusterBinaryAuthorizationArgsDict']]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distribution: Optional[pulumi.Input[builtins.str]] = None,
                 fleet: Optional[pulumi.Input[Union['AttachedClusterFleetArgs', 'AttachedClusterFleetArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['AttachedClusterLoggingConfigArgs', 'AttachedClusterLoggingConfigArgsDict']]] = None,
                 monitoring_config: Optional[pulumi.Input[Union['AttachedClusterMonitoringConfigArgs', 'AttachedClusterMonitoringConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_config: Optional[pulumi.Input[Union['AttachedClusterOidcConfigArgs', 'AttachedClusterOidcConfigArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_config: Optional[pulumi.Input[Union['AttachedClusterProxyConfigArgs', 'AttachedClusterProxyConfigArgsDict']]] = None,
                 security_posture_config: Optional[pulumi.Input[Union['AttachedClusterSecurityPostureConfigArgs', 'AttachedClusterSecurityPostureConfigArgsDict']]] = None,
                 __props__=None):
        """
        An Anthos cluster running on customer owned infrastructure.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/anthos/clusters/docs/multi-cloud/reference/rest)
        * How-to Guides
            * [API reference](https://cloud.google.com/anthos/clusters/docs/multi-cloud/reference/rest/v1/projects.locations.attachedClusters)
            * [Multicloud overview](https://cloud.google.com/anthos/clusters/docs/multi-cloud)

        ## Example Usage

        ### Container Attached Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            location="us-west1",
            project=project.project_id,
            description="Test cluster",
            distribution="aks",
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            })
        ```
        ### Container Attached Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            project=project.project_id,
            location="us-west1",
            description="Test cluster",
            distribution="aks",
            annotations={
                "label-one": "value-one",
            },
            authorization={
                "admin_users": [
                    "user1@example.com",
                    "user2@example.com",
                ],
                "admin_groups": [
                    "group1@example.com",
                    "group2@example.com",
                ],
            },
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
                "jwks": std.base64encode(input="{\\"keys\\":[{\\"use\\":\\"sig\\",\\"kty\\":\\"RSA\\",\\"kid\\":\\"testid\\",\\"alg\\":\\"RS256\\",\\"n\\":\\"somedata\\",\\"e\\":\\"AQAB\\"}]}").result,
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            },
            logging_config={
                "component_config": {
                    "enable_components": [
                        "SYSTEM_COMPONENTS",
                        "WORKLOADS",
                    ],
                },
            },
            monitoring_config={
                "managed_prometheus_config": {
                    "enabled": True,
                },
            },
            binary_authorization={
                "evaluation_mode": "PROJECT_SINGLETON_POLICY_ENFORCE",
            },
            proxy_config={
                "kubernetes_secret": {
                    "name": "proxy-config",
                    "namespace": "default",
                },
            })
        ```
        ### Container Attached Cluster Ignore Errors

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            location="us-west1",
            project=project.project_id,
            description="Test cluster",
            distribution="aks",
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            },
            deletion_policy="DELETE_IGNORE_ERRORS")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/attachedClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default projects/{{project}}/locations/{{location}}/attachedClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same
               restrictions as Kubernetes annotations. The total size of all keys and
               values combined is limited to 256k. Key can have 2 segments: prefix (optional)
               and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AttachedClusterAuthorizationArgs', 'AttachedClusterAuthorizationArgsDict']] authorization: Configuration related to the cluster RBAC settings.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterBinaryAuthorizationArgs', 'AttachedClusterBinaryAuthorizationArgsDict']] binary_authorization: Binary Authorization configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        :param pulumi.Input[builtins.str] description: A human readable description of this attached cluster. Cannot be longer
               than 255 UTF-8 encoded bytes.
        :param pulumi.Input[builtins.str] distribution: The Kubernetes distribution of the underlying attached cluster. Supported values:
               "eks", "aks", "generic". The generic distribution provides the ability to register
               or migrate any CNCF conformant cluster.
        :param pulumi.Input[Union['AttachedClusterFleetArgs', 'AttachedClusterFleetArgsDict']] fleet: Fleet configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AttachedClusterLoggingConfigArgs', 'AttachedClusterLoggingConfigArgsDict']] logging_config: Logging configuration.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterMonitoringConfigArgs', 'AttachedClusterMonitoringConfigArgsDict']] monitoring_config: Monitoring configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[Union['AttachedClusterOidcConfigArgs', 'AttachedClusterOidcConfigArgsDict']] oidc_config: OIDC discovery information of the target cluster.
               Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
               API server. This fields indicates how GCP services
               validate KSA tokens in order to allow system workloads (such as GKE Connect
               and telemetry agents) to authenticate back to GCP.
               Both clusters with public and private issuer URLs are supported.
               Clusters with public issuers only need to specify the `issuer_url` field
               while clusters with private issuers need to provide both
               `issuer_url` and `jwks`.
               Structure is documented below.
        :param pulumi.Input[builtins.str] platform_version: The platform version for the cluster (e.g. `1.23.0-gke.1`).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AttachedClusterProxyConfigArgs', 'AttachedClusterProxyConfigArgsDict']] proxy_config: Support for proxy configuration.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterSecurityPostureConfigArgs', 'AttachedClusterSecurityPostureConfigArgsDict']] security_posture_config: (Optional, Deprecated)
               Enable/Disable Security Posture API features for the cluster.
               Structure is documented below.
               
               > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachedClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Anthos cluster running on customer owned infrastructure.

        To get more information about Cluster, see:

        * [API documentation](https://cloud.google.com/anthos/clusters/docs/multi-cloud/reference/rest)
        * How-to Guides
            * [API reference](https://cloud.google.com/anthos/clusters/docs/multi-cloud/reference/rest/v1/projects.locations.attachedClusters)
            * [Multicloud overview](https://cloud.google.com/anthos/clusters/docs/multi-cloud)

        ## Example Usage

        ### Container Attached Cluster Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            location="us-west1",
            project=project.project_id,
            description="Test cluster",
            distribution="aks",
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            })
        ```
        ### Container Attached Cluster Full

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            project=project.project_id,
            location="us-west1",
            description="Test cluster",
            distribution="aks",
            annotations={
                "label-one": "value-one",
            },
            authorization={
                "admin_users": [
                    "user1@example.com",
                    "user2@example.com",
                ],
                "admin_groups": [
                    "group1@example.com",
                    "group2@example.com",
                ],
            },
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
                "jwks": std.base64encode(input="{\\"keys\\":[{\\"use\\":\\"sig\\",\\"kty\\":\\"RSA\\",\\"kid\\":\\"testid\\",\\"alg\\":\\"RS256\\",\\"n\\":\\"somedata\\",\\"e\\":\\"AQAB\\"}]}").result,
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            },
            logging_config={
                "component_config": {
                    "enable_components": [
                        "SYSTEM_COMPONENTS",
                        "WORKLOADS",
                    ],
                },
            },
            monitoring_config={
                "managed_prometheus_config": {
                    "enabled": True,
                },
            },
            binary_authorization={
                "evaluation_mode": "PROJECT_SINGLETON_POLICY_ENFORCE",
            },
            proxy_config={
                "kubernetes_secret": {
                    "name": "proxy-config",
                    "namespace": "default",
                },
            })
        ```
        ### Container Attached Cluster Ignore Errors

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        versions = gcp.container.get_attached_versions(location="us-west1",
            project=project.project_id)
        primary = gcp.container.AttachedCluster("primary",
            name="basic",
            location="us-west1",
            project=project.project_id,
            description="Test cluster",
            distribution="aks",
            oidc_config={
                "issuer_url": "https://oidc.issuer.url",
            },
            platform_version=versions.valid_versions[0],
            fleet={
                "project": f"projects/{project.number}",
            },
            deletion_policy="DELETE_IGNORE_ERRORS")
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/attachedClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default projects/{{project}}/locations/{{location}}/attachedClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/attachedCluster:AttachedCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AttachedClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachedClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[Union['AttachedClusterAuthorizationArgs', 'AttachedClusterAuthorizationArgsDict']]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['AttachedClusterBinaryAuthorizationArgs', 'AttachedClusterBinaryAuthorizationArgsDict']]] = None,
                 deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 distribution: Optional[pulumi.Input[builtins.str]] = None,
                 fleet: Optional[pulumi.Input[Union['AttachedClusterFleetArgs', 'AttachedClusterFleetArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['AttachedClusterLoggingConfigArgs', 'AttachedClusterLoggingConfigArgsDict']]] = None,
                 monitoring_config: Optional[pulumi.Input[Union['AttachedClusterMonitoringConfigArgs', 'AttachedClusterMonitoringConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oidc_config: Optional[pulumi.Input[Union['AttachedClusterOidcConfigArgs', 'AttachedClusterOidcConfigArgsDict']]] = None,
                 platform_version: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 proxy_config: Optional[pulumi.Input[Union['AttachedClusterProxyConfigArgs', 'AttachedClusterProxyConfigArgsDict']]] = None,
                 security_posture_config: Optional[pulumi.Input[Union['AttachedClusterSecurityPostureConfigArgs', 'AttachedClusterSecurityPostureConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachedClusterArgs.__new__(AttachedClusterArgs)

            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["binary_authorization"] = binary_authorization
            __props__.__dict__["deletion_policy"] = deletion_policy
            __props__.__dict__["description"] = description
            if distribution is None and not opts.urn:
                raise TypeError("Missing required property 'distribution'")
            __props__.__dict__["distribution"] = distribution
            if fleet is None and not opts.urn:
                raise TypeError("Missing required property 'fleet'")
            __props__.__dict__["fleet"] = fleet
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["monitoring_config"] = monitoring_config
            __props__.__dict__["name"] = name
            if oidc_config is None and not opts.urn:
                raise TypeError("Missing required property 'oidc_config'")
            __props__.__dict__["oidc_config"] = oidc_config
            if platform_version is None and not opts.urn:
                raise TypeError("Missing required property 'platform_version'")
            __props__.__dict__["platform_version"] = platform_version
            __props__.__dict__["project"] = project
            __props__.__dict__["proxy_config"] = proxy_config
            __props__.__dict__["security_posture_config"] = security_posture_config
            __props__.__dict__["cluster_region"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["kubernetes_version"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["workload_identity_configs"] = None
        super(AttachedCluster, __self__).__init__(
            'gcp:container/attachedCluster:AttachedCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            authorization: Optional[pulumi.Input[Union['AttachedClusterAuthorizationArgs', 'AttachedClusterAuthorizationArgsDict']]] = None,
            binary_authorization: Optional[pulumi.Input[Union['AttachedClusterBinaryAuthorizationArgs', 'AttachedClusterBinaryAuthorizationArgsDict']]] = None,
            cluster_region: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            deletion_policy: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            distribution: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AttachedClusterErrorArgs', 'AttachedClusterErrorArgsDict']]]]] = None,
            fleet: Optional[pulumi.Input[Union['AttachedClusterFleetArgs', 'AttachedClusterFleetArgsDict']]] = None,
            kubernetes_version: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['AttachedClusterLoggingConfigArgs', 'AttachedClusterLoggingConfigArgsDict']]] = None,
            monitoring_config: Optional[pulumi.Input[Union['AttachedClusterMonitoringConfigArgs', 'AttachedClusterMonitoringConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oidc_config: Optional[pulumi.Input[Union['AttachedClusterOidcConfigArgs', 'AttachedClusterOidcConfigArgsDict']]] = None,
            platform_version: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            proxy_config: Optional[pulumi.Input[Union['AttachedClusterProxyConfigArgs', 'AttachedClusterProxyConfigArgsDict']]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            security_posture_config: Optional[pulumi.Input[Union['AttachedClusterSecurityPostureConfigArgs', 'AttachedClusterSecurityPostureConfigArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AttachedClusterWorkloadIdentityConfigArgs', 'AttachedClusterWorkloadIdentityConfigArgsDict']]]]] = None) -> 'AttachedCluster':
        """
        Get an existing AttachedCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same
               restrictions as Kubernetes annotations. The total size of all keys and
               values combined is limited to 256k. Key can have 2 segments: prefix (optional)
               and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
               Name must be 63 characters or less, begin and end with alphanumerics,
               with dashes (-), underscores (_), dots (.), and alphanumerics between.
               
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AttachedClusterAuthorizationArgs', 'AttachedClusterAuthorizationArgsDict']] authorization: Configuration related to the cluster RBAC settings.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterBinaryAuthorizationArgs', 'AttachedClusterBinaryAuthorizationArgsDict']] binary_authorization: Binary Authorization configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] cluster_region: Output only. The region where this cluster runs.
               For EKS clusters, this is an AWS region. For AKS clusters,
               this is an Azure region.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[builtins.str] deletion_policy: Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        :param pulumi.Input[builtins.str] description: A human readable description of this attached cluster. Cannot be longer
               than 255 UTF-8 encoded bytes.
        :param pulumi.Input[builtins.str] distribution: The Kubernetes distribution of the underlying attached cluster. Supported values:
               "eks", "aks", "generic". The generic distribution provides the ability to register
               or migrate any CNCF conformant cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AttachedClusterErrorArgs', 'AttachedClusterErrorArgsDict']]]] errors: A set of errors found in the cluster.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterFleetArgs', 'AttachedClusterFleetArgsDict']] fleet: Fleet configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] kubernetes_version: The Kubernetes version of the cluster.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AttachedClusterLoggingConfigArgs', 'AttachedClusterLoggingConfigArgsDict']] logging_config: Logging configuration.
               Structure is documented below.
        :param pulumi.Input[Union['AttachedClusterMonitoringConfigArgs', 'AttachedClusterMonitoringConfigArgsDict']] monitoring_config: Monitoring configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[Union['AttachedClusterOidcConfigArgs', 'AttachedClusterOidcConfigArgsDict']] oidc_config: OIDC discovery information of the target cluster.
               Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
               API server. This fields indicates how GCP services
               validate KSA tokens in order to allow system workloads (such as GKE Connect
               and telemetry agents) to authenticate back to GCP.
               Both clusters with public and private issuer URLs are supported.
               Clusters with public issuers only need to specify the `issuer_url` field
               while clusters with private issuers need to provide both
               `issuer_url` and `jwks`.
               Structure is documented below.
        :param pulumi.Input[builtins.str] platform_version: The platform version for the cluster (e.g. `1.23.0-gke.1`).
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['AttachedClusterProxyConfigArgs', 'AttachedClusterProxyConfigArgsDict']] proxy_config: Support for proxy configuration.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] reconciling: If set, there are currently changes in flight to the cluster.
        :param pulumi.Input[Union['AttachedClusterSecurityPostureConfigArgs', 'AttachedClusterSecurityPostureConfigArgsDict']] security_posture_config: (Optional, Deprecated)
               Enable/Disable Security Posture API features for the cluster.
               Structure is documented below.
               
               > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        :param pulumi.Input[builtins.str] state: The current state of the cluster. Possible values:
               STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR,
               DEGRADED
        :param pulumi.Input[builtins.str] uid: A globally unique identifier for the cluster.
        :param pulumi.Input[builtins.str] update_time: The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AttachedClusterWorkloadIdentityConfigArgs', 'AttachedClusterWorkloadIdentityConfigArgsDict']]]] workload_identity_configs: Workload Identity settings.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachedClusterState.__new__(_AttachedClusterState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["cluster_region"] = cluster_region
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletion_policy"] = deletion_policy
        __props__.__dict__["description"] = description
        __props__.__dict__["distribution"] = distribution
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["errors"] = errors
        __props__.__dict__["fleet"] = fleet
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["monitoring_config"] = monitoring_config
        __props__.__dict__["name"] = name
        __props__.__dict__["oidc_config"] = oidc_config
        __props__.__dict__["platform_version"] = platform_version
        __props__.__dict__["project"] = project
        __props__.__dict__["proxy_config"] = proxy_config
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["security_posture_config"] = security_posture_config
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["workload_identity_configs"] = workload_identity_configs
        return AttachedCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Annotations on the cluster. This field has the same
        restrictions as Kubernetes annotations. The total size of all keys and
        values combined is limited to 256k. Key can have 2 segments: prefix (optional)
        and name (required), separated by a slash (/). Prefix must be a DNS subdomain.
        Name must be 63 characters or less, begin and end with alphanumerics,
        with dashes (-), underscores (_), dots (.), and alphanumerics between.

        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional['outputs.AttachedClusterAuthorization']]:
        """
        Configuration related to the cluster RBAC settings.
        Structure is documented below.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output['outputs.AttachedClusterBinaryAuthorization']:
        """
        Binary Authorization configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter(name="clusterRegion")
    def cluster_region(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The region where this cluster runs.
        For EKS clusters, this is an AWS region. For AKS clusters,
        this is an Azure region.
        """
        return pulumi.get(self, "cluster_region")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deletionPolicy")
    def deletion_policy(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Policy to determine what flags to send on delete. Possible values: DELETE, DELETE_IGNORE_ERRORS
        """
        return pulumi.get(self, "deletion_policy")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A human readable description of this attached cluster. Cannot be longer
        than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> pulumi.Output[builtins.str]:
        """
        The Kubernetes distribution of the underlying attached cluster. Supported values:
        "eks", "aks", "generic". The generic distribution provides the ability to register
        or migrate any CNCF conformant cluster.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.AttachedClusterError']]:
        """
        A set of errors found in the cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Output['outputs.AttachedClusterFleet']:
        """
        Fleet configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[builtins.str]:
        """
        The Kubernetes version of the cluster.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.AttachedClusterLoggingConfig']]:
        """
        Logging configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="monitoringConfig")
    def monitoring_config(self) -> pulumi.Output['outputs.AttachedClusterMonitoringConfig']:
        """
        Monitoring configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "monitoring_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="oidcConfig")
    def oidc_config(self) -> pulumi.Output['outputs.AttachedClusterOidcConfig']:
        """
        OIDC discovery information of the target cluster.
        Kubernetes Service Account (KSA) tokens are JWT tokens signed by the cluster
        API server. This fields indicates how GCP services
        validate KSA tokens in order to allow system workloads (such as GKE Connect
        and telemetry agents) to authenticate back to GCP.
        Both clusters with public and private issuer URLs are supported.
        Clusters with public issuers only need to specify the `issuer_url` field
        while clusters with private issuers need to provide both
        `issuer_url` and `jwks`.
        Structure is documented below.
        """
        return pulumi.get(self, "oidc_config")

    @property
    @pulumi.getter(name="platformVersion")
    def platform_version(self) -> pulumi.Output[builtins.str]:
        """
        The platform version for the cluster (e.g. `1.23.0-gke.1`).
        """
        return pulumi.get(self, "platform_version")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="proxyConfig")
    def proxy_config(self) -> pulumi.Output[Optional['outputs.AttachedClusterProxyConfig']]:
        """
        Support for proxy configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "proxy_config")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter(name="securityPostureConfig")
    @_utilities.deprecated("""`security_posture_config` is deprecated and will be removed in a future major release.""")
    def security_posture_config(self) -> pulumi.Output['outputs.AttachedClusterSecurityPostureConfig']:
        """
        (Optional, Deprecated)
        Enable/Disable Security Posture API features for the cluster.
        Structure is documented below.

        > **Warning:** `security_posture_config` is deprecated and will be removed in a future major release.
        """
        return pulumi.get(self, "security_posture_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the cluster. Possible values:
        STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR,
        DEGRADED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> pulumi.Output[Sequence['outputs.AttachedClusterWorkloadIdentityConfig']]:
        """
        Workload Identity settings.
        Structure is documented below.
        """
        return pulumi.get(self, "workload_identity_configs")

