# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AwsClusterArgs', 'AwsCluster']

@pulumi.input_type
class AwsClusterArgs:
    def __init__(__self__, *,
                 authorization: pulumi.Input['AwsClusterAuthorizationArgs'],
                 aws_region: pulumi.Input[builtins.str],
                 control_plane: pulumi.Input['AwsClusterControlPlaneArgs'],
                 fleet: pulumi.Input['AwsClusterFleetArgs'],
                 location: pulumi.Input[builtins.str],
                 networking: pulumi.Input['AwsClusterNetworkingArgs'],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 binary_authorization: Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['AwsClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AwsCluster resource.
        :param pulumi.Input['AwsClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[builtins.str] aws_region: The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        :param pulumi.Input['AwsClusterControlPlaneArgs'] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input['AwsClusterFleetArgs'] fleet: Fleet configuration.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AwsClusterNetworkingArgs'] networking: Cluster-wide networking configuration.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
               all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AwsClusterBinaryAuthorizationArgs'] binary_authorization: Configuration options for the Binary Authorization feature.
        :param pulumi.Input[builtins.str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input['AwsClusterLoggingConfigArgs'] logging_config: Logging configuration.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The project for the resource
        """
        pulumi.set(__self__, "authorization", authorization)
        pulumi.set(__self__, "aws_region", aws_region)
        pulumi.set(__self__, "control_plane", control_plane)
        pulumi.set(__self__, "fleet", fleet)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "networking", networking)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Input['AwsClusterAuthorizationArgs']:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: pulumi.Input['AwsClusterAuthorizationArgs']):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Input[builtins.str]:
        """
        The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Input['AwsClusterControlPlaneArgs']:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: pulumi.Input['AwsClusterControlPlaneArgs']):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Input['AwsClusterFleetArgs']:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: pulumi.Input['AwsClusterFleetArgs']):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Input['AwsClusterNetworkingArgs']:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: pulumi.Input['AwsClusterNetworkingArgs']):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
        all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']]:
        """
        Configuration options for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AwsClusterLoggingConfigArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AwsClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AwsClusterState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input['AwsClusterAuthorizationArgs']] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']] = None,
                 control_plane: Optional[pulumi.Input['AwsClusterControlPlaneArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 fleet: Optional[pulumi.Input['AwsClusterFleetArgs']] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input['AwsClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input['AwsClusterNetworkingArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AwsClusterWorkloadIdentityConfigArgs']]]] = None):
        """
        Input properties used for looking up and filtering AwsCluster resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
               all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AwsClusterAuthorizationArgs'] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[builtins.str] aws_region: The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        :param pulumi.Input['AwsClusterBinaryAuthorizationArgs'] binary_authorization: Configuration options for the Binary Authorization feature.
        :param pulumi.Input['AwsClusterControlPlaneArgs'] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[builtins.str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[builtins.str] endpoint: Output only. The endpoint of the cluster's API server.
        :param pulumi.Input[builtins.str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input['AwsClusterFleetArgs'] fleet: Fleet configuration.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AwsClusterLoggingConfigArgs'] logging_config: Logging configuration.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input['AwsClusterNetworkingArgs'] networking: Cluster-wide networking configuration.
        :param pulumi.Input[builtins.str] project: The project for the resource
        :param pulumi.Input[builtins.bool] reconciling: Output only. If set, there are currently changes in flight to the cluster.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[builtins.str] uid: Output only. A globally unique identifier for the cluster.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input['AwsClusterWorkloadIdentityConfigArgs']]] workload_identity_configs: Output only. Workload Identity settings.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if aws_region is not None:
            pulumi.set(__self__, "aws_region", aws_region)
        if binary_authorization is not None:
            pulumi.set(__self__, "binary_authorization", binary_authorization)
        if control_plane is not None:
            pulumi.set(__self__, "control_plane", control_plane)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if fleet is not None:
            pulumi.set(__self__, "fleet", fleet)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networking is not None:
            pulumi.set(__self__, "networking", networking)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if workload_identity_configs is not None:
            pulumi.set(__self__, "workload_identity_configs", workload_identity_configs)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
        all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input['AwsClusterAuthorizationArgs']]:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input['AwsClusterAuthorizationArgs']]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        """
        return pulumi.get(self, "aws_region")

    @aws_region.setter
    def aws_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "aws_region", value)

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']]:
        """
        Configuration options for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @binary_authorization.setter
    def binary_authorization(self, value: Optional[pulumi.Input['AwsClusterBinaryAuthorizationArgs']]):
        pulumi.set(self, "binary_authorization", value)

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> Optional[pulumi.Input['AwsClusterControlPlaneArgs']]:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @control_plane.setter
    def control_plane(self, value: Optional[pulumi.Input['AwsClusterControlPlaneArgs']]):
        pulumi.set(self, "control_plane", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The endpoint of the cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def fleet(self) -> Optional[pulumi.Input['AwsClusterFleetArgs']]:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @fleet.setter
    def fleet(self, value: Optional[pulumi.Input['AwsClusterFleetArgs']]):
        pulumi.set(self, "fleet", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['AwsClusterLoggingConfigArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['AwsClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def networking(self) -> Optional[pulumi.Input['AwsClusterNetworkingArgs']]:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @networking.setter
    def networking(self, value: Optional[pulumi.Input['AwsClusterNetworkingArgs']]):
        pulumi.set(self, "networking", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AwsClusterWorkloadIdentityConfigArgs']]]]:
        """
        Output only. Workload Identity settings.
        """
        return pulumi.get(self, "workload_identity_configs")

    @workload_identity_configs.setter
    def workload_identity_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AwsClusterWorkloadIdentityConfigArgs']]]]):
        pulumi.set(self, "workload_identity_configs", value)


@pulumi.type_token("gcp:container/awsCluster:AwsCluster")
class AwsCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[Union['AwsClusterAuthorizationArgs', 'AwsClusterAuthorizationArgsDict']]] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['AwsClusterBinaryAuthorizationArgs', 'AwsClusterBinaryAuthorizationArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['AwsClusterControlPlaneArgs', 'AwsClusterControlPlaneArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fleet: Optional[pulumi.Input[Union['AwsClusterFleetArgs', 'AwsClusterFleetArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['AwsClusterLoggingConfigArgs', 'AwsClusterLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['AwsClusterNetworkingArgs', 'AwsClusterNetworkingArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An Anthos cluster running on AWS.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_aws_cluster
        A basic example of a containeraws cluster
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
                "admin_groups": [{
                    "group": "group@domain.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        ```
        ### Basic_enum_aws_cluster
        A basic example of a containeraws cluster with lowercase enums
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        ```
        ### Beta_basic_enum_aws_cluster
        A basic example of a containeraws cluster with lowercase enums (beta)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
                "instance_placement": {
                    "tenancy": "dedicated",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name",
            logging_config={
                "component_config": {
                    "enable_components": [
                        "system_components",
                        "workloads",
                    ],
                },
            })
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/awsClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default projects/{{project}}/locations/{{location}}/awsClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
               all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AwsClusterAuthorizationArgs', 'AwsClusterAuthorizationArgsDict']] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[builtins.str] aws_region: The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        :param pulumi.Input[Union['AwsClusterBinaryAuthorizationArgs', 'AwsClusterBinaryAuthorizationArgsDict']] binary_authorization: Configuration options for the Binary Authorization feature.
        :param pulumi.Input[Union['AwsClusterControlPlaneArgs', 'AwsClusterControlPlaneArgsDict']] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[builtins.str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[Union['AwsClusterFleetArgs', 'AwsClusterFleetArgsDict']] fleet: Fleet configuration.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AwsClusterLoggingConfigArgs', 'AwsClusterLoggingConfigArgsDict']] logging_config: Logging configuration.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[Union['AwsClusterNetworkingArgs', 'AwsClusterNetworkingArgsDict']] networking: Cluster-wide networking configuration.
        :param pulumi.Input[builtins.str] project: The project for the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AwsClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Anthos cluster running on AWS.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_aws_cluster
        A basic example of a containeraws cluster
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
                "admin_groups": [{
                    "group": "group@domain.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "GP3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        ```
        ### Basic_enum_aws_cluster
        A basic example of a containeraws cluster with lowercase enums
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name")
        ```
        ### Beta_basic_enum_aws_cluster
        A basic example of a containeraws cluster with lowercase enums (beta)
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_aws_versions(project="my-project-name",
            location="us-west1")
        primary = gcp.container.AwsCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "my@service-account.com",
                }],
            },
            aws_region="my-aws-region",
            control_plane={
                "aws_services_authentication": {
                    "role_arn": "arn:aws:iam::012345678910:role/my--1p-dev-oneplatform",
                    "role_session_name": "my--1p-dev-session",
                },
                "config_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "database_encryption": {
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                },
                "iam_instance_profile": "my--1p-dev-controlplane",
                "subnet_ids": ["subnet-00000000000000000"],
                "version": versions.valid_versions[0],
                "instance_type": "t3.medium",
                "main_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "proxy_config": {
                    "secret_arn": "arn:aws:secretsmanager:us-west-2:126285863215:secret:proxy_config20210824150329476300000001-ABCDEF",
                    "secret_version": "12345678-ABCD-EFGH-IJKL-987654321098",
                },
                "root_volume": {
                    "iops": 3000,
                    "kms_key_arn": "arn:aws:kms:my-aws-region:012345678910:key/12345678-1234-1234-1234-123456789111",
                    "size_gib": 10,
                    "volume_type": "gp3",
                },
                "security_group_ids": ["sg-00000000000000000"],
                "ssh_config": {
                    "ec2_key_pair": "my--1p-dev-ssh",
                },
                "tags": {
                    "owner": "my@service-account.com",
                },
                "instance_placement": {
                    "tenancy": "dedicated",
                },
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.2.0.0/16"],
                "service_address_cidr_blocks": ["10.1.0.0/16"],
                "vpc_id": "vpc-00000000000000000",
            },
            annotations={
                "label-one": "value-one",
            },
            description="A sample aws cluster",
            project="my-project-name",
            logging_config={
                "component_config": {
                    "enable_components": [
                        "system_components",
                        "workloads",
                    ],
                },
            })
        ```

        ## Import

        Cluster can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/awsClusters/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, Cluster can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default projects/{{project}}/locations/{{location}}/awsClusters/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/awsCluster:AwsCluster default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AwsClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AwsClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 authorization: Optional[pulumi.Input[Union['AwsClusterAuthorizationArgs', 'AwsClusterAuthorizationArgsDict']]] = None,
                 aws_region: Optional[pulumi.Input[builtins.str]] = None,
                 binary_authorization: Optional[pulumi.Input[Union['AwsClusterBinaryAuthorizationArgs', 'AwsClusterBinaryAuthorizationArgsDict']]] = None,
                 control_plane: Optional[pulumi.Input[Union['AwsClusterControlPlaneArgs', 'AwsClusterControlPlaneArgsDict']]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 fleet: Optional[pulumi.Input[Union['AwsClusterFleetArgs', 'AwsClusterFleetArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 logging_config: Optional[pulumi.Input[Union['AwsClusterLoggingConfigArgs', 'AwsClusterLoggingConfigArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 networking: Optional[pulumi.Input[Union['AwsClusterNetworkingArgs', 'AwsClusterNetworkingArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AwsClusterArgs.__new__(AwsClusterArgs)

            __props__.__dict__["annotations"] = annotations
            if authorization is None and not opts.urn:
                raise TypeError("Missing required property 'authorization'")
            __props__.__dict__["authorization"] = authorization
            if aws_region is None and not opts.urn:
                raise TypeError("Missing required property 'aws_region'")
            __props__.__dict__["aws_region"] = aws_region
            __props__.__dict__["binary_authorization"] = binary_authorization
            if control_plane is None and not opts.urn:
                raise TypeError("Missing required property 'control_plane'")
            __props__.__dict__["control_plane"] = control_plane
            __props__.__dict__["description"] = description
            if fleet is None and not opts.urn:
                raise TypeError("Missing required property 'fleet'")
            __props__.__dict__["fleet"] = fleet
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["name"] = name
            if networking is None and not opts.urn:
                raise TypeError("Missing required property 'networking'")
            __props__.__dict__["networking"] = networking
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["workload_identity_configs"] = None
        super(AwsCluster, __self__).__init__(
            'gcp:container/awsCluster:AwsCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            authorization: Optional[pulumi.Input[Union['AwsClusterAuthorizationArgs', 'AwsClusterAuthorizationArgsDict']]] = None,
            aws_region: Optional[pulumi.Input[builtins.str]] = None,
            binary_authorization: Optional[pulumi.Input[Union['AwsClusterBinaryAuthorizationArgs', 'AwsClusterBinaryAuthorizationArgsDict']]] = None,
            control_plane: Optional[pulumi.Input[Union['AwsClusterControlPlaneArgs', 'AwsClusterControlPlaneArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            endpoint: Optional[pulumi.Input[builtins.str]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            fleet: Optional[pulumi.Input[Union['AwsClusterFleetArgs', 'AwsClusterFleetArgsDict']]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            logging_config: Optional[pulumi.Input[Union['AwsClusterLoggingConfigArgs', 'AwsClusterLoggingConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            networking: Optional[pulumi.Input[Union['AwsClusterNetworkingArgs', 'AwsClusterNetworkingArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            workload_identity_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AwsClusterWorkloadIdentityConfigArgs', 'AwsClusterWorkloadIdentityConfigArgsDict']]]]] = None) -> 'AwsCluster':
        """
        Get an existing AwsCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
               all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AwsClusterAuthorizationArgs', 'AwsClusterAuthorizationArgsDict']] authorization: Configuration related to the cluster RBAC settings.
        :param pulumi.Input[builtins.str] aws_region: The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        :param pulumi.Input[Union['AwsClusterBinaryAuthorizationArgs', 'AwsClusterBinaryAuthorizationArgsDict']] binary_authorization: Configuration options for the Binary Authorization feature.
        :param pulumi.Input[Union['AwsClusterControlPlaneArgs', 'AwsClusterControlPlaneArgsDict']] control_plane: Configuration related to the cluster control plane.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this cluster was created.
        :param pulumi.Input[builtins.str] description: Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        :param pulumi.Input[builtins.str] endpoint: Output only. The endpoint of the cluster's API server.
        :param pulumi.Input[builtins.str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[Union['AwsClusterFleetArgs', 'AwsClusterFleetArgsDict']] fleet: Fleet configuration.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AwsClusterLoggingConfigArgs', 'AwsClusterLoggingConfigArgsDict']] logging_config: Logging configuration.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[Union['AwsClusterNetworkingArgs', 'AwsClusterNetworkingArgsDict']] networking: Cluster-wide networking configuration.
        :param pulumi.Input[builtins.str] project: The project for the resource
        :param pulumi.Input[builtins.bool] reconciling: Output only. If set, there are currently changes in flight to the cluster.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[builtins.str] uid: Output only. A globally unique identifier for the cluster.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this cluster was last updated.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AwsClusterWorkloadIdentityConfigArgs', 'AwsClusterWorkloadIdentityConfigArgsDict']]]] workload_identity_configs: Output only. Workload Identity settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AwsClusterState.__new__(_AwsClusterState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["aws_region"] = aws_region
        __props__.__dict__["binary_authorization"] = binary_authorization
        __props__.__dict__["control_plane"] = control_plane
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["etag"] = etag
        __props__.__dict__["fleet"] = fleet
        __props__.__dict__["location"] = location
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["networking"] = networking
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["workload_identity_configs"] = workload_identity_configs
        return AwsCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Annotations on the cluster. This field has the same restrictions as Kubernetes annotations. The total size of
        all keys and values combined is limited to 256k. Key can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output['outputs.AwsClusterAuthorization']:
        """
        Configuration related to the cluster RBAC settings.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="awsRegion")
    def aws_region(self) -> pulumi.Output[builtins.str]:
        """
        The AWS region where the cluster runs. Each Google Cloud region supports a subset of nearby AWS regions. You can call to list all supported AWS regions within a given Google Cloud region.
        """
        return pulumi.get(self, "aws_region")

    @property
    @pulumi.getter(name="binaryAuthorization")
    def binary_authorization(self) -> pulumi.Output['outputs.AwsClusterBinaryAuthorization']:
        """
        Configuration options for the Binary Authorization feature.
        """
        return pulumi.get(self, "binary_authorization")

    @property
    @pulumi.getter(name="controlPlane")
    def control_plane(self) -> pulumi.Output['outputs.AwsClusterControlPlane']:
        """
        Configuration related to the cluster control plane.
        """
        return pulumi.get(self, "control_plane")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this cluster was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Optional. A human readable description of this cluster. Cannot be longer than 255 UTF-8 encoded bytes.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The endpoint of the cluster's API server.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def fleet(self) -> pulumi.Output['outputs.AwsClusterFleet']:
        """
        Fleet configuration.
        """
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output['outputs.AwsClusterLoggingConfig']:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def networking(self) -> pulumi.Output['outputs.AwsClusterNetworking']:
        """
        Cluster-wide networking configuration.
        """
        return pulumi.get(self, "networking")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. If set, there are currently changes in flight to the cluster.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The current state of the cluster. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. A globally unique identifier for the cluster.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this cluster was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workloadIdentityConfigs")
    def workload_identity_configs(self) -> pulumi.Output[Sequence['outputs.AwsClusterWorkloadIdentityConfig']]:
        """
        Output only. Workload Identity settings.
        """
        return pulumi.get(self, "workload_identity_configs")

