# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AzureNodePoolArgs', 'AzureNodePool']

@pulumi.input_type
class AzureNodePoolArgs:
    def __init__(__self__, *,
                 autoscaling: pulumi.Input['AzureNodePoolAutoscalingArgs'],
                 cluster: pulumi.Input[builtins.str],
                 config: pulumi.Input['AzureNodePoolConfigArgs'],
                 location: pulumi.Input[builtins.str],
                 max_pods_constraint: pulumi.Input['AzureNodePoolMaxPodsConstraintArgs'],
                 subnet_id: pulumi.Input[builtins.str],
                 version: pulumi.Input[builtins.str],
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 azure_availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 management: Optional[pulumi.Input['AzureNodePoolManagementArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a AzureNodePool resource.
        :param pulumi.Input['AzureNodePoolAutoscalingArgs'] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[builtins.str] cluster: The azureCluster for the resource
        :param pulumi.Input['AzureNodePoolConfigArgs'] config: The node configuration of the node pool.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AzureNodePoolMaxPodsConstraintArgs'] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[builtins.str] subnet_id: The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        :param pulumi.Input[builtins.str] version: The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[builtins.str] azure_availability_zone: Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        :param pulumi.Input['AzureNodePoolManagementArgs'] management: The Management configuration for this node pool.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The project for the resource
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if azure_availability_zone is not None:
            pulumi.set(__self__, "azure_availability_zone", azure_availability_zone)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Input['AzureNodePoolAutoscalingArgs']:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: pulumi.Input['AzureNodePoolAutoscalingArgs']):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Input[builtins.str]:
        """
        The azureCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['AzureNodePoolConfigArgs']:
        """
        The node configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['AzureNodePoolConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> pulumi.Input['AzureNodePoolMaxPodsConstraintArgs']:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @max_pods_constraint.setter
    def max_pods_constraint(self, value: pulumi.Input['AzureNodePoolMaxPodsConstraintArgs']):
        pulumi.set(self, "max_pods_constraint", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[builtins.str]:
        """
        The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter(name="azureAvailabilityZone")
    def azure_availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        """
        return pulumi.get(self, "azure_availability_zone")

    @azure_availability_zone.setter
    def azure_availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_availability_zone", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['AzureNodePoolManagementArgs']]:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['AzureNodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AzureNodePoolState:
    def __init__(__self__, *,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 autoscaling: Optional[pulumi.Input['AzureNodePoolAutoscalingArgs']] = None,
                 azure_availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input['AzureNodePoolConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 etag: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 management: Optional[pulumi.Input['AzureNodePoolManagementArgs']] = None,
                 max_pods_constraint: Optional[pulumi.Input['AzureNodePoolMaxPodsConstraintArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reconciling: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering AzureNodePool resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input['AzureNodePoolAutoscalingArgs'] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[builtins.str] azure_availability_zone: Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        :param pulumi.Input[builtins.str] cluster: The azureCluster for the resource
        :param pulumi.Input['AzureNodePoolConfigArgs'] config: The node configuration of the node pool.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this node pool was created.
        :param pulumi.Input[builtins.str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input['AzureNodePoolManagementArgs'] management: The Management configuration for this node pool.
        :param pulumi.Input['AzureNodePoolMaxPodsConstraintArgs'] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The project for the resource
        :param pulumi.Input[builtins.bool] reconciling: Output only. If set, there are currently pending changes to the node pool.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[builtins.str] subnet_id: The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        :param pulumi.Input[builtins.str] uid: Output only. A globally unique identifier for the node pool.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this node pool was last updated.
        :param pulumi.Input[builtins.str] version: The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if azure_availability_zone is not None:
            pulumi.set(__self__, "azure_availability_zone", azure_availability_zone)
        if cluster is not None:
            pulumi.set(__self__, "cluster", cluster)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management is not None:
            pulumi.set(__self__, "management", management)
        if max_pods_constraint is not None:
            pulumi.set(__self__, "max_pods_constraint", max_pods_constraint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reconciling is not None:
            pulumi.set(__self__, "reconciling", reconciling)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input['AzureNodePoolAutoscalingArgs']]:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input['AzureNodePoolAutoscalingArgs']]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="azureAvailabilityZone")
    def azure_availability_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        """
        return pulumi.get(self, "azure_availability_zone")

    @azure_availability_zone.setter
    def azure_availability_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "azure_availability_zone", value)

    @property
    @pulumi.getter
    def cluster(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The azureCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @cluster.setter
    def cluster(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['AzureNodePoolConfigArgs']]:
        """
        The node configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['AzureNodePoolConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this node pool was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "etag", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def management(self) -> Optional[pulumi.Input['AzureNodePoolManagementArgs']]:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @management.setter
    def management(self, value: Optional[pulumi.Input['AzureNodePoolManagementArgs']]):
        pulumi.set(self, "management", value)

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> Optional[pulumi.Input['AzureNodePoolMaxPodsConstraintArgs']]:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @max_pods_constraint.setter
    def max_pods_constraint(self, value: Optional[pulumi.Input['AzureNodePoolMaxPodsConstraintArgs']]):
        pulumi.set(self, "max_pods_constraint", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def reconciling(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Output only. If set, there are currently pending changes to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @reconciling.setter
    def reconciling(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "reconciling", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The current state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. A globally unique identifier for the node pool.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The time at which this node pool was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("gcp:container/azureNodePool:AzureNodePool")
class AzureNodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 autoscaling: Optional[pulumi.Input[Union['AzureNodePoolAutoscalingArgs', 'AzureNodePoolAutoscalingArgsDict']]] = None,
                 azure_availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['AzureNodePoolConfigArgs', 'AzureNodePoolConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 management: Optional[pulumi.Input[Union['AzureNodePoolManagementArgs', 'AzureNodePoolManagementArgsDict']]] = None,
                 max_pods_constraint: Optional[pulumi.Input[Union['AzureNodePoolMaxPodsConstraintArgs', 'AzureNodePoolMaxPodsConstraintArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An Anthos node pool running on Azure.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_azure_node_pool
        A basic example of a containerazure azure node pool
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_azure_versions(project="my-project-name",
            location="us-west1")
        basic = gcp.container.AzureClient("basic",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            name="client-name",
            tenant_id="12345678-1234-1234-1234-123456789111",
            project="my-project-name")
        primary = gcp.container.AzureCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "mmv2@google.com",
                }],
            },
            azure_region="westus2",
            client=basic.name.apply(lambda name: f"projects/my-project-number/locations/us-west1/azureClients/{name}"),
            control_plane={
                "ssh_config": {
                    "authorized_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                },
                "subnet_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
                "version": versions.valid_versions[0],
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.200.0.0/16"],
                "service_address_cidr_blocks": ["10.32.0.0/24"],
                "virtual_network_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet",
            },
            resource_group_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster",
            project="my-project-name")
        primary_azure_node_pool = gcp.container.AzureNodePool("primary",
            autoscaling={
                "max_node_count": 3,
                "min_node_count": 2,
            },
            cluster=primary.name,
            config={
                "ssh_config": {
                    "authorized_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                },
                "proxy_config": {
                    "resource_group_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster",
                    "secret_id": "https://my--dev-keyvault.vault.azure.net/secrets/my--dev-secret/0000000000000000000000000000000000",
                },
                "root_volume": {
                    "size_gib": 32,
                },
                "tags": {
                    "owner": "mmv2",
                },
                "labels": {
                    "key_one": "label_one",
                },
                "vm_size": "Standard_DS2_v2",
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
            version=versions.valid_versions[0],
            annotations={
                "annotation-one": "value-one",
            },
            management={
                "auto_repair": True,
            },
            project="my-project-name")
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/azureClusters/{{cluster}}/azureNodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default projects/{{project}}/locations/{{location}}/azureClusters/{{cluster}}/azureNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AzureNodePoolAutoscalingArgs', 'AzureNodePoolAutoscalingArgsDict']] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[builtins.str] azure_availability_zone: Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        :param pulumi.Input[builtins.str] cluster: The azureCluster for the resource
        :param pulumi.Input[Union['AzureNodePoolConfigArgs', 'AzureNodePoolConfigArgsDict']] config: The node configuration of the node pool.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AzureNodePoolManagementArgs', 'AzureNodePoolManagementArgsDict']] management: The Management configuration for this node pool.
        :param pulumi.Input[Union['AzureNodePoolMaxPodsConstraintArgs', 'AzureNodePoolMaxPodsConstraintArgsDict']] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The project for the resource
        :param pulumi.Input[builtins.str] subnet_id: The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        :param pulumi.Input[builtins.str] version: The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzureNodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Anthos node pool running on Azure.

        For more information, see:
        * [Multicloud overview](https://cloud.google.com/kubernetes-engine/multi-cloud/docs)
        ## Example Usage

        ### Basic_azure_node_pool
        A basic example of a containerazure azure node pool
        ```python
        import pulumi
        import pulumi_gcp as gcp

        versions = gcp.container.get_azure_versions(project="my-project-name",
            location="us-west1")
        basic = gcp.container.AzureClient("basic",
            application_id="12345678-1234-1234-1234-123456789111",
            location="us-west1",
            name="client-name",
            tenant_id="12345678-1234-1234-1234-123456789111",
            project="my-project-name")
        primary = gcp.container.AzureCluster("primary",
            authorization={
                "admin_users": [{
                    "username": "mmv2@google.com",
                }],
            },
            azure_region="westus2",
            client=basic.name.apply(lambda name: f"projects/my-project-number/locations/us-west1/azureClients/{name}"),
            control_plane={
                "ssh_config": {
                    "authorized_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                },
                "subnet_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
                "version": versions.valid_versions[0],
            },
            fleet={
                "project": "my-project-number",
            },
            location="us-west1",
            name="name",
            networking={
                "pod_address_cidr_blocks": ["10.200.0.0/16"],
                "service_address_cidr_blocks": ["10.32.0.0/24"],
                "virtual_network_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet",
            },
            resource_group_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster",
            project="my-project-name")
        primary_azure_node_pool = gcp.container.AzureNodePool("primary",
            autoscaling={
                "max_node_count": 3,
                "min_node_count": 2,
            },
            cluster=primary.name,
            config={
                "ssh_config": {
                    "authorized_key": "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAACAQC8yaayO6lnb2v+SedxUMa2c8vtIEzCzBjM3EJJsv8Vm9zUDWR7dXWKoNGARUb2mNGXASvI6mFIDXTIlkQ0poDEPpMaXR0g2cb5xT8jAAJq7fqXL3+0rcJhY/uigQ+MrT6s+ub0BFVbsmGHNrMQttXX9gtmwkeAEvj3mra9e5pkNf90qlKnZz6U0SVArxVsLx07vHPHDIYrl0OPG4zUREF52igbBPiNrHJFDQJT/4YlDMJmo/QT/A1D6n9ocemvZSzhRx15/Arjowhr+VVKSbaxzPtEfY0oIg2SrqJnnr/l3Du5qIefwh5VmCZe4xopPUaDDoOIEFriZ88sB+3zz8ib8sk8zJJQCgeP78tQvXCgS+4e5W3TUg9mxjB6KjXTyHIVhDZqhqde0OI3Fy1UuVzRUwnBaLjBnAwP5EoFQGRmDYk/rEYe7HTmovLeEBUDQocBQKT4Ripm/xJkkWY7B07K/tfo56dGUCkvyIVXKBInCh+dLK7gZapnd4UWkY0xBYcwo1geMLRq58iFTLA2j/JmpmHXp7m0l7jJii7d44uD3tTIFYThn7NlOnvhLim/YcBK07GMGIN7XwrrKZKmxXaspw6KBWVhzuw1UPxctxshYEaMLfFg/bwOw8HvMPr9VtrElpSB7oiOh91PDIPdPBgHCi7N2QgQ5l/ZDBHieSpNrQ== thomasrodgers",
                },
                "proxy_config": {
                    "resource_group_id": "/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-cluster",
                    "secret_id": "https://my--dev-keyvault.vault.azure.net/secrets/my--dev-secret/0000000000000000000000000000000000",
                },
                "root_volume": {
                    "size_gib": 32,
                },
                "tags": {
                    "owner": "mmv2",
                },
                "labels": {
                    "key_one": "label_one",
                },
                "vm_size": "Standard_DS2_v2",
            },
            location="us-west1",
            max_pods_constraint={
                "max_pods_per_node": 110,
            },
            name="node-pool-name",
            subnet_id="/subscriptions/12345678-1234-1234-1234-123456789111/resourceGroups/my--dev-byo/providers/Microsoft.Network/virtualNetworks/my--dev-vnet/subnets/default",
            version=versions.valid_versions[0],
            annotations={
                "annotation-one": "value-one",
            },
            management={
                "auto_repair": True,
            },
            project="my-project-name")
        ```

        ## Import

        NodePool can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/azureClusters/{{cluster}}/azureNodePools/{{name}}`

        * `{{project}}/{{location}}/{{cluster}}/{{name}}`

        * `{{location}}/{{cluster}}/{{name}}`

        When using the `pulumi import` command, NodePool can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default projects/{{project}}/locations/{{location}}/azureClusters/{{cluster}}/azureNodePools/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default {{project}}/{{location}}/{{cluster}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:container/azureNodePool:AzureNodePool default {{location}}/{{cluster}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AzureNodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzureNodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 autoscaling: Optional[pulumi.Input[Union['AzureNodePoolAutoscalingArgs', 'AzureNodePoolAutoscalingArgsDict']]] = None,
                 azure_availability_zone: Optional[pulumi.Input[builtins.str]] = None,
                 cluster: Optional[pulumi.Input[builtins.str]] = None,
                 config: Optional[pulumi.Input[Union['AzureNodePoolConfigArgs', 'AzureNodePoolConfigArgsDict']]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 management: Optional[pulumi.Input[Union['AzureNodePoolManagementArgs', 'AzureNodePoolManagementArgsDict']]] = None,
                 max_pods_constraint: Optional[pulumi.Input[Union['AzureNodePoolMaxPodsConstraintArgs', 'AzureNodePoolMaxPodsConstraintArgsDict']]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzureNodePoolArgs.__new__(AzureNodePoolArgs)

            __props__.__dict__["annotations"] = annotations
            if autoscaling is None and not opts.urn:
                raise TypeError("Missing required property 'autoscaling'")
            __props__.__dict__["autoscaling"] = autoscaling
            __props__.__dict__["azure_availability_zone"] = azure_availability_zone
            if cluster is None and not opts.urn:
                raise TypeError("Missing required property 'cluster'")
            __props__.__dict__["cluster"] = cluster
            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["management"] = management
            if max_pods_constraint is None and not opts.urn:
                raise TypeError("Missing required property 'max_pods_constraint'")
            __props__.__dict__["max_pods_constraint"] = max_pods_constraint
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["reconciling"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        super(AzureNodePool, __self__).__init__(
            'gcp:container/azureNodePool:AzureNodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            autoscaling: Optional[pulumi.Input[Union['AzureNodePoolAutoscalingArgs', 'AzureNodePoolAutoscalingArgsDict']]] = None,
            azure_availability_zone: Optional[pulumi.Input[builtins.str]] = None,
            cluster: Optional[pulumi.Input[builtins.str]] = None,
            config: Optional[pulumi.Input[Union['AzureNodePoolConfigArgs', 'AzureNodePoolConfigArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            etag: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            management: Optional[pulumi.Input[Union['AzureNodePoolManagementArgs', 'AzureNodePoolManagementArgsDict']]] = None,
            max_pods_constraint: Optional[pulumi.Input[Union['AzureNodePoolMaxPodsConstraintArgs', 'AzureNodePoolMaxPodsConstraintArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            reconciling: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None) -> 'AzureNodePool':
        """
        Get an existing AzureNodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] annotations: Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
               of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
               separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
               alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
               non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
               `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[Union['AzureNodePoolAutoscalingArgs', 'AzureNodePoolAutoscalingArgsDict']] autoscaling: Autoscaler configuration for this node pool.
        :param pulumi.Input[builtins.str] azure_availability_zone: Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        :param pulumi.Input[builtins.str] cluster: The azureCluster for the resource
        :param pulumi.Input[Union['AzureNodePoolConfigArgs', 'AzureNodePoolConfigArgsDict']] config: The node configuration of the node pool.
        :param pulumi.Input[builtins.str] create_time: Output only. The time at which this node pool was created.
        :param pulumi.Input[builtins.str] etag: Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        :param pulumi.Input[builtins.str] location: The location for the resource
        :param pulumi.Input[Union['AzureNodePoolManagementArgs', 'AzureNodePoolManagementArgsDict']] management: The Management configuration for this node pool.
        :param pulumi.Input[Union['AzureNodePoolMaxPodsConstraintArgs', 'AzureNodePoolMaxPodsConstraintArgsDict']] max_pods_constraint: The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        :param pulumi.Input[builtins.str] name: The name of this resource.
        :param pulumi.Input[builtins.str] project: The project for the resource
        :param pulumi.Input[builtins.bool] reconciling: Output only. If set, there are currently pending changes to the node pool.
        :param pulumi.Input[builtins.str] state: Output only. The current state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        :param pulumi.Input[builtins.str] subnet_id: The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        :param pulumi.Input[builtins.str] uid: Output only. A globally unique identifier for the node pool.
        :param pulumi.Input[builtins.str] update_time: Output only. The time at which this node pool was last updated.
        :param pulumi.Input[builtins.str] version: The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzureNodePoolState.__new__(_AzureNodePoolState)

        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["azure_availability_zone"] = azure_availability_zone
        __props__.__dict__["cluster"] = cluster
        __props__.__dict__["config"] = config
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["etag"] = etag
        __props__.__dict__["location"] = location
        __props__.__dict__["management"] = management
        __props__.__dict__["max_pods_constraint"] = max_pods_constraint
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["reconciling"] = reconciling
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version"] = version
        return AzureNodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Optional. Annotations on the node pool. This field has the same restrictions as Kubernetes annotations. The total size
        of all keys and values combined is limited to 256k. Keys can have 2 segments: prefix (optional) and name (required),
        separated by a slash (/). Prefix must be a DNS subdomain. Name must be 63 characters or less, begin and end with
        alphanumerics, with dashes (-), underscores (_), dots (.), and alphanumerics between. **Note**: This field is
        non-authoritative, and will only manage the annotations present in your configuration. Please refer to the field
        `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output['outputs.AzureNodePoolAutoscaling']:
        """
        Autoscaler configuration for this node pool.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="azureAvailabilityZone")
    def azure_availability_zone(self) -> pulumi.Output[builtins.str]:
        """
        Optional. The Azure availability zone of the nodes in this nodepool. When unspecified, it defaults to `1`.
        """
        return pulumi.get(self, "azure_availability_zone")

    @property
    @pulumi.getter
    def cluster(self) -> pulumi.Output[builtins.str]:
        """
        The azureCluster for the resource
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.AzureNodePoolConfig']:
        """
        The node configuration of the node pool.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this node pool was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[builtins.str]:
        """
        Allows clients to perform consistent read-modify-writes through optimistic concurrency control. May be sent on update and delete requests to ensure the client has an up-to-date value before proceeding.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location for the resource
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def management(self) -> pulumi.Output['outputs.AzureNodePoolManagement']:
        """
        The Management configuration for this node pool.
        """
        return pulumi.get(self, "management")

    @property
    @pulumi.getter(name="maxPodsConstraint")
    def max_pods_constraint(self) -> pulumi.Output['outputs.AzureNodePoolMaxPodsConstraint']:
        """
        The constraint on the maximum number of pods that can be run simultaneously on a node in the node pool.
        """
        return pulumi.get(self, "max_pods_constraint")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of this resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The project for the resource
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def reconciling(self) -> pulumi.Output[builtins.bool]:
        """
        Output only. If set, there are currently pending changes to the node pool.
        """
        return pulumi.get(self, "reconciling")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The current state of the node pool. Possible values: STATE_UNSPECIFIED, PROVISIONING, RUNNING, RECONCILING, STOPPING, ERROR, DEGRADED
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        The ARM ID of the subnet where the node pool VMs run. Make sure it's a subnet under the virtual network in the cluster configuration.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        Output only. A globally unique identifier for the node pool.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The time at which this node pool was last updated.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        The Kubernetes version (e.g. `1.19.10-gke.1000`) running on this node pool.
        """
        return pulumi.get(self, "version")

