# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NoteArgs', 'Note']

@pulumi.input_type
class NoteArgs:
    def __init__(__self__, *,
                 attestation_authority: pulumi.Input['NoteAttestationAuthorityArgs'],
                 expiration_time: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Note resource.
        :param pulumi.Input['NoteAttestationAuthorityArgs'] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[builtins.str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[builtins.str] long_description: A detailed description of the note
        :param pulumi.Input[builtins.str] name: The name of the note.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_description: A one sentence description of the note.
        """
        pulumi.set(__self__, "attestation_authority", attestation_authority)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if long_description is not None:
            pulumi.set(__self__, "long_description", long_description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if related_note_names is not None:
            pulumi.set(__self__, "related_note_names", related_note_names)
        if related_urls is not None:
            pulumi.set(__self__, "related_urls", related_urls)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)

    @property
    @pulumi.getter(name="attestationAuthority")
    def attestation_authority(self) -> pulumi.Input['NoteAttestationAuthorityArgs']:
        """
        Note kind that represents a logical attestation "role" or "authority".
        For example, an organization might have one AttestationAuthority for
        "QA" and one for "build". This Note is intended to act strictly as a
        grouping mechanism for the attached Occurrences (Attestations). This
        grouping mechanism also provides a security boundary, since IAM ACLs
        gate the ability for a principle to attach an Occurrence to a given
        Note. It also provides a single point of lookup to find all attached
        Attestation Occurrences, even if they don't all live in the same
        project.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority")

    @attestation_authority.setter
    def attestation_authority(self, value: pulumi.Input['NoteAttestationAuthorityArgs']):
        pulumi.set(self, "attestation_authority", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time of expiration for this note. Leave empty if note does not expire.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A detailed description of the note
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the note.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="relatedNoteNames")
    def related_note_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of other notes related to this note.
        """
        return pulumi.get(self, "related_note_names")

    @related_note_names.setter
    def related_note_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "related_note_names", value)

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]]:
        """
        URLs associated with this note and related metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "related_urls")

    @related_urls.setter
    def related_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]]):
        pulumi.set(self, "related_urls", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A one sentence description of the note.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_description", value)


@pulumi.input_type
class _NoteState:
    def __init__(__self__, *,
                 attestation_authority: Optional[pulumi.Input['NoteAttestationAuthorityArgs']] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[builtins.str]] = None,
                 kind: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Note resources.
        :param pulumi.Input['NoteAttestationAuthorityArgs'] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time this note was created.
        :param pulumi.Input[builtins.str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[builtins.str] kind: The type of analysis this note describes
        :param pulumi.Input[builtins.str] long_description: A detailed description of the note
        :param pulumi.Input[builtins.str] name: The name of the note.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_description: A one sentence description of the note.
        :param pulumi.Input[builtins.str] update_time: The time this note was last updated.
        """
        if attestation_authority is not None:
            pulumi.set(__self__, "attestation_authority", attestation_authority)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if long_description is not None:
            pulumi.set(__self__, "long_description", long_description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if related_note_names is not None:
            pulumi.set(__self__, "related_note_names", related_note_names)
        if related_urls is not None:
            pulumi.set(__self__, "related_urls", related_urls)
        if short_description is not None:
            pulumi.set(__self__, "short_description", short_description)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="attestationAuthority")
    def attestation_authority(self) -> Optional[pulumi.Input['NoteAttestationAuthorityArgs']]:
        """
        Note kind that represents a logical attestation "role" or "authority".
        For example, an organization might have one AttestationAuthority for
        "QA" and one for "build". This Note is intended to act strictly as a
        grouping mechanism for the attached Occurrences (Attestations). This
        grouping mechanism also provides a security boundary, since IAM ACLs
        gate the ability for a principle to attach an Occurrence to a given
        Note. It also provides a single point of lookup to find all attached
        Attestation Occurrences, even if they don't all live in the same
        project.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority")

    @attestation_authority.setter
    def attestation_authority(self, value: Optional[pulumi.Input['NoteAttestationAuthorityArgs']]):
        pulumi.set(self, "attestation_authority", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this note was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time of expiration for this note. Leave empty if note does not expire.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of analysis this note describes
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A detailed description of the note
        """
        return pulumi.get(self, "long_description")

    @long_description.setter
    def long_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "long_description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the note.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="relatedNoteNames")
    def related_note_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Names of other notes related to this note.
        """
        return pulumi.get(self, "related_note_names")

    @related_note_names.setter
    def related_note_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "related_note_names", value)

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]]:
        """
        URLs associated with this note and related metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "related_urls")

    @related_urls.setter
    def related_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NoteRelatedUrlArgs']]]]):
        pulumi.set(self, "related_urls", value)

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A one sentence description of the note.
        """
        return pulumi.get(self, "short_description")

    @short_description.setter
    def short_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_description", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this note was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:containeranalysis/note:Note")
class Note(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority: Optional[pulumi.Input[Union['NoteAttestationAuthorityArgs', 'NoteAttestationAuthorityArgsDict']]] = None,
                 expiration_time: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NoteRelatedUrlArgs', 'NoteRelatedUrlArgsDict']]]]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A Container Analysis note is a high-level piece of metadata that
        describes a type of analysis that can be done for a resource.

        To get more information about Note, see:

        * [API documentation](https://cloud.google.com/container-analysis/api/reference/rest/)
        * How-to Guides
            * [Creating Attestations (Occurrences)](https://cloud.google.com/binary-authorization/docs/making-attestations)
            * [Official Documentation](https://cloud.google.com/container-analysis/)

        ## Example Usage

        ### Container Analysis Note Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note",
            name="attestor-note",
            attestation_authority={
                "hint": {
                    "human_readable_name": "Attestor Note",
                },
            })
        ```
        ### Container Analysis Note Attestation Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note",
            name="attestor-note",
            short_description="test note",
            long_description="a longer description of test note",
            expiration_time="2120-10-02T15:01:23.045123456Z",
            related_urls=[
                {
                    "url": "some.url",
                    "label": "foo",
                },
                {
                    "url": "google.com",
                },
            ],
            attestation_authority={
                "hint": {
                    "human_readable_name": "Attestor Note",
                },
            })
        ```

        ## Import

        Note can be imported using any of these accepted formats:

        * `projects/{{project}}/notes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Note can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default projects/{{project}}/notes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NoteAttestationAuthorityArgs', 'NoteAttestationAuthorityArgsDict']] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[builtins.str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[builtins.str] long_description: A detailed description of the note
        :param pulumi.Input[builtins.str] name: The name of the note.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NoteRelatedUrlArgs', 'NoteRelatedUrlArgsDict']]]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_description: A one sentence description of the note.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NoteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Container Analysis note is a high-level piece of metadata that
        describes a type of analysis that can be done for a resource.

        To get more information about Note, see:

        * [API documentation](https://cloud.google.com/container-analysis/api/reference/rest/)
        * How-to Guides
            * [Creating Attestations (Occurrences)](https://cloud.google.com/binary-authorization/docs/making-attestations)
            * [Official Documentation](https://cloud.google.com/container-analysis/)

        ## Example Usage

        ### Container Analysis Note Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note",
            name="attestor-note",
            attestation_authority={
                "hint": {
                    "human_readable_name": "Attestor Note",
                },
            })
        ```
        ### Container Analysis Note Attestation Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note",
            name="attestor-note",
            short_description="test note",
            long_description="a longer description of test note",
            expiration_time="2120-10-02T15:01:23.045123456Z",
            related_urls=[
                {
                    "url": "some.url",
                    "label": "foo",
                },
                {
                    "url": "google.com",
                },
            ],
            attestation_authority={
                "hint": {
                    "human_readable_name": "Attestor Note",
                },
            })
        ```

        ## Import

        Note can be imported using any of these accepted formats:

        * `projects/{{project}}/notes/{{name}}`

        * `{{project}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Note can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default projects/{{project}}/notes/{{name}}
        ```

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default {{project}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:containeranalysis/note:Note default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param NoteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NoteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority: Optional[pulumi.Input[Union['NoteAttestationAuthorityArgs', 'NoteAttestationAuthorityArgsDict']]] = None,
                 expiration_time: Optional[pulumi.Input[builtins.str]] = None,
                 long_description: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 related_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NoteRelatedUrlArgs', 'NoteRelatedUrlArgsDict']]]]] = None,
                 short_description: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NoteArgs.__new__(NoteArgs)

            if attestation_authority is None and not opts.urn:
                raise TypeError("Missing required property 'attestation_authority'")
            __props__.__dict__["attestation_authority"] = attestation_authority
            __props__.__dict__["expiration_time"] = expiration_time
            __props__.__dict__["long_description"] = long_description
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["related_note_names"] = related_note_names
            __props__.__dict__["related_urls"] = related_urls
            __props__.__dict__["short_description"] = short_description
            __props__.__dict__["create_time"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["update_time"] = None
        super(Note, __self__).__init__(
            'gcp:containeranalysis/note:Note',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attestation_authority: Optional[pulumi.Input[Union['NoteAttestationAuthorityArgs', 'NoteAttestationAuthorityArgsDict']]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            expiration_time: Optional[pulumi.Input[builtins.str]] = None,
            kind: Optional[pulumi.Input[builtins.str]] = None,
            long_description: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            related_note_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            related_urls: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NoteRelatedUrlArgs', 'NoteRelatedUrlArgsDict']]]]] = None,
            short_description: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Note':
        """
        Get an existing Note resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NoteAttestationAuthorityArgs', 'NoteAttestationAuthorityArgsDict']] attestation_authority: Note kind that represents a logical attestation "role" or "authority".
               For example, an organization might have one AttestationAuthority for
               "QA" and one for "build". This Note is intended to act strictly as a
               grouping mechanism for the attached Occurrences (Attestations). This
               grouping mechanism also provides a security boundary, since IAM ACLs
               gate the ability for a principle to attach an Occurrence to a given
               Note. It also provides a single point of lookup to find all attached
               Attestation Occurrences, even if they don't all live in the same
               project.
               Structure is documented below.
        :param pulumi.Input[builtins.str] create_time: The time this note was created.
        :param pulumi.Input[builtins.str] expiration_time: Time of expiration for this note. Leave empty if note does not expire.
        :param pulumi.Input[builtins.str] kind: The type of analysis this note describes
        :param pulumi.Input[builtins.str] long_description: A detailed description of the note
        :param pulumi.Input[builtins.str] name: The name of the note.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] related_note_names: Names of other notes related to this note.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NoteRelatedUrlArgs', 'NoteRelatedUrlArgsDict']]]] related_urls: URLs associated with this note and related metadata.
               Structure is documented below.
        :param pulumi.Input[builtins.str] short_description: A one sentence description of the note.
        :param pulumi.Input[builtins.str] update_time: The time this note was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NoteState.__new__(_NoteState)

        __props__.__dict__["attestation_authority"] = attestation_authority
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["kind"] = kind
        __props__.__dict__["long_description"] = long_description
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["related_note_names"] = related_note_names
        __props__.__dict__["related_urls"] = related_urls
        __props__.__dict__["short_description"] = short_description
        __props__.__dict__["update_time"] = update_time
        return Note(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attestationAuthority")
    def attestation_authority(self) -> pulumi.Output['outputs.NoteAttestationAuthority']:
        """
        Note kind that represents a logical attestation "role" or "authority".
        For example, an organization might have one AttestationAuthority for
        "QA" and one for "build". This Note is intended to act strictly as a
        grouping mechanism for the attached Occurrences (Attestations). This
        grouping mechanism also provides a security boundary, since IAM ACLs
        gate the ability for a principle to attach an Occurrence to a given
        Note. It also provides a single point of lookup to find all attached
        Attestation Occurrences, even if they don't all live in the same
        project.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time this note was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Time of expiration for this note. Leave empty if note does not expire.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[builtins.str]:
        """
        The type of analysis this note describes
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A detailed description of the note
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the note.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="relatedNoteNames")
    def related_note_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Names of other notes related to this note.
        """
        return pulumi.get(self, "related_note_names")

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> pulumi.Output[Optional[Sequence['outputs.NoteRelatedUrl']]]:
        """
        URLs associated with this note and related metadata.
        Structure is documented below.
        """
        return pulumi.get(self, "related_urls")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A one sentence description of the note.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time this note was last updated.
        """
        return pulumi.get(self, "update_time")

