# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ConnectionProfileAlloydbArgs',
    'ConnectionProfileAlloydbArgsDict',
    'ConnectionProfileAlloydbSettingsArgs',
    'ConnectionProfileAlloydbSettingsArgsDict',
    'ConnectionProfileAlloydbSettingsInitialUserArgs',
    'ConnectionProfileAlloydbSettingsInitialUserArgsDict',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgsDict',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs',
    'ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgsDict',
    'ConnectionProfileCloudsqlArgs',
    'ConnectionProfileCloudsqlArgsDict',
    'ConnectionProfileCloudsqlSettingsArgs',
    'ConnectionProfileCloudsqlSettingsArgsDict',
    'ConnectionProfileCloudsqlSettingsIpConfigArgs',
    'ConnectionProfileCloudsqlSettingsIpConfigArgsDict',
    'ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs',
    'ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgsDict',
    'ConnectionProfileErrorArgs',
    'ConnectionProfileErrorArgsDict',
    'ConnectionProfileMysqlArgs',
    'ConnectionProfileMysqlArgsDict',
    'ConnectionProfileMysqlSslArgs',
    'ConnectionProfileMysqlSslArgsDict',
    'ConnectionProfileOracleArgs',
    'ConnectionProfileOracleArgsDict',
    'ConnectionProfileOracleForwardSshConnectivityArgs',
    'ConnectionProfileOracleForwardSshConnectivityArgsDict',
    'ConnectionProfileOraclePrivateConnectivityArgs',
    'ConnectionProfileOraclePrivateConnectivityArgsDict',
    'ConnectionProfileOracleSslArgs',
    'ConnectionProfileOracleSslArgsDict',
    'ConnectionProfileOracleStaticServiceIpConnectivityArgs',
    'ConnectionProfileOracleStaticServiceIpConnectivityArgsDict',
    'ConnectionProfilePostgresqlArgs',
    'ConnectionProfilePostgresqlArgsDict',
    'ConnectionProfilePostgresqlSslArgs',
    'ConnectionProfilePostgresqlSslArgsDict',
    'MigrationJobDumpFlagsArgs',
    'MigrationJobDumpFlagsArgsDict',
    'MigrationJobDumpFlagsDumpFlagArgs',
    'MigrationJobDumpFlagsDumpFlagArgsDict',
    'MigrationJobErrorArgs',
    'MigrationJobErrorArgsDict',
    'MigrationJobPerformanceConfigArgs',
    'MigrationJobPerformanceConfigArgsDict',
    'MigrationJobReverseSshConnectivityArgs',
    'MigrationJobReverseSshConnectivityArgsDict',
    'MigrationJobStaticIpConnectivityArgs',
    'MigrationJobStaticIpConnectivityArgsDict',
    'MigrationJobVpcPeeringConnectivityArgs',
    'MigrationJobVpcPeeringConnectivityArgsDict',
    'PrivateConnectionErrorArgs',
    'PrivateConnectionErrorArgsDict',
    'PrivateConnectionVpcPeeringConfigArgs',
    'PrivateConnectionVpcPeeringConfigArgsDict',
]

MYPY = False

if not MYPY:
    class ConnectionProfileAlloydbArgsDict(TypedDict):
        cluster_id: pulumi.Input[builtins.str]
        """
        Required. The AlloyDB cluster ID that this connection profile is associated with.
        """
        settings: NotRequired[pulumi.Input['ConnectionProfileAlloydbSettingsArgsDict']]
        """
        Immutable. Metadata used to create the destination AlloyDB cluster.
        Structure is documented below.
        """
elif False:
    ConnectionProfileAlloydbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileAlloydbArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[builtins.str],
                 settings: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']] = None):
        """
        :param pulumi.Input[builtins.str] cluster_id: Required. The AlloyDB cluster ID that this connection profile is associated with.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsArgs'] settings: Immutable. Metadata used to create the destination AlloyDB cluster.
               Structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[builtins.str]:
        """
        Required. The AlloyDB cluster ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']]:
        """
        Immutable. Metadata used to create the destination AlloyDB cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsArgs']]):
        pulumi.set(self, "settings", value)


if not MYPY:
    class ConnectionProfileAlloydbSettingsArgsDict(TypedDict):
        initial_user: pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgsDict']
        """
        Required. Input only. Initial user to setup during cluster creation.
        Structure is documented below.
        """
        vpc_network: pulumi.Input[builtins.str]
        """
        Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Labels for the AlloyDB cluster created by DMS.
        """
        primary_instance_settings: NotRequired[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgsDict']]
        """
        Settings for the cluster's primary instance
        Structure is documented below.
        """
elif False:
    ConnectionProfileAlloydbSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileAlloydbSettingsArgs:
    def __init__(__self__, *,
                 initial_user: pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs'],
                 vpc_network: pulumi.Input[builtins.str],
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 primary_instance_settings: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']] = None):
        """
        :param pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs'] initial_user: Required. Input only. Initial user to setup during cluster creation.
               Structure is documented below.
        :param pulumi.Input[builtins.str] vpc_network: Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
               It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for the AlloyDB cluster created by DMS.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs'] primary_instance_settings: Settings for the cluster's primary instance
               Structure is documented below.
        """
        pulumi.set(__self__, "initial_user", initial_user)
        pulumi.set(__self__, "vpc_network", vpc_network)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if primary_instance_settings is not None:
            pulumi.set(__self__, "primary_instance_settings", primary_instance_settings)

    @property
    @pulumi.getter(name="initialUser")
    def initial_user(self) -> pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs']:
        """
        Required. Input only. Initial user to setup during cluster creation.
        Structure is documented below.
        """
        return pulumi.get(self, "initial_user")

    @initial_user.setter
    def initial_user(self, value: pulumi.Input['ConnectionProfileAlloydbSettingsInitialUserArgs']):
        pulumi.set(self, "initial_user", value)

    @property
    @pulumi.getter(name="vpcNetwork")
    def vpc_network(self) -> pulumi.Input[builtins.str]:
        """
        Required. The resource link for the VPC network in which cluster resources are created and from which they are accessible via Private IP. The network must belong to the same project as the cluster.
        It is specified in the form: 'projects/{project_number}/global/networks/{network_id}'. This is required to create a cluster.
        """
        return pulumi.get(self, "vpc_network")

    @vpc_network.setter
    def vpc_network(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_network", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for the AlloyDB cluster created by DMS.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="primaryInstanceSettings")
    def primary_instance_settings(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']]:
        """
        Settings for the cluster's primary instance
        Structure is documented below.
        """
        return pulumi.get(self, "primary_instance_settings")

    @primary_instance_settings.setter
    def primary_instance_settings(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs']]):
        pulumi.set(self, "primary_instance_settings", value)


if not MYPY:
    class ConnectionProfileAlloydbSettingsInitialUserArgsDict(TypedDict):
        password: pulumi.Input[builtins.str]
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        user: pulumi.Input[builtins.str]
        """
        The database username.
        """
        password_set: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Output)
        Output only. Indicates if the initialUser.password field has been set.
        """
elif False:
    ConnectionProfileAlloydbSettingsInitialUserArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileAlloydbSettingsInitialUserArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[builtins.str],
                 user: pulumi.Input[builtins.str],
                 password_set: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[builtins.str] password: The initial password for the user.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] user: The database username.
        :param pulumi.Input[builtins.bool] password_set: (Output)
               Output only. Indicates if the initialUser.password field has been set.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user", user)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        The initial password for the user.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> pulumi.Input[builtins.str]:
        """
        The database username.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Output)
        Output only. Indicates if the initialUser.password field has been set.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "password_set", value)


if not MYPY:
    class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgsDict(TypedDict):
        id: pulumi.Input[builtins.str]
        """
        The database username.
        """
        machine_config: pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgsDict']
        """
        Configuration for the machines that host the underlying database engine.
        Structure is documented below.
        """
        database_flags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        """
        labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        Labels for the AlloyDB primary instance created by DMS.
        """
        private_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
elif False:
    ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[builtins.str],
                 machine_config: pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs'],
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] id: The database username.
        :param pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs'] machine_config: Configuration for the machines that host the underlying database engine.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] database_flags: Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Labels for the AlloyDB primary instance created by DMS.
        :param pulumi.Input[builtins.str] private_ip: (Output)
               Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "machine_config", machine_config)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[builtins.str]:
        """
        The database username.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="machineConfig")
    def machine_config(self) -> pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs']:
        """
        Configuration for the machines that host the underlying database engine.
        Structure is documented below.
        """
        return pulumi.get(self, "machine_config")

    @machine_config.setter
    def machine_config(self, value: pulumi.Input['ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs']):
        pulumi.set(self, "machine_config", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Database flags to pass to AlloyDB when DMS is creating the AlloyDB cluster and instances. See the AlloyDB documentation for how these can be used.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Labels for the AlloyDB primary instance created by DMS.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The private IP address for the Instance. This is the connection endpoint for an end-user application.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)


if not MYPY:
    class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgsDict(TypedDict):
        cpu_count: pulumi.Input[builtins.int]
        """
        The number of CPU's in the VM instance.
        """
elif False:
    ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileAlloydbSettingsPrimaryInstanceSettingsMachineConfigArgs:
    def __init__(__self__, *,
                 cpu_count: pulumi.Input[builtins.int]):
        """
        :param pulumi.Input[builtins.int] cpu_count: The number of CPU's in the VM instance.
        """
        pulumi.set(__self__, "cpu_count", cpu_count)

    @property
    @pulumi.getter(name="cpuCount")
    def cpu_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of CPU's in the VM instance.
        """
        return pulumi.get(self, "cpu_count")

    @cpu_count.setter
    def cpu_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "cpu_count", value)


if not MYPY:
    class ConnectionProfileCloudsqlArgsDict(TypedDict):
        cloud_sql_id: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The Cloud SQL instance ID that this connection profile is associated with.
        """
        private_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The Cloud SQL database instance's private IP.
        """
        public_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. The Cloud SQL database instance's public IP.
        """
        settings: NotRequired[pulumi.Input['ConnectionProfileCloudsqlSettingsArgsDict']]
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        Structure is documented below.
        """
elif False:
    ConnectionProfileCloudsqlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileCloudsqlArgs:
    def __init__(__self__, *,
                 cloud_sql_id: Optional[pulumi.Input[builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[builtins.str]] = None,
                 settings: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']] = None):
        """
        :param pulumi.Input[builtins.str] cloud_sql_id: (Output)
               Output only. The Cloud SQL instance ID that this connection profile is associated with.
        :param pulumi.Input[builtins.str] private_ip: (Output)
               Output only. The Cloud SQL database instance's private IP.
        :param pulumi.Input[builtins.str] public_ip: (Output)
               Output only. The Cloud SQL database instance's public IP.
        :param pulumi.Input['ConnectionProfileCloudsqlSettingsArgs'] settings: Immutable. Metadata used to create the destination Cloud SQL database.
               Structure is documented below.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The Cloud SQL instance ID that this connection profile is associated with.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The Cloud SQL database instance's private IP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. The Cloud SQL database instance's public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']]:
        """
        Immutable. Metadata used to create the destination Cloud SQL database.
        Structure is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsArgs']]):
        pulumi.set(self, "settings", value)


if not MYPY:
    class ConnectionProfileCloudsqlSettingsArgsDict(TypedDict):
        source_id: pulumi.Input[builtins.str]
        """
        The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        """
        activation_policy: NotRequired[pulumi.Input[builtins.str]]
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
        Possible values are: `ALWAYS`, `NEVER`.
        """
        auto_storage_increase: NotRequired[pulumi.Input[builtins.bool]]
        """
        If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
        If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        cmek_key_name: NotRequired[pulumi.Input[builtins.str]]
        """
        The KMS key name used for the csql instance.
        """
        collation: NotRequired[pulumi.Input[builtins.str]]
        """
        The Cloud SQL default instance level collation.
        """
        data_disk_size_gb: NotRequired[pulumi.Input[builtins.str]]
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        data_disk_type: NotRequired[pulumi.Input[builtins.str]]
        """
        The type of storage.
        Possible values are: `PD_SSD`, `PD_HDD`.
        """
        database_flags: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The database flags passed to the Cloud SQL instance at startup.
        """
        database_version: NotRequired[pulumi.Input[builtins.str]]
        """
        The database engine type and version.
        Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        """
        edition: NotRequired[pulumi.Input[builtins.str]]
        """
        The edition of the given Cloud SQL instance.
        Possible values are: `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        ip_config: NotRequired[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgsDict']]
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        Structure is documented below.
        """
        root_password: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. Initial root password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        root_password_set: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Output)
        Output only. Indicates If this connection profile root password is stored.
        """
        storage_auto_resize_limit: NotRequired[pulumi.Input[builtins.str]]
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        tier: NotRequired[pulumi.Input[builtins.str]]
        """
        The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
        For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        """
        user_labels: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        zone: NotRequired[pulumi.Input[builtins.str]]
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
elif False:
    ConnectionProfileCloudsqlSettingsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileCloudsqlSettingsArgs:
    def __init__(__self__, *,
                 source_id: pulumi.Input[builtins.str],
                 activation_policy: Optional[pulumi.Input[builtins.str]] = None,
                 auto_storage_increase: Optional[pulumi.Input[builtins.bool]] = None,
                 cmek_key_name: Optional[pulumi.Input[builtins.str]] = None,
                 collation: Optional[pulumi.Input[builtins.str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[builtins.str]] = None,
                 data_disk_type: Optional[pulumi.Input[builtins.str]] = None,
                 database_flags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 database_version: Optional[pulumi.Input[builtins.str]] = None,
                 edition: Optional[pulumi.Input[builtins.str]] = None,
                 ip_config: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']] = None,
                 root_password: Optional[pulumi.Input[builtins.str]] = None,
                 root_password_set: Optional[pulumi.Input[builtins.bool]] = None,
                 storage_auto_resize_limit: Optional[pulumi.Input[builtins.str]] = None,
                 tier: Optional[pulumi.Input[builtins.str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] source_id: The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        :param pulumi.Input[builtins.str] activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
               Possible values are: `ALWAYS`, `NEVER`.
        :param pulumi.Input[builtins.bool] auto_storage_increase: If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
               If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        :param pulumi.Input[builtins.str] cmek_key_name: The KMS key name used for the csql instance.
        :param pulumi.Input[builtins.str] collation: The Cloud SQL default instance level collation.
        :param pulumi.Input[builtins.str] data_disk_size_gb: The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        :param pulumi.Input[builtins.str] data_disk_type: The type of storage.
               Possible values are: `PD_SSD`, `PD_HDD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] database_flags: The database flags passed to the Cloud SQL instance at startup.
        :param pulumi.Input[builtins.str] database_version: The database engine type and version.
               Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        :param pulumi.Input[builtins.str] edition: The edition of the given Cloud SQL instance.
               Possible values are: `ENTERPRISE`, `ENTERPRISE_PLUS`.
        :param pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs'] ip_config: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
               Structure is documented below.
        :param pulumi.Input[builtins.str] root_password: Input only. Initial root password.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.bool] root_password_set: (Output)
               Output only. Indicates If this connection profile root password is stored.
        :param pulumi.Input[builtins.str] storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[builtins.str] tier: The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
               For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] user_labels: The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        :param pulumi.Input[builtins.str] zone: The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        pulumi.set(__self__, "source_id", source_id)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if auto_storage_increase is not None:
            pulumi.set(__self__, "auto_storage_increase", auto_storage_increase)
        if cmek_key_name is not None:
            pulumi.set(__self__, "cmek_key_name", cmek_key_name)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if ip_config is not None:
            pulumi.set(__self__, "ip_config", ip_config)
        if root_password is not None:
            pulumi.set(__self__, "root_password", root_password)
        if root_password_set is not None:
            pulumi.set(__self__, "root_password_set", root_password_set)
        if storage_auto_resize_limit is not None:
            pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[builtins.str]:
        """
        The Database Migration Service source connection profile ID, in the format: projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is 'RUNNABLE'.
        Possible values are: `ALWAYS`, `NEVER`.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="autoStorageIncrease")
    def auto_storage_increase(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If you enable this setting, Cloud SQL checks your available storage every 30 seconds. If the available storage falls below a threshold size, Cloud SQL automatically adds additional storage capacity.
        If the available storage repeatedly falls below the threshold size, Cloud SQL continues to add storage until it reaches the maximum of 30 TB.
        """
        return pulumi.get(self, "auto_storage_increase")

    @auto_storage_increase.setter
    def auto_storage_increase(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "auto_storage_increase", value)

    @property
    @pulumi.getter(name="cmekKeyName")
    def cmek_key_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The KMS key name used for the csql instance.
        """
        return pulumi.get(self, "cmek_key_name")

    @cmek_key_name.setter
    def cmek_key_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cmek_key_name", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Cloud SQL default instance level collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The storage capacity available to the database, in GB. The minimum (and default) size is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of storage.
        Possible values are: `PD_SSD`, `PD_HDD`.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The database flags passed to the Cloud SQL instance at startup.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database engine type and version.
        Currently supported values located at https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles#sqldatabaseversion
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The edition of the given Cloud SQL instance.
        Possible values are: `ENTERPRISE`, `ENTERPRISE_PLUS`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter(name="ipConfig")
    def ip_config(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']]:
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled.
        Structure is documented below.
        """
        return pulumi.get(self, "ip_config")

    @ip_config.setter
    def ip_config(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigArgs']]):
        pulumi.set(self, "ip_config", value)

    @property
    @pulumi.getter(name="rootPassword")
    def root_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. Initial root password.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "root_password")

    @root_password.setter
    def root_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "root_password", value)

    @property
    @pulumi.getter(name="rootPasswordSet")
    def root_password_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile root password is stored.
        """
        return pulumi.get(self, "root_password_set")

    @root_password_set.setter
    def root_password_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "root_password_set", value)

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @storage_auto_resize_limit.setter
    def storage_auto_resize_limit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "storage_auto_resize_limit", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The tier (or machine type) for this instance, for example: db-n1-standard-1 (MySQL instances) or db-custom-1-3840 (PostgreSQL instances).
        For more information, see https://cloud.google.com/sql/docs/mysql/instance-settings
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for a Cloud SQL instance to use to annotate any related underlying resources such as Compute Engine VMs.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "user_labels", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Google Cloud Platform zone where your Cloud SQL datdabse instance is located.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


if not MYPY:
    class ConnectionProfileCloudsqlSettingsIpConfigArgsDict(TypedDict):
        authorized_networks: NotRequired[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgsDict']]]]
        """
        The list of external networks that are allowed to connect to the instance using the IP.
        Structure is documented below.
        """
        enable_ipv4: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        private_network: NotRequired[pulumi.Input[builtins.str]]
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        This setting can be updated, but it cannot be removed after it is set.
        """
        require_ssl: NotRequired[pulumi.Input[builtins.bool]]
        """
        Whether SSL connections over IP should be enforced or not.
        """
elif False:
    ConnectionProfileCloudsqlSettingsIpConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileCloudsqlSettingsIpConfigArgs:
    def __init__(__self__, *,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]] = None,
                 enable_ipv4: Optional[pulumi.Input[builtins.bool]] = None,
                 private_network: Optional[pulumi.Input[builtins.str]] = None,
                 require_ssl: Optional[pulumi.Input[builtins.bool]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] enable_ipv4: Whether the instance should be assigned an IPv4 address or not.
        :param pulumi.Input[builtins.str] private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[builtins.bool] require_ssl: Whether SSL connections over IP should be enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if enable_ipv4 is not None:
            pulumi.set(__self__, "enable_ipv4", enable_ipv4)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]]:
        """
        The list of external networks that are allowed to connect to the instance using the IP.
        Structure is documented below.
        """
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="enableIpv4")
    def enable_ipv4(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the instance should be assigned an IPv4 address or not.
        """
        return pulumi.get(self, "enable_ipv4")

    @enable_ipv4.setter
    def enable_ipv4(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_ipv4", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether SSL connections over IP should be enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "require_ssl", value)


if not MYPY:
    class ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgsDict(TypedDict):
        value: pulumi.Input[builtins.str]
        """
        The allowlisted value for the access control list.
        """
        expire_time: NotRequired[pulumi.Input[builtins.str]]
        """
        The time when this access control entry expires in RFC 3339 format.
        """
        label: NotRequired[pulumi.Input[builtins.str]]
        """
        A label to identify this entry.
        """
        ttl: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The time-to-leave of this access control entry.
        """
elif False:
    ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileCloudsqlSettingsIpConfigAuthorizedNetworkArgs:
    def __init__(__self__, *,
                 value: pulumi.Input[builtins.str],
                 expire_time: Optional[pulumi.Input[builtins.str]] = None,
                 label: Optional[pulumi.Input[builtins.str]] = None,
                 ttl: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] value: The allowlisted value for the access control list.
        :param pulumi.Input[builtins.str] expire_time: The time when this access control entry expires in RFC 3339 format.
        :param pulumi.Input[builtins.str] label: A label to identify this entry.
        :param pulumi.Input[builtins.str] ttl: Input only. The time-to-leave of this access control entry.
        """
        pulumi.set(__self__, "value", value)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)
        if label is not None:
            pulumi.set(__self__, "label", label)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[builtins.str]:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when this access control entry expires in RFC 3339 format.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expire_time", value)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A label to identify this entry.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The time-to-leave of this access control entry.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ttl", value)


if not MYPY:
    class ConnectionProfileErrorArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        details: NotRequired[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]
        """
        (Output)
        A list of messages that carry the error details.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Human readable message indicating details about the current status.
        """
elif False:
    ConnectionProfileErrorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[builtins.int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] details: (Output)
               A list of messages that carry the error details.
        :param pulumi.Input[builtins.str] message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class ConnectionProfileMysqlArgsDict(TypedDict):
        cloud_sql_id: NotRequired[pulumi.Input[builtins.str]]
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP or hostname of the source MySQL database.
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        password_set: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The network port of the source MySQL database.
        """
        ssl: NotRequired[pulumi.Input['ConnectionProfileMysqlSslArgsDict']]
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
elif False:
    ConnectionProfileMysqlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileMysqlArgs:
    def __init__(__self__, *,
                 cloud_sql_id: Optional[pulumi.Input[builtins.str]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_set: Optional[pulumi.Input[builtins.bool]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 ssl: Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[builtins.str] host: The IP or hostname of the source MySQL database.
        :param pulumi.Input[builtins.str] password: Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.bool] password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param pulumi.Input[builtins.int] port: The network port of the source MySQL database.
        :param pulumi.Input['ConnectionProfileMysqlSslArgs'] ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "password_set", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['ConnectionProfileMysqlSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionProfileMysqlSslArgsDict(TypedDict):
        ca_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The current connection profile state.
        """
elif False:
    ConnectionProfileMysqlSslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileMysqlSslArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ca_certificate: Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] type: (Output)
               The current connection profile state.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ConnectionProfileOracleArgsDict(TypedDict):
        database_service: pulumi.Input[builtins.str]
        """
        Required. Database service for the Oracle connection.
        """
        host: pulumi.Input[builtins.str]
        """
        Required. The IP or hostname of the source Oracle database.
        """
        password: pulumi.Input[builtins.str]
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        port: pulumi.Input[builtins.int]
        """
        Required. The network port of the source Oracle database.
        """
        username: pulumi.Input[builtins.str]
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        forward_ssh_connectivity: NotRequired[pulumi.Input['ConnectionProfileOracleForwardSshConnectivityArgsDict']]
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        password_set: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        private_connectivity: NotRequired[pulumi.Input['ConnectionProfileOraclePrivateConnectivityArgsDict']]
        """
        Configuration for using a private network to communicate with the source database
        Structure is documented below.
        """
        ssl: NotRequired[pulumi.Input['ConnectionProfileOracleSslArgsDict']]
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        static_service_ip_connectivity: NotRequired[pulumi.Input['ConnectionProfileOracleStaticServiceIpConnectivityArgsDict']]
        """
        This object has no nested fields.
        Static IP address connectivity configured on service project.
        """
elif False:
    ConnectionProfileOracleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileOracleArgs:
    def __init__(__self__, *,
                 database_service: pulumi.Input[builtins.str],
                 host: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 username: pulumi.Input[builtins.str],
                 forward_ssh_connectivity: Optional[pulumi.Input['ConnectionProfileOracleForwardSshConnectivityArgs']] = None,
                 password_set: Optional[pulumi.Input[builtins.bool]] = None,
                 private_connectivity: Optional[pulumi.Input['ConnectionProfileOraclePrivateConnectivityArgs']] = None,
                 ssl: Optional[pulumi.Input['ConnectionProfileOracleSslArgs']] = None,
                 static_service_ip_connectivity: Optional[pulumi.Input['ConnectionProfileOracleStaticServiceIpConnectivityArgs']] = None):
        """
        :param pulumi.Input[builtins.str] database_service: Required. Database service for the Oracle connection.
        :param pulumi.Input[builtins.str] host: Required. The IP or hostname of the source Oracle database.
        :param pulumi.Input[builtins.str] password: Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.int] port: Required. The network port of the source Oracle database.
        :param pulumi.Input[builtins.str] username: Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        :param pulumi.Input['ConnectionProfileOracleForwardSshConnectivityArgs'] forward_ssh_connectivity: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param pulumi.Input[builtins.bool] password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param pulumi.Input['ConnectionProfileOraclePrivateConnectivityArgs'] private_connectivity: Configuration for using a private network to communicate with the source database
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileOracleSslArgs'] ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileOracleStaticServiceIpConnectivityArgs'] static_service_ip_connectivity: This object has no nested fields.
               Static IP address connectivity configured on service project.
        """
        pulumi.set(__self__, "database_service", database_service)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if forward_ssh_connectivity is not None:
            pulumi.set(__self__, "forward_ssh_connectivity", forward_ssh_connectivity)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if private_connectivity is not None:
            pulumi.set(__self__, "private_connectivity", private_connectivity)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if static_service_ip_connectivity is not None:
            pulumi.set(__self__, "static_service_ip_connectivity", static_service_ip_connectivity)

    @property
    @pulumi.getter(name="databaseService")
    def database_service(self) -> pulumi.Input[builtins.str]:
        """
        Required. Database service for the Oracle connection.
        """
        return pulumi.get(self, "database_service")

    @database_service.setter
    def database_service(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "database_service", value)

    @property
    @pulumi.getter
    def host(self) -> pulumi.Input[builtins.str]:
        """
        Required. The IP or hostname of the source Oracle database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        Required. Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        Required. The network port of the source Oracle database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Required. The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="forwardSshConnectivity")
    def forward_ssh_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileOracleForwardSshConnectivityArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "forward_ssh_connectivity")

    @forward_ssh_connectivity.setter
    def forward_ssh_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileOracleForwardSshConnectivityArgs']]):
        pulumi.set(self, "forward_ssh_connectivity", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "password_set", value)

    @property
    @pulumi.getter(name="privateConnectivity")
    def private_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileOraclePrivateConnectivityArgs']]:
        """
        Configuration for using a private network to communicate with the source database
        Structure is documented below.
        """
        return pulumi.get(self, "private_connectivity")

    @private_connectivity.setter
    def private_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileOraclePrivateConnectivityArgs']]):
        pulumi.set(self, "private_connectivity", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['ConnectionProfileOracleSslArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['ConnectionProfileOracleSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter(name="staticServiceIpConnectivity")
    def static_service_ip_connectivity(self) -> Optional[pulumi.Input['ConnectionProfileOracleStaticServiceIpConnectivityArgs']]:
        """
        This object has no nested fields.
        Static IP address connectivity configured on service project.
        """
        return pulumi.get(self, "static_service_ip_connectivity")

    @static_service_ip_connectivity.setter
    def static_service_ip_connectivity(self, value: Optional[pulumi.Input['ConnectionProfileOracleStaticServiceIpConnectivityArgs']]):
        pulumi.set(self, "static_service_ip_connectivity", value)


if not MYPY:
    class ConnectionProfileOracleForwardSshConnectivityArgsDict(TypedDict):
        hostname: pulumi.Input[builtins.str]
        """
        Required. Hostname for the SSH tunnel.
        """
        port: pulumi.Input[builtins.int]
        """
        Port for the SSH tunnel, default value is 22.
        """
        username: pulumi.Input[builtins.str]
        """
        Required. Username for the SSH tunnel.
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. SSH password. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        private_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. SSH private key. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
elif False:
    ConnectionProfileOracleForwardSshConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileOracleForwardSshConnectivityArgs:
    def __init__(__self__, *,
                 hostname: pulumi.Input[builtins.str],
                 port: pulumi.Input[builtins.int],
                 username: pulumi.Input[builtins.str],
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 private_key: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] hostname: Required. Hostname for the SSH tunnel.
        :param pulumi.Input[builtins.int] port: Port for the SSH tunnel, default value is 22.
        :param pulumi.Input[builtins.str] username: Required. Username for the SSH tunnel.
        :param pulumi.Input[builtins.str] password: Input only. SSH password. Only one of `password` and `private_key` can be configured.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] private_key: Input only. SSH private key. Only one of `password` and `private_key` can be configured.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "username", username)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[builtins.str]:
        """
        Required. Hostname for the SSH tunnel.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[builtins.int]:
        """
        Port for the SSH tunnel, default value is 22.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        Required. Username for the SSH tunnel.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. SSH password. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. SSH private key. Only one of `password` and `private_key` can be configured.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_key", value)


if not MYPY:
    class ConnectionProfileOraclePrivateConnectivityArgsDict(TypedDict):
        private_connection: pulumi.Input[builtins.str]
        """
        Required. The resource name (URI) of the private connection.
        """
elif False:
    ConnectionProfileOraclePrivateConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileOraclePrivateConnectivityArgs:
    def __init__(__self__, *,
                 private_connection: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] private_connection: Required. The resource name (URI) of the private connection.
        """
        pulumi.set(__self__, "private_connection", private_connection)

    @property
    @pulumi.getter(name="privateConnection")
    def private_connection(self) -> pulumi.Input[builtins.str]:
        """
        Required. The resource name (URI) of the private connection.
        """
        return pulumi.get(self, "private_connection")

    @private_connection.setter
    def private_connection(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "private_connection", value)


if not MYPY:
    class ConnectionProfileOracleSslArgsDict(TypedDict):
        ca_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The current connection profile state.
        """
elif False:
    ConnectionProfileOracleSslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileOracleSslArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ca_certificate: Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] type: (Output)
               The current connection profile state.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class ConnectionProfileOracleStaticServiceIpConnectivityArgsDict(TypedDict):
        pass
elif False:
    ConnectionProfileOracleStaticServiceIpConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfileOracleStaticServiceIpConnectivityArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class ConnectionProfilePostgresqlArgsDict(TypedDict):
        alloydb_cluster_id: NotRequired[pulumi.Input[builtins.str]]
        """
        If the connected database is an AlloyDB instance, use this field to provide the AlloyDB cluster ID.
        """
        cloud_sql_id: NotRequired[pulumi.Input[builtins.str]]
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        host: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP or hostname of the source MySQL database.
        """
        network_architecture: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        """
        password: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        password_set: NotRequired[pulumi.Input[builtins.bool]]
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        port: NotRequired[pulumi.Input[builtins.int]]
        """
        The network port of the source MySQL database.
        """
        ssl: NotRequired[pulumi.Input['ConnectionProfilePostgresqlSslArgsDict']]
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        username: NotRequired[pulumi.Input[builtins.str]]
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
elif False:
    ConnectionProfilePostgresqlArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfilePostgresqlArgs:
    def __init__(__self__, *,
                 alloydb_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 cloud_sql_id: Optional[pulumi.Input[builtins.str]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 network_architecture: Optional[pulumi.Input[builtins.str]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 password_set: Optional[pulumi.Input[builtins.bool]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 ssl: Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] alloydb_cluster_id: If the connected database is an AlloyDB instance, use this field to provide the AlloyDB cluster ID.
        :param pulumi.Input[builtins.str] cloud_sql_id: If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        :param pulumi.Input[builtins.str] host: The IP or hostname of the source MySQL database.
        :param pulumi.Input[builtins.str] network_architecture: (Output)
               Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        :param pulumi.Input[builtins.str] password: Input only. The password for the user that Database Migration Service will be using to connect to the database.
               This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.bool] password_set: (Output)
               Output only. Indicates If this connection profile password is stored.
        :param pulumi.Input[builtins.int] port: The network port of the source MySQL database.
        :param pulumi.Input['ConnectionProfilePostgresqlSslArgs'] ssl: SSL configuration for the destination to connect to the source database.
               Structure is documented below.
        :param pulumi.Input[builtins.str] username: The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        if alloydb_cluster_id is not None:
            pulumi.set(__self__, "alloydb_cluster_id", alloydb_cluster_id)
        if cloud_sql_id is not None:
            pulumi.set(__self__, "cloud_sql_id", cloud_sql_id)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if network_architecture is not None:
            pulumi.set(__self__, "network_architecture", network_architecture)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if password_set is not None:
            pulumi.set(__self__, "password_set", password_set)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="alloydbClusterId")
    def alloydb_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the connected database is an AlloyDB instance, use this field to provide the AlloyDB cluster ID.
        """
        return pulumi.get(self, "alloydb_cluster_id")

    @alloydb_cluster_id.setter
    def alloydb_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alloydb_cluster_id", value)

    @property
    @pulumi.getter(name="cloudSqlId")
    def cloud_sql_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        If the source is a Cloud SQL database, use this field to provide the Cloud SQL instance ID of the source.
        """
        return pulumi.get(self, "cloud_sql_id")

    @cloud_sql_id.setter
    def cloud_sql_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloud_sql_id", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP or hostname of the source MySQL database.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="networkArchitecture")
    def network_architecture(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Output only. If the source is a Cloud SQL database, this field indicates the network architecture it's associated with.
        """
        return pulumi.get(self, "network_architecture")

    @network_architecture.setter
    def network_architecture(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_architecture", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The password for the user that Database Migration Service will be using to connect to the database.
        This field is not returned on request, and the value is encrypted when stored in Database Migration Service.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="passwordSet")
    def password_set(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Output)
        Output only. Indicates If this connection profile password is stored.
        """
        return pulumi.get(self, "password_set")

    @password_set.setter
    def password_set(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "password_set", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The network port of the source MySQL database.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']]:
        """
        SSL configuration for the destination to connect to the source database.
        Structure is documented below.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlSslArgs']]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The username that Database Migration Service will use to connect to the database. The value is encrypted when stored in Database Migration Service.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)


if not MYPY:
    class ConnectionProfilePostgresqlSslArgsDict(TypedDict):
        ca_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_certificate: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        client_key: NotRequired[pulumi.Input[builtins.str]]
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        type: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        The current connection profile state.
        """
elif False:
    ConnectionProfilePostgresqlSslArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ConnectionProfilePostgresqlSslArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 client_key: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] ca_certificate: Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
               The replica will use this certificate to verify it's connecting to the right host.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_certificate: Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
               If this field is used then the 'clientKey' field is mandatory
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] client_key: Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
               If this field is used then the 'clientCertificate' field is mandatory.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[builtins.str] type: (Output)
               The current connection profile state.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate of the CA that signed the source database server's certificate.
        The replica will use this certificate to verify it's connecting to the right host.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The x509 PEM-encoded certificate that will be used by the replica to authenticate against the source database server.
        If this field is used then the 'clientKey' field is mandatory
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with the Client Certificate.
        If this field is used then the 'clientCertificate' field is mandatory.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The current connection profile state.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


if not MYPY:
    class MigrationJobDumpFlagsArgsDict(TypedDict):
        dump_flags: NotRequired[pulumi.Input[Sequence[pulumi.Input['MigrationJobDumpFlagsDumpFlagArgsDict']]]]
        """
        A list of dump flags
        Structure is documented below.
        """
elif False:
    MigrationJobDumpFlagsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobDumpFlagsArgs:
    def __init__(__self__, *,
                 dump_flags: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobDumpFlagsDumpFlagArgs']]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['MigrationJobDumpFlagsDumpFlagArgs']]] dump_flags: A list of dump flags
               Structure is documented below.
        """
        if dump_flags is not None:
            pulumi.set(__self__, "dump_flags", dump_flags)

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobDumpFlagsDumpFlagArgs']]]]:
        """
        A list of dump flags
        Structure is documented below.
        """
        return pulumi.get(self, "dump_flags")

    @dump_flags.setter
    def dump_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobDumpFlagsDumpFlagArgs']]]]):
        pulumi.set(self, "dump_flags", value)


if not MYPY:
    class MigrationJobDumpFlagsDumpFlagArgsDict(TypedDict):
        name: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the flag
        """
        value: NotRequired[pulumi.Input[builtins.str]]
        """
        The vale of the flag
        """
elif False:
    MigrationJobDumpFlagsDumpFlagArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobDumpFlagsDumpFlagArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 value: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] name: The name of the flag
        :param pulumi.Input[builtins.str] value: The vale of the flag
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the flag
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The vale of the flag
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "value", value)


if not MYPY:
    class MigrationJobErrorArgsDict(TypedDict):
        code: NotRequired[pulumi.Input[builtins.int]]
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        details: NotRequired[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]
        """
        (Output)
        A list of messages that carry the error details.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        (Output)
        Human readable message indicating details about the current status.
        """
elif False:
    MigrationJobErrorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[builtins.int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.int] code: (Output)
               The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]] details: (Output)
               A list of messages that carry the error details.
        :param pulumi.Input[builtins.str] message: (Output)
               Human readable message indicating details about the current status.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Output)
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]:
        """
        (Output)
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class MigrationJobPerformanceConfigArgsDict(TypedDict):
        dump_parallel_level: NotRequired[pulumi.Input[builtins.str]]
        """
        Initial dump parallelism level.
        Possible values are: `MIN`, `OPTIMAL`, `MAX`.
        """
elif False:
    MigrationJobPerformanceConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobPerformanceConfigArgs:
    def __init__(__self__, *,
                 dump_parallel_level: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] dump_parallel_level: Initial dump parallelism level.
               Possible values are: `MIN`, `OPTIMAL`, `MAX`.
        """
        if dump_parallel_level is not None:
            pulumi.set(__self__, "dump_parallel_level", dump_parallel_level)

    @property
    @pulumi.getter(name="dumpParallelLevel")
    def dump_parallel_level(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Initial dump parallelism level.
        Possible values are: `MIN`, `OPTIMAL`, `MAX`.
        """
        return pulumi.get(self, "dump_parallel_level")

    @dump_parallel_level.setter
    def dump_parallel_level(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dump_parallel_level", value)


if not MYPY:
    class MigrationJobReverseSshConnectivityArgsDict(TypedDict):
        vm: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        vm_ip: NotRequired[pulumi.Input[builtins.str]]
        """
        The IP of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        vm_port: NotRequired[pulumi.Input[builtins.int]]
        """
        The forwarding port of the virtual machine (Compute Engine) used as the
        bastion server for the SSH tunnel.
        """
        vpc: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the VPC to peer with the Cloud SQL private network.
        """
elif False:
    MigrationJobReverseSshConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobReverseSshConnectivityArgs:
    def __init__(__self__, *,
                 vm: Optional[pulumi.Input[builtins.str]] = None,
                 vm_ip: Optional[pulumi.Input[builtins.str]] = None,
                 vm_port: Optional[pulumi.Input[builtins.int]] = None,
                 vpc: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] vm: The name of the virtual machine (Compute Engine) used as the bastion server
               for the SSH tunnel.
        :param pulumi.Input[builtins.str] vm_ip: The IP of the virtual machine (Compute Engine) used as the bastion server
               for the SSH tunnel.
        :param pulumi.Input[builtins.int] vm_port: The forwarding port of the virtual machine (Compute Engine) used as the
               bastion server for the SSH tunnel.
        :param pulumi.Input[builtins.str] vpc: The name of the VPC to peer with the Cloud SQL private network.
        """
        if vm is not None:
            pulumi.set(__self__, "vm", vm)
        if vm_ip is not None:
            pulumi.set(__self__, "vm_ip", vm_ip)
        if vm_port is not None:
            pulumi.set(__self__, "vm_port", vm_port)
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vm(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        return pulumi.get(self, "vm")

    @vm.setter
    def vm(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vm", value)

    @property
    @pulumi.getter(name="vmIp")
    def vm_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IP of the virtual machine (Compute Engine) used as the bastion server
        for the SSH tunnel.
        """
        return pulumi.get(self, "vm_ip")

    @vm_ip.setter
    def vm_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vm_ip", value)

    @property
    @pulumi.getter(name="vmPort")
    def vm_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The forwarding port of the virtual machine (Compute Engine) used as the
        bastion server for the SSH tunnel.
        """
        return pulumi.get(self, "vm_port")

    @vm_port.setter
    def vm_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vm_port", value)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VPC to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc", value)


if not MYPY:
    class MigrationJobStaticIpConnectivityArgsDict(TypedDict):
        pass
elif False:
    MigrationJobStaticIpConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobStaticIpConnectivityArgs:
    def __init__(__self__):
        pass


if not MYPY:
    class MigrationJobVpcPeeringConnectivityArgsDict(TypedDict):
        vpc: NotRequired[pulumi.Input[builtins.str]]
        """
        The name of the VPC network to peer with the Cloud SQL private network.
        """
elif False:
    MigrationJobVpcPeeringConnectivityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class MigrationJobVpcPeeringConnectivityArgs:
    def __init__(__self__, *,
                 vpc: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[builtins.str] vpc: The name of the VPC network to peer with the Cloud SQL private network.
        """
        if vpc is not None:
            pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter
    def vpc(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the VPC network to peer with the Cloud SQL private network.
        """
        return pulumi.get(self, "vpc")

    @vpc.setter
    def vpc(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vpc", value)


if not MYPY:
    class PrivateConnectionErrorArgsDict(TypedDict):
        details: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]
        """
        A list of messages that carry the error details.
        """
        message: NotRequired[pulumi.Input[builtins.str]]
        """
        A message containing more information about the error that occurred.
        """
elif False:
    PrivateConnectionErrorArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateConnectionErrorArgs:
    def __init__(__self__, *,
                 details: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 message: Optional[pulumi.Input[builtins.str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] details: A list of messages that carry the error details.
        :param pulumi.Input[builtins.str] message: A message containing more information about the error that occurred.
        """
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A list of messages that carry the error details.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message containing more information about the error that occurred.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message", value)


if not MYPY:
    class PrivateConnectionVpcPeeringConfigArgsDict(TypedDict):
        subnet: pulumi.Input[builtins.str]
        """
        A free subnet for peering. (CIDR of /29)
        """
        vpc_name: pulumi.Input[builtins.str]
        """
        Fully qualified name of the VPC that Database Migration Service will peer to.
        Format: projects/{project}/global/{networks}/{name}
        """
elif False:
    PrivateConnectionVpcPeeringConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class PrivateConnectionVpcPeeringConfigArgs:
    def __init__(__self__, *,
                 subnet: pulumi.Input[builtins.str],
                 vpc_name: pulumi.Input[builtins.str]):
        """
        :param pulumi.Input[builtins.str] subnet: A free subnet for peering. (CIDR of /29)
        :param pulumi.Input[builtins.str] vpc_name: Fully qualified name of the VPC that Database Migration Service will peer to.
               Format: projects/{project}/global/{networks}/{name}
        """
        pulumi.set(__self__, "subnet", subnet)
        pulumi.set(__self__, "vpc_name", vpc_name)

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Input[builtins.str]:
        """
        A free subnet for peering. (CIDR of /29)
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet", value)

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> pulumi.Input[builtins.str]:
        """
        Fully qualified name of the VPC that Database Migration Service will peer to.
        Format: projects/{project}/global/{networks}/{name}
        """
        return pulumi.get(self, "vpc_name")

    @vpc_name.setter
    def vpc_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vpc_name", value)


