# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionProfileArgs', 'ConnectionProfile']

@pulumi.input_type
class ConnectionProfileArgs:
    def __init__(__self__, *,
                 connection_profile_id: pulumi.Input[builtins.str],
                 alloydb: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']] = None,
                 cloudsql: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mysql: Optional[pulumi.Input['ConnectionProfileMysqlArgs']] = None,
                 oracle: Optional[pulumi.Input['ConnectionProfileOracleArgs']] = None,
                 postgresql: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ConnectionProfile resource.
        :param pulumi.Input[builtins.str] connection_profile_id: The ID of the connection profile.
        :param pulumi.Input['ConnectionProfileAlloydbArgs'] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileCloudsqlArgs'] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the connection profile should reside.
        :param pulumi.Input['ConnectionProfileMysqlArgs'] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileOracleArgs'] oracle: Specifies connection parameters required specifically for Oracle databases.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlArgs'] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if alloydb is not None:
            pulumi.set(__self__, "alloydb", alloydb)
        if cloudsql is not None:
            pulumi.set(__self__, "cloudsql", cloudsql)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if oracle is not None:
            pulumi.set(__self__, "oracle", oracle)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the connection profile.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter
    def alloydb(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @alloydb.setter
    def alloydb(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]):
        pulumi.set(self, "alloydb", value)

    @property
    @pulumi.getter
    def cloudsql(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @cloudsql.setter
    def cloudsql(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]):
        pulumi.set(self, "cloudsql", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ConnectionProfileMysqlArgs']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ConnectionProfileMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter
    def oracle(self) -> Optional[pulumi.Input['ConnectionProfileOracleArgs']]:
        """
        Specifies connection parameters required specifically for Oracle databases.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle")

    @oracle.setter
    def oracle(self, value: Optional[pulumi.Input['ConnectionProfileOracleArgs']]):
        pulumi.set(self, "oracle", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ConnectionProfileState:
    def __init__(__self__, *,
                 alloydb: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']] = None,
                 cloudsql: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']] = None,
                 connection_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 dbprovider: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mysql: Optional[pulumi.Input['ConnectionProfileMysqlArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 oracle: Optional[pulumi.Input['ConnectionProfileOracleArgs']] = None,
                 postgresql: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConnectionProfile resources.
        :param pulumi.Input['ConnectionProfileAlloydbArgs'] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfileCloudsqlArgs'] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_profile_id: The ID of the connection profile.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[builtins.str] dbprovider: The database provider.
        :param pulumi.Input[builtins.str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the connection profile should reside.
        :param pulumi.Input['ConnectionProfileMysqlArgs'] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        :param pulumi.Input['ConnectionProfileOracleArgs'] oracle: Specifies connection parameters required specifically for Oracle databases.
               Structure is documented below.
        :param pulumi.Input['ConnectionProfilePostgresqlArgs'] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The current connection profile state.
        """
        if alloydb is not None:
            pulumi.set(__self__, "alloydb", alloydb)
        if cloudsql is not None:
            pulumi.set(__self__, "cloudsql", cloudsql)
        if connection_profile_id is not None:
            pulumi.set(__self__, "connection_profile_id", connection_profile_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if dbprovider is not None:
            pulumi.set(__self__, "dbprovider", dbprovider)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mysql is not None:
            pulumi.set(__self__, "mysql", mysql)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oracle is not None:
            pulumi.set(__self__, "oracle", oracle)
        if postgresql is not None:
            pulumi.set(__self__, "postgresql", postgresql)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def alloydb(self) -> Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @alloydb.setter
    def alloydb(self, value: Optional[pulumi.Input['ConnectionProfileAlloydbArgs']]):
        pulumi.set(self, "alloydb", value)

    @property
    @pulumi.getter
    def cloudsql(self) -> Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @cloudsql.setter
    def cloudsql(self, value: Optional[pulumi.Input['ConnectionProfileCloudsqlArgs']]):
        pulumi.set(self, "cloudsql", value)

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the connection profile.
        """
        return pulumi.get(self, "connection_profile_id")

    @connection_profile_id.setter
    def connection_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_profile_id", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def dbprovider(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database provider.
        """
        return pulumi.get(self, "dbprovider")

    @dbprovider.setter
    def dbprovider(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dbprovider", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionProfileErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def mysql(self) -> Optional[pulumi.Input['ConnectionProfileMysqlArgs']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @mysql.setter
    def mysql(self, value: Optional[pulumi.Input['ConnectionProfileMysqlArgs']]):
        pulumi.set(self, "mysql", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def oracle(self) -> Optional[pulumi.Input['ConnectionProfileOracleArgs']]:
        """
        Specifies connection parameters required specifically for Oracle databases.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle")

    @oracle.setter
    def oracle(self, value: Optional[pulumi.Input['ConnectionProfileOracleArgs']]):
        pulumi.set(self, "oracle", value)

    @property
    @pulumi.getter
    def postgresql(self) -> Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @postgresql.setter
    def postgresql(self, value: Optional[pulumi.Input['ConnectionProfilePostgresqlArgs']]):
        pulumi.set(self, "postgresql", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current connection profile state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("gcp:databasemigrationservice/connectionProfile:ConnectionProfile")
class ConnectionProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alloydb: Optional[pulumi.Input[Union['ConnectionProfileAlloydbArgs', 'ConnectionProfileAlloydbArgsDict']]] = None,
                 cloudsql: Optional[pulumi.Input[Union['ConnectionProfileCloudsqlArgs', 'ConnectionProfileCloudsqlArgsDict']]] = None,
                 connection_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mysql: Optional[pulumi.Input[Union['ConnectionProfileMysqlArgs', 'ConnectionProfileMysqlArgsDict']]] = None,
                 oracle: Optional[pulumi.Input[Union['ConnectionProfileOracleArgs', 'ConnectionProfileOracleArgsDict']]] = None,
                 postgresql: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlArgs', 'ConnectionProfilePostgresqlArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        A connection profile definition.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        ## Example Usage

        ### Database Migration Service Connection Profile Cloudsql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudsqldb = gcp.sql.DatabaseInstance("cloudsqldb",
            name="my-database",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=cloudsqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[cloudsqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=cloudsqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        cloudsqlprofile = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile",
            location="us-central1",
            connection_profile_id="my-fromprofileid",
            display_name="my-fromprofileid_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "host": cloudsqldb.ip_addresses[0].ip_address,
                "port": 3306,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "client_key": sql_client_cert.private_key,
                    "client_certificate": sql_client_cert.cert,
                    "ca_certificate": sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        cloudsqlprofile_destination = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile_destination",
            location="us-central1",
            connection_profile_id="my-toprofileid",
            display_name="my-toprofileid_displayname",
            labels={
                "foo": "bar",
            },
            cloudsql={
                "settings": {
                    "database_version": "MYSQL_5_7",
                    "user_labels": {
                        "cloudfoo": "cloudbar",
                    },
                    "tier": "db-n1-standard-1",
                    "edition": "ENTERPRISE",
                    "storage_auto_resize_limit": "0",
                    "activation_policy": "ALWAYS",
                    "ip_config": {
                        "enable_ipv4": True,
                        "require_ssl": True,
                    },
                    "auto_storage_increase": True,
                    "data_disk_type": "PD_HDD",
                    "data_disk_size_gb": "11",
                    "zone": "us-central1-b",
                    "source_id": f"projects/{project.project_id}/locations/us-central1/connectionProfiles/my-fromprofileid",
                    "root_password": "testpasscloudsql",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[cloudsqlprofile]))
        ```
        ### Database Migration Service Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "client_key": sql_client_cert.private_key,
                    "client_certificate": sql_client_cert.cert,
                    "ca_certificate": sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Postgres No Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "type": "NONE",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Postgres Required Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "type": "REQUIRED",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Oracle

        ```python
        import pulumi
        import pulumi_gcp as gcp

        oracleprofile = gcp.databasemigrationservice.ConnectionProfile("oracleprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            oracle={
                "host": "host",
                "port": 1521,
                "username": "username",
                "password": "password",
                "database_service": "dbprovider",
                "static_service_ip_connectivity": {},
            })
        ```
        ### Database Migration Service Connection Profile Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", name="vpc-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        alloydbprofile = gcp.databasemigrationservice.ConnectionProfile("alloydbprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            alloydb={
                "cluster_id": "tf-test-dbmsalloycluster_85840",
                "settings": {
                    "initial_user": {
                        "user": "alloyuser_60302",
                        "password": "alloypass_22811",
                    },
                    "vpc_network": default.id,
                    "labels": {
                        "alloyfoo": "alloybar",
                    },
                    "primary_instance_settings": {
                        "id": "priminstid",
                        "machine_config": {
                            "cpu_count": 2,
                        },
                        "database_flags": {},
                        "labels": {
                            "alloysinstfoo": "allowinstbar",
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        ```
        ### Database Migration Service Connection Profile Existing Mysql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        existing_mysql = gcp.databasemigrationservice.ConnectionProfile("existing-mysql",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        ```
        ### Database Migration Service Connection Profile Existing Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        existing_psql = gcp.databasemigrationservice.ConnectionProfile("existing-psql",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        ```
        ### Database Migration Service Connection Profile Existing Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", name="destination-alloydb")
        destination_alloydb = gcp.alloydb.Cluster("destination_alloydb",
            cluster_id="destination-alloydb",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "destination-alloydb",
                "password": "destination-alloydb",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="destination-alloydb",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        destination_alloydb_primary = gcp.alloydb.Instance("destination_alloydb_primary",
            cluster=destination_alloydb.name,
            instance_id="destination-alloydb-primary",
            instance_type="PRIMARY",
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        existing_alloydb = gcp.databasemigrationservice.ConnectionProfile("existing-alloydb",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "alloydb_cluster_id": "destination-alloydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination_alloydb,
                    destination_alloydb_primary,
                ]))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}`

        * `{{project}}/{{location}}/{{connection_profile_id}}`

        * `{{location}}/{{connection_profile_id}}`

        When using the `pulumi import` command, ConnectionProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionProfileAlloydbArgs', 'ConnectionProfileAlloydbArgsDict']] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileCloudsqlArgs', 'ConnectionProfileCloudsqlArgsDict']] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_profile_id: The ID of the connection profile.
        :param pulumi.Input[builtins.str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the connection profile should reside.
        :param pulumi.Input[Union['ConnectionProfileMysqlArgs', 'ConnectionProfileMysqlArgsDict']] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileOracleArgs', 'ConnectionProfileOracleArgsDict']] oracle: Specifies connection parameters required specifically for Oracle databases.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePostgresqlArgs', 'ConnectionProfilePostgresqlArgsDict']] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionProfileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A connection profile definition.

        To get more information about ConnectionProfile, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.connectionProfiles/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        ## Example Usage

        ### Database Migration Service Connection Profile Cloudsql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        cloudsqldb = gcp.sql.DatabaseInstance("cloudsqldb",
            name="my-database",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=cloudsqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[cloudsqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=cloudsqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        cloudsqlprofile = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile",
            location="us-central1",
            connection_profile_id="my-fromprofileid",
            display_name="my-fromprofileid_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "host": cloudsqldb.ip_addresses[0].ip_address,
                "port": 3306,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "client_key": sql_client_cert.private_key,
                    "client_certificate": sql_client_cert.cert,
                    "ca_certificate": sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        cloudsqlprofile_destination = gcp.databasemigrationservice.ConnectionProfile("cloudsqlprofile_destination",
            location="us-central1",
            connection_profile_id="my-toprofileid",
            display_name="my-toprofileid_displayname",
            labels={
                "foo": "bar",
            },
            cloudsql={
                "settings": {
                    "database_version": "MYSQL_5_7",
                    "user_labels": {
                        "cloudfoo": "cloudbar",
                    },
                    "tier": "db-n1-standard-1",
                    "edition": "ENTERPRISE",
                    "storage_auto_resize_limit": "0",
                    "activation_policy": "ALWAYS",
                    "ip_config": {
                        "enable_ipv4": True,
                        "require_ssl": True,
                    },
                    "auto_storage_increase": True,
                    "data_disk_type": "PD_HDD",
                    "data_disk_size_gb": "11",
                    "zone": "us-central1-b",
                    "source_id": f"projects/{project.project_id}/locations/us-central1/connectionProfiles/my-fromprofileid",
                    "root_password": "testpasscloudsql",
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[cloudsqlprofile]))
        ```
        ### Database Migration Service Connection Profile Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "client_key": sql_client_cert.private_key,
                    "client_certificate": sql_client_cert.cert,
                    "ca_certificate": sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Postgres No Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "type": "NONE",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Postgres Required Ssl

        ```python
        import pulumi
        import pulumi_gcp as gcp

        postgresqldb = gcp.sql.DatabaseInstance("postgresqldb",
            name="my-database",
            database_version="POSTGRES_12",
            settings={
                "tier": "db-custom-2-13312",
            },
            deletion_protection=False)
        sql_client_cert = gcp.sql.SslCert("sql_client_cert",
            common_name="my-cert",
            instance=postgresqldb.name,
            opts = pulumi.ResourceOptions(depends_on=[postgresqldb]))
        sqldb_user = gcp.sql.User("sqldb_user",
            name="my-username",
            instance=postgresqldb.name,
            password="my-password",
            opts = pulumi.ResourceOptions(depends_on=[sql_client_cert]))
        postgresprofile = gcp.databasemigrationservice.ConnectionProfile("postgresprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": postgresqldb.ip_addresses[0].ip_address,
                "port": 5432,
                "username": sqldb_user.name,
                "password": sqldb_user.password,
                "ssl": {
                    "type": "REQUIRED",
                },
                "cloud_sql_id": "my-database",
            },
            opts = pulumi.ResourceOptions(depends_on=[sqldb_user]))
        ```
        ### Database Migration Service Connection Profile Oracle

        ```python
        import pulumi
        import pulumi_gcp as gcp

        oracleprofile = gcp.databasemigrationservice.ConnectionProfile("oracleprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            oracle={
                "host": "host",
                "port": 1521,
                "username": "username",
                "password": "password",
                "database_service": "dbprovider",
                "static_service_ip_connectivity": {},
            })
        ```
        ### Database Migration Service Connection Profile Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", name="vpc-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="private-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        alloydbprofile = gcp.databasemigrationservice.ConnectionProfile("alloydbprofile",
            location="us-central1",
            connection_profile_id="my-profileid",
            display_name="my-profileid_display",
            labels={
                "foo": "bar",
            },
            alloydb={
                "cluster_id": "tf-test-dbmsalloycluster_85840",
                "settings": {
                    "initial_user": {
                        "user": "alloyuser_60302",
                        "password": "alloypass_22811",
                    },
                    "vpc_network": default.id,
                    "labels": {
                        "alloyfoo": "alloybar",
                    },
                    "primary_instance_settings": {
                        "id": "priminstid",
                        "machine_config": {
                            "cpu_count": 2,
                        },
                        "database_flags": {},
                        "labels": {
                            "alloysinstfoo": "allowinstbar",
                        },
                    },
                },
            },
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        ```
        ### Database Migration Service Connection Profile Existing Mysql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        existing_mysql = gcp.databasemigrationservice.ConnectionProfile("existing-mysql",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        ```
        ### Database Migration Service Connection Profile Existing Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        existing_psql = gcp.databasemigrationservice.ConnectionProfile("existing-psql",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        ```
        ### Database Migration Service Connection Profile Existing Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        default = gcp.compute.Network("default", name="destination-alloydb")
        destination_alloydb = gcp.alloydb.Cluster("destination_alloydb",
            cluster_id="destination-alloydb",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "destination-alloydb",
                "password": "destination-alloydb",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="destination-alloydb",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        destination_alloydb_primary = gcp.alloydb.Instance("destination_alloydb_primary",
            cluster=destination_alloydb.name,
            instance_id="destination-alloydb-primary",
            instance_type="PRIMARY",
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        existing_alloydb = gcp.databasemigrationservice.ConnectionProfile("existing-alloydb",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "alloydb_cluster_id": "destination-alloydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination_alloydb,
                    destination_alloydb_primary,
                ]))
        ```

        ## Import

        ConnectionProfile can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}`

        * `{{project}}/{{location}}/{{connection_profile_id}}`

        * `{{location}}/{{connection_profile_id}}`

        When using the `pulumi import` command, ConnectionProfile can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{project}}/{{location}}/{{connection_profile_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/connectionProfile:ConnectionProfile default {{location}}/{{connection_profile_id}}
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alloydb: Optional[pulumi.Input[Union['ConnectionProfileAlloydbArgs', 'ConnectionProfileAlloydbArgsDict']]] = None,
                 cloudsql: Optional[pulumi.Input[Union['ConnectionProfileCloudsqlArgs', 'ConnectionProfileCloudsqlArgsDict']]] = None,
                 connection_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 mysql: Optional[pulumi.Input[Union['ConnectionProfileMysqlArgs', 'ConnectionProfileMysqlArgsDict']]] = None,
                 oracle: Optional[pulumi.Input[Union['ConnectionProfileOracleArgs', 'ConnectionProfileOracleArgsDict']]] = None,
                 postgresql: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlArgs', 'ConnectionProfilePostgresqlArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionProfileArgs.__new__(ConnectionProfileArgs)

            __props__.__dict__["alloydb"] = alloydb
            __props__.__dict__["cloudsql"] = cloudsql
            if connection_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'connection_profile_id'")
            __props__.__dict__["connection_profile_id"] = connection_profile_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["mysql"] = mysql
            __props__.__dict__["oracle"] = oracle
            __props__.__dict__["postgresql"] = postgresql
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["dbprovider"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ConnectionProfile, __self__).__init__(
            'gcp:databasemigrationservice/connectionProfile:ConnectionProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alloydb: Optional[pulumi.Input[Union['ConnectionProfileAlloydbArgs', 'ConnectionProfileAlloydbArgsDict']]] = None,
            cloudsql: Optional[pulumi.Input[Union['ConnectionProfileCloudsqlArgs', 'ConnectionProfileCloudsqlArgsDict']]] = None,
            connection_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            dbprovider: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionProfileErrorArgs', 'ConnectionProfileErrorArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            mysql: Optional[pulumi.Input[Union['ConnectionProfileMysqlArgs', 'ConnectionProfileMysqlArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            oracle: Optional[pulumi.Input[Union['ConnectionProfileOracleArgs', 'ConnectionProfileOracleArgsDict']]] = None,
            postgresql: Optional[pulumi.Input[Union['ConnectionProfilePostgresqlArgs', 'ConnectionProfilePostgresqlArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None) -> 'ConnectionProfile':
        """
        Get an existing ConnectionProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ConnectionProfileAlloydbArgs', 'ConnectionProfileAlloydbArgsDict']] alloydb: Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfileCloudsqlArgs', 'ConnectionProfileCloudsqlArgsDict']] cloudsql: Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
               Structure is documented below.
        :param pulumi.Input[builtins.str] connection_profile_id: The ID of the connection profile.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[builtins.str] dbprovider: The database provider.
        :param pulumi.Input[builtins.str] display_name: The connection profile display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionProfileErrorArgs', 'ConnectionProfileErrorArgsDict']]]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the connection profile should reside.
        :param pulumi.Input[Union['ConnectionProfileMysqlArgs', 'ConnectionProfileMysqlArgsDict']] mysql: Specifies connection parameters required specifically for MySQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        :param pulumi.Input[Union['ConnectionProfileOracleArgs', 'ConnectionProfileOracleArgsDict']] oracle: Specifies connection parameters required specifically for Oracle databases.
               Structure is documented below.
        :param pulumi.Input[Union['ConnectionProfilePostgresqlArgs', 'ConnectionProfilePostgresqlArgsDict']] postgresql: Specifies connection parameters required specifically for PostgreSQL databases.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] state: The current connection profile state.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionProfileState.__new__(_ConnectionProfileState)

        __props__.__dict__["alloydb"] = alloydb
        __props__.__dict__["cloudsql"] = cloudsql
        __props__.__dict__["connection_profile_id"] = connection_profile_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["dbprovider"] = dbprovider
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["errors"] = errors
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["mysql"] = mysql
        __props__.__dict__["name"] = name
        __props__.__dict__["oracle"] = oracle
        __props__.__dict__["postgresql"] = postgresql
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["state"] = state
        return ConnectionProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alloydb(self) -> pulumi.Output[Optional['outputs.ConnectionProfileAlloydb']]:
        """
        Specifies required connection parameters, and the parameters required to create an AlloyDB destination cluster.
        Structure is documented below.
        """
        return pulumi.get(self, "alloydb")

    @property
    @pulumi.getter
    def cloudsql(self) -> pulumi.Output[Optional['outputs.ConnectionProfileCloudsql']]:
        """
        Specifies required connection parameters, and, optionally, the parameters required to create a Cloud SQL destination database instance.
        Structure is documented below.
        """
        return pulumi.get(self, "cloudsql")

    @property
    @pulumi.getter(name="connectionProfileId")
    def connection_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the connection profile.
        """
        return pulumi.get(self, "connection_profile_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def dbprovider(self) -> pulumi.Output[builtins.str]:
        """
        The database provider.
        """
        return pulumi.get(self, "dbprovider")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The connection profile display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.ConnectionProfileError']]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The resource labels for connection profile to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location where the connection profile should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def mysql(self) -> pulumi.Output[Optional['outputs.ConnectionProfileMysql']]:
        """
        Specifies connection parameters required specifically for MySQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "mysql")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of this connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{connectionProfile}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def oracle(self) -> pulumi.Output[Optional['outputs.ConnectionProfileOracle']]:
        """
        Specifies connection parameters required specifically for Oracle databases.
        Structure is documented below.
        """
        return pulumi.get(self, "oracle")

    @property
    @pulumi.getter
    def postgresql(self) -> pulumi.Output[Optional['outputs.ConnectionProfilePostgresql']]:
        """
        Specifies connection parameters required specifically for PostgreSQL databases.
        Structure is documented below.
        """
        return pulumi.get(self, "postgresql")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current connection profile state.
        """
        return pulumi.get(self, "state")

