# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MigrationJobArgs', 'MigrationJob']

@pulumi.input_type
class MigrationJobArgs:
    def __init__(__self__, *,
                 destination: pulumi.Input[builtins.str],
                 migration_job_id: pulumi.Input[builtins.str],
                 source: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dump_flags: Optional[pulumi.Input['MigrationJobDumpFlagsArgs']] = None,
                 dump_path: Optional[pulumi.Input[builtins.str]] = None,
                 dump_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 performance_config: Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_ssh_connectivity: Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']] = None,
                 static_ip_connectivity: Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']] = None,
                 vpc_peering_connectivity: Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']] = None):
        """
        The set of arguments for constructing a MigrationJob resource.
        :param pulumi.Input[builtins.str] destination: The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        :param pulumi.Input[builtins.str] migration_job_id: The ID of the migration job.
        :param pulumi.Input[builtins.str] source: The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        :param pulumi.Input[builtins.str] type: The type of the migration job.
               Possible values are: `ONE_TIME`, `CONTINUOUS`.
        :param pulumi.Input[builtins.str] display_name: The migration job display name.
        :param pulumi.Input['MigrationJobDumpFlagsArgs'] dump_flags: The initial dump flags.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dump_path: The path to the dump file in Google Cloud Storage,
               in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
               This field and the "dump_flags" field are mutually exclusive.
        :param pulumi.Input[builtins.str] dump_type: The type of the data dump. Supported for MySQL to CloudSQL for MySQL
               migrations only.
               Possible values are: `LOGICAL`, `PHYSICAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the migration job should reside.
        :param pulumi.Input['MigrationJobPerformanceConfigArgs'] performance_config: Data dump parallelism settings used by the migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['MigrationJobReverseSshConnectivityArgs'] reverse_ssh_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        :param pulumi.Input['MigrationJobStaticIpConnectivityArgs'] static_ip_connectivity: If set to an empty object (`{}`), the source database will allow incoming
               connections from the public IP of the destination database.
               You can retrieve the public IP of the Cloud SQL instance from the
               Cloud SQL console or using Cloud SQL APIs.
        :param pulumi.Input['MigrationJobVpcPeeringConnectivityArgs'] vpc_peering_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "migration_job_id", migration_job_id)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "type", type)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dump_flags is not None:
            pulumi.set(__self__, "dump_flags", dump_flags)
        if dump_path is not None:
            pulumi.set(__self__, "dump_path", dump_path)
        if dump_type is not None:
            pulumi.set(__self__, "dump_type", dump_type)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if performance_config is not None:
            pulumi.set(__self__, "performance_config", performance_config)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if reverse_ssh_connectivity is not None:
            pulumi.set(__self__, "reverse_ssh_connectivity", reverse_ssh_connectivity)
        if static_ip_connectivity is not None:
            pulumi.set(__self__, "static_ip_connectivity", static_ip_connectivity)
        if vpc_peering_connectivity is not None:
            pulumi.set(__self__, "vpc_peering_connectivity", vpc_peering_connectivity)

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Input[builtins.str]:
        """
        The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="migrationJobId")
    def migration_job_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the migration job.
        """
        return pulumi.get(self, "migration_job_id")

    @migration_job_id.setter
    def migration_job_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "migration_job_id", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[builtins.str]:
        """
        The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        The type of the migration job.
        Possible values are: `ONE_TIME`, `CONTINUOUS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The migration job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> Optional[pulumi.Input['MigrationJobDumpFlagsArgs']]:
        """
        The initial dump flags.
        Structure is documented below.
        """
        return pulumi.get(self, "dump_flags")

    @dump_flags.setter
    def dump_flags(self, value: Optional[pulumi.Input['MigrationJobDumpFlagsArgs']]):
        pulumi.set(self, "dump_flags", value)

    @property
    @pulumi.getter(name="dumpPath")
    def dump_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the dump file in Google Cloud Storage,
        in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
        This field and the "dump_flags" field are mutually exclusive.
        """
        return pulumi.get(self, "dump_path")

    @dump_path.setter
    def dump_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dump_path", value)

    @property
    @pulumi.getter(name="dumpType")
    def dump_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the data dump. Supported for MySQL to CloudSQL for MySQL
        migrations only.
        Possible values are: `LOGICAL`, `PHYSICAL`.
        """
        return pulumi.get(self, "dump_type")

    @dump_type.setter
    def dump_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dump_type", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the migration job should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']]:
        """
        Data dump parallelism settings used by the migration.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @performance_config.setter
    def performance_config(self, value: Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']]):
        pulumi.set(self, "performance_config", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="reverseSshConnectivity")
    def reverse_ssh_connectivity(self) -> Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "reverse_ssh_connectivity")

    @reverse_ssh_connectivity.setter
    def reverse_ssh_connectivity(self, value: Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']]):
        pulumi.set(self, "reverse_ssh_connectivity", value)

    @property
    @pulumi.getter(name="staticIpConnectivity")
    def static_ip_connectivity(self) -> Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']]:
        """
        If set to an empty object (`{}`), the source database will allow incoming
        connections from the public IP of the destination database.
        You can retrieve the public IP of the Cloud SQL instance from the
        Cloud SQL console or using Cloud SQL APIs.
        """
        return pulumi.get(self, "static_ip_connectivity")

    @static_ip_connectivity.setter
    def static_ip_connectivity(self, value: Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']]):
        pulumi.set(self, "static_ip_connectivity", value)

    @property
    @pulumi.getter(name="vpcPeeringConnectivity")
    def vpc_peering_connectivity(self) -> Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_peering_connectivity")

    @vpc_peering_connectivity.setter
    def vpc_peering_connectivity(self, value: Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']]):
        pulumi.set(self, "vpc_peering_connectivity", value)


@pulumi.input_type
class _MigrationJobState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dump_flags: Optional[pulumi.Input['MigrationJobDumpFlagsArgs']] = None,
                 dump_path: Optional[pulumi.Input[builtins.str]] = None,
                 dump_type: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 errors: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobErrorArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 migration_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 performance_config: Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']] = None,
                 phase: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 reverse_ssh_connectivity: Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 static_ip_connectivity: Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connectivity: Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']] = None):
        """
        Input properties used for looking up and filtering MigrationJob resources.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[builtins.str] destination: The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        :param pulumi.Input[builtins.str] display_name: The migration job display name.
        :param pulumi.Input['MigrationJobDumpFlagsArgs'] dump_flags: The initial dump flags.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dump_path: The path to the dump file in Google Cloud Storage,
               in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
               This field and the "dump_flags" field are mutually exclusive.
        :param pulumi.Input[builtins.str] dump_type: The type of the data dump. Supported for MySQL to CloudSQL for MySQL
               migrations only.
               Possible values are: `LOGICAL`, `PHYSICAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input['MigrationJobErrorArgs']]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the migration job should reside.
        :param pulumi.Input[builtins.str] migration_job_id: The ID of the migration job.
        :param pulumi.Input[builtins.str] name: The name of this migration job resource in the form of projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
        :param pulumi.Input['MigrationJobPerformanceConfigArgs'] performance_config: Data dump parallelism settings used by the migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] phase: The current migration job phase.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['MigrationJobReverseSshConnectivityArgs'] reverse_ssh_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source: The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        :param pulumi.Input[builtins.str] state: The current migration job state.
        :param pulumi.Input['MigrationJobStaticIpConnectivityArgs'] static_ip_connectivity: If set to an empty object (`{}`), the source database will allow incoming
               connections from the public IP of the destination database.
               You can retrieve the public IP of the Cloud SQL instance from the
               Cloud SQL console or using Cloud SQL APIs.
        :param pulumi.Input[builtins.str] type: The type of the migration job.
               Possible values are: `ONE_TIME`, `CONTINUOUS`.
        :param pulumi.Input['MigrationJobVpcPeeringConnectivityArgs'] vpc_peering_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dump_flags is not None:
            pulumi.set(__self__, "dump_flags", dump_flags)
        if dump_path is not None:
            pulumi.set(__self__, "dump_path", dump_path)
        if dump_type is not None:
            pulumi.set(__self__, "dump_type", dump_type)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if errors is not None:
            pulumi.set(__self__, "errors", errors)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if migration_job_id is not None:
            pulumi.set(__self__, "migration_job_id", migration_job_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_config is not None:
            pulumi.set(__self__, "performance_config", performance_config)
        if phase is not None:
            pulumi.set(__self__, "phase", phase)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if reverse_ssh_connectivity is not None:
            pulumi.set(__self__, "reverse_ssh_connectivity", reverse_ssh_connectivity)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_ip_connectivity is not None:
            pulumi.set(__self__, "static_ip_connectivity", static_ip_connectivity)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_peering_connectivity is not None:
            pulumi.set(__self__, "vpc_peering_connectivity", vpc_peering_connectivity)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The migration job display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> Optional[pulumi.Input['MigrationJobDumpFlagsArgs']]:
        """
        The initial dump flags.
        Structure is documented below.
        """
        return pulumi.get(self, "dump_flags")

    @dump_flags.setter
    def dump_flags(self, value: Optional[pulumi.Input['MigrationJobDumpFlagsArgs']]):
        pulumi.set(self, "dump_flags", value)

    @property
    @pulumi.getter(name="dumpPath")
    def dump_path(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The path to the dump file in Google Cloud Storage,
        in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
        This field and the "dump_flags" field are mutually exclusive.
        """
        return pulumi.get(self, "dump_path")

    @dump_path.setter
    def dump_path(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dump_path", value)

    @property
    @pulumi.getter(name="dumpType")
    def dump_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the data dump. Supported for MySQL to CloudSQL for MySQL
        migrations only.
        Possible values are: `LOGICAL`, `PHYSICAL`.
        """
        return pulumi.get(self, "dump_type")

    @dump_type.setter
    def dump_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dump_type", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter
    def errors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobErrorArgs']]]]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @errors.setter
    def errors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MigrationJobErrorArgs']]]]):
        pulumi.set(self, "errors", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where the migration job should reside.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="migrationJobId")
    def migration_job_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the migration job.
        """
        return pulumi.get(self, "migration_job_id")

    @migration_job_id.setter
    def migration_job_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "migration_job_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of this migration job resource in the form of projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']]:
        """
        Data dump parallelism settings used by the migration.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @performance_config.setter
    def performance_config(self, value: Optional[pulumi.Input['MigrationJobPerformanceConfigArgs']]):
        pulumi.set(self, "performance_config", value)

    @property
    @pulumi.getter
    def phase(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current migration job phase.
        """
        return pulumi.get(self, "phase")

    @phase.setter
    def phase(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "phase", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="reverseSshConnectivity")
    def reverse_ssh_connectivity(self) -> Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "reverse_ssh_connectivity")

    @reverse_ssh_connectivity.setter
    def reverse_ssh_connectivity(self, value: Optional[pulumi.Input['MigrationJobReverseSshConnectivityArgs']]):
        pulumi.set(self, "reverse_ssh_connectivity", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current migration job state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticIpConnectivity")
    def static_ip_connectivity(self) -> Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']]:
        """
        If set to an empty object (`{}`), the source database will allow incoming
        connections from the public IP of the destination database.
        You can retrieve the public IP of the Cloud SQL instance from the
        Cloud SQL console or using Cloud SQL APIs.
        """
        return pulumi.get(self, "static_ip_connectivity")

    @static_ip_connectivity.setter
    def static_ip_connectivity(self, value: Optional[pulumi.Input['MigrationJobStaticIpConnectivityArgs']]):
        pulumi.set(self, "static_ip_connectivity", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of the migration job.
        Possible values are: `ONE_TIME`, `CONTINUOUS`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcPeeringConnectivity")
    def vpc_peering_connectivity(self) -> Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_peering_connectivity")

    @vpc_peering_connectivity.setter
    def vpc_peering_connectivity(self, value: Optional[pulumi.Input['MigrationJobVpcPeeringConnectivityArgs']]):
        pulumi.set(self, "vpc_peering_connectivity", value)


@pulumi.type_token("gcp:databasemigrationservice/migrationJob:MigrationJob")
class MigrationJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dump_flags: Optional[pulumi.Input[Union['MigrationJobDumpFlagsArgs', 'MigrationJobDumpFlagsArgsDict']]] = None,
                 dump_path: Optional[pulumi.Input[builtins.str]] = None,
                 dump_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 migration_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_config: Optional[pulumi.Input[Union['MigrationJobPerformanceConfigArgs', 'MigrationJobPerformanceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_ssh_connectivity: Optional[pulumi.Input[Union['MigrationJobReverseSshConnectivityArgs', 'MigrationJobReverseSshConnectivityArgsDict']]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 static_ip_connectivity: Optional[pulumi.Input[Union['MigrationJobStaticIpConnectivityArgs', 'MigrationJobStaticIpConnectivityArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connectivity: Optional[pulumi.Input[Union['MigrationJobVpcPeeringConnectivityArgs', 'MigrationJobVpcPeeringConnectivityArgsDict']]] = None,
                 __props__=None):
        """
        A migration job definition.

        To get more information about MigrationJob, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        ## Example Usage

        ### Database Migration Service Migration Job Mysql To Mysql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        default = gcp.compute.Network("default", name="destination-csql")
        mysqltomysql = gcp.databasemigrationservice.MigrationJob("mysqltomysql",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            performance_config={
                "dump_parallel_level": "MAX",
            },
            vpc_peering_connectivity={
                "vpc": default.id,
            },
            dump_type="LOGICAL",
            dump_flags={
                "dump_flags": [{
                    "name": "max-allowed-packet",
                    "value": "1073741824",
                }],
            },
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```
        ### Database Migration Service Migration Job Postgres To Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        psqltopsql = gcp.databasemigrationservice.MigrationJob("psqltopsql",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            static_ip_connectivity={},
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```
        ### Database Migration Service Migration Job Postgres To Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        default = gcp.compute.Network("default", name="destination-alloydb")
        destination_alloydb = gcp.alloydb.Cluster("destination_alloydb",
            cluster_id="destination-alloydb",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "destination-alloydb",
                "password": "destination-alloydb",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="destination-alloydb",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        destination_alloydb_primary = gcp.alloydb.Instance("destination_alloydb_primary",
            cluster=destination_alloydb.name,
            instance_id="destination-alloydb-primary",
            instance_type="PRIMARY",
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "alloydb_cluster_id": "destination-alloydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination_alloydb,
                    destination_alloydb_primary,
                ]))
        psqltoalloydb = gcp.databasemigrationservice.MigrationJob("psqltoalloydb",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            static_ip_connectivity={},
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```

        ## Import

        MigrationJob can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/migrationJobs/{{migration_job_id}}`

        * `{{project}}/{{location}}/{{migration_job_id}}`

        * `{{location}}/{{migration_job_id}}`

        When using the `pulumi import` command, MigrationJob can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default projects/{{project}}/locations/{{location}}/migrationJobs/{{migration_job_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default {{project}}/{{location}}/{{migration_job_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default {{location}}/{{migration_job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] destination: The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        :param pulumi.Input[builtins.str] display_name: The migration job display name.
        :param pulumi.Input[Union['MigrationJobDumpFlagsArgs', 'MigrationJobDumpFlagsArgsDict']] dump_flags: The initial dump flags.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dump_path: The path to the dump file in Google Cloud Storage,
               in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
               This field and the "dump_flags" field are mutually exclusive.
        :param pulumi.Input[builtins.str] dump_type: The type of the data dump. Supported for MySQL to CloudSQL for MySQL
               migrations only.
               Possible values are: `LOGICAL`, `PHYSICAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the migration job should reside.
        :param pulumi.Input[builtins.str] migration_job_id: The ID of the migration job.
        :param pulumi.Input[Union['MigrationJobPerformanceConfigArgs', 'MigrationJobPerformanceConfigArgsDict']] performance_config: Data dump parallelism settings used by the migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['MigrationJobReverseSshConnectivityArgs', 'MigrationJobReverseSshConnectivityArgsDict']] reverse_ssh_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source: The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        :param pulumi.Input[Union['MigrationJobStaticIpConnectivityArgs', 'MigrationJobStaticIpConnectivityArgsDict']] static_ip_connectivity: If set to an empty object (`{}`), the source database will allow incoming
               connections from the public IP of the destination database.
               You can retrieve the public IP of the Cloud SQL instance from the
               Cloud SQL console or using Cloud SQL APIs.
        :param pulumi.Input[builtins.str] type: The type of the migration job.
               Possible values are: `ONE_TIME`, `CONTINUOUS`.
        :param pulumi.Input[Union['MigrationJobVpcPeeringConnectivityArgs', 'MigrationJobVpcPeeringConnectivityArgsDict']] vpc_peering_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MigrationJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A migration job definition.

        To get more information about MigrationJob, see:

        * [API documentation](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/create)
        * How-to Guides
            * [Database Migration](https://cloud.google.com/database-migration/docs/)

        ## Example Usage

        ### Database Migration Service Migration Job Mysql To Mysql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="MYSQL_5_7",
            settings={
                "tier": "db-n1-standard-1",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            mysql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        default = gcp.compute.Network("default", name="destination-csql")
        mysqltomysql = gcp.databasemigrationservice.MigrationJob("mysqltomysql",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            performance_config={
                "dump_parallel_level": "MAX",
            },
            vpc_peering_connectivity={
                "vpc": default.id,
            },
            dump_type="LOGICAL",
            dump_flags={
                "dump_flags": [{
                    "name": "max-allowed-packet",
                    "value": "1073741824",
                }],
            },
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```
        ### Database Migration Service Migration Job Postgres To Postgres

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        destination_csql = gcp.sql.DatabaseInstance("destination_csql",
            name="destination-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "cloud_sql_id": "destination-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[destination_csql]))
        psqltopsql = gcp.databasemigrationservice.MigrationJob("psqltopsql",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            static_ip_connectivity={},
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```
        ### Database Migration Service Migration Job Postgres To Alloydb

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        source_csql = gcp.sql.DatabaseInstance("source_csql",
            name="source-csql",
            database_version="POSTGRES_15",
            settings={
                "tier": "db-custom-2-13312",
                "deletion_protection_enabled": False,
            },
            deletion_protection=False)
        source_sql_client_cert = gcp.sql.SslCert("source_sql_client_cert",
            common_name="cert",
            instance=source_csql.name,
            opts = pulumi.ResourceOptions(depends_on=[source_csql]))
        source_sqldb_user = gcp.sql.User("source_sqldb_user",
            name="username",
            instance=source_csql.name,
            password="password",
            opts = pulumi.ResourceOptions(depends_on=[source_sql_client_cert]))
        source_cp = gcp.databasemigrationservice.ConnectionProfile("source_cp",
            location="us-central1",
            connection_profile_id="source-cp",
            display_name="source-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "host": source_csql.ip_addresses[0].ip_address,
                "port": 3306,
                "username": source_sqldb_user.name,
                "password": source_sqldb_user.password,
                "ssl": {
                    "client_key": source_sql_client_cert.private_key,
                    "client_certificate": source_sql_client_cert.cert,
                    "ca_certificate": source_sql_client_cert.server_ca_cert,
                    "type": "SERVER_CLIENT",
                },
                "cloud_sql_id": "source-csql",
            },
            opts = pulumi.ResourceOptions(depends_on=[source_sqldb_user]))
        default = gcp.compute.Network("default", name="destination-alloydb")
        destination_alloydb = gcp.alloydb.Cluster("destination_alloydb",
            cluster_id="destination-alloydb",
            location="us-central1",
            network_config={
                "network": default.id,
            },
            database_version="POSTGRES_15",
            initial_user={
                "user": "destination-alloydb",
                "password": "destination-alloydb",
            })
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="destination-alloydb",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=16,
            network=default.id)
        vpc_connection = gcp.servicenetworking.Connection("vpc_connection",
            network=default.id,
            service="servicenetworking.googleapis.com",
            reserved_peering_ranges=[private_ip_alloc.name])
        destination_alloydb_primary = gcp.alloydb.Instance("destination_alloydb_primary",
            cluster=destination_alloydb.name,
            instance_id="destination-alloydb-primary",
            instance_type="PRIMARY",
            opts = pulumi.ResourceOptions(depends_on=[vpc_connection]))
        destination_cp = gcp.databasemigrationservice.ConnectionProfile("destination_cp",
            location="us-central1",
            connection_profile_id="destination-cp",
            display_name="destination-cp_display",
            labels={
                "foo": "bar",
            },
            postgresql={
                "alloydb_cluster_id": "destination-alloydb",
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    destination_alloydb,
                    destination_alloydb_primary,
                ]))
        psqltoalloydb = gcp.databasemigrationservice.MigrationJob("psqltoalloydb",
            location="us-central1",
            migration_job_id="my-migrationid",
            display_name="my-migrationid_display",
            labels={
                "foo": "bar",
            },
            static_ip_connectivity={},
            source=source_cp.name,
            destination=destination_cp.name,
            type="CONTINUOUS")
        ```

        ## Import

        MigrationJob can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/migrationJobs/{{migration_job_id}}`

        * `{{project}}/{{location}}/{{migration_job_id}}`

        * `{{location}}/{{migration_job_id}}`

        When using the `pulumi import` command, MigrationJob can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default projects/{{project}}/locations/{{location}}/migrationJobs/{{migration_job_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default {{project}}/{{location}}/{{migration_job_id}}
        ```

        ```sh
        $ pulumi import gcp:databasemigrationservice/migrationJob:MigrationJob default {{location}}/{{migration_job_id}}
        ```

        :param str resource_name: The name of the resource.
        :param MigrationJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MigrationJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dump_flags: Optional[pulumi.Input[Union['MigrationJobDumpFlagsArgs', 'MigrationJobDumpFlagsArgsDict']]] = None,
                 dump_path: Optional[pulumi.Input[builtins.str]] = None,
                 dump_type: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 migration_job_id: Optional[pulumi.Input[builtins.str]] = None,
                 performance_config: Optional[pulumi.Input[Union['MigrationJobPerformanceConfigArgs', 'MigrationJobPerformanceConfigArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 reverse_ssh_connectivity: Optional[pulumi.Input[Union['MigrationJobReverseSshConnectivityArgs', 'MigrationJobReverseSshConnectivityArgsDict']]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 static_ip_connectivity: Optional[pulumi.Input[Union['MigrationJobStaticIpConnectivityArgs', 'MigrationJobStaticIpConnectivityArgsDict']]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 vpc_peering_connectivity: Optional[pulumi.Input[Union['MigrationJobVpcPeeringConnectivityArgs', 'MigrationJobVpcPeeringConnectivityArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MigrationJobArgs.__new__(MigrationJobArgs)

            if destination is None and not opts.urn:
                raise TypeError("Missing required property 'destination'")
            __props__.__dict__["destination"] = destination
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dump_flags"] = dump_flags
            __props__.__dict__["dump_path"] = dump_path
            __props__.__dict__["dump_type"] = dump_type
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            if migration_job_id is None and not opts.urn:
                raise TypeError("Missing required property 'migration_job_id'")
            __props__.__dict__["migration_job_id"] = migration_job_id
            __props__.__dict__["performance_config"] = performance_config
            __props__.__dict__["project"] = project
            __props__.__dict__["reverse_ssh_connectivity"] = reverse_ssh_connectivity
            if source is None and not opts.urn:
                raise TypeError("Missing required property 'source'")
            __props__.__dict__["source"] = source
            __props__.__dict__["static_ip_connectivity"] = static_ip_connectivity
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vpc_peering_connectivity"] = vpc_peering_connectivity
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["errors"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["phase"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MigrationJob, __self__).__init__(
            'gcp:databasemigrationservice/migrationJob:MigrationJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dump_flags: Optional[pulumi.Input[Union['MigrationJobDumpFlagsArgs', 'MigrationJobDumpFlagsArgsDict']]] = None,
            dump_path: Optional[pulumi.Input[builtins.str]] = None,
            dump_type: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            errors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MigrationJobErrorArgs', 'MigrationJobErrorArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            migration_job_id: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            performance_config: Optional[pulumi.Input[Union['MigrationJobPerformanceConfigArgs', 'MigrationJobPerformanceConfigArgsDict']]] = None,
            phase: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            reverse_ssh_connectivity: Optional[pulumi.Input[Union['MigrationJobReverseSshConnectivityArgs', 'MigrationJobReverseSshConnectivityArgsDict']]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            static_ip_connectivity: Optional[pulumi.Input[Union['MigrationJobStaticIpConnectivityArgs', 'MigrationJobStaticIpConnectivityArgsDict']]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            vpc_peering_connectivity: Optional[pulumi.Input[Union['MigrationJobVpcPeeringConnectivityArgs', 'MigrationJobVpcPeeringConnectivityArgsDict']]] = None) -> 'MigrationJob':
        """
        Get an existing MigrationJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        :param pulumi.Input[builtins.str] destination: The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        :param pulumi.Input[builtins.str] display_name: The migration job display name.
        :param pulumi.Input[Union['MigrationJobDumpFlagsArgs', 'MigrationJobDumpFlagsArgsDict']] dump_flags: The initial dump flags.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dump_path: The path to the dump file in Google Cloud Storage,
               in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
               This field and the "dump_flags" field are mutually exclusive.
        :param pulumi.Input[builtins.str] dump_type: The type of the data dump. Supported for MySQL to CloudSQL for MySQL
               migrations only.
               Possible values are: `LOGICAL`, `PHYSICAL`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MigrationJobErrorArgs', 'MigrationJobErrorArgsDict']]]] errors: Output only. The error details in case of state FAILED.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where the migration job should reside.
        :param pulumi.Input[builtins.str] migration_job_id: The ID of the migration job.
        :param pulumi.Input[builtins.str] name: The name of this migration job resource in the form of projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
        :param pulumi.Input[Union['MigrationJobPerformanceConfigArgs', 'MigrationJobPerformanceConfigArgsDict']] performance_config: Data dump parallelism settings used by the migration.
               Structure is documented below.
        :param pulumi.Input[builtins.str] phase: The current migration job phase.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['MigrationJobReverseSshConnectivityArgs', 'MigrationJobReverseSshConnectivityArgsDict']] reverse_ssh_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        :param pulumi.Input[builtins.str] source: The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        :param pulumi.Input[builtins.str] state: The current migration job state.
        :param pulumi.Input[Union['MigrationJobStaticIpConnectivityArgs', 'MigrationJobStaticIpConnectivityArgsDict']] static_ip_connectivity: If set to an empty object (`{}`), the source database will allow incoming
               connections from the public IP of the destination database.
               You can retrieve the public IP of the Cloud SQL instance from the
               Cloud SQL console or using Cloud SQL APIs.
        :param pulumi.Input[builtins.str] type: The type of the migration job.
               Possible values are: `ONE_TIME`, `CONTINUOUS`.
        :param pulumi.Input[Union['MigrationJobVpcPeeringConnectivityArgs', 'MigrationJobVpcPeeringConnectivityArgsDict']] vpc_peering_connectivity: The details of the VPC network that the source database is located in.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MigrationJobState.__new__(_MigrationJobState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["destination"] = destination
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dump_flags"] = dump_flags
        __props__.__dict__["dump_path"] = dump_path
        __props__.__dict__["dump_type"] = dump_type
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["errors"] = errors
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["migration_job_id"] = migration_job_id
        __props__.__dict__["name"] = name
        __props__.__dict__["performance_config"] = performance_config
        __props__.__dict__["phase"] = phase
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["reverse_ssh_connectivity"] = reverse_ssh_connectivity
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["static_ip_connectivity"] = static_ip_connectivity
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_peering_connectivity"] = vpc_peering_connectivity
        return MigrationJob(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        Output only. The timestamp when the resource was created. A timestamp in RFC3339 UTC 'Zulu' format, accurate to nanoseconds. Example: '2014-10-02T15:01:23.045123456Z'.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[builtins.str]:
        """
        The name of the destination connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{destinationConnectionProfile}.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The migration job display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dumpFlags")
    def dump_flags(self) -> pulumi.Output[Optional['outputs.MigrationJobDumpFlags']]:
        """
        The initial dump flags.
        Structure is documented below.
        """
        return pulumi.get(self, "dump_flags")

    @property
    @pulumi.getter(name="dumpPath")
    def dump_path(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The path to the dump file in Google Cloud Storage,
        in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
        This field and the "dump_flags" field are mutually exclusive.
        """
        return pulumi.get(self, "dump_path")

    @property
    @pulumi.getter(name="dumpType")
    def dump_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of the data dump. Supported for MySQL to CloudSQL for MySQL
        migrations only.
        Possible values are: `LOGICAL`, `PHYSICAL`.
        """
        return pulumi.get(self, "dump_type")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter
    def errors(self) -> pulumi.Output[Sequence['outputs.MigrationJobError']]:
        """
        Output only. The error details in case of state FAILED.
        Structure is documented below.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The resource labels for migration job to use to annotate any related underlying resources such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location where the migration job should reside.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="migrationJobId")
    def migration_job_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the migration job.
        """
        return pulumi.get(self, "migration_job_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of this migration job resource in the form of projects/{project}/locations/{location}/migrationJobs/{migrationJob}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="performanceConfig")
    def performance_config(self) -> pulumi.Output[Optional['outputs.MigrationJobPerformanceConfig']]:
        """
        Data dump parallelism settings used by the migration.
        Structure is documented below.
        """
        return pulumi.get(self, "performance_config")

    @property
    @pulumi.getter
    def phase(self) -> pulumi.Output[builtins.str]:
        """
        The current migration job phase.
        """
        return pulumi.get(self, "phase")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="reverseSshConnectivity")
    def reverse_ssh_connectivity(self) -> pulumi.Output[Optional['outputs.MigrationJobReverseSshConnectivity']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "reverse_ssh_connectivity")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[builtins.str]:
        """
        The name of the source connection profile resource in the form of projects/{project}/locations/{location}/connectionProfiles/{sourceConnectionProfile}.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current migration job state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticIpConnectivity")
    def static_ip_connectivity(self) -> pulumi.Output[Optional['outputs.MigrationJobStaticIpConnectivity']]:
        """
        If set to an empty object (`{}`), the source database will allow incoming
        connections from the public IP of the destination database.
        You can retrieve the public IP of the Cloud SQL instance from the
        Cloud SQL console or using Cloud SQL APIs.
        """
        return pulumi.get(self, "static_ip_connectivity")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        The type of the migration job.
        Possible values are: `ONE_TIME`, `CONTINUOUS`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcPeeringConnectivity")
    def vpc_peering_connectivity(self) -> pulumi.Output[Optional['outputs.MigrationJobVpcPeeringConnectivity']]:
        """
        The details of the VPC network that the source database is located in.
        Structure is documented below.
        """
        return pulumi.get(self, "vpc_peering_connectivity")

