# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[builtins.str],
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]] = None,
                 crypto_key_config: Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']] = None,
                 dataproc_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_rbac: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 event_publish_config: Optional[pulumi.Input['InstanceEventPublishConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['InstanceNetworkConfigArgs']] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 private_instance: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] type: Represents the type of Data Fusion instance. Each type is configured with
               the default settings for processing and memory.
               - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
               using point and click UI. However, there are certain limitations, such as fewer number
               of concurrent pipelines, no support for streaming pipelines, etc.
               - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
               available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
               - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
               with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
               pipelines at low cost.
               Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]] accelerators: List of accelerators enabled for this CDF instance.
               If accelerators are enabled it is possible a permadiff will be created with the Options field.
               Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
               Structure is documented below.
        :param pulumi.Input['InstanceCryptoKeyConfigArgs'] crypto_key_config: The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dataproc_service_account: User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        :param pulumi.Input[builtins.str] description: An optional description of the instance.
        :param pulumi.Input[builtins.str] display_name: Display name for an instance.
        :param pulumi.Input[builtins.bool] enable_rbac: Option to enable granular role-based access control.
        :param pulumi.Input[builtins.bool] enable_stackdriver_logging: Option to enable Stackdriver Logging.
        :param pulumi.Input[builtins.bool] enable_stackdriver_monitoring: Option to enable Stackdriver Monitoring.
        :param pulumi.Input['InstanceEventPublishConfigArgs'] event_publish_config: Option to enable and pass metadata for event publishing.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for instance to use to annotate any related underlying resources,
               such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input['InstanceNetworkConfigArgs'] network_config: Network configuration options. These are required when a private Data Fusion instance is to be created.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] options: Map of additional options used to configure the behavior of Data Fusion instance.
        :param pulumi.Input[builtins.bool] private_instance: Specifies whether the Data Fusion instance should be private. If set to
               true, all Data Fusion nodes will have private IP addresses and will not be
               able to access the public internet.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of the Data Fusion instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags.
               Resource manager tag keys and values have the same definition as resource manager tags.
               Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
               The field is ignored (both PUT & PATCH) when empty.
        :param pulumi.Input[builtins.str] version: Current version of the Data Fusion.
        :param pulumi.Input[builtins.str] zone: Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        pulumi.set(__self__, "type", type)
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if crypto_key_config is not None:
            pulumi.set(__self__, "crypto_key_config", crypto_key_config)
        if dataproc_service_account is not None:
            pulumi.set(__self__, "dataproc_service_account", dataproc_service_account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if enable_stackdriver_monitoring is not None:
            pulumi.set(__self__, "enable_stackdriver_monitoring", enable_stackdriver_monitoring)
        if event_publish_config is not None:
            pulumi.set(__self__, "event_publish_config", event_publish_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if private_instance is not None:
            pulumi.set(__self__, "private_instance", private_instance)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Represents the type of Data Fusion instance. Each type is configured with
        the default settings for processing and memory.
        - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
        using point and click UI. However, there are certain limitations, such as fewer number
        of concurrent pipelines, no support for streaming pipelines, etc.
        - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
        available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
        - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
        with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
        pipelines at low cost.
        Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]]:
        """
        List of accelerators enabled for this CDF instance.
        If accelerators are enabled it is possible a permadiff will be created with the Options field.
        Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']]:
        """
        The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @crypto_key_config.setter
    def crypto_key_config(self, value: Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']]):
        pulumi.set(self, "crypto_key_config", value)

    @property
    @pulumi.getter(name="dataprocServiceAccount")
    def dataproc_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        """
        return pulumi.get(self, "dataproc_service_account")

    @dataproc_service_account.setter
    def dataproc_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataproc_service_account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name for an instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable granular role-based access control.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_rbac", value)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable Stackdriver Logging.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @property
    @pulumi.getter(name="enableStackdriverMonitoring")
    def enable_stackdriver_monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable Stackdriver Monitoring.
        """
        return pulumi.get(self, "enable_stackdriver_monitoring")

    @enable_stackdriver_monitoring.setter
    def enable_stackdriver_monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_monitoring", value)

    @property
    @pulumi.getter(name="eventPublishConfig")
    def event_publish_config(self) -> Optional[pulumi.Input['InstanceEventPublishConfigArgs']]:
        """
        Option to enable and pass metadata for event publishing.
        Structure is documented below.
        """
        return pulumi.get(self, "event_publish_config")

    @event_publish_config.setter
    def event_publish_config(self, value: Optional[pulumi.Input['InstanceEventPublishConfigArgs']]):
        pulumi.set(self, "event_publish_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for instance to use to annotate any related underlying resources,
        such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['InstanceNetworkConfigArgs']]:
        """
        Network configuration options. These are required when a private Data Fusion instance is to be created.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['InstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of additional options used to configure the behavior of Data Fusion instance.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="privateInstance")
    def private_instance(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Data Fusion instance should be private. If set to
        true, all Data Fusion nodes will have private IP addresses and will not be
        able to access the public internet.
        """
        return pulumi.get(self, "private_instance")

    @private_instance.setter
    def private_instance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private_instance", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of resource manager tags.
        Resource manager tag keys and values have the same definition as resource manager tags.
        Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
        The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current version of the Data Fusion.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]] = None,
                 api_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 crypto_key_config: Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']] = None,
                 dataproc_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 enable_rbac: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 event_publish_config: Optional[pulumi.Input['InstanceEventPublishConfigArgs']] = None,
                 gcs_bucket: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input['InstanceNetworkConfigArgs']] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 p4_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 private_instance: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 service_account: Optional[pulumi.Input[builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 state_message: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_project_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]] accelerators: List of accelerators enabled for this CDF instance.
               If accelerators are enabled it is possible a permadiff will be created with the Options field.
               Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
               Structure is documented below.
        :param pulumi.Input[builtins.str] api_endpoint: Endpoint on which the REST APIs is accessible.
        :param pulumi.Input[builtins.str] create_time: The time the instance was created in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        :param pulumi.Input['InstanceCryptoKeyConfigArgs'] crypto_key_config: The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dataproc_service_account: User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        :param pulumi.Input[builtins.str] description: An optional description of the instance.
        :param pulumi.Input[builtins.str] display_name: Display name for an instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_rbac: Option to enable granular role-based access control.
        :param pulumi.Input[builtins.bool] enable_stackdriver_logging: Option to enable Stackdriver Logging.
        :param pulumi.Input[builtins.bool] enable_stackdriver_monitoring: Option to enable Stackdriver Monitoring.
        :param pulumi.Input['InstanceEventPublishConfigArgs'] event_publish_config: Option to enable and pass metadata for event publishing.
               Structure is documented below.
        :param pulumi.Input[builtins.str] gcs_bucket: Cloud Storage bucket generated by Data Fusion in the customer project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for instance to use to annotate any related underlying resources,
               such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input['InstanceNetworkConfigArgs'] network_config: Network configuration options. These are required when a private Data Fusion instance is to be created.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] options: Map of additional options used to configure the behavior of Data Fusion instance.
        :param pulumi.Input[builtins.str] p4_service_account: P4 service account for the customer project.
        :param pulumi.Input[builtins.bool] private_instance: Specifies whether the Data Fusion instance should be private. If set to
               true, all Data Fusion nodes will have private IP addresses and will not be
               able to access the public internet.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region of the Data Fusion instance.
        :param pulumi.Input[builtins.str] service_account: Service account which will be used to access resources in the customer project.
        :param pulumi.Input[builtins.str] service_endpoint: Endpoint on which the Data Fusion UI and REST APIs are accessible.
        :param pulumi.Input[builtins.str] state: The current state of this Data Fusion instance.
               - CREATING: Instance is being created
               - RUNNING: Instance is running and ready for requests
               - FAILED: Instance creation failed
               - DELETING: Instance is being deleted
               - UPGRADING: Instance is being upgraded
               - RESTARTING: Instance is being restarted
        :param pulumi.Input[builtins.str] state_message: Additional information about the current state of this Data Fusion instance if available.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags.
               Resource manager tag keys and values have the same definition as resource manager tags.
               Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
               The field is ignored (both PUT & PATCH) when empty.
        :param pulumi.Input[builtins.str] tenant_project_id: The name of the tenant project.
        :param pulumi.Input[builtins.str] type: Represents the type of Data Fusion instance. Each type is configured with
               the default settings for processing and memory.
               - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
               using point and click UI. However, there are certain limitations, such as fewer number
               of concurrent pipelines, no support for streaming pipelines, etc.
               - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
               available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
               - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
               with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
               pipelines at low cost.
               Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        :param pulumi.Input[builtins.str] update_time: The time the instance was last updated in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        :param pulumi.Input[builtins.str] version: Current version of the Data Fusion.
        :param pulumi.Input[builtins.str] zone: Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        if accelerators is not None:
            pulumi.set(__self__, "accelerators", accelerators)
        if api_endpoint is not None:
            pulumi.set(__self__, "api_endpoint", api_endpoint)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if crypto_key_config is not None:
            pulumi.set(__self__, "crypto_key_config", crypto_key_config)
        if dataproc_service_account is not None:
            pulumi.set(__self__, "dataproc_service_account", dataproc_service_account)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if enable_rbac is not None:
            pulumi.set(__self__, "enable_rbac", enable_rbac)
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)
        if enable_stackdriver_monitoring is not None:
            pulumi.set(__self__, "enable_stackdriver_monitoring", enable_stackdriver_monitoring)
        if event_publish_config is not None:
            pulumi.set(__self__, "event_publish_config", event_publish_config)
        if gcs_bucket is not None:
            pulumi.set(__self__, "gcs_bucket", gcs_bucket)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_config is not None:
            pulumi.set(__self__, "network_config", network_config)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if p4_service_account is not None:
            pulumi.set(__self__, "p4_service_account", p4_service_account)
        if private_instance is not None:
            pulumi.set(__self__, "private_instance", private_instance)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_account is not None:
            warnings.warn("""`service_account` is deprecated and will be removed in a future major release. Instead, use `tenant_project_id` to extract the tenant project ID.""", DeprecationWarning)
            pulumi.log.warn("""service_account is deprecated: `service_account` is deprecated and will be removed in a future major release. Instead, use `tenant_project_id` to extract the tenant project ID.""")
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if service_endpoint is not None:
            pulumi.set(__self__, "service_endpoint", service_endpoint)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if state_message is not None:
            pulumi.set(__self__, "state_message", state_message)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_project_id is not None:
            pulumi.set(__self__, "tenant_project_id", tenant_project_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def accelerators(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]]:
        """
        List of accelerators enabled for this CDF instance.
        If accelerators are enabled it is possible a permadiff will be created with the Options field.
        Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerators")

    @accelerators.setter
    def accelerators(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceAcceleratorArgs']]]]):
        pulumi.set(self, "accelerators", value)

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint on which the REST APIs is accessible.
        """
        return pulumi.get(self, "api_endpoint")

    @api_endpoint.setter
    def api_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "api_endpoint", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the instance was created in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']]:
        """
        The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @crypto_key_config.setter
    def crypto_key_config(self, value: Optional[pulumi.Input['InstanceCryptoKeyConfigArgs']]):
        pulumi.set(self, "crypto_key_config", value)

    @property
    @pulumi.getter(name="dataprocServiceAccount")
    def dataproc_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        """
        return pulumi.get(self, "dataproc_service_account")

    @dataproc_service_account.setter
    def dataproc_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dataproc_service_account", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of the instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Display name for an instance.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable granular role-based access control.
        """
        return pulumi.get(self, "enable_rbac")

    @enable_rbac.setter
    def enable_rbac(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_rbac", value)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable Stackdriver Logging.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)

    @property
    @pulumi.getter(name="enableStackdriverMonitoring")
    def enable_stackdriver_monitoring(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Option to enable Stackdriver Monitoring.
        """
        return pulumi.get(self, "enable_stackdriver_monitoring")

    @enable_stackdriver_monitoring.setter
    def enable_stackdriver_monitoring(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_stackdriver_monitoring", value)

    @property
    @pulumi.getter(name="eventPublishConfig")
    def event_publish_config(self) -> Optional[pulumi.Input['InstanceEventPublishConfigArgs']]:
        """
        Option to enable and pass metadata for event publishing.
        Structure is documented below.
        """
        return pulumi.get(self, "event_publish_config")

    @event_publish_config.setter
    def event_publish_config(self, value: Optional[pulumi.Input['InstanceEventPublishConfigArgs']]):
        pulumi.set(self, "event_publish_config", value)

    @property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Cloud Storage bucket generated by Data Fusion in the customer project.
        """
        return pulumi.get(self, "gcs_bucket")

    @gcs_bucket.setter
    def gcs_bucket(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "gcs_bucket", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The resource labels for instance to use to annotate any related underlying resources,
        such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> Optional[pulumi.Input['InstanceNetworkConfigArgs']]:
        """
        Network configuration options. These are required when a private Data Fusion instance is to be created.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @network_config.setter
    def network_config(self, value: Optional[pulumi.Input['InstanceNetworkConfigArgs']]):
        pulumi.set(self, "network_config", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Map of additional options used to configure the behavior of Data Fusion instance.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="p4ServiceAccount")
    def p4_service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        P4 service account for the customer project.
        """
        return pulumi.get(self, "p4_service_account")

    @p4_service_account.setter
    def p4_service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "p4_service_account", value)

    @property
    @pulumi.getter(name="privateInstance")
    def private_instance(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether the Data Fusion instance should be private. If set to
        true, all Data Fusion nodes will have private IP addresses and will not be
        able to access the public internet.
        """
        return pulumi.get(self, "private_instance")

    @private_instance.setter
    def private_instance(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "private_instance", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceAccount")
    @_utilities.deprecated("""`service_account` is deprecated and will be removed in a future major release. Instead, use `tenant_project_id` to extract the tenant project ID.""")
    def service_account(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Service account which will be used to access resources in the customer project.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Endpoint on which the Data Fusion UI and REST APIs are accessible.
        """
        return pulumi.get(self, "service_endpoint")

    @service_endpoint.setter
    def service_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_endpoint", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of this Data Fusion instance.
        - CREATING: Instance is being created
        - RUNNING: Instance is running and ready for requests
        - FAILED: Instance creation failed
        - DELETING: Instance is being deleted
        - UPGRADING: Instance is being upgraded
        - RESTARTING: Instance is being restarted
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current state of this Data Fusion instance if available.
        """
        return pulumi.get(self, "state_message")

    @state_message.setter
    def state_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state_message", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of resource manager tags.
        Resource manager tag keys and values have the same definition as resource manager tags.
        Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
        The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantProjectId")
    def tenant_project_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the tenant project.
        """
        return pulumi.get(self, "tenant_project_id")

    @tenant_project_id.setter
    def tenant_project_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_project_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Represents the type of Data Fusion instance. Each type is configured with
        the default settings for processing and memory.
        - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
        using point and click UI. However, there are certain limitations, such as fewer number
        of concurrent pipelines, no support for streaming pipelines, etc.
        - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
        available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
        - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
        with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
        pipelines at low cost.
        Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the instance was last updated in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Current version of the Data Fusion.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("gcp:datafusion/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAcceleratorArgs', 'InstanceAcceleratorArgsDict']]]]] = None,
                 crypto_key_config: Optional[pulumi.Input[Union['InstanceCryptoKeyConfigArgs', 'InstanceCryptoKeyConfigArgsDict']]] = None,
                 dataproc_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_rbac: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 event_publish_config: Optional[pulumi.Input[Union['InstanceEventPublishConfigArgs', 'InstanceEventPublishConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 private_instance: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        Represents a Data Fusion instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/data-fusion/docs/reference/rest/v1beta1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-fusion/docs/)

        ## Example Usage

        ### Data Fusion Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_instance = gcp.datafusion.Instance("basic_instance",
            name="my-instance",
            region="us-central1",
            type="BASIC")
        ```
        ### Data Fusion Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.appengine.get_default_service_account()
        network = gcp.compute.Network("network", name="datafusion-full-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="datafusion-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=22,
            network=network.id)
        extended_instance = gcp.datafusion.Instance("extended_instance",
            name="my-instance",
            description="My Data Fusion instance",
            display_name="My Data Fusion instance",
            region="us-central1",
            type="BASIC",
            enable_stackdriver_logging=True,
            enable_stackdriver_monitoring=True,
            private_instance=True,
            dataproc_service_account=default.email,
            labels={
                "example_key": "example_value",
            },
            network_config={
                "network": "default",
                "ip_allocation": pulumi.Output.all(
                    address=private_ip_alloc.address,
                    prefix_length=private_ip_alloc.prefix_length
        ).apply(lambda resolved_outputs: f"{resolved_outputs['address']}/{resolved_outputs['prefix_length']}")
        ,
            },
            accelerators=[{
                "accelerator_type": "CDC",
                "state": "ENABLED",
            }])
        ```
        ### Data Fusion Instance Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc = gcp.compute.Network("psc",
            name="datafusion-psc-network",
            auto_create_subnetworks=False)
        psc_subnetwork = gcp.compute.Subnetwork("psc",
            name="datafusion-psc-subnet",
            region="us-central1",
            network=psc.id,
            ip_cidr_range="10.0.0.0/16")
        psc_network_attachment = gcp.compute.NetworkAttachment("psc",
            name="datafusion-psc-attachment",
            region="us-central1",
            connection_preference="ACCEPT_AUTOMATIC",
            subnetworks=[psc_subnetwork.self_link])
        psc_instance = gcp.datafusion.Instance("psc_instance",
            name="psc-instance",
            region="us-central1",
            type="BASIC",
            private_instance=True,
            network_config={
                "connection_type": "PRIVATE_SERVICE_CONNECT_INTERFACES",
                "private_service_connect_config": {
                    "network_attachment": psc_network_attachment.id,
                    "unreachable_cidr_block": "192.168.0.0/25",
                },
            })
        ```
        ### Data Fusion Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="my-instance",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="my-instance",
            key_ring=key_ring.id)
        project = gcp.organizations.get_project()
        crypto_key_member = gcp.kms.CryptoKeyIAMMember("crypto_key_member",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datafusion.iam.gserviceaccount.com")
        cmek = gcp.datafusion.Instance("cmek",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            crypto_key_config={
                "key_reference": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member]))
        ```
        ### Data Fusion Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_instance = gcp.datafusion.Instance("enterprise_instance",
            name="my-instance",
            region="us-central1",
            type="ENTERPRISE",
            enable_rbac=True)
        ```
        ### Data Fusion Instance Event

        ```python
        import pulumi
        import pulumi_gcp as gcp

        event_topic = gcp.pubsub.Topic("event", name="my-instance")
        event = gcp.datafusion.Instance("event",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            event_publish_config={
                "enabled": True,
                "topic": event_topic.id,
            })
        ```
        ### Data Fusion Instance Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        zone = gcp.datafusion.Instance("zone",
            name="my-instance",
            region="us-central1",
            zone="us-central1-a",
            type="DEVELOPER")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAcceleratorArgs', 'InstanceAcceleratorArgsDict']]]] accelerators: List of accelerators enabled for this CDF instance.
               If accelerators are enabled it is possible a permadiff will be created with the Options field.
               Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
               Structure is documented below.
        :param pulumi.Input[Union['InstanceCryptoKeyConfigArgs', 'InstanceCryptoKeyConfigArgsDict']] crypto_key_config: The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dataproc_service_account: User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        :param pulumi.Input[builtins.str] description: An optional description of the instance.
        :param pulumi.Input[builtins.str] display_name: Display name for an instance.
        :param pulumi.Input[builtins.bool] enable_rbac: Option to enable granular role-based access control.
        :param pulumi.Input[builtins.bool] enable_stackdriver_logging: Option to enable Stackdriver Logging.
        :param pulumi.Input[builtins.bool] enable_stackdriver_monitoring: Option to enable Stackdriver Monitoring.
        :param pulumi.Input[Union['InstanceEventPublishConfigArgs', 'InstanceEventPublishConfigArgsDict']] event_publish_config: Option to enable and pass metadata for event publishing.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for instance to use to annotate any related underlying resources,
               such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']] network_config: Network configuration options. These are required when a private Data Fusion instance is to be created.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] options: Map of additional options used to configure the behavior of Data Fusion instance.
        :param pulumi.Input[builtins.bool] private_instance: Specifies whether the Data Fusion instance should be private. If set to
               true, all Data Fusion nodes will have private IP addresses and will not be
               able to access the public internet.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[builtins.str] region: The region of the Data Fusion instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags.
               Resource manager tag keys and values have the same definition as resource manager tags.
               Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
               The field is ignored (both PUT & PATCH) when empty.
        :param pulumi.Input[builtins.str] type: Represents the type of Data Fusion instance. Each type is configured with
               the default settings for processing and memory.
               - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
               using point and click UI. However, there are certain limitations, such as fewer number
               of concurrent pipelines, no support for streaming pipelines, etc.
               - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
               available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
               - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
               with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
               pipelines at low cost.
               Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        :param pulumi.Input[builtins.str] version: Current version of the Data Fusion.
        :param pulumi.Input[builtins.str] zone: Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Represents a Data Fusion instance.

        To get more information about Instance, see:

        * [API documentation](https://cloud.google.com/data-fusion/docs/reference/rest/v1beta1/projects.locations.instances)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/data-fusion/docs/)

        ## Example Usage

        ### Data Fusion Instance Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic_instance = gcp.datafusion.Instance("basic_instance",
            name="my-instance",
            region="us-central1",
            type="BASIC")
        ```
        ### Data Fusion Instance Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.appengine.get_default_service_account()
        network = gcp.compute.Network("network", name="datafusion-full-network")
        private_ip_alloc = gcp.compute.GlobalAddress("private_ip_alloc",
            name="datafusion-ip-alloc",
            address_type="INTERNAL",
            purpose="VPC_PEERING",
            prefix_length=22,
            network=network.id)
        extended_instance = gcp.datafusion.Instance("extended_instance",
            name="my-instance",
            description="My Data Fusion instance",
            display_name="My Data Fusion instance",
            region="us-central1",
            type="BASIC",
            enable_stackdriver_logging=True,
            enable_stackdriver_monitoring=True,
            private_instance=True,
            dataproc_service_account=default.email,
            labels={
                "example_key": "example_value",
            },
            network_config={
                "network": "default",
                "ip_allocation": pulumi.Output.all(
                    address=private_ip_alloc.address,
                    prefix_length=private_ip_alloc.prefix_length
        ).apply(lambda resolved_outputs: f"{resolved_outputs['address']}/{resolved_outputs['prefix_length']}")
        ,
            },
            accelerators=[{
                "accelerator_type": "CDC",
                "state": "ENABLED",
            }])
        ```
        ### Data Fusion Instance Psc

        ```python
        import pulumi
        import pulumi_gcp as gcp

        psc = gcp.compute.Network("psc",
            name="datafusion-psc-network",
            auto_create_subnetworks=False)
        psc_subnetwork = gcp.compute.Subnetwork("psc",
            name="datafusion-psc-subnet",
            region="us-central1",
            network=psc.id,
            ip_cidr_range="10.0.0.0/16")
        psc_network_attachment = gcp.compute.NetworkAttachment("psc",
            name="datafusion-psc-attachment",
            region="us-central1",
            connection_preference="ACCEPT_AUTOMATIC",
            subnetworks=[psc_subnetwork.self_link])
        psc_instance = gcp.datafusion.Instance("psc_instance",
            name="psc-instance",
            region="us-central1",
            type="BASIC",
            private_instance=True,
            network_config={
                "connection_type": "PRIVATE_SERVICE_CONNECT_INTERFACES",
                "private_service_connect_config": {
                    "network_attachment": psc_network_attachment.id,
                    "unreachable_cidr_block": "192.168.0.0/25",
                },
            })
        ```
        ### Data Fusion Instance Cmek

        ```python
        import pulumi
        import pulumi_gcp as gcp

        key_ring = gcp.kms.KeyRing("key_ring",
            name="my-instance",
            location="us-central1")
        crypto_key = gcp.kms.CryptoKey("crypto_key",
            name="my-instance",
            key_ring=key_ring.id)
        project = gcp.organizations.get_project()
        crypto_key_member = gcp.kms.CryptoKeyIAMMember("crypto_key_member",
            crypto_key_id=crypto_key.id,
            role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
            member=f"serviceAccount:service-{project.number}@gcp-sa-datafusion.iam.gserviceaccount.com")
        cmek = gcp.datafusion.Instance("cmek",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            crypto_key_config={
                "key_reference": crypto_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[crypto_key_member]))
        ```
        ### Data Fusion Instance Enterprise

        ```python
        import pulumi
        import pulumi_gcp as gcp

        enterprise_instance = gcp.datafusion.Instance("enterprise_instance",
            name="my-instance",
            region="us-central1",
            type="ENTERPRISE",
            enable_rbac=True)
        ```
        ### Data Fusion Instance Event

        ```python
        import pulumi
        import pulumi_gcp as gcp

        event_topic = gcp.pubsub.Topic("event", name="my-instance")
        event = gcp.datafusion.Instance("event",
            name="my-instance",
            region="us-central1",
            type="BASIC",
            event_publish_config={
                "enabled": True,
                "topic": event_topic.id,
            })
        ```
        ### Data Fusion Instance Zone

        ```python
        import pulumi
        import pulumi_gcp as gcp

        zone = gcp.datafusion.Instance("zone",
            name="my-instance",
            region="us-central1",
            zone="us-central1-a",
            type="DEVELOPER")
        ```

        ## Import

        Instance can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{region}}/instances/{{name}}`

        * `{{project}}/{{region}}/{{name}}`

        * `{{region}}/{{name}}`

        * `{{name}}`

        When using the `pulumi import` command, Instance can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default projects/{{project}}/locations/{{region}}/instances/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{project}}/{{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{region}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:datafusion/instance:Instance default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAcceleratorArgs', 'InstanceAcceleratorArgsDict']]]]] = None,
                 crypto_key_config: Optional[pulumi.Input[Union['InstanceCryptoKeyConfigArgs', 'InstanceCryptoKeyConfigArgsDict']]] = None,
                 dataproc_service_account: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_rbac: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_logging: Optional[pulumi.Input[builtins.bool]] = None,
                 enable_stackdriver_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
                 event_publish_config: Optional[pulumi.Input[Union['InstanceEventPublishConfigArgs', 'InstanceEventPublishConfigArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
                 options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 private_instance: Optional[pulumi.Input[builtins.bool]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 version: Optional[pulumi.Input[builtins.str]] = None,
                 zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["accelerators"] = accelerators
            __props__.__dict__["crypto_key_config"] = crypto_key_config
            __props__.__dict__["dataproc_service_account"] = dataproc_service_account
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_rbac"] = enable_rbac
            __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
            __props__.__dict__["enable_stackdriver_monitoring"] = enable_stackdriver_monitoring
            __props__.__dict__["event_publish_config"] = event_publish_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["network_config"] = network_config
            __props__.__dict__["options"] = options
            __props__.__dict__["private_instance"] = private_instance
            __props__.__dict__["project"] = project
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["version"] = version
            __props__.__dict__["zone"] = zone
            __props__.__dict__["api_endpoint"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["gcs_bucket"] = None
            __props__.__dict__["p4_service_account"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["service_account"] = None
            __props__.__dict__["service_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["tenant_project_id"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'gcp:datafusion/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceAcceleratorArgs', 'InstanceAcceleratorArgsDict']]]]] = None,
            api_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            crypto_key_config: Optional[pulumi.Input[Union['InstanceCryptoKeyConfigArgs', 'InstanceCryptoKeyConfigArgsDict']]] = None,
            dataproc_service_account: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            enable_rbac: Optional[pulumi.Input[builtins.bool]] = None,
            enable_stackdriver_logging: Optional[pulumi.Input[builtins.bool]] = None,
            enable_stackdriver_monitoring: Optional[pulumi.Input[builtins.bool]] = None,
            event_publish_config: Optional[pulumi.Input[Union['InstanceEventPublishConfigArgs', 'InstanceEventPublishConfigArgsDict']]] = None,
            gcs_bucket: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_config: Optional[pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']]] = None,
            options: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            p4_service_account: Optional[pulumi.Input[builtins.str]] = None,
            private_instance: Optional[pulumi.Input[builtins.bool]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            service_account: Optional[pulumi.Input[builtins.str]] = None,
            service_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            state_message: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenant_project_id: Optional[pulumi.Input[builtins.str]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None,
            version: Optional[pulumi.Input[builtins.str]] = None,
            zone: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceAcceleratorArgs', 'InstanceAcceleratorArgsDict']]]] accelerators: List of accelerators enabled for this CDF instance.
               If accelerators are enabled it is possible a permadiff will be created with the Options field.
               Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
               Structure is documented below.
        :param pulumi.Input[builtins.str] api_endpoint: Endpoint on which the REST APIs is accessible.
        :param pulumi.Input[builtins.str] create_time: The time the instance was created in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        :param pulumi.Input[Union['InstanceCryptoKeyConfigArgs', 'InstanceCryptoKeyConfigArgsDict']] crypto_key_config: The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
               Structure is documented below.
        :param pulumi.Input[builtins.str] dataproc_service_account: User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        :param pulumi.Input[builtins.str] description: An optional description of the instance.
        :param pulumi.Input[builtins.str] display_name: Display name for an instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.bool] enable_rbac: Option to enable granular role-based access control.
        :param pulumi.Input[builtins.bool] enable_stackdriver_logging: Option to enable Stackdriver Logging.
        :param pulumi.Input[builtins.bool] enable_stackdriver_monitoring: Option to enable Stackdriver Monitoring.
        :param pulumi.Input[Union['InstanceEventPublishConfigArgs', 'InstanceEventPublishConfigArgsDict']] event_publish_config: Option to enable and pass metadata for event publishing.
               Structure is documented below.
        :param pulumi.Input[builtins.str] gcs_bucket: Cloud Storage bucket generated by Data Fusion in the customer project.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: The resource labels for instance to use to annotate any related underlying resources,
               such as Compute Engine VMs.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] name: The ID of the instance or a fully qualified identifier for the instance.
        :param pulumi.Input[Union['InstanceNetworkConfigArgs', 'InstanceNetworkConfigArgsDict']] network_config: Network configuration options. These are required when a private Data Fusion instance is to be created.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] options: Map of additional options used to configure the behavior of Data Fusion instance.
        :param pulumi.Input[builtins.str] p4_service_account: P4 service account for the customer project.
        :param pulumi.Input[builtins.bool] private_instance: Specifies whether the Data Fusion instance should be private. If set to
               true, all Data Fusion nodes will have private IP addresses and will not be
               able to access the public internet.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[builtins.str] region: The region of the Data Fusion instance.
        :param pulumi.Input[builtins.str] service_account: Service account which will be used to access resources in the customer project.
        :param pulumi.Input[builtins.str] service_endpoint: Endpoint on which the Data Fusion UI and REST APIs are accessible.
        :param pulumi.Input[builtins.str] state: The current state of this Data Fusion instance.
               - CREATING: Instance is being created
               - RUNNING: Instance is running and ready for requests
               - FAILED: Instance creation failed
               - DELETING: Instance is being deleted
               - UPGRADING: Instance is being upgraded
               - RESTARTING: Instance is being restarted
        :param pulumi.Input[builtins.str] state_message: Additional information about the current state of this Data Fusion instance if available.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] tags: A map of resource manager tags.
               Resource manager tag keys and values have the same definition as resource manager tags.
               Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
               The field is ignored (both PUT & PATCH) when empty.
        :param pulumi.Input[builtins.str] tenant_project_id: The name of the tenant project.
        :param pulumi.Input[builtins.str] type: Represents the type of Data Fusion instance. Each type is configured with
               the default settings for processing and memory.
               - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
               using point and click UI. However, there are certain limitations, such as fewer number
               of concurrent pipelines, no support for streaming pipelines, etc.
               - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
               available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
               - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
               with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
               pipelines at low cost.
               Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        :param pulumi.Input[builtins.str] update_time: The time the instance was last updated in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        :param pulumi.Input[builtins.str] version: Current version of the Data Fusion.
        :param pulumi.Input[builtins.str] zone: Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["accelerators"] = accelerators
        __props__.__dict__["api_endpoint"] = api_endpoint
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["crypto_key_config"] = crypto_key_config
        __props__.__dict__["dataproc_service_account"] = dataproc_service_account
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["enable_rbac"] = enable_rbac
        __props__.__dict__["enable_stackdriver_logging"] = enable_stackdriver_logging
        __props__.__dict__["enable_stackdriver_monitoring"] = enable_stackdriver_monitoring
        __props__.__dict__["event_publish_config"] = event_publish_config
        __props__.__dict__["gcs_bucket"] = gcs_bucket
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network_config"] = network_config
        __props__.__dict__["options"] = options
        __props__.__dict__["p4_service_account"] = p4_service_account
        __props__.__dict__["private_instance"] = private_instance
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["region"] = region
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["service_endpoint"] = service_endpoint
        __props__.__dict__["state"] = state
        __props__.__dict__["state_message"] = state_message
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_project_id"] = tenant_project_id
        __props__.__dict__["type"] = type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accelerators(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceAccelerator']]]:
        """
        List of accelerators enabled for this CDF instance.
        If accelerators are enabled it is possible a permadiff will be created with the Options field.
        Users will need to either manually update their state file to include these diffed options, or include the field in a lifecycle ignore changes block.
        Structure is documented below.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="apiEndpoint")
    def api_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Endpoint on which the REST APIs is accessible.
        """
        return pulumi.get(self, "api_endpoint")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the instance was created in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="cryptoKeyConfig")
    def crypto_key_config(self) -> pulumi.Output[Optional['outputs.InstanceCryptoKeyConfig']]:
        """
        The crypto key configuration. This field is used by the Customer-Managed Encryption Keys (CMEK) feature.
        Structure is documented below.
        """
        return pulumi.get(self, "crypto_key_config")

    @property
    @pulumi.getter(name="dataprocServiceAccount")
    def dataproc_service_account(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-managed service account to set on Dataproc when Cloud Data Fusion creates Dataproc to run data processing pipelines.
        """
        return pulumi.get(self, "dataproc_service_account")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An optional description of the instance.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Display name for an instance.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="enableRbac")
    def enable_rbac(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Option to enable granular role-based access control.
        """
        return pulumi.get(self, "enable_rbac")

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Option to enable Stackdriver Logging.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @property
    @pulumi.getter(name="enableStackdriverMonitoring")
    def enable_stackdriver_monitoring(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Option to enable Stackdriver Monitoring.
        """
        return pulumi.get(self, "enable_stackdriver_monitoring")

    @property
    @pulumi.getter(name="eventPublishConfig")
    def event_publish_config(self) -> pulumi.Output[Optional['outputs.InstanceEventPublishConfig']]:
        """
        Option to enable and pass metadata for event publishing.
        Structure is documented below.
        """
        return pulumi.get(self, "event_publish_config")

    @property
    @pulumi.getter(name="gcsBucket")
    def gcs_bucket(self) -> pulumi.Output[builtins.str]:
        """
        Cloud Storage bucket generated by Data Fusion in the customer project.
        """
        return pulumi.get(self, "gcs_bucket")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        The resource labels for instance to use to annotate any related underlying resources,
        such as Compute Engine VMs.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the instance or a fully qualified identifier for the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkConfig")
    def network_config(self) -> pulumi.Output[Optional['outputs.InstanceNetworkConfig']]:
        """
        Network configuration options. These are required when a private Data Fusion instance is to be created.
        Structure is documented below.
        """
        return pulumi.get(self, "network_config")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Map of additional options used to configure the behavior of Data Fusion instance.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="p4ServiceAccount")
    def p4_service_account(self) -> pulumi.Output[builtins.str]:
        """
        P4 service account for the customer project.
        """
        return pulumi.get(self, "p4_service_account")

    @property
    @pulumi.getter(name="privateInstance")
    def private_instance(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Specifies whether the Data Fusion instance should be private. If set to
        true, all Data Fusion nodes will have private IP addresses and will not be
        able to access the public internet.
        """
        return pulumi.get(self, "private_instance")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region of the Data Fusion instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceAccount")
    @_utilities.deprecated("""`service_account` is deprecated and will be removed in a future major release. Instead, use `tenant_project_id` to extract the tenant project ID.""")
    def service_account(self) -> pulumi.Output[builtins.str]:
        """
        Service account which will be used to access resources in the customer project.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        Endpoint on which the Data Fusion UI and REST APIs are accessible.
        """
        return pulumi.get(self, "service_endpoint")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of this Data Fusion instance.
        - CREATING: Instance is being created
        - RUNNING: Instance is running and ready for requests
        - FAILED: Instance creation failed
        - DELETING: Instance is being deleted
        - UPGRADING: Instance is being upgraded
        - RESTARTING: Instance is being restarted
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current state of this Data Fusion instance if available.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of resource manager tags.
        Resource manager tag keys and values have the same definition as resource manager tags.
        Keys must be in the format tagKeys/{tag_key_id}, and values are in the format tagValues/{tag_value_id}.
        The field is ignored (both PUT & PATCH) when empty.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantProjectId")
    def tenant_project_id(self) -> pulumi.Output[builtins.str]:
        """
        The name of the tenant project.
        """
        return pulumi.get(self, "tenant_project_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Represents the type of Data Fusion instance. Each type is configured with
        the default settings for processing and memory.
        - BASIC: Basic Data Fusion instance. In Basic type, the user will be able to create data pipelines
        using point and click UI. However, there are certain limitations, such as fewer number
        of concurrent pipelines, no support for streaming pipelines, etc.
        - ENTERPRISE: Enterprise Data Fusion instance. In Enterprise type, the user will have more features
        available, such as support for streaming pipelines, higher number of concurrent pipelines, etc.
        - DEVELOPER: Developer Data Fusion instance. In Developer type, the user will have all features available but
        with restrictive capabilities. This is to help enterprises design and develop their data ingestion and integration
        pipelines at low cost.
        Possible values are: `BASIC`, `ENTERPRISE`, `DEVELOPER`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time the instance was last updated in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[builtins.str]:
        """
        Current version of the Data Fusion.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[builtins.str]:
        """
        Name of the zone in which the Data Fusion instance will be created. Only DEVELOPER instances use this field.
        """
        return pulumi.get(self, "zone")

