# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceAccelerator',
    'InstanceCryptoKeyConfig',
    'InstanceEventPublishConfig',
    'InstanceNetworkConfig',
    'InstanceNetworkConfigPrivateServiceConnectConfig',
]

@pulumi.output_type
class InstanceAccelerator(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorType":
            suggest = "accelerator_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceAccelerator. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceAccelerator.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceAccelerator.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_type: builtins.str,
                 state: builtins.str):
        """
        :param builtins.str accelerator_type: The type of an accelator for a CDF instance.
               Possible values are: `CDC`, `HEALTHCARE`, `CCAI_INSIGHTS`.
        :param builtins.str state: The type of an accelator for a CDF instance.
               Possible values are: `ENABLED`, `DISABLED`.
        """
        pulumi.set(__self__, "accelerator_type", accelerator_type)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="acceleratorType")
    def accelerator_type(self) -> builtins.str:
        """
        The type of an accelator for a CDF instance.
        Possible values are: `CDC`, `HEALTHCARE`, `CCAI_INSIGHTS`.
        """
        return pulumi.get(self, "accelerator_type")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The type of an accelator for a CDF instance.
        Possible values are: `ENABLED`, `DISABLED`.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class InstanceCryptoKeyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyReference":
            suggest = "key_reference"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceCryptoKeyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceCryptoKeyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceCryptoKeyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_reference: builtins.str):
        """
        :param builtins.str key_reference: The name of the key which is used to encrypt/decrypt customer data. For key in Cloud KMS, the key should be in the format of projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        pulumi.set(__self__, "key_reference", key_reference)

    @property
    @pulumi.getter(name="keyReference")
    def key_reference(self) -> builtins.str:
        """
        The name of the key which is used to encrypt/decrypt customer data. For key in Cloud KMS, the key should be in the format of projects/*/locations/*/keyRings/*/cryptoKeys/*.
        """
        return pulumi.get(self, "key_reference")


@pulumi.output_type
class InstanceEventPublishConfig(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 topic: builtins.str):
        """
        :param builtins.bool enabled: Option to enable Event Publishing.
        :param builtins.str topic: The resource name of the Pub/Sub topic. Format: projects/{projectId}/topics/{topic_id}
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Option to enable Event Publishing.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def topic(self) -> builtins.str:
        """
        The resource name of the Pub/Sub topic. Format: projects/{projectId}/topics/{topic_id}
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class InstanceNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectionType":
            suggest = "connection_type"
        elif key == "ipAllocation":
            suggest = "ip_allocation"
        elif key == "privateServiceConnectConfig":
            suggest = "private_service_connect_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connection_type: Optional[builtins.str] = None,
                 ip_allocation: Optional[builtins.str] = None,
                 network: Optional[builtins.str] = None,
                 private_service_connect_config: Optional['outputs.InstanceNetworkConfigPrivateServiceConnectConfig'] = None):
        """
        :param builtins.str connection_type: Optional. Type of connection for establishing private IP connectivity between the Data Fusion customer project VPC and
               the corresponding tenant project from a predefined list of available connection modes.
               If this field is unspecified for a private instance, VPC peering is used.
               Possible values are: `VPC_PEERING`, `PRIVATE_SERVICE_CONNECT_INTERFACES`.
        :param builtins.str ip_allocation: The IP range in CIDR notation to use for the managed Data Fusion instance
               nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
        :param builtins.str network: Name of the network in the project with which the tenant project
               will be peered for executing pipelines. In case of shared VPC where the network resides in another host
               project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
        :param 'InstanceNetworkConfigPrivateServiceConnectConfigArgs' private_service_connect_config: Optional. Configuration for Private Service Connect.
               This is required only when using connection type PRIVATE_SERVICE_CONNECT_INTERFACES.
               Structure is documented below.
        """
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if ip_allocation is not None:
            pulumi.set(__self__, "ip_allocation", ip_allocation)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if private_service_connect_config is not None:
            pulumi.set(__self__, "private_service_connect_config", private_service_connect_config)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[builtins.str]:
        """
        Optional. Type of connection for establishing private IP connectivity between the Data Fusion customer project VPC and
        the corresponding tenant project from a predefined list of available connection modes.
        If this field is unspecified for a private instance, VPC peering is used.
        Possible values are: `VPC_PEERING`, `PRIVATE_SERVICE_CONNECT_INTERFACES`.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="ipAllocation")
    def ip_allocation(self) -> Optional[builtins.str]:
        """
        The IP range in CIDR notation to use for the managed Data Fusion instance
        nodes. This range must not overlap with any other ranges used in the Data Fusion instance network.
        """
        return pulumi.get(self, "ip_allocation")

    @property
    @pulumi.getter
    def network(self) -> Optional[builtins.str]:
        """
        Name of the network in the project with which the tenant project
        will be peered for executing pipelines. In case of shared VPC where the network resides in another host
        project the network should specified in the form of projects/{host-project-id}/global/networks/{network}
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="privateServiceConnectConfig")
    def private_service_connect_config(self) -> Optional['outputs.InstanceNetworkConfigPrivateServiceConnectConfig']:
        """
        Optional. Configuration for Private Service Connect.
        This is required only when using connection type PRIVATE_SERVICE_CONNECT_INTERFACES.
        Structure is documented below.
        """
        return pulumi.get(self, "private_service_connect_config")


@pulumi.output_type
class InstanceNetworkConfigPrivateServiceConnectConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "effectiveUnreachableCidrBlock":
            suggest = "effective_unreachable_cidr_block"
        elif key == "networkAttachment":
            suggest = "network_attachment"
        elif key == "unreachableCidrBlock":
            suggest = "unreachable_cidr_block"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetworkConfigPrivateServiceConnectConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetworkConfigPrivateServiceConnectConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetworkConfigPrivateServiceConnectConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 effective_unreachable_cidr_block: Optional[builtins.str] = None,
                 network_attachment: Optional[builtins.str] = None,
                 unreachable_cidr_block: Optional[builtins.str] = None):
        """
        :param builtins.str effective_unreachable_cidr_block: (Output)
               Output only. The CIDR block to which the CDF instance can't route traffic to in the consumer project VPC.
               The size of this block is /25. The format of this field is governed by RFC 4632.
        :param builtins.str network_attachment: Optional. The reference to the network attachment used to establish private connectivity.
               It will be of the form projects/{project-id}/regions/{region}/networkAttachments/{network-attachment-id}.
               This is required only when using connection type PRIVATE_SERVICE_CONNECT_INTERFACES.
        :param builtins.str unreachable_cidr_block: Optional. Input only. The CIDR block to which the CDF instance can't route traffic to in the consumer project VPC.
               The size of this block should be at least /25. This range should not overlap with the primary address range of any subnetwork used by the network attachment.
               This range can be used for other purposes in the consumer VPC as long as there is no requirement for CDF to reach destinations using these addresses.
               If this value is not provided, the server chooses a non RFC 1918 address range. The format of this field is governed by RFC 4632.
        """
        if effective_unreachable_cidr_block is not None:
            pulumi.set(__self__, "effective_unreachable_cidr_block", effective_unreachable_cidr_block)
        if network_attachment is not None:
            pulumi.set(__self__, "network_attachment", network_attachment)
        if unreachable_cidr_block is not None:
            pulumi.set(__self__, "unreachable_cidr_block", unreachable_cidr_block)

    @property
    @pulumi.getter(name="effectiveUnreachableCidrBlock")
    def effective_unreachable_cidr_block(self) -> Optional[builtins.str]:
        """
        (Output)
        Output only. The CIDR block to which the CDF instance can't route traffic to in the consumer project VPC.
        The size of this block is /25. The format of this field is governed by RFC 4632.
        """
        return pulumi.get(self, "effective_unreachable_cidr_block")

    @property
    @pulumi.getter(name="networkAttachment")
    def network_attachment(self) -> Optional[builtins.str]:
        """
        Optional. The reference to the network attachment used to establish private connectivity.
        It will be of the form projects/{project-id}/regions/{region}/networkAttachments/{network-attachment-id}.
        This is required only when using connection type PRIVATE_SERVICE_CONNECT_INTERFACES.
        """
        return pulumi.get(self, "network_attachment")

    @property
    @pulumi.getter(name="unreachableCidrBlock")
    def unreachable_cidr_block(self) -> Optional[builtins.str]:
        """
        Optional. Input only. The CIDR block to which the CDF instance can't route traffic to in the consumer project VPC.
        The size of this block should be at least /25. This range should not overlap with the primary address range of any subnetwork used by the network attachment.
        This range can be used for other purposes in the consumer VPC as long as there is no requirement for CDF to reach destinations using these addresses.
        If this value is not provided, the server chooses a non RFC 1918 address range. The format of this field is governed by RFC 4632.
        """
        return pulumi.get(self, "unreachable_cidr_block")


