# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PreventionInspectTemplateArgs', 'PreventionInspectTemplate']

@pulumi.input_type
class PreventionInspectTemplateArgs:
    def __init__(__self__, *,
                 parent: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_config: Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PreventionInspectTemplate resource.
        :param pulumi.Input[builtins.str] parent: The parent of the inspect template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] description: A description of the inspect template.
        :param pulumi.Input[builtins.str] display_name: User set display name of the inspect template.
        :param pulumi.Input['PreventionInspectTemplateInspectConfigArgs'] inspect_config: The core content of the template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        pulumi.set(__self__, "parent", parent)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_config is not None:
            pulumi.set(__self__, "inspect_config", inspect_config)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Input[builtins.str]:
        """
        The parent of the inspect template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the inspect template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User set display name of the inspect template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectConfig")
    def inspect_config(self) -> Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']]:
        """
        The core content of the template.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_config")

    @inspect_config.setter
    def inspect_config(self, value: Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']]):
        pulumi.set(self, "inspect_config", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _PreventionInspectTemplateState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_config: Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PreventionInspectTemplate resources.
        :param pulumi.Input[builtins.str] description: A description of the inspect template.
        :param pulumi.Input[builtins.str] display_name: User set display name of the inspect template.
        :param pulumi.Input['PreventionInspectTemplateInspectConfigArgs'] inspect_config: The core content of the template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the inspect template. Set by the server.
        :param pulumi.Input[builtins.str] parent: The parent of the inspect template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if inspect_config is not None:
            pulumi.set(__self__, "inspect_config", inspect_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parent is not None:
            pulumi.set(__self__, "parent", parent)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A description of the inspect template.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User set display name of the inspect template.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="inspectConfig")
    def inspect_config(self) -> Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']]:
        """
        The core content of the template.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_config")

    @inspect_config.setter
    def inspect_config(self, value: Optional[pulumi.Input['PreventionInspectTemplateInspectConfigArgs']]):
        pulumi.set(self, "inspect_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The resource name of the inspect template. Set by the server.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parent(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The parent of the inspect template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @parent.setter
    def parent(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "template_id", value)


@pulumi.type_token("gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate")
class PreventionInspectTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_config: Optional[pulumi.Input[Union['PreventionInspectTemplateInspectConfigArgs', 'PreventionInspectTemplateInspectConfigArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        An inspect job template.

        To get more information about InspectTemplate, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.inspectTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-templates-inspect)

        ## Example Usage

        ### Dlp Inspect Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionInspectTemplate("basic",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "info_types": [
                    {
                        "name": "EMAIL_ADDRESS",
                    },
                    {
                        "name": "PERSON_NAME",
                    },
                    {
                        "name": "LAST_NAME",
                    },
                    {
                        "name": "DOMAIN_NAME",
                    },
                    {
                        "name": "PHONE_NUMBER",
                    },
                    {
                        "name": "FIRST_NAME",
                    },
                ],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [
                            {
                                "name": "EMAIL_ADDRESS",
                            },
                            {
                                "name": "DOMAIN_NAME",
                            },
                            {
                                "name": "PHONE_NUMBER",
                            },
                            {
                                "name": "PERSON_NAME",
                            },
                            {
                                "name": "FIRST_NAME",
                            },
                        ],
                        "rules": [{
                            "exclusion_rule": {
                                "dictionary": {
                                    "word_list": {
                                        "words": ["TEST"],
                                    },
                                },
                                "matching_type": "MATCHING_TYPE_PARTIAL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "PERSON_NAME",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "patient",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                    "max_findings_per_info_types": [
                        {
                            "max_findings": 75,
                            "info_type": {
                                "name": "PERSON_NAME",
                            },
                        },
                        {
                            "max_findings": 80,
                            "info_type": {
                                "name": "LAST_NAME",
                            },
                        },
                    ],
                },
            })
        ```
        ### Dlp Inspect Template Custom Type

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom = gcp.dataloss.PreventionInspectTemplate("custom",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "custom_info_types": [{
                    "info_type": {
                        "name": "MY_CUSTOM_TYPE",
                    },
                    "likelihood": "UNLIKELY",
                    "regex": {
                        "pattern": "test*",
                    },
                }],
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "MY_CUSTOM_TYPE",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "example*",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                },
            })
        ```
        ### Dlp Inspect Template Custom Type Surrogate

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_type_surrogate = gcp.dataloss.PreventionInspectTemplate("custom_type_surrogate",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "custom_info_types": [{
                    "info_type": {
                        "name": "MY_CUSTOM_TYPE",
                    },
                    "likelihood": "UNLIKELY",
                    "surrogate_type": {},
                }],
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "MY_CUSTOM_TYPE",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "example*",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                },
            })
        ```
        ### Dlp Inspect Template Max Infotype Per Finding Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        max_infotype_per_finding_default = gcp.dataloss.PreventionInspectTemplate("max_infotype_per_finding_default",
            parent="projects/my-project-name",
            inspect_config={
                "info_types": [
                    {
                        "name": "EMAIL_ADDRESS",
                    },
                    {
                        "name": "PERSON_NAME",
                    },
                ],
                "min_likelihood": "UNLIKELY",
                "limits": {
                    "max_findings_per_request": 333,
                    "max_findings_per_item": 222,
                    "max_findings_per_info_types": [{
                        "max_findings": 111,
                    }],
                },
            })
        ```

        ## Import

        InspectTemplate can be imported using any of these accepted formats:

        * `{{parent}}/inspectTemplates/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, InspectTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate default {{parent}}/inspectTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the inspect template.
        :param pulumi.Input[builtins.str] display_name: User set display name of the inspect template.
        :param pulumi.Input[Union['PreventionInspectTemplateInspectConfigArgs', 'PreventionInspectTemplateInspectConfigArgsDict']] inspect_config: The core content of the template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] parent: The parent of the inspect template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PreventionInspectTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An inspect job template.

        To get more information about InspectTemplate, see:

        * [API documentation](https://cloud.google.com/dlp/docs/reference/rest/v2/projects.inspectTemplates)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dlp/docs/creating-templates-inspect)

        ## Example Usage

        ### Dlp Inspect Template Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        basic = gcp.dataloss.PreventionInspectTemplate("basic",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "info_types": [
                    {
                        "name": "EMAIL_ADDRESS",
                    },
                    {
                        "name": "PERSON_NAME",
                    },
                    {
                        "name": "LAST_NAME",
                    },
                    {
                        "name": "DOMAIN_NAME",
                    },
                    {
                        "name": "PHONE_NUMBER",
                    },
                    {
                        "name": "FIRST_NAME",
                    },
                ],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [
                            {
                                "name": "EMAIL_ADDRESS",
                            },
                            {
                                "name": "DOMAIN_NAME",
                            },
                            {
                                "name": "PHONE_NUMBER",
                            },
                            {
                                "name": "PERSON_NAME",
                            },
                            {
                                "name": "FIRST_NAME",
                            },
                        ],
                        "rules": [{
                            "exclusion_rule": {
                                "dictionary": {
                                    "word_list": {
                                        "words": ["TEST"],
                                    },
                                },
                                "matching_type": "MATCHING_TYPE_PARTIAL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "PERSON_NAME",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "patient",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                    "max_findings_per_info_types": [
                        {
                            "max_findings": 75,
                            "info_type": {
                                "name": "PERSON_NAME",
                            },
                        },
                        {
                            "max_findings": 80,
                            "info_type": {
                                "name": "LAST_NAME",
                            },
                        },
                    ],
                },
            })
        ```
        ### Dlp Inspect Template Custom Type

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom = gcp.dataloss.PreventionInspectTemplate("custom",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "custom_info_types": [{
                    "info_type": {
                        "name": "MY_CUSTOM_TYPE",
                    },
                    "likelihood": "UNLIKELY",
                    "regex": {
                        "pattern": "test*",
                    },
                }],
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "MY_CUSTOM_TYPE",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "example*",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                },
            })
        ```
        ### Dlp Inspect Template Custom Type Surrogate

        ```python
        import pulumi
        import pulumi_gcp as gcp

        custom_type_surrogate = gcp.dataloss.PreventionInspectTemplate("custom_type_surrogate",
            parent="projects/my-project-name",
            description="My description",
            display_name="display_name",
            inspect_config={
                "custom_info_types": [{
                    "info_type": {
                        "name": "MY_CUSTOM_TYPE",
                    },
                    "likelihood": "UNLIKELY",
                    "surrogate_type": {},
                }],
                "info_types": [{
                    "name": "EMAIL_ADDRESS",
                }],
                "min_likelihood": "UNLIKELY",
                "rule_sets": [
                    {
                        "info_types": [{
                            "name": "EMAIL_ADDRESS",
                        }],
                        "rules": [{
                            "exclusion_rule": {
                                "regex": {
                                    "pattern": ".+@example.com",
                                },
                                "matching_type": "MATCHING_TYPE_FULL_MATCH",
                            },
                        }],
                    },
                    {
                        "info_types": [{
                            "name": "MY_CUSTOM_TYPE",
                        }],
                        "rules": [{
                            "hotword_rule": {
                                "hotword_regex": {
                                    "pattern": "example*",
                                },
                                "proximity": {
                                    "window_before": 50,
                                },
                                "likelihood_adjustment": {
                                    "fixed_likelihood": "VERY_LIKELY",
                                },
                            },
                        }],
                    },
                ],
                "limits": {
                    "max_findings_per_item": 10,
                    "max_findings_per_request": 50,
                },
            })
        ```
        ### Dlp Inspect Template Max Infotype Per Finding Default

        ```python
        import pulumi
        import pulumi_gcp as gcp

        max_infotype_per_finding_default = gcp.dataloss.PreventionInspectTemplate("max_infotype_per_finding_default",
            parent="projects/my-project-name",
            inspect_config={
                "info_types": [
                    {
                        "name": "EMAIL_ADDRESS",
                    },
                    {
                        "name": "PERSON_NAME",
                    },
                ],
                "min_likelihood": "UNLIKELY",
                "limits": {
                    "max_findings_per_request": 333,
                    "max_findings_per_item": 222,
                    "max_findings_per_info_types": [{
                        "max_findings": 111,
                    }],
                },
            })
        ```

        ## Import

        InspectTemplate can be imported using any of these accepted formats:

        * `{{parent}}/inspectTemplates/{{name}}`

        * `{{parent}}/{{name}}`

        When using the `pulumi import` command, InspectTemplate can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate default {{parent}}/inspectTemplates/{{name}}
        ```

        ```sh
        $ pulumi import gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate default {{parent}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param PreventionInspectTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PreventionInspectTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 inspect_config: Optional[pulumi.Input[Union['PreventionInspectTemplateInspectConfigArgs', 'PreventionInspectTemplateInspectConfigArgsDict']]] = None,
                 parent: Optional[pulumi.Input[builtins.str]] = None,
                 template_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PreventionInspectTemplateArgs.__new__(PreventionInspectTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["inspect_config"] = inspect_config
            if parent is None and not opts.urn:
                raise TypeError("Missing required property 'parent'")
            __props__.__dict__["parent"] = parent
            __props__.__dict__["template_id"] = template_id
            __props__.__dict__["name"] = None
        super(PreventionInspectTemplate, __self__).__init__(
            'gcp:dataloss/preventionInspectTemplate:PreventionInspectTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            inspect_config: Optional[pulumi.Input[Union['PreventionInspectTemplateInspectConfigArgs', 'PreventionInspectTemplateInspectConfigArgsDict']]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            parent: Optional[pulumi.Input[builtins.str]] = None,
            template_id: Optional[pulumi.Input[builtins.str]] = None) -> 'PreventionInspectTemplate':
        """
        Get an existing PreventionInspectTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: A description of the inspect template.
        :param pulumi.Input[builtins.str] display_name: User set display name of the inspect template.
        :param pulumi.Input[Union['PreventionInspectTemplateInspectConfigArgs', 'PreventionInspectTemplateInspectConfigArgsDict']] inspect_config: The core content of the template.
               Structure is documented below.
        :param pulumi.Input[builtins.str] name: The resource name of the inspect template. Set by the server.
        :param pulumi.Input[builtins.str] parent: The parent of the inspect template in any of the following formats:
               * `projects/{{project}}`
               * `projects/{{project}}/locations/{{location}}`
               * `organizations/{{organization_id}}`
               * `organizations/{{organization_id}}/locations/{{location}}`
        :param pulumi.Input[builtins.str] template_id: The template id can contain uppercase and lowercase letters, numbers, and hyphens;
               that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
               100 characters. Can be empty to allow the system to generate one.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PreventionInspectTemplateState.__new__(_PreventionInspectTemplateState)

        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["inspect_config"] = inspect_config
        __props__.__dict__["name"] = name
        __props__.__dict__["parent"] = parent
        __props__.__dict__["template_id"] = template_id
        return PreventionInspectTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        A description of the inspect template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User set display name of the inspect template.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="inspectConfig")
    def inspect_config(self) -> pulumi.Output[Optional['outputs.PreventionInspectTemplateInspectConfig']]:
        """
        The core content of the template.
        Structure is documented below.
        """
        return pulumi.get(self, "inspect_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The resource name of the inspect template. Set by the server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parent(self) -> pulumi.Output[builtins.str]:
        """
        The parent of the inspect template in any of the following formats:
        * `projects/{{project}}`
        * `projects/{{project}}/locations/{{location}}`
        * `organizations/{{organization_id}}`
        * `organizations/{{organization_id}}/locations/{{location}}`
        """
        return pulumi.get(self, "parent")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[builtins.str]:
        """
        The template id can contain uppercase and lowercase letters, numbers, and hyphens;
        that is, it must match the regular expression: [a-zA-Z\\d-_]+. The maximum length is
        100 characters. Can be empty to allow the system to generate one.
        """
        return pulumi.get(self, "template_id")

