# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EntryTypeArgs', 'EntryType']

@pulumi.input_type
class EntryTypeArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entry_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 required_aspects: Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 type_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a EntryType resource.
        :param pulumi.Input[builtins.str] description: Description of the EntryType.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[builtins.str] entry_type_id: The entry type id of the entry type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the EntryType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where entry type will be created in.
        :param pulumi.Input[builtins.str] platform: The platform that Entries of this type belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]] required_aspects: AspectInfo for the entry type.
               Structure is documented below.
        :param pulumi.Input[builtins.str] system: The system that Entries of this type belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] type_aliases: Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entry_type_id is not None:
            pulumi.set(__self__, "entry_type_id", entry_type_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if required_aspects is not None:
            pulumi.set(__self__, "required_aspects", required_aspects)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if type_aliases is not None:
            pulumi.set(__self__, "type_aliases", type_aliases)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the EntryType.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entryTypeId")
    def entry_type_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry type id of the entry type.
        """
        return pulumi.get(self, "entry_type_id")

    @entry_type_id.setter
    def entry_type_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_type_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the EntryType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where entry type will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The platform that Entries of this type belongs to.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requiredAspects")
    def required_aspects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]]:
        """
        AspectInfo for the entry type.
        Structure is documented below.
        """
        return pulumi.get(self, "required_aspects")

    @required_aspects.setter
    def required_aspects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]]):
        pulumi.set(self, "required_aspects", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The system that Entries of this type belongs to.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter(name="typeAliases")
    def type_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        """
        return pulumi.get(self, "type_aliases")

    @type_aliases.setter
    def type_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "type_aliases", value)


@pulumi.input_type
class _EntryTypeState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 entry_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 required_aspects: Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 type_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering EntryType resources.
        :param pulumi.Input[builtins.str] create_time: The time when the EntryType was created.
        :param pulumi.Input[builtins.str] description: Description of the EntryType.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] entry_type_id: The entry type id of the entry type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the EntryType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where entry type will be created in.
        :param pulumi.Input[builtins.str] name: The relative resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}
        :param pulumi.Input[builtins.str] platform: The platform that Entries of this type belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]] required_aspects: AspectInfo for the entry type.
               Structure is documented below.
        :param pulumi.Input[builtins.str] system: The system that Entries of this type belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] type_aliases: Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        :param pulumi.Input[builtins.str] uid: System generated globally unique ID for the EntryType. This ID will be different if the EntryType is deleted and re-created with the same name.
        :param pulumi.Input[builtins.str] update_time: The time when the EntryType was last updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if entry_type_id is not None:
            pulumi.set(__self__, "entry_type_id", entry_type_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if required_aspects is not None:
            pulumi.set(__self__, "required_aspects", required_aspects)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if type_aliases is not None:
            pulumi.set(__self__, "type_aliases", type_aliases)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the EntryType was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description of the EntryType.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="entryTypeId")
    def entry_type_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The entry type id of the entry type.
        """
        return pulumi.get(self, "entry_type_id")

    @entry_type_id.setter
    def entry_type_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "entry_type_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the EntryType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location where entry type will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The relative resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The platform that Entries of this type belongs to.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter(name="requiredAspects")
    def required_aspects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]]:
        """
        AspectInfo for the entry type.
        Structure is documented below.
        """
        return pulumi.get(self, "required_aspects")

    @required_aspects.setter
    def required_aspects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EntryTypeRequiredAspectArgs']]]]):
        pulumi.set(self, "required_aspects", value)

    @property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The system that Entries of this type belongs to.
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system", value)

    @property
    @pulumi.getter(name="typeAliases")
    def type_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        """
        return pulumi.get(self, "type_aliases")

    @type_aliases.setter
    def type_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "type_aliases", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        System generated globally unique ID for the EntryType. This ID will be different if the EntryType is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the EntryType was last updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/entryType:EntryType")
class EntryType(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entry_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 required_aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryTypeRequiredAspectArgs', 'EntryTypeRequiredAspectArgsDict']]]]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 type_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        An Entry Type is a template for creating Entries.

        ## Example Usage

        ### Dataplex Entry Type Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_entry_type_basic = gcp.dataplex.EntryType("test_entry_type_basic",
            entry_type_id="entry-type-basic",
            project="my-project-name",
            location="us-central1")
        ```
        ### Dataplex Entry Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_entry_type_full = gcp.dataplex.AspectType("test_entry_type_full",
            aspect_type_id="tf-test-aspect-type_95154",
            location="us-central1",
            project="my-project-name",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        test_entry_type_full_entry_type = gcp.dataplex.EntryType("test_entry_type_full",
            entry_type_id="entry-type-full",
            project="my-project-name",
            location="us-central1",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform entry type",
            description="entry type created by Terraform",
            type_aliases=[
                "TABLE",
                "DATABASE",
            ],
            platform="GCS",
            system="CloudSQL",
            required_aspects=[{
                "type": test_entry_type_full.name,
            }])
        ```

        ## Import

        EntryType can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryTypes/{{entry_type_id}}`

        * `{{project}}/{{location}}/{{entry_type_id}}`

        * `{{location}}/{{entry_type_id}}`

        When using the `pulumi import` command, EntryType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default projects/{{project}}/locations/{{location}}/entryTypes/{{entry_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default {{project}}/{{location}}/{{entry_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default {{location}}/{{entry_type_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: Description of the EntryType.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[builtins.str] entry_type_id: The entry type id of the entry type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the EntryType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where entry type will be created in.
        :param pulumi.Input[builtins.str] platform: The platform that Entries of this type belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryTypeRequiredAspectArgs', 'EntryTypeRequiredAspectArgsDict']]]] required_aspects: AspectInfo for the entry type.
               Structure is documented below.
        :param pulumi.Input[builtins.str] system: The system that Entries of this type belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] type_aliases: Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EntryTypeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An Entry Type is a template for creating Entries.

        ## Example Usage

        ### Dataplex Entry Type Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_entry_type_basic = gcp.dataplex.EntryType("test_entry_type_basic",
            entry_type_id="entry-type-basic",
            project="my-project-name",
            location="us-central1")
        ```
        ### Dataplex Entry Type Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        test_entry_type_full = gcp.dataplex.AspectType("test_entry_type_full",
            aspect_type_id="tf-test-aspect-type_95154",
            location="us-central1",
            project="my-project-name",
            metadata_template=\"\"\"{
          "name": "tf-test-template",
          "type": "record",
          "recordFields": [
            {
              "name": "type",
              "type": "enum",
              "annotations": {
                "displayName": "Type",
                "description": "Specifies the type of view represented by the entry."
              },
              "index": 1,
              "constraints": {
                "required": true
              },
              "enumValues": [
                {
                  "name": "VIEW",
                  "index": 1
                }
              ]
            }
          ]
        }
        \"\"\")
        test_entry_type_full_entry_type = gcp.dataplex.EntryType("test_entry_type_full",
            entry_type_id="entry-type-full",
            project="my-project-name",
            location="us-central1",
            labels={
                "tag": "test-tf",
            },
            display_name="terraform entry type",
            description="entry type created by Terraform",
            type_aliases=[
                "TABLE",
                "DATABASE",
            ],
            platform="GCS",
            system="CloudSQL",
            required_aspects=[{
                "type": test_entry_type_full.name,
            }])
        ```

        ## Import

        EntryType can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/entryTypes/{{entry_type_id}}`

        * `{{project}}/{{location}}/{{entry_type_id}}`

        * `{{location}}/{{entry_type_id}}`

        When using the `pulumi import` command, EntryType can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default projects/{{project}}/locations/{{location}}/entryTypes/{{entry_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default {{project}}/{{location}}/{{entry_type_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/entryType:EntryType default {{location}}/{{entry_type_id}}
        ```

        :param str resource_name: The name of the resource.
        :param EntryTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EntryTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 entry_type_id: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 platform: Optional[pulumi.Input[builtins.str]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 required_aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryTypeRequiredAspectArgs', 'EntryTypeRequiredAspectArgsDict']]]]] = None,
                 system: Optional[pulumi.Input[builtins.str]] = None,
                 type_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EntryTypeArgs.__new__(EntryTypeArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["entry_type_id"] = entry_type_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["platform"] = platform
            __props__.__dict__["project"] = project
            __props__.__dict__["required_aspects"] = required_aspects
            __props__.__dict__["system"] = system
            __props__.__dict__["type_aliases"] = type_aliases
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EntryType, __self__).__init__(
            'gcp:dataplex/entryType:EntryType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            entry_type_id: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            platform: Optional[pulumi.Input[builtins.str]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            required_aspects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['EntryTypeRequiredAspectArgs', 'EntryTypeRequiredAspectArgsDict']]]]] = None,
            system: Optional[pulumi.Input[builtins.str]] = None,
            type_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'EntryType':
        """
        Get an existing EntryType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time when the EntryType was created.
        :param pulumi.Input[builtins.str] description: Description of the EntryType.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[builtins.str] entry_type_id: The entry type id of the entry type.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the EntryType.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] location: The location where entry type will be created in.
        :param pulumi.Input[builtins.str] name: The relative resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}
        :param pulumi.Input[builtins.str] platform: The platform that Entries of this type belongs to.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['EntryTypeRequiredAspectArgs', 'EntryTypeRequiredAspectArgsDict']]]] required_aspects: AspectInfo for the entry type.
               Structure is documented below.
        :param pulumi.Input[builtins.str] system: The system that Entries of this type belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] type_aliases: Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        :param pulumi.Input[builtins.str] uid: System generated globally unique ID for the EntryType. This ID will be different if the EntryType is deleted and re-created with the same name.
        :param pulumi.Input[builtins.str] update_time: The time when the EntryType was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EntryTypeState.__new__(_EntryTypeState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["entry_type_id"] = entry_type_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["required_aspects"] = required_aspects
        __props__.__dict__["system"] = system
        __props__.__dict__["type_aliases"] = type_aliases
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return EntryType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the EntryType was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description of the EntryType.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="entryTypeId")
    def entry_type_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The entry type id of the entry type.
        """
        return pulumi.get(self, "entry_type_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels for the EntryType.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location where entry type will be created in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The relative resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The platform that Entries of this type belongs to.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter(name="requiredAspects")
    def required_aspects(self) -> pulumi.Output[Optional[Sequence['outputs.EntryTypeRequiredAspect']]]:
        """
        AspectInfo for the entry type.
        Structure is documented below.
        """
        return pulumi.get(self, "required_aspects")

    @property
    @pulumi.getter
    def system(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The system that Entries of this type belongs to.
        """
        return pulumi.get(self, "system")

    @property
    @pulumi.getter(name="typeAliases")
    def type_aliases(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        """
        Indicates the class this Entry Type belongs to, for example, TABLE, DATABASE, MODEL.
        """
        return pulumi.get(self, "type_aliases")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        System generated globally unique ID for the EntryType. This ID will be different if the EntryType is deleted and re-created with the same name.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the EntryType was last updated.
        """
        return pulumi.get(self, "update_time")

