# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAspectTypeIamPolicyResult',
    'AwaitableGetAspectTypeIamPolicyResult',
    'get_aspect_type_iam_policy',
    'get_aspect_type_iam_policy_output',
]

@pulumi.output_type
class GetAspectTypeIamPolicyResult:
    """
    A collection of values returned by getAspectTypeIamPolicy.
    """
    def __init__(__self__, aspect_type_id=None, etag=None, id=None, location=None, policy_data=None, project=None):
        if aspect_type_id and not isinstance(aspect_type_id, str):
            raise TypeError("Expected argument 'aspect_type_id' to be a str")
        pulumi.set(__self__, "aspect_type_id", aspect_type_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="aspectTypeId")
    def aspect_type_id(self) -> builtins.str:
        return pulumi.get(self, "aspect_type_id")

    @property
    @pulumi.getter
    def etag(self) -> builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> builtins.str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> builtins.str:
        """
        (Required only by `dataplex.AspectTypeIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")

    @property
    @pulumi.getter
    def project(self) -> builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetAspectTypeIamPolicyResult(GetAspectTypeIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAspectTypeIamPolicyResult(
            aspect_type_id=self.aspect_type_id,
            etag=self.etag,
            id=self.id,
            location=self.location,
            policy_data=self.policy_data,
            project=self.project)


def get_aspect_type_iam_policy(aspect_type_id: Optional[builtins.str] = None,
                               location: Optional[builtins.str] = None,
                               project: Optional[builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAspectTypeIamPolicyResult:
    """
    Retrieves the current IAM policy data for aspecttype

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataplex.get_aspect_type_iam_policy(project=test_aspect_type_basic["project"],
        location=test_aspect_type_basic["location"],
        aspect_type_id=test_aspect_type_basic["aspectTypeId"])
    ```


    :param builtins.str aspect_type_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: The location where aspect type will be created in.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['aspectTypeId'] = aspect_type_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataplex/getAspectTypeIamPolicy:getAspectTypeIamPolicy', __args__, opts=opts, typ=GetAspectTypeIamPolicyResult).value

    return AwaitableGetAspectTypeIamPolicyResult(
        aspect_type_id=pulumi.get(__ret__, 'aspect_type_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'))
def get_aspect_type_iam_policy_output(aspect_type_id: Optional[pulumi.Input[builtins.str]] = None,
                                      location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAspectTypeIamPolicyResult]:
    """
    Retrieves the current IAM policy data for aspecttype

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.dataplex.get_aspect_type_iam_policy(project=test_aspect_type_basic["project"],
        location=test_aspect_type_basic["location"],
        aspect_type_id=test_aspect_type_basic["aspectTypeId"])
    ```


    :param builtins.str aspect_type_id: Used to find the parent resource to bind the IAM policy to
    :param builtins.str location: The location where aspect type will be created in.
           Used to find the parent resource to bind the IAM policy to. If not specified,
           the value will be parsed from the identifier of the parent resource. If no location is provided in the parent identifier and no
           location is specified, it is taken from the provider configuration.
    :param builtins.str project: The ID of the project in which the resource belongs.
           If it is not provided, the project will be parsed from the identifier of the parent resource. If no project is provided in the parent identifier and no project is specified, the provider project is used.
    """
    __args__ = dict()
    __args__['aspectTypeId'] = aspect_type_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataplex/getAspectTypeIamPolicy:getAspectTypeIamPolicy', __args__, opts=opts, typ=GetAspectTypeIamPolicyResult)
    return __ret__.apply(lambda __response__: GetAspectTypeIamPolicyResult(
        aspect_type_id=pulumi.get(__response__, 'aspect_type_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project')))
