# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDataQualityRulesResult',
    'AwaitableGetDataQualityRulesResult',
    'get_data_quality_rules',
    'get_data_quality_rules_output',
]

@pulumi.output_type
class GetDataQualityRulesResult:
    """
    A collection of values returned by getDataQualityRules.
    """
    def __init__(__self__, data_scan_id=None, id=None, location=None, project=None, rules=None):
        if data_scan_id and not isinstance(data_scan_id, str):
            raise TypeError("Expected argument 'data_scan_id' to be a str")
        pulumi.set(__self__, "data_scan_id", data_scan_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="dataScanId")
    def data_scan_id(self) -> builtins.str:
        return pulumi.get(self, "data_scan_id")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def location(self) -> Optional[builtins.str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def project(self) -> Optional[builtins.str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetDataQualityRulesRuleResult']:
        """
        (Computed) The list of generated data quality rules. For more details, please see the datascan page.
        """
        return pulumi.get(self, "rules")


class AwaitableGetDataQualityRulesResult(GetDataQualityRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataQualityRulesResult(
            data_scan_id=self.data_scan_id,
            id=self.id,
            location=self.location,
            project=self.project,
            rules=self.rules)


def get_data_quality_rules(data_scan_id: Optional[builtins.str] = None,
                           location: Optional[builtins.str] = None,
                           project: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataQualityRulesResult:
    """
    Retrieves the generated data quality rules for the creating a new data quality scan.
    For more information see
    the [official documentation](https://cloud.google.com/dataplex/docs)
    and [API](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.dataScans/generateDataQualityRules).

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    dqrs = gcp.dataplex.get_data_quality_rules(project="my-project",
        location="use-central1",
        data_scan_id="my-datascan-profile")
    ```


    :param builtins.str data_scan_id: The ID of the data profile scan which the generation of quality rules will be basing on.
    :param builtins.str location: The location where the referenced data profile scan resides.
    :param builtins.str project: The ID of the project in which the datascan belongs.
    """
    __args__ = dict()
    __args__['dataScanId'] = data_scan_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:dataplex/getDataQualityRules:getDataQualityRules', __args__, opts=opts, typ=GetDataQualityRulesResult).value

    return AwaitableGetDataQualityRulesResult(
        data_scan_id=pulumi.get(__ret__, 'data_scan_id'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        project=pulumi.get(__ret__, 'project'),
        rules=pulumi.get(__ret__, 'rules'))
def get_data_quality_rules_output(data_scan_id: Optional[pulumi.Input[builtins.str]] = None,
                                  location: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  project: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataQualityRulesResult]:
    """
    Retrieves the generated data quality rules for the creating a new data quality scan.
    For more information see
    the [official documentation](https://cloud.google.com/dataplex/docs)
    and [API](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.dataScans/generateDataQualityRules).

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    dqrs = gcp.dataplex.get_data_quality_rules(project="my-project",
        location="use-central1",
        data_scan_id="my-datascan-profile")
    ```


    :param builtins.str data_scan_id: The ID of the data profile scan which the generation of quality rules will be basing on.
    :param builtins.str location: The location where the referenced data profile scan resides.
    :param builtins.str project: The ID of the project in which the datascan belongs.
    """
    __args__ = dict()
    __args__['dataScanId'] = data_scan_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:dataplex/getDataQualityRules:getDataQualityRules', __args__, opts=opts, typ=GetDataQualityRulesResult)
    return __ret__.apply(lambda __response__: GetDataQualityRulesResult(
        data_scan_id=pulumi.get(__response__, 'data_scan_id'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        project=pulumi.get(__response__, 'project'),
        rules=pulumi.get(__response__, 'rules')))
