# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TaskArgs', 'Task']

@pulumi.input_type
class TaskArgs:
    def __init__(__self__, *,
                 execution_spec: pulumi.Input['TaskExecutionSpecArgs'],
                 trigger_spec: pulumi.Input['TaskTriggerSpecArgs'],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lake: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook: Optional[pulumi.Input['TaskNotebookArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input['TaskSparkArgs']] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Task resource.
        :param pulumi.Input['TaskExecutionSpecArgs'] execution_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input['TaskTriggerSpecArgs'] trigger_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[builtins.str] description: User-provided description of the task.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the task.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lake: The lake in which the task will be created in.
        :param pulumi.Input[builtins.str] location: The location in which the task will be created in.
        :param pulumi.Input['TaskNotebookArgs'] notebook: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['TaskSparkArgs'] spark: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] task_id: The task Id of the task.
        """
        pulumi.set(__self__, "execution_spec", execution_spec)
        pulumi.set(__self__, "trigger_spec", trigger_spec)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lake is not None:
            pulumi.set(__self__, "lake", lake)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if notebook is not None:
            pulumi.set(__self__, "notebook", notebook)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Input['TaskExecutionSpecArgs']:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: pulumi.Input['TaskExecutionSpecArgs']):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter(name="triggerSpec")
    def trigger_spec(self) -> pulumi.Input['TaskTriggerSpecArgs']:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_spec")

    @trigger_spec.setter
    def trigger_spec(self, value: pulumi.Input['TaskTriggerSpecArgs']):
        pulumi.set(self, "trigger_spec", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the task.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the task.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lake(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lake in which the task will be created in.
        """
        return pulumi.get(self, "lake")

    @lake.setter
    def lake(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lake", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the task will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def notebook(self) -> Optional[pulumi.Input['TaskNotebookArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: Optional[pulumi.Input['TaskNotebookArgs']]):
        pulumi.set(self, "notebook", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def spark(self) -> Optional[pulumi.Input['TaskSparkArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

    @spark.setter
    def spark(self, value: Optional[pulumi.Input['TaskSparkArgs']]):
        pulumi.set(self, "spark", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The task Id of the task.
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_id", value)


@pulumi.input_type
class _TaskState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 execution_spec: Optional[pulumi.Input['TaskExecutionSpecArgs']] = None,
                 execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['TaskExecutionStatusArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lake: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 notebook: Optional[pulumi.Input['TaskNotebookArgs']] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 spark: Optional[pulumi.Input['TaskSparkArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_spec: Optional[pulumi.Input['TaskTriggerSpecArgs']] = None,
                 uid: Optional[pulumi.Input[builtins.str]] = None,
                 update_time: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Task resources.
        :param pulumi.Input[builtins.str] create_time: The time when the task was created.
        :param pulumi.Input[builtins.str] description: User-provided description of the task.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input['TaskExecutionSpecArgs'] execution_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['TaskExecutionStatusArgs']]] execution_statuses: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the task.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lake: The lake in which the task will be created in.
        :param pulumi.Input[builtins.str] location: The location in which the task will be created in.
        :param pulumi.Input[builtins.str] name: (Output)
               The relative resource name of the job, of the form: projects/{project_number}/locations/{locationId}/lakes/{lakeId}/tasks/{taskId}/jobs/{jobId}.
        :param pulumi.Input['TaskNotebookArgs'] notebook: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input['TaskSparkArgs'] spark: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               Execution state for the job.
        :param pulumi.Input[builtins.str] task_id: The task Id of the task.
        :param pulumi.Input['TaskTriggerSpecArgs'] trigger_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: (Output)
               System generated globally unique ID for the job.
        :param pulumi.Input[builtins.str] update_time: (Output)
               Last update time of the status.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if execution_spec is not None:
            pulumi.set(__self__, "execution_spec", execution_spec)
        if execution_statuses is not None:
            pulumi.set(__self__, "execution_statuses", execution_statuses)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if lake is not None:
            pulumi.set(__self__, "lake", lake)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notebook is not None:
            pulumi.set(__self__, "notebook", notebook)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if spark is not None:
            pulumi.set(__self__, "spark", spark)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if task_id is not None:
            pulumi.set(__self__, "task_id", task_id)
        if trigger_spec is not None:
            pulumi.set(__self__, "trigger_spec", trigger_spec)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when the task was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User-provided description of the task.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> Optional[pulumi.Input['TaskExecutionSpecArgs']]:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @execution_spec.setter
    def execution_spec(self, value: Optional[pulumi.Input['TaskExecutionSpecArgs']]):
        pulumi.set(self, "execution_spec", value)

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TaskExecutionStatusArgs']]]]:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @execution_statuses.setter
    def execution_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TaskExecutionStatusArgs']]]]):
        pulumi.set(self, "execution_statuses", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        User-defined labels for the task.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def lake(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lake in which the task will be created in.
        """
        return pulumi.get(self, "lake")

    @lake.setter
    def lake(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lake", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location in which the task will be created in.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        The relative resource name of the job, of the form: projects/{project_number}/locations/{locationId}/lakes/{lakeId}/tasks/{taskId}/jobs/{jobId}.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notebook(self) -> Optional[pulumi.Input['TaskNotebookArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "notebook")

    @notebook.setter
    def notebook(self, value: Optional[pulumi.Input['TaskNotebookArgs']]):
        pulumi.set(self, "notebook", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @property
    @pulumi.getter
    def spark(self) -> Optional[pulumi.Input['TaskSparkArgs']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

    @spark.setter
    def spark(self, value: Optional[pulumi.Input['TaskSparkArgs']]):
        pulumi.set(self, "spark", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Execution state for the job.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The task Id of the task.
        """
        return pulumi.get(self, "task_id")

    @task_id.setter
    def task_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "task_id", value)

    @property
    @pulumi.getter(name="triggerSpec")
    def trigger_spec(self) -> Optional[pulumi.Input['TaskTriggerSpecArgs']]:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_spec")

    @trigger_spec.setter
    def trigger_spec(self, value: Optional[pulumi.Input['TaskTriggerSpecArgs']]):
        pulumi.set(self, "trigger_spec", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        System generated globally unique ID for the job.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "uid", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Output)
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:dataplex/task:Task")
class Task(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_spec: Optional[pulumi.Input[Union['TaskExecutionSpecArgs', 'TaskExecutionSpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lake: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook: Optional[pulumi.Input[Union['TaskNotebookArgs', 'TaskNotebookArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input[Union['TaskSparkArgs', 'TaskSparkArgsDict']]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_spec: Optional[pulumi.Input[Union['TaskTriggerSpecArgs', 'TaskTriggerSpecArgsDict']]] = None,
                 __props__=None):
        """
        A Dataplex task represents the work that you want Dataplex to do on a schedule. It encapsulates code, parameters, and the schedule.

        To get more information about Task, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.lakes.tasks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Task Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.dataplex.Lake("example",
            name="tf-test-lake_8493",
            location="us-central1",
            project="my-project-name")
        example_task = gcp.dataplex.Task("example",
            task_id="tf-test-task_9106",
            location="us-central1",
            lake=example.name,
            description="Test Task Basic",
            display_name="task-basic",
            labels={
                "count": "3",
            },
            trigger_spec={
                "type": "RECURRING",
                "disabled": False,
                "max_retries": 3,
                "start_time": "2023-10-02T15:01:23Z",
                "schedule": "1 * * * *",
            },
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "project": "my-project-name",
                "max_job_execution_lifetime": "100s",
                "kms_key": "234jn2kjn42k3n423",
            },
            spark={
                "python_script_file": "gs://dataproc-examples/pyspark/hello-world/hello-world.py",
            },
            project="my-project-name")
        ```
        ### Dataplex Task Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # VPC network
        default = gcp.compute.Network("default",
            name="tf-test-workstation-cluster_27169",
            auto_create_subnetworks=True)
        project = gcp.organizations.get_project()
        example_spark = gcp.dataplex.Lake("example_spark",
            name="tf-test-lake_75223",
            location="us-central1",
            project="my-project-name")
        example_spark_task = gcp.dataplex.Task("example_spark",
            task_id="tf-test-task_41819",
            location="us-central1",
            lake=example_spark.name,
            trigger_spec={
                "type": "ON_DEMAND",
            },
            description="task-spark-terraform",
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "args": {
                    "TASK_ARGS": "--output_location,gs://spark-job/task-result, --output_format, json",
                },
            },
            spark={
                "infrastructure_spec": {
                    "batch": {
                        "executors_count": 2,
                        "max_executors_count": 100,
                    },
                    "container_image": {
                        "image": "test-image",
                        "java_jars": ["test-java-jars.jar"],
                        "python_packages": ["gs://bucket-name/my/path/to/lib.tar.gz"],
                        "properties": {
                            "name": "wrench",
                            "mass": "1.3kg",
                            "count": "3",
                        },
                    },
                    "vpc_network": {
                        "network_tags": ["test-network-tag"],
                        "sub_network": default.id,
                    },
                },
                "file_uris": ["gs://terrafrom-test/test.csv"],
                "archive_uris": ["gs://terraform-test/test.csv"],
                "sql_script": "show databases",
            },
            project="my-project-name")
        ```
        ### Dataplex Task Notebook

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # VPC network
        default = gcp.compute.Network("default",
            name="tf-test-workstation-cluster_75092",
            auto_create_subnetworks=True)
        project = gcp.organizations.get_project()
        example_notebook = gcp.dataplex.Lake("example_notebook",
            name="tf-test-lake_2605",
            location="us-central1",
            project="my-project-name")
        example_notebook_task = gcp.dataplex.Task("example_notebook",
            task_id="tf-test-task_34535",
            location="us-central1",
            lake=example_notebook.name,
            trigger_spec={
                "type": "RECURRING",
                "schedule": "1 * * * *",
            },
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "args": {
                    "TASK_ARGS": "--output_location,gs://spark-job-jars-anrajitha/task-result, --output_format, json",
                },
            },
            notebook={
                "notebook": "gs://terraform-test/test-notebook.ipynb",
                "infrastructure_spec": {
                    "batch": {
                        "executors_count": 2,
                        "max_executors_count": 100,
                    },
                    "container_image": {
                        "image": "test-image",
                        "java_jars": ["test-java-jars.jar"],
                        "python_packages": ["gs://bucket-name/my/path/to/lib.tar.gz"],
                        "properties": {
                            "name": "wrench",
                            "mass": "1.3kg",
                            "count": "3",
                        },
                    },
                    "vpc_network": {
                        "network_tags": ["test-network-tag"],
                        "network": default.id,
                    },
                },
                "file_uris": ["gs://terraform-test/test.csv"],
                "archive_uris": ["gs://terraform-test/test.csv"],
            },
            project="my-project-name")
        ```

        ## Import

        Task can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/lakes/{{lake}}/tasks/{{task_id}}`

        * `{{project}}/{{location}}/{{lake}}/{{task_id}}`

        * `{{location}}/{{lake}}/{{task_id}}`

        When using the `pulumi import` command, Task can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/task:Task default projects/{{project}}/locations/{{location}}/lakes/{{lake}}/tasks/{{task_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/task:Task default {{project}}/{{location}}/{{lake}}/{{task_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/task:Task default {{location}}/{{lake}}/{{task_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: User-provided description of the task.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Union['TaskExecutionSpecArgs', 'TaskExecutionSpecArgsDict']] execution_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the task.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lake: The lake in which the task will be created in.
        :param pulumi.Input[builtins.str] location: The location in which the task will be created in.
        :param pulumi.Input[Union['TaskNotebookArgs', 'TaskNotebookArgsDict']] notebook: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['TaskSparkArgs', 'TaskSparkArgsDict']] spark: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] task_id: The task Id of the task.
        :param pulumi.Input[Union['TaskTriggerSpecArgs', 'TaskTriggerSpecArgsDict']] trigger_spec: Configuration for the cluster
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Dataplex task represents the work that you want Dataplex to do on a schedule. It encapsulates code, parameters, and the schedule.

        To get more information about Task, see:

        * [API documentation](https://cloud.google.com/dataplex/docs/reference/rest/v1/projects.locations.lakes.tasks)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/dataplex/docs)

        ## Example Usage

        ### Dataplex Task Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        example = gcp.dataplex.Lake("example",
            name="tf-test-lake_8493",
            location="us-central1",
            project="my-project-name")
        example_task = gcp.dataplex.Task("example",
            task_id="tf-test-task_9106",
            location="us-central1",
            lake=example.name,
            description="Test Task Basic",
            display_name="task-basic",
            labels={
                "count": "3",
            },
            trigger_spec={
                "type": "RECURRING",
                "disabled": False,
                "max_retries": 3,
                "start_time": "2023-10-02T15:01:23Z",
                "schedule": "1 * * * *",
            },
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "project": "my-project-name",
                "max_job_execution_lifetime": "100s",
                "kms_key": "234jn2kjn42k3n423",
            },
            spark={
                "python_script_file": "gs://dataproc-examples/pyspark/hello-world/hello-world.py",
            },
            project="my-project-name")
        ```
        ### Dataplex Task Spark

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # VPC network
        default = gcp.compute.Network("default",
            name="tf-test-workstation-cluster_27169",
            auto_create_subnetworks=True)
        project = gcp.organizations.get_project()
        example_spark = gcp.dataplex.Lake("example_spark",
            name="tf-test-lake_75223",
            location="us-central1",
            project="my-project-name")
        example_spark_task = gcp.dataplex.Task("example_spark",
            task_id="tf-test-task_41819",
            location="us-central1",
            lake=example_spark.name,
            trigger_spec={
                "type": "ON_DEMAND",
            },
            description="task-spark-terraform",
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "args": {
                    "TASK_ARGS": "--output_location,gs://spark-job/task-result, --output_format, json",
                },
            },
            spark={
                "infrastructure_spec": {
                    "batch": {
                        "executors_count": 2,
                        "max_executors_count": 100,
                    },
                    "container_image": {
                        "image": "test-image",
                        "java_jars": ["test-java-jars.jar"],
                        "python_packages": ["gs://bucket-name/my/path/to/lib.tar.gz"],
                        "properties": {
                            "name": "wrench",
                            "mass": "1.3kg",
                            "count": "3",
                        },
                    },
                    "vpc_network": {
                        "network_tags": ["test-network-tag"],
                        "sub_network": default.id,
                    },
                },
                "file_uris": ["gs://terrafrom-test/test.csv"],
                "archive_uris": ["gs://terraform-test/test.csv"],
                "sql_script": "show databases",
            },
            project="my-project-name")
        ```
        ### Dataplex Task Notebook

        ```python
        import pulumi
        import pulumi_gcp as gcp

        # VPC network
        default = gcp.compute.Network("default",
            name="tf-test-workstation-cluster_75092",
            auto_create_subnetworks=True)
        project = gcp.organizations.get_project()
        example_notebook = gcp.dataplex.Lake("example_notebook",
            name="tf-test-lake_2605",
            location="us-central1",
            project="my-project-name")
        example_notebook_task = gcp.dataplex.Task("example_notebook",
            task_id="tf-test-task_34535",
            location="us-central1",
            lake=example_notebook.name,
            trigger_spec={
                "type": "RECURRING",
                "schedule": "1 * * * *",
            },
            execution_spec={
                "service_account": f"{project.number}-compute@developer.gserviceaccount.com",
                "args": {
                    "TASK_ARGS": "--output_location,gs://spark-job-jars-anrajitha/task-result, --output_format, json",
                },
            },
            notebook={
                "notebook": "gs://terraform-test/test-notebook.ipynb",
                "infrastructure_spec": {
                    "batch": {
                        "executors_count": 2,
                        "max_executors_count": 100,
                    },
                    "container_image": {
                        "image": "test-image",
                        "java_jars": ["test-java-jars.jar"],
                        "python_packages": ["gs://bucket-name/my/path/to/lib.tar.gz"],
                        "properties": {
                            "name": "wrench",
                            "mass": "1.3kg",
                            "count": "3",
                        },
                    },
                    "vpc_network": {
                        "network_tags": ["test-network-tag"],
                        "network": default.id,
                    },
                },
                "file_uris": ["gs://terraform-test/test.csv"],
                "archive_uris": ["gs://terraform-test/test.csv"],
            },
            project="my-project-name")
        ```

        ## Import

        Task can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/lakes/{{lake}}/tasks/{{task_id}}`

        * `{{project}}/{{location}}/{{lake}}/{{task_id}}`

        * `{{location}}/{{lake}}/{{task_id}}`

        When using the `pulumi import` command, Task can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:dataplex/task:Task default projects/{{project}}/locations/{{location}}/lakes/{{lake}}/tasks/{{task_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/task:Task default {{project}}/{{location}}/{{lake}}/{{task_id}}
        ```

        ```sh
        $ pulumi import gcp:dataplex/task:Task default {{location}}/{{lake}}/{{task_id}}
        ```

        :param str resource_name: The name of the resource.
        :param TaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 execution_spec: Optional[pulumi.Input[Union['TaskExecutionSpecArgs', 'TaskExecutionSpecArgsDict']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lake: Optional[pulumi.Input[builtins.str]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 notebook: Optional[pulumi.Input[Union['TaskNotebookArgs', 'TaskNotebookArgsDict']]] = None,
                 project: Optional[pulumi.Input[builtins.str]] = None,
                 spark: Optional[pulumi.Input[Union['TaskSparkArgs', 'TaskSparkArgsDict']]] = None,
                 task_id: Optional[pulumi.Input[builtins.str]] = None,
                 trigger_spec: Optional[pulumi.Input[Union['TaskTriggerSpecArgs', 'TaskTriggerSpecArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TaskArgs.__new__(TaskArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if execution_spec is None and not opts.urn:
                raise TypeError("Missing required property 'execution_spec'")
            __props__.__dict__["execution_spec"] = execution_spec
            __props__.__dict__["labels"] = labels
            __props__.__dict__["lake"] = lake
            __props__.__dict__["location"] = location
            __props__.__dict__["notebook"] = notebook
            __props__.__dict__["project"] = project
            __props__.__dict__["spark"] = spark
            __props__.__dict__["task_id"] = task_id
            if trigger_spec is None and not opts.urn:
                raise TypeError("Missing required property 'trigger_spec'")
            __props__.__dict__["trigger_spec"] = trigger_spec
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["execution_statuses"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Task, __self__).__init__(
            'gcp:dataplex/task:Task',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            execution_spec: Optional[pulumi.Input[Union['TaskExecutionSpecArgs', 'TaskExecutionSpecArgsDict']]] = None,
            execution_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TaskExecutionStatusArgs', 'TaskExecutionStatusArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lake: Optional[pulumi.Input[builtins.str]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            notebook: Optional[pulumi.Input[Union['TaskNotebookArgs', 'TaskNotebookArgsDict']]] = None,
            project: Optional[pulumi.Input[builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            spark: Optional[pulumi.Input[Union['TaskSparkArgs', 'TaskSparkArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            task_id: Optional[pulumi.Input[builtins.str]] = None,
            trigger_spec: Optional[pulumi.Input[Union['TaskTriggerSpecArgs', 'TaskTriggerSpecArgsDict']]] = None,
            uid: Optional[pulumi.Input[builtins.str]] = None,
            update_time: Optional[pulumi.Input[builtins.str]] = None) -> 'Task':
        """
        Get an existing Task resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] create_time: The time when the task was created.
        :param pulumi.Input[builtins.str] description: User-provided description of the task.
        :param pulumi.Input[builtins.str] display_name: User friendly display name.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Union['TaskExecutionSpecArgs', 'TaskExecutionSpecArgsDict']] execution_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TaskExecutionStatusArgs', 'TaskExecutionStatusArgsDict']]]] execution_statuses: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: User-defined labels for the task.
               
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[builtins.str] lake: The lake in which the task will be created in.
        :param pulumi.Input[builtins.str] location: The location in which the task will be created in.
        :param pulumi.Input[builtins.str] name: (Output)
               The relative resource name of the job, of the form: projects/{project_number}/locations/{locationId}/lakes/{lakeId}/tasks/{taskId}/jobs/{jobId}.
        :param pulumi.Input[Union['TaskNotebookArgs', 'TaskNotebookArgsDict']] notebook: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Union['TaskSparkArgs', 'TaskSparkArgsDict']] spark: A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
               Structure is documented below.
        :param pulumi.Input[builtins.str] state: (Output)
               Execution state for the job.
        :param pulumi.Input[builtins.str] task_id: The task Id of the task.
        :param pulumi.Input[Union['TaskTriggerSpecArgs', 'TaskTriggerSpecArgsDict']] trigger_spec: Configuration for the cluster
               Structure is documented below.
        :param pulumi.Input[builtins.str] uid: (Output)
               System generated globally unique ID for the job.
        :param pulumi.Input[builtins.str] update_time: (Output)
               Last update time of the status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TaskState.__new__(_TaskState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["execution_spec"] = execution_spec
        __props__.__dict__["execution_statuses"] = execution_statuses
        __props__.__dict__["labels"] = labels
        __props__.__dict__["lake"] = lake
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notebook"] = notebook
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["spark"] = spark
        __props__.__dict__["state"] = state
        __props__.__dict__["task_id"] = task_id
        __props__.__dict__["trigger_spec"] = trigger_spec
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return Task(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[builtins.str]:
        """
        The time when the task was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User-provided description of the task.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        User friendly display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @property
    @pulumi.getter(name="executionSpec")
    def execution_spec(self) -> pulumi.Output['outputs.TaskExecutionSpec']:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "execution_spec")

    @property
    @pulumi.getter(name="executionStatuses")
    def execution_statuses(self) -> pulumi.Output[Sequence['outputs.TaskExecutionStatus']]:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "execution_statuses")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        User-defined labels for the task.

        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def lake(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The lake in which the task will be created in.
        """
        return pulumi.get(self, "lake")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The location in which the task will be created in.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        The relative resource name of the job, of the form: projects/{project_number}/locations/{locationId}/lakes/{lakeId}/tasks/{taskId}/jobs/{jobId}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notebook(self) -> pulumi.Output[Optional['outputs.TaskNotebook']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "notebook")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @property
    @pulumi.getter
    def spark(self) -> pulumi.Output[Optional['outputs.TaskSpark']]:
        """
        A service with manual scaling runs continuously, allowing you to perform complex initialization and rely on the state of its memory over time.
        Structure is documented below.
        """
        return pulumi.get(self, "spark")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        Execution state for the job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="taskId")
    def task_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The task Id of the task.
        """
        return pulumi.get(self, "task_id")

    @property
    @pulumi.getter(name="triggerSpec")
    def trigger_spec(self) -> pulumi.Output['outputs.TaskTriggerSpec']:
        """
        Configuration for the cluster
        Structure is documented below.
        """
        return pulumi.get(self, "trigger_spec")

    @property
    @pulumi.getter
    def uid(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        System generated globally unique ID for the job.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[builtins.str]:
        """
        (Output)
        Last update time of the status.
        """
        return pulumi.get(self, "update_time")

